/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * Type of a load balancer. For more information, see [Summary of Google Cloud
 * load
 * balancers](https://cloud.google.com/load-balancing/docs/load-balancing-overview#summary-of-google-cloud-load-balancers).
 * </pre>
 *
 * Protobuf enum {@code google.cloud.networkmanagement.v1.LoadBalancerType}
 */
public enum LoadBalancerType implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Forwarding rule points to a different target than a load balancer or a
   * load balancer type is unknown.
   * </pre>
   *
   * <code>LOAD_BALANCER_TYPE_UNSPECIFIED = 0;</code>
   */
  LOAD_BALANCER_TYPE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Global external HTTP(S) load balancer.
   * </pre>
   *
   * <code>HTTPS_ADVANCED_LOAD_BALANCER = 1;</code>
   */
  HTTPS_ADVANCED_LOAD_BALANCER(1),
  /**
   *
   *
   * <pre>
   * Global external HTTP(S) load balancer (classic)
   * </pre>
   *
   * <code>HTTPS_LOAD_BALANCER = 2;</code>
   */
  HTTPS_LOAD_BALANCER(2),
  /**
   *
   *
   * <pre>
   * Regional external HTTP(S) load balancer.
   * </pre>
   *
   * <code>REGIONAL_HTTPS_LOAD_BALANCER = 3;</code>
   */
  REGIONAL_HTTPS_LOAD_BALANCER(3),
  /**
   *
   *
   * <pre>
   * Internal HTTP(S) load balancer.
   * </pre>
   *
   * <code>INTERNAL_HTTPS_LOAD_BALANCER = 4;</code>
   */
  INTERNAL_HTTPS_LOAD_BALANCER(4),
  /**
   *
   *
   * <pre>
   * External SSL proxy load balancer.
   * </pre>
   *
   * <code>SSL_PROXY_LOAD_BALANCER = 5;</code>
   */
  SSL_PROXY_LOAD_BALANCER(5),
  /**
   *
   *
   * <pre>
   * External TCP proxy load balancer.
   * </pre>
   *
   * <code>TCP_PROXY_LOAD_BALANCER = 6;</code>
   */
  TCP_PROXY_LOAD_BALANCER(6),
  /**
   *
   *
   * <pre>
   * Internal regional TCP proxy load balancer.
   * </pre>
   *
   * <code>INTERNAL_TCP_PROXY_LOAD_BALANCER = 7;</code>
   */
  INTERNAL_TCP_PROXY_LOAD_BALANCER(7),
  /**
   *
   *
   * <pre>
   * External TCP/UDP Network load balancer.
   * </pre>
   *
   * <code>NETWORK_LOAD_BALANCER = 8;</code>
   */
  NETWORK_LOAD_BALANCER(8),
  /**
   *
   *
   * <pre>
   * Target-pool based external TCP/UDP Network load balancer.
   * </pre>
   *
   * <code>LEGACY_NETWORK_LOAD_BALANCER = 9;</code>
   */
  LEGACY_NETWORK_LOAD_BALANCER(9),
  /**
   *
   *
   * <pre>
   * Internal TCP/UDP load balancer.
   * </pre>
   *
   * <code>TCP_UDP_INTERNAL_LOAD_BALANCER = 10;</code>
   */
  TCP_UDP_INTERNAL_LOAD_BALANCER(10),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Forwarding rule points to a different target than a load balancer or a
   * load balancer type is unknown.
   * </pre>
   *
   * <code>LOAD_BALANCER_TYPE_UNSPECIFIED = 0;</code>
   */
  public static final int LOAD_BALANCER_TYPE_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Global external HTTP(S) load balancer.
   * </pre>
   *
   * <code>HTTPS_ADVANCED_LOAD_BALANCER = 1;</code>
   */
  public static final int HTTPS_ADVANCED_LOAD_BALANCER_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Global external HTTP(S) load balancer (classic)
   * </pre>
   *
   * <code>HTTPS_LOAD_BALANCER = 2;</code>
   */
  public static final int HTTPS_LOAD_BALANCER_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Regional external HTTP(S) load balancer.
   * </pre>
   *
   * <code>REGIONAL_HTTPS_LOAD_BALANCER = 3;</code>
   */
  public static final int REGIONAL_HTTPS_LOAD_BALANCER_VALUE = 3;
  /**
   *
   *
   * <pre>
   * Internal HTTP(S) load balancer.
   * </pre>
   *
   * <code>INTERNAL_HTTPS_LOAD_BALANCER = 4;</code>
   */
  public static final int INTERNAL_HTTPS_LOAD_BALANCER_VALUE = 4;
  /**
   *
   *
   * <pre>
   * External SSL proxy load balancer.
   * </pre>
   *
   * <code>SSL_PROXY_LOAD_BALANCER = 5;</code>
   */
  public static final int SSL_PROXY_LOAD_BALANCER_VALUE = 5;
  /**
   *
   *
   * <pre>
   * External TCP proxy load balancer.
   * </pre>
   *
   * <code>TCP_PROXY_LOAD_BALANCER = 6;</code>
   */
  public static final int TCP_PROXY_LOAD_BALANCER_VALUE = 6;
  /**
   *
   *
   * <pre>
   * Internal regional TCP proxy load balancer.
   * </pre>
   *
   * <code>INTERNAL_TCP_PROXY_LOAD_BALANCER = 7;</code>
   */
  public static final int INTERNAL_TCP_PROXY_LOAD_BALANCER_VALUE = 7;
  /**
   *
   *
   * <pre>
   * External TCP/UDP Network load balancer.
   * </pre>
   *
   * <code>NETWORK_LOAD_BALANCER = 8;</code>
   */
  public static final int NETWORK_LOAD_BALANCER_VALUE = 8;
  /**
   *
   *
   * <pre>
   * Target-pool based external TCP/UDP Network load balancer.
   * </pre>
   *
   * <code>LEGACY_NETWORK_LOAD_BALANCER = 9;</code>
   */
  public static final int LEGACY_NETWORK_LOAD_BALANCER_VALUE = 9;
  /**
   *
   *
   * <pre>
   * Internal TCP/UDP load balancer.
   * </pre>
   *
   * <code>TCP_UDP_INTERNAL_LOAD_BALANCER = 10;</code>
   */
  public static final int TCP_UDP_INTERNAL_LOAD_BALANCER_VALUE = 10;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static LoadBalancerType valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static LoadBalancerType forNumber(int value) {
    switch (value) {
      case 0:
        return LOAD_BALANCER_TYPE_UNSPECIFIED;
      case 1:
        return HTTPS_ADVANCED_LOAD_BALANCER;
      case 2:
        return HTTPS_LOAD_BALANCER;
      case 3:
        return REGIONAL_HTTPS_LOAD_BALANCER;
      case 4:
        return INTERNAL_HTTPS_LOAD_BALANCER;
      case 5:
        return SSL_PROXY_LOAD_BALANCER;
      case 6:
        return TCP_PROXY_LOAD_BALANCER;
      case 7:
        return INTERNAL_TCP_PROXY_LOAD_BALANCER;
      case 8:
        return NETWORK_LOAD_BALANCER;
      case 9:
        return LEGACY_NETWORK_LOAD_BALANCER;
      case 10:
        return TCP_UDP_INTERNAL_LOAD_BALANCER;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<LoadBalancerType> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<LoadBalancerType> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<LoadBalancerType>() {
        public LoadBalancerType findValueByNumber(int number) {
          return LoadBalancerType.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final LoadBalancerType[] VALUES = values();

  public static LoadBalancerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private LoadBalancerType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.LoadBalancerType)
}
