/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a Compute Engine route.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.RouteInfo}
 */
public final class RouteInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.RouteInfo)
    RouteInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouteInfo.newBuilder() to construct.
  private RouteInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouteInfo() {
    routeType_ = 0;
    nextHopType_ = 0;
    routeScope_ = 0;
    displayName_ = "";
    uri_ = "";
    destIpRange_ = "";
    nextHop_ = "";
    networkUri_ = "";
    instanceTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    srcIpRange_ = "";
    destPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    srcPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    protocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
    nccHubUri_ = "";
    nccSpokeUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouteInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_RouteInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_RouteInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.RouteInfo.class,
            com.google.cloud.networkmanagement.v1.RouteInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of route:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.RouteInfo.RouteType}
   */
  public enum RouteType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>ROUTE_TYPE_UNSPECIFIED = 0;</code>
     */
    ROUTE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Route is a subnet route automatically created by the system.
     * </pre>
     *
     * <code>SUBNET = 1;</code>
     */
    SUBNET(1),
    /**
     *
     *
     * <pre>
     * Static route created by the user, including the default route to the
     * internet.
     * </pre>
     *
     * <code>STATIC = 2;</code>
     */
    STATIC(2),
    /**
     *
     *
     * <pre>
     * Dynamic route exchanged between BGP peers.
     * </pre>
     *
     * <code>DYNAMIC = 3;</code>
     */
    DYNAMIC(3),
    /**
     *
     *
     * <pre>
     * A subnet route received from peering network.
     * </pre>
     *
     * <code>PEERING_SUBNET = 4;</code>
     */
    PEERING_SUBNET(4),
    /**
     *
     *
     * <pre>
     * A static route received from peering network.
     * </pre>
     *
     * <code>PEERING_STATIC = 5;</code>
     */
    PEERING_STATIC(5),
    /**
     *
     *
     * <pre>
     * A dynamic route received from peering network.
     * </pre>
     *
     * <code>PEERING_DYNAMIC = 6;</code>
     */
    PEERING_DYNAMIC(6),
    /**
     *
     *
     * <pre>
     * Policy based route.
     * </pre>
     *
     * <code>POLICY_BASED = 7;</code>
     */
    POLICY_BASED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>ROUTE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ROUTE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Route is a subnet route automatically created by the system.
     * </pre>
     *
     * <code>SUBNET = 1;</code>
     */
    public static final int SUBNET_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Static route created by the user, including the default route to the
     * internet.
     * </pre>
     *
     * <code>STATIC = 2;</code>
     */
    public static final int STATIC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Dynamic route exchanged between BGP peers.
     * </pre>
     *
     * <code>DYNAMIC = 3;</code>
     */
    public static final int DYNAMIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A subnet route received from peering network.
     * </pre>
     *
     * <code>PEERING_SUBNET = 4;</code>
     */
    public static final int PEERING_SUBNET_VALUE = 4;
    /**
     *
     *
     * <pre>
     * A static route received from peering network.
     * </pre>
     *
     * <code>PEERING_STATIC = 5;</code>
     */
    public static final int PEERING_STATIC_VALUE = 5;
    /**
     *
     *
     * <pre>
     * A dynamic route received from peering network.
     * </pre>
     *
     * <code>PEERING_DYNAMIC = 6;</code>
     */
    public static final int PEERING_DYNAMIC_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Policy based route.
     * </pre>
     *
     * <code>POLICY_BASED = 7;</code>
     */
    public static final int POLICY_BASED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RouteType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RouteType forNumber(int value) {
      switch (value) {
        case 0:
          return ROUTE_TYPE_UNSPECIFIED;
        case 1:
          return SUBNET;
        case 2:
          return STATIC;
        case 3:
          return DYNAMIC;
        case 4:
          return PEERING_SUBNET;
        case 5:
          return PEERING_STATIC;
        case 6:
          return PEERING_DYNAMIC;
        case 7:
          return POLICY_BASED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RouteType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RouteType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RouteType>() {
          public RouteType findValueByNumber(int number) {
            return RouteType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.RouteInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final RouteType[] VALUES = values();

    public static RouteType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RouteType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.RouteInfo.RouteType)
  }

  /**
   *
   *
   * <pre>
   * Type of next hop:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.RouteInfo.NextHopType}
   */
  public enum NextHopType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>NEXT_HOP_TYPE_UNSPECIFIED = 0;</code>
     */
    NEXT_HOP_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Next hop is an IP address.
     * </pre>
     *
     * <code>NEXT_HOP_IP = 1;</code>
     */
    NEXT_HOP_IP(1),
    /**
     *
     *
     * <pre>
     * Next hop is a Compute Engine instance.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE = 2;</code>
     */
    NEXT_HOP_INSTANCE(2),
    /**
     *
     *
     * <pre>
     * Next hop is a VPC network gateway.
     * </pre>
     *
     * <code>NEXT_HOP_NETWORK = 3;</code>
     */
    NEXT_HOP_NETWORK(3),
    /**
     *
     *
     * <pre>
     * Next hop is a peering VPC.
     * </pre>
     *
     * <code>NEXT_HOP_PEERING = 4;</code>
     */
    NEXT_HOP_PEERING(4),
    /**
     *
     *
     * <pre>
     * Next hop is an interconnect.
     * </pre>
     *
     * <code>NEXT_HOP_INTERCONNECT = 5;</code>
     */
    NEXT_HOP_INTERCONNECT(5),
    /**
     *
     *
     * <pre>
     * Next hop is a VPN tunnel.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_TUNNEL = 6;</code>
     */
    NEXT_HOP_VPN_TUNNEL(6),
    /**
     *
     *
     * <pre>
     * Next hop is a VPN gateway. This scenario only happens when tracing
     * connectivity from an on-premises network to Google Cloud through a VPN.
     * The analysis simulates a packet departing from the on-premises network
     * through a VPN tunnel and arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_GATEWAY = 7;</code>
     */
    NEXT_HOP_VPN_GATEWAY(7),
    /**
     *
     *
     * <pre>
     * Next hop is an internet gateway.
     * </pre>
     *
     * <code>NEXT_HOP_INTERNET_GATEWAY = 8;</code>
     */
    NEXT_HOP_INTERNET_GATEWAY(8),
    /**
     *
     *
     * <pre>
     * Next hop is blackhole; that is, the next hop either does not exist or is
     * not running.
     * </pre>
     *
     * <code>NEXT_HOP_BLACKHOLE = 9;</code>
     */
    NEXT_HOP_BLACKHOLE(9),
    /**
     *
     *
     * <pre>
     * Next hop is the forwarding rule of an Internal Load Balancer.
     * </pre>
     *
     * <code>NEXT_HOP_ILB = 10;</code>
     */
    NEXT_HOP_ILB(10),
    /**
     *
     *
     * <pre>
     * Next hop is a
     * [router appliance
     * instance](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/ra-overview).
     * </pre>
     *
     * <code>NEXT_HOP_ROUTER_APPLIANCE = 11;</code>
     */
    NEXT_HOP_ROUTER_APPLIANCE(11),
    /**
     *
     *
     * <pre>
     * Next hop is an NCC hub.
     * </pre>
     *
     * <code>NEXT_HOP_NCC_HUB = 12;</code>
     */
    NEXT_HOP_NCC_HUB(12),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>NEXT_HOP_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int NEXT_HOP_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Next hop is an IP address.
     * </pre>
     *
     * <code>NEXT_HOP_IP = 1;</code>
     */
    public static final int NEXT_HOP_IP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Next hop is a Compute Engine instance.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE = 2;</code>
     */
    public static final int NEXT_HOP_INSTANCE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Next hop is a VPC network gateway.
     * </pre>
     *
     * <code>NEXT_HOP_NETWORK = 3;</code>
     */
    public static final int NEXT_HOP_NETWORK_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Next hop is a peering VPC.
     * </pre>
     *
     * <code>NEXT_HOP_PEERING = 4;</code>
     */
    public static final int NEXT_HOP_PEERING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Next hop is an interconnect.
     * </pre>
     *
     * <code>NEXT_HOP_INTERCONNECT = 5;</code>
     */
    public static final int NEXT_HOP_INTERCONNECT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Next hop is a VPN tunnel.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_TUNNEL = 6;</code>
     */
    public static final int NEXT_HOP_VPN_TUNNEL_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Next hop is a VPN gateway. This scenario only happens when tracing
     * connectivity from an on-premises network to Google Cloud through a VPN.
     * The analysis simulates a packet departing from the on-premises network
     * through a VPN tunnel and arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_GATEWAY = 7;</code>
     */
    public static final int NEXT_HOP_VPN_GATEWAY_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Next hop is an internet gateway.
     * </pre>
     *
     * <code>NEXT_HOP_INTERNET_GATEWAY = 8;</code>
     */
    public static final int NEXT_HOP_INTERNET_GATEWAY_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Next hop is blackhole; that is, the next hop either does not exist or is
     * not running.
     * </pre>
     *
     * <code>NEXT_HOP_BLACKHOLE = 9;</code>
     */
    public static final int NEXT_HOP_BLACKHOLE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Next hop is the forwarding rule of an Internal Load Balancer.
     * </pre>
     *
     * <code>NEXT_HOP_ILB = 10;</code>
     */
    public static final int NEXT_HOP_ILB_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Next hop is a
     * [router appliance
     * instance](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/ra-overview).
     * </pre>
     *
     * <code>NEXT_HOP_ROUTER_APPLIANCE = 11;</code>
     */
    public static final int NEXT_HOP_ROUTER_APPLIANCE_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Next hop is an NCC hub.
     * </pre>
     *
     * <code>NEXT_HOP_NCC_HUB = 12;</code>
     */
    public static final int NEXT_HOP_NCC_HUB_VALUE = 12;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NextHopType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NextHopType forNumber(int value) {
      switch (value) {
        case 0:
          return NEXT_HOP_TYPE_UNSPECIFIED;
        case 1:
          return NEXT_HOP_IP;
        case 2:
          return NEXT_HOP_INSTANCE;
        case 3:
          return NEXT_HOP_NETWORK;
        case 4:
          return NEXT_HOP_PEERING;
        case 5:
          return NEXT_HOP_INTERCONNECT;
        case 6:
          return NEXT_HOP_VPN_TUNNEL;
        case 7:
          return NEXT_HOP_VPN_GATEWAY;
        case 8:
          return NEXT_HOP_INTERNET_GATEWAY;
        case 9:
          return NEXT_HOP_BLACKHOLE;
        case 10:
          return NEXT_HOP_ILB;
        case 11:
          return NEXT_HOP_ROUTER_APPLIANCE;
        case 12:
          return NEXT_HOP_NCC_HUB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NextHopType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NextHopType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NextHopType>() {
          public NextHopType findValueByNumber(int number) {
            return NextHopType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.RouteInfo.getDescriptor().getEnumTypes().get(1);
    }

    private static final NextHopType[] VALUES = values();

    public static NextHopType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NextHopType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.RouteInfo.NextHopType)
  }

  /**
   *
   *
   * <pre>
   * Indicates where routes are applicable.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.RouteInfo.RouteScope}
   */
  public enum RouteScope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified scope. Default value.
     * </pre>
     *
     * <code>ROUTE_SCOPE_UNSPECIFIED = 0;</code>
     */
    ROUTE_SCOPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Route is applicable to packets in Network.
     * </pre>
     *
     * <code>NETWORK = 1;</code>
     */
    NETWORK(1),
    /**
     *
     *
     * <pre>
     * Route is applicable to packets using NCC Hub's routing table.
     * </pre>
     *
     * <code>NCC_HUB = 2;</code>
     */
    NCC_HUB(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified scope. Default value.
     * </pre>
     *
     * <code>ROUTE_SCOPE_UNSPECIFIED = 0;</code>
     */
    public static final int ROUTE_SCOPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Route is applicable to packets in Network.
     * </pre>
     *
     * <code>NETWORK = 1;</code>
     */
    public static final int NETWORK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Route is applicable to packets using NCC Hub's routing table.
     * </pre>
     *
     * <code>NCC_HUB = 2;</code>
     */
    public static final int NCC_HUB_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RouteScope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RouteScope forNumber(int value) {
      switch (value) {
        case 0:
          return ROUTE_SCOPE_UNSPECIFIED;
        case 1:
          return NETWORK;
        case 2:
          return NCC_HUB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RouteScope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RouteScope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RouteScope>() {
          public RouteScope findValueByNumber(int number) {
            return RouteScope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.RouteInfo.getDescriptor().getEnumTypes().get(2);
    }

    private static final RouteScope[] VALUES = values();

    public static RouteScope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RouteScope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.RouteInfo.RouteScope)
  }

  private int bitField0_;
  public static final int ROUTE_TYPE_FIELD_NUMBER = 8;
  private int routeType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
   *
   * @return The enum numeric value on the wire for routeType.
   */
  @java.lang.Override
  public int getRouteTypeValue() {
    return routeType_;
  }
  /**
   *
   *
   * <pre>
   * Type of route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
   *
   * @return The routeType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.RouteInfo.RouteType getRouteType() {
    com.google.cloud.networkmanagement.v1.RouteInfo.RouteType result =
        com.google.cloud.networkmanagement.v1.RouteInfo.RouteType.forNumber(routeType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.RouteInfo.RouteType.UNRECOGNIZED
        : result;
  }

  public static final int NEXT_HOP_TYPE_FIELD_NUMBER = 9;
  private int nextHopType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of next hop.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
   *
   * @return The enum numeric value on the wire for nextHopType.
   */
  @java.lang.Override
  public int getNextHopTypeValue() {
    return nextHopType_;
  }
  /**
   *
   *
   * <pre>
   * Type of next hop.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
   *
   * @return The nextHopType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType getNextHopType() {
    com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType result =
        com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType.forNumber(nextHopType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType.UNRECOGNIZED
        : result;
  }

  public static final int ROUTE_SCOPE_FIELD_NUMBER = 14;
  private int routeScope_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates where route is applicable.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
   *
   * @return The enum numeric value on the wire for routeScope.
   */
  @java.lang.Override
  public int getRouteScopeValue() {
    return routeScope_;
  }
  /**
   *
   *
   * <pre>
   * Indicates where route is applicable.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
   *
   * @return The routeScope.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope getRouteScope() {
    com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope result =
        com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope.forNumber(routeScope_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Name of a route.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a route.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a route.
   * Dynamic, peering static and peering dynamic routes do not have an URI.
   * Advertised route from Google Cloud VPC to on-premises network also does
   * not have an URI.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a route.
   * Dynamic, peering static and peering dynamic routes do not have an URI.
   * Advertised route from Google Cloud VPC to on-premises network also does
   * not have an URI.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEST_IP_RANGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Destination IP range of the route.
   * </pre>
   *
   * <code>string dest_ip_range = 3;</code>
   *
   * @return The destIpRange.
   */
  @java.lang.Override
  public java.lang.String getDestIpRange() {
    java.lang.Object ref = destIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP range of the route.
   * </pre>
   *
   * <code>string dest_ip_range = 3;</code>
   *
   * @return The bytes for destIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestIpRangeBytes() {
    java.lang.Object ref = destIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHop_ = "";
  /**
   *
   *
   * <pre>
   * Next hop of the route.
   * </pre>
   *
   * <code>string next_hop = 4;</code>
   *
   * @return The nextHop.
   */
  @java.lang.Override
  public java.lang.String getNextHop() {
    java.lang.Object ref = nextHop_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHop_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Next hop of the route.
   * </pre>
   *
   * <code>string next_hop = 4;</code>
   *
   * @return The bytes for nextHop.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopBytes() {
    java.lang.Object ref = nextHop_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHop_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network. NETWORK routes only.
   * </pre>
   *
   * <code>string network_uri = 5;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network. NETWORK routes only.
   * </pre>
   *
   * <code>string network_uri = 5;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIORITY_FIELD_NUMBER = 6;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * Priority of the route.
   * </pre>
   *
   * <code>int32 priority = 6;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int INSTANCE_TAGS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instanceTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @return A list containing the instanceTags.
   */
  public com.google.protobuf.ProtocolStringList getInstanceTagsList() {
    return instanceTags_;
  }
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @return The count of instanceTags.
   */
  public int getInstanceTagsCount() {
    return instanceTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The instanceTags at the given index.
   */
  public java.lang.String getInstanceTags(int index) {
    return instanceTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instanceTags at the given index.
   */
  public com.google.protobuf.ByteString getInstanceTagsBytes(int index) {
    return instanceTags_.getByteString(index);
  }

  public static final int SRC_IP_RANGE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object srcIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Source IP address range of the route. Policy based routes only.
   * </pre>
   *
   * <code>string src_ip_range = 10;</code>
   *
   * @return The srcIpRange.
   */
  @java.lang.Override
  public java.lang.String getSrcIpRange() {
    java.lang.Object ref = srcIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      srcIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source IP address range of the route. Policy based routes only.
   * </pre>
   *
   * <code>string src_ip_range = 10;</code>
   *
   * @return The bytes for srcIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSrcIpRangeBytes() {
    java.lang.Object ref = srcIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      srcIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEST_PORT_RANGES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList destPortRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Destination port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string dest_port_ranges = 11;</code>
   *
   * @return A list containing the destPortRanges.
   */
  public com.google.protobuf.ProtocolStringList getDestPortRangesList() {
    return destPortRanges_;
  }
  /**
   *
   *
   * <pre>
   * Destination port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string dest_port_ranges = 11;</code>
   *
   * @return The count of destPortRanges.
   */
  public int getDestPortRangesCount() {
    return destPortRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Destination port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string dest_port_ranges = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The destPortRanges at the given index.
   */
  public java.lang.String getDestPortRanges(int index) {
    return destPortRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Destination port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string dest_port_ranges = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the destPortRanges at the given index.
   */
  public com.google.protobuf.ByteString getDestPortRangesBytes(int index) {
    return destPortRanges_.getByteString(index);
  }

  public static final int SRC_PORT_RANGES_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList srcPortRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Source port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string src_port_ranges = 12;</code>
   *
   * @return A list containing the srcPortRanges.
   */
  public com.google.protobuf.ProtocolStringList getSrcPortRangesList() {
    return srcPortRanges_;
  }
  /**
   *
   *
   * <pre>
   * Source port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string src_port_ranges = 12;</code>
   *
   * @return The count of srcPortRanges.
   */
  public int getSrcPortRangesCount() {
    return srcPortRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Source port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string src_port_ranges = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The srcPortRanges at the given index.
   */
  public java.lang.String getSrcPortRanges(int index) {
    return srcPortRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Source port ranges of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string src_port_ranges = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the srcPortRanges at the given index.
   */
  public com.google.protobuf.ByteString getSrcPortRangesBytes(int index) {
    return srcPortRanges_.getByteString(index);
  }

  public static final int PROTOCOLS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList protocols_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Protocols of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string protocols = 13;</code>
   *
   * @return A list containing the protocols.
   */
  public com.google.protobuf.ProtocolStringList getProtocolsList() {
    return protocols_;
  }
  /**
   *
   *
   * <pre>
   * Protocols of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string protocols = 13;</code>
   *
   * @return The count of protocols.
   */
  public int getProtocolsCount() {
    return protocols_.size();
  }
  /**
   *
   *
   * <pre>
   * Protocols of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string protocols = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The protocols at the given index.
   */
  public java.lang.String getProtocols(int index) {
    return protocols_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Protocols of the route. Policy based routes only.
   * </pre>
   *
   * <code>repeated string protocols = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the protocols at the given index.
   */
  public com.google.protobuf.ByteString getProtocolsBytes(int index) {
    return protocols_.getByteString(index);
  }

  public static final int NCC_HUB_URI_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nccHubUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a NCC Hub. NCC_HUB routes only.
   * </pre>
   *
   * <code>optional string ncc_hub_uri = 15;</code>
   *
   * @return Whether the nccHubUri field is set.
   */
  @java.lang.Override
  public boolean hasNccHubUri() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * URI of a NCC Hub. NCC_HUB routes only.
   * </pre>
   *
   * <code>optional string ncc_hub_uri = 15;</code>
   *
   * @return The nccHubUri.
   */
  @java.lang.Override
  public java.lang.String getNccHubUri() {
    java.lang.Object ref = nccHubUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nccHubUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a NCC Hub. NCC_HUB routes only.
   * </pre>
   *
   * <code>optional string ncc_hub_uri = 15;</code>
   *
   * @return The bytes for nccHubUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNccHubUriBytes() {
    java.lang.Object ref = nccHubUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nccHubUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NCC_SPOKE_URI_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nccSpokeUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a NCC Spoke. NCC_HUB routes only.
   * </pre>
   *
   * <code>optional string ncc_spoke_uri = 16;</code>
   *
   * @return Whether the nccSpokeUri field is set.
   */
  @java.lang.Override
  public boolean hasNccSpokeUri() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * URI of a NCC Spoke. NCC_HUB routes only.
   * </pre>
   *
   * <code>optional string ncc_spoke_uri = 16;</code>
   *
   * @return The nccSpokeUri.
   */
  @java.lang.Override
  public java.lang.String getNccSpokeUri() {
    java.lang.Object ref = nccSpokeUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nccSpokeUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a NCC Spoke. NCC_HUB routes only.
   * </pre>
   *
   * <code>optional string ncc_spoke_uri = 16;</code>
   *
   * @return The bytes for nccSpokeUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNccSpokeUriBytes() {
    java.lang.Object ref = nccSpokeUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nccSpokeUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destIpRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextHop_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, nextHop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, networkUri_);
    }
    if (priority_ != 0) {
      output.writeInt32(6, priority_);
    }
    for (int i = 0; i < instanceTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, instanceTags_.getRaw(i));
    }
    if (routeType_
        != com.google.cloud.networkmanagement.v1.RouteInfo.RouteType.ROUTE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, routeType_);
    }
    if (nextHopType_
        != com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType.NEXT_HOP_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, nextHopType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(srcIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, srcIpRange_);
    }
    for (int i = 0; i < destPortRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, destPortRanges_.getRaw(i));
    }
    for (int i = 0; i < srcPortRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, srcPortRanges_.getRaw(i));
    }
    for (int i = 0; i < protocols_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, protocols_.getRaw(i));
    }
    if (routeScope_
        != com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope.ROUTE_SCOPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(14, routeScope_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, nccHubUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, nccSpokeUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destIpRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextHop_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, nextHop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, networkUri_);
    }
    if (priority_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, priority_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInstanceTagsList().size();
    }
    if (routeType_
        != com.google.cloud.networkmanagement.v1.RouteInfo.RouteType.ROUTE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, routeType_);
    }
    if (nextHopType_
        != com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType.NEXT_HOP_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, nextHopType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(srcIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, srcIpRange_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < destPortRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(destPortRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDestPortRangesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < srcPortRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(srcPortRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSrcPortRangesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < protocols_.size(); i++) {
        dataSize += computeStringSizeNoTag(protocols_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getProtocolsList().size();
    }
    if (routeScope_
        != com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope.ROUTE_SCOPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, routeScope_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, nccHubUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, nccSpokeUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.RouteInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.RouteInfo other =
        (com.google.cloud.networkmanagement.v1.RouteInfo) obj;

    if (routeType_ != other.routeType_) return false;
    if (nextHopType_ != other.nextHopType_) return false;
    if (routeScope_ != other.routeScope_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getDestIpRange().equals(other.getDestIpRange())) return false;
    if (!getNextHop().equals(other.getNextHop())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (getPriority() != other.getPriority()) return false;
    if (!getInstanceTagsList().equals(other.getInstanceTagsList())) return false;
    if (!getSrcIpRange().equals(other.getSrcIpRange())) return false;
    if (!getDestPortRangesList().equals(other.getDestPortRangesList())) return false;
    if (!getSrcPortRangesList().equals(other.getSrcPortRangesList())) return false;
    if (!getProtocolsList().equals(other.getProtocolsList())) return false;
    if (hasNccHubUri() != other.hasNccHubUri()) return false;
    if (hasNccHubUri()) {
      if (!getNccHubUri().equals(other.getNccHubUri())) return false;
    }
    if (hasNccSpokeUri() != other.hasNccSpokeUri()) return false;
    if (hasNccSpokeUri()) {
      if (!getNccSpokeUri().equals(other.getNccSpokeUri())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROUTE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + routeType_;
    hash = (37 * hash) + NEXT_HOP_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + nextHopType_;
    hash = (37 * hash) + ROUTE_SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + routeScope_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + DEST_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getDestIpRange().hashCode();
    hash = (37 * hash) + NEXT_HOP_FIELD_NUMBER;
    hash = (53 * hash) + getNextHop().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + getPriority();
    if (getInstanceTagsCount() > 0) {
      hash = (37 * hash) + INSTANCE_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceTagsList().hashCode();
    }
    hash = (37 * hash) + SRC_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getSrcIpRange().hashCode();
    if (getDestPortRangesCount() > 0) {
      hash = (37 * hash) + DEST_PORT_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDestPortRangesList().hashCode();
    }
    if (getSrcPortRangesCount() > 0) {
      hash = (37 * hash) + SRC_PORT_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSrcPortRangesList().hashCode();
    }
    if (getProtocolsCount() > 0) {
      hash = (37 * hash) + PROTOCOLS_FIELD_NUMBER;
      hash = (53 * hash) + getProtocolsList().hashCode();
    }
    if (hasNccHubUri()) {
      hash = (37 * hash) + NCC_HUB_URI_FIELD_NUMBER;
      hash = (53 * hash) + getNccHubUri().hashCode();
    }
    if (hasNccSpokeUri()) {
      hash = (37 * hash) + NCC_SPOKE_URI_FIELD_NUMBER;
      hash = (53 * hash) + getNccSpokeUri().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.RouteInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a Compute Engine route.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.RouteInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.RouteInfo)
      com.google.cloud.networkmanagement.v1.RouteInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_RouteInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_RouteInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.RouteInfo.class,
              com.google.cloud.networkmanagement.v1.RouteInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.RouteInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      routeType_ = 0;
      nextHopType_ = 0;
      routeScope_ = 0;
      displayName_ = "";
      uri_ = "";
      destIpRange_ = "";
      nextHop_ = "";
      networkUri_ = "";
      priority_ = 0;
      instanceTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      srcIpRange_ = "";
      destPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      srcPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      protocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nccHubUri_ = "";
      nccSpokeUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_RouteInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo build() {
      com.google.cloud.networkmanagement.v1.RouteInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.RouteInfo result =
          new com.google.cloud.networkmanagement.v1.RouteInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.RouteInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.routeType_ = routeType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextHopType_ = nextHopType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.routeScope_ = routeScope_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.destIpRange_ = destIpRange_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.nextHop_ = nextHop_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.networkUri_ = networkUri_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.priority_ = priority_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        instanceTags_.makeImmutable();
        result.instanceTags_ = instanceTags_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.srcIpRange_ = srcIpRange_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        destPortRanges_.makeImmutable();
        result.destPortRanges_ = destPortRanges_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        srcPortRanges_.makeImmutable();
        result.srcPortRanges_ = srcPortRanges_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        protocols_.makeImmutable();
        result.protocols_ = protocols_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.nccHubUri_ = nccHubUri_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.nccSpokeUri_ = nccSpokeUri_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.RouteInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.RouteInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.RouteInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance())
        return this;
      if (other.routeType_ != 0) {
        setRouteTypeValue(other.getRouteTypeValue());
      }
      if (other.nextHopType_ != 0) {
        setNextHopTypeValue(other.getNextHopTypeValue());
      }
      if (other.routeScope_ != 0) {
        setRouteScopeValue(other.getRouteScopeValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDestIpRange().isEmpty()) {
        destIpRange_ = other.destIpRange_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getNextHop().isEmpty()) {
        nextHop_ = other.nextHop_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getPriority() != 0) {
        setPriority(other.getPriority());
      }
      if (!other.instanceTags_.isEmpty()) {
        if (instanceTags_.isEmpty()) {
          instanceTags_ = other.instanceTags_;
          bitField0_ |= 0x00000200;
        } else {
          ensureInstanceTagsIsMutable();
          instanceTags_.addAll(other.instanceTags_);
        }
        onChanged();
      }
      if (!other.getSrcIpRange().isEmpty()) {
        srcIpRange_ = other.srcIpRange_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.destPortRanges_.isEmpty()) {
        if (destPortRanges_.isEmpty()) {
          destPortRanges_ = other.destPortRanges_;
          bitField0_ |= 0x00000800;
        } else {
          ensureDestPortRangesIsMutable();
          destPortRanges_.addAll(other.destPortRanges_);
        }
        onChanged();
      }
      if (!other.srcPortRanges_.isEmpty()) {
        if (srcPortRanges_.isEmpty()) {
          srcPortRanges_ = other.srcPortRanges_;
          bitField0_ |= 0x00001000;
        } else {
          ensureSrcPortRangesIsMutable();
          srcPortRanges_.addAll(other.srcPortRanges_);
        }
        onChanged();
      }
      if (!other.protocols_.isEmpty()) {
        if (protocols_.isEmpty()) {
          protocols_ = other.protocols_;
          bitField0_ |= 0x00002000;
        } else {
          ensureProtocolsIsMutable();
          protocols_.addAll(other.protocols_);
        }
        onChanged();
      }
      if (other.hasNccHubUri()) {
        nccHubUri_ = other.nccHubUri_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasNccSpokeUri()) {
        nccSpokeUri_ = other.nccSpokeUri_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                destIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                nextHop_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 42:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 48:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 48
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceTagsIsMutable();
                instanceTags_.add(s);
                break;
              } // case 58
            case 64:
              {
                routeType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 64
            case 72:
              {
                nextHopType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 72
            case 82:
              {
                srcIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestPortRangesIsMutable();
                destPortRanges_.add(s);
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSrcPortRangesIsMutable();
                srcPortRanges_.add(s);
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureProtocolsIsMutable();
                protocols_.add(s);
                break;
              } // case 106
            case 112:
              {
                routeScope_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 112
            case 122:
              {
                nccHubUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                nccSpokeUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int routeType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @return The enum numeric value on the wire for routeType.
     */
    @java.lang.Override
    public int getRouteTypeValue() {
      return routeType_;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @param value The enum numeric value on the wire for routeType to set.
     * @return This builder for chaining.
     */
    public Builder setRouteTypeValue(int value) {
      routeType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @return The routeType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo.RouteType getRouteType() {
      com.google.cloud.networkmanagement.v1.RouteInfo.RouteType result =
          com.google.cloud.networkmanagement.v1.RouteInfo.RouteType.forNumber(routeType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.RouteInfo.RouteType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @param value The routeType to set.
     * @return This builder for chaining.
     */
    public Builder setRouteType(com.google.cloud.networkmanagement.v1.RouteInfo.RouteType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      routeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      routeType_ = 0;
      onChanged();
      return this;
    }

    private int nextHopType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @return The enum numeric value on the wire for nextHopType.
     */
    @java.lang.Override
    public int getNextHopTypeValue() {
      return nextHopType_;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @param value The enum numeric value on the wire for nextHopType to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopTypeValue(int value) {
      nextHopType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @return The nextHopType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType getNextHopType() {
      com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType result =
          com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType.forNumber(nextHopType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @param value The nextHopType to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopType(
        com.google.cloud.networkmanagement.v1.RouteInfo.NextHopType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      nextHopType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      nextHopType_ = 0;
      onChanged();
      return this;
    }

    private int routeScope_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates where route is applicable.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
     *
     * @return The enum numeric value on the wire for routeScope.
     */
    @java.lang.Override
    public int getRouteScopeValue() {
      return routeScope_;
    }
    /**
     *
     *
     * <pre>
     * Indicates where route is applicable.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
     *
     * @param value The enum numeric value on the wire for routeScope to set.
     * @return This builder for chaining.
     */
    public Builder setRouteScopeValue(int value) {
      routeScope_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates where route is applicable.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
     *
     * @return The routeScope.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope getRouteScope() {
      com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope result =
          com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope.forNumber(routeScope_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates where route is applicable.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
     *
     * @param value The routeScope to set.
     * @return This builder for chaining.
     */
    public Builder setRouteScope(com.google.cloud.networkmanagement.v1.RouteInfo.RouteScope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      routeScope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates where route is applicable.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo.RouteScope route_scope = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteScope() {
      bitField0_ = (bitField0_ & ~0x00000004);
      routeScope_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name of a route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a route.
     * Dynamic, peering static and peering dynamic routes do not have an URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have an URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a route.
     * Dynamic, peering static and peering dynamic routes do not have an URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have an URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a route.
     * Dynamic, peering static and peering dynamic routes do not have an URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have an URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a route.
     * Dynamic, peering static and peering dynamic routes do not have an URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have an URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a route.
     * Dynamic, peering static and peering dynamic routes do not have an URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have an URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object destIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @return The destIpRange.
     */
    public java.lang.String getDestIpRange() {
      java.lang.Object ref = destIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @return The bytes for destIpRange.
     */
    public com.google.protobuf.ByteString getDestIpRangeBytes() {
      java.lang.Object ref = destIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @param value The destIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setDestIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destIpRange_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestIpRange() {
      destIpRange_ = getDefaultInstance().getDestIpRange();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @param value The bytes for destIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setDestIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destIpRange_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object nextHop_ = "";
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @return The nextHop.
     */
    public java.lang.String getNextHop() {
      java.lang.Object ref = nextHop_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHop_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @return The bytes for nextHop.
     */
    public com.google.protobuf.ByteString getNextHopBytes() {
      java.lang.Object ref = nextHop_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHop_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @param value The nextHop to set.
     * @return This builder for chaining.
     */
    public Builder setNextHop(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHop_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHop() {
      nextHop_ = getDefaultInstance().getNextHop();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @param value The bytes for nextHop to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHop_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network. NETWORK routes only.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network. NETWORK routes only.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network. NETWORK routes only.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network. NETWORK routes only.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network. NETWORK routes only.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * Priority of the route.
     * </pre>
     *
     * <code>int32 priority = 6;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * Priority of the route.
     * </pre>
     *
     * <code>int32 priority = 6;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Priority of the route.
     * </pre>
     *
     * <code>int32 priority = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000100);
      priority_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList instanceTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstanceTagsIsMutable() {
      if (!instanceTags_.isModifiable()) {
        instanceTags_ = new com.google.protobuf.LazyStringArrayList(instanceTags_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @return A list containing the instanceTags.
     */
    public com.google.protobuf.ProtocolStringList getInstanceTagsList() {
      instanceTags_.makeImmutable();
      return instanceTags_;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @return The count of instanceTags.
     */
    public int getInstanceTagsCount() {
      return instanceTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The instanceTags at the given index.
     */
    public java.lang.String getInstanceTags(int index) {
      return instanceTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instanceTags at the given index.
     */
    public com.google.protobuf.ByteString getInstanceTagsBytes(int index) {
      return instanceTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The instanceTags to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceTagsIsMutable();
      instanceTags_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param value The instanceTags to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceTagsIsMutable();
      instanceTags_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param values The instanceTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstanceTags(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceTags_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceTags() {
      instanceTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param value The bytes of the instanceTags to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceTagsIsMutable();
      instanceTags_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object srcIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Source IP address range of the route. Policy based routes only.
     * </pre>
     *
     * <code>string src_ip_range = 10;</code>
     *
     * @return The srcIpRange.
     */
    public java.lang.String getSrcIpRange() {
      java.lang.Object ref = srcIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        srcIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address range of the route. Policy based routes only.
     * </pre>
     *
     * <code>string src_ip_range = 10;</code>
     *
     * @return The bytes for srcIpRange.
     */
    public com.google.protobuf.ByteString getSrcIpRangeBytes() {
      java.lang.Object ref = srcIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        srcIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address range of the route. Policy based routes only.
     * </pre>
     *
     * <code>string src_ip_range = 10;</code>
     *
     * @param value The srcIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setSrcIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      srcIpRange_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address range of the route. Policy based routes only.
     * </pre>
     *
     * <code>string src_ip_range = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcIpRange() {
      srcIpRange_ = getDefaultInstance().getSrcIpRange();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address range of the route. Policy based routes only.
     * </pre>
     *
     * <code>string src_ip_range = 10;</code>
     *
     * @param value The bytes for srcIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setSrcIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      srcIpRange_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList destPortRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDestPortRangesIsMutable() {
      if (!destPortRanges_.isModifiable()) {
        destPortRanges_ = new com.google.protobuf.LazyStringArrayList(destPortRanges_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @return A list containing the destPortRanges.
     */
    public com.google.protobuf.ProtocolStringList getDestPortRangesList() {
      destPortRanges_.makeImmutable();
      return destPortRanges_;
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @return The count of destPortRanges.
     */
    public int getDestPortRangesCount() {
      return destPortRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The destPortRanges at the given index.
     */
    public java.lang.String getDestPortRanges(int index) {
      return destPortRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the destPortRanges at the given index.
     */
    public com.google.protobuf.ByteString getDestPortRangesBytes(int index) {
      return destPortRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The destPortRanges to set.
     * @return This builder for chaining.
     */
    public Builder setDestPortRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestPortRangesIsMutable();
      destPortRanges_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @param value The destPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestPortRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestPortRangesIsMutable();
      destPortRanges_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @param values The destPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllDestPortRanges(java.lang.Iterable<java.lang.String> values) {
      ensureDestPortRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destPortRanges_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestPortRanges() {
      destPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string dest_port_ranges = 11;</code>
     *
     * @param value The bytes of the destPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestPortRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDestPortRangesIsMutable();
      destPortRanges_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList srcPortRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSrcPortRangesIsMutable() {
      if (!srcPortRanges_.isModifiable()) {
        srcPortRanges_ = new com.google.protobuf.LazyStringArrayList(srcPortRanges_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @return A list containing the srcPortRanges.
     */
    public com.google.protobuf.ProtocolStringList getSrcPortRangesList() {
      srcPortRanges_.makeImmutable();
      return srcPortRanges_;
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @return The count of srcPortRanges.
     */
    public int getSrcPortRangesCount() {
      return srcPortRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @param index The index of the element to return.
     * @return The srcPortRanges at the given index.
     */
    public java.lang.String getSrcPortRanges(int index) {
      return srcPortRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the srcPortRanges at the given index.
     */
    public com.google.protobuf.ByteString getSrcPortRangesBytes(int index) {
      return srcPortRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @param index The index to set the value at.
     * @param value The srcPortRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSrcPortRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcPortRangesIsMutable();
      srcPortRanges_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @param value The srcPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSrcPortRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcPortRangesIsMutable();
      srcPortRanges_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @param values The srcPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSrcPortRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSrcPortRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcPortRanges_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcPortRanges() {
      srcPortRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port ranges of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string src_port_ranges = 12;</code>
     *
     * @param value The bytes of the srcPortRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSrcPortRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSrcPortRangesIsMutable();
      srcPortRanges_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList protocols_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureProtocolsIsMutable() {
      if (!protocols_.isModifiable()) {
        protocols_ = new com.google.protobuf.LazyStringArrayList(protocols_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @return A list containing the protocols.
     */
    public com.google.protobuf.ProtocolStringList getProtocolsList() {
      protocols_.makeImmutable();
      return protocols_;
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @return The count of protocols.
     */
    public int getProtocolsCount() {
      return protocols_.size();
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The protocols at the given index.
     */
    public java.lang.String getProtocols(int index) {
      return protocols_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the protocols at the given index.
     */
    public com.google.protobuf.ByteString getProtocolsBytes(int index) {
      return protocols_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The protocols to set.
     * @return This builder for chaining.
     */
    public Builder setProtocols(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProtocolsIsMutable();
      protocols_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @param value The protocols to add.
     * @return This builder for chaining.
     */
    public Builder addProtocols(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProtocolsIsMutable();
      protocols_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @param values The protocols to add.
     * @return This builder for chaining.
     */
    public Builder addAllProtocols(java.lang.Iterable<java.lang.String> values) {
      ensureProtocolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, protocols_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocols() {
      protocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols of the route. Policy based routes only.
     * </pre>
     *
     * <code>repeated string protocols = 13;</code>
     *
     * @param value The bytes of the protocols to add.
     * @return This builder for chaining.
     */
    public Builder addProtocolsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureProtocolsIsMutable();
      protocols_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object nccHubUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a NCC Hub. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_hub_uri = 15;</code>
     *
     * @return Whether the nccHubUri field is set.
     */
    public boolean hasNccHubUri() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Hub. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_hub_uri = 15;</code>
     *
     * @return The nccHubUri.
     */
    public java.lang.String getNccHubUri() {
      java.lang.Object ref = nccHubUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nccHubUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Hub. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_hub_uri = 15;</code>
     *
     * @return The bytes for nccHubUri.
     */
    public com.google.protobuf.ByteString getNccHubUriBytes() {
      java.lang.Object ref = nccHubUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nccHubUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Hub. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_hub_uri = 15;</code>
     *
     * @param value The nccHubUri to set.
     * @return This builder for chaining.
     */
    public Builder setNccHubUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nccHubUri_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Hub. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_hub_uri = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNccHubUri() {
      nccHubUri_ = getDefaultInstance().getNccHubUri();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Hub. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_hub_uri = 15;</code>
     *
     * @param value The bytes for nccHubUri to set.
     * @return This builder for chaining.
     */
    public Builder setNccHubUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nccHubUri_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object nccSpokeUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a NCC Spoke. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_spoke_uri = 16;</code>
     *
     * @return Whether the nccSpokeUri field is set.
     */
    public boolean hasNccSpokeUri() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Spoke. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_spoke_uri = 16;</code>
     *
     * @return The nccSpokeUri.
     */
    public java.lang.String getNccSpokeUri() {
      java.lang.Object ref = nccSpokeUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nccSpokeUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Spoke. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_spoke_uri = 16;</code>
     *
     * @return The bytes for nccSpokeUri.
     */
    public com.google.protobuf.ByteString getNccSpokeUriBytes() {
      java.lang.Object ref = nccSpokeUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nccSpokeUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Spoke. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_spoke_uri = 16;</code>
     *
     * @param value The nccSpokeUri to set.
     * @return This builder for chaining.
     */
    public Builder setNccSpokeUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nccSpokeUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Spoke. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_spoke_uri = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNccSpokeUri() {
      nccSpokeUri_ = getDefaultInstance().getNccSpokeUri();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a NCC Spoke. NCC_HUB routes only.
     * </pre>
     *
     * <code>optional string ncc_spoke_uri = 16;</code>
     *
     * @param value The bytes for nccSpokeUri to set.
     * @return This builder for chaining.
     */
    public Builder setNccSpokeUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nccSpokeUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.RouteInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.RouteInfo)
  private static final com.google.cloud.networkmanagement.v1.RouteInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.RouteInfo();
  }

  public static com.google.cloud.networkmanagement.v1.RouteInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouteInfo> PARSER =
      new com.google.protobuf.AbstractParser<RouteInfo>() {
        @java.lang.Override
        public RouteInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouteInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouteInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.RouteInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
