/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * Trace represents one simulated packet forwarding path.
 *
 *   * Each trace contains multiple ordered steps.
 *   * Each step is in a particular state with associated configuration.
 *   * State is categorized as final or non-final states.
 *   * Each final state has a reason associated.
 *   * Each trace must end with a final state (the last step).
 * ```
 *   |---------------------Trace----------------------|
 *   Step1(State) Step2(State) ---  StepN(State(final))
 * ```
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.Trace}
 */
public final class Trace extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.Trace)
    TraceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Trace.newBuilder() to construct.
  private Trace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Trace() {
    steps_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Trace();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_Trace_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_Trace_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.Trace.class,
            com.google.cloud.networkmanagement.v1.Trace.Builder.class);
  }

  public static final int ENDPOINT_INFO_FIELD_NUMBER = 1;
  private com.google.cloud.networkmanagement.v1.EndpointInfo endpointInfo_;
  /**
   *
   *
   * <pre>
   * Derived from the source and destination endpoints definition specified by
   * user request, and validated by the data plane model.
   * If there are multiple traces starting from different source locations, then
   * the endpoint_info may be different between traces.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
   *
   * @return Whether the endpointInfo field is set.
   */
  @java.lang.Override
  public boolean hasEndpointInfo() {
    return endpointInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Derived from the source and destination endpoints definition specified by
   * user request, and validated by the data plane model.
   * If there are multiple traces starting from different source locations, then
   * the endpoint_info may be different between traces.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
   *
   * @return The endpointInfo.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.EndpointInfo getEndpointInfo() {
    return endpointInfo_ == null
        ? com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance()
        : endpointInfo_;
  }
  /**
   *
   *
   * <pre>
   * Derived from the source and destination endpoints definition specified by
   * user request, and validated by the data plane model.
   * If there are multiple traces starting from different source locations, then
   * the endpoint_info may be different between traces.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder getEndpointInfoOrBuilder() {
    return endpointInfo_ == null
        ? com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance()
        : endpointInfo_;
  }

  public static final int STEPS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.networkmanagement.v1.Step> steps_;
  /**
   *
   *
   * <pre>
   * A trace of a test contains multiple steps from the initial state to the
   * final state (delivered, dropped, forwarded, or aborted).
   *
   * The steps are ordered by the processing sequence within the simulated
   * network state machine. It is critical to preserve the order of the steps
   * and avoid reordering or sorting them.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networkmanagement.v1.Step> getStepsList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * A trace of a test contains multiple steps from the initial state to the
   * final state (delivered, dropped, forwarded, or aborted).
   *
   * The steps are ordered by the processing sequence within the simulated
   * network state machine. It is critical to preserve the order of the steps
   * and avoid reordering or sorting them.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.networkmanagement.v1.StepOrBuilder>
      getStepsOrBuilderList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * A trace of a test contains multiple steps from the initial state to the
   * final state (delivered, dropped, forwarded, or aborted).
   *
   * The steps are ordered by the processing sequence within the simulated
   * network state machine. It is critical to preserve the order of the steps
   * and avoid reordering or sorting them.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
   */
  @java.lang.Override
  public int getStepsCount() {
    return steps_.size();
  }
  /**
   *
   *
   * <pre>
   * A trace of a test contains multiple steps from the initial state to the
   * final state (delivered, dropped, forwarded, or aborted).
   *
   * The steps are ordered by the processing sequence within the simulated
   * network state machine. It is critical to preserve the order of the steps
   * and avoid reordering or sorting them.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.Step getSteps(int index) {
    return steps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A trace of a test contains multiple steps from the initial state to the
   * final state (delivered, dropped, forwarded, or aborted).
   *
   * The steps are ordered by the processing sequence within the simulated
   * network state machine. It is critical to preserve the order of the steps
   * and avoid reordering or sorting them.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.StepOrBuilder getStepsOrBuilder(int index) {
    return steps_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (endpointInfo_ != null) {
      output.writeMessage(1, getEndpointInfo());
    }
    for (int i = 0; i < steps_.size(); i++) {
      output.writeMessage(2, steps_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (endpointInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEndpointInfo());
    }
    for (int i = 0; i < steps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, steps_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.Trace)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.Trace other =
        (com.google.cloud.networkmanagement.v1.Trace) obj;

    if (hasEndpointInfo() != other.hasEndpointInfo()) return false;
    if (hasEndpointInfo()) {
      if (!getEndpointInfo().equals(other.getEndpointInfo())) return false;
    }
    if (!getStepsList().equals(other.getStepsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEndpointInfo()) {
      hash = (37 * hash) + ENDPOINT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointInfo().hashCode();
    }
    if (getStepsCount() > 0) {
      hash = (37 * hash) + STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getStepsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.Trace parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.Trace prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Trace represents one simulated packet forwarding path.
   *
   *   * Each trace contains multiple ordered steps.
   *   * Each step is in a particular state with associated configuration.
   *   * State is categorized as final or non-final states.
   *   * Each final state has a reason associated.
   *   * Each trace must end with a final state (the last step).
   * ```
   *   |---------------------Trace----------------------|
   *   Step1(State) Step2(State) ---  StepN(State(final))
   * ```
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.Trace}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.Trace)
      com.google.cloud.networkmanagement.v1.TraceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_Trace_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_Trace_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.Trace.class,
              com.google.cloud.networkmanagement.v1.Trace.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.Trace.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      endpointInfo_ = null;
      if (endpointInfoBuilder_ != null) {
        endpointInfoBuilder_.dispose();
        endpointInfoBuilder_ = null;
      }
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
      } else {
        steps_ = null;
        stepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_Trace_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Trace getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.Trace.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Trace build() {
      com.google.cloud.networkmanagement.v1.Trace result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Trace buildPartial() {
      com.google.cloud.networkmanagement.v1.Trace result =
          new com.google.cloud.networkmanagement.v1.Trace(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.networkmanagement.v1.Trace result) {
      if (stepsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          steps_ = java.util.Collections.unmodifiableList(steps_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.steps_ = steps_;
      } else {
        result.steps_ = stepsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.Trace result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.endpointInfo_ =
            endpointInfoBuilder_ == null ? endpointInfo_ : endpointInfoBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.Trace) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.Trace) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.Trace other) {
      if (other == com.google.cloud.networkmanagement.v1.Trace.getDefaultInstance()) return this;
      if (other.hasEndpointInfo()) {
        mergeEndpointInfo(other.getEndpointInfo());
      }
      if (stepsBuilder_ == null) {
        if (!other.steps_.isEmpty()) {
          if (steps_.isEmpty()) {
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStepsIsMutable();
            steps_.addAll(other.steps_);
          }
          onChanged();
        }
      } else {
        if (!other.steps_.isEmpty()) {
          if (stepsBuilder_.isEmpty()) {
            stepsBuilder_.dispose();
            stepsBuilder_ = null;
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000002);
            stepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStepsFieldBuilder()
                    : null;
          } else {
            stepsBuilder_.addAllMessages(other.steps_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEndpointInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.networkmanagement.v1.Step m =
                    input.readMessage(
                        com.google.cloud.networkmanagement.v1.Step.parser(), extensionRegistry);
                if (stepsBuilder_ == null) {
                  ensureStepsIsMutable();
                  steps_.add(m);
                } else {
                  stepsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.networkmanagement.v1.EndpointInfo endpointInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.EndpointInfo,
            com.google.cloud.networkmanagement.v1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder>
        endpointInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     *
     * @return Whether the endpointInfo field is set.
     */
    public boolean hasEndpointInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     *
     * @return The endpointInfo.
     */
    public com.google.cloud.networkmanagement.v1.EndpointInfo getEndpointInfo() {
      if (endpointInfoBuilder_ == null) {
        return endpointInfo_ == null
            ? com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance()
            : endpointInfo_;
      } else {
        return endpointInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    public Builder setEndpointInfo(com.google.cloud.networkmanagement.v1.EndpointInfo value) {
      if (endpointInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointInfo_ = value;
      } else {
        endpointInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    public Builder setEndpointInfo(
        com.google.cloud.networkmanagement.v1.EndpointInfo.Builder builderForValue) {
      if (endpointInfoBuilder_ == null) {
        endpointInfo_ = builderForValue.build();
      } else {
        endpointInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    public Builder mergeEndpointInfo(com.google.cloud.networkmanagement.v1.EndpointInfo value) {
      if (endpointInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && endpointInfo_ != null
            && endpointInfo_
                != com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance()) {
          getEndpointInfoBuilder().mergeFrom(value);
        } else {
          endpointInfo_ = value;
        }
      } else {
        endpointInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    public Builder clearEndpointInfo() {
      bitField0_ = (bitField0_ & ~0x00000001);
      endpointInfo_ = null;
      if (endpointInfoBuilder_ != null) {
        endpointInfoBuilder_.dispose();
        endpointInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    public com.google.cloud.networkmanagement.v1.EndpointInfo.Builder getEndpointInfoBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getEndpointInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    public com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder getEndpointInfoOrBuilder() {
      if (endpointInfoBuilder_ != null) {
        return endpointInfoBuilder_.getMessageOrBuilder();
      } else {
        return endpointInfo_ == null
            ? com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance()
            : endpointInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Derived from the source and destination endpoints definition specified by
     * user request, and validated by the data plane model.
     * If there are multiple traces starting from different source locations, then
     * the endpoint_info may be different between traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint_info = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.EndpointInfo,
            com.google.cloud.networkmanagement.v1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder>
        getEndpointInfoFieldBuilder() {
      if (endpointInfoBuilder_ == null) {
        endpointInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.EndpointInfo,
                com.google.cloud.networkmanagement.v1.EndpointInfo.Builder,
                com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder>(
                getEndpointInfo(), getParentForChildren(), isClean());
        endpointInfo_ = null;
      }
      return endpointInfoBuilder_;
    }

    private java.util.List<com.google.cloud.networkmanagement.v1.Step> steps_ =
        java.util.Collections.emptyList();

    private void ensureStepsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        steps_ = new java.util.ArrayList<com.google.cloud.networkmanagement.v1.Step>(steps_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.Step,
            com.google.cloud.networkmanagement.v1.Step.Builder,
            com.google.cloud.networkmanagement.v1.StepOrBuilder>
        stepsBuilder_;

    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public java.util.List<com.google.cloud.networkmanagement.v1.Step> getStepsList() {
      if (stepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(steps_);
      } else {
        return stepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public int getStepsCount() {
      if (stepsBuilder_ == null) {
        return steps_.size();
      } else {
        return stepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public com.google.cloud.networkmanagement.v1.Step getSteps(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder setSteps(int index, com.google.cloud.networkmanagement.v1.Step value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.set(index, value);
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder setSteps(
        int index, com.google.cloud.networkmanagement.v1.Step.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.set(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder addSteps(com.google.cloud.networkmanagement.v1.Step value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder addSteps(int index, com.google.cloud.networkmanagement.v1.Step value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(index, value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder addSteps(com.google.cloud.networkmanagement.v1.Step.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder addSteps(
        int index, com.google.cloud.networkmanagement.v1.Step.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder addAllSteps(
        java.lang.Iterable<? extends com.google.cloud.networkmanagement.v1.Step> values) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, steps_);
        onChanged();
      } else {
        stepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder clearSteps() {
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        stepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public Builder removeSteps(int index) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.remove(index);
        onChanged();
      } else {
        stepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public com.google.cloud.networkmanagement.v1.Step.Builder getStepsBuilder(int index) {
      return getStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public com.google.cloud.networkmanagement.v1.StepOrBuilder getStepsOrBuilder(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.networkmanagement.v1.StepOrBuilder>
        getStepsOrBuilderList() {
      if (stepsBuilder_ != null) {
        return stepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(steps_);
      }
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public com.google.cloud.networkmanagement.v1.Step.Builder addStepsBuilder() {
      return getStepsFieldBuilder()
          .addBuilder(com.google.cloud.networkmanagement.v1.Step.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public com.google.cloud.networkmanagement.v1.Step.Builder addStepsBuilder(int index) {
      return getStepsFieldBuilder()
          .addBuilder(index, com.google.cloud.networkmanagement.v1.Step.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A trace of a test contains multiple steps from the initial state to the
     * final state (delivered, dropped, forwarded, or aborted).
     *
     * The steps are ordered by the processing sequence within the simulated
     * network state machine. It is critical to preserve the order of the steps
     * and avoid reordering or sorting them.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1.Step steps = 2;</code>
     */
    public java.util.List<com.google.cloud.networkmanagement.v1.Step.Builder>
        getStepsBuilderList() {
      return getStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.Step,
            com.google.cloud.networkmanagement.v1.Step.Builder,
            com.google.cloud.networkmanagement.v1.StepOrBuilder>
        getStepsFieldBuilder() {
      if (stepsBuilder_ == null) {
        stepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.Step,
                com.google.cloud.networkmanagement.v1.Step.Builder,
                com.google.cloud.networkmanagement.v1.StepOrBuilder>(
                steps_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        steps_ = null;
      }
      return stepsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.Trace)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.Trace)
  private static final com.google.cloud.networkmanagement.v1.Trace DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.Trace();
  }

  public static com.google.cloud.networkmanagement.v1.Trace getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Trace> PARSER =
      new com.google.protobuf.AbstractParser<Trace>() {
        @java.lang.Override
        public Trace parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Trace> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Trace> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.Trace getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
