/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * Details of the final state "forward" and associated resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.ForwardInfo}
 */
public final class ForwardInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.ForwardInfo)
    ForwardInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ForwardInfo.newBuilder() to construct.
  private ForwardInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ForwardInfo() {
    target_ = 0;
    resourceUri_ = "";
    ipAddress_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ForwardInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_ForwardInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_ForwardInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.ForwardInfo.class,
            com.google.cloud.networkmanagement.v1.ForwardInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Forward target types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.ForwardInfo.Target}
   */
  public enum Target implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Target not specified.
     * </pre>
     *
     * <code>TARGET_UNSPECIFIED = 0;</code>
     */
    TARGET_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Forwarded to a VPC peering network.
     * </pre>
     *
     * <code>PEERING_VPC = 1;</code>
     */
    PEERING_VPC(1),
    /**
     *
     *
     * <pre>
     * Forwarded to a Cloud VPN gateway.
     * </pre>
     *
     * <code>VPN_GATEWAY = 2;</code>
     */
    VPN_GATEWAY(2),
    /**
     *
     *
     * <pre>
     * Forwarded to a Cloud Interconnect connection.
     * </pre>
     *
     * <code>INTERCONNECT = 3;</code>
     */
    INTERCONNECT(3),
    /**
     *
     *
     * <pre>
     * Forwarded to a Google Kubernetes Engine Container cluster master.
     * </pre>
     *
     * <code>GKE_MASTER = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    GKE_MASTER(4),
    /**
     *
     *
     * <pre>
     * Forwarded to the next hop of a custom route imported from a peering VPC.
     * </pre>
     *
     * <code>IMPORTED_CUSTOM_ROUTE_NEXT_HOP = 5;</code>
     */
    IMPORTED_CUSTOM_ROUTE_NEXT_HOP(5),
    /**
     *
     *
     * <pre>
     * Forwarded to a Cloud SQL instance.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    CLOUD_SQL_INSTANCE(6),
    /**
     *
     *
     * <pre>
     * Forwarded to a VPC network in another project.
     * </pre>
     *
     * <code>ANOTHER_PROJECT = 7;</code>
     */
    ANOTHER_PROJECT(7),
    /**
     *
     *
     * <pre>
     * Forwarded to an NCC Hub.
     * </pre>
     *
     * <code>NCC_HUB = 8;</code>
     */
    NCC_HUB(8),
    /**
     *
     *
     * <pre>
     * Forwarded to a router appliance.
     * </pre>
     *
     * <code>ROUTER_APPLIANCE = 9;</code>
     */
    ROUTER_APPLIANCE(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Target not specified.
     * </pre>
     *
     * <code>TARGET_UNSPECIFIED = 0;</code>
     */
    public static final int TARGET_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Forwarded to a VPC peering network.
     * </pre>
     *
     * <code>PEERING_VPC = 1;</code>
     */
    public static final int PEERING_VPC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Forwarded to a Cloud VPN gateway.
     * </pre>
     *
     * <code>VPN_GATEWAY = 2;</code>
     */
    public static final int VPN_GATEWAY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Forwarded to a Cloud Interconnect connection.
     * </pre>
     *
     * <code>INTERCONNECT = 3;</code>
     */
    public static final int INTERCONNECT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Forwarded to a Google Kubernetes Engine Container cluster master.
     * </pre>
     *
     * <code>GKE_MASTER = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int GKE_MASTER_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Forwarded to the next hop of a custom route imported from a peering VPC.
     * </pre>
     *
     * <code>IMPORTED_CUSTOM_ROUTE_NEXT_HOP = 5;</code>
     */
    public static final int IMPORTED_CUSTOM_ROUTE_NEXT_HOP_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Forwarded to a Cloud SQL instance.
     * </pre>
     *
     * <code>CLOUD_SQL_INSTANCE = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int CLOUD_SQL_INSTANCE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Forwarded to a VPC network in another project.
     * </pre>
     *
     * <code>ANOTHER_PROJECT = 7;</code>
     */
    public static final int ANOTHER_PROJECT_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Forwarded to an NCC Hub.
     * </pre>
     *
     * <code>NCC_HUB = 8;</code>
     */
    public static final int NCC_HUB_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Forwarded to a router appliance.
     * </pre>
     *
     * <code>ROUTER_APPLIANCE = 9;</code>
     */
    public static final int ROUTER_APPLIANCE_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Target valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Target forNumber(int value) {
      switch (value) {
        case 0:
          return TARGET_UNSPECIFIED;
        case 1:
          return PEERING_VPC;
        case 2:
          return VPN_GATEWAY;
        case 3:
          return INTERCONNECT;
        case 4:
          return GKE_MASTER;
        case 5:
          return IMPORTED_CUSTOM_ROUTE_NEXT_HOP;
        case 6:
          return CLOUD_SQL_INSTANCE;
        case 7:
          return ANOTHER_PROJECT;
        case 8:
          return NCC_HUB;
        case 9:
          return ROUTER_APPLIANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Target> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Target> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Target>() {
          public Target findValueByNumber(int number) {
            return Target.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.ForwardInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Target[] VALUES = values();

    public static Target valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Target(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.ForwardInfo.Target)
  }

  public static final int TARGET_FIELD_NUMBER = 1;
  private int target_ = 0;
  /**
   *
   *
   * <pre>
   * Target type where this packet is forwarded to.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
   *
   * @return The enum numeric value on the wire for target.
   */
  @java.lang.Override
  public int getTargetValue() {
    return target_;
  }
  /**
   *
   *
   * <pre>
   * Target type where this packet is forwarded to.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ForwardInfo.Target getTarget() {
    com.google.cloud.networkmanagement.v1.ForwardInfo.Target result =
        com.google.cloud.networkmanagement.v1.ForwardInfo.Target.forNumber(target_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.ForwardInfo.Target.UNRECOGNIZED
        : result;
  }

  public static final int RESOURCE_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the resource that the packet is forwarded to.
   * </pre>
   *
   * <code>string resource_uri = 2;</code>
   *
   * @return The resourceUri.
   */
  @java.lang.Override
  public java.lang.String getResourceUri() {
    java.lang.Object ref = resourceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the resource that the packet is forwarded to.
   * </pre>
   *
   * <code>string resource_uri = 2;</code>
   *
   * @return The bytes for resourceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceUriBytes() {
    java.lang.Object ref = resourceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipAddress_ = "";
  /**
   *
   *
   * <pre>
   * IP address of the target (if applicable).
   * </pre>
   *
   * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP address of the target (if applicable).
   * </pre>
   *
   * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (target_
        != com.google.cloud.networkmanagement.v1.ForwardInfo.Target.TARGET_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ipAddress_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (target_
        != com.google.cloud.networkmanagement.v1.ForwardInfo.Target.TARGET_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ipAddress_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.ForwardInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.ForwardInfo other =
        (com.google.cloud.networkmanagement.v1.ForwardInfo) obj;

    if (target_ != other.target_) return false;
    if (!getResourceUri().equals(other.getResourceUri())) return false;
    if (!getIpAddress().equals(other.getIpAddress())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + target_;
    hash = (37 * hash) + RESOURCE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getResourceUri().hashCode();
    hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getIpAddress().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.ForwardInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of the final state "forward" and associated resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.ForwardInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.ForwardInfo)
      com.google.cloud.networkmanagement.v1.ForwardInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_ForwardInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_ForwardInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.ForwardInfo.class,
              com.google.cloud.networkmanagement.v1.ForwardInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.ForwardInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      target_ = 0;
      resourceUri_ = "";
      ipAddress_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_ForwardInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardInfo build() {
      com.google.cloud.networkmanagement.v1.ForwardInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.ForwardInfo result =
          new com.google.cloud.networkmanagement.v1.ForwardInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.ForwardInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resourceUri_ = resourceUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ipAddress_ = ipAddress_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.ForwardInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.ForwardInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.ForwardInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance())
        return this;
      if (other.target_ != 0) {
        setTargetValue(other.getTargetValue());
      }
      if (!other.getResourceUri().isEmpty()) {
        resourceUri_ = other.resourceUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getIpAddress().isEmpty()) {
        ipAddress_ = other.ipAddress_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                target_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                resourceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                ipAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int target_ = 0;
    /**
     *
     *
     * <pre>
     * Target type where this packet is forwarded to.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
     *
     * @return The enum numeric value on the wire for target.
     */
    @java.lang.Override
    public int getTargetValue() {
      return target_;
    }
    /**
     *
     *
     * <pre>
     * Target type where this packet is forwarded to.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
     *
     * @param value The enum numeric value on the wire for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetValue(int value) {
      target_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target type where this packet is forwarded to.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
     *
     * @return The target.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardInfo.Target getTarget() {
      com.google.cloud.networkmanagement.v1.ForwardInfo.Target result =
          com.google.cloud.networkmanagement.v1.ForwardInfo.Target.forNumber(target_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.ForwardInfo.Target.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Target type where this packet is forwarded to.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(com.google.cloud.networkmanagement.v1.ForwardInfo.Target value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      target_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target type where this packet is forwarded to.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo.Target target = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      bitField0_ = (bitField0_ & ~0x00000001);
      target_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object resourceUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the resource that the packet is forwarded to.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @return The resourceUri.
     */
    public java.lang.String getResourceUri() {
      java.lang.Object ref = resourceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that the packet is forwarded to.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @return The bytes for resourceUri.
     */
    public com.google.protobuf.ByteString getResourceUriBytes() {
      java.lang.Object ref = resourceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that the packet is forwarded to.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @param value The resourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that the packet is forwarded to.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceUri() {
      resourceUri_ = getDefaultInstance().getResourceUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the resource that the packet is forwarded to.
     * </pre>
     *
     * <code>string resource_uri = 2;</code>
     *
     * @param value The bytes for resourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object ipAddress_ = "";
    /**
     *
     *
     * <pre>
     * IP address of the target (if applicable).
     * </pre>
     *
     * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address of the target (if applicable).
     * </pre>
     *
     * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address of the target (if applicable).
     * </pre>
     *
     * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipAddress_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP address of the target (if applicable).
     * </pre>
     *
     * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {
      ipAddress_ = getDefaultInstance().getIpAddress();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP address of the target (if applicable).
     * </pre>
     *
     * <code>string ip_address = 3 [(.google.api.field_info) = { ... }</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipAddress_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.ForwardInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.ForwardInfo)
  private static final com.google.cloud.networkmanagement.v1.ForwardInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.ForwardInfo();
  }

  public static com.google.cloud.networkmanagement.v1.ForwardInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ForwardInfo> PARSER =
      new com.google.protobuf.AbstractParser<ForwardInfo>() {
        @java.lang.Override
        public ForwardInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ForwardInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ForwardInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ForwardInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
