/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with the load balancer backend.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.LoadBalancerBackendInfo}
 */
public final class LoadBalancerBackendInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.LoadBalancerBackendInfo)
    LoadBalancerBackendInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LoadBalancerBackendInfo.newBuilder() to construct.
  private LoadBalancerBackendInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LoadBalancerBackendInfo() {
    name_ = "";
    instanceUri_ = "";
    backendServiceUri_ = "";
    instanceGroupUri_ = "";
    networkEndpointGroupUri_ = "";
    backendBucketUri_ = "";
    pscServiceAttachmentUri_ = "";
    pscGoogleApiTarget_ = "";
    healthCheckUri_ = "";
    healthCheckFirewallsConfigState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LoadBalancerBackendInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_LoadBalancerBackendInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_LoadBalancerBackendInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.class,
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Health check firewalls configuration state enum.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState}
   */
  public enum HealthCheckFirewallsConfigState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Configuration state unspecified. It usually means that the backend has
     * no health check attached, or there was an unexpected configuration error
     * preventing Connectivity tests from verifying health check configuration.
     * </pre>
     *
     * <code>HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED = 0;</code>
     */
    HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Firewall rules (policies) allowing health check traffic from all required
     * IP ranges to the backend are configured.
     * </pre>
     *
     * <code>FIREWALLS_CONFIGURED = 1;</code>
     */
    FIREWALLS_CONFIGURED(1),
    /**
     *
     *
     * <pre>
     * Firewall rules (policies) allow health check traffic only from a part of
     * required IP ranges.
     * </pre>
     *
     * <code>FIREWALLS_PARTIALLY_CONFIGURED = 2;</code>
     */
    FIREWALLS_PARTIALLY_CONFIGURED(2),
    /**
     *
     *
     * <pre>
     * Firewall rules (policies) deny health check traffic from all required
     * IP ranges to the backend.
     * </pre>
     *
     * <code>FIREWALLS_NOT_CONFIGURED = 3;</code>
     */
    FIREWALLS_NOT_CONFIGURED(3),
    /**
     *
     *
     * <pre>
     * The network contains firewall rules of unsupported types, so Connectivity
     * tests were not able to verify health check configuration status. Please
     * refer to the documentation for the list of unsupported configurations:
     * https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/concepts/overview#unsupported-configs
     * </pre>
     *
     * <code>FIREWALLS_UNSUPPORTED = 4;</code>
     */
    FIREWALLS_UNSUPPORTED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Configuration state unspecified. It usually means that the backend has
     * no health check attached, or there was an unexpected configuration error
     * preventing Connectivity tests from verifying health check configuration.
     * </pre>
     *
     * <code>HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Firewall rules (policies) allowing health check traffic from all required
     * IP ranges to the backend are configured.
     * </pre>
     *
     * <code>FIREWALLS_CONFIGURED = 1;</code>
     */
    public static final int FIREWALLS_CONFIGURED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Firewall rules (policies) allow health check traffic only from a part of
     * required IP ranges.
     * </pre>
     *
     * <code>FIREWALLS_PARTIALLY_CONFIGURED = 2;</code>
     */
    public static final int FIREWALLS_PARTIALLY_CONFIGURED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Firewall rules (policies) deny health check traffic from all required
     * IP ranges to the backend.
     * </pre>
     *
     * <code>FIREWALLS_NOT_CONFIGURED = 3;</code>
     */
    public static final int FIREWALLS_NOT_CONFIGURED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The network contains firewall rules of unsupported types, so Connectivity
     * tests were not able to verify health check configuration status. Please
     * refer to the documentation for the list of unsupported configurations:
     * https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/concepts/overview#unsupported-configs
     * </pre>
     *
     * <code>FIREWALLS_UNSUPPORTED = 4;</code>
     */
    public static final int FIREWALLS_UNSUPPORTED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HealthCheckFirewallsConfigState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HealthCheckFirewallsConfigState forNumber(int value) {
      switch (value) {
        case 0:
          return HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED;
        case 1:
          return FIREWALLS_CONFIGURED;
        case 2:
          return FIREWALLS_PARTIALLY_CONFIGURED;
        case 3:
          return FIREWALLS_NOT_CONFIGURED;
        case 4:
          return FIREWALLS_UNSUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HealthCheckFirewallsConfigState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HealthCheckFirewallsConfigState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<HealthCheckFirewallsConfigState>() {
              public HealthCheckFirewallsConfigState findValueByNumber(int number) {
                return HealthCheckFirewallsConfigState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final HealthCheckFirewallsConfigState[] VALUES = values();

    public static HealthCheckFirewallsConfigState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HealthCheckFirewallsConfigState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Display name of the backend. For example, it might be an instance name for
   * the instance group backends, or an IP address and port for zonal network
   * endpoint group backends.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name of the backend. For example, it might be an instance name for
   * the instance group backends, or an IP address and port for zonal network
   * endpoint group backends.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the backend instance (if applicable). Populated for instance group
   * backends, and zonal NEG backends.
   * </pre>
   *
   * <code>string instance_uri = 2;</code>
   *
   * @return The instanceUri.
   */
  @java.lang.Override
  public java.lang.String getInstanceUri() {
    java.lang.Object ref = instanceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the backend instance (if applicable). Populated for instance group
   * backends, and zonal NEG backends.
   * </pre>
   *
   * <code>string instance_uri = 2;</code>
   *
   * @return The bytes for instanceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceUriBytes() {
    java.lang.Object ref = instanceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKEND_SERVICE_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backendServiceUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the backend service this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string backend_service_uri = 3;</code>
   *
   * @return The backendServiceUri.
   */
  @java.lang.Override
  public java.lang.String getBackendServiceUri() {
    java.lang.Object ref = backendServiceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backendServiceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the backend service this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string backend_service_uri = 3;</code>
   *
   * @return The bytes for backendServiceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackendServiceUriBytes() {
    java.lang.Object ref = backendServiceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backendServiceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_GROUP_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceGroupUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the instance group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string instance_group_uri = 4;</code>
   *
   * @return The instanceGroupUri.
   */
  @java.lang.Override
  public java.lang.String getInstanceGroupUri() {
    java.lang.Object ref = instanceGroupUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceGroupUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the instance group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string instance_group_uri = 4;</code>
   *
   * @return The bytes for instanceGroupUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceGroupUriBytes() {
    java.lang.Object ref = instanceGroupUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceGroupUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_ENDPOINT_GROUP_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkEndpointGroupUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the network endpoint group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string network_endpoint_group_uri = 5;</code>
   *
   * @return The networkEndpointGroupUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkEndpointGroupUri() {
    java.lang.Object ref = networkEndpointGroupUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkEndpointGroupUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the network endpoint group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string network_endpoint_group_uri = 5;</code>
   *
   * @return The bytes for networkEndpointGroupUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkEndpointGroupUriBytes() {
    java.lang.Object ref = networkEndpointGroupUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkEndpointGroupUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKEND_BUCKET_URI_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backendBucketUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the backend bucket this backend targets (if applicable).
   * </pre>
   *
   * <code>string backend_bucket_uri = 8;</code>
   *
   * @return The backendBucketUri.
   */
  @java.lang.Override
  public java.lang.String getBackendBucketUri() {
    java.lang.Object ref = backendBucketUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backendBucketUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the backend bucket this backend targets (if applicable).
   * </pre>
   *
   * <code>string backend_bucket_uri = 8;</code>
   *
   * @return The bytes for backendBucketUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackendBucketUriBytes() {
    java.lang.Object ref = backendBucketUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backendBucketUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PSC_SERVICE_ATTACHMENT_URI_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pscServiceAttachmentUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the PSC service attachment this PSC NEG backend targets (if
   * applicable).
   * </pre>
   *
   * <code>string psc_service_attachment_uri = 9;</code>
   *
   * @return The pscServiceAttachmentUri.
   */
  @java.lang.Override
  public java.lang.String getPscServiceAttachmentUri() {
    java.lang.Object ref = pscServiceAttachmentUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pscServiceAttachmentUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the PSC service attachment this PSC NEG backend targets (if
   * applicable).
   * </pre>
   *
   * <code>string psc_service_attachment_uri = 9;</code>
   *
   * @return The bytes for pscServiceAttachmentUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPscServiceAttachmentUriBytes() {
    java.lang.Object ref = pscServiceAttachmentUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pscServiceAttachmentUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PSC_GOOGLE_API_TARGET_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pscGoogleApiTarget_ = "";
  /**
   *
   *
   * <pre>
   * PSC Google API target this PSC NEG backend targets (if applicable).
   * </pre>
   *
   * <code>string psc_google_api_target = 10;</code>
   *
   * @return The pscGoogleApiTarget.
   */
  @java.lang.Override
  public java.lang.String getPscGoogleApiTarget() {
    java.lang.Object ref = pscGoogleApiTarget_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pscGoogleApiTarget_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * PSC Google API target this PSC NEG backend targets (if applicable).
   * </pre>
   *
   * <code>string psc_google_api_target = 10;</code>
   *
   * @return The bytes for pscGoogleApiTarget.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPscGoogleApiTargetBytes() {
    java.lang.Object ref = pscGoogleApiTarget_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pscGoogleApiTarget_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_CHECK_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object healthCheckUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the health check attached to this backend (if applicable).
   * </pre>
   *
   * <code>string health_check_uri = 6;</code>
   *
   * @return The healthCheckUri.
   */
  @java.lang.Override
  public java.lang.String getHealthCheckUri() {
    java.lang.Object ref = healthCheckUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthCheckUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the health check attached to this backend (if applicable).
   * </pre>
   *
   * <code>string health_check_uri = 6;</code>
   *
   * @return The bytes for healthCheckUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthCheckUriBytes() {
    java.lang.Object ref = healthCheckUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthCheckUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_CHECK_FIREWALLS_CONFIG_STATE_FIELD_NUMBER = 7;
  private int healthCheckFirewallsConfigState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Health check firewalls configuration state for the backend.
   * This is a result of the static firewall analysis (verifying that health
   * check traffic from required IP ranges to the backend is allowed or not).
   * The backend might still be unhealthy even if these firewalls are
   * configured. Please refer to the documentation for more information:
   * https://cloud.google.com/load-balancing/docs/firewall-rules
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for healthCheckFirewallsConfigState.
   */
  @java.lang.Override
  public int getHealthCheckFirewallsConfigStateValue() {
    return healthCheckFirewallsConfigState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Health check firewalls configuration state for the backend.
   * This is a result of the static firewall analysis (verifying that health
   * check traffic from required IP ranges to the backend is allowed or not).
   * The backend might still be unhealthy even if these firewalls are
   * configured. Please refer to the documentation for more information:
   * https://cloud.google.com/load-balancing/docs/firewall-rules
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The healthCheckFirewallsConfigState.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
          .HealthCheckFirewallsConfigState
      getHealthCheckFirewallsConfigState() {
    com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState
        result =
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
                .HealthCheckFirewallsConfigState.forNumber(healthCheckFirewallsConfigState_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
            .HealthCheckFirewallsConfigState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backendServiceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, backendServiceUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceGroupUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, instanceGroupUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkEndpointGroupUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, networkEndpointGroupUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(healthCheckUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, healthCheckUri_);
    }
    if (healthCheckFirewallsConfigState_
        != com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
            .HealthCheckFirewallsConfigState.HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, healthCheckFirewallsConfigState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backendBucketUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, backendBucketUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pscServiceAttachmentUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, pscServiceAttachmentUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pscGoogleApiTarget_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, pscGoogleApiTarget_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instanceUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backendServiceUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, backendServiceUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceGroupUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, instanceGroupUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkEndpointGroupUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, networkEndpointGroupUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(healthCheckUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, healthCheckUri_);
    }
    if (healthCheckFirewallsConfigState_
        != com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
            .HealthCheckFirewallsConfigState.HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              7, healthCheckFirewallsConfigState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backendBucketUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, backendBucketUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pscServiceAttachmentUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, pscServiceAttachmentUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pscGoogleApiTarget_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, pscGoogleApiTarget_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo other =
        (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getInstanceUri().equals(other.getInstanceUri())) return false;
    if (!getBackendServiceUri().equals(other.getBackendServiceUri())) return false;
    if (!getInstanceGroupUri().equals(other.getInstanceGroupUri())) return false;
    if (!getNetworkEndpointGroupUri().equals(other.getNetworkEndpointGroupUri())) return false;
    if (!getBackendBucketUri().equals(other.getBackendBucketUri())) return false;
    if (!getPscServiceAttachmentUri().equals(other.getPscServiceAttachmentUri())) return false;
    if (!getPscGoogleApiTarget().equals(other.getPscGoogleApiTarget())) return false;
    if (!getHealthCheckUri().equals(other.getHealthCheckUri())) return false;
    if (healthCheckFirewallsConfigState_ != other.healthCheckFirewallsConfigState_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + INSTANCE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceUri().hashCode();
    hash = (37 * hash) + BACKEND_SERVICE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getBackendServiceUri().hashCode();
    hash = (37 * hash) + INSTANCE_GROUP_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceGroupUri().hashCode();
    hash = (37 * hash) + NETWORK_ENDPOINT_GROUP_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkEndpointGroupUri().hashCode();
    hash = (37 * hash) + BACKEND_BUCKET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getBackendBucketUri().hashCode();
    hash = (37 * hash) + PSC_SERVICE_ATTACHMENT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getPscServiceAttachmentUri().hashCode();
    hash = (37 * hash) + PSC_GOOGLE_API_TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getPscGoogleApiTarget().hashCode();
    hash = (37 * hash) + HEALTH_CHECK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getHealthCheckUri().hashCode();
    hash = (37 * hash) + HEALTH_CHECK_FIREWALLS_CONFIG_STATE_FIELD_NUMBER;
    hash = (53 * hash) + healthCheckFirewallsConfigState_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with the load balancer backend.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.LoadBalancerBackendInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.LoadBalancerBackendInfo)
      com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_LoadBalancerBackendInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_LoadBalancerBackendInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.class,
              com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      instanceUri_ = "";
      backendServiceUri_ = "";
      instanceGroupUri_ = "";
      networkEndpointGroupUri_ = "";
      backendBucketUri_ = "";
      pscServiceAttachmentUri_ = "";
      pscGoogleApiTarget_ = "";
      healthCheckUri_ = "";
      healthCheckFirewallsConfigState_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_LoadBalancerBackendInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
        getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo build() {
      com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo result =
          new com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceUri_ = instanceUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.backendServiceUri_ = backendServiceUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.instanceGroupUri_ = instanceGroupUri_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.networkEndpointGroupUri_ = networkEndpointGroupUri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.backendBucketUri_ = backendBucketUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pscServiceAttachmentUri_ = pscServiceAttachmentUri_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pscGoogleApiTarget_ = pscGoogleApiTarget_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.healthCheckUri_ = healthCheckUri_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.healthCheckFirewallsConfigState_ = healthCheckFirewallsConfigState_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo other) {
      if (other
          == com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInstanceUri().isEmpty()) {
        instanceUri_ = other.instanceUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getBackendServiceUri().isEmpty()) {
        backendServiceUri_ = other.backendServiceUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getInstanceGroupUri().isEmpty()) {
        instanceGroupUri_ = other.instanceGroupUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getNetworkEndpointGroupUri().isEmpty()) {
        networkEndpointGroupUri_ = other.networkEndpointGroupUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getBackendBucketUri().isEmpty()) {
        backendBucketUri_ = other.backendBucketUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getPscServiceAttachmentUri().isEmpty()) {
        pscServiceAttachmentUri_ = other.pscServiceAttachmentUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getPscGoogleApiTarget().isEmpty()) {
        pscGoogleApiTarget_ = other.pscGoogleApiTarget_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getHealthCheckUri().isEmpty()) {
        healthCheckUri_ = other.healthCheckUri_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.healthCheckFirewallsConfigState_ != 0) {
        setHealthCheckFirewallsConfigStateValue(other.getHealthCheckFirewallsConfigStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                instanceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                backendServiceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                instanceGroupUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                networkEndpointGroupUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                healthCheckUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 56:
              {
                healthCheckFirewallsConfigState_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 56
            case 66:
              {
                backendBucketUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                pscServiceAttachmentUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                pscGoogleApiTarget_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Display name of the backend. For example, it might be an instance name for
     * the instance group backends, or an IP address and port for zonal network
     * endpoint group backends.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of the backend. For example, it might be an instance name for
     * the instance group backends, or an IP address and port for zonal network
     * endpoint group backends.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of the backend. For example, it might be an instance name for
     * the instance group backends, or an IP address and port for zonal network
     * endpoint group backends.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of the backend. For example, it might be an instance name for
     * the instance group backends, or an IP address and port for zonal network
     * endpoint group backends.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of the backend. For example, it might be an instance name for
     * the instance group backends, or an IP address and port for zonal network
     * endpoint group backends.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instanceUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the backend instance (if applicable). Populated for instance group
     * backends, and zonal NEG backends.
     * </pre>
     *
     * <code>string instance_uri = 2;</code>
     *
     * @return The instanceUri.
     */
    public java.lang.String getInstanceUri() {
      java.lang.Object ref = instanceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the backend instance (if applicable). Populated for instance group
     * backends, and zonal NEG backends.
     * </pre>
     *
     * <code>string instance_uri = 2;</code>
     *
     * @return The bytes for instanceUri.
     */
    public com.google.protobuf.ByteString getInstanceUriBytes() {
      java.lang.Object ref = instanceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the backend instance (if applicable). Populated for instance group
     * backends, and zonal NEG backends.
     * </pre>
     *
     * <code>string instance_uri = 2;</code>
     *
     * @param value The instanceUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the backend instance (if applicable). Populated for instance group
     * backends, and zonal NEG backends.
     * </pre>
     *
     * <code>string instance_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceUri() {
      instanceUri_ = getDefaultInstance().getInstanceUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the backend instance (if applicable). Populated for instance group
     * backends, and zonal NEG backends.
     * </pre>
     *
     * <code>string instance_uri = 2;</code>
     *
     * @param value The bytes for instanceUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object backendServiceUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the backend service this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string backend_service_uri = 3;</code>
     *
     * @return The backendServiceUri.
     */
    public java.lang.String getBackendServiceUri() {
      java.lang.Object ref = backendServiceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backendServiceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the backend service this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string backend_service_uri = 3;</code>
     *
     * @return The bytes for backendServiceUri.
     */
    public com.google.protobuf.ByteString getBackendServiceUriBytes() {
      java.lang.Object ref = backendServiceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backendServiceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the backend service this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string backend_service_uri = 3;</code>
     *
     * @param value The backendServiceUri to set.
     * @return This builder for chaining.
     */
    public Builder setBackendServiceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backendServiceUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the backend service this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string backend_service_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackendServiceUri() {
      backendServiceUri_ = getDefaultInstance().getBackendServiceUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the backend service this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string backend_service_uri = 3;</code>
     *
     * @param value The bytes for backendServiceUri to set.
     * @return This builder for chaining.
     */
    public Builder setBackendServiceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backendServiceUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object instanceGroupUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the instance group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string instance_group_uri = 4;</code>
     *
     * @return The instanceGroupUri.
     */
    public java.lang.String getInstanceGroupUri() {
      java.lang.Object ref = instanceGroupUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceGroupUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the instance group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string instance_group_uri = 4;</code>
     *
     * @return The bytes for instanceGroupUri.
     */
    public com.google.protobuf.ByteString getInstanceGroupUriBytes() {
      java.lang.Object ref = instanceGroupUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceGroupUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the instance group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string instance_group_uri = 4;</code>
     *
     * @param value The instanceGroupUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceGroupUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the instance group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string instance_group_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceGroupUri() {
      instanceGroupUri_ = getDefaultInstance().getInstanceGroupUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the instance group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string instance_group_uri = 4;</code>
     *
     * @param value The bytes for instanceGroupUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceGroupUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object networkEndpointGroupUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the network endpoint group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string network_endpoint_group_uri = 5;</code>
     *
     * @return The networkEndpointGroupUri.
     */
    public java.lang.String getNetworkEndpointGroupUri() {
      java.lang.Object ref = networkEndpointGroupUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkEndpointGroupUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network endpoint group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string network_endpoint_group_uri = 5;</code>
     *
     * @return The bytes for networkEndpointGroupUri.
     */
    public com.google.protobuf.ByteString getNetworkEndpointGroupUriBytes() {
      java.lang.Object ref = networkEndpointGroupUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkEndpointGroupUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network endpoint group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string network_endpoint_group_uri = 5;</code>
     *
     * @param value The networkEndpointGroupUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkEndpointGroupUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkEndpointGroupUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network endpoint group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string network_endpoint_group_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkEndpointGroupUri() {
      networkEndpointGroupUri_ = getDefaultInstance().getNetworkEndpointGroupUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network endpoint group this backend belongs to (if applicable).
     * </pre>
     *
     * <code>string network_endpoint_group_uri = 5;</code>
     *
     * @param value The bytes for networkEndpointGroupUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkEndpointGroupUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkEndpointGroupUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object backendBucketUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the backend bucket this backend targets (if applicable).
     * </pre>
     *
     * <code>string backend_bucket_uri = 8;</code>
     *
     * @return The backendBucketUri.
     */
    public java.lang.String getBackendBucketUri() {
      java.lang.Object ref = backendBucketUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backendBucketUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the backend bucket this backend targets (if applicable).
     * </pre>
     *
     * <code>string backend_bucket_uri = 8;</code>
     *
     * @return The bytes for backendBucketUri.
     */
    public com.google.protobuf.ByteString getBackendBucketUriBytes() {
      java.lang.Object ref = backendBucketUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backendBucketUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the backend bucket this backend targets (if applicable).
     * </pre>
     *
     * <code>string backend_bucket_uri = 8;</code>
     *
     * @param value The backendBucketUri to set.
     * @return This builder for chaining.
     */
    public Builder setBackendBucketUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backendBucketUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the backend bucket this backend targets (if applicable).
     * </pre>
     *
     * <code>string backend_bucket_uri = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackendBucketUri() {
      backendBucketUri_ = getDefaultInstance().getBackendBucketUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the backend bucket this backend targets (if applicable).
     * </pre>
     *
     * <code>string backend_bucket_uri = 8;</code>
     *
     * @param value The bytes for backendBucketUri to set.
     * @return This builder for chaining.
     */
    public Builder setBackendBucketUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backendBucketUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object pscServiceAttachmentUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the PSC service attachment this PSC NEG backend targets (if
     * applicable).
     * </pre>
     *
     * <code>string psc_service_attachment_uri = 9;</code>
     *
     * @return The pscServiceAttachmentUri.
     */
    public java.lang.String getPscServiceAttachmentUri() {
      java.lang.Object ref = pscServiceAttachmentUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pscServiceAttachmentUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the PSC service attachment this PSC NEG backend targets (if
     * applicable).
     * </pre>
     *
     * <code>string psc_service_attachment_uri = 9;</code>
     *
     * @return The bytes for pscServiceAttachmentUri.
     */
    public com.google.protobuf.ByteString getPscServiceAttachmentUriBytes() {
      java.lang.Object ref = pscServiceAttachmentUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pscServiceAttachmentUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the PSC service attachment this PSC NEG backend targets (if
     * applicable).
     * </pre>
     *
     * <code>string psc_service_attachment_uri = 9;</code>
     *
     * @param value The pscServiceAttachmentUri to set.
     * @return This builder for chaining.
     */
    public Builder setPscServiceAttachmentUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pscServiceAttachmentUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the PSC service attachment this PSC NEG backend targets (if
     * applicable).
     * </pre>
     *
     * <code>string psc_service_attachment_uri = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPscServiceAttachmentUri() {
      pscServiceAttachmentUri_ = getDefaultInstance().getPscServiceAttachmentUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the PSC service attachment this PSC NEG backend targets (if
     * applicable).
     * </pre>
     *
     * <code>string psc_service_attachment_uri = 9;</code>
     *
     * @param value The bytes for pscServiceAttachmentUri to set.
     * @return This builder for chaining.
     */
    public Builder setPscServiceAttachmentUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pscServiceAttachmentUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object pscGoogleApiTarget_ = "";
    /**
     *
     *
     * <pre>
     * PSC Google API target this PSC NEG backend targets (if applicable).
     * </pre>
     *
     * <code>string psc_google_api_target = 10;</code>
     *
     * @return The pscGoogleApiTarget.
     */
    public java.lang.String getPscGoogleApiTarget() {
      java.lang.Object ref = pscGoogleApiTarget_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pscGoogleApiTarget_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * PSC Google API target this PSC NEG backend targets (if applicable).
     * </pre>
     *
     * <code>string psc_google_api_target = 10;</code>
     *
     * @return The bytes for pscGoogleApiTarget.
     */
    public com.google.protobuf.ByteString getPscGoogleApiTargetBytes() {
      java.lang.Object ref = pscGoogleApiTarget_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pscGoogleApiTarget_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * PSC Google API target this PSC NEG backend targets (if applicable).
     * </pre>
     *
     * <code>string psc_google_api_target = 10;</code>
     *
     * @param value The pscGoogleApiTarget to set.
     * @return This builder for chaining.
     */
    public Builder setPscGoogleApiTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pscGoogleApiTarget_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PSC Google API target this PSC NEG backend targets (if applicable).
     * </pre>
     *
     * <code>string psc_google_api_target = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPscGoogleApiTarget() {
      pscGoogleApiTarget_ = getDefaultInstance().getPscGoogleApiTarget();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PSC Google API target this PSC NEG backend targets (if applicable).
     * </pre>
     *
     * <code>string psc_google_api_target = 10;</code>
     *
     * @param value The bytes for pscGoogleApiTarget to set.
     * @return This builder for chaining.
     */
    public Builder setPscGoogleApiTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pscGoogleApiTarget_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object healthCheckUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the health check attached to this backend (if applicable).
     * </pre>
     *
     * <code>string health_check_uri = 6;</code>
     *
     * @return The healthCheckUri.
     */
    public java.lang.String getHealthCheckUri() {
      java.lang.Object ref = healthCheckUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthCheckUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the health check attached to this backend (if applicable).
     * </pre>
     *
     * <code>string health_check_uri = 6;</code>
     *
     * @return The bytes for healthCheckUri.
     */
    public com.google.protobuf.ByteString getHealthCheckUriBytes() {
      java.lang.Object ref = healthCheckUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthCheckUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the health check attached to this backend (if applicable).
     * </pre>
     *
     * <code>string health_check_uri = 6;</code>
     *
     * @param value The healthCheckUri to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      healthCheckUri_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the health check attached to this backend (if applicable).
     * </pre>
     *
     * <code>string health_check_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthCheckUri() {
      healthCheckUri_ = getDefaultInstance().getHealthCheckUri();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the health check attached to this backend (if applicable).
     * </pre>
     *
     * <code>string health_check_uri = 6;</code>
     *
     * @param value The bytes for healthCheckUri to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      healthCheckUri_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int healthCheckFirewallsConfigState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Health check firewalls configuration state for the backend.
     * This is a result of the static firewall analysis (verifying that health
     * check traffic from required IP ranges to the backend is allowed or not).
     * The backend might still be unhealthy even if these firewalls are
     * configured. Please refer to the documentation for more information:
     * https://cloud.google.com/load-balancing/docs/firewall-rules
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for healthCheckFirewallsConfigState.
     */
    @java.lang.Override
    public int getHealthCheckFirewallsConfigStateValue() {
      return healthCheckFirewallsConfigState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Health check firewalls configuration state for the backend.
     * This is a result of the static firewall analysis (verifying that health
     * check traffic from required IP ranges to the backend is allowed or not).
     * The backend might still be unhealthy even if these firewalls are
     * configured. Please refer to the documentation for more information:
     * https://cloud.google.com/load-balancing/docs/firewall-rules
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for healthCheckFirewallsConfigState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckFirewallsConfigStateValue(int value) {
      healthCheckFirewallsConfigState_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Health check firewalls configuration state for the backend.
     * This is a result of the static firewall analysis (verifying that health
     * check traffic from required IP ranges to the backend is allowed or not).
     * The backend might still be unhealthy even if these firewalls are
     * configured. Please refer to the documentation for more information:
     * https://cloud.google.com/load-balancing/docs/firewall-rules
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The healthCheckFirewallsConfigState.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
            .HealthCheckFirewallsConfigState
        getHealthCheckFirewallsConfigState() {
      com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState
          result =
              com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
                  .HealthCheckFirewallsConfigState.forNumber(healthCheckFirewallsConfigState_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
              .HealthCheckFirewallsConfigState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Health check firewalls configuration state for the backend.
     * This is a result of the static firewall analysis (verifying that health
     * check traffic from required IP ranges to the backend is allowed or not).
     * The backend might still be unhealthy even if these firewalls are
     * configured. Please refer to the documentation for more information:
     * https://cloud.google.com/load-balancing/docs/firewall-rules
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The healthCheckFirewallsConfigState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthCheckFirewallsConfigState(
        com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
                .HealthCheckFirewallsConfigState
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      healthCheckFirewallsConfigState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Health check firewalls configuration state for the backend.
     * This is a result of the static firewall analysis (verifying that health
     * check traffic from required IP ranges to the backend is allowed or not).
     * The backend might still be unhealthy even if these firewalls are
     * configured. Please refer to the documentation for more information:
     * https://cloud.google.com/load-balancing/docs/firewall-rules
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthCheckFirewallsConfigState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      healthCheckFirewallsConfigState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.LoadBalancerBackendInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.LoadBalancerBackendInfo)
  private static final com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo();
  }

  public static com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LoadBalancerBackendInfo> PARSER =
      new com.google.protobuf.AbstractParser<LoadBalancerBackendInfo>() {
        @java.lang.Override
        public LoadBalancerBackendInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LoadBalancerBackendInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LoadBalancerBackendInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
