/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

public interface LoadBalancerBackendInfoOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.networkmanagement.v1.LoadBalancerBackendInfo)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Display name of the backend. For example, it might be an instance name for
   * the instance group backends, or an IP address and port for zonal network
   * endpoint group backends.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Display name of the backend. For example, it might be an instance name for
   * the instance group backends, or an IP address and port for zonal network
   * endpoint group backends.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * URI of the backend instance (if applicable). Populated for instance group
   * backends, and zonal NEG backends.
   * </pre>
   *
   * <code>string instance_uri = 2;</code>
   *
   * @return The instanceUri.
   */
  java.lang.String getInstanceUri();
  /**
   *
   *
   * <pre>
   * URI of the backend instance (if applicable). Populated for instance group
   * backends, and zonal NEG backends.
   * </pre>
   *
   * <code>string instance_uri = 2;</code>
   *
   * @return The bytes for instanceUri.
   */
  com.google.protobuf.ByteString getInstanceUriBytes();

  /**
   *
   *
   * <pre>
   * URI of the backend service this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string backend_service_uri = 3;</code>
   *
   * @return The backendServiceUri.
   */
  java.lang.String getBackendServiceUri();
  /**
   *
   *
   * <pre>
   * URI of the backend service this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string backend_service_uri = 3;</code>
   *
   * @return The bytes for backendServiceUri.
   */
  com.google.protobuf.ByteString getBackendServiceUriBytes();

  /**
   *
   *
   * <pre>
   * URI of the instance group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string instance_group_uri = 4;</code>
   *
   * @return The instanceGroupUri.
   */
  java.lang.String getInstanceGroupUri();
  /**
   *
   *
   * <pre>
   * URI of the instance group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string instance_group_uri = 4;</code>
   *
   * @return The bytes for instanceGroupUri.
   */
  com.google.protobuf.ByteString getInstanceGroupUriBytes();

  /**
   *
   *
   * <pre>
   * URI of the network endpoint group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string network_endpoint_group_uri = 5;</code>
   *
   * @return The networkEndpointGroupUri.
   */
  java.lang.String getNetworkEndpointGroupUri();
  /**
   *
   *
   * <pre>
   * URI of the network endpoint group this backend belongs to (if applicable).
   * </pre>
   *
   * <code>string network_endpoint_group_uri = 5;</code>
   *
   * @return The bytes for networkEndpointGroupUri.
   */
  com.google.protobuf.ByteString getNetworkEndpointGroupUriBytes();

  /**
   *
   *
   * <pre>
   * URI of the backend bucket this backend targets (if applicable).
   * </pre>
   *
   * <code>string backend_bucket_uri = 8;</code>
   *
   * @return The backendBucketUri.
   */
  java.lang.String getBackendBucketUri();
  /**
   *
   *
   * <pre>
   * URI of the backend bucket this backend targets (if applicable).
   * </pre>
   *
   * <code>string backend_bucket_uri = 8;</code>
   *
   * @return The bytes for backendBucketUri.
   */
  com.google.protobuf.ByteString getBackendBucketUriBytes();

  /**
   *
   *
   * <pre>
   * URI of the PSC service attachment this PSC NEG backend targets (if
   * applicable).
   * </pre>
   *
   * <code>string psc_service_attachment_uri = 9;</code>
   *
   * @return The pscServiceAttachmentUri.
   */
  java.lang.String getPscServiceAttachmentUri();
  /**
   *
   *
   * <pre>
   * URI of the PSC service attachment this PSC NEG backend targets (if
   * applicable).
   * </pre>
   *
   * <code>string psc_service_attachment_uri = 9;</code>
   *
   * @return The bytes for pscServiceAttachmentUri.
   */
  com.google.protobuf.ByteString getPscServiceAttachmentUriBytes();

  /**
   *
   *
   * <pre>
   * PSC Google API target this PSC NEG backend targets (if applicable).
   * </pre>
   *
   * <code>string psc_google_api_target = 10;</code>
   *
   * @return The pscGoogleApiTarget.
   */
  java.lang.String getPscGoogleApiTarget();
  /**
   *
   *
   * <pre>
   * PSC Google API target this PSC NEG backend targets (if applicable).
   * </pre>
   *
   * <code>string psc_google_api_target = 10;</code>
   *
   * @return The bytes for pscGoogleApiTarget.
   */
  com.google.protobuf.ByteString getPscGoogleApiTargetBytes();

  /**
   *
   *
   * <pre>
   * URI of the health check attached to this backend (if applicable).
   * </pre>
   *
   * <code>string health_check_uri = 6;</code>
   *
   * @return The healthCheckUri.
   */
  java.lang.String getHealthCheckUri();
  /**
   *
   *
   * <pre>
   * URI of the health check attached to this backend (if applicable).
   * </pre>
   *
   * <code>string health_check_uri = 6;</code>
   *
   * @return The bytes for healthCheckUri.
   */
  com.google.protobuf.ByteString getHealthCheckUriBytes();

  /**
   *
   *
   * <pre>
   * Output only. Health check firewalls configuration state for the backend.
   * This is a result of the static firewall analysis (verifying that health
   * check traffic from required IP ranges to the backend is allowed or not).
   * The backend might still be unhealthy even if these firewalls are
   * configured. Please refer to the documentation for more information:
   * https://cloud.google.com/load-balancing/docs/firewall-rules
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for healthCheckFirewallsConfigState.
   */
  int getHealthCheckFirewallsConfigStateValue();
  /**
   *
   *
   * <pre>
   * Output only. Health check firewalls configuration state for the backend.
   * This is a result of the static firewall analysis (verifying that health
   * check traffic from required IP ranges to the backend is allowed or not).
   * The backend might still be unhealthy even if these firewalls are
   * configured. Please refer to the documentation for more information:
   * https://cloud.google.com/load-balancing/docs/firewall-rules
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState health_check_firewalls_config_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The healthCheckFirewallsConfigState.
   */
  com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState
      getHealthCheckFirewallsConfigState();
}
