/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with NAT.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.NatInfo}
 */
public final class NatInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.NatInfo)
    NatInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NatInfo.newBuilder() to construct.
  private NatInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NatInfo() {
    type_ = 0;
    protocol_ = "";
    networkUri_ = "";
    oldSourceIp_ = "";
    newSourceIp_ = "";
    oldDestinationIp_ = "";
    newDestinationIp_ = "";
    routerUri_ = "";
    natGatewayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NatInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_NatInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_NatInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.NatInfo.class,
            com.google.cloud.networkmanagement.v1.NatInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of NAT.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.NatInfo.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Type is unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * From Compute Engine instance's internal address to external address.
     * </pre>
     *
     * <code>INTERNAL_TO_EXTERNAL = 1;</code>
     */
    INTERNAL_TO_EXTERNAL(1),
    /**
     *
     *
     * <pre>
     * From Compute Engine instance's external address to internal address.
     * </pre>
     *
     * <code>EXTERNAL_TO_INTERNAL = 2;</code>
     */
    EXTERNAL_TO_INTERNAL(2),
    /**
     *
     *
     * <pre>
     * Cloud NAT Gateway.
     * </pre>
     *
     * <code>CLOUD_NAT = 3;</code>
     */
    CLOUD_NAT(3),
    /**
     *
     *
     * <pre>
     * Private service connect NAT.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 4;</code>
     */
    PRIVATE_SERVICE_CONNECT(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Type is unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * From Compute Engine instance's internal address to external address.
     * </pre>
     *
     * <code>INTERNAL_TO_EXTERNAL = 1;</code>
     */
    public static final int INTERNAL_TO_EXTERNAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * From Compute Engine instance's external address to internal address.
     * </pre>
     *
     * <code>EXTERNAL_TO_INTERNAL = 2;</code>
     */
    public static final int EXTERNAL_TO_INTERNAL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Cloud NAT Gateway.
     * </pre>
     *
     * <code>CLOUD_NAT = 3;</code>
     */
    public static final int CLOUD_NAT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Private service connect NAT.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 4;</code>
     */
    public static final int PRIVATE_SERVICE_CONNECT_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return INTERNAL_TO_EXTERNAL;
        case 2:
          return EXTERNAL_TO_INTERNAL;
        case 3:
          return CLOUD_NAT;
        case 4:
          return PRIVATE_SERVICE_CONNECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.NatInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.NatInfo.Type)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Type of NAT.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Type of NAT.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.NatInfo.Type getType() {
    com.google.cloud.networkmanagement.v1.NatInfo.Type result =
        com.google.cloud.networkmanagement.v1.NatInfo.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.NatInfo.Type.UNRECOGNIZED
        : result;
  }

  public static final int PROTOCOL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protocol_ = "";
  /**
   *
   *
   * <pre>
   * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
   * </pre>
   *
   * <code>string protocol = 2;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
   * </pre>
   *
   * <code>string protocol = 2;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the network where NAT translation takes place.
   * </pre>
   *
   * <code>string network_uri = 3;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the network where NAT translation takes place.
   * </pre>
   *
   * <code>string network_uri = 3;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_SOURCE_IP_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object oldSourceIp_ = "";
  /**
   *
   *
   * <pre>
   * Source IP address before NAT translation.
   * </pre>
   *
   * <code>string old_source_ip = 4;</code>
   *
   * @return The oldSourceIp.
   */
  @java.lang.Override
  public java.lang.String getOldSourceIp() {
    java.lang.Object ref = oldSourceIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      oldSourceIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source IP address before NAT translation.
   * </pre>
   *
   * <code>string old_source_ip = 4;</code>
   *
   * @return The bytes for oldSourceIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOldSourceIpBytes() {
    java.lang.Object ref = oldSourceIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      oldSourceIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEW_SOURCE_IP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object newSourceIp_ = "";
  /**
   *
   *
   * <pre>
   * Source IP address after NAT translation.
   * </pre>
   *
   * <code>string new_source_ip = 5;</code>
   *
   * @return The newSourceIp.
   */
  @java.lang.Override
  public java.lang.String getNewSourceIp() {
    java.lang.Object ref = newSourceIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newSourceIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source IP address after NAT translation.
   * </pre>
   *
   * <code>string new_source_ip = 5;</code>
   *
   * @return The bytes for newSourceIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewSourceIpBytes() {
    java.lang.Object ref = newSourceIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newSourceIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_DESTINATION_IP_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object oldDestinationIp_ = "";
  /**
   *
   *
   * <pre>
   * Destination IP address before NAT translation.
   * </pre>
   *
   * <code>string old_destination_ip = 6;</code>
   *
   * @return The oldDestinationIp.
   */
  @java.lang.Override
  public java.lang.String getOldDestinationIp() {
    java.lang.Object ref = oldDestinationIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      oldDestinationIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP address before NAT translation.
   * </pre>
   *
   * <code>string old_destination_ip = 6;</code>
   *
   * @return The bytes for oldDestinationIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOldDestinationIpBytes() {
    java.lang.Object ref = oldDestinationIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      oldDestinationIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEW_DESTINATION_IP_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object newDestinationIp_ = "";
  /**
   *
   *
   * <pre>
   * Destination IP address after NAT translation.
   * </pre>
   *
   * <code>string new_destination_ip = 7;</code>
   *
   * @return The newDestinationIp.
   */
  @java.lang.Override
  public java.lang.String getNewDestinationIp() {
    java.lang.Object ref = newDestinationIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newDestinationIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP address after NAT translation.
   * </pre>
   *
   * <code>string new_destination_ip = 7;</code>
   *
   * @return The bytes for newDestinationIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewDestinationIpBytes() {
    java.lang.Object ref = newDestinationIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newDestinationIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_SOURCE_PORT_FIELD_NUMBER = 8;
  private int oldSourcePort_ = 0;
  /**
   *
   *
   * <pre>
   * Source port before NAT translation. Only valid when protocol is TCP or UDP.
   * </pre>
   *
   * <code>int32 old_source_port = 8;</code>
   *
   * @return The oldSourcePort.
   */
  @java.lang.Override
  public int getOldSourcePort() {
    return oldSourcePort_;
  }

  public static final int NEW_SOURCE_PORT_FIELD_NUMBER = 9;
  private int newSourcePort_ = 0;
  /**
   *
   *
   * <pre>
   * Source port after NAT translation. Only valid when protocol is TCP or UDP.
   * </pre>
   *
   * <code>int32 new_source_port = 9;</code>
   *
   * @return The newSourcePort.
   */
  @java.lang.Override
  public int getNewSourcePort() {
    return newSourcePort_;
  }

  public static final int OLD_DESTINATION_PORT_FIELD_NUMBER = 10;
  private int oldDestinationPort_ = 0;
  /**
   *
   *
   * <pre>
   * Destination port before NAT translation. Only valid when protocol is TCP or
   * UDP.
   * </pre>
   *
   * <code>int32 old_destination_port = 10;</code>
   *
   * @return The oldDestinationPort.
   */
  @java.lang.Override
  public int getOldDestinationPort() {
    return oldDestinationPort_;
  }

  public static final int NEW_DESTINATION_PORT_FIELD_NUMBER = 11;
  private int newDestinationPort_ = 0;
  /**
   *
   *
   * <pre>
   * Destination port after NAT translation. Only valid when protocol is TCP or
   * UDP.
   * </pre>
   *
   * <code>int32 new_destination_port = 11;</code>
   *
   * @return The newDestinationPort.
   */
  @java.lang.Override
  public int getNewDestinationPort() {
    return newDestinationPort_;
  }

  public static final int ROUTER_URI_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routerUri_ = "";
  /**
   *
   *
   * <pre>
   * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
   * </pre>
   *
   * <code>string router_uri = 12;</code>
   *
   * @return The routerUri.
   */
  @java.lang.Override
  public java.lang.String getRouterUri() {
    java.lang.Object ref = routerUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routerUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
   * </pre>
   *
   * <code>string router_uri = 12;</code>
   *
   * @return The bytes for routerUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouterUriBytes() {
    java.lang.Object ref = routerUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routerUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAT_GATEWAY_NAME_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object natGatewayName_ = "";
  /**
   *
   *
   * <pre>
   * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
   * </pre>
   *
   * <code>string nat_gateway_name = 13;</code>
   *
   * @return The natGatewayName.
   */
  @java.lang.Override
  public java.lang.String getNatGatewayName() {
    java.lang.Object ref = natGatewayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      natGatewayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
   * </pre>
   *
   * <code>string nat_gateway_name = 13;</code>
   *
   * @return The bytes for natGatewayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNatGatewayNameBytes() {
    java.lang.Object ref = natGatewayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      natGatewayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.cloud.networkmanagement.v1.NatInfo.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, protocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, networkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldSourceIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, oldSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newSourceIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, newSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldDestinationIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, oldDestinationIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newDestinationIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, newDestinationIp_);
    }
    if (oldSourcePort_ != 0) {
      output.writeInt32(8, oldSourcePort_);
    }
    if (newSourcePort_ != 0) {
      output.writeInt32(9, newSourcePort_);
    }
    if (oldDestinationPort_ != 0) {
      output.writeInt32(10, oldDestinationPort_);
    }
    if (newDestinationPort_ != 0) {
      output.writeInt32(11, newDestinationPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routerUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, routerUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(natGatewayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, natGatewayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.cloud.networkmanagement.v1.NatInfo.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, protocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, networkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldSourceIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, oldSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newSourceIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, newSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldDestinationIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, oldDestinationIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newDestinationIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, newDestinationIp_);
    }
    if (oldSourcePort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, oldSourcePort_);
    }
    if (newSourcePort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, newSourcePort_);
    }
    if (oldDestinationPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, oldDestinationPort_);
    }
    if (newDestinationPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, newDestinationPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routerUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, routerUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(natGatewayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, natGatewayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.NatInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.NatInfo other =
        (com.google.cloud.networkmanagement.v1.NatInfo) obj;

    if (type_ != other.type_) return false;
    if (!getProtocol().equals(other.getProtocol())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getOldSourceIp().equals(other.getOldSourceIp())) return false;
    if (!getNewSourceIp().equals(other.getNewSourceIp())) return false;
    if (!getOldDestinationIp().equals(other.getOldDestinationIp())) return false;
    if (!getNewDestinationIp().equals(other.getNewDestinationIp())) return false;
    if (getOldSourcePort() != other.getOldSourcePort()) return false;
    if (getNewSourcePort() != other.getNewSourcePort()) return false;
    if (getOldDestinationPort() != other.getOldDestinationPort()) return false;
    if (getNewDestinationPort() != other.getNewDestinationPort()) return false;
    if (!getRouterUri().equals(other.getRouterUri())) return false;
    if (!getNatGatewayName().equals(other.getNatGatewayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (37 * hash) + OLD_SOURCE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getOldSourceIp().hashCode();
    hash = (37 * hash) + NEW_SOURCE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getNewSourceIp().hashCode();
    hash = (37 * hash) + OLD_DESTINATION_IP_FIELD_NUMBER;
    hash = (53 * hash) + getOldDestinationIp().hashCode();
    hash = (37 * hash) + NEW_DESTINATION_IP_FIELD_NUMBER;
    hash = (53 * hash) + getNewDestinationIp().hashCode();
    hash = (37 * hash) + OLD_SOURCE_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getOldSourcePort();
    hash = (37 * hash) + NEW_SOURCE_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getNewSourcePort();
    hash = (37 * hash) + OLD_DESTINATION_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getOldDestinationPort();
    hash = (37 * hash) + NEW_DESTINATION_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getNewDestinationPort();
    hash = (37 * hash) + ROUTER_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRouterUri().hashCode();
    hash = (37 * hash) + NAT_GATEWAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getNatGatewayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.NatInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with NAT.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.NatInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.NatInfo)
      com.google.cloud.networkmanagement.v1.NatInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_NatInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_NatInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.NatInfo.class,
              com.google.cloud.networkmanagement.v1.NatInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.NatInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      protocol_ = "";
      networkUri_ = "";
      oldSourceIp_ = "";
      newSourceIp_ = "";
      oldDestinationIp_ = "";
      newDestinationIp_ = "";
      oldSourcePort_ = 0;
      newSourcePort_ = 0;
      oldDestinationPort_ = 0;
      newDestinationPort_ = 0;
      routerUri_ = "";
      natGatewayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_NatInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NatInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NatInfo build() {
      com.google.cloud.networkmanagement.v1.NatInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NatInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.NatInfo result =
          new com.google.cloud.networkmanagement.v1.NatInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.NatInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.protocol_ = protocol_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.networkUri_ = networkUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.oldSourceIp_ = oldSourceIp_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.newSourceIp_ = newSourceIp_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.oldDestinationIp_ = oldDestinationIp_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.newDestinationIp_ = newDestinationIp_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.oldSourcePort_ = oldSourcePort_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.newSourcePort_ = newSourcePort_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.oldDestinationPort_ = oldDestinationPort_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.newDestinationPort_ = newDestinationPort_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.routerUri_ = routerUri_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.natGatewayName_ = natGatewayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.NatInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.NatInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.NatInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getOldSourceIp().isEmpty()) {
        oldSourceIp_ = other.oldSourceIp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getNewSourceIp().isEmpty()) {
        newSourceIp_ = other.newSourceIp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getOldDestinationIp().isEmpty()) {
        oldDestinationIp_ = other.oldDestinationIp_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getNewDestinationIp().isEmpty()) {
        newDestinationIp_ = other.newDestinationIp_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getOldSourcePort() != 0) {
        setOldSourcePort(other.getOldSourcePort());
      }
      if (other.getNewSourcePort() != 0) {
        setNewSourcePort(other.getNewSourcePort());
      }
      if (other.getOldDestinationPort() != 0) {
        setOldDestinationPort(other.getOldDestinationPort());
      }
      if (other.getNewDestinationPort() != 0) {
        setNewDestinationPort(other.getNewDestinationPort());
      }
      if (!other.getRouterUri().isEmpty()) {
        routerUri_ = other.routerUri_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getNatGatewayName().isEmpty()) {
        natGatewayName_ = other.natGatewayName_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                protocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                oldSourceIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                newSourceIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                oldDestinationIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                newDestinationIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                oldSourcePort_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                newSourcePort_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                oldDestinationPort_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                newDestinationPort_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                routerUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                natGatewayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Type of NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Type of NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NatInfo.Type getType() {
      com.google.cloud.networkmanagement.v1.NatInfo.Type result =
          com.google.cloud.networkmanagement.v1.NatInfo.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.NatInfo.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.networkmanagement.v1.NatInfo.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo.Type type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 2;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 2;</code>
     *
     * @return The bytes for protocol.
     */
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 2;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protocol_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {
      protocol_ = getDefaultInstance().getProtocol();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 2;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protocol_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the network where NAT translation takes place.
     * </pre>
     *
     * <code>string network_uri = 3;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where NAT translation takes place.
     * </pre>
     *
     * <code>string network_uri = 3;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where NAT translation takes place.
     * </pre>
     *
     * <code>string network_uri = 3;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where NAT translation takes place.
     * </pre>
     *
     * <code>string network_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where NAT translation takes place.
     * </pre>
     *
     * <code>string network_uri = 3;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object oldSourceIp_ = "";
    /**
     *
     *
     * <pre>
     * Source IP address before NAT translation.
     * </pre>
     *
     * <code>string old_source_ip = 4;</code>
     *
     * @return The oldSourceIp.
     */
    public java.lang.String getOldSourceIp() {
      java.lang.Object ref = oldSourceIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oldSourceIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address before NAT translation.
     * </pre>
     *
     * <code>string old_source_ip = 4;</code>
     *
     * @return The bytes for oldSourceIp.
     */
    public com.google.protobuf.ByteString getOldSourceIpBytes() {
      java.lang.Object ref = oldSourceIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        oldSourceIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address before NAT translation.
     * </pre>
     *
     * <code>string old_source_ip = 4;</code>
     *
     * @param value The oldSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldSourceIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      oldSourceIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address before NAT translation.
     * </pre>
     *
     * <code>string old_source_ip = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldSourceIp() {
      oldSourceIp_ = getDefaultInstance().getOldSourceIp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address before NAT translation.
     * </pre>
     *
     * <code>string old_source_ip = 4;</code>
     *
     * @param value The bytes for oldSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldSourceIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      oldSourceIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object newSourceIp_ = "";
    /**
     *
     *
     * <pre>
     * Source IP address after NAT translation.
     * </pre>
     *
     * <code>string new_source_ip = 5;</code>
     *
     * @return The newSourceIp.
     */
    public java.lang.String getNewSourceIp() {
      java.lang.Object ref = newSourceIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newSourceIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address after NAT translation.
     * </pre>
     *
     * <code>string new_source_ip = 5;</code>
     *
     * @return The bytes for newSourceIp.
     */
    public com.google.protobuf.ByteString getNewSourceIpBytes() {
      java.lang.Object ref = newSourceIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newSourceIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address after NAT translation.
     * </pre>
     *
     * <code>string new_source_ip = 5;</code>
     *
     * @param value The newSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewSourceIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newSourceIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address after NAT translation.
     * </pre>
     *
     * <code>string new_source_ip = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewSourceIp() {
      newSourceIp_ = getDefaultInstance().getNewSourceIp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address after NAT translation.
     * </pre>
     *
     * <code>string new_source_ip = 5;</code>
     *
     * @param value The bytes for newSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewSourceIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      newSourceIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object oldDestinationIp_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP address before NAT translation.
     * </pre>
     *
     * <code>string old_destination_ip = 6;</code>
     *
     * @return The oldDestinationIp.
     */
    public java.lang.String getOldDestinationIp() {
      java.lang.Object ref = oldDestinationIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oldDestinationIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address before NAT translation.
     * </pre>
     *
     * <code>string old_destination_ip = 6;</code>
     *
     * @return The bytes for oldDestinationIp.
     */
    public com.google.protobuf.ByteString getOldDestinationIpBytes() {
      java.lang.Object ref = oldDestinationIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        oldDestinationIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address before NAT translation.
     * </pre>
     *
     * <code>string old_destination_ip = 6;</code>
     *
     * @param value The oldDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldDestinationIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      oldDestinationIp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address before NAT translation.
     * </pre>
     *
     * <code>string old_destination_ip = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldDestinationIp() {
      oldDestinationIp_ = getDefaultInstance().getOldDestinationIp();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address before NAT translation.
     * </pre>
     *
     * <code>string old_destination_ip = 6;</code>
     *
     * @param value The bytes for oldDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldDestinationIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      oldDestinationIp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object newDestinationIp_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP address after NAT translation.
     * </pre>
     *
     * <code>string new_destination_ip = 7;</code>
     *
     * @return The newDestinationIp.
     */
    public java.lang.String getNewDestinationIp() {
      java.lang.Object ref = newDestinationIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newDestinationIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address after NAT translation.
     * </pre>
     *
     * <code>string new_destination_ip = 7;</code>
     *
     * @return The bytes for newDestinationIp.
     */
    public com.google.protobuf.ByteString getNewDestinationIpBytes() {
      java.lang.Object ref = newDestinationIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newDestinationIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address after NAT translation.
     * </pre>
     *
     * <code>string new_destination_ip = 7;</code>
     *
     * @param value The newDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewDestinationIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newDestinationIp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address after NAT translation.
     * </pre>
     *
     * <code>string new_destination_ip = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewDestinationIp() {
      newDestinationIp_ = getDefaultInstance().getNewDestinationIp();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address after NAT translation.
     * </pre>
     *
     * <code>string new_destination_ip = 7;</code>
     *
     * @param value The bytes for newDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewDestinationIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      newDestinationIp_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int oldSourcePort_;
    /**
     *
     *
     * <pre>
     * Source port before NAT translation. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 old_source_port = 8;</code>
     *
     * @return The oldSourcePort.
     */
    @java.lang.Override
    public int getOldSourcePort() {
      return oldSourcePort_;
    }
    /**
     *
     *
     * <pre>
     * Source port before NAT translation. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 old_source_port = 8;</code>
     *
     * @param value The oldSourcePort to set.
     * @return This builder for chaining.
     */
    public Builder setOldSourcePort(int value) {

      oldSourcePort_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port before NAT translation. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 old_source_port = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldSourcePort() {
      bitField0_ = (bitField0_ & ~0x00000080);
      oldSourcePort_ = 0;
      onChanged();
      return this;
    }

    private int newSourcePort_;
    /**
     *
     *
     * <pre>
     * Source port after NAT translation. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 new_source_port = 9;</code>
     *
     * @return The newSourcePort.
     */
    @java.lang.Override
    public int getNewSourcePort() {
      return newSourcePort_;
    }
    /**
     *
     *
     * <pre>
     * Source port after NAT translation. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 new_source_port = 9;</code>
     *
     * @param value The newSourcePort to set.
     * @return This builder for chaining.
     */
    public Builder setNewSourcePort(int value) {

      newSourcePort_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port after NAT translation. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 new_source_port = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewSourcePort() {
      bitField0_ = (bitField0_ & ~0x00000100);
      newSourcePort_ = 0;
      onChanged();
      return this;
    }

    private int oldDestinationPort_;
    /**
     *
     *
     * <pre>
     * Destination port before NAT translation. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 old_destination_port = 10;</code>
     *
     * @return The oldDestinationPort.
     */
    @java.lang.Override
    public int getOldDestinationPort() {
      return oldDestinationPort_;
    }
    /**
     *
     *
     * <pre>
     * Destination port before NAT translation. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 old_destination_port = 10;</code>
     *
     * @param value The oldDestinationPort to set.
     * @return This builder for chaining.
     */
    public Builder setOldDestinationPort(int value) {

      oldDestinationPort_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port before NAT translation. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 old_destination_port = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldDestinationPort() {
      bitField0_ = (bitField0_ & ~0x00000200);
      oldDestinationPort_ = 0;
      onChanged();
      return this;
    }

    private int newDestinationPort_;
    /**
     *
     *
     * <pre>
     * Destination port after NAT translation. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 new_destination_port = 11;</code>
     *
     * @return The newDestinationPort.
     */
    @java.lang.Override
    public int getNewDestinationPort() {
      return newDestinationPort_;
    }
    /**
     *
     *
     * <pre>
     * Destination port after NAT translation. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 new_destination_port = 11;</code>
     *
     * @param value The newDestinationPort to set.
     * @return This builder for chaining.
     */
    public Builder setNewDestinationPort(int value) {

      newDestinationPort_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port after NAT translation. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 new_destination_port = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewDestinationPort() {
      bitField0_ = (bitField0_ & ~0x00000400);
      newDestinationPort_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object routerUri_ = "";
    /**
     *
     *
     * <pre>
     * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string router_uri = 12;</code>
     *
     * @return The routerUri.
     */
    public java.lang.String getRouterUri() {
      java.lang.Object ref = routerUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routerUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string router_uri = 12;</code>
     *
     * @return The bytes for routerUri.
     */
    public com.google.protobuf.ByteString getRouterUriBytes() {
      java.lang.Object ref = routerUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routerUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string router_uri = 12;</code>
     *
     * @param value The routerUri to set.
     * @return This builder for chaining.
     */
    public Builder setRouterUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routerUri_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string router_uri = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouterUri() {
      routerUri_ = getDefaultInstance().getRouterUri();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string router_uri = 12;</code>
     *
     * @param value The bytes for routerUri to set.
     * @return This builder for chaining.
     */
    public Builder setRouterUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routerUri_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object natGatewayName_ = "";
    /**
     *
     *
     * <pre>
     * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string nat_gateway_name = 13;</code>
     *
     * @return The natGatewayName.
     */
    public java.lang.String getNatGatewayName() {
      java.lang.Object ref = natGatewayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        natGatewayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string nat_gateway_name = 13;</code>
     *
     * @return The bytes for natGatewayName.
     */
    public com.google.protobuf.ByteString getNatGatewayNameBytes() {
      java.lang.Object ref = natGatewayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        natGatewayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string nat_gateway_name = 13;</code>
     *
     * @param value The natGatewayName to set.
     * @return This builder for chaining.
     */
    public Builder setNatGatewayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      natGatewayName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string nat_gateway_name = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatGatewayName() {
      natGatewayName_ = getDefaultInstance().getNatGatewayName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
     * </pre>
     *
     * <code>string nat_gateway_name = 13;</code>
     *
     * @param value The bytes for natGatewayName to set.
     * @return This builder for chaining.
     */
    public Builder setNatGatewayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      natGatewayName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.NatInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.NatInfo)
  private static final com.google.cloud.networkmanagement.v1.NatInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.NatInfo();
  }

  public static com.google.cloud.networkmanagement.v1.NatInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NatInfo> PARSER =
      new com.google.protobuf.AbstractParser<NatInfo>() {
        @java.lang.Override
        public NatInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NatInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NatInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.NatInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
