/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with ProxyConnection.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.ProxyConnectionInfo}
 */
public final class ProxyConnectionInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.ProxyConnectionInfo)
    ProxyConnectionInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProxyConnectionInfo.newBuilder() to construct.
  private ProxyConnectionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProxyConnectionInfo() {
    protocol_ = "";
    oldSourceIp_ = "";
    newSourceIp_ = "";
    oldDestinationIp_ = "";
    newDestinationIp_ = "";
    subnetUri_ = "";
    networkUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProxyConnectionInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_ProxyConnectionInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_ProxyConnectionInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.class,
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder.class);
  }

  public static final int PROTOCOL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protocol_ = "";
  /**
   *
   *
   * <pre>
   * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
   * </pre>
   *
   * <code>string protocol = 1;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
   * </pre>
   *
   * <code>string protocol = 1;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_SOURCE_IP_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object oldSourceIp_ = "";
  /**
   *
   *
   * <pre>
   * Source IP address of an original connection.
   * </pre>
   *
   * <code>string old_source_ip = 2;</code>
   *
   * @return The oldSourceIp.
   */
  @java.lang.Override
  public java.lang.String getOldSourceIp() {
    java.lang.Object ref = oldSourceIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      oldSourceIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source IP address of an original connection.
   * </pre>
   *
   * <code>string old_source_ip = 2;</code>
   *
   * @return The bytes for oldSourceIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOldSourceIpBytes() {
    java.lang.Object ref = oldSourceIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      oldSourceIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEW_SOURCE_IP_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object newSourceIp_ = "";
  /**
   *
   *
   * <pre>
   * Source IP address of a new connection.
   * </pre>
   *
   * <code>string new_source_ip = 3;</code>
   *
   * @return The newSourceIp.
   */
  @java.lang.Override
  public java.lang.String getNewSourceIp() {
    java.lang.Object ref = newSourceIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newSourceIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source IP address of a new connection.
   * </pre>
   *
   * <code>string new_source_ip = 3;</code>
   *
   * @return The bytes for newSourceIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewSourceIpBytes() {
    java.lang.Object ref = newSourceIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newSourceIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_DESTINATION_IP_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object oldDestinationIp_ = "";
  /**
   *
   *
   * <pre>
   * Destination IP address of an original connection
   * </pre>
   *
   * <code>string old_destination_ip = 4;</code>
   *
   * @return The oldDestinationIp.
   */
  @java.lang.Override
  public java.lang.String getOldDestinationIp() {
    java.lang.Object ref = oldDestinationIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      oldDestinationIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP address of an original connection
   * </pre>
   *
   * <code>string old_destination_ip = 4;</code>
   *
   * @return The bytes for oldDestinationIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOldDestinationIpBytes() {
    java.lang.Object ref = oldDestinationIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      oldDestinationIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEW_DESTINATION_IP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object newDestinationIp_ = "";
  /**
   *
   *
   * <pre>
   * Destination IP address of a new connection.
   * </pre>
   *
   * <code>string new_destination_ip = 5;</code>
   *
   * @return The newDestinationIp.
   */
  @java.lang.Override
  public java.lang.String getNewDestinationIp() {
    java.lang.Object ref = newDestinationIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newDestinationIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP address of a new connection.
   * </pre>
   *
   * <code>string new_destination_ip = 5;</code>
   *
   * @return The bytes for newDestinationIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewDestinationIpBytes() {
    java.lang.Object ref = newDestinationIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newDestinationIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLD_SOURCE_PORT_FIELD_NUMBER = 6;
  private int oldSourcePort_ = 0;
  /**
   *
   *
   * <pre>
   * Source port of an original connection. Only valid when protocol is TCP or
   * UDP.
   * </pre>
   *
   * <code>int32 old_source_port = 6;</code>
   *
   * @return The oldSourcePort.
   */
  @java.lang.Override
  public int getOldSourcePort() {
    return oldSourcePort_;
  }

  public static final int NEW_SOURCE_PORT_FIELD_NUMBER = 7;
  private int newSourcePort_ = 0;
  /**
   *
   *
   * <pre>
   * Source port of a new connection. Only valid when protocol is TCP or UDP.
   * </pre>
   *
   * <code>int32 new_source_port = 7;</code>
   *
   * @return The newSourcePort.
   */
  @java.lang.Override
  public int getNewSourcePort() {
    return newSourcePort_;
  }

  public static final int OLD_DESTINATION_PORT_FIELD_NUMBER = 8;
  private int oldDestinationPort_ = 0;
  /**
   *
   *
   * <pre>
   * Destination port of an original connection. Only valid when protocol is TCP
   * or UDP.
   * </pre>
   *
   * <code>int32 old_destination_port = 8;</code>
   *
   * @return The oldDestinationPort.
   */
  @java.lang.Override
  public int getOldDestinationPort() {
    return oldDestinationPort_;
  }

  public static final int NEW_DESTINATION_PORT_FIELD_NUMBER = 9;
  private int newDestinationPort_ = 0;
  /**
   *
   *
   * <pre>
   * Destination port of a new connection. Only valid when protocol is TCP or
   * UDP.
   * </pre>
   *
   * <code>int32 new_destination_port = 9;</code>
   *
   * @return The newDestinationPort.
   */
  @java.lang.Override
  public int getNewDestinationPort() {
    return newDestinationPort_;
  }

  public static final int SUBNET_URI_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetUri_ = "";
  /**
   *
   *
   * <pre>
   * Uri of proxy subnet.
   * </pre>
   *
   * <code>string subnet_uri = 10;</code>
   *
   * @return The subnetUri.
   */
  @java.lang.Override
  public java.lang.String getSubnetUri() {
    java.lang.Object ref = subnetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Uri of proxy subnet.
   * </pre>
   *
   * <code>string subnet_uri = 10;</code>
   *
   * @return The bytes for subnetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetUriBytes() {
    java.lang.Object ref = subnetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the network where connection is proxied.
   * </pre>
   *
   * <code>string network_uri = 11;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the network where connection is proxied.
   * </pre>
   *
   * <code>string network_uri = 11;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, protocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldSourceIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, oldSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newSourceIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, newSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldDestinationIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, oldDestinationIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newDestinationIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, newDestinationIp_);
    }
    if (oldSourcePort_ != 0) {
      output.writeInt32(6, oldSourcePort_);
    }
    if (newSourcePort_ != 0) {
      output.writeInt32(7, newSourcePort_);
    }
    if (oldDestinationPort_ != 0) {
      output.writeInt32(8, oldDestinationPort_);
    }
    if (newDestinationPort_ != 0) {
      output.writeInt32(9, newDestinationPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, subnetUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, networkUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, protocol_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldSourceIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, oldSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newSourceIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, newSourceIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oldDestinationIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, oldDestinationIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newDestinationIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, newDestinationIp_);
    }
    if (oldSourcePort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, oldSourcePort_);
    }
    if (newSourcePort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, newSourcePort_);
    }
    if (oldDestinationPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, oldDestinationPort_);
    }
    if (newDestinationPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, newDestinationPort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, subnetUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, networkUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.ProxyConnectionInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.ProxyConnectionInfo other =
        (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) obj;

    if (!getProtocol().equals(other.getProtocol())) return false;
    if (!getOldSourceIp().equals(other.getOldSourceIp())) return false;
    if (!getNewSourceIp().equals(other.getNewSourceIp())) return false;
    if (!getOldDestinationIp().equals(other.getOldDestinationIp())) return false;
    if (!getNewDestinationIp().equals(other.getNewDestinationIp())) return false;
    if (getOldSourcePort() != other.getOldSourcePort()) return false;
    if (getNewSourcePort() != other.getNewSourcePort()) return false;
    if (getOldDestinationPort() != other.getOldDestinationPort()) return false;
    if (getNewDestinationPort() != other.getNewDestinationPort()) return false;
    if (!getSubnetUri().equals(other.getSubnetUri())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    hash = (37 * hash) + OLD_SOURCE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getOldSourceIp().hashCode();
    hash = (37 * hash) + NEW_SOURCE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getNewSourceIp().hashCode();
    hash = (37 * hash) + OLD_DESTINATION_IP_FIELD_NUMBER;
    hash = (53 * hash) + getOldDestinationIp().hashCode();
    hash = (37 * hash) + NEW_DESTINATION_IP_FIELD_NUMBER;
    hash = (53 * hash) + getNewDestinationIp().hashCode();
    hash = (37 * hash) + OLD_SOURCE_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getOldSourcePort();
    hash = (37 * hash) + NEW_SOURCE_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getNewSourcePort();
    hash = (37 * hash) + OLD_DESTINATION_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getOldDestinationPort();
    hash = (37 * hash) + NEW_DESTINATION_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getNewDestinationPort();
    hash = (37 * hash) + SUBNET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetUri().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1.ProxyConnectionInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with ProxyConnection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.ProxyConnectionInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.ProxyConnectionInfo)
      com.google.cloud.networkmanagement.v1.ProxyConnectionInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_ProxyConnectionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_ProxyConnectionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.class,
              com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      protocol_ = "";
      oldSourceIp_ = "";
      newSourceIp_ = "";
      oldDestinationIp_ = "";
      newDestinationIp_ = "";
      oldSourcePort_ = 0;
      newSourcePort_ = 0;
      oldDestinationPort_ = 0;
      newDestinationPort_ = 0;
      subnetUri_ = "";
      networkUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_ProxyConnectionInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo build() {
      com.google.cloud.networkmanagement.v1.ProxyConnectionInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.ProxyConnectionInfo result =
          new com.google.cloud.networkmanagement.v1.ProxyConnectionInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.ProxyConnectionInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.protocol_ = protocol_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.oldSourceIp_ = oldSourceIp_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.newSourceIp_ = newSourceIp_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.oldDestinationIp_ = oldDestinationIp_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.newDestinationIp_ = newDestinationIp_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.oldSourcePort_ = oldSourcePort_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.newSourcePort_ = newSourcePort_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.oldDestinationPort_ = oldDestinationPort_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.newDestinationPort_ = newDestinationPort_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.subnetUri_ = subnetUri_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.networkUri_ = networkUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.ProxyConnectionInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance())
        return this;
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getOldSourceIp().isEmpty()) {
        oldSourceIp_ = other.oldSourceIp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getNewSourceIp().isEmpty()) {
        newSourceIp_ = other.newSourceIp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getOldDestinationIp().isEmpty()) {
        oldDestinationIp_ = other.oldDestinationIp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getNewDestinationIp().isEmpty()) {
        newDestinationIp_ = other.newDestinationIp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getOldSourcePort() != 0) {
        setOldSourcePort(other.getOldSourcePort());
      }
      if (other.getNewSourcePort() != 0) {
        setNewSourcePort(other.getNewSourcePort());
      }
      if (other.getOldDestinationPort() != 0) {
        setOldDestinationPort(other.getOldDestinationPort());
      }
      if (other.getNewDestinationPort() != 0) {
        setNewDestinationPort(other.getNewDestinationPort());
      }
      if (!other.getSubnetUri().isEmpty()) {
        subnetUri_ = other.subnetUri_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                protocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                oldSourceIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                newSourceIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                oldDestinationIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                newDestinationIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                oldSourcePort_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                newSourcePort_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                oldDestinationPort_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                newDestinationPort_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                subnetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @return The bytes for protocol.
     */
    public com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protocol_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {
      protocol_ = getDefaultInstance().getProtocol();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP protocol in string format, for example: "TCP", "UDP", "ICMP".
     * </pre>
     *
     * <code>string protocol = 1;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protocol_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object oldSourceIp_ = "";
    /**
     *
     *
     * <pre>
     * Source IP address of an original connection.
     * </pre>
     *
     * <code>string old_source_ip = 2;</code>
     *
     * @return The oldSourceIp.
     */
    public java.lang.String getOldSourceIp() {
      java.lang.Object ref = oldSourceIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oldSourceIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address of an original connection.
     * </pre>
     *
     * <code>string old_source_ip = 2;</code>
     *
     * @return The bytes for oldSourceIp.
     */
    public com.google.protobuf.ByteString getOldSourceIpBytes() {
      java.lang.Object ref = oldSourceIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        oldSourceIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address of an original connection.
     * </pre>
     *
     * <code>string old_source_ip = 2;</code>
     *
     * @param value The oldSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldSourceIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      oldSourceIp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address of an original connection.
     * </pre>
     *
     * <code>string old_source_ip = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldSourceIp() {
      oldSourceIp_ = getDefaultInstance().getOldSourceIp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address of an original connection.
     * </pre>
     *
     * <code>string old_source_ip = 2;</code>
     *
     * @param value The bytes for oldSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldSourceIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      oldSourceIp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object newSourceIp_ = "";
    /**
     *
     *
     * <pre>
     * Source IP address of a new connection.
     * </pre>
     *
     * <code>string new_source_ip = 3;</code>
     *
     * @return The newSourceIp.
     */
    public java.lang.String getNewSourceIp() {
      java.lang.Object ref = newSourceIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newSourceIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address of a new connection.
     * </pre>
     *
     * <code>string new_source_ip = 3;</code>
     *
     * @return The bytes for newSourceIp.
     */
    public com.google.protobuf.ByteString getNewSourceIpBytes() {
      java.lang.Object ref = newSourceIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newSourceIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source IP address of a new connection.
     * </pre>
     *
     * <code>string new_source_ip = 3;</code>
     *
     * @param value The newSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewSourceIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newSourceIp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address of a new connection.
     * </pre>
     *
     * <code>string new_source_ip = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewSourceIp() {
      newSourceIp_ = getDefaultInstance().getNewSourceIp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source IP address of a new connection.
     * </pre>
     *
     * <code>string new_source_ip = 3;</code>
     *
     * @param value The bytes for newSourceIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewSourceIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      newSourceIp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object oldDestinationIp_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP address of an original connection
     * </pre>
     *
     * <code>string old_destination_ip = 4;</code>
     *
     * @return The oldDestinationIp.
     */
    public java.lang.String getOldDestinationIp() {
      java.lang.Object ref = oldDestinationIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oldDestinationIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of an original connection
     * </pre>
     *
     * <code>string old_destination_ip = 4;</code>
     *
     * @return The bytes for oldDestinationIp.
     */
    public com.google.protobuf.ByteString getOldDestinationIpBytes() {
      java.lang.Object ref = oldDestinationIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        oldDestinationIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of an original connection
     * </pre>
     *
     * <code>string old_destination_ip = 4;</code>
     *
     * @param value The oldDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldDestinationIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      oldDestinationIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of an original connection
     * </pre>
     *
     * <code>string old_destination_ip = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldDestinationIp() {
      oldDestinationIp_ = getDefaultInstance().getOldDestinationIp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of an original connection
     * </pre>
     *
     * <code>string old_destination_ip = 4;</code>
     *
     * @param value The bytes for oldDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setOldDestinationIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      oldDestinationIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object newDestinationIp_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP address of a new connection.
     * </pre>
     *
     * <code>string new_destination_ip = 5;</code>
     *
     * @return The newDestinationIp.
     */
    public java.lang.String getNewDestinationIp() {
      java.lang.Object ref = newDestinationIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newDestinationIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of a new connection.
     * </pre>
     *
     * <code>string new_destination_ip = 5;</code>
     *
     * @return The bytes for newDestinationIp.
     */
    public com.google.protobuf.ByteString getNewDestinationIpBytes() {
      java.lang.Object ref = newDestinationIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newDestinationIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of a new connection.
     * </pre>
     *
     * <code>string new_destination_ip = 5;</code>
     *
     * @param value The newDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewDestinationIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newDestinationIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of a new connection.
     * </pre>
     *
     * <code>string new_destination_ip = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewDestinationIp() {
      newDestinationIp_ = getDefaultInstance().getNewDestinationIp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP address of a new connection.
     * </pre>
     *
     * <code>string new_destination_ip = 5;</code>
     *
     * @param value The bytes for newDestinationIp to set.
     * @return This builder for chaining.
     */
    public Builder setNewDestinationIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      newDestinationIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int oldSourcePort_;
    /**
     *
     *
     * <pre>
     * Source port of an original connection. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 old_source_port = 6;</code>
     *
     * @return The oldSourcePort.
     */
    @java.lang.Override
    public int getOldSourcePort() {
      return oldSourcePort_;
    }
    /**
     *
     *
     * <pre>
     * Source port of an original connection. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 old_source_port = 6;</code>
     *
     * @param value The oldSourcePort to set.
     * @return This builder for chaining.
     */
    public Builder setOldSourcePort(int value) {

      oldSourcePort_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port of an original connection. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 old_source_port = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldSourcePort() {
      bitField0_ = (bitField0_ & ~0x00000020);
      oldSourcePort_ = 0;
      onChanged();
      return this;
    }

    private int newSourcePort_;
    /**
     *
     *
     * <pre>
     * Source port of a new connection. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 new_source_port = 7;</code>
     *
     * @return The newSourcePort.
     */
    @java.lang.Override
    public int getNewSourcePort() {
      return newSourcePort_;
    }
    /**
     *
     *
     * <pre>
     * Source port of a new connection. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 new_source_port = 7;</code>
     *
     * @param value The newSourcePort to set.
     * @return This builder for chaining.
     */
    public Builder setNewSourcePort(int value) {

      newSourcePort_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source port of a new connection. Only valid when protocol is TCP or UDP.
     * </pre>
     *
     * <code>int32 new_source_port = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewSourcePort() {
      bitField0_ = (bitField0_ & ~0x00000040);
      newSourcePort_ = 0;
      onChanged();
      return this;
    }

    private int oldDestinationPort_;
    /**
     *
     *
     * <pre>
     * Destination port of an original connection. Only valid when protocol is TCP
     * or UDP.
     * </pre>
     *
     * <code>int32 old_destination_port = 8;</code>
     *
     * @return The oldDestinationPort.
     */
    @java.lang.Override
    public int getOldDestinationPort() {
      return oldDestinationPort_;
    }
    /**
     *
     *
     * <pre>
     * Destination port of an original connection. Only valid when protocol is TCP
     * or UDP.
     * </pre>
     *
     * <code>int32 old_destination_port = 8;</code>
     *
     * @param value The oldDestinationPort to set.
     * @return This builder for chaining.
     */
    public Builder setOldDestinationPort(int value) {

      oldDestinationPort_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port of an original connection. Only valid when protocol is TCP
     * or UDP.
     * </pre>
     *
     * <code>int32 old_destination_port = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOldDestinationPort() {
      bitField0_ = (bitField0_ & ~0x00000080);
      oldDestinationPort_ = 0;
      onChanged();
      return this;
    }

    private int newDestinationPort_;
    /**
     *
     *
     * <pre>
     * Destination port of a new connection. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 new_destination_port = 9;</code>
     *
     * @return The newDestinationPort.
     */
    @java.lang.Override
    public int getNewDestinationPort() {
      return newDestinationPort_;
    }
    /**
     *
     *
     * <pre>
     * Destination port of a new connection. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 new_destination_port = 9;</code>
     *
     * @param value The newDestinationPort to set.
     * @return This builder for chaining.
     */
    public Builder setNewDestinationPort(int value) {

      newDestinationPort_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination port of a new connection. Only valid when protocol is TCP or
     * UDP.
     * </pre>
     *
     * <code>int32 new_destination_port = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewDestinationPort() {
      bitField0_ = (bitField0_ & ~0x00000100);
      newDestinationPort_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object subnetUri_ = "";
    /**
     *
     *
     * <pre>
     * Uri of proxy subnet.
     * </pre>
     *
     * <code>string subnet_uri = 10;</code>
     *
     * @return The subnetUri.
     */
    public java.lang.String getSubnetUri() {
      java.lang.Object ref = subnetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri of proxy subnet.
     * </pre>
     *
     * <code>string subnet_uri = 10;</code>
     *
     * @return The bytes for subnetUri.
     */
    public com.google.protobuf.ByteString getSubnetUriBytes() {
      java.lang.Object ref = subnetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri of proxy subnet.
     * </pre>
     *
     * <code>string subnet_uri = 10;</code>
     *
     * @param value The subnetUri to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uri of proxy subnet.
     * </pre>
     *
     * <code>string subnet_uri = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetUri() {
      subnetUri_ = getDefaultInstance().getSubnetUri();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uri of proxy subnet.
     * </pre>
     *
     * <code>string subnet_uri = 10;</code>
     *
     * @param value The bytes for subnetUri to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the network where connection is proxied.
     * </pre>
     *
     * <code>string network_uri = 11;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where connection is proxied.
     * </pre>
     *
     * <code>string network_uri = 11;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the network where connection is proxied.
     * </pre>
     *
     * <code>string network_uri = 11;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where connection is proxied.
     * </pre>
     *
     * <code>string network_uri = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the network where connection is proxied.
     * </pre>
     *
     * <code>string network_uri = 11;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.ProxyConnectionInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.ProxyConnectionInfo)
  private static final com.google.cloud.networkmanagement.v1.ProxyConnectionInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.ProxyConnectionInfo();
  }

  public static com.google.cloud.networkmanagement.v1.ProxyConnectionInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProxyConnectionInfo> PARSER =
      new com.google.protobuf.AbstractParser<ProxyConnectionInfo>() {
        @java.lang.Override
        public ProxyConnectionInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProxyConnectionInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProxyConnectionInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
