/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * A simulated forwarding path is composed of multiple steps.
 * Each step has a well-defined state and an associated configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.Step}
 */
public final class Step extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.Step)
    StepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Step.newBuilder() to construct.
  private Step(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Step() {
    description_ = "";
    state_ = 0;
    projectId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Step();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_Step_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_Step_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.Step.class,
            com.google.cloud.networkmanagement.v1.Step.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of states that are defined in the network state machine.
   * Each step in the packet trace is in a specific state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.Step.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Compute Engine instance.
     * An InstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_INSTANCE = 1;</code>
     */
    START_FROM_INSTANCE(1),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from the internet.
     * The endpoint information is populated.
     * </pre>
     *
     * <code>START_FROM_INTERNET = 2;</code>
     */
    START_FROM_INTERNET(2),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Google service.
     * The google_service information is populated.
     * </pre>
     *
     * <code>START_FROM_GOOGLE_SERVICE = 27;</code>
     */
    START_FROM_GOOGLE_SERVICE(27),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a VPC or on-premises network
     * with internal source IP.
     * If the source is a VPC network visible to the user, a NetworkInfo
     * is populated with details of the network.
     * </pre>
     *
     * <code>START_FROM_PRIVATE_NETWORK = 3;</code>
     */
    START_FROM_PRIVATE_NETWORK(3),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Google Kubernetes Engine cluster
     * master. A GKEMasterInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_GKE_MASTER = 21;</code>
     */
    START_FROM_GKE_MASTER(21),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud SQL instance.
     * A CloudSQLInstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_SQL_INSTANCE = 22;</code>
     */
    START_FROM_CLOUD_SQL_INSTANCE(22),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud Function.
     * A CloudFunctionInfo is populated with starting function information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_FUNCTION = 23;</code>
     */
    START_FROM_CLOUD_FUNCTION(23),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from an App Engine service version.
     * An AppEngineVersionInfo is populated with starting version information.
     * </pre>
     *
     * <code>START_FROM_APP_ENGINE_VERSION = 25;</code>
     */
    START_FROM_APP_ENGINE_VERSION(25),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud Run revision.
     * A CloudRunRevisionInfo is populated with starting revision information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_RUN_REVISION = 26;</code>
     */
    START_FROM_CLOUD_RUN_REVISION(26),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Storage Bucket. Used only for
     * return traces.
     * The storage_bucket information is populated.
     * </pre>
     *
     * <code>START_FROM_STORAGE_BUCKET = 29;</code>
     */
    START_FROM_STORAGE_BUCKET(29),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a published service that uses
     * Private Service Connect. Used only for return traces.
     * </pre>
     *
     * <code>START_FROM_PSC_PUBLISHED_SERVICE = 30;</code>
     */
    START_FROM_PSC_PUBLISHED_SERVICE(30),
    /**
     *
     *
     * <pre>
     * Config checking state: verify ingress firewall rule.
     * </pre>
     *
     * <code>APPLY_INGRESS_FIREWALL_RULE = 4;</code>
     */
    APPLY_INGRESS_FIREWALL_RULE(4),
    /**
     *
     *
     * <pre>
     * Config checking state: verify egress firewall rule.
     * </pre>
     *
     * <code>APPLY_EGRESS_FIREWALL_RULE = 5;</code>
     */
    APPLY_EGRESS_FIREWALL_RULE(5),
    /**
     *
     *
     * <pre>
     * Config checking state: verify route.
     * </pre>
     *
     * <code>APPLY_ROUTE = 6;</code>
     */
    APPLY_ROUTE(6),
    /**
     *
     *
     * <pre>
     * Config checking state: match forwarding rule.
     * </pre>
     *
     * <code>APPLY_FORWARDING_RULE = 7;</code>
     */
    APPLY_FORWARDING_RULE(7),
    /**
     *
     *
     * <pre>
     * Config checking state: verify load balancer backend configuration.
     * </pre>
     *
     * <code>ANALYZE_LOAD_BALANCER_BACKEND = 28;</code>
     */
    ANALYZE_LOAD_BALANCER_BACKEND(28),
    /**
     *
     *
     * <pre>
     * Config checking state: packet sent or received under foreign IP
     * address and allowed.
     * </pre>
     *
     * <code>SPOOFING_APPROVED = 8;</code>
     */
    SPOOFING_APPROVED(8),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine instance.
     * </pre>
     *
     * <code>ARRIVE_AT_INSTANCE = 9;</code>
     */
    ARRIVE_AT_INSTANCE(9),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine internal load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_INTERNAL_LOAD_BALANCER = 10 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    ARRIVE_AT_INTERNAL_LOAD_BALANCER(10),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine external load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 11 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    ARRIVE_AT_EXTERNAL_LOAD_BALANCER(11),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_GATEWAY = 12;</code>
     */
    ARRIVE_AT_VPN_GATEWAY(12),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN tunnel.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_TUNNEL = 13;</code>
     */
    ARRIVE_AT_VPN_TUNNEL(13),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a VPC connector.
     * </pre>
     *
     * <code>ARRIVE_AT_VPC_CONNECTOR = 24;</code>
     */
    ARRIVE_AT_VPC_CONNECTOR(24),
    /**
     *
     *
     * <pre>
     * Transition state: packet header translated.
     * </pre>
     *
     * <code>NAT = 14;</code>
     */
    NAT(14),
    /**
     *
     *
     * <pre>
     * Transition state: original connection is terminated and a new proxied
     * connection is initiated.
     * </pre>
     *
     * <code>PROXY_CONNECTION = 15;</code>
     */
    PROXY_CONNECTION(15),
    /**
     *
     *
     * <pre>
     * Final state: packet could be delivered.
     * </pre>
     *
     * <code>DELIVER = 16;</code>
     */
    DELIVER(16),
    /**
     *
     *
     * <pre>
     * Final state: packet could be dropped.
     * </pre>
     *
     * <code>DROP = 17;</code>
     */
    DROP(17),
    /**
     *
     *
     * <pre>
     * Final state: packet could be forwarded to a network with an unknown
     * configuration.
     * </pre>
     *
     * <code>FORWARD = 18;</code>
     */
    FORWARD(18),
    /**
     *
     *
     * <pre>
     * Final state: analysis is aborted.
     * </pre>
     *
     * <code>ABORT = 19;</code>
     */
    ABORT(19),
    /**
     *
     *
     * <pre>
     * Special state: viewer of the test result does not have permission to
     * see the configuration in this step.
     * </pre>
     *
     * <code>VIEWER_PERMISSION_MISSING = 20;</code>
     */
    VIEWER_PERMISSION_MISSING(20),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Compute Engine instance.
     * An InstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_INSTANCE = 1;</code>
     */
    public static final int START_FROM_INSTANCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from the internet.
     * The endpoint information is populated.
     * </pre>
     *
     * <code>START_FROM_INTERNET = 2;</code>
     */
    public static final int START_FROM_INTERNET_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Google service.
     * The google_service information is populated.
     * </pre>
     *
     * <code>START_FROM_GOOGLE_SERVICE = 27;</code>
     */
    public static final int START_FROM_GOOGLE_SERVICE_VALUE = 27;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a VPC or on-premises network
     * with internal source IP.
     * If the source is a VPC network visible to the user, a NetworkInfo
     * is populated with details of the network.
     * </pre>
     *
     * <code>START_FROM_PRIVATE_NETWORK = 3;</code>
     */
    public static final int START_FROM_PRIVATE_NETWORK_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Google Kubernetes Engine cluster
     * master. A GKEMasterInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_GKE_MASTER = 21;</code>
     */
    public static final int START_FROM_GKE_MASTER_VALUE = 21;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud SQL instance.
     * A CloudSQLInstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_SQL_INSTANCE = 22;</code>
     */
    public static final int START_FROM_CLOUD_SQL_INSTANCE_VALUE = 22;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud Function.
     * A CloudFunctionInfo is populated with starting function information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_FUNCTION = 23;</code>
     */
    public static final int START_FROM_CLOUD_FUNCTION_VALUE = 23;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from an App Engine service version.
     * An AppEngineVersionInfo is populated with starting version information.
     * </pre>
     *
     * <code>START_FROM_APP_ENGINE_VERSION = 25;</code>
     */
    public static final int START_FROM_APP_ENGINE_VERSION_VALUE = 25;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud Run revision.
     * A CloudRunRevisionInfo is populated with starting revision information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_RUN_REVISION = 26;</code>
     */
    public static final int START_FROM_CLOUD_RUN_REVISION_VALUE = 26;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Storage Bucket. Used only for
     * return traces.
     * The storage_bucket information is populated.
     * </pre>
     *
     * <code>START_FROM_STORAGE_BUCKET = 29;</code>
     */
    public static final int START_FROM_STORAGE_BUCKET_VALUE = 29;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a published service that uses
     * Private Service Connect. Used only for return traces.
     * </pre>
     *
     * <code>START_FROM_PSC_PUBLISHED_SERVICE = 30;</code>
     */
    public static final int START_FROM_PSC_PUBLISHED_SERVICE_VALUE = 30;
    /**
     *
     *
     * <pre>
     * Config checking state: verify ingress firewall rule.
     * </pre>
     *
     * <code>APPLY_INGRESS_FIREWALL_RULE = 4;</code>
     */
    public static final int APPLY_INGRESS_FIREWALL_RULE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Config checking state: verify egress firewall rule.
     * </pre>
     *
     * <code>APPLY_EGRESS_FIREWALL_RULE = 5;</code>
     */
    public static final int APPLY_EGRESS_FIREWALL_RULE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Config checking state: verify route.
     * </pre>
     *
     * <code>APPLY_ROUTE = 6;</code>
     */
    public static final int APPLY_ROUTE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Config checking state: match forwarding rule.
     * </pre>
     *
     * <code>APPLY_FORWARDING_RULE = 7;</code>
     */
    public static final int APPLY_FORWARDING_RULE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Config checking state: verify load balancer backend configuration.
     * </pre>
     *
     * <code>ANALYZE_LOAD_BALANCER_BACKEND = 28;</code>
     */
    public static final int ANALYZE_LOAD_BALANCER_BACKEND_VALUE = 28;
    /**
     *
     *
     * <pre>
     * Config checking state: packet sent or received under foreign IP
     * address and allowed.
     * </pre>
     *
     * <code>SPOOFING_APPROVED = 8;</code>
     */
    public static final int SPOOFING_APPROVED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine instance.
     * </pre>
     *
     * <code>ARRIVE_AT_INSTANCE = 9;</code>
     */
    public static final int ARRIVE_AT_INSTANCE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine internal load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_INTERNAL_LOAD_BALANCER = 10 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int ARRIVE_AT_INTERNAL_LOAD_BALANCER_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine external load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 11 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int ARRIVE_AT_EXTERNAL_LOAD_BALANCER_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_GATEWAY = 12;</code>
     */
    public static final int ARRIVE_AT_VPN_GATEWAY_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN tunnel.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_TUNNEL = 13;</code>
     */
    public static final int ARRIVE_AT_VPN_TUNNEL_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a VPC connector.
     * </pre>
     *
     * <code>ARRIVE_AT_VPC_CONNECTOR = 24;</code>
     */
    public static final int ARRIVE_AT_VPC_CONNECTOR_VALUE = 24;
    /**
     *
     *
     * <pre>
     * Transition state: packet header translated.
     * </pre>
     *
     * <code>NAT = 14;</code>
     */
    public static final int NAT_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Transition state: original connection is terminated and a new proxied
     * connection is initiated.
     * </pre>
     *
     * <code>PROXY_CONNECTION = 15;</code>
     */
    public static final int PROXY_CONNECTION_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Final state: packet could be delivered.
     * </pre>
     *
     * <code>DELIVER = 16;</code>
     */
    public static final int DELIVER_VALUE = 16;
    /**
     *
     *
     * <pre>
     * Final state: packet could be dropped.
     * </pre>
     *
     * <code>DROP = 17;</code>
     */
    public static final int DROP_VALUE = 17;
    /**
     *
     *
     * <pre>
     * Final state: packet could be forwarded to a network with an unknown
     * configuration.
     * </pre>
     *
     * <code>FORWARD = 18;</code>
     */
    public static final int FORWARD_VALUE = 18;
    /**
     *
     *
     * <pre>
     * Final state: analysis is aborted.
     * </pre>
     *
     * <code>ABORT = 19;</code>
     */
    public static final int ABORT_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Special state: viewer of the test result does not have permission to
     * see the configuration in this step.
     * </pre>
     *
     * <code>VIEWER_PERMISSION_MISSING = 20;</code>
     */
    public static final int VIEWER_PERMISSION_MISSING_VALUE = 20;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return START_FROM_INSTANCE;
        case 2:
          return START_FROM_INTERNET;
        case 27:
          return START_FROM_GOOGLE_SERVICE;
        case 3:
          return START_FROM_PRIVATE_NETWORK;
        case 21:
          return START_FROM_GKE_MASTER;
        case 22:
          return START_FROM_CLOUD_SQL_INSTANCE;
        case 23:
          return START_FROM_CLOUD_FUNCTION;
        case 25:
          return START_FROM_APP_ENGINE_VERSION;
        case 26:
          return START_FROM_CLOUD_RUN_REVISION;
        case 29:
          return START_FROM_STORAGE_BUCKET;
        case 30:
          return START_FROM_PSC_PUBLISHED_SERVICE;
        case 4:
          return APPLY_INGRESS_FIREWALL_RULE;
        case 5:
          return APPLY_EGRESS_FIREWALL_RULE;
        case 6:
          return APPLY_ROUTE;
        case 7:
          return APPLY_FORWARDING_RULE;
        case 28:
          return ANALYZE_LOAD_BALANCER_BACKEND;
        case 8:
          return SPOOFING_APPROVED;
        case 9:
          return ARRIVE_AT_INSTANCE;
        case 10:
          return ARRIVE_AT_INTERNAL_LOAD_BALANCER;
        case 11:
          return ARRIVE_AT_EXTERNAL_LOAD_BALANCER;
        case 12:
          return ARRIVE_AT_VPN_GATEWAY;
        case 13:
          return ARRIVE_AT_VPN_TUNNEL;
        case 24:
          return ARRIVE_AT_VPC_CONNECTOR;
        case 14:
          return NAT;
        case 15:
          return PROXY_CONNECTION;
        case 16:
          return DELIVER;
        case 17:
          return DROP;
        case 18:
          return FORWARD;
        case 19:
          return ABORT;
        case 20:
          return VIEWER_PERMISSION_MISSING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.Step.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.Step.State)
  }

  private int stepInfoCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object stepInfo_;

  public enum StepInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSTANCE(5),
    FIREWALL(6),
    ROUTE(7),
    ENDPOINT(8),
    GOOGLE_SERVICE(24),
    FORWARDING_RULE(9),
    VPN_GATEWAY(10),
    VPN_TUNNEL(11),
    VPC_CONNECTOR(21),
    DELIVER(12),
    FORWARD(13),
    ABORT(14),
    DROP(15),
    @java.lang.Deprecated
    LOAD_BALANCER(16),
    NETWORK(17),
    GKE_MASTER(18),
    CLOUD_SQL_INSTANCE(19),
    CLOUD_FUNCTION(20),
    APP_ENGINE_VERSION(22),
    CLOUD_RUN_REVISION(23),
    NAT(25),
    PROXY_CONNECTION(26),
    LOAD_BALANCER_BACKEND_INFO(27),
    STORAGE_BUCKET(28),
    STEPINFO_NOT_SET(0);
    private final int value;

    private StepInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StepInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static StepInfoCase forNumber(int value) {
      switch (value) {
        case 5:
          return INSTANCE;
        case 6:
          return FIREWALL;
        case 7:
          return ROUTE;
        case 8:
          return ENDPOINT;
        case 24:
          return GOOGLE_SERVICE;
        case 9:
          return FORWARDING_RULE;
        case 10:
          return VPN_GATEWAY;
        case 11:
          return VPN_TUNNEL;
        case 21:
          return VPC_CONNECTOR;
        case 12:
          return DELIVER;
        case 13:
          return FORWARD;
        case 14:
          return ABORT;
        case 15:
          return DROP;
        case 16:
          return LOAD_BALANCER;
        case 17:
          return NETWORK;
        case 18:
          return GKE_MASTER;
        case 19:
          return CLOUD_SQL_INSTANCE;
        case 20:
          return CLOUD_FUNCTION;
        case 22:
          return APP_ENGINE_VERSION;
        case 23:
          return CLOUD_RUN_REVISION;
        case 25:
          return NAT;
        case 26:
          return PROXY_CONNECTION;
        case 27:
          return LOAD_BALANCER_BACKEND_INFO;
        case 28:
          return STORAGE_BUCKET;
        case 0:
          return STEPINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StepInfoCase getStepInfoCase() {
    return StepInfoCase.forNumber(stepInfoCase_);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A description of the step. Usually this is a summary of the state.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of the step. Usually this is a summary of the state.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Each step is in one of the pre-defined states.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Each step is in one of the pre-defined states.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.Step.State getState() {
    com.google.cloud.networkmanagement.v1.Step.State result =
        com.google.cloud.networkmanagement.v1.Step.State.forNumber(state_);
    return result == null ? com.google.cloud.networkmanagement.v1.Step.State.UNRECOGNIZED : result;
  }

  public static final int CAUSES_DROP_FIELD_NUMBER = 3;
  private boolean causesDrop_ = false;
  /**
   *
   *
   * <pre>
   * This is a step that leads to the final state Drop.
   * </pre>
   *
   * <code>bool causes_drop = 3;</code>
   *
   * @return The causesDrop.
   */
  @java.lang.Override
  public boolean getCausesDrop() {
    return causesDrop_;
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Project ID that contains the configuration this step is validating.
   * </pre>
   *
   * <code>string project_id = 4;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID that contains the configuration this step is validating.
   * </pre>
   *
   * <code>string project_id = 4;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return stepInfoCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.InstanceInfo getInstance() {
    if (stepInfoCase_ == 5) {
      return (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.InstanceInfoOrBuilder getInstanceOrBuilder() {
    if (stepInfoCase_ == 5) {
      return (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
  }

  public static final int FIREWALL_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine firewall rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
   *
   * @return Whether the firewall field is set.
   */
  @java.lang.Override
  public boolean hasFirewall() {
    return stepInfoCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine firewall rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
   *
   * @return The firewall.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.FirewallInfo getFirewall() {
    if (stepInfoCase_ == 6) {
      return (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine firewall rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.FirewallInfoOrBuilder getFirewallOrBuilder() {
    if (stepInfoCase_ == 6) {
      return (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
  }

  public static final int ROUTE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
   *
   * @return Whether the route field is set.
   */
  @java.lang.Override
  public boolean hasRoute() {
    return stepInfoCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
   *
   * @return The route.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.RouteInfo getRoute() {
    if (stepInfoCase_ == 7) {
      return (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.RouteInfoOrBuilder getRouteOrBuilder() {
    if (stepInfoCase_ == 7) {
      return (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
  }

  public static final int ENDPOINT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Display information of the source and destination under analysis.
   * The endpoint information in an intermediate state may differ with the
   * initial input, as it might be modified by state like NAT,
   * or Connection Proxy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
   *
   * @return Whether the endpoint field is set.
   */
  @java.lang.Override
  public boolean hasEndpoint() {
    return stepInfoCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Display information of the source and destination under analysis.
   * The endpoint information in an intermediate state may differ with the
   * initial input, as it might be modified by state like NAT,
   * or Connection Proxy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.EndpointInfo getEndpoint() {
    if (stepInfoCase_ == 8) {
      return (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the source and destination under analysis.
   * The endpoint information in an intermediate state may differ with the
   * initial input, as it might be modified by state like NAT,
   * or Connection Proxy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder getEndpointOrBuilder() {
    if (stepInfoCase_ == 8) {
      return (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
  }

  public static final int GOOGLE_SERVICE_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Display information of a Google service
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
   *
   * @return Whether the googleService field is set.
   */
  @java.lang.Override
  public boolean hasGoogleService() {
    return stepInfoCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google service
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
   *
   * @return The googleService.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.GoogleServiceInfo getGoogleService() {
    if (stepInfoCase_ == 24) {
      return (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google service
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.GoogleServiceInfoOrBuilder
      getGoogleServiceOrBuilder() {
    if (stepInfoCase_ == 24) {
      return (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance();
  }

  public static final int FORWARDING_RULE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
   *
   * @return Whether the forwardingRule field is set.
   */
  @java.lang.Override
  public boolean hasForwardingRule() {
    return stepInfoCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
   *
   * @return The forwardingRule.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ForwardingRuleInfo getForwardingRule() {
    if (stepInfoCase_ == 9) {
      return (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ForwardingRuleInfoOrBuilder
      getForwardingRuleOrBuilder() {
    if (stepInfoCase_ == 9) {
      return (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance();
  }

  public static final int VPN_GATEWAY_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN gateway.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
   *
   * @return Whether the vpnGateway field is set.
   */
  @java.lang.Override
  public boolean hasVpnGateway() {
    return stepInfoCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN gateway.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
   *
   * @return The vpnGateway.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpnGatewayInfo getVpnGateway() {
    if (stepInfoCase_ == 10) {
      return (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN gateway.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpnGatewayInfoOrBuilder getVpnGatewayOrBuilder() {
    if (stepInfoCase_ == 10) {
      return (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance();
  }

  public static final int VPN_TUNNEL_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN tunnel.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
   *
   * @return Whether the vpnTunnel field is set.
   */
  @java.lang.Override
  public boolean hasVpnTunnel() {
    return stepInfoCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN tunnel.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
   *
   * @return The vpnTunnel.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpnTunnelInfo getVpnTunnel() {
    if (stepInfoCase_ == 11) {
      return (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN tunnel.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpnTunnelInfoOrBuilder getVpnTunnelOrBuilder() {
    if (stepInfoCase_ == 11) {
      return (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
  }

  public static final int VPC_CONNECTOR_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Display information of a VPC connector.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
   *
   * @return Whether the vpcConnector field is set.
   */
  @java.lang.Override
  public boolean hasVpcConnector() {
    return stepInfoCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Display information of a VPC connector.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
   *
   * @return The vpcConnector.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpcConnectorInfo getVpcConnector() {
    if (stepInfoCase_ == 21) {
      return (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a VPC connector.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpcConnectorInfoOrBuilder
      getVpcConnectorOrBuilder() {
    if (stepInfoCase_ == 21) {
      return (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance();
  }

  public static final int DELIVER_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Display information of the final state "deliver" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
   *
   * @return Whether the deliver field is set.
   */
  @java.lang.Override
  public boolean hasDeliver() {
    return stepInfoCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "deliver" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
   *
   * @return The deliver.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.DeliverInfo getDeliver() {
    if (stepInfoCase_ == 12) {
      return (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "deliver" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.DeliverInfoOrBuilder getDeliverOrBuilder() {
    if (stepInfoCase_ == 12) {
      return (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance();
  }

  public static final int FORWARD_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Display information of the final state "forward" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
   *
   * @return Whether the forward field is set.
   */
  @java.lang.Override
  public boolean hasForward() {
    return stepInfoCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "forward" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
   *
   * @return The forward.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ForwardInfo getForward() {
    if (stepInfoCase_ == 13) {
      return (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "forward" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ForwardInfoOrBuilder getForwardOrBuilder() {
    if (stepInfoCase_ == 13) {
      return (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
  }

  public static final int ABORT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Display information of the final state "abort" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
   *
   * @return Whether the abort field is set.
   */
  @java.lang.Override
  public boolean hasAbort() {
    return stepInfoCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "abort" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
   *
   * @return The abort.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.AbortInfo getAbort() {
    if (stepInfoCase_ == 14) {
      return (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "abort" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.AbortInfoOrBuilder getAbortOrBuilder() {
    if (stepInfoCase_ == 14) {
      return (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance();
  }

  public static final int DROP_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Display information of the final state "drop" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
   *
   * @return Whether the drop field is set.
   */
  @java.lang.Override
  public boolean hasDrop() {
    return stepInfoCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "drop" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
   *
   * @return The drop.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.DropInfo getDrop() {
    if (stepInfoCase_ == 15) {
      return (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "drop" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.DropInfoOrBuilder getDropOrBuilder() {
    if (stepInfoCase_ == 15) {
      return (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
  }

  public static final int LOAD_BALANCER_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Display information of the load balancers. Deprecated in favor of the
   * `load_balancer_backend_info` field, not used in new tests.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.networkmanagement.v1.Step.load_balancer is deprecated. See
   *     google/cloud/networkmanagement/v1/trace.proto;l=241
   * @return Whether the loadBalancer field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasLoadBalancer() {
    return stepInfoCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Display information of the load balancers. Deprecated in favor of the
   * `load_balancer_backend_info` field, not used in new tests.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.networkmanagement.v1.Step.load_balancer is deprecated. See
   *     google/cloud/networkmanagement/v1/trace.proto;l=241
   * @return The loadBalancer.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.networkmanagement.v1.LoadBalancerInfo getLoadBalancer() {
    if (stepInfoCase_ == 16) {
      return (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the load balancers. Deprecated in favor of the
   * `load_balancer_backend_info` field, not used in new tests.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.networkmanagement.v1.LoadBalancerInfoOrBuilder
      getLoadBalancerOrBuilder() {
    if (stepInfoCase_ == 16) {
      return (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance();
  }

  public static final int NETWORK_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Display information of a Google Cloud network.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return stepInfoCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Cloud network.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.NetworkInfo getNetwork() {
    if (stepInfoCase_ == 17) {
      return (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Cloud network.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.NetworkInfoOrBuilder getNetworkOrBuilder() {
    if (stepInfoCase_ == 17) {
      return (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance();
  }

  public static final int GKE_MASTER_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Display information of a Google Kubernetes Engine cluster master.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
   *
   * @return Whether the gkeMaster field is set.
   */
  @java.lang.Override
  public boolean hasGkeMaster() {
    return stepInfoCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Kubernetes Engine cluster master.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
   *
   * @return The gkeMaster.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.GKEMasterInfo getGkeMaster() {
    if (stepInfoCase_ == 18) {
      return (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Kubernetes Engine cluster master.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.GKEMasterInfoOrBuilder getGkeMasterOrBuilder() {
    if (stepInfoCase_ == 18) {
      return (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance();
  }

  public static final int CLOUD_SQL_INSTANCE_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Display information of a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
   *
   * @return Whether the cloudSqlInstance field is set.
   */
  @java.lang.Override
  public boolean hasCloudSqlInstance() {
    return stepInfoCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
   *
   * @return The cloudSqlInstance.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo getCloudSqlInstance() {
    if (stepInfoCase_ == 19) {
      return (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfoOrBuilder
      getCloudSqlInstanceOrBuilder() {
    if (stepInfoCase_ == 19) {
      return (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.getDefaultInstance();
  }

  public static final int CLOUD_FUNCTION_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Display information of a Cloud Function.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
   *
   * @return Whether the cloudFunction field is set.
   */
  @java.lang.Override
  public boolean hasCloudFunction() {
    return stepInfoCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud Function.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
   *
   * @return The cloudFunction.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.CloudFunctionInfo getCloudFunction() {
    if (stepInfoCase_ == 20) {
      return (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud Function.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.CloudFunctionInfoOrBuilder
      getCloudFunctionOrBuilder() {
    if (stepInfoCase_ == 20) {
      return (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance();
  }

  public static final int APP_ENGINE_VERSION_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Display information of an App Engine service version.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
   *
   * @return Whether the appEngineVersion field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineVersion() {
    return stepInfoCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Display information of an App Engine service version.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
   *
   * @return The appEngineVersion.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.AppEngineVersionInfo getAppEngineVersion() {
    if (stepInfoCase_ == 22) {
      return (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of an App Engine service version.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.AppEngineVersionInfoOrBuilder
      getAppEngineVersionOrBuilder() {
    if (stepInfoCase_ == 22) {
      return (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.getDefaultInstance();
  }

  public static final int CLOUD_RUN_REVISION_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Display information of a Cloud Run revision.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
   *
   * @return Whether the cloudRunRevision field is set.
   */
  @java.lang.Override
  public boolean hasCloudRunRevision() {
    return stepInfoCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud Run revision.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
   *
   * @return The cloudRunRevision.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo getCloudRunRevision() {
    if (stepInfoCase_ == 23) {
      return (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud Run revision.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.CloudRunRevisionInfoOrBuilder
      getCloudRunRevisionOrBuilder() {
    if (stepInfoCase_ == 23) {
      return (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.getDefaultInstance();
  }

  public static final int NAT_FIELD_NUMBER = 25;
  /**
   *
   *
   * <pre>
   * Display information of a NAT.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
   *
   * @return Whether the nat field is set.
   */
  @java.lang.Override
  public boolean hasNat() {
    return stepInfoCase_ == 25;
  }
  /**
   *
   *
   * <pre>
   * Display information of a NAT.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
   *
   * @return The nat.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.NatInfo getNat() {
    if (stepInfoCase_ == 25) {
      return (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a NAT.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.NatInfoOrBuilder getNatOrBuilder() {
    if (stepInfoCase_ == 25) {
      return (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
  }

  public static final int PROXY_CONNECTION_FIELD_NUMBER = 26;
  /**
   *
   *
   * <pre>
   * Display information of a ProxyConnection.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
   *
   * @return Whether the proxyConnection field is set.
   */
  @java.lang.Override
  public boolean hasProxyConnection() {
    return stepInfoCase_ == 26;
  }
  /**
   *
   *
   * <pre>
   * Display information of a ProxyConnection.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
   *
   * @return The proxyConnection.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo getProxyConnection() {
    if (stepInfoCase_ == 26) {
      return (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a ProxyConnection.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.ProxyConnectionInfoOrBuilder
      getProxyConnectionOrBuilder() {
    if (stepInfoCase_ == 26) {
      return (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
  }

  public static final int LOAD_BALANCER_BACKEND_INFO_FIELD_NUMBER = 27;
  /**
   *
   *
   * <pre>
   * Display information of a specific load balancer backend.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
   * </code>
   *
   * @return Whether the loadBalancerBackendInfo field is set.
   */
  @java.lang.Override
  public boolean hasLoadBalancerBackendInfo() {
    return stepInfoCase_ == 27;
  }
  /**
   *
   *
   * <pre>
   * Display information of a specific load balancer backend.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
   * </code>
   *
   * @return The loadBalancerBackendInfo.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
      getLoadBalancerBackendInfo() {
    if (stepInfoCase_ == 27) {
      return (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a specific load balancer backend.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfoOrBuilder
      getLoadBalancerBackendInfoOrBuilder() {
    if (stepInfoCase_ == 27) {
      return (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
  }

  public static final int STORAGE_BUCKET_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Display information of a Storage Bucket. Used only for return traces.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
   *
   * @return Whether the storageBucket field is set.
   */
  @java.lang.Override
  public boolean hasStorageBucket() {
    return stepInfoCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Storage Bucket. Used only for return traces.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
   *
   * @return The storageBucket.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.StorageBucketInfo getStorageBucket() {
    if (stepInfoCase_ == 28) {
      return (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Storage Bucket. Used only for return traces.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.StorageBucketInfoOrBuilder
      getStorageBucketOrBuilder() {
    if (stepInfoCase_ == 28) {
      return (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
    }
    if (state_ != com.google.cloud.networkmanagement.v1.Step.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (causesDrop_ != false) {
      output.writeBool(3, causesDrop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, projectId_);
    }
    if (stepInfoCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_);
    }
    if (stepInfoCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_);
    }
    if (stepInfoCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_);
    }
    if (stepInfoCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_);
    }
    if (stepInfoCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_);
    }
    if (stepInfoCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_);
    }
    if (stepInfoCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_);
    }
    if (stepInfoCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_);
    }
    if (stepInfoCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_);
    }
    if (stepInfoCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_);
    }
    if (stepInfoCase_ == 16) {
      output.writeMessage(16, (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_);
    }
    if (stepInfoCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_);
    }
    if (stepInfoCase_ == 18) {
      output.writeMessage(18, (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_);
    }
    if (stepInfoCase_ == 19) {
      output.writeMessage(
          19, (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 20) {
      output.writeMessage(20, (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 21) {
      output.writeMessage(21, (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_);
    }
    if (stepInfoCase_ == 22) {
      output.writeMessage(
          22, (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 23) {
      output.writeMessage(
          23, (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 24) {
      output.writeMessage(24, (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 25) {
      output.writeMessage(25, (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_);
    }
    if (stepInfoCase_ == 26) {
      output.writeMessage(
          26, (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 27) {
      output.writeMessage(
          27, (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_);
    }
    if (stepInfoCase_ == 28) {
      output.writeMessage(28, (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
    }
    if (state_ != com.google.cloud.networkmanagement.v1.Step.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (causesDrop_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, causesDrop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, projectId_);
    }
    if (stepInfoCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_);
    }
    if (stepInfoCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_);
    }
    if (stepInfoCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_);
    }
    if (stepInfoCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_);
    }
    if (stepInfoCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_);
    }
    if (stepInfoCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_);
    }
    if (stepInfoCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_);
    }
    if (stepInfoCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_);
    }
    if (stepInfoCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_);
    }
    if (stepInfoCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_);
    }
    if (stepInfoCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_);
    }
    if (stepInfoCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_);
    }
    if (stepInfoCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_);
    }
    if (stepInfoCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_);
    }
    if (stepInfoCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 25) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25, (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_);
    }
    if (stepInfoCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26, (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_);
    }
    if (stepInfoCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.Step)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.Step other =
        (com.google.cloud.networkmanagement.v1.Step) obj;

    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (getCausesDrop() != other.getCausesDrop()) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getStepInfoCase().equals(other.getStepInfoCase())) return false;
    switch (stepInfoCase_) {
      case 5:
        if (!getInstance().equals(other.getInstance())) return false;
        break;
      case 6:
        if (!getFirewall().equals(other.getFirewall())) return false;
        break;
      case 7:
        if (!getRoute().equals(other.getRoute())) return false;
        break;
      case 8:
        if (!getEndpoint().equals(other.getEndpoint())) return false;
        break;
      case 24:
        if (!getGoogleService().equals(other.getGoogleService())) return false;
        break;
      case 9:
        if (!getForwardingRule().equals(other.getForwardingRule())) return false;
        break;
      case 10:
        if (!getVpnGateway().equals(other.getVpnGateway())) return false;
        break;
      case 11:
        if (!getVpnTunnel().equals(other.getVpnTunnel())) return false;
        break;
      case 21:
        if (!getVpcConnector().equals(other.getVpcConnector())) return false;
        break;
      case 12:
        if (!getDeliver().equals(other.getDeliver())) return false;
        break;
      case 13:
        if (!getForward().equals(other.getForward())) return false;
        break;
      case 14:
        if (!getAbort().equals(other.getAbort())) return false;
        break;
      case 15:
        if (!getDrop().equals(other.getDrop())) return false;
        break;
      case 16:
        if (!getLoadBalancer().equals(other.getLoadBalancer())) return false;
        break;
      case 17:
        if (!getNetwork().equals(other.getNetwork())) return false;
        break;
      case 18:
        if (!getGkeMaster().equals(other.getGkeMaster())) return false;
        break;
      case 19:
        if (!getCloudSqlInstance().equals(other.getCloudSqlInstance())) return false;
        break;
      case 20:
        if (!getCloudFunction().equals(other.getCloudFunction())) return false;
        break;
      case 22:
        if (!getAppEngineVersion().equals(other.getAppEngineVersion())) return false;
        break;
      case 23:
        if (!getCloudRunRevision().equals(other.getCloudRunRevision())) return false;
        break;
      case 25:
        if (!getNat().equals(other.getNat())) return false;
        break;
      case 26:
        if (!getProxyConnection().equals(other.getProxyConnection())) return false;
        break;
      case 27:
        if (!getLoadBalancerBackendInfo().equals(other.getLoadBalancerBackendInfo())) return false;
        break;
      case 28:
        if (!getStorageBucket().equals(other.getStorageBucket())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CAUSES_DROP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCausesDrop());
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    switch (stepInfoCase_) {
      case 5:
        hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getInstance().hashCode();
        break;
      case 6:
        hash = (37 * hash) + FIREWALL_FIELD_NUMBER;
        hash = (53 * hash) + getFirewall().hashCode();
        break;
      case 7:
        hash = (37 * hash) + ROUTE_FIELD_NUMBER;
        hash = (53 * hash) + getRoute().hashCode();
        break;
      case 8:
        hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getEndpoint().hashCode();
        break;
      case 24:
        hash = (37 * hash) + GOOGLE_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleService().hashCode();
        break;
      case 9:
        hash = (37 * hash) + FORWARDING_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getForwardingRule().hashCode();
        break;
      case 10:
        hash = (37 * hash) + VPN_GATEWAY_FIELD_NUMBER;
        hash = (53 * hash) + getVpnGateway().hashCode();
        break;
      case 11:
        hash = (37 * hash) + VPN_TUNNEL_FIELD_NUMBER;
        hash = (53 * hash) + getVpnTunnel().hashCode();
        break;
      case 21:
        hash = (37 * hash) + VPC_CONNECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getVpcConnector().hashCode();
        break;
      case 12:
        hash = (37 * hash) + DELIVER_FIELD_NUMBER;
        hash = (53 * hash) + getDeliver().hashCode();
        break;
      case 13:
        hash = (37 * hash) + FORWARD_FIELD_NUMBER;
        hash = (53 * hash) + getForward().hashCode();
        break;
      case 14:
        hash = (37 * hash) + ABORT_FIELD_NUMBER;
        hash = (53 * hash) + getAbort().hashCode();
        break;
      case 15:
        hash = (37 * hash) + DROP_FIELD_NUMBER;
        hash = (53 * hash) + getDrop().hashCode();
        break;
      case 16:
        hash = (37 * hash) + LOAD_BALANCER_FIELD_NUMBER;
        hash = (53 * hash) + getLoadBalancer().hashCode();
        break;
      case 17:
        hash = (37 * hash) + NETWORK_FIELD_NUMBER;
        hash = (53 * hash) + getNetwork().hashCode();
        break;
      case 18:
        hash = (37 * hash) + GKE_MASTER_FIELD_NUMBER;
        hash = (53 * hash) + getGkeMaster().hashCode();
        break;
      case 19:
        hash = (37 * hash) + CLOUD_SQL_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudSqlInstance().hashCode();
        break;
      case 20:
        hash = (37 * hash) + CLOUD_FUNCTION_FIELD_NUMBER;
        hash = (53 * hash) + getCloudFunction().hashCode();
        break;
      case 22:
        hash = (37 * hash) + APP_ENGINE_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngineVersion().hashCode();
        break;
      case 23:
        hash = (37 * hash) + CLOUD_RUN_REVISION_FIELD_NUMBER;
        hash = (53 * hash) + getCloudRunRevision().hashCode();
        break;
      case 25:
        hash = (37 * hash) + NAT_FIELD_NUMBER;
        hash = (53 * hash) + getNat().hashCode();
        break;
      case 26:
        hash = (37 * hash) + PROXY_CONNECTION_FIELD_NUMBER;
        hash = (53 * hash) + getProxyConnection().hashCode();
        break;
      case 27:
        hash = (37 * hash) + LOAD_BALANCER_BACKEND_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getLoadBalancerBackendInfo().hashCode();
        break;
      case 28:
        hash = (37 * hash) + STORAGE_BUCKET_FIELD_NUMBER;
        hash = (53 * hash) + getStorageBucket().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.Step parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.Step prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A simulated forwarding path is composed of multiple steps.
   * Each step has a well-defined state and an associated configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.Step}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.Step)
      com.google.cloud.networkmanagement.v1.StepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_Step_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_Step_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.Step.class,
              com.google.cloud.networkmanagement.v1.Step.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.Step.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      description_ = "";
      state_ = 0;
      causesDrop_ = false;
      projectId_ = "";
      if (instanceBuilder_ != null) {
        instanceBuilder_.clear();
      }
      if (firewallBuilder_ != null) {
        firewallBuilder_.clear();
      }
      if (routeBuilder_ != null) {
        routeBuilder_.clear();
      }
      if (endpointBuilder_ != null) {
        endpointBuilder_.clear();
      }
      if (googleServiceBuilder_ != null) {
        googleServiceBuilder_.clear();
      }
      if (forwardingRuleBuilder_ != null) {
        forwardingRuleBuilder_.clear();
      }
      if (vpnGatewayBuilder_ != null) {
        vpnGatewayBuilder_.clear();
      }
      if (vpnTunnelBuilder_ != null) {
        vpnTunnelBuilder_.clear();
      }
      if (vpcConnectorBuilder_ != null) {
        vpcConnectorBuilder_.clear();
      }
      if (deliverBuilder_ != null) {
        deliverBuilder_.clear();
      }
      if (forwardBuilder_ != null) {
        forwardBuilder_.clear();
      }
      if (abortBuilder_ != null) {
        abortBuilder_.clear();
      }
      if (dropBuilder_ != null) {
        dropBuilder_.clear();
      }
      if (loadBalancerBuilder_ != null) {
        loadBalancerBuilder_.clear();
      }
      if (networkBuilder_ != null) {
        networkBuilder_.clear();
      }
      if (gkeMasterBuilder_ != null) {
        gkeMasterBuilder_.clear();
      }
      if (cloudSqlInstanceBuilder_ != null) {
        cloudSqlInstanceBuilder_.clear();
      }
      if (cloudFunctionBuilder_ != null) {
        cloudFunctionBuilder_.clear();
      }
      if (appEngineVersionBuilder_ != null) {
        appEngineVersionBuilder_.clear();
      }
      if (cloudRunRevisionBuilder_ != null) {
        cloudRunRevisionBuilder_.clear();
      }
      if (natBuilder_ != null) {
        natBuilder_.clear();
      }
      if (proxyConnectionBuilder_ != null) {
        proxyConnectionBuilder_.clear();
      }
      if (loadBalancerBackendInfoBuilder_ != null) {
        loadBalancerBackendInfoBuilder_.clear();
      }
      if (storageBucketBuilder_ != null) {
        storageBucketBuilder_.clear();
      }
      stepInfoCase_ = 0;
      stepInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_Step_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Step getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.Step.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Step build() {
      com.google.cloud.networkmanagement.v1.Step result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Step buildPartial() {
      com.google.cloud.networkmanagement.v1.Step result =
          new com.google.cloud.networkmanagement.v1.Step(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.Step result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.causesDrop_ = causesDrop_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.projectId_ = projectId_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.networkmanagement.v1.Step result) {
      result.stepInfoCase_ = stepInfoCase_;
      result.stepInfo_ = this.stepInfo_;
      if (stepInfoCase_ == 5 && instanceBuilder_ != null) {
        result.stepInfo_ = instanceBuilder_.build();
      }
      if (stepInfoCase_ == 6 && firewallBuilder_ != null) {
        result.stepInfo_ = firewallBuilder_.build();
      }
      if (stepInfoCase_ == 7 && routeBuilder_ != null) {
        result.stepInfo_ = routeBuilder_.build();
      }
      if (stepInfoCase_ == 8 && endpointBuilder_ != null) {
        result.stepInfo_ = endpointBuilder_.build();
      }
      if (stepInfoCase_ == 24 && googleServiceBuilder_ != null) {
        result.stepInfo_ = googleServiceBuilder_.build();
      }
      if (stepInfoCase_ == 9 && forwardingRuleBuilder_ != null) {
        result.stepInfo_ = forwardingRuleBuilder_.build();
      }
      if (stepInfoCase_ == 10 && vpnGatewayBuilder_ != null) {
        result.stepInfo_ = vpnGatewayBuilder_.build();
      }
      if (stepInfoCase_ == 11 && vpnTunnelBuilder_ != null) {
        result.stepInfo_ = vpnTunnelBuilder_.build();
      }
      if (stepInfoCase_ == 21 && vpcConnectorBuilder_ != null) {
        result.stepInfo_ = vpcConnectorBuilder_.build();
      }
      if (stepInfoCase_ == 12 && deliverBuilder_ != null) {
        result.stepInfo_ = deliverBuilder_.build();
      }
      if (stepInfoCase_ == 13 && forwardBuilder_ != null) {
        result.stepInfo_ = forwardBuilder_.build();
      }
      if (stepInfoCase_ == 14 && abortBuilder_ != null) {
        result.stepInfo_ = abortBuilder_.build();
      }
      if (stepInfoCase_ == 15 && dropBuilder_ != null) {
        result.stepInfo_ = dropBuilder_.build();
      }
      if (stepInfoCase_ == 16 && loadBalancerBuilder_ != null) {
        result.stepInfo_ = loadBalancerBuilder_.build();
      }
      if (stepInfoCase_ == 17 && networkBuilder_ != null) {
        result.stepInfo_ = networkBuilder_.build();
      }
      if (stepInfoCase_ == 18 && gkeMasterBuilder_ != null) {
        result.stepInfo_ = gkeMasterBuilder_.build();
      }
      if (stepInfoCase_ == 19 && cloudSqlInstanceBuilder_ != null) {
        result.stepInfo_ = cloudSqlInstanceBuilder_.build();
      }
      if (stepInfoCase_ == 20 && cloudFunctionBuilder_ != null) {
        result.stepInfo_ = cloudFunctionBuilder_.build();
      }
      if (stepInfoCase_ == 22 && appEngineVersionBuilder_ != null) {
        result.stepInfo_ = appEngineVersionBuilder_.build();
      }
      if (stepInfoCase_ == 23 && cloudRunRevisionBuilder_ != null) {
        result.stepInfo_ = cloudRunRevisionBuilder_.build();
      }
      if (stepInfoCase_ == 25 && natBuilder_ != null) {
        result.stepInfo_ = natBuilder_.build();
      }
      if (stepInfoCase_ == 26 && proxyConnectionBuilder_ != null) {
        result.stepInfo_ = proxyConnectionBuilder_.build();
      }
      if (stepInfoCase_ == 27 && loadBalancerBackendInfoBuilder_ != null) {
        result.stepInfo_ = loadBalancerBackendInfoBuilder_.build();
      }
      if (stepInfoCase_ == 28 && storageBucketBuilder_ != null) {
        result.stepInfo_ = storageBucketBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.Step) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.Step) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.Step other) {
      if (other == com.google.cloud.networkmanagement.v1.Step.getDefaultInstance()) return this;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getCausesDrop() != false) {
        setCausesDrop(other.getCausesDrop());
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      switch (other.getStepInfoCase()) {
        case INSTANCE:
          {
            mergeInstance(other.getInstance());
            break;
          }
        case FIREWALL:
          {
            mergeFirewall(other.getFirewall());
            break;
          }
        case ROUTE:
          {
            mergeRoute(other.getRoute());
            break;
          }
        case ENDPOINT:
          {
            mergeEndpoint(other.getEndpoint());
            break;
          }
        case GOOGLE_SERVICE:
          {
            mergeGoogleService(other.getGoogleService());
            break;
          }
        case FORWARDING_RULE:
          {
            mergeForwardingRule(other.getForwardingRule());
            break;
          }
        case VPN_GATEWAY:
          {
            mergeVpnGateway(other.getVpnGateway());
            break;
          }
        case VPN_TUNNEL:
          {
            mergeVpnTunnel(other.getVpnTunnel());
            break;
          }
        case VPC_CONNECTOR:
          {
            mergeVpcConnector(other.getVpcConnector());
            break;
          }
        case DELIVER:
          {
            mergeDeliver(other.getDeliver());
            break;
          }
        case FORWARD:
          {
            mergeForward(other.getForward());
            break;
          }
        case ABORT:
          {
            mergeAbort(other.getAbort());
            break;
          }
        case DROP:
          {
            mergeDrop(other.getDrop());
            break;
          }
        case LOAD_BALANCER:
          {
            mergeLoadBalancer(other.getLoadBalancer());
            break;
          }
        case NETWORK:
          {
            mergeNetwork(other.getNetwork());
            break;
          }
        case GKE_MASTER:
          {
            mergeGkeMaster(other.getGkeMaster());
            break;
          }
        case CLOUD_SQL_INSTANCE:
          {
            mergeCloudSqlInstance(other.getCloudSqlInstance());
            break;
          }
        case CLOUD_FUNCTION:
          {
            mergeCloudFunction(other.getCloudFunction());
            break;
          }
        case APP_ENGINE_VERSION:
          {
            mergeAppEngineVersion(other.getAppEngineVersion());
            break;
          }
        case CLOUD_RUN_REVISION:
          {
            mergeCloudRunRevision(other.getCloudRunRevision());
            break;
          }
        case NAT:
          {
            mergeNat(other.getNat());
            break;
          }
        case PROXY_CONNECTION:
          {
            mergeProxyConnection(other.getProxyConnection());
            break;
          }
        case LOAD_BALANCER_BACKEND_INFO:
          {
            mergeLoadBalancerBackendInfo(other.getLoadBalancerBackendInfo());
            break;
          }
        case STORAGE_BUCKET:
          {
            mergeStorageBucket(other.getStorageBucket());
            break;
          }
        case STEPINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                causesDrop_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getInstanceFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getFirewallFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getRouteFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndpointFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getForwardingRuleFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getVpnGatewayFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getVpnTunnelFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDeliverFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getForwardFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getAbortFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getDropFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getLoadBalancerFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getNetworkFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getGkeMasterFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getCloudSqlInstanceFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getCloudFunctionFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getVpcConnectorFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getAppEngineVersionFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getCloudRunRevisionFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 23;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getGoogleServiceFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 24;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(getNatFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 25;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(getProxyConnectionFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 26;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(
                    getLoadBalancerBackendInfoFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 27;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getStorageBucketFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 28;
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int stepInfoCase_ = 0;
    private java.lang.Object stepInfo_;

    public StepInfoCase getStepInfoCase() {
      return StepInfoCase.forNumber(stepInfoCase_);
    }

    public Builder clearStepInfo() {
      stepInfoCase_ = 0;
      stepInfo_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.Step.State getState() {
      com.google.cloud.networkmanagement.v1.Step.State result =
          com.google.cloud.networkmanagement.v1.Step.State.forNumber(state_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.Step.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.networkmanagement.v1.Step.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.Step.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private boolean causesDrop_;
    /**
     *
     *
     * <pre>
     * This is a step that leads to the final state Drop.
     * </pre>
     *
     * <code>bool causes_drop = 3;</code>
     *
     * @return The causesDrop.
     */
    @java.lang.Override
    public boolean getCausesDrop() {
      return causesDrop_;
    }
    /**
     *
     *
     * <pre>
     * This is a step that leads to the final state Drop.
     * </pre>
     *
     * <code>bool causes_drop = 3;</code>
     *
     * @param value The causesDrop to set.
     * @return This builder for chaining.
     */
    public Builder setCausesDrop(boolean value) {

      causesDrop_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is a step that leads to the final state Drop.
     * </pre>
     *
     * <code>bool causes_drop = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCausesDrop() {
      bitField0_ = (bitField0_ & ~0x00000004);
      causesDrop_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.InstanceInfo,
            com.google.cloud.networkmanagement.v1.InstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1.InstanceInfoOrBuilder>
        instanceBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     *
     * @return Whether the instance field is set.
     */
    @java.lang.Override
    public boolean hasInstance() {
      return stepInfoCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     *
     * @return The instance.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.InstanceInfo getInstance() {
      if (instanceBuilder_ == null) {
        if (stepInfoCase_ == 5) {
          return (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 5) {
          return instanceBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    public Builder setInstance(com.google.cloud.networkmanagement.v1.InstanceInfo value) {
      if (instanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        instanceBuilder_.setMessage(value);
      }
      stepInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    public Builder setInstance(
        com.google.cloud.networkmanagement.v1.InstanceInfo.Builder builderForValue) {
      if (instanceBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        instanceBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    public Builder mergeInstance(com.google.cloud.networkmanagement.v1.InstanceInfo value) {
      if (instanceBuilder_ == null) {
        if (stepInfoCase_ == 5
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.InstanceInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 5) {
          instanceBuilder_.mergeFrom(value);
        } else {
          instanceBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    public Builder clearInstance() {
      if (instanceBuilder_ == null) {
        if (stepInfoCase_ == 5) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 5) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        instanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1.InstanceInfo.Builder getInstanceBuilder() {
      return getInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.InstanceInfoOrBuilder getInstanceOrBuilder() {
      if ((stepInfoCase_ == 5) && (instanceBuilder_ != null)) {
        return instanceBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 5) {
          return (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.InstanceInfo instance = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.InstanceInfo,
            com.google.cloud.networkmanagement.v1.InstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1.InstanceInfoOrBuilder>
        getInstanceFieldBuilder() {
      if (instanceBuilder_ == null) {
        if (!(stepInfoCase_ == 5)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.InstanceInfo.getDefaultInstance();
        }
        instanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.InstanceInfo,
                com.google.cloud.networkmanagement.v1.InstanceInfo.Builder,
                com.google.cloud.networkmanagement.v1.InstanceInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.InstanceInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 5;
      onChanged();
      return instanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.FirewallInfo,
            com.google.cloud.networkmanagement.v1.FirewallInfo.Builder,
            com.google.cloud.networkmanagement.v1.FirewallInfoOrBuilder>
        firewallBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     *
     * @return Whether the firewall field is set.
     */
    @java.lang.Override
    public boolean hasFirewall() {
      return stepInfoCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     *
     * @return The firewall.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.FirewallInfo getFirewall() {
      if (firewallBuilder_ == null) {
        if (stepInfoCase_ == 6) {
          return (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 6) {
          return firewallBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    public Builder setFirewall(com.google.cloud.networkmanagement.v1.FirewallInfo value) {
      if (firewallBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        firewallBuilder_.setMessage(value);
      }
      stepInfoCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    public Builder setFirewall(
        com.google.cloud.networkmanagement.v1.FirewallInfo.Builder builderForValue) {
      if (firewallBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        firewallBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    public Builder mergeFirewall(com.google.cloud.networkmanagement.v1.FirewallInfo value) {
      if (firewallBuilder_ == null) {
        if (stepInfoCase_ == 6
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.FirewallInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 6) {
          firewallBuilder_.mergeFrom(value);
        } else {
          firewallBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    public Builder clearFirewall() {
      if (firewallBuilder_ == null) {
        if (stepInfoCase_ == 6) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 6) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        firewallBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    public com.google.cloud.networkmanagement.v1.FirewallInfo.Builder getFirewallBuilder() {
      return getFirewallFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.FirewallInfoOrBuilder getFirewallOrBuilder() {
      if ((stepInfoCase_ == 6) && (firewallBuilder_ != null)) {
        return firewallBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 6) {
          return (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.FirewallInfo firewall = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.FirewallInfo,
            com.google.cloud.networkmanagement.v1.FirewallInfo.Builder,
            com.google.cloud.networkmanagement.v1.FirewallInfoOrBuilder>
        getFirewallFieldBuilder() {
      if (firewallBuilder_ == null) {
        if (!(stepInfoCase_ == 6)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.FirewallInfo.getDefaultInstance();
        }
        firewallBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.FirewallInfo,
                com.google.cloud.networkmanagement.v1.FirewallInfo.Builder,
                com.google.cloud.networkmanagement.v1.FirewallInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.FirewallInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 6;
      onChanged();
      return firewallBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.RouteInfo,
            com.google.cloud.networkmanagement.v1.RouteInfo.Builder,
            com.google.cloud.networkmanagement.v1.RouteInfoOrBuilder>
        routeBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     *
     * @return Whether the route field is set.
     */
    @java.lang.Override
    public boolean hasRoute() {
      return stepInfoCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     *
     * @return The route.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfo getRoute() {
      if (routeBuilder_ == null) {
        if (stepInfoCase_ == 7) {
          return (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 7) {
          return routeBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    public Builder setRoute(com.google.cloud.networkmanagement.v1.RouteInfo value) {
      if (routeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        routeBuilder_.setMessage(value);
      }
      stepInfoCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    public Builder setRoute(
        com.google.cloud.networkmanagement.v1.RouteInfo.Builder builderForValue) {
      if (routeBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        routeBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    public Builder mergeRoute(com.google.cloud.networkmanagement.v1.RouteInfo value) {
      if (routeBuilder_ == null) {
        if (stepInfoCase_ == 7
            && stepInfo_ != com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.RouteInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 7) {
          routeBuilder_.mergeFrom(value);
        } else {
          routeBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    public Builder clearRoute() {
      if (routeBuilder_ == null) {
        if (stepInfoCase_ == 7) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 7) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        routeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    public com.google.cloud.networkmanagement.v1.RouteInfo.Builder getRouteBuilder() {
      return getRouteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.RouteInfoOrBuilder getRouteOrBuilder() {
      if ((stepInfoCase_ == 7) && (routeBuilder_ != null)) {
        return routeBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 7) {
          return (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.RouteInfo route = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.RouteInfo,
            com.google.cloud.networkmanagement.v1.RouteInfo.Builder,
            com.google.cloud.networkmanagement.v1.RouteInfoOrBuilder>
        getRouteFieldBuilder() {
      if (routeBuilder_ == null) {
        if (!(stepInfoCase_ == 7)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.RouteInfo.getDefaultInstance();
        }
        routeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.RouteInfo,
                com.google.cloud.networkmanagement.v1.RouteInfo.Builder,
                com.google.cloud.networkmanagement.v1.RouteInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.RouteInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 7;
      onChanged();
      return routeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.EndpointInfo,
            com.google.cloud.networkmanagement.v1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder>
        endpointBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     *
     * @return Whether the endpoint field is set.
     */
    @java.lang.Override
    public boolean hasEndpoint() {
      return stepInfoCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.EndpointInfo getEndpoint() {
      if (endpointBuilder_ == null) {
        if (stepInfoCase_ == 8) {
          return (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 8) {
          return endpointBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    public Builder setEndpoint(com.google.cloud.networkmanagement.v1.EndpointInfo value) {
      if (endpointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        endpointBuilder_.setMessage(value);
      }
      stepInfoCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    public Builder setEndpoint(
        com.google.cloud.networkmanagement.v1.EndpointInfo.Builder builderForValue) {
      if (endpointBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        endpointBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    public Builder mergeEndpoint(com.google.cloud.networkmanagement.v1.EndpointInfo value) {
      if (endpointBuilder_ == null) {
        if (stepInfoCase_ == 8
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.EndpointInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 8) {
          endpointBuilder_.mergeFrom(value);
        } else {
          endpointBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    public Builder clearEndpoint() {
      if (endpointBuilder_ == null) {
        if (stepInfoCase_ == 8) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 8) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        endpointBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    public com.google.cloud.networkmanagement.v1.EndpointInfo.Builder getEndpointBuilder() {
      return getEndpointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder getEndpointOrBuilder() {
      if ((stepInfoCase_ == 8) && (endpointBuilder_ != null)) {
        return endpointBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 8) {
          return (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.EndpointInfo endpoint = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.EndpointInfo,
            com.google.cloud.networkmanagement.v1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder>
        getEndpointFieldBuilder() {
      if (endpointBuilder_ == null) {
        if (!(stepInfoCase_ == 8)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.EndpointInfo.getDefaultInstance();
        }
        endpointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.EndpointInfo,
                com.google.cloud.networkmanagement.v1.EndpointInfo.Builder,
                com.google.cloud.networkmanagement.v1.EndpointInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.EndpointInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 8;
      onChanged();
      return endpointBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.GoogleServiceInfo,
            com.google.cloud.networkmanagement.v1.GoogleServiceInfo.Builder,
            com.google.cloud.networkmanagement.v1.GoogleServiceInfoOrBuilder>
        googleServiceBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     *
     * @return Whether the googleService field is set.
     */
    @java.lang.Override
    public boolean hasGoogleService() {
      return stepInfoCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     *
     * @return The googleService.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.GoogleServiceInfo getGoogleService() {
      if (googleServiceBuilder_ == null) {
        if (stepInfoCase_ == 24) {
          return (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 24) {
          return googleServiceBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    public Builder setGoogleService(com.google.cloud.networkmanagement.v1.GoogleServiceInfo value) {
      if (googleServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        googleServiceBuilder_.setMessage(value);
      }
      stepInfoCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    public Builder setGoogleService(
        com.google.cloud.networkmanagement.v1.GoogleServiceInfo.Builder builderForValue) {
      if (googleServiceBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        googleServiceBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    public Builder mergeGoogleService(
        com.google.cloud.networkmanagement.v1.GoogleServiceInfo value) {
      if (googleServiceBuilder_ == null) {
        if (stepInfoCase_ == 24
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.GoogleServiceInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 24) {
          googleServiceBuilder_.mergeFrom(value);
        } else {
          googleServiceBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    public Builder clearGoogleService() {
      if (googleServiceBuilder_ == null) {
        if (stepInfoCase_ == 24) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 24) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        googleServiceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    public com.google.cloud.networkmanagement.v1.GoogleServiceInfo.Builder
        getGoogleServiceBuilder() {
      return getGoogleServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.GoogleServiceInfoOrBuilder
        getGoogleServiceOrBuilder() {
      if ((stepInfoCase_ == 24) && (googleServiceBuilder_ != null)) {
        return googleServiceBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 24) {
          return (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google service
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GoogleServiceInfo google_service = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.GoogleServiceInfo,
            com.google.cloud.networkmanagement.v1.GoogleServiceInfo.Builder,
            com.google.cloud.networkmanagement.v1.GoogleServiceInfoOrBuilder>
        getGoogleServiceFieldBuilder() {
      if (googleServiceBuilder_ == null) {
        if (!(stepInfoCase_ == 24)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.GoogleServiceInfo.getDefaultInstance();
        }
        googleServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.GoogleServiceInfo,
                com.google.cloud.networkmanagement.v1.GoogleServiceInfo.Builder,
                com.google.cloud.networkmanagement.v1.GoogleServiceInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.GoogleServiceInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 24;
      onChanged();
      return googleServiceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.ForwardingRuleInfo,
            com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.Builder,
            com.google.cloud.networkmanagement.v1.ForwardingRuleInfoOrBuilder>
        forwardingRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     *
     * @return Whether the forwardingRule field is set.
     */
    @java.lang.Override
    public boolean hasForwardingRule() {
      return stepInfoCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     *
     * @return The forwardingRule.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardingRuleInfo getForwardingRule() {
      if (forwardingRuleBuilder_ == null) {
        if (stepInfoCase_ == 9) {
          return (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 9) {
          return forwardingRuleBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder setForwardingRule(
        com.google.cloud.networkmanagement.v1.ForwardingRuleInfo value) {
      if (forwardingRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        forwardingRuleBuilder_.setMessage(value);
      }
      stepInfoCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder setForwardingRule(
        com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.Builder builderForValue) {
      if (forwardingRuleBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        forwardingRuleBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder mergeForwardingRule(
        com.google.cloud.networkmanagement.v1.ForwardingRuleInfo value) {
      if (forwardingRuleBuilder_ == null) {
        if (stepInfoCase_ == 9
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 9) {
          forwardingRuleBuilder_.mergeFrom(value);
        } else {
          forwardingRuleBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder clearForwardingRule() {
      if (forwardingRuleBuilder_ == null) {
        if (stepInfoCase_ == 9) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 9) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        forwardingRuleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.Builder
        getForwardingRuleBuilder() {
      return getForwardingRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardingRuleInfoOrBuilder
        getForwardingRuleOrBuilder() {
      if ((stepInfoCase_ == 9) && (forwardingRuleBuilder_ != null)) {
        return forwardingRuleBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 9) {
          return (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.ForwardingRuleInfo,
            com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.Builder,
            com.google.cloud.networkmanagement.v1.ForwardingRuleInfoOrBuilder>
        getForwardingRuleFieldBuilder() {
      if (forwardingRuleBuilder_ == null) {
        if (!(stepInfoCase_ == 9)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.getDefaultInstance();
        }
        forwardingRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.ForwardingRuleInfo,
                com.google.cloud.networkmanagement.v1.ForwardingRuleInfo.Builder,
                com.google.cloud.networkmanagement.v1.ForwardingRuleInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.ForwardingRuleInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 9;
      onChanged();
      return forwardingRuleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.VpnGatewayInfo,
            com.google.cloud.networkmanagement.v1.VpnGatewayInfo.Builder,
            com.google.cloud.networkmanagement.v1.VpnGatewayInfoOrBuilder>
        vpnGatewayBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     *
     * @return Whether the vpnGateway field is set.
     */
    @java.lang.Override
    public boolean hasVpnGateway() {
      return stepInfoCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     *
     * @return The vpnGateway.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnGatewayInfo getVpnGateway() {
      if (vpnGatewayBuilder_ == null) {
        if (stepInfoCase_ == 10) {
          return (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 10) {
          return vpnGatewayBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder setVpnGateway(com.google.cloud.networkmanagement.v1.VpnGatewayInfo value) {
      if (vpnGatewayBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        vpnGatewayBuilder_.setMessage(value);
      }
      stepInfoCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder setVpnGateway(
        com.google.cloud.networkmanagement.v1.VpnGatewayInfo.Builder builderForValue) {
      if (vpnGatewayBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        vpnGatewayBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder mergeVpnGateway(com.google.cloud.networkmanagement.v1.VpnGatewayInfo value) {
      if (vpnGatewayBuilder_ == null) {
        if (stepInfoCase_ == 10
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.VpnGatewayInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 10) {
          vpnGatewayBuilder_.mergeFrom(value);
        } else {
          vpnGatewayBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder clearVpnGateway() {
      if (vpnGatewayBuilder_ == null) {
        if (stepInfoCase_ == 10) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 10) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        vpnGatewayBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public com.google.cloud.networkmanagement.v1.VpnGatewayInfo.Builder getVpnGatewayBuilder() {
      return getVpnGatewayFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnGatewayInfoOrBuilder getVpnGatewayOrBuilder() {
      if ((stepInfoCase_ == 10) && (vpnGatewayBuilder_ != null)) {
        return vpnGatewayBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 10) {
          return (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.VpnGatewayInfo,
            com.google.cloud.networkmanagement.v1.VpnGatewayInfo.Builder,
            com.google.cloud.networkmanagement.v1.VpnGatewayInfoOrBuilder>
        getVpnGatewayFieldBuilder() {
      if (vpnGatewayBuilder_ == null) {
        if (!(stepInfoCase_ == 10)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.VpnGatewayInfo.getDefaultInstance();
        }
        vpnGatewayBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.VpnGatewayInfo,
                com.google.cloud.networkmanagement.v1.VpnGatewayInfo.Builder,
                com.google.cloud.networkmanagement.v1.VpnGatewayInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.VpnGatewayInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 10;
      onChanged();
      return vpnGatewayBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.VpnTunnelInfo,
            com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder,
            com.google.cloud.networkmanagement.v1.VpnTunnelInfoOrBuilder>
        vpnTunnelBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     *
     * @return Whether the vpnTunnel field is set.
     */
    @java.lang.Override
    public boolean hasVpnTunnel() {
      return stepInfoCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     *
     * @return The vpnTunnel.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfo getVpnTunnel() {
      if (vpnTunnelBuilder_ == null) {
        if (stepInfoCase_ == 11) {
          return (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 11) {
          return vpnTunnelBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder setVpnTunnel(com.google.cloud.networkmanagement.v1.VpnTunnelInfo value) {
      if (vpnTunnelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        vpnTunnelBuilder_.setMessage(value);
      }
      stepInfoCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder setVpnTunnel(
        com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder builderForValue) {
      if (vpnTunnelBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        vpnTunnelBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder mergeVpnTunnel(com.google.cloud.networkmanagement.v1.VpnTunnelInfo value) {
      if (vpnTunnelBuilder_ == null) {
        if (stepInfoCase_ == 11
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.VpnTunnelInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 11) {
          vpnTunnelBuilder_.mergeFrom(value);
        } else {
          vpnTunnelBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder clearVpnTunnel() {
      if (vpnTunnelBuilder_ == null) {
        if (stepInfoCase_ == 11) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 11) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        vpnTunnelBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder getVpnTunnelBuilder() {
      return getVpnTunnelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfoOrBuilder getVpnTunnelOrBuilder() {
      if ((stepInfoCase_ == 11) && (vpnTunnelBuilder_ != null)) {
        return vpnTunnelBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 11) {
          return (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.VpnTunnelInfo,
            com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder,
            com.google.cloud.networkmanagement.v1.VpnTunnelInfoOrBuilder>
        getVpnTunnelFieldBuilder() {
      if (vpnTunnelBuilder_ == null) {
        if (!(stepInfoCase_ == 11)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
        }
        vpnTunnelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.VpnTunnelInfo,
                com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder,
                com.google.cloud.networkmanagement.v1.VpnTunnelInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 11;
      onChanged();
      return vpnTunnelBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.VpcConnectorInfo,
            com.google.cloud.networkmanagement.v1.VpcConnectorInfo.Builder,
            com.google.cloud.networkmanagement.v1.VpcConnectorInfoOrBuilder>
        vpcConnectorBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     *
     * @return Whether the vpcConnector field is set.
     */
    @java.lang.Override
    public boolean hasVpcConnector() {
      return stepInfoCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     *
     * @return The vpcConnector.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpcConnectorInfo getVpcConnector() {
      if (vpcConnectorBuilder_ == null) {
        if (stepInfoCase_ == 21) {
          return (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 21) {
          return vpcConnectorBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder setVpcConnector(com.google.cloud.networkmanagement.v1.VpcConnectorInfo value) {
      if (vpcConnectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        vpcConnectorBuilder_.setMessage(value);
      }
      stepInfoCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder setVpcConnector(
        com.google.cloud.networkmanagement.v1.VpcConnectorInfo.Builder builderForValue) {
      if (vpcConnectorBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        vpcConnectorBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder mergeVpcConnector(com.google.cloud.networkmanagement.v1.VpcConnectorInfo value) {
      if (vpcConnectorBuilder_ == null) {
        if (stepInfoCase_ == 21
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.VpcConnectorInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 21) {
          vpcConnectorBuilder_.mergeFrom(value);
        } else {
          vpcConnectorBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder clearVpcConnector() {
      if (vpcConnectorBuilder_ == null) {
        if (stepInfoCase_ == 21) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 21) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        vpcConnectorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public com.google.cloud.networkmanagement.v1.VpcConnectorInfo.Builder getVpcConnectorBuilder() {
      return getVpcConnectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpcConnectorInfoOrBuilder
        getVpcConnectorOrBuilder() {
      if ((stepInfoCase_ == 21) && (vpcConnectorBuilder_ != null)) {
        return vpcConnectorBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 21) {
          return (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.VpcConnectorInfo,
            com.google.cloud.networkmanagement.v1.VpcConnectorInfo.Builder,
            com.google.cloud.networkmanagement.v1.VpcConnectorInfoOrBuilder>
        getVpcConnectorFieldBuilder() {
      if (vpcConnectorBuilder_ == null) {
        if (!(stepInfoCase_ == 21)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.VpcConnectorInfo.getDefaultInstance();
        }
        vpcConnectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.VpcConnectorInfo,
                com.google.cloud.networkmanagement.v1.VpcConnectorInfo.Builder,
                com.google.cloud.networkmanagement.v1.VpcConnectorInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.VpcConnectorInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 21;
      onChanged();
      return vpcConnectorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.DeliverInfo,
            com.google.cloud.networkmanagement.v1.DeliverInfo.Builder,
            com.google.cloud.networkmanagement.v1.DeliverInfoOrBuilder>
        deliverBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     *
     * @return Whether the deliver field is set.
     */
    @java.lang.Override
    public boolean hasDeliver() {
      return stepInfoCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     *
     * @return The deliver.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DeliverInfo getDeliver() {
      if (deliverBuilder_ == null) {
        if (stepInfoCase_ == 12) {
          return (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 12) {
          return deliverBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    public Builder setDeliver(com.google.cloud.networkmanagement.v1.DeliverInfo value) {
      if (deliverBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        deliverBuilder_.setMessage(value);
      }
      stepInfoCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    public Builder setDeliver(
        com.google.cloud.networkmanagement.v1.DeliverInfo.Builder builderForValue) {
      if (deliverBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        deliverBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    public Builder mergeDeliver(com.google.cloud.networkmanagement.v1.DeliverInfo value) {
      if (deliverBuilder_ == null) {
        if (stepInfoCase_ == 12
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.DeliverInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 12) {
          deliverBuilder_.mergeFrom(value);
        } else {
          deliverBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    public Builder clearDeliver() {
      if (deliverBuilder_ == null) {
        if (stepInfoCase_ == 12) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 12) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        deliverBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    public com.google.cloud.networkmanagement.v1.DeliverInfo.Builder getDeliverBuilder() {
      return getDeliverFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DeliverInfoOrBuilder getDeliverOrBuilder() {
      if ((stepInfoCase_ == 12) && (deliverBuilder_ != null)) {
        return deliverBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 12) {
          return (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DeliverInfo deliver = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.DeliverInfo,
            com.google.cloud.networkmanagement.v1.DeliverInfo.Builder,
            com.google.cloud.networkmanagement.v1.DeliverInfoOrBuilder>
        getDeliverFieldBuilder() {
      if (deliverBuilder_ == null) {
        if (!(stepInfoCase_ == 12)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.DeliverInfo.getDefaultInstance();
        }
        deliverBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.DeliverInfo,
                com.google.cloud.networkmanagement.v1.DeliverInfo.Builder,
                com.google.cloud.networkmanagement.v1.DeliverInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.DeliverInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 12;
      onChanged();
      return deliverBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.ForwardInfo,
            com.google.cloud.networkmanagement.v1.ForwardInfo.Builder,
            com.google.cloud.networkmanagement.v1.ForwardInfoOrBuilder>
        forwardBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     *
     * @return Whether the forward field is set.
     */
    @java.lang.Override
    public boolean hasForward() {
      return stepInfoCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     *
     * @return The forward.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardInfo getForward() {
      if (forwardBuilder_ == null) {
        if (stepInfoCase_ == 13) {
          return (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 13) {
          return forwardBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    public Builder setForward(com.google.cloud.networkmanagement.v1.ForwardInfo value) {
      if (forwardBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        forwardBuilder_.setMessage(value);
      }
      stepInfoCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    public Builder setForward(
        com.google.cloud.networkmanagement.v1.ForwardInfo.Builder builderForValue) {
      if (forwardBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        forwardBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    public Builder mergeForward(com.google.cloud.networkmanagement.v1.ForwardInfo value) {
      if (forwardBuilder_ == null) {
        if (stepInfoCase_ == 13
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.ForwardInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 13) {
          forwardBuilder_.mergeFrom(value);
        } else {
          forwardBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    public Builder clearForward() {
      if (forwardBuilder_ == null) {
        if (stepInfoCase_ == 13) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 13) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        forwardBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    public com.google.cloud.networkmanagement.v1.ForwardInfo.Builder getForwardBuilder() {
      return getForwardFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ForwardInfoOrBuilder getForwardOrBuilder() {
      if ((stepInfoCase_ == 13) && (forwardBuilder_ != null)) {
        return forwardBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 13) {
          return (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ForwardInfo forward = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.ForwardInfo,
            com.google.cloud.networkmanagement.v1.ForwardInfo.Builder,
            com.google.cloud.networkmanagement.v1.ForwardInfoOrBuilder>
        getForwardFieldBuilder() {
      if (forwardBuilder_ == null) {
        if (!(stepInfoCase_ == 13)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.ForwardInfo.getDefaultInstance();
        }
        forwardBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.ForwardInfo,
                com.google.cloud.networkmanagement.v1.ForwardInfo.Builder,
                com.google.cloud.networkmanagement.v1.ForwardInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.ForwardInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 13;
      onChanged();
      return forwardBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.AbortInfo,
            com.google.cloud.networkmanagement.v1.AbortInfo.Builder,
            com.google.cloud.networkmanagement.v1.AbortInfoOrBuilder>
        abortBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     *
     * @return Whether the abort field is set.
     */
    @java.lang.Override
    public boolean hasAbort() {
      return stepInfoCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     *
     * @return The abort.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.AbortInfo getAbort() {
      if (abortBuilder_ == null) {
        if (stepInfoCase_ == 14) {
          return (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 14) {
          return abortBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    public Builder setAbort(com.google.cloud.networkmanagement.v1.AbortInfo value) {
      if (abortBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        abortBuilder_.setMessage(value);
      }
      stepInfoCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    public Builder setAbort(
        com.google.cloud.networkmanagement.v1.AbortInfo.Builder builderForValue) {
      if (abortBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        abortBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    public Builder mergeAbort(com.google.cloud.networkmanagement.v1.AbortInfo value) {
      if (abortBuilder_ == null) {
        if (stepInfoCase_ == 14
            && stepInfo_ != com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.AbortInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 14) {
          abortBuilder_.mergeFrom(value);
        } else {
          abortBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    public Builder clearAbort() {
      if (abortBuilder_ == null) {
        if (stepInfoCase_ == 14) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 14) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        abortBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    public com.google.cloud.networkmanagement.v1.AbortInfo.Builder getAbortBuilder() {
      return getAbortFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.AbortInfoOrBuilder getAbortOrBuilder() {
      if ((stepInfoCase_ == 14) && (abortBuilder_ != null)) {
        return abortBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 14) {
          return (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AbortInfo abort = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.AbortInfo,
            com.google.cloud.networkmanagement.v1.AbortInfo.Builder,
            com.google.cloud.networkmanagement.v1.AbortInfoOrBuilder>
        getAbortFieldBuilder() {
      if (abortBuilder_ == null) {
        if (!(stepInfoCase_ == 14)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.AbortInfo.getDefaultInstance();
        }
        abortBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.AbortInfo,
                com.google.cloud.networkmanagement.v1.AbortInfo.Builder,
                com.google.cloud.networkmanagement.v1.AbortInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.AbortInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 14;
      onChanged();
      return abortBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.DropInfo,
            com.google.cloud.networkmanagement.v1.DropInfo.Builder,
            com.google.cloud.networkmanagement.v1.DropInfoOrBuilder>
        dropBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     *
     * @return Whether the drop field is set.
     */
    @java.lang.Override
    public boolean hasDrop() {
      return stepInfoCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     *
     * @return The drop.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DropInfo getDrop() {
      if (dropBuilder_ == null) {
        if (stepInfoCase_ == 15) {
          return (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 15) {
          return dropBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    public Builder setDrop(com.google.cloud.networkmanagement.v1.DropInfo value) {
      if (dropBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        dropBuilder_.setMessage(value);
      }
      stepInfoCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    public Builder setDrop(com.google.cloud.networkmanagement.v1.DropInfo.Builder builderForValue) {
      if (dropBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        dropBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    public Builder mergeDrop(com.google.cloud.networkmanagement.v1.DropInfo value) {
      if (dropBuilder_ == null) {
        if (stepInfoCase_ == 15
            && stepInfo_ != com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.DropInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 15) {
          dropBuilder_.mergeFrom(value);
        } else {
          dropBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    public Builder clearDrop() {
      if (dropBuilder_ == null) {
        if (stepInfoCase_ == 15) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 15) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        dropBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    public com.google.cloud.networkmanagement.v1.DropInfo.Builder getDropBuilder() {
      return getDropFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.DropInfoOrBuilder getDropOrBuilder() {
      if ((stepInfoCase_ == 15) && (dropBuilder_ != null)) {
        return dropBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 15) {
          return (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.DropInfo drop = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.DropInfo,
            com.google.cloud.networkmanagement.v1.DropInfo.Builder,
            com.google.cloud.networkmanagement.v1.DropInfoOrBuilder>
        getDropFieldBuilder() {
      if (dropBuilder_ == null) {
        if (!(stepInfoCase_ == 15)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.DropInfo.getDefaultInstance();
        }
        dropBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.DropInfo,
                com.google.cloud.networkmanagement.v1.DropInfo.Builder,
                com.google.cloud.networkmanagement.v1.DropInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.DropInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 15;
      onChanged();
      return dropBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.LoadBalancerInfo,
            com.google.cloud.networkmanagement.v1.LoadBalancerInfo.Builder,
            com.google.cloud.networkmanagement.v1.LoadBalancerInfoOrBuilder>
        loadBalancerBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.networkmanagement.v1.Step.load_balancer is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=241
     * @return Whether the loadBalancer field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasLoadBalancer() {
      return stepInfoCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.networkmanagement.v1.Step.load_balancer is deprecated. See
     *     google/cloud/networkmanagement/v1/trace.proto;l=241
     * @return The loadBalancer.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.networkmanagement.v1.LoadBalancerInfo getLoadBalancer() {
      if (loadBalancerBuilder_ == null) {
        if (stepInfoCase_ == 16) {
          return (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 16) {
          return loadBalancerBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setLoadBalancer(com.google.cloud.networkmanagement.v1.LoadBalancerInfo value) {
      if (loadBalancerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        loadBalancerBuilder_.setMessage(value);
      }
      stepInfoCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setLoadBalancer(
        com.google.cloud.networkmanagement.v1.LoadBalancerInfo.Builder builderForValue) {
      if (loadBalancerBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        loadBalancerBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeLoadBalancer(com.google.cloud.networkmanagement.v1.LoadBalancerInfo value) {
      if (loadBalancerBuilder_ == null) {
        if (stepInfoCase_ == 16
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.LoadBalancerInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 16) {
          loadBalancerBuilder_.mergeFrom(value);
        } else {
          loadBalancerBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearLoadBalancer() {
      if (loadBalancerBuilder_ == null) {
        if (stepInfoCase_ == 16) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 16) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        loadBalancerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.networkmanagement.v1.LoadBalancerInfo.Builder getLoadBalancerBuilder() {
      return getLoadBalancerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.networkmanagement.v1.LoadBalancerInfoOrBuilder
        getLoadBalancerOrBuilder() {
      if ((stepInfoCase_ == 16) && (loadBalancerBuilder_ != null)) {
        return loadBalancerBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 16) {
          return (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers. Deprecated in favor of the
     * `load_balancer_backend_info` field, not used in new tests.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerInfo load_balancer = 16 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.LoadBalancerInfo,
            com.google.cloud.networkmanagement.v1.LoadBalancerInfo.Builder,
            com.google.cloud.networkmanagement.v1.LoadBalancerInfoOrBuilder>
        getLoadBalancerFieldBuilder() {
      if (loadBalancerBuilder_ == null) {
        if (!(stepInfoCase_ == 16)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.LoadBalancerInfo.getDefaultInstance();
        }
        loadBalancerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.LoadBalancerInfo,
                com.google.cloud.networkmanagement.v1.LoadBalancerInfo.Builder,
                com.google.cloud.networkmanagement.v1.LoadBalancerInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.LoadBalancerInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 16;
      onChanged();
      return loadBalancerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.NetworkInfo,
            com.google.cloud.networkmanagement.v1.NetworkInfo.Builder,
            com.google.cloud.networkmanagement.v1.NetworkInfoOrBuilder>
        networkBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     *
     * @return Whether the network field is set.
     */
    @java.lang.Override
    public boolean hasNetwork() {
      return stepInfoCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     *
     * @return The network.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NetworkInfo getNetwork() {
      if (networkBuilder_ == null) {
        if (stepInfoCase_ == 17) {
          return (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 17) {
          return networkBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    public Builder setNetwork(com.google.cloud.networkmanagement.v1.NetworkInfo value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        networkBuilder_.setMessage(value);
      }
      stepInfoCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    public Builder setNetwork(
        com.google.cloud.networkmanagement.v1.NetworkInfo.Builder builderForValue) {
      if (networkBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    public Builder mergeNetwork(com.google.cloud.networkmanagement.v1.NetworkInfo value) {
      if (networkBuilder_ == null) {
        if (stepInfoCase_ == 17
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.NetworkInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 17) {
          networkBuilder_.mergeFrom(value);
        } else {
          networkBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    public Builder clearNetwork() {
      if (networkBuilder_ == null) {
        if (stepInfoCase_ == 17) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 17) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        networkBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    public com.google.cloud.networkmanagement.v1.NetworkInfo.Builder getNetworkBuilder() {
      return getNetworkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NetworkInfoOrBuilder getNetworkOrBuilder() {
      if ((stepInfoCase_ == 17) && (networkBuilder_ != null)) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 17) {
          return (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NetworkInfo network = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.NetworkInfo,
            com.google.cloud.networkmanagement.v1.NetworkInfo.Builder,
            com.google.cloud.networkmanagement.v1.NetworkInfoOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        if (!(stepInfoCase_ == 17)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.NetworkInfo.getDefaultInstance();
        }
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.NetworkInfo,
                com.google.cloud.networkmanagement.v1.NetworkInfo.Builder,
                com.google.cloud.networkmanagement.v1.NetworkInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.NetworkInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 17;
      onChanged();
      return networkBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.GKEMasterInfo,
            com.google.cloud.networkmanagement.v1.GKEMasterInfo.Builder,
            com.google.cloud.networkmanagement.v1.GKEMasterInfoOrBuilder>
        gkeMasterBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     *
     * @return Whether the gkeMaster field is set.
     */
    @java.lang.Override
    public boolean hasGkeMaster() {
      return stepInfoCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     *
     * @return The gkeMaster.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.GKEMasterInfo getGkeMaster() {
      if (gkeMasterBuilder_ == null) {
        if (stepInfoCase_ == 18) {
          return (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 18) {
          return gkeMasterBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder setGkeMaster(com.google.cloud.networkmanagement.v1.GKEMasterInfo value) {
      if (gkeMasterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        gkeMasterBuilder_.setMessage(value);
      }
      stepInfoCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder setGkeMaster(
        com.google.cloud.networkmanagement.v1.GKEMasterInfo.Builder builderForValue) {
      if (gkeMasterBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        gkeMasterBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder mergeGkeMaster(com.google.cloud.networkmanagement.v1.GKEMasterInfo value) {
      if (gkeMasterBuilder_ == null) {
        if (stepInfoCase_ == 18
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.GKEMasterInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 18) {
          gkeMasterBuilder_.mergeFrom(value);
        } else {
          gkeMasterBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder clearGkeMaster() {
      if (gkeMasterBuilder_ == null) {
        if (stepInfoCase_ == 18) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 18) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        gkeMasterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    public com.google.cloud.networkmanagement.v1.GKEMasterInfo.Builder getGkeMasterBuilder() {
      return getGkeMasterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.GKEMasterInfoOrBuilder getGkeMasterOrBuilder() {
      if ((stepInfoCase_ == 18) && (gkeMasterBuilder_ != null)) {
        return gkeMasterBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 18) {
          return (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.GKEMasterInfo gke_master = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.GKEMasterInfo,
            com.google.cloud.networkmanagement.v1.GKEMasterInfo.Builder,
            com.google.cloud.networkmanagement.v1.GKEMasterInfoOrBuilder>
        getGkeMasterFieldBuilder() {
      if (gkeMasterBuilder_ == null) {
        if (!(stepInfoCase_ == 18)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.GKEMasterInfo.getDefaultInstance();
        }
        gkeMasterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.GKEMasterInfo,
                com.google.cloud.networkmanagement.v1.GKEMasterInfo.Builder,
                com.google.cloud.networkmanagement.v1.GKEMasterInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.GKEMasterInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 18;
      onChanged();
      return gkeMasterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo,
            com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfoOrBuilder>
        cloudSqlInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     *
     * @return Whether the cloudSqlInstance field is set.
     */
    @java.lang.Override
    public boolean hasCloudSqlInstance() {
      return stepInfoCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     *
     * @return The cloudSqlInstance.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo getCloudSqlInstance() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (stepInfoCase_ == 19) {
          return (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 19) {
          return cloudSqlInstanceBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    public Builder setCloudSqlInstance(
        com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo value) {
      if (cloudSqlInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        cloudSqlInstanceBuilder_.setMessage(value);
      }
      stepInfoCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    public Builder setCloudSqlInstance(
        com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.Builder builderForValue) {
      if (cloudSqlInstanceBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        cloudSqlInstanceBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    public Builder mergeCloudSqlInstance(
        com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo value) {
      if (cloudSqlInstanceBuilder_ == null) {
        if (stepInfoCase_ == 19
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 19) {
          cloudSqlInstanceBuilder_.mergeFrom(value);
        } else {
          cloudSqlInstanceBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    public Builder clearCloudSqlInstance() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (stepInfoCase_ == 19) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 19) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        cloudSqlInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    public com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.Builder
        getCloudSqlInstanceBuilder() {
      return getCloudSqlInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfoOrBuilder
        getCloudSqlInstanceOrBuilder() {
      if ((stepInfoCase_ == 19) && (cloudSqlInstanceBuilder_ != null)) {
        return cloudSqlInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 19) {
          return (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo cloud_sql_instance = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo,
            com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfoOrBuilder>
        getCloudSqlInstanceFieldBuilder() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (!(stepInfoCase_ == 19)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.getDefaultInstance();
        }
        cloudSqlInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo,
                com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo.Builder,
                com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.CloudSQLInstanceInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 19;
      onChanged();
      return cloudSqlInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.CloudFunctionInfo,
            com.google.cloud.networkmanagement.v1.CloudFunctionInfo.Builder,
            com.google.cloud.networkmanagement.v1.CloudFunctionInfoOrBuilder>
        cloudFunctionBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     *
     * @return Whether the cloudFunction field is set.
     */
    @java.lang.Override
    public boolean hasCloudFunction() {
      return stepInfoCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     *
     * @return The cloudFunction.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.CloudFunctionInfo getCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        if (stepInfoCase_ == 20) {
          return (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 20) {
          return cloudFunctionBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder setCloudFunction(com.google.cloud.networkmanagement.v1.CloudFunctionInfo value) {
      if (cloudFunctionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        cloudFunctionBuilder_.setMessage(value);
      }
      stepInfoCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder setCloudFunction(
        com.google.cloud.networkmanagement.v1.CloudFunctionInfo.Builder builderForValue) {
      if (cloudFunctionBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        cloudFunctionBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder mergeCloudFunction(
        com.google.cloud.networkmanagement.v1.CloudFunctionInfo value) {
      if (cloudFunctionBuilder_ == null) {
        if (stepInfoCase_ == 20
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.CloudFunctionInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 20) {
          cloudFunctionBuilder_.mergeFrom(value);
        } else {
          cloudFunctionBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder clearCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        if (stepInfoCase_ == 20) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 20) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        cloudFunctionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public com.google.cloud.networkmanagement.v1.CloudFunctionInfo.Builder
        getCloudFunctionBuilder() {
      return getCloudFunctionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.CloudFunctionInfoOrBuilder
        getCloudFunctionOrBuilder() {
      if ((stepInfoCase_ == 20) && (cloudFunctionBuilder_ != null)) {
        return cloudFunctionBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 20) {
          return (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudFunctionInfo cloud_function = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.CloudFunctionInfo,
            com.google.cloud.networkmanagement.v1.CloudFunctionInfo.Builder,
            com.google.cloud.networkmanagement.v1.CloudFunctionInfoOrBuilder>
        getCloudFunctionFieldBuilder() {
      if (cloudFunctionBuilder_ == null) {
        if (!(stepInfoCase_ == 20)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.CloudFunctionInfo.getDefaultInstance();
        }
        cloudFunctionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.CloudFunctionInfo,
                com.google.cloud.networkmanagement.v1.CloudFunctionInfo.Builder,
                com.google.cloud.networkmanagement.v1.CloudFunctionInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.CloudFunctionInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 20;
      onChanged();
      return cloudFunctionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.AppEngineVersionInfo,
            com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.Builder,
            com.google.cloud.networkmanagement.v1.AppEngineVersionInfoOrBuilder>
        appEngineVersionBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     *
     * @return Whether the appEngineVersion field is set.
     */
    @java.lang.Override
    public boolean hasAppEngineVersion() {
      return stepInfoCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     *
     * @return The appEngineVersion.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.AppEngineVersionInfo getAppEngineVersion() {
      if (appEngineVersionBuilder_ == null) {
        if (stepInfoCase_ == 22) {
          return (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 22) {
          return appEngineVersionBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    public Builder setAppEngineVersion(
        com.google.cloud.networkmanagement.v1.AppEngineVersionInfo value) {
      if (appEngineVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        appEngineVersionBuilder_.setMessage(value);
      }
      stepInfoCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    public Builder setAppEngineVersion(
        com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.Builder builderForValue) {
      if (appEngineVersionBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        appEngineVersionBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    public Builder mergeAppEngineVersion(
        com.google.cloud.networkmanagement.v1.AppEngineVersionInfo value) {
      if (appEngineVersionBuilder_ == null) {
        if (stepInfoCase_ == 22
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.AppEngineVersionInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 22) {
          appEngineVersionBuilder_.mergeFrom(value);
        } else {
          appEngineVersionBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    public Builder clearAppEngineVersion() {
      if (appEngineVersionBuilder_ == null) {
        if (stepInfoCase_ == 22) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 22) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        appEngineVersionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    public com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.Builder
        getAppEngineVersionBuilder() {
      return getAppEngineVersionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.AppEngineVersionInfoOrBuilder
        getAppEngineVersionOrBuilder() {
      if ((stepInfoCase_ == 22) && (appEngineVersionBuilder_ != null)) {
        return appEngineVersionBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 22) {
          return (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of an App Engine service version.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.AppEngineVersionInfo app_engine_version = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.AppEngineVersionInfo,
            com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.Builder,
            com.google.cloud.networkmanagement.v1.AppEngineVersionInfoOrBuilder>
        getAppEngineVersionFieldBuilder() {
      if (appEngineVersionBuilder_ == null) {
        if (!(stepInfoCase_ == 22)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.getDefaultInstance();
        }
        appEngineVersionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.AppEngineVersionInfo,
                com.google.cloud.networkmanagement.v1.AppEngineVersionInfo.Builder,
                com.google.cloud.networkmanagement.v1.AppEngineVersionInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.AppEngineVersionInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 22;
      onChanged();
      return appEngineVersionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo,
            com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.Builder,
            com.google.cloud.networkmanagement.v1.CloudRunRevisionInfoOrBuilder>
        cloudRunRevisionBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     *
     * @return Whether the cloudRunRevision field is set.
     */
    @java.lang.Override
    public boolean hasCloudRunRevision() {
      return stepInfoCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     *
     * @return The cloudRunRevision.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo getCloudRunRevision() {
      if (cloudRunRevisionBuilder_ == null) {
        if (stepInfoCase_ == 23) {
          return (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 23) {
          return cloudRunRevisionBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    public Builder setCloudRunRevision(
        com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo value) {
      if (cloudRunRevisionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        cloudRunRevisionBuilder_.setMessage(value);
      }
      stepInfoCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    public Builder setCloudRunRevision(
        com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.Builder builderForValue) {
      if (cloudRunRevisionBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        cloudRunRevisionBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    public Builder mergeCloudRunRevision(
        com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo value) {
      if (cloudRunRevisionBuilder_ == null) {
        if (stepInfoCase_ == 23
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 23) {
          cloudRunRevisionBuilder_.mergeFrom(value);
        } else {
          cloudRunRevisionBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    public Builder clearCloudRunRevision() {
      if (cloudRunRevisionBuilder_ == null) {
        if (stepInfoCase_ == 23) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 23) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        cloudRunRevisionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    public com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.Builder
        getCloudRunRevisionBuilder() {
      return getCloudRunRevisionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.CloudRunRevisionInfoOrBuilder
        getCloudRunRevisionOrBuilder() {
      if ((stepInfoCase_ == 23) && (cloudRunRevisionBuilder_ != null)) {
        return cloudRunRevisionBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 23) {
          return (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud Run revision.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.CloudRunRevisionInfo cloud_run_revision = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo,
            com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.Builder,
            com.google.cloud.networkmanagement.v1.CloudRunRevisionInfoOrBuilder>
        getCloudRunRevisionFieldBuilder() {
      if (cloudRunRevisionBuilder_ == null) {
        if (!(stepInfoCase_ == 23)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.getDefaultInstance();
        }
        cloudRunRevisionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo,
                com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo.Builder,
                com.google.cloud.networkmanagement.v1.CloudRunRevisionInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.CloudRunRevisionInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 23;
      onChanged();
      return cloudRunRevisionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.NatInfo,
            com.google.cloud.networkmanagement.v1.NatInfo.Builder,
            com.google.cloud.networkmanagement.v1.NatInfoOrBuilder>
        natBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     *
     * @return Whether the nat field is set.
     */
    @java.lang.Override
    public boolean hasNat() {
      return stepInfoCase_ == 25;
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     *
     * @return The nat.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NatInfo getNat() {
      if (natBuilder_ == null) {
        if (stepInfoCase_ == 25) {
          return (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 25) {
          return natBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    public Builder setNat(com.google.cloud.networkmanagement.v1.NatInfo value) {
      if (natBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        natBuilder_.setMessage(value);
      }
      stepInfoCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    public Builder setNat(com.google.cloud.networkmanagement.v1.NatInfo.Builder builderForValue) {
      if (natBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        natBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    public Builder mergeNat(com.google.cloud.networkmanagement.v1.NatInfo value) {
      if (natBuilder_ == null) {
        if (stepInfoCase_ == 25
            && stepInfo_ != com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.NatInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 25) {
          natBuilder_.mergeFrom(value);
        } else {
          natBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    public Builder clearNat() {
      if (natBuilder_ == null) {
        if (stepInfoCase_ == 25) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 25) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        natBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    public com.google.cloud.networkmanagement.v1.NatInfo.Builder getNatBuilder() {
      return getNatFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.NatInfoOrBuilder getNatOrBuilder() {
      if ((stepInfoCase_ == 25) && (natBuilder_ != null)) {
        return natBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 25) {
          return (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a NAT.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.NatInfo nat = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.NatInfo,
            com.google.cloud.networkmanagement.v1.NatInfo.Builder,
            com.google.cloud.networkmanagement.v1.NatInfoOrBuilder>
        getNatFieldBuilder() {
      if (natBuilder_ == null) {
        if (!(stepInfoCase_ == 25)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.NatInfo.getDefaultInstance();
        }
        natBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.NatInfo,
                com.google.cloud.networkmanagement.v1.NatInfo.Builder,
                com.google.cloud.networkmanagement.v1.NatInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.NatInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 25;
      onChanged();
      return natBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfo,
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder,
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfoOrBuilder>
        proxyConnectionBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     *
     * @return Whether the proxyConnection field is set.
     */
    @java.lang.Override
    public boolean hasProxyConnection() {
      return stepInfoCase_ == 26;
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     *
     * @return The proxyConnection.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo getProxyConnection() {
      if (proxyConnectionBuilder_ == null) {
        if (stepInfoCase_ == 26) {
          return (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 26) {
          return proxyConnectionBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    public Builder setProxyConnection(
        com.google.cloud.networkmanagement.v1.ProxyConnectionInfo value) {
      if (proxyConnectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        proxyConnectionBuilder_.setMessage(value);
      }
      stepInfoCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    public Builder setProxyConnection(
        com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder builderForValue) {
      if (proxyConnectionBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        proxyConnectionBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    public Builder mergeProxyConnection(
        com.google.cloud.networkmanagement.v1.ProxyConnectionInfo value) {
      if (proxyConnectionBuilder_ == null) {
        if (stepInfoCase_ == 26
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 26) {
          proxyConnectionBuilder_.mergeFrom(value);
        } else {
          proxyConnectionBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    public Builder clearProxyConnection() {
      if (proxyConnectionBuilder_ == null) {
        if (stepInfoCase_ == 26) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 26) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        proxyConnectionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    public com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder
        getProxyConnectionBuilder() {
      return getProxyConnectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.ProxyConnectionInfoOrBuilder
        getProxyConnectionOrBuilder() {
      if ((stepInfoCase_ == 26) && (proxyConnectionBuilder_ != null)) {
        return proxyConnectionBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 26) {
          return (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a ProxyConnection.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.ProxyConnectionInfo proxy_connection = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfo,
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder,
            com.google.cloud.networkmanagement.v1.ProxyConnectionInfoOrBuilder>
        getProxyConnectionFieldBuilder() {
      if (proxyConnectionBuilder_ == null) {
        if (!(stepInfoCase_ == 26)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.getDefaultInstance();
        }
        proxyConnectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.ProxyConnectionInfo,
                com.google.cloud.networkmanagement.v1.ProxyConnectionInfo.Builder,
                com.google.cloud.networkmanagement.v1.ProxyConnectionInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.ProxyConnectionInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 26;
      onChanged();
      return proxyConnectionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo,
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder,
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfoOrBuilder>
        loadBalancerBackendInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     *
     * @return Whether the loadBalancerBackendInfo field is set.
     */
    @java.lang.Override
    public boolean hasLoadBalancerBackendInfo() {
      return stepInfoCase_ == 27;
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     *
     * @return The loadBalancerBackendInfo.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
        getLoadBalancerBackendInfo() {
      if (loadBalancerBackendInfoBuilder_ == null) {
        if (stepInfoCase_ == 27) {
          return (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 27) {
          return loadBalancerBackendInfoBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    public Builder setLoadBalancerBackendInfo(
        com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo value) {
      if (loadBalancerBackendInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        loadBalancerBackendInfoBuilder_.setMessage(value);
      }
      stepInfoCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    public Builder setLoadBalancerBackendInfo(
        com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder builderForValue) {
      if (loadBalancerBackendInfoBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        loadBalancerBackendInfoBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    public Builder mergeLoadBalancerBackendInfo(
        com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo value) {
      if (loadBalancerBackendInfoBuilder_ == null) {
        if (stepInfoCase_ == 27
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 27) {
          loadBalancerBackendInfoBuilder_.mergeFrom(value);
        } else {
          loadBalancerBackendInfoBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    public Builder clearLoadBalancerBackendInfo() {
      if (loadBalancerBackendInfoBuilder_ == null) {
        if (stepInfoCase_ == 27) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 27) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        loadBalancerBackendInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder
        getLoadBalancerBackendInfoBuilder() {
      return getLoadBalancerBackendInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfoOrBuilder
        getLoadBalancerBackendInfoOrBuilder() {
      if ((stepInfoCase_ == 27) && (loadBalancerBackendInfoBuilder_ != null)) {
        return loadBalancerBackendInfoBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 27) {
          return (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a specific load balancer backend.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1.LoadBalancerBackendInfo load_balancer_backend_info = 27;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo,
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder,
            com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfoOrBuilder>
        getLoadBalancerBackendInfoFieldBuilder() {
      if (loadBalancerBackendInfoBuilder_ == null) {
        if (!(stepInfoCase_ == 27)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.getDefaultInstance();
        }
        loadBalancerBackendInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo,
                com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.Builder,
                com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.LoadBalancerBackendInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 27;
      onChanged();
      return loadBalancerBackendInfoBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.StorageBucketInfo,
            com.google.cloud.networkmanagement.v1.StorageBucketInfo.Builder,
            com.google.cloud.networkmanagement.v1.StorageBucketInfoOrBuilder>
        storageBucketBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     *
     * @return Whether the storageBucket field is set.
     */
    @java.lang.Override
    public boolean hasStorageBucket() {
      return stepInfoCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     *
     * @return The storageBucket.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.StorageBucketInfo getStorageBucket() {
      if (storageBucketBuilder_ == null) {
        if (stepInfoCase_ == 28) {
          return (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 28) {
          return storageBucketBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    public Builder setStorageBucket(com.google.cloud.networkmanagement.v1.StorageBucketInfo value) {
      if (storageBucketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        storageBucketBuilder_.setMessage(value);
      }
      stepInfoCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    public Builder setStorageBucket(
        com.google.cloud.networkmanagement.v1.StorageBucketInfo.Builder builderForValue) {
      if (storageBucketBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        storageBucketBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    public Builder mergeStorageBucket(
        com.google.cloud.networkmanagement.v1.StorageBucketInfo value) {
      if (storageBucketBuilder_ == null) {
        if (stepInfoCase_ == 28
            && stepInfo_
                != com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1.StorageBucketInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 28) {
          storageBucketBuilder_.mergeFrom(value);
        } else {
          storageBucketBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    public Builder clearStorageBucket() {
      if (storageBucketBuilder_ == null) {
        if (stepInfoCase_ == 28) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 28) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        storageBucketBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    public com.google.cloud.networkmanagement.v1.StorageBucketInfo.Builder
        getStorageBucketBuilder() {
      return getStorageBucketFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.StorageBucketInfoOrBuilder
        getStorageBucketOrBuilder() {
      if ((stepInfoCase_ == 28) && (storageBucketBuilder_ != null)) {
        return storageBucketBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 28) {
          return (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Storage Bucket. Used only for return traces.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.StorageBucketInfo storage_bucket = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1.StorageBucketInfo,
            com.google.cloud.networkmanagement.v1.StorageBucketInfo.Builder,
            com.google.cloud.networkmanagement.v1.StorageBucketInfoOrBuilder>
        getStorageBucketFieldBuilder() {
      if (storageBucketBuilder_ == null) {
        if (!(stepInfoCase_ == 28)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1.StorageBucketInfo.getDefaultInstance();
        }
        storageBucketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1.StorageBucketInfo,
                com.google.cloud.networkmanagement.v1.StorageBucketInfo.Builder,
                com.google.cloud.networkmanagement.v1.StorageBucketInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1.StorageBucketInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 28;
      onChanged();
      return storageBucketBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.Step)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.Step)
  private static final com.google.cloud.networkmanagement.v1.Step DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.Step();
  }

  public static com.google.cloud.networkmanagement.v1.Step getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Step> PARSER =
      new com.google.protobuf.AbstractParser<Step>() {
        @java.lang.Override
        public Step parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Step> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Step> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.Step getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
