/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1/trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.networkmanagement.v1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a Compute Engine VPN tunnel.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1.VpnTunnelInfo}
 */
public final class VpnTunnelInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1.VpnTunnelInfo)
    VpnTunnelInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VpnTunnelInfo.newBuilder() to construct.
  private VpnTunnelInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VpnTunnelInfo() {
    displayName_ = "";
    uri_ = "";
    sourceGateway_ = "";
    remoteGateway_ = "";
    remoteGatewayIp_ = "";
    sourceGatewayIp_ = "";
    networkUri_ = "";
    region_ = "";
    routingType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VpnTunnelInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_VpnTunnelInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1_VpnTunnelInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1.VpnTunnelInfo.class,
            com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of VPN routing policy. For details, refer to [Networks and Tunnel
   * routing](https://cloud.google.com/network-connectivity/docs/vpn/concepts/choosing-networks-routing/).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType}
   */
  public enum RoutingType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>ROUTING_TYPE_UNSPECIFIED = 0;</code>
     */
    ROUTING_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Route based VPN.
     * </pre>
     *
     * <code>ROUTE_BASED = 1;</code>
     */
    ROUTE_BASED(1),
    /**
     *
     *
     * <pre>
     * Policy based routing.
     * </pre>
     *
     * <code>POLICY_BASED = 2;</code>
     */
    POLICY_BASED(2),
    /**
     *
     *
     * <pre>
     * Dynamic (BGP) routing.
     * </pre>
     *
     * <code>DYNAMIC = 3;</code>
     */
    DYNAMIC(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>ROUTING_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ROUTING_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Route based VPN.
     * </pre>
     *
     * <code>ROUTE_BASED = 1;</code>
     */
    public static final int ROUTE_BASED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Policy based routing.
     * </pre>
     *
     * <code>POLICY_BASED = 2;</code>
     */
    public static final int POLICY_BASED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Dynamic (BGP) routing.
     * </pre>
     *
     * <code>DYNAMIC = 3;</code>
     */
    public static final int DYNAMIC_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoutingType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RoutingType forNumber(int value) {
      switch (value) {
        case 0:
          return ROUTING_TYPE_UNSPECIFIED;
        case 1:
          return ROUTE_BASED;
        case 2:
          return POLICY_BASED;
        case 3:
          return DYNAMIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RoutingType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RoutingType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RoutingType>() {
          public RoutingType findValueByNumber(int number) {
            return RoutingType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RoutingType[] VALUES = values();

    public static RoutingType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RoutingType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType)
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Name of a VPN tunnel.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a VPN tunnel.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a VPN tunnel.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a VPN tunnel.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_GATEWAY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceGateway_ = "";
  /**
   *
   *
   * <pre>
   * URI of the VPN gateway at local end of the tunnel.
   * </pre>
   *
   * <code>string source_gateway = 3;</code>
   *
   * @return The sourceGateway.
   */
  @java.lang.Override
  public java.lang.String getSourceGateway() {
    java.lang.Object ref = sourceGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceGateway_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the VPN gateway at local end of the tunnel.
   * </pre>
   *
   * <code>string source_gateway = 3;</code>
   *
   * @return The bytes for sourceGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceGatewayBytes() {
    java.lang.Object ref = sourceGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_GATEWAY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteGateway_ = "";
  /**
   *
   *
   * <pre>
   * URI of a VPN gateway at remote end of the tunnel.
   * </pre>
   *
   * <code>string remote_gateway = 4;</code>
   *
   * @return The remoteGateway.
   */
  @java.lang.Override
  public java.lang.String getRemoteGateway() {
    java.lang.Object ref = remoteGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteGateway_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a VPN gateway at remote end of the tunnel.
   * </pre>
   *
   * <code>string remote_gateway = 4;</code>
   *
   * @return The bytes for remoteGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRemoteGatewayBytes() {
    java.lang.Object ref = remoteGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_GATEWAY_IP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteGatewayIp_ = "";
  /**
   *
   *
   * <pre>
   * Remote VPN gateway's IP address.
   * </pre>
   *
   * <code>string remote_gateway_ip = 5;</code>
   *
   * @return The remoteGatewayIp.
   */
  @java.lang.Override
  public java.lang.String getRemoteGatewayIp() {
    java.lang.Object ref = remoteGatewayIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteGatewayIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Remote VPN gateway's IP address.
   * </pre>
   *
   * <code>string remote_gateway_ip = 5;</code>
   *
   * @return The bytes for remoteGatewayIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRemoteGatewayIpBytes() {
    java.lang.Object ref = remoteGatewayIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteGatewayIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_GATEWAY_IP_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceGatewayIp_ = "";
  /**
   *
   *
   * <pre>
   * Local VPN gateway's IP address.
   * </pre>
   *
   * <code>string source_gateway_ip = 6;</code>
   *
   * @return The sourceGatewayIp.
   */
  @java.lang.Override
  public java.lang.String getSourceGatewayIp() {
    java.lang.Object ref = sourceGatewayIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceGatewayIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Local VPN gateway's IP address.
   * </pre>
   *
   * <code>string source_gateway_ip = 6;</code>
   *
   * @return The bytes for sourceGatewayIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceGatewayIpBytes() {
    java.lang.Object ref = sourceGatewayIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceGatewayIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network where the VPN tunnel is configured.
   * </pre>
   *
   * <code>string network_uri = 7;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network where the VPN tunnel is configured.
   * </pre>
   *
   * <code>string network_uri = 7;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * Name of a Google Cloud region where this VPN tunnel is configured.
   * </pre>
   *
   * <code>string region = 8;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a Google Cloud region where this VPN tunnel is configured.
   * </pre>
   *
   * <code>string region = 8;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTING_TYPE_FIELD_NUMBER = 9;
  private int routingType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of the routing policy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
   *
   * @return The enum numeric value on the wire for routingType.
   */
  @java.lang.Override
  public int getRoutingTypeValue() {
    return routingType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the routing policy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
   *
   * @return The routingType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType getRoutingType() {
    com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType result =
        com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType.forNumber(routingType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceGateway_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceGateway_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteGateway_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, remoteGateway_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteGatewayIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, remoteGatewayIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceGatewayIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sourceGatewayIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, networkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, region_);
    }
    if (routingType_
        != com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType.ROUTING_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, routingType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceGateway_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceGateway_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteGateway_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, remoteGateway_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(remoteGatewayIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, remoteGatewayIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceGatewayIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sourceGatewayIp_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, networkUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, region_);
    }
    if (routingType_
        != com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType.ROUTING_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, routingType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1.VpnTunnelInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1.VpnTunnelInfo other =
        (com.google.cloud.networkmanagement.v1.VpnTunnelInfo) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getSourceGateway().equals(other.getSourceGateway())) return false;
    if (!getRemoteGateway().equals(other.getRemoteGateway())) return false;
    if (!getRemoteGatewayIp().equals(other.getRemoteGatewayIp())) return false;
    if (!getSourceGatewayIp().equals(other.getSourceGatewayIp())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getRegion().equals(other.getRegion())) return false;
    if (routingType_ != other.routingType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + SOURCE_GATEWAY_FIELD_NUMBER;
    hash = (53 * hash) + getSourceGateway().hashCode();
    hash = (37 * hash) + REMOTE_GATEWAY_FIELD_NUMBER;
    hash = (53 * hash) + getRemoteGateway().hashCode();
    hash = (37 * hash) + REMOTE_GATEWAY_IP_FIELD_NUMBER;
    hash = (53 * hash) + getRemoteGatewayIp().hashCode();
    hash = (37 * hash) + SOURCE_GATEWAY_IP_FIELD_NUMBER;
    hash = (53 * hash) + getSourceGatewayIp().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (37 * hash) + REGION_FIELD_NUMBER;
    hash = (53 * hash) + getRegion().hashCode();
    hash = (37 * hash) + ROUTING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + routingType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1.VpnTunnelInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a Compute Engine VPN tunnel.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1.VpnTunnelInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1.VpnTunnelInfo)
      com.google.cloud.networkmanagement.v1.VpnTunnelInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_VpnTunnelInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_VpnTunnelInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1.VpnTunnelInfo.class,
              com.google.cloud.networkmanagement.v1.VpnTunnelInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1.VpnTunnelInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      uri_ = "";
      sourceGateway_ = "";
      remoteGateway_ = "";
      remoteGatewayIp_ = "";
      sourceGatewayIp_ = "";
      networkUri_ = "";
      region_ = "";
      routingType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1_VpnTunnelInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfo build() {
      com.google.cloud.networkmanagement.v1.VpnTunnelInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfo buildPartial() {
      com.google.cloud.networkmanagement.v1.VpnTunnelInfo result =
          new com.google.cloud.networkmanagement.v1.VpnTunnelInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networkmanagement.v1.VpnTunnelInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sourceGateway_ = sourceGateway_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.remoteGateway_ = remoteGateway_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.remoteGatewayIp_ = remoteGatewayIp_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceGatewayIp_ = sourceGatewayIp_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.networkUri_ = networkUri_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.region_ = region_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.routingType_ = routingType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1.VpnTunnelInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1.VpnTunnelInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1.VpnTunnelInfo other) {
      if (other == com.google.cloud.networkmanagement.v1.VpnTunnelInfo.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSourceGateway().isEmpty()) {
        sourceGateway_ = other.sourceGateway_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getRemoteGateway().isEmpty()) {
        remoteGateway_ = other.remoteGateway_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getRemoteGatewayIp().isEmpty()) {
        remoteGatewayIp_ = other.remoteGatewayIp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getSourceGatewayIp().isEmpty()) {
        sourceGatewayIp_ = other.sourceGatewayIp_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getRegion().isEmpty()) {
        region_ = other.region_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.routingType_ != 0) {
        setRoutingTypeValue(other.getRoutingTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                sourceGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                remoteGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                remoteGatewayIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                sourceGatewayIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                routingType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name of a VPN tunnel.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a VPN tunnel.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a VPN tunnel.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a VPN tunnel.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a VPN tunnel.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a VPN tunnel.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN tunnel.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN tunnel.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN tunnel.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN tunnel.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object sourceGateway_ = "";
    /**
     *
     *
     * <pre>
     * URI of the VPN gateway at local end of the tunnel.
     * </pre>
     *
     * <code>string source_gateway = 3;</code>
     *
     * @return The sourceGateway.
     */
    public java.lang.String getSourceGateway() {
      java.lang.Object ref = sourceGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the VPN gateway at local end of the tunnel.
     * </pre>
     *
     * <code>string source_gateway = 3;</code>
     *
     * @return The bytes for sourceGateway.
     */
    public com.google.protobuf.ByteString getSourceGatewayBytes() {
      java.lang.Object ref = sourceGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the VPN gateway at local end of the tunnel.
     * </pre>
     *
     * <code>string source_gateway = 3;</code>
     *
     * @param value The sourceGateway to set.
     * @return This builder for chaining.
     */
    public Builder setSourceGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceGateway_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the VPN gateway at local end of the tunnel.
     * </pre>
     *
     * <code>string source_gateway = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceGateway() {
      sourceGateway_ = getDefaultInstance().getSourceGateway();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the VPN gateway at local end of the tunnel.
     * </pre>
     *
     * <code>string source_gateway = 3;</code>
     *
     * @param value The bytes for sourceGateway to set.
     * @return This builder for chaining.
     */
    public Builder setSourceGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceGateway_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object remoteGateway_ = "";
    /**
     *
     *
     * <pre>
     * URI of a VPN gateway at remote end of the tunnel.
     * </pre>
     *
     * <code>string remote_gateway = 4;</code>
     *
     * @return The remoteGateway.
     */
    public java.lang.String getRemoteGateway() {
      java.lang.Object ref = remoteGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN gateway at remote end of the tunnel.
     * </pre>
     *
     * <code>string remote_gateway = 4;</code>
     *
     * @return The bytes for remoteGateway.
     */
    public com.google.protobuf.ByteString getRemoteGatewayBytes() {
      java.lang.Object ref = remoteGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN gateway at remote end of the tunnel.
     * </pre>
     *
     * <code>string remote_gateway = 4;</code>
     *
     * @param value The remoteGateway to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteGateway_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN gateway at remote end of the tunnel.
     * </pre>
     *
     * <code>string remote_gateway = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteGateway() {
      remoteGateway_ = getDefaultInstance().getRemoteGateway();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a VPN gateway at remote end of the tunnel.
     * </pre>
     *
     * <code>string remote_gateway = 4;</code>
     *
     * @param value The bytes for remoteGateway to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteGateway_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object remoteGatewayIp_ = "";
    /**
     *
     *
     * <pre>
     * Remote VPN gateway's IP address.
     * </pre>
     *
     * <code>string remote_gateway_ip = 5;</code>
     *
     * @return The remoteGatewayIp.
     */
    public java.lang.String getRemoteGatewayIp() {
      java.lang.Object ref = remoteGatewayIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteGatewayIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Remote VPN gateway's IP address.
     * </pre>
     *
     * <code>string remote_gateway_ip = 5;</code>
     *
     * @return The bytes for remoteGatewayIp.
     */
    public com.google.protobuf.ByteString getRemoteGatewayIpBytes() {
      java.lang.Object ref = remoteGatewayIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteGatewayIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Remote VPN gateway's IP address.
     * </pre>
     *
     * <code>string remote_gateway_ip = 5;</code>
     *
     * @param value The remoteGatewayIp to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteGatewayIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteGatewayIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Remote VPN gateway's IP address.
     * </pre>
     *
     * <code>string remote_gateway_ip = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteGatewayIp() {
      remoteGatewayIp_ = getDefaultInstance().getRemoteGatewayIp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Remote VPN gateway's IP address.
     * </pre>
     *
     * <code>string remote_gateway_ip = 5;</code>
     *
     * @param value The bytes for remoteGatewayIp to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteGatewayIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteGatewayIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object sourceGatewayIp_ = "";
    /**
     *
     *
     * <pre>
     * Local VPN gateway's IP address.
     * </pre>
     *
     * <code>string source_gateway_ip = 6;</code>
     *
     * @return The sourceGatewayIp.
     */
    public java.lang.String getSourceGatewayIp() {
      java.lang.Object ref = sourceGatewayIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceGatewayIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Local VPN gateway's IP address.
     * </pre>
     *
     * <code>string source_gateway_ip = 6;</code>
     *
     * @return The bytes for sourceGatewayIp.
     */
    public com.google.protobuf.ByteString getSourceGatewayIpBytes() {
      java.lang.Object ref = sourceGatewayIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceGatewayIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Local VPN gateway's IP address.
     * </pre>
     *
     * <code>string source_gateway_ip = 6;</code>
     *
     * @param value The sourceGatewayIp to set.
     * @return This builder for chaining.
     */
    public Builder setSourceGatewayIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceGatewayIp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Local VPN gateway's IP address.
     * </pre>
     *
     * <code>string source_gateway_ip = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceGatewayIp() {
      sourceGatewayIp_ = getDefaultInstance().getSourceGatewayIp();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Local VPN gateway's IP address.
     * </pre>
     *
     * <code>string source_gateway_ip = 6;</code>
     *
     * @param value The bytes for sourceGatewayIp to set.
     * @return This builder for chaining.
     */
    public Builder setSourceGatewayIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceGatewayIp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network where the VPN tunnel is configured.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network where the VPN tunnel is configured.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network where the VPN tunnel is configured.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network where the VPN tunnel is configured.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network where the VPN tunnel is configured.
     * </pre>
     *
     * <code>string network_uri = 7;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * Name of a Google Cloud region where this VPN tunnel is configured.
     * </pre>
     *
     * <code>string region = 8;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Google Cloud region where this VPN tunnel is configured.
     * </pre>
     *
     * <code>string region = 8;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Google Cloud region where this VPN tunnel is configured.
     * </pre>
     *
     * <code>string region = 8;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Google Cloud region where this VPN tunnel is configured.
     * </pre>
     *
     * <code>string region = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Google Cloud region where this VPN tunnel is configured.
     * </pre>
     *
     * <code>string region = 8;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int routingType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the routing policy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
     *
     * @return The enum numeric value on the wire for routingType.
     */
    @java.lang.Override
    public int getRoutingTypeValue() {
      return routingType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the routing policy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
     *
     * @param value The enum numeric value on the wire for routingType to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingTypeValue(int value) {
      routingType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the routing policy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
     *
     * @return The routingType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType getRoutingType() {
      com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType result =
          com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType.forNumber(routingType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the routing policy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
     *
     * @param value The routingType to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingType(
        com.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      routingType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the routing policy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType routing_type = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutingType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      routingType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1.VpnTunnelInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1.VpnTunnelInfo)
  private static final com.google.cloud.networkmanagement.v1.VpnTunnelInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1.VpnTunnelInfo();
  }

  public static com.google.cloud.networkmanagement.v1.VpnTunnelInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VpnTunnelInfo> PARSER =
      new com.google.protobuf.AbstractParser<VpnTunnelInfo>() {
        @java.lang.Override
        public VpnTunnelInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VpnTunnelInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VpnTunnelInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1.VpnTunnelInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
