/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networksecurity/v1beta1/authorization_policy.proto

package com.google.cloud.networksecurity.v1beta1;

/**
 *
 *
 * <pre>
 * AuthorizationPolicy is a resource that specifies how a server
 * should authorize incoming connections. This resource in itself does
 * not change the configuration unless it's attached to a target https
 * proxy or endpoint config selector resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy}
 */
public final class AuthorizationPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy)
    AuthorizationPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuthorizationPolicy.newBuilder() to construct.
  private AuthorizationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuthorizationPolicy() {
    name_ = "";
    description_ = "";
    action_ = 0;
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuthorizationPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
        .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
        .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.class,
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible values that define what action to take.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action}
   */
  public enum Action implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    ACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Grant access.
     * </pre>
     *
     * <code>ALLOW = 1;</code>
     */
    ALLOW(1),
    /**
     *
     *
     * <pre>
     * Deny access.
     * Deny rules should be avoided unless they are used to provide a default
     * "deny all" fallback.
     * </pre>
     *
     * <code>DENY = 2;</code>
     */
    DENY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    public static final int ACTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Grant access.
     * </pre>
     *
     * <code>ALLOW = 1;</code>
     */
    public static final int ALLOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Deny access.
     * Deny rules should be avoided unless they are used to provide a default
     * "deny all" fallback.
     * </pre>
     *
     * <code>DENY = 2;</code>
     */
    public static final int DENY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0:
          return ACTION_UNSPECIFIED;
        case 1:
          return ALLOW;
        case 2:
          return DENY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Action>() {
          public Action findValueByNumber(int number) {
            return Action.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action)
  }

  public interface RuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>
        getSourcesList();
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source getSources(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSourcesCount();
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder>
        getSourcesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder
        getSourcesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>
        getDestinationsList();
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination getDestinations(
        int index);
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getDestinationsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                    .DestinationOrBuilder>
        getDestinationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.DestinationOrBuilder
        getDestinationsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Specification of rules.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule}
   */
  public static final class Rule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule)
      RuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Rule.newBuilder() to construct.
    private Rule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Rule() {
      sources_ = java.util.Collections.emptyList();
      destinations_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Rule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.class,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder.class);
    }

    public interface SourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the principals.
       */
      java.util.List<java.lang.String> getPrincipalsList();
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of principals.
       */
      int getPrincipalsCount();
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The principals at the given index.
       */
      java.lang.String getPrincipals(int index);
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the principals at the given index.
       */
      com.google.protobuf.ByteString getPrincipalsBytes(int index);

      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ipBlocks.
       */
      java.util.List<java.lang.String> getIpBlocksList();
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ipBlocks.
       */
      int getIpBlocksCount();
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ipBlocks at the given index.
       */
      java.lang.String getIpBlocks(int index);
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ipBlocks at the given index.
       */
      com.google.protobuf.ByteString getIpBlocksBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Specification of traffic source attributes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source}
     */
    public static final class Source extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source)
        SourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Source.newBuilder() to construct.
      private Source(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Source() {
        principals_ = com.google.protobuf.LazyStringArrayList.emptyList();
        ipBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Source();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Source_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Source_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.class,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
                    .class);
      }

      public static final int PRINCIPALS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList principals_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the principals.
       */
      public com.google.protobuf.ProtocolStringList getPrincipalsList() {
        return principals_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of principals.
       */
      public int getPrincipalsCount() {
        return principals_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The principals at the given index.
       */
      public java.lang.String getPrincipals(int index) {
        return principals_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of peer identities to match for authorization. At least
       * one principal should match. Each peer can be an exact match, or a
       * prefix match (example, "namespace/&#42;") or a suffix match (example,
       * "*&#47;service-account") or a presence match "*". Authorization based on
       * the principal name without certificate validation (configured by
       * ServerTlsPolicy resource) is considered insecure.
       * </pre>
       *
       * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the principals at the given index.
       */
      public com.google.protobuf.ByteString getPrincipalsBytes(int index) {
        return principals_.getByteString(index);
      }

      public static final int IP_BLOCKS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList ipBlocks_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ipBlocks.
       */
      public com.google.protobuf.ProtocolStringList getIpBlocksList() {
        return ipBlocks_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ipBlocks.
       */
      public int getIpBlocksCount() {
        return ipBlocks_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ipBlocks at the given index.
       */
      public java.lang.String getIpBlocks(int index) {
        return ipBlocks_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of CIDR ranges to match based on source IP address. At
       * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
       * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
       * alone should be avoided. The IP addresses of any load balancers or
       * proxies should be considered untrusted.
       * </pre>
       *
       * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ipBlocks at the given index.
       */
      public com.google.protobuf.ByteString getIpBlocksBytes(int index) {
        return ipBlocks_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < principals_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principals_.getRaw(i));
        }
        for (int i = 0; i < ipBlocks_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ipBlocks_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < principals_.size(); i++) {
            dataSize += computeStringSizeNoTag(principals_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getPrincipalsList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < ipBlocks_.size(); i++) {
            dataSize += computeStringSizeNoTag(ipBlocks_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getIpBlocksList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source)) {
          return super.equals(obj);
        }
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source other =
            (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source) obj;

        if (!getPrincipalsList().equals(other.getPrincipalsList())) return false;
        if (!getIpBlocksList().equals(other.getIpBlocksList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getPrincipalsCount() > 0) {
          hash = (37 * hash) + PRINCIPALS_FIELD_NUMBER;
          hash = (53 * hash) + getPrincipalsList().hashCode();
        }
        if (getIpBlocksCount() > 0) {
          hash = (37 * hash) + IP_BLOCKS_FIELD_NUMBER;
          hash = (53 * hash) + getIpBlocksList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specification of traffic source attributes.
       * </pre>
       *
       * Protobuf type {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source)
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Source_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Source_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.class,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          principals_ = com.google.protobuf.LazyStringArrayList.emptyList();
          ipBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Source_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
            getDefaultInstanceForType() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source build() {
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
            buildPartial() {
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source result =
              new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            principals_.makeImmutable();
            result.principals_ = principals_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            ipBlocks_.makeImmutable();
            result.ipBlocks_ = ipBlocks_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source) {
            return mergeFrom(
                (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source other) {
          if (other
              == com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
                  .getDefaultInstance()) return this;
          if (!other.principals_.isEmpty()) {
            if (principals_.isEmpty()) {
              principals_ = other.principals_;
              bitField0_ |= 0x00000001;
            } else {
              ensurePrincipalsIsMutable();
              principals_.addAll(other.principals_);
            }
            onChanged();
          }
          if (!other.ipBlocks_.isEmpty()) {
            if (ipBlocks_.isEmpty()) {
              ipBlocks_ = other.ipBlocks_;
              bitField0_ |= 0x00000002;
            } else {
              ensureIpBlocksIsMutable();
              ipBlocks_.addAll(other.ipBlocks_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensurePrincipalsIsMutable();
                    principals_.add(s);
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureIpBlocksIsMutable();
                    ipBlocks_.add(s);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList principals_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensurePrincipalsIsMutable() {
          if (!principals_.isModifiable()) {
            principals_ = new com.google.protobuf.LazyStringArrayList(principals_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the principals.
         */
        public com.google.protobuf.ProtocolStringList getPrincipalsList() {
          principals_.makeImmutable();
          return principals_;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of principals.
         */
        public int getPrincipalsCount() {
          return principals_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The principals at the given index.
         */
        public java.lang.String getPrincipals(int index) {
          return principals_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the principals at the given index.
         */
        public com.google.protobuf.ByteString getPrincipalsBytes(int index) {
          return principals_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The principals to set.
         * @return This builder for chaining.
         */
        public Builder setPrincipals(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePrincipalsIsMutable();
          principals_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The principals to add.
         * @return This builder for chaining.
         */
        public Builder addPrincipals(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePrincipalsIsMutable();
          principals_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The principals to add.
         * @return This builder for chaining.
         */
        public Builder addAllPrincipals(java.lang.Iterable<java.lang.String> values) {
          ensurePrincipalsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, principals_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPrincipals() {
          principals_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of peer identities to match for authorization. At least
         * one principal should match. Each peer can be an exact match, or a
         * prefix match (example, "namespace/&#42;") or a suffix match (example,
         * "*&#47;service-account") or a presence match "*". Authorization based on
         * the principal name without certificate validation (configured by
         * ServerTlsPolicy resource) is considered insecure.
         * </pre>
         *
         * <code>repeated string principals = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the principals to add.
         * @return This builder for chaining.
         */
        public Builder addPrincipalsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensurePrincipalsIsMutable();
          principals_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList ipBlocks_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureIpBlocksIsMutable() {
          if (!ipBlocks_.isModifiable()) {
            ipBlocks_ = new com.google.protobuf.LazyStringArrayList(ipBlocks_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the ipBlocks.
         */
        public com.google.protobuf.ProtocolStringList getIpBlocksList() {
          ipBlocks_.makeImmutable();
          return ipBlocks_;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of ipBlocks.
         */
        public int getIpBlocksCount() {
          return ipBlocks_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The ipBlocks at the given index.
         */
        public java.lang.String getIpBlocks(int index) {
          return ipBlocks_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the ipBlocks at the given index.
         */
        public com.google.protobuf.ByteString getIpBlocksBytes(int index) {
          return ipBlocks_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The ipBlocks to set.
         * @return This builder for chaining.
         */
        public Builder setIpBlocks(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpBlocksIsMutable();
          ipBlocks_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The ipBlocks to add.
         * @return This builder for chaining.
         */
        public Builder addIpBlocks(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpBlocksIsMutable();
          ipBlocks_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The ipBlocks to add.
         * @return This builder for chaining.
         */
        public Builder addAllIpBlocks(java.lang.Iterable<java.lang.String> values) {
          ensureIpBlocksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipBlocks_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIpBlocks() {
          ipBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. List of CIDR ranges to match based on source IP address. At
         * least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
         * (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
         * alone should be avoided. The IP addresses of any load balancers or
         * proxies should be considered untrusted.
         * </pre>
         *
         * <code>repeated string ip_blocks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the ipBlocks to add.
         * @return This builder for chaining.
         */
        public Builder addIpBlocksBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureIpBlocksIsMutable();
          ipBlocks_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source)
      private static final com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source();
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Source> PARSER =
          new com.google.protobuf.AbstractParser<Source>() {
            @java.lang.Override
            public Source parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Source> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Source> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DestinationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the hosts.
       */
      java.util.List<java.lang.String> getHostsList();
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of hosts.
       */
      int getHostsCount();
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The hosts at the given index.
       */
      java.lang.String getHosts(int index);
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the hosts at the given index.
       */
      com.google.protobuf.ByteString getHostsBytes(int index);

      /**
       *
       *
       * <pre>
       * Required. List of destination ports to match. At least one port should
       * match.
       * </pre>
       *
       * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the ports.
       */
      java.util.List<java.lang.Integer> getPortsList();
      /**
       *
       *
       * <pre>
       * Required. List of destination ports to match. At least one port should
       * match.
       * </pre>
       *
       * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of ports.
       */
      int getPortsCount();
      /**
       *
       *
       * <pre>
       * Required. List of destination ports to match. At least one port should
       * match.
       * </pre>
       *
       * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The ports at the given index.
       */
      int getPorts(int index);

      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the methods.
       */
      java.util.List<java.lang.String> getMethodsList();
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of methods.
       */
      int getMethodsCount();
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The methods at the given index.
       */
      java.lang.String getMethods(int index);
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the methods at the given index.
       */
      com.google.protobuf.ByteString getMethodsBytes(int index);

      /**
       *
       *
       * <pre>
       * Optional. Match against key:value pair in http header. Provides a
       * flexible match based on HTTP headers, for potentially advanced use
       * cases. At least one header should match. Avoid using header matches to
       * make authorization decisions unless there is a strong guarantee that
       * requests arrive through a trusted client or proxy.
       * </pre>
       *
       * <code>
       * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the httpHeaderMatch field is set.
       */
      boolean hasHttpHeaderMatch();
      /**
       *
       *
       * <pre>
       * Optional. Match against key:value pair in http header. Provides a
       * flexible match based on HTTP headers, for potentially advanced use
       * cases. At least one header should match. Avoid using header matches to
       * make authorization decisions unless there is a strong guarantee that
       * requests arrive through a trusted client or proxy.
       * </pre>
       *
       * <code>
       * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The httpHeaderMatch.
       */
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch
          getHttpHeaderMatch();
      /**
       *
       *
       * <pre>
       * Optional. Match against key:value pair in http header. Provides a
       * flexible match based on HTTP headers, for potentially advanced use
       * cases. At least one header should match. Avoid using header matches to
       * make authorization decisions unless there is a strong guarantee that
       * requests arrive through a trusted client or proxy.
       * </pre>
       *
       * <code>
       * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
              .HttpHeaderMatchOrBuilder
          getHttpHeaderMatchOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification of traffic destination attributes.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination}
     */
    public static final class Destination extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)
        DestinationOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Destination.newBuilder() to construct.
      private Destination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Destination() {
        hosts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        ports_ = emptyIntList();
        methods_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Destination();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.class,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .Builder.class);
      }

      public interface HttpHeaderMatchOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The value of the header must match the regular expression
         * specified in regexMatch. For regular expression grammar,
         * please see: en.cppreference.com/w/cpp/regex/ecmascript
         * For matching against a port specified in the HTTP
         * request, use a headerMatch with headerName set to Host
         * and a regular expression that satisfies the RFC2616 Host
         * header's port specifier.
         * </pre>
         *
         * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return Whether the regexMatch field is set.
         */
        boolean hasRegexMatch();
        /**
         *
         *
         * <pre>
         * Required. The value of the header must match the regular expression
         * specified in regexMatch. For regular expression grammar,
         * please see: en.cppreference.com/w/cpp/regex/ecmascript
         * For matching against a port specified in the HTTP
         * request, use a headerMatch with headerName set to Host
         * and a regular expression that satisfies the RFC2616 Host
         * header's port specifier.
         * </pre>
         *
         * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The regexMatch.
         */
        java.lang.String getRegexMatch();
        /**
         *
         *
         * <pre>
         * Required. The value of the header must match the regular expression
         * specified in regexMatch. For regular expression grammar,
         * please see: en.cppreference.com/w/cpp/regex/ecmascript
         * For matching against a port specified in the HTTP
         * request, use a headerMatch with headerName set to Host
         * and a regular expression that satisfies the RFC2616 Host
         * header's port specifier.
         * </pre>
         *
         * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for regexMatch.
         */
        com.google.protobuf.ByteString getRegexMatchBytes();

        /**
         *
         *
         * <pre>
         * Required. The name of the HTTP header to match. For matching
         * against the HTTP request's authority, use a headerMatch
         * with the header name ":authority". For matching a
         * request's method, use the headerName ":method".
         * </pre>
         *
         * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The headerName.
         */
        java.lang.String getHeaderName();
        /**
         *
         *
         * <pre>
         * Required. The name of the HTTP header to match. For matching
         * against the HTTP request's authority, use a headerMatch
         * with the header name ":authority". For matching a
         * request's method, use the headerName ":method".
         * </pre>
         *
         * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for headerName.
         */
        com.google.protobuf.ByteString getHeaderNameBytes();

        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch.TypeCase
            getTypeCase();
      }
      /**
       *
       *
       * <pre>
       * Specification of HTTP header match attributes.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch}
       */
      public static final class HttpHeaderMatch extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch)
          HttpHeaderMatchOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use HttpHeaderMatch.newBuilder() to construct.
        private HttpHeaderMatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private HttpHeaderMatch() {
          headerName_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new HttpHeaderMatch();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .HttpHeaderMatch.class,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .HttpHeaderMatch.Builder.class);
        }

        private int typeCase_ = 0;

        @SuppressWarnings("serial")
        private java.lang.Object type_;

        public enum TypeCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          REGEX_MATCH(2),
          TYPE_NOT_SET(0);
          private final int value;

          private TypeCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static TypeCase valueOf(int value) {
            return forNumber(value);
          }

          public static TypeCase forNumber(int value) {
            switch (value) {
              case 2:
                return REGEX_MATCH;
              case 0:
                return TYPE_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public TypeCase getTypeCase() {
          return TypeCase.forNumber(typeCase_);
        }

        public static final int REGEX_MATCH_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * Required. The value of the header must match the regular expression
         * specified in regexMatch. For regular expression grammar,
         * please see: en.cppreference.com/w/cpp/regex/ecmascript
         * For matching against a port specified in the HTTP
         * request, use a headerMatch with headerName set to Host
         * and a regular expression that satisfies the RFC2616 Host
         * header's port specifier.
         * </pre>
         *
         * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return Whether the regexMatch field is set.
         */
        public boolean hasRegexMatch() {
          return typeCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Required. The value of the header must match the regular expression
         * specified in regexMatch. For regular expression grammar,
         * please see: en.cppreference.com/w/cpp/regex/ecmascript
         * For matching against a port specified in the HTTP
         * request, use a headerMatch with headerName set to Host
         * and a regular expression that satisfies the RFC2616 Host
         * header's port specifier.
         * </pre>
         *
         * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The regexMatch.
         */
        public java.lang.String getRegexMatch() {
          java.lang.Object ref = "";
          if (typeCase_ == 2) {
            ref = type_;
          }
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (typeCase_ == 2) {
              type_ = s;
            }
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The value of the header must match the regular expression
         * specified in regexMatch. For regular expression grammar,
         * please see: en.cppreference.com/w/cpp/regex/ecmascript
         * For matching against a port specified in the HTTP
         * request, use a headerMatch with headerName set to Host
         * and a regular expression that satisfies the RFC2616 Host
         * header's port specifier.
         * </pre>
         *
         * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for regexMatch.
         */
        public com.google.protobuf.ByteString getRegexMatchBytes() {
          java.lang.Object ref = "";
          if (typeCase_ == 2) {
            ref = type_;
          }
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (typeCase_ == 2) {
              type_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int HEADER_NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object headerName_ = "";
        /**
         *
         *
         * <pre>
         * Required. The name of the HTTP header to match. For matching
         * against the HTTP request's authority, use a headerMatch
         * with the header name ":authority". For matching a
         * request's method, use the headerName ":method".
         * </pre>
         *
         * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The headerName.
         */
        @java.lang.Override
        public java.lang.String getHeaderName() {
          java.lang.Object ref = headerName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            headerName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the HTTP header to match. For matching
         * against the HTTP request's authority, use a headerMatch
         * with the header name ":authority". For matching a
         * request's method, use the headerName ":method".
         * </pre>
         *
         * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for headerName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getHeaderNameBytes() {
          java.lang.Object ref = headerName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            headerName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headerName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, headerName_);
          }
          if (typeCase_ == 2) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headerName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, headerName_);
          }
          if (typeCase_ == 2) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .HttpHeaderMatch)) {
            return super.equals(obj);
          }
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .HttpHeaderMatch
              other =
                  (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                          .HttpHeaderMatch)
                      obj;

          if (!getHeaderName().equals(other.getHeaderName())) return false;
          if (!getTypeCase().equals(other.getTypeCase())) return false;
          switch (typeCase_) {
            case 2:
              if (!getRegexMatch().equals(other.getRegexMatch())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + HEADER_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getHeaderName().hashCode();
          switch (typeCase_) {
            case 2:
              hash = (37 * hash) + REGEX_MATCH_FIELD_NUMBER;
              hash = (53 * hash) + getRegexMatch().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specification of HTTP header match attributes.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch)
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatchOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
                .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
                .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                        .HttpHeaderMatch.class,
                    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                        .HttpHeaderMatch.Builder.class);
          }

          // Construct using
          // com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            headerName_ = "";
            typeCase_ = 0;
            type_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
                .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .HttpHeaderMatch
              getDefaultInstanceForType() {
            return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .HttpHeaderMatch
              build() {
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .HttpHeaderMatch
              buildPartial() {
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch
                result =
                    new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                        .Destination.HttpHeaderMatch(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            buildPartialOneofs(result);
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .HttpHeaderMatch
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.headerName_ = headerName_;
            }
          }

          private void buildPartialOneofs(
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .HttpHeaderMatch
                  result) {
            result.typeCase_ = typeCase_;
            result.type_ = this.type_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch) {
              return mergeFrom(
                  (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                          .HttpHeaderMatch)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .HttpHeaderMatch
                  other) {
            if (other
                == com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch.getDefaultInstance()) return this;
            if (!other.getHeaderName().isEmpty()) {
              headerName_ = other.headerName_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            switch (other.getTypeCase()) {
              case REGEX_MATCH:
                {
                  typeCase_ = 2;
                  type_ = other.type_;
                  onChanged();
                  break;
                }
              case TYPE_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      headerName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 10
                  case 18:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      typeCase_ = 2;
                      type_ = s;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int typeCase_ = 0;
          private java.lang.Object type_;

          public TypeCase getTypeCase() {
            return TypeCase.forNumber(typeCase_);
          }

          public Builder clearType() {
            typeCase_ = 0;
            type_ = null;
            onChanged();
            return this;
          }

          private int bitField0_;

          /**
           *
           *
           * <pre>
           * Required. The value of the header must match the regular expression
           * specified in regexMatch. For regular expression grammar,
           * please see: en.cppreference.com/w/cpp/regex/ecmascript
           * For matching against a port specified in the HTTP
           * request, use a headerMatch with headerName set to Host
           * and a regular expression that satisfies the RFC2616 Host
           * header's port specifier.
           * </pre>
           *
           * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return Whether the regexMatch field is set.
           */
          @java.lang.Override
          public boolean hasRegexMatch() {
            return typeCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * Required. The value of the header must match the regular expression
           * specified in regexMatch. For regular expression grammar,
           * please see: en.cppreference.com/w/cpp/regex/ecmascript
           * For matching against a port specified in the HTTP
           * request, use a headerMatch with headerName set to Host
           * and a regular expression that satisfies the RFC2616 Host
           * header's port specifier.
           * </pre>
           *
           * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The regexMatch.
           */
          @java.lang.Override
          public java.lang.String getRegexMatch() {
            java.lang.Object ref = "";
            if (typeCase_ == 2) {
              ref = type_;
            }
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (typeCase_ == 2) {
                type_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The value of the header must match the regular expression
           * specified in regexMatch. For regular expression grammar,
           * please see: en.cppreference.com/w/cpp/regex/ecmascript
           * For matching against a port specified in the HTTP
           * request, use a headerMatch with headerName set to Host
           * and a regular expression that satisfies the RFC2616 Host
           * header's port specifier.
           * </pre>
           *
           * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for regexMatch.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getRegexMatchBytes() {
            java.lang.Object ref = "";
            if (typeCase_ == 2) {
              ref = type_;
            }
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              if (typeCase_ == 2) {
                type_ = b;
              }
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The value of the header must match the regular expression
           * specified in regexMatch. For regular expression grammar,
           * please see: en.cppreference.com/w/cpp/regex/ecmascript
           * For matching against a port specified in the HTTP
           * request, use a headerMatch with headerName set to Host
           * and a regular expression that satisfies the RFC2616 Host
           * header's port specifier.
           * </pre>
           *
           * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The regexMatch to set.
           * @return This builder for chaining.
           */
          public Builder setRegexMatch(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            typeCase_ = 2;
            type_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The value of the header must match the regular expression
           * specified in regexMatch. For regular expression grammar,
           * please see: en.cppreference.com/w/cpp/regex/ecmascript
           * For matching against a port specified in the HTTP
           * request, use a headerMatch with headerName set to Host
           * and a regular expression that satisfies the RFC2616 Host
           * header's port specifier.
           * </pre>
           *
           * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearRegexMatch() {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The value of the header must match the regular expression
           * specified in regexMatch. For regular expression grammar,
           * please see: en.cppreference.com/w/cpp/regex/ecmascript
           * For matching against a port specified in the HTTP
           * request, use a headerMatch with headerName set to Host
           * and a regular expression that satisfies the RFC2616 Host
           * header's port specifier.
           * </pre>
           *
           * <code>string regex_match = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for regexMatch to set.
           * @return This builder for chaining.
           */
          public Builder setRegexMatchBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            typeCase_ = 2;
            type_ = value;
            onChanged();
            return this;
          }

          private java.lang.Object headerName_ = "";
          /**
           *
           *
           * <pre>
           * Required. The name of the HTTP header to match. For matching
           * against the HTTP request's authority, use a headerMatch
           * with the header name ":authority". For matching a
           * request's method, use the headerName ":method".
           * </pre>
           *
           * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The headerName.
           */
          public java.lang.String getHeaderName() {
            java.lang.Object ref = headerName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              headerName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the HTTP header to match. For matching
           * against the HTTP request's authority, use a headerMatch
           * with the header name ":authority". For matching a
           * request's method, use the headerName ":method".
           * </pre>
           *
           * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for headerName.
           */
          public com.google.protobuf.ByteString getHeaderNameBytes() {
            java.lang.Object ref = headerName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              headerName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the HTTP header to match. For matching
           * against the HTTP request's authority, use a headerMatch
           * with the header name ":authority". For matching a
           * request's method, use the headerName ":method".
           * </pre>
           *
           * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The headerName to set.
           * @return This builder for chaining.
           */
          public Builder setHeaderName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            headerName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the HTTP header to match. For matching
           * against the HTTP request's authority, use a headerMatch
           * with the header name ":authority". For matching a
           * request's method, use the headerName ":method".
           * </pre>
           *
           * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearHeaderName() {
            headerName_ = getDefaultInstance().getHeaderName();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the HTTP header to match. For matching
           * against the HTTP request's authority, use a headerMatch
           * with the header name ":authority". For matching a
           * request's method, use the headerName ":method".
           * </pre>
           *
           * <code>string header_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for headerName to set.
           * @return This builder for chaining.
           */
          public Builder setHeaderNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            headerName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch)
        private static final com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                .Destination.HttpHeaderMatch
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .HttpHeaderMatch();
        }

        public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<HttpHeaderMatch> PARSER =
            new com.google.protobuf.AbstractParser<HttpHeaderMatch>() {
              @java.lang.Override
              public HttpHeaderMatch parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<HttpHeaderMatch> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<HttpHeaderMatch> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int HOSTS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList hosts_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the hosts.
       */
      public com.google.protobuf.ProtocolStringList getHostsList() {
        return hosts_;
      }
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of hosts.
       */
      public int getHostsCount() {
        return hosts_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The hosts at the given index.
       */
      public java.lang.String getHosts(int index) {
        return hosts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. List of host names to match. Matched against the ":authority"
       * header in http requests. At least one host should match. Each host can
       * be an exact match, or a prefix match (example "mydomain.*") or a suffix
       * match (example "*.myorg.com") or a presence (any) match "*".
       * </pre>
       *
       * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the hosts at the given index.
       */
      public com.google.protobuf.ByteString getHostsBytes(int index) {
        return hosts_.getByteString(index);
      }

      public static final int PORTS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.Internal.IntList ports_;
      /**
       *
       *
       * <pre>
       * Required. List of destination ports to match. At least one port should
       * match.
       * </pre>
       *
       * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the ports.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer> getPortsList() {
        return ports_;
      }
      /**
       *
       *
       * <pre>
       * Required. List of destination ports to match. At least one port should
       * match.
       * </pre>
       *
       * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of ports.
       */
      public int getPortsCount() {
        return ports_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. List of destination ports to match. At least one port should
       * match.
       * </pre>
       *
       * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The ports at the given index.
       */
      public int getPorts(int index) {
        return ports_.getInt(index);
      }

      private int portsMemoizedSerializedSize = -1;

      public static final int METHODS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList methods_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the methods.
       */
      public com.google.protobuf.ProtocolStringList getMethodsList() {
        return methods_;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of methods.
       */
      public int getMethodsCount() {
        return methods_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The methods at the given index.
       */
      public java.lang.String getMethods(int index) {
        return methods_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of HTTP methods to match. At least one method should
       * match. Should not be set for gRPC services.
       * </pre>
       *
       * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the methods at the given index.
       */
      public com.google.protobuf.ByteString getMethodsBytes(int index) {
        return methods_.getByteString(index);
      }

      public static final int HTTP_HEADER_MATCH_FIELD_NUMBER = 5;
      private com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
              .HttpHeaderMatch
          httpHeaderMatch_;
      /**
       *
       *
       * <pre>
       * Optional. Match against key:value pair in http header. Provides a
       * flexible match based on HTTP headers, for potentially advanced use
       * cases. At least one header should match. Avoid using header matches to
       * make authorization decisions unless there is a strong guarantee that
       * requests arrive through a trusted client or proxy.
       * </pre>
       *
       * <code>
       * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the httpHeaderMatch field is set.
       */
      @java.lang.Override
      public boolean hasHttpHeaderMatch() {
        return httpHeaderMatch_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. Match against key:value pair in http header. Provides a
       * flexible match based on HTTP headers, for potentially advanced use
       * cases. At least one header should match. Avoid using header matches to
       * make authorization decisions unless there is a strong guarantee that
       * requests arrive through a trusted client or proxy.
       * </pre>
       *
       * <code>
       * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The httpHeaderMatch.
       */
      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
              .HttpHeaderMatch
          getHttpHeaderMatch() {
        return httpHeaderMatch_ == null
            ? com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch.getDefaultInstance()
            : httpHeaderMatch_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Match against key:value pair in http header. Provides a
       * flexible match based on HTTP headers, for potentially advanced use
       * cases. At least one header should match. Avoid using header matches to
       * make authorization decisions unless there is a strong guarantee that
       * requests arrive through a trusted client or proxy.
       * </pre>
       *
       * <code>
       * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
              .HttpHeaderMatchOrBuilder
          getHttpHeaderMatchOrBuilder() {
        return httpHeaderMatch_ == null
            ? com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch.getDefaultInstance()
            : httpHeaderMatch_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        for (int i = 0; i < hosts_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hosts_.getRaw(i));
        }
        if (getPortsList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(portsMemoizedSerializedSize);
        }
        for (int i = 0; i < ports_.size(); i++) {
          output.writeUInt32NoTag(ports_.getInt(i));
        }
        for (int i = 0; i < methods_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, methods_.getRaw(i));
        }
        if (httpHeaderMatch_ != null) {
          output.writeMessage(5, getHttpHeaderMatch());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < hosts_.size(); i++) {
            dataSize += computeStringSizeNoTag(hosts_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getHostsList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < ports_.size(); i++) {
            dataSize +=
                com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(ports_.getInt(i));
          }
          size += dataSize;
          if (!getPortsList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          portsMemoizedSerializedSize = dataSize;
        }
        {
          int dataSize = 0;
          for (int i = 0; i < methods_.size(); i++) {
            dataSize += computeStringSizeNoTag(methods_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getMethodsList().size();
        }
        if (httpHeaderMatch_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getHttpHeaderMatch());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)) {
          return super.equals(obj);
        }
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination other =
            (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination) obj;

        if (!getHostsList().equals(other.getHostsList())) return false;
        if (!getPortsList().equals(other.getPortsList())) return false;
        if (!getMethodsList().equals(other.getMethodsList())) return false;
        if (hasHttpHeaderMatch() != other.hasHttpHeaderMatch()) return false;
        if (hasHttpHeaderMatch()) {
          if (!getHttpHeaderMatch().equals(other.getHttpHeaderMatch())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getHostsCount() > 0) {
          hash = (37 * hash) + HOSTS_FIELD_NUMBER;
          hash = (53 * hash) + getHostsList().hashCode();
        }
        if (getPortsCount() > 0) {
          hash = (37 * hash) + PORTS_FIELD_NUMBER;
          hash = (53 * hash) + getPortsList().hashCode();
        }
        if (getMethodsCount() > 0) {
          hash = (37 * hash) + METHODS_FIELD_NUMBER;
          hash = (53 * hash) + getMethodsList().hashCode();
        }
        if (hasHttpHeaderMatch()) {
          hash = (37 * hash) + HTTP_HEADER_MATCH_FIELD_NUMBER;
          hash = (53 * hash) + getHttpHeaderMatch().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specification of traffic destination attributes.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.DestinationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .class,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          hosts_ = com.google.protobuf.LazyStringArrayList.emptyList();
          ports_ = emptyIntList();
          methods_ = com.google.protobuf.LazyStringArrayList.emptyList();
          httpHeaderMatch_ = null;
          if (httpHeaderMatchBuilder_ != null) {
            httpHeaderMatchBuilder_.dispose();
            httpHeaderMatchBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
              .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_Destination_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
            getDefaultInstanceForType() {
          return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
            build() {
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
            buildPartial() {
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination result =
              new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination result) {
          if (((bitField0_ & 0x00000002) != 0)) {
            ports_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.ports_ = ports_;
        }

        private void buildPartial0(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            hosts_.makeImmutable();
            result.hosts_ = hosts_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            methods_.makeImmutable();
            result.methods_ = methods_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.httpHeaderMatch_ =
                httpHeaderMatchBuilder_ == null
                    ? httpHeaderMatch_
                    : httpHeaderMatchBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination) {
            return mergeFrom(
                (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination other) {
          if (other
              == com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                  .getDefaultInstance()) return this;
          if (!other.hosts_.isEmpty()) {
            if (hosts_.isEmpty()) {
              hosts_ = other.hosts_;
              bitField0_ |= 0x00000001;
            } else {
              ensureHostsIsMutable();
              hosts_.addAll(other.hosts_);
            }
            onChanged();
          }
          if (!other.ports_.isEmpty()) {
            if (ports_.isEmpty()) {
              ports_ = other.ports_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensurePortsIsMutable();
              ports_.addAll(other.ports_);
            }
            onChanged();
          }
          if (!other.methods_.isEmpty()) {
            if (methods_.isEmpty()) {
              methods_ = other.methods_;
              bitField0_ |= 0x00000004;
            } else {
              ensureMethodsIsMutable();
              methods_.addAll(other.methods_);
            }
            onChanged();
          }
          if (other.hasHttpHeaderMatch()) {
            mergeHttpHeaderMatch(other.getHttpHeaderMatch());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureHostsIsMutable();
                    hosts_.add(s);
                    break;
                  } // case 10
                case 16:
                  {
                    int v = input.readUInt32();
                    ensurePortsIsMutable();
                    ports_.addInt(v);
                    break;
                  } // case 16
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    ensurePortsIsMutable();
                    while (input.getBytesUntilLimit() > 0) {
                      ports_.addInt(input.readUInt32());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 18
                case 34:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureMethodsIsMutable();
                    methods_.add(s);
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(
                        getHttpHeaderMatchFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList hosts_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureHostsIsMutable() {
          if (!hosts_.isModifiable()) {
            hosts_ = new com.google.protobuf.LazyStringArrayList(hosts_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the hosts.
         */
        public com.google.protobuf.ProtocolStringList getHostsList() {
          hosts_.makeImmutable();
          return hosts_;
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of hosts.
         */
        public int getHostsCount() {
          return hosts_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The hosts at the given index.
         */
        public java.lang.String getHosts(int index) {
          return hosts_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the hosts at the given index.
         */
        public com.google.protobuf.ByteString getHostsBytes(int index) {
          return hosts_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The hosts to set.
         * @return This builder for chaining.
         */
        public Builder setHosts(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHostsIsMutable();
          hosts_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The hosts to add.
         * @return This builder for chaining.
         */
        public Builder addHosts(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHostsIsMutable();
          hosts_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The hosts to add.
         * @return This builder for chaining.
         */
        public Builder addAllHosts(java.lang.Iterable<java.lang.String> values) {
          ensureHostsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, hosts_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearHosts() {
          hosts_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of host names to match. Matched against the ":authority"
         * header in http requests. At least one host should match. Each host can
         * be an exact match, or a prefix match (example "mydomain.*") or a suffix
         * match (example "*.myorg.com") or a presence (any) match "*".
         * </pre>
         *
         * <code>repeated string hosts = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes of the hosts to add.
         * @return This builder for chaining.
         */
        public Builder addHostsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureHostsIsMutable();
          hosts_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.IntList ports_ = emptyIntList();

        private void ensurePortsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            ports_ = mutableCopy(ports_);
            bitField0_ |= 0x00000002;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the ports.
         */
        public java.util.List<java.lang.Integer> getPortsList() {
          return ((bitField0_ & 0x00000002) != 0)
              ? java.util.Collections.unmodifiableList(ports_)
              : ports_;
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of ports.
         */
        public int getPortsCount() {
          return ports_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The ports at the given index.
         */
        public int getPorts(int index) {
          return ports_.getInt(index);
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The ports to set.
         * @return This builder for chaining.
         */
        public Builder setPorts(int index, int value) {

          ensurePortsIsMutable();
          ports_.setInt(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The ports to add.
         * @return This builder for chaining.
         */
        public Builder addPorts(int value) {

          ensurePortsIsMutable();
          ports_.addInt(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The ports to add.
         * @return This builder for chaining.
         */
        public Builder addAllPorts(java.lang.Iterable<? extends java.lang.Integer> values) {
          ensurePortsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. List of destination ports to match. At least one port should
         * match.
         * </pre>
         *
         * <code>repeated uint32 ports = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPorts() {
          ports_ = emptyIntList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList methods_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureMethodsIsMutable() {
          if (!methods_.isModifiable()) {
            methods_ = new com.google.protobuf.LazyStringArrayList(methods_);
          }
          bitField0_ |= 0x00000004;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the methods.
         */
        public com.google.protobuf.ProtocolStringList getMethodsList() {
          methods_.makeImmutable();
          return methods_;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of methods.
         */
        public int getMethodsCount() {
          return methods_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The methods at the given index.
         */
        public java.lang.String getMethods(int index) {
          return methods_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the methods at the given index.
         */
        public com.google.protobuf.ByteString getMethodsBytes(int index) {
          return methods_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The methods to set.
         * @return This builder for chaining.
         */
        public Builder setMethods(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMethodsIsMutable();
          methods_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The methods to add.
         * @return This builder for chaining.
         */
        public Builder addMethods(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMethodsIsMutable();
          methods_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The methods to add.
         * @return This builder for chaining.
         */
        public Builder addAllMethods(java.lang.Iterable<java.lang.String> values) {
          ensureMethodsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, methods_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMethods() {
          methods_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A list of HTTP methods to match. At least one method should
         * match. Should not be set for gRPC services.
         * </pre>
         *
         * <code>repeated string methods = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the methods to add.
         * @return This builder for chaining.
         */
        public Builder addMethodsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureMethodsIsMutable();
          methods_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            httpHeaderMatch_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch.Builder,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatchOrBuilder>
            httpHeaderMatchBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the httpHeaderMatch field is set.
         */
        public boolean hasHttpHeaderMatch() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The httpHeaderMatch.
         */
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch
            getHttpHeaderMatch() {
          if (httpHeaderMatchBuilder_ == null) {
            return httpHeaderMatch_ == null
                ? com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch.getDefaultInstance()
                : httpHeaderMatch_;
          } else {
            return httpHeaderMatchBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setHttpHeaderMatch(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch
                value) {
          if (httpHeaderMatchBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            httpHeaderMatch_ = value;
          } else {
            httpHeaderMatchBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setHttpHeaderMatch(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch.Builder
                builderForValue) {
          if (httpHeaderMatchBuilder_ == null) {
            httpHeaderMatch_ = builderForValue.build();
          } else {
            httpHeaderMatchBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeHttpHeaderMatch(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch
                value) {
          if (httpHeaderMatchBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && httpHeaderMatch_ != null
                && httpHeaderMatch_
                    != com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                        .HttpHeaderMatch.getDefaultInstance()) {
              getHttpHeaderMatchBuilder().mergeFrom(value);
            } else {
              httpHeaderMatch_ = value;
            }
          } else {
            httpHeaderMatchBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearHttpHeaderMatch() {
          bitField0_ = (bitField0_ & ~0x00000008);
          httpHeaderMatch_ = null;
          if (httpHeaderMatchBuilder_ != null) {
            httpHeaderMatchBuilder_.dispose();
            httpHeaderMatchBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatch.Builder
            getHttpHeaderMatchBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getHttpHeaderMatchFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                .HttpHeaderMatchOrBuilder
            getHttpHeaderMatchOrBuilder() {
          if (httpHeaderMatchBuilder_ != null) {
            return httpHeaderMatchBuilder_.getMessageOrBuilder();
          } else {
            return httpHeaderMatch_ == null
                ? com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch.getDefaultInstance()
                : httpHeaderMatch_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Match against key:value pair in http header. Provides a
         * flexible match based on HTTP headers, for potentially advanced use
         * cases. At least one header should match. Avoid using header matches to
         * make authorization decisions unless there is a strong guarantee that
         * requests arrive through a trusted client or proxy.
         * </pre>
         *
         * <code>
         * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch http_header_match = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatch.Builder,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .HttpHeaderMatchOrBuilder>
            getHttpHeaderMatchFieldBuilder() {
          if (httpHeaderMatchBuilder_ == null) {
            httpHeaderMatchBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                        .HttpHeaderMatch,
                    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                        .HttpHeaderMatch.Builder,
                    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                        .HttpHeaderMatchOrBuilder>(
                    getHttpHeaderMatch(), getParentForChildren(), isClean());
            httpHeaderMatch_ = null;
          }
          return httpHeaderMatchBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination)
      private static final com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
              .Destination
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination();
      }

      public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Destination> PARSER =
          new com.google.protobuf.AbstractParser<Destination>() {
            @java.lang.Override
            public Destination parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Destination> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Destination> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int SOURCES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>
        sources_;
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>
        getSourcesList() {
      return sources_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder>
        getSourcesOrBuilderList() {
      return sources_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getSourcesCount() {
      return sources_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source getSources(
        int index) {
      return sources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic source. All of the sources
     * must match. A source is a match if both principals and ip_blocks match.
     * If not set, the action specified in the 'action' field will be applied
     * without any rule checks for the source.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder
        getSourcesOrBuilder(int index) {
      return sources_.get(index);
    }

    public static final int DESTINATIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>
        destinations_;
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>
        getDestinationsList() {
      return destinations_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                    .DestinationOrBuilder>
        getDestinationsOrBuilderList() {
      return destinations_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getDestinationsCount() {
      return destinations_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
        getDestinations(int index) {
      return destinations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of attributes for the traffic destination. All of the
     * destinations must match. A destination is a match if a request matches
     * all the specified hosts, ports, methods and headers. If not set, the
     * action specified in the 'action' field will be applied without any rule
     * checks for the destination.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.DestinationOrBuilder
        getDestinationsOrBuilder(int index) {
      return destinations_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < sources_.size(); i++) {
        output.writeMessage(1, sources_.get(i));
      }
      for (int i = 0; i < destinations_.size(); i++) {
        output.writeMessage(2, destinations_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < sources_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, sources_.get(i));
      }
      for (int i = 0; i < destinations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, destinations_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule)) {
        return super.equals(obj);
      }
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule other =
          (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule) obj;

      if (!getSourcesList().equals(other.getSourcesList())) return false;
      if (!getDestinationsList().equals(other.getDestinationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSourcesCount() > 0) {
        hash = (37 * hash) + SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSourcesList().hashCode();
      }
      if (getDestinationsCount() > 0) {
        hash = (37 * hash) + DESTINATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specification of rules.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule)
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.class,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder.class);
      }

      // Construct using
      // com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (sourcesBuilder_ == null) {
          sources_ = java.util.Collections.emptyList();
        } else {
          sources_ = null;
          sourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (destinationsBuilder_ == null) {
          destinations_ = java.util.Collections.emptyList();
        } else {
          destinations_ = null;
          destinationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_Rule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
          getDefaultInstanceForType() {
        return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule build() {
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule buildPartial() {
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule result =
            new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule result) {
        if (sourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            sources_ = java.util.Collections.unmodifiableList(sources_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.sources_ = sources_;
        } else {
          result.sources_ = sourcesBuilder_.build();
        }
        if (destinationsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            destinations_ = java.util.Collections.unmodifiableList(destinations_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.destinations_ = destinations_;
        } else {
          result.destinations_ = destinationsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule) {
          return mergeFrom(
              (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule other) {
        if (other
            == com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                .getDefaultInstance()) return this;
        if (sourcesBuilder_ == null) {
          if (!other.sources_.isEmpty()) {
            if (sources_.isEmpty()) {
              sources_ = other.sources_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSourcesIsMutable();
              sources_.addAll(other.sources_);
            }
            onChanged();
          }
        } else {
          if (!other.sources_.isEmpty()) {
            if (sourcesBuilder_.isEmpty()) {
              sourcesBuilder_.dispose();
              sourcesBuilder_ = null;
              sources_ = other.sources_;
              bitField0_ = (bitField0_ & ~0x00000001);
              sourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSourcesFieldBuilder()
                      : null;
            } else {
              sourcesBuilder_.addAllMessages(other.sources_);
            }
          }
        }
        if (destinationsBuilder_ == null) {
          if (!other.destinations_.isEmpty()) {
            if (destinations_.isEmpty()) {
              destinations_ = other.destinations_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureDestinationsIsMutable();
              destinations_.addAll(other.destinations_);
            }
            onChanged();
          }
        } else {
          if (!other.destinations_.isEmpty()) {
            if (destinationsBuilder_.isEmpty()) {
              destinationsBuilder_.dispose();
              destinationsBuilder_ = null;
              destinations_ = other.destinations_;
              bitField0_ = (bitField0_ & ~0x00000002);
              destinationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDestinationsFieldBuilder()
                      : null;
            } else {
              destinationsBuilder_.addAllMessages(other.destinations_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source m =
                      input.readMessage(
                          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
                              .parser(),
                          extensionRegistry);
                  if (sourcesBuilder_ == null) {
                    ensureSourcesIsMutable();
                    sources_.add(m);
                  } else {
                    sourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination m =
                      input.readMessage(
                          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                              .Destination.parser(),
                          extensionRegistry);
                  if (destinationsBuilder_ == null) {
                    ensureDestinationsIsMutable();
                    destinations_.add(m);
                  } else {
                    destinationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>
          sources_ = java.util.Collections.emptyList();

      private void ensureSourcesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          sources_ =
              new java.util.ArrayList<
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>(
                  sources_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder>
          sourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>
          getSourcesList() {
        if (sourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(sources_);
        } else {
          return sourcesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getSourcesCount() {
        if (sourcesBuilder_ == null) {
          return sources_.size();
        } else {
          return sourcesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source getSources(
          int index) {
        if (sourcesBuilder_ == null) {
          return sources_.get(index);
        } else {
          return sourcesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSources(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.set(index, value);
          onChanged();
        } else {
          sourcesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSources(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
              builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.set(index, builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.add(value);
          onChanged();
        } else {
          sourcesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.add(index, value);
          onChanged();
        } else {
          sourcesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
              builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.add(builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
              builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.add(index, builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllSources(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source>
              values) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
          onChanged();
        } else {
          sourcesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSources() {
        if (sourcesBuilder_ == null) {
          sources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          sourcesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSources(int index) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.remove(index);
          onChanged();
        } else {
          sourcesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
          getSourcesBuilder(int index) {
        return getSourcesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder
          getSourcesOrBuilder(int index) {
        if (sourcesBuilder_ == null) {
          return sources_.get(index);
        } else {
          return sourcesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder>
          getSourcesOrBuilderList() {
        if (sourcesBuilder_ != null) {
          return sourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(sources_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
          addSourcesBuilder() {
        return getSourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder
          addSourcesBuilder(int index) {
        return getSourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic source. All of the sources
       * must match. A source is a match if both principals and ip_blocks match.
       * If not set, the action specified in the 'action' field will be applied
       * without any rule checks for the source.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source sources = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder>
          getSourcesBuilderList() {
        return getSourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.SourceOrBuilder>
          getSourcesFieldBuilder() {
        if (sourcesBuilder_ == null) {
          sourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source.Builder,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                      .SourceOrBuilder>(
                  sources_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          sources_ = null;
        }
        return sourcesBuilder_;
      }

      private java.util.List<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>
          destinations_ = java.util.Collections.emptyList();

      private void ensureDestinationsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          destinations_ =
              new java.util.ArrayList<
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>(
                  destinations_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                  .DestinationOrBuilder>
          destinationsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>
          getDestinationsList() {
        if (destinationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(destinations_);
        } else {
          return destinationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getDestinationsCount() {
        if (destinationsBuilder_ == null) {
          return destinations_.size();
        } else {
          return destinationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
          getDestinations(int index) {
        if (destinationsBuilder_ == null) {
          return destinations_.get(index);
        } else {
          return destinationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDestinations(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination value) {
        if (destinationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDestinationsIsMutable();
          destinations_.set(index, value);
          onChanged();
        } else {
          destinationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDestinations(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder
              builderForValue) {
        if (destinationsBuilder_ == null) {
          ensureDestinationsIsMutable();
          destinations_.set(index, builderForValue.build());
          onChanged();
        } else {
          destinationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDestinations(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination value) {
        if (destinationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDestinationsIsMutable();
          destinations_.add(value);
          onChanged();
        } else {
          destinationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDestinations(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination value) {
        if (destinationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDestinationsIsMutable();
          destinations_.add(index, value);
          onChanged();
        } else {
          destinationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDestinations(
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder
              builderForValue) {
        if (destinationsBuilder_ == null) {
          ensureDestinationsIsMutable();
          destinations_.add(builderForValue.build());
          onChanged();
        } else {
          destinationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addDestinations(
          int index,
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder
              builderForValue) {
        if (destinationsBuilder_ == null) {
          ensureDestinationsIsMutable();
          destinations_.add(index, builderForValue.build());
          onChanged();
        } else {
          destinationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllDestinations(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination>
              values) {
        if (destinationsBuilder_ == null) {
          ensureDestinationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destinations_);
          onChanged();
        } else {
          destinationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDestinations() {
        if (destinationsBuilder_ == null) {
          destinations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          destinationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeDestinations(int index) {
        if (destinationsBuilder_ == null) {
          ensureDestinationsIsMutable();
          destinations_.remove(index);
          onChanged();
        } else {
          destinationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder
          getDestinationsBuilder(int index) {
        return getDestinationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.DestinationOrBuilder
          getDestinationsOrBuilder(int index) {
        if (destinationsBuilder_ == null) {
          return destinations_.get(index);
        } else {
          return destinationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                      .DestinationOrBuilder>
          getDestinationsOrBuilderList() {
        if (destinationsBuilder_ != null) {
          return destinationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(destinations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder
          addDestinationsBuilder() {
        return getDestinationsFieldBuilder()
            .addBuilder(
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder
          addDestinationsBuilder(int index) {
        return getDestinationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. List of attributes for the traffic destination. All of the
       * destinations must match. A destination is a match if a request matches
       * all the specified hosts, ports, methods and headers. If not set, the
       * action specified in the 'action' field will be applied without any rule
       * checks for the destination.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination destinations = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder>
          getDestinationsBuilderList() {
        return getDestinationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.Builder,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                  .DestinationOrBuilder>
          getDestinationsFieldBuilder() {
        if (destinationsBuilder_ == null) {
          destinationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
                      .Builder,
                  com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                      .DestinationOrBuilder>(
                  destinations_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          destinations_ = null;
        }
        return destinationsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule)
    private static final com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule();
    }

    public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Rule> PARSER =
        new com.google.protobuf.AbstractParser<Rule>() {
          @java.lang.Override
          public Rule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Rule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Rule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the AuthorizationPolicy resource. It matches pattern
   * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the AuthorizationPolicy resource. It matches pattern
   * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Free-text description of the resource.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Free-text description of the resource.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
                .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the AuthorizationPolicy
   * resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the AuthorizationPolicy
   * resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the AuthorizationPolicy
   * resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the AuthorizationPolicy
   * resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ACTION_FIELD_NUMBER = 6;
  private int action_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The action to take when a rule match is found. Possible values
   * are "ALLOW" or "DENY".
   * </pre>
   *
   * <code>
   * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for action.
   */
  @java.lang.Override
  public int getActionValue() {
    return action_;
  }
  /**
   *
   *
   * <pre>
   * Required. The action to take when a rule match is found. Possible values
   * are "ALLOW" or "DENY".
   * </pre>
   *
   * <code>
   * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action getAction() {
    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action result =
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action.forNumber(action_);
    return result == null
        ? com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action.UNRECOGNIZED
        : result;
  }

  public static final int RULES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule> rules_;
  /**
   *
   *
   * <pre>
   * Optional. List of rules to match. Note that at least one of the rules must
   * match in order for the action specified in the 'action' field to be taken.
   * A rule is a match if there is a matching source and destination. If left
   * blank, the action specified in the `action` field will be applied on every
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule>
      getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of rules to match. Note that at least one of the rules must
   * match in order for the action specified in the 'action' field to be taken.
   * A rule is a match if there is a matching source and destination. If left
   * blank, the action specified in the `action` field will be applied on every
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of rules to match. Note that at least one of the rules must
   * match in order for the action specified in the 'action' field to be taken.
   * A rule is a match if there is a matching source and destination. If left
   * blank, the action specified in the `action` field will be applied on every
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of rules to match. Note that at least one of the rules must
   * match in order for the action specified in the 'action' field to be taken.
   * A rule is a match if there is a matching source and destination. If left
   * blank, the action specified in the `action` field will be applied on every
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of rules to match. Note that at least one of the rules must
   * match in order for the action specified in the 'action' field to be taken.
   * A rule is a match if there is a matching source and destination. If left
   * blank, the action specified in the `action` field will be applied on every
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder
      getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (action_
        != com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action.ACTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, action_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(7, rules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (action_
        != com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action.ACTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, action_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, rules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy other =
        (com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (action_ != other.action_) return false;
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AuthorizationPolicy is a resource that specifies how a server
   * should authorize incoming connections. This resource in itself does
   * not change the configuration unless it's attached to a target https
   * proxy or endpoint config selector resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networksecurity.v1beta1.AuthorizationPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.AuthorizationPolicy)
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.class,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Builder.class);
    }

    // Construct using com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      action_ = 0;
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_AuthorizationPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy
        getDefaultInstanceForType() {
      return com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy build() {
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy buildPartial() {
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy result =
          new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy result) {
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.action_ = action_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy) {
        return mergeFrom((com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy other) {
      if (other
          == com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000040);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                action_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule m =
                    input.readMessage(
                        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.parser(),
                        extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the AuthorizationPolicy resource. It matches pattern
     * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the AuthorizationPolicy resource. It matches pattern
     * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the AuthorizationPolicy resource. It matches pattern
     * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the AuthorizationPolicy resource. It matches pattern
     * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the AuthorizationPolicy resource. It matches pattern
     * `projects/{project}/locations/{location}/authorizationPolicies/&lt;authorization_policy&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the AuthorizationPolicy
     * resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private int action_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The action to take when a rule match is found. Possible values
     * are "ALLOW" or "DENY".
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override
    public int getActionValue() {
      return action_;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to take when a rule match is found. Possible values
     * are "ALLOW" or "DENY".
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionValue(int value) {
      action_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to take when a rule match is found. Possible values
     * are "ALLOW" or "DENY".
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action getAction() {
      com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action result =
          com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action.forNumber(action_);
      return result == null
          ? com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to take when a rule match is found. Possible values
     * are "ALLOW" or "DENY".
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      action_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to take when a rule match is found. Possible values
     * are "ALLOW" or "DENY".
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action action = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      bitField0_ = (bitField0_ & ~0x00000020);
      action_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule>
        rules_ = java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        rules_ =
            new java.util.ArrayList<
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule>(rules_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule,
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder,
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule>
        getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRules(
        int index, com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRules(
        int index,
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRules(
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRules(
        int index, com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRules(
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRules(
        int index,
        com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllRules(
        java.lang.Iterable<
                ? extends com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule>
            values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder
        getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder
        getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder
        addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder
        addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of rules to match. Note that at least one of the rules must
     * match in order for the action specified in the 'action' field to be taken.
     * A rule is a match if there is a matching source and destination. If left
     * blank, the action specified in the `action` field will be applied on every
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule rules = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder>
        getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule,
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder,
            com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Builder,
                com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy.RuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.AuthorizationPolicy)
  private static final com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy();
  }

  public static com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuthorizationPolicy> PARSER =
      new com.google.protobuf.AbstractParser<AuthorizationPolicy>() {
        @java.lang.Override
        public AuthorizationPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuthorizationPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuthorizationPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.AuthorizationPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
