/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networksecurity/v1beta1/server_tls_policy.proto

package com.google.cloud.networksecurity.v1beta1;

/**
 *
 *
 * <pre>
 * ServerTlsPolicy is a resource that specifies how a server should authenticate
 * incoming requests. This resource itself does not affect configuration unless
 * it is attached to a target https proxy or endpoint config selector resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networksecurity.v1beta1.ServerTlsPolicy}
 */
public final class ServerTlsPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.ServerTlsPolicy)
    ServerTlsPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServerTlsPolicy.newBuilder() to construct.
  private ServerTlsPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServerTlsPolicy() {
    name_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServerTlsPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
        .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
        .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.class,
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.Builder.class);
  }

  public interface MTLSPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
        getClientValidationCaList();
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    com.google.cloud.networksecurity.v1beta1.ValidationCA getClientValidationCa(int index);
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    int getClientValidationCaCount();
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    java.util.List<? extends com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
        getClientValidationCaOrBuilderList();
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder getClientValidationCaOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * Specification of the MTLSPolicy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy}
   */
  public static final class MTLSPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy)
      MTLSPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MTLSPolicy.newBuilder() to construct.
    private MTLSPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MTLSPolicy() {
      clientValidationCa_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MTLSPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_MTLSPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_MTLSPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.class,
              com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder.class);
    }

    public static final int CLIENT_VALIDATION_CA_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
        clientValidationCa_;
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
        getClientValidationCaList() {
      return clientValidationCa_;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
        getClientValidationCaOrBuilderList() {
      return clientValidationCa_;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    @java.lang.Override
    public int getClientValidationCaCount() {
      return clientValidationCa_.size();
    }
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ValidationCA getClientValidationCa(int index) {
      return clientValidationCa_.get(index);
    }
    /**
     *
     *
     * <pre>
     *
     * Defines the mechanism to obtain the Certificate Authority certificate to
     * validate the client certificate.
     * </pre>
     *
     * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder
        getClientValidationCaOrBuilder(int index) {
      return clientValidationCa_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < clientValidationCa_.size(); i++) {
        output.writeMessage(1, clientValidationCa_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < clientValidationCa_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, clientValidationCa_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy other =
          (com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy) obj;

      if (!getClientValidationCaList().equals(other.getClientValidationCaList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getClientValidationCaCount() > 0) {
        hash = (37 * hash) + CLIENT_VALIDATION_CA_FIELD_NUMBER;
        hash = (53 * hash) + getClientValidationCaList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specification of the MTLSPolicy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy)
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_MTLSPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_MTLSPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.class,
                com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder.class);
      }

      // Construct using
      // com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (clientValidationCaBuilder_ == null) {
          clientValidationCa_ = java.util.Collections.emptyList();
        } else {
          clientValidationCa_ = null;
          clientValidationCaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
            .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_MTLSPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
          getDefaultInstanceForType() {
        return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy build() {
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy buildPartial() {
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy result =
            new com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy result) {
        if (clientValidationCaBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            clientValidationCa_ = java.util.Collections.unmodifiableList(clientValidationCa_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.clientValidationCa_ = clientValidationCa_;
        } else {
          result.clientValidationCa_ = clientValidationCaBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy) {
          return mergeFrom(
              (com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy other) {
        if (other
            == com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
                .getDefaultInstance()) return this;
        if (clientValidationCaBuilder_ == null) {
          if (!other.clientValidationCa_.isEmpty()) {
            if (clientValidationCa_.isEmpty()) {
              clientValidationCa_ = other.clientValidationCa_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureClientValidationCaIsMutable();
              clientValidationCa_.addAll(other.clientValidationCa_);
            }
            onChanged();
          }
        } else {
          if (!other.clientValidationCa_.isEmpty()) {
            if (clientValidationCaBuilder_.isEmpty()) {
              clientValidationCaBuilder_.dispose();
              clientValidationCaBuilder_ = null;
              clientValidationCa_ = other.clientValidationCa_;
              bitField0_ = (bitField0_ & ~0x00000001);
              clientValidationCaBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getClientValidationCaFieldBuilder()
                      : null;
            } else {
              clientValidationCaBuilder_.addAllMessages(other.clientValidationCa_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.networksecurity.v1beta1.ValidationCA m =
                      input.readMessage(
                          com.google.cloud.networksecurity.v1beta1.ValidationCA.parser(),
                          extensionRegistry);
                  if (clientValidationCaBuilder_ == null) {
                    ensureClientValidationCaIsMutable();
                    clientValidationCa_.add(m);
                  } else {
                    clientValidationCaBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
          clientValidationCa_ = java.util.Collections.emptyList();

      private void ensureClientValidationCaIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          clientValidationCa_ =
              new java.util.ArrayList<com.google.cloud.networksecurity.v1beta1.ValidationCA>(
                  clientValidationCa_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.networksecurity.v1beta1.ValidationCA,
              com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder,
              com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
          clientValidationCaBuilder_;

      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
          getClientValidationCaList() {
        if (clientValidationCaBuilder_ == null) {
          return java.util.Collections.unmodifiableList(clientValidationCa_);
        } else {
          return clientValidationCaBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public int getClientValidationCaCount() {
        if (clientValidationCaBuilder_ == null) {
          return clientValidationCa_.size();
        } else {
          return clientValidationCaBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.ValidationCA getClientValidationCa(
          int index) {
        if (clientValidationCaBuilder_ == null) {
          return clientValidationCa_.get(index);
        } else {
          return clientValidationCaBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder setClientValidationCa(
          int index, com.google.cloud.networksecurity.v1beta1.ValidationCA value) {
        if (clientValidationCaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureClientValidationCaIsMutable();
          clientValidationCa_.set(index, value);
          onChanged();
        } else {
          clientValidationCaBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder setClientValidationCa(
          int index,
          com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder builderForValue) {
        if (clientValidationCaBuilder_ == null) {
          ensureClientValidationCaIsMutable();
          clientValidationCa_.set(index, builderForValue.build());
          onChanged();
        } else {
          clientValidationCaBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder addClientValidationCa(
          com.google.cloud.networksecurity.v1beta1.ValidationCA value) {
        if (clientValidationCaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureClientValidationCaIsMutable();
          clientValidationCa_.add(value);
          onChanged();
        } else {
          clientValidationCaBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder addClientValidationCa(
          int index, com.google.cloud.networksecurity.v1beta1.ValidationCA value) {
        if (clientValidationCaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureClientValidationCaIsMutable();
          clientValidationCa_.add(index, value);
          onChanged();
        } else {
          clientValidationCaBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder addClientValidationCa(
          com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder builderForValue) {
        if (clientValidationCaBuilder_ == null) {
          ensureClientValidationCaIsMutable();
          clientValidationCa_.add(builderForValue.build());
          onChanged();
        } else {
          clientValidationCaBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder addClientValidationCa(
          int index,
          com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder builderForValue) {
        if (clientValidationCaBuilder_ == null) {
          ensureClientValidationCaIsMutable();
          clientValidationCa_.add(index, builderForValue.build());
          onChanged();
        } else {
          clientValidationCaBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder addAllClientValidationCa(
          java.lang.Iterable<? extends com.google.cloud.networksecurity.v1beta1.ValidationCA>
              values) {
        if (clientValidationCaBuilder_ == null) {
          ensureClientValidationCaIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clientValidationCa_);
          onChanged();
        } else {
          clientValidationCaBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder clearClientValidationCa() {
        if (clientValidationCaBuilder_ == null) {
          clientValidationCa_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          clientValidationCaBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public Builder removeClientValidationCa(int index) {
        if (clientValidationCaBuilder_ == null) {
          ensureClientValidationCaIsMutable();
          clientValidationCa_.remove(index);
          onChanged();
        } else {
          clientValidationCaBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder
          getClientValidationCaBuilder(int index) {
        return getClientValidationCaFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder
          getClientValidationCaOrBuilder(int index) {
        if (clientValidationCaBuilder_ == null) {
          return clientValidationCa_.get(index);
        } else {
          return clientValidationCaBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
          getClientValidationCaOrBuilderList() {
        if (clientValidationCaBuilder_ != null) {
          return clientValidationCaBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(clientValidationCa_);
        }
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder
          addClientValidationCaBuilder() {
        return getClientValidationCaFieldBuilder()
            .addBuilder(com.google.cloud.networksecurity.v1beta1.ValidationCA.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder
          addClientValidationCaBuilder(int index) {
        return getClientValidationCaFieldBuilder()
            .addBuilder(
                index, com.google.cloud.networksecurity.v1beta1.ValidationCA.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       *
       * Defines the mechanism to obtain the Certificate Authority certificate to
       * validate the client certificate.
       * </pre>
       *
       * <code>repeated .google.cloud.networksecurity.v1beta1.ValidationCA client_validation_ca = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder>
          getClientValidationCaBuilderList() {
        return getClientValidationCaFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.networksecurity.v1beta1.ValidationCA,
              com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder,
              com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
          getClientValidationCaFieldBuilder() {
        if (clientValidationCaBuilder_ == null) {
          clientValidationCaBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.networksecurity.v1beta1.ValidationCA,
                  com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder,
                  com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>(
                  clientValidationCa_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          clientValidationCa_ = null;
        }
        return clientValidationCaBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy)
    private static final com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy();
    }

    public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MTLSPolicy> PARSER =
        new com.google.protobuf.AbstractParser<MTLSPolicy>() {
          @java.lang.Override
          public MTLSPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MTLSPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MTLSPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the ServerTlsPolicy resource. It matches the pattern
   * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the ServerTlsPolicy resource. It matches the pattern
   * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Free-text description of the resource.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Free-text description of the resource.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
                .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ALLOW_OPEN_FIELD_NUMBER = 6;
  private boolean allowOpen_ = false;
  /**
   *
   *
   * <pre>
   *
   * Determines if server allows plaintext connections. If set to true, server
   * allows plain text connections. By default, it is set to false. This setting
   * is not exclusive of other encryption modes. For example, if `allow_open`
   * and `mtls_policy` are set, server allows both plain text and mTLS
   * connections. See documentation of other encryption modes to confirm
   * compatibility.
   *
   * Consider using it if you wish to upgrade in place your deployment to TLS
   * while having mixed TLS and non-TLS traffic reaching port :80.
   * </pre>
   *
   * <code>bool allow_open = 6;</code>
   *
   * @return The allowOpen.
   */
  @java.lang.Override
  public boolean getAllowOpen() {
    return allowOpen_;
  }

  public static final int SERVER_CERTIFICATE_FIELD_NUMBER = 7;
  private com.google.cloud.networksecurity.v1beta1.CertificateProvider serverCertificate_;
  /**
   *
   *
   * <pre>
   *
   * Defines a mechanism to provision server identity (public and private keys).
   * Cannot be combined with `allow_open` as a permissive mode that allows both
   * plain text and TLS is not supported.
   * </pre>
   *
   * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;</code>
   *
   * @return Whether the serverCertificate field is set.
   */
  @java.lang.Override
  public boolean hasServerCertificate() {
    return serverCertificate_ != null;
  }
  /**
   *
   *
   * <pre>
   *
   * Defines a mechanism to provision server identity (public and private keys).
   * Cannot be combined with `allow_open` as a permissive mode that allows both
   * plain text and TLS is not supported.
   * </pre>
   *
   * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;</code>
   *
   * @return The serverCertificate.
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.CertificateProvider getServerCertificate() {
    return serverCertificate_ == null
        ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
        : serverCertificate_;
  }
  /**
   *
   *
   * <pre>
   *
   * Defines a mechanism to provision server identity (public and private keys).
   * Cannot be combined with `allow_open` as a permissive mode that allows both
   * plain text and TLS is not supported.
   * </pre>
   *
   * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder
      getServerCertificateOrBuilder() {
    return serverCertificate_ == null
        ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
        : serverCertificate_;
  }

  public static final int MTLS_POLICY_FIELD_NUMBER = 8;
  private com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtlsPolicy_;
  /**
   *
   *
   * <pre>
   *
   * Defines a mechanism to provision peer validation certificates for peer to
   * peer authentication (Mutual TLS - mTLS). If not specified, client
   * certificate will not be requested. The connection is treated as TLS and not
   * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
   * text and mTLS connections.
   * </pre>
   *
   * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;</code>
   *
   * @return Whether the mtlsPolicy field is set.
   */
  @java.lang.Override
  public boolean hasMtlsPolicy() {
    return mtlsPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   *
   * Defines a mechanism to provision peer validation certificates for peer to
   * peer authentication (Mutual TLS - mTLS). If not specified, client
   * certificate will not be requested. The connection is treated as TLS and not
   * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
   * text and mTLS connections.
   * </pre>
   *
   * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;</code>
   *
   * @return The mtlsPolicy.
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy getMtlsPolicy() {
    return mtlsPolicy_ == null
        ? com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.getDefaultInstance()
        : mtlsPolicy_;
  }
  /**
   *
   *
   * <pre>
   *
   * Defines a mechanism to provision peer validation certificates for peer to
   * peer authentication (Mutual TLS - mTLS). If not specified, client
   * certificate will not be requested. The connection is treated as TLS and not
   * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
   * text and mTLS connections.
   * </pre>
   *
   * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicyOrBuilder
      getMtlsPolicyOrBuilder() {
    return mtlsPolicy_ == null
        ? com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.getDefaultInstance()
        : mtlsPolicy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (allowOpen_ != false) {
      output.writeBool(6, allowOpen_);
    }
    if (serverCertificate_ != null) {
      output.writeMessage(7, getServerCertificate());
    }
    if (mtlsPolicy_ != null) {
      output.writeMessage(8, getMtlsPolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (allowOpen_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, allowOpen_);
    }
    if (serverCertificate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getServerCertificate());
    }
    if (mtlsPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getMtlsPolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy other =
        (com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getAllowOpen() != other.getAllowOpen()) return false;
    if (hasServerCertificate() != other.hasServerCertificate()) return false;
    if (hasServerCertificate()) {
      if (!getServerCertificate().equals(other.getServerCertificate())) return false;
    }
    if (hasMtlsPolicy() != other.hasMtlsPolicy()) return false;
    if (hasMtlsPolicy()) {
      if (!getMtlsPolicy().equals(other.getMtlsPolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ALLOW_OPEN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowOpen());
    if (hasServerCertificate()) {
      hash = (37 * hash) + SERVER_CERTIFICATE_FIELD_NUMBER;
      hash = (53 * hash) + getServerCertificate().hashCode();
    }
    if (hasMtlsPolicy()) {
      hash = (37 * hash) + MTLS_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMtlsPolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ServerTlsPolicy is a resource that specifies how a server should authenticate
   * incoming requests. This resource itself does not affect configuration unless
   * it is attached to a target https proxy or endpoint config selector resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networksecurity.v1beta1.ServerTlsPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.ServerTlsPolicy)
      com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.class,
              com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.Builder.class);
    }

    // Construct using com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      allowOpen_ = false;
      serverCertificate_ = null;
      if (serverCertificateBuilder_ != null) {
        serverCertificateBuilder_.dispose();
        serverCertificateBuilder_ = null;
      }
      mtlsPolicy_ = null;
      if (mtlsPolicyBuilder_ != null) {
        mtlsPolicyBuilder_.dispose();
        mtlsPolicyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ServerTlsPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy getDefaultInstanceForType() {
      return com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy build() {
      com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy buildPartial() {
      com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy result =
          new com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.allowOpen_ = allowOpen_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serverCertificate_ =
            serverCertificateBuilder_ == null
                ? serverCertificate_
                : serverCertificateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.mtlsPolicy_ = mtlsPolicyBuilder_ == null ? mtlsPolicy_ : mtlsPolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy) {
        return mergeFrom((com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy other) {
      if (other == com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.getAllowOpen() != false) {
        setAllowOpen(other.getAllowOpen());
      }
      if (other.hasServerCertificate()) {
        mergeServerCertificate(other.getServerCertificate());
      }
      if (other.hasMtlsPolicy()) {
        mergeMtlsPolicy(other.getMtlsPolicy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                allowOpen_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(
                    getServerCertificateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getMtlsPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the ServerTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ServerTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ServerTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ServerTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ServerTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/serverTlsPolicies/{server_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private boolean allowOpen_;
    /**
     *
     *
     * <pre>
     *
     * Determines if server allows plaintext connections. If set to true, server
     * allows plain text connections. By default, it is set to false. This setting
     * is not exclusive of other encryption modes. For example, if `allow_open`
     * and `mtls_policy` are set, server allows both plain text and mTLS
     * connections. See documentation of other encryption modes to confirm
     * compatibility.
     *
     * Consider using it if you wish to upgrade in place your deployment to TLS
     * while having mixed TLS and non-TLS traffic reaching port :80.
     * </pre>
     *
     * <code>bool allow_open = 6;</code>
     *
     * @return The allowOpen.
     */
    @java.lang.Override
    public boolean getAllowOpen() {
      return allowOpen_;
    }
    /**
     *
     *
     * <pre>
     *
     * Determines if server allows plaintext connections. If set to true, server
     * allows plain text connections. By default, it is set to false. This setting
     * is not exclusive of other encryption modes. For example, if `allow_open`
     * and `mtls_policy` are set, server allows both plain text and mTLS
     * connections. See documentation of other encryption modes to confirm
     * compatibility.
     *
     * Consider using it if you wish to upgrade in place your deployment to TLS
     * while having mixed TLS and non-TLS traffic reaching port :80.
     * </pre>
     *
     * <code>bool allow_open = 6;</code>
     *
     * @param value The allowOpen to set.
     * @return This builder for chaining.
     */
    public Builder setAllowOpen(boolean value) {

      allowOpen_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Determines if server allows plaintext connections. If set to true, server
     * allows plain text connections. By default, it is set to false. This setting
     * is not exclusive of other encryption modes. For example, if `allow_open`
     * and `mtls_policy` are set, server allows both plain text and mTLS
     * connections. See documentation of other encryption modes to confirm
     * compatibility.
     *
     * Consider using it if you wish to upgrade in place your deployment to TLS
     * while having mixed TLS and non-TLS traffic reaching port :80.
     * </pre>
     *
     * <code>bool allow_open = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowOpen() {
      bitField0_ = (bitField0_ & ~0x00000020);
      allowOpen_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.networksecurity.v1beta1.CertificateProvider serverCertificate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.CertificateProvider,
            com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder,
            com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder>
        serverCertificateBuilder_;
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     *
     * @return Whether the serverCertificate field is set.
     */
    public boolean hasServerCertificate() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     *
     * @return The serverCertificate.
     */
    public com.google.cloud.networksecurity.v1beta1.CertificateProvider getServerCertificate() {
      if (serverCertificateBuilder_ == null) {
        return serverCertificate_ == null
            ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
            : serverCertificate_;
      } else {
        return serverCertificateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    public Builder setServerCertificate(
        com.google.cloud.networksecurity.v1beta1.CertificateProvider value) {
      if (serverCertificateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serverCertificate_ = value;
      } else {
        serverCertificateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    public Builder setServerCertificate(
        com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder builderForValue) {
      if (serverCertificateBuilder_ == null) {
        serverCertificate_ = builderForValue.build();
      } else {
        serverCertificateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    public Builder mergeServerCertificate(
        com.google.cloud.networksecurity.v1beta1.CertificateProvider value) {
      if (serverCertificateBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && serverCertificate_ != null
            && serverCertificate_
                != com.google.cloud.networksecurity.v1beta1.CertificateProvider
                    .getDefaultInstance()) {
          getServerCertificateBuilder().mergeFrom(value);
        } else {
          serverCertificate_ = value;
        }
      } else {
        serverCertificateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    public Builder clearServerCertificate() {
      bitField0_ = (bitField0_ & ~0x00000040);
      serverCertificate_ = null;
      if (serverCertificateBuilder_ != null) {
        serverCertificateBuilder_.dispose();
        serverCertificateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder
        getServerCertificateBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getServerCertificateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder
        getServerCertificateOrBuilder() {
      if (serverCertificateBuilder_ != null) {
        return serverCertificateBuilder_.getMessageOrBuilder();
      } else {
        return serverCertificate_ == null
            ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
            : serverCertificate_;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision server identity (public and private keys).
     * Cannot be combined with `allow_open` as a permissive mode that allows both
     * plain text and TLS is not supported.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.CertificateProvider server_certificate = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.CertificateProvider,
            com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder,
            com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder>
        getServerCertificateFieldBuilder() {
      if (serverCertificateBuilder_ == null) {
        serverCertificateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.CertificateProvider,
                com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder,
                com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder>(
                getServerCertificate(), getParentForChildren(), isClean());
        serverCertificate_ = null;
      }
      return serverCertificateBuilder_;
    }

    private com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtlsPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy,
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder,
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicyOrBuilder>
        mtlsPolicyBuilder_;
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     *
     * @return Whether the mtlsPolicy field is set.
     */
    public boolean hasMtlsPolicy() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     *
     * @return The mtlsPolicy.
     */
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy getMtlsPolicy() {
      if (mtlsPolicyBuilder_ == null) {
        return mtlsPolicy_ == null
            ? com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
                .getDefaultInstance()
            : mtlsPolicy_;
      } else {
        return mtlsPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    public Builder setMtlsPolicy(
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy value) {
      if (mtlsPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mtlsPolicy_ = value;
      } else {
        mtlsPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    public Builder setMtlsPolicy(
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder
            builderForValue) {
      if (mtlsPolicyBuilder_ == null) {
        mtlsPolicy_ = builderForValue.build();
      } else {
        mtlsPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    public Builder mergeMtlsPolicy(
        com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy value) {
      if (mtlsPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && mtlsPolicy_ != null
            && mtlsPolicy_
                != com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
                    .getDefaultInstance()) {
          getMtlsPolicyBuilder().mergeFrom(value);
        } else {
          mtlsPolicy_ = value;
        }
      } else {
        mtlsPolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    public Builder clearMtlsPolicy() {
      bitField0_ = (bitField0_ & ~0x00000080);
      mtlsPolicy_ = null;
      if (mtlsPolicyBuilder_ != null) {
        mtlsPolicyBuilder_.dispose();
        mtlsPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder
        getMtlsPolicyBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getMtlsPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicyOrBuilder
        getMtlsPolicyOrBuilder() {
      if (mtlsPolicyBuilder_ != null) {
        return mtlsPolicyBuilder_.getMessageOrBuilder();
      } else {
        return mtlsPolicy_ == null
            ? com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy
                .getDefaultInstance()
            : mtlsPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Defines a mechanism to provision peer validation certificates for peer to
     * peer authentication (Mutual TLS - mTLS). If not specified, client
     * certificate will not be requested. The connection is treated as TLS and not
     * mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
     * text and mTLS connections.
     * </pre>
     *
     * <code>.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy mtls_policy = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy,
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder,
            com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicyOrBuilder>
        getMtlsPolicyFieldBuilder() {
      if (mtlsPolicyBuilder_ == null) {
        mtlsPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy,
                com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicy.Builder,
                com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy.MTLSPolicyOrBuilder>(
                getMtlsPolicy(), getParentForChildren(), isClean());
        mtlsPolicy_ = null;
      }
      return mtlsPolicyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.ServerTlsPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.ServerTlsPolicy)
  private static final com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy();
  }

  public static com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServerTlsPolicy> PARSER =
      new com.google.protobuf.AbstractParser<ServerTlsPolicy>() {
        @java.lang.Override
        public ServerTlsPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServerTlsPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServerTlsPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.ServerTlsPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
