/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networksecurity/v1beta1/client_tls_policy.proto

package com.google.cloud.networksecurity.v1beta1;

/**
 *
 *
 * <pre>
 * ClientTlsPolicy is a resource that specifies how a client should authenticate
 * connections to backends of a service. This resource itself does not affect
 * configuration unless it is attached to a backend service resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networksecurity.v1beta1.ClientTlsPolicy}
 */
public final class ClientTlsPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networksecurity.v1beta1.ClientTlsPolicy)
    ClientTlsPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClientTlsPolicy.newBuilder() to construct.
  private ClientTlsPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClientTlsPolicy() {
    name_ = "";
    description_ = "";
    sni_ = "";
    serverValidationCa_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClientTlsPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyProto
        .internal_static_google_cloud_networksecurity_v1beta1_ClientTlsPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyProto
        .internal_static_google_cloud_networksecurity_v1beta1_ClientTlsPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.class,
            com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the ClientTlsPolicy resource. It matches the pattern
   * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the ClientTlsPolicy resource. It matches the pattern
   * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Free-text description of the resource.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Free-text description of the resource.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the resource was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyProto
                .internal_static_google_cloud_networksecurity_v1beta1_ClientTlsPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Set of label tags associated with the resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SNI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sni_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Server Name Indication string to present to the server during TLS
   * handshake. E.g: "secure.example.com".
   * </pre>
   *
   * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sni.
   */
  @java.lang.Override
  public java.lang.String getSni() {
    java.lang.Object ref = sni_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sni_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Server Name Indication string to present to the server during TLS
   * handshake. E.g: "secure.example.com".
   * </pre>
   *
   * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for sni.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSniBytes() {
    java.lang.Object ref = sni_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sni_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_CERTIFICATE_FIELD_NUMBER = 7;
  private com.google.cloud.networksecurity.v1beta1.CertificateProvider clientCertificate_;
  /**
   *
   *
   * <pre>
   * Optional. Defines a mechanism to provision client identity (public and
   * private keys) for peer to peer authentication. The presence of this
   * dictates mTLS.
   * </pre>
   *
   * <code>
   * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the clientCertificate field is set.
   */
  @java.lang.Override
  public boolean hasClientCertificate() {
    return clientCertificate_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines a mechanism to provision client identity (public and
   * private keys) for peer to peer authentication. The presence of this
   * dictates mTLS.
   * </pre>
   *
   * <code>
   * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The clientCertificate.
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.CertificateProvider getClientCertificate() {
    return clientCertificate_ == null
        ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
        : clientCertificate_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines a mechanism to provision client identity (public and
   * private keys) for peer to peer authentication. The presence of this
   * dictates mTLS.
   * </pre>
   *
   * <code>
   * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder
      getClientCertificateOrBuilder() {
    return clientCertificate_ == null
        ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
        : clientCertificate_;
  }

  public static final int SERVER_VALIDATION_CA_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA> serverValidationCa_;
  /**
   *
   *
   * <pre>
   * Optional. Defines the mechanism to obtain the Certificate Authority
   * certificate to validate the server certificate. If empty, client does not
   * validate the server certificate.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
      getServerValidationCaList() {
    return serverValidationCa_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines the mechanism to obtain the Certificate Authority
   * certificate to validate the server certificate. If empty, client does not
   * validate the server certificate.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
      getServerValidationCaOrBuilderList() {
    return serverValidationCa_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines the mechanism to obtain the Certificate Authority
   * certificate to validate the server certificate. If empty, client does not
   * validate the server certificate.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getServerValidationCaCount() {
    return serverValidationCa_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines the mechanism to obtain the Certificate Authority
   * certificate to validate the server certificate. If empty, client does not
   * validate the server certificate.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.ValidationCA getServerValidationCa(int index) {
    return serverValidationCa_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines the mechanism to obtain the Certificate Authority
   * certificate to validate the server certificate. If empty, client does not
   * validate the server certificate.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder
      getServerValidationCaOrBuilder(int index) {
    return serverValidationCa_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sni_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sni_);
    }
    if (clientCertificate_ != null) {
      output.writeMessage(7, getClientCertificate());
    }
    for (int i = 0; i < serverValidationCa_.size(); i++) {
      output.writeMessage(8, serverValidationCa_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sni_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sni_);
    }
    if (clientCertificate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getClientCertificate());
    }
    for (int i = 0; i < serverValidationCa_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, serverValidationCa_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy other =
        (com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getSni().equals(other.getSni())) return false;
    if (hasClientCertificate() != other.hasClientCertificate()) return false;
    if (hasClientCertificate()) {
      if (!getClientCertificate().equals(other.getClientCertificate())) return false;
    }
    if (!getServerValidationCaList().equals(other.getServerValidationCaList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + SNI_FIELD_NUMBER;
    hash = (53 * hash) + getSni().hashCode();
    if (hasClientCertificate()) {
      hash = (37 * hash) + CLIENT_CERTIFICATE_FIELD_NUMBER;
      hash = (53 * hash) + getClientCertificate().hashCode();
    }
    if (getServerValidationCaCount() > 0) {
      hash = (37 * hash) + SERVER_VALIDATION_CA_FIELD_NUMBER;
      hash = (53 * hash) + getServerValidationCaList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ClientTlsPolicy is a resource that specifies how a client should authenticate
   * connections to backends of a service. This resource itself does not affect
   * configuration unless it is attached to a backend service resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networksecurity.v1beta1.ClientTlsPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networksecurity.v1beta1.ClientTlsPolicy)
      com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ClientTlsPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ClientTlsPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.class,
              com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.Builder.class);
    }

    // Construct using com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      sni_ = "";
      clientCertificate_ = null;
      if (clientCertificateBuilder_ != null) {
        clientCertificateBuilder_.dispose();
        clientCertificateBuilder_ = null;
      }
      if (serverValidationCaBuilder_ == null) {
        serverValidationCa_ = java.util.Collections.emptyList();
      } else {
        serverValidationCa_ = null;
        serverValidationCaBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networksecurity.v1beta1.ClientTlsPolicyProto
          .internal_static_google_cloud_networksecurity_v1beta1_ClientTlsPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy getDefaultInstanceForType() {
      return com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy build() {
      com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy buildPartial() {
      com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy result =
          new com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy result) {
      if (serverValidationCaBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          serverValidationCa_ = java.util.Collections.unmodifiableList(serverValidationCa_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.serverValidationCa_ = serverValidationCa_;
      } else {
        result.serverValidationCa_ = serverValidationCaBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sni_ = sni_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.clientCertificate_ =
            clientCertificateBuilder_ == null
                ? clientCertificate_
                : clientCertificateBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy) {
        return mergeFrom((com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy other) {
      if (other == com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (!other.getSni().isEmpty()) {
        sni_ = other.sni_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasClientCertificate()) {
        mergeClientCertificate(other.getClientCertificate());
      }
      if (serverValidationCaBuilder_ == null) {
        if (!other.serverValidationCa_.isEmpty()) {
          if (serverValidationCa_.isEmpty()) {
            serverValidationCa_ = other.serverValidationCa_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureServerValidationCaIsMutable();
            serverValidationCa_.addAll(other.serverValidationCa_);
          }
          onChanged();
        }
      } else {
        if (!other.serverValidationCa_.isEmpty()) {
          if (serverValidationCaBuilder_.isEmpty()) {
            serverValidationCaBuilder_.dispose();
            serverValidationCaBuilder_ = null;
            serverValidationCa_ = other.serverValidationCa_;
            bitField0_ = (bitField0_ & ~0x00000080);
            serverValidationCaBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServerValidationCaFieldBuilder()
                    : null;
          } else {
            serverValidationCaBuilder_.addAllMessages(other.serverValidationCa_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                sni_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getClientCertificateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.networksecurity.v1beta1.ValidationCA m =
                    input.readMessage(
                        com.google.cloud.networksecurity.v1beta1.ValidationCA.parser(),
                        extensionRegistry);
                if (serverValidationCaBuilder_ == null) {
                  ensureServerValidationCaIsMutable();
                  serverValidationCa_.add(m);
                } else {
                  serverValidationCaBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the ClientTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ClientTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ClientTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ClientTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the ClientTlsPolicy resource. It matches the pattern
     * `projects/&#42;&#47;locations/{location}/clientTlsPolicies/{client_tls_policy}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Free-text description of the resource.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the resource was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set of label tags associated with the resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.lang.Object sni_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Server Name Indication string to present to the server during TLS
     * handshake. E.g: "secure.example.com".
     * </pre>
     *
     * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sni.
     */
    public java.lang.String getSni() {
      java.lang.Object ref = sni_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sni_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Server Name Indication string to present to the server during TLS
     * handshake. E.g: "secure.example.com".
     * </pre>
     *
     * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sni.
     */
    public com.google.protobuf.ByteString getSniBytes() {
      java.lang.Object ref = sni_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sni_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Server Name Indication string to present to the server during TLS
     * handshake. E.g: "secure.example.com".
     * </pre>
     *
     * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sni to set.
     * @return This builder for chaining.
     */
    public Builder setSni(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sni_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Server Name Indication string to present to the server during TLS
     * handshake. E.g: "secure.example.com".
     * </pre>
     *
     * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSni() {
      sni_ = getDefaultInstance().getSni();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Server Name Indication string to present to the server during TLS
     * handshake. E.g: "secure.example.com".
     * </pre>
     *
     * <code>string sni = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for sni to set.
     * @return This builder for chaining.
     */
    public Builder setSniBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sni_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.networksecurity.v1beta1.CertificateProvider clientCertificate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.CertificateProvider,
            com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder,
            com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder>
        clientCertificateBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the clientCertificate field is set.
     */
    public boolean hasClientCertificate() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The clientCertificate.
     */
    public com.google.cloud.networksecurity.v1beta1.CertificateProvider getClientCertificate() {
      if (clientCertificateBuilder_ == null) {
        return clientCertificate_ == null
            ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
            : clientCertificate_;
      } else {
        return clientCertificateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClientCertificate(
        com.google.cloud.networksecurity.v1beta1.CertificateProvider value) {
      if (clientCertificateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientCertificate_ = value;
      } else {
        clientCertificateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClientCertificate(
        com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder builderForValue) {
      if (clientCertificateBuilder_ == null) {
        clientCertificate_ = builderForValue.build();
      } else {
        clientCertificateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeClientCertificate(
        com.google.cloud.networksecurity.v1beta1.CertificateProvider value) {
      if (clientCertificateBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && clientCertificate_ != null
            && clientCertificate_
                != com.google.cloud.networksecurity.v1beta1.CertificateProvider
                    .getDefaultInstance()) {
          getClientCertificateBuilder().mergeFrom(value);
        } else {
          clientCertificate_ = value;
        }
      } else {
        clientCertificateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearClientCertificate() {
      bitField0_ = (bitField0_ & ~0x00000040);
      clientCertificate_ = null;
      if (clientCertificateBuilder_ != null) {
        clientCertificateBuilder_.dispose();
        clientCertificateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder
        getClientCertificateBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getClientCertificateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder
        getClientCertificateOrBuilder() {
      if (clientCertificateBuilder_ != null) {
        return clientCertificateBuilder_.getMessageOrBuilder();
      } else {
        return clientCertificate_ == null
            ? com.google.cloud.networksecurity.v1beta1.CertificateProvider.getDefaultInstance()
            : clientCertificate_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a mechanism to provision client identity (public and
     * private keys) for peer to peer authentication. The presence of this
     * dictates mTLS.
     * </pre>
     *
     * <code>
     * .google.cloud.networksecurity.v1beta1.CertificateProvider client_certificate = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.CertificateProvider,
            com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder,
            com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder>
        getClientCertificateFieldBuilder() {
      if (clientCertificateBuilder_ == null) {
        clientCertificateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.CertificateProvider,
                com.google.cloud.networksecurity.v1beta1.CertificateProvider.Builder,
                com.google.cloud.networksecurity.v1beta1.CertificateProviderOrBuilder>(
                getClientCertificate(), getParentForChildren(), isClean());
        clientCertificate_ = null;
      }
      return clientCertificateBuilder_;
    }

    private java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
        serverValidationCa_ = java.util.Collections.emptyList();

    private void ensureServerValidationCaIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        serverValidationCa_ =
            new java.util.ArrayList<com.google.cloud.networksecurity.v1beta1.ValidationCA>(
                serverValidationCa_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.ValidationCA,
            com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder,
            com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
        serverValidationCaBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA>
        getServerValidationCaList() {
      if (serverValidationCaBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serverValidationCa_);
      } else {
        return serverValidationCaBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getServerValidationCaCount() {
      if (serverValidationCaBuilder_ == null) {
        return serverValidationCa_.size();
      } else {
        return serverValidationCaBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ValidationCA getServerValidationCa(int index) {
      if (serverValidationCaBuilder_ == null) {
        return serverValidationCa_.get(index);
      } else {
        return serverValidationCaBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setServerValidationCa(
        int index, com.google.cloud.networksecurity.v1beta1.ValidationCA value) {
      if (serverValidationCaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServerValidationCaIsMutable();
        serverValidationCa_.set(index, value);
        onChanged();
      } else {
        serverValidationCaBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setServerValidationCa(
        int index, com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder builderForValue) {
      if (serverValidationCaBuilder_ == null) {
        ensureServerValidationCaIsMutable();
        serverValidationCa_.set(index, builderForValue.build());
        onChanged();
      } else {
        serverValidationCaBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServerValidationCa(
        com.google.cloud.networksecurity.v1beta1.ValidationCA value) {
      if (serverValidationCaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServerValidationCaIsMutable();
        serverValidationCa_.add(value);
        onChanged();
      } else {
        serverValidationCaBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServerValidationCa(
        int index, com.google.cloud.networksecurity.v1beta1.ValidationCA value) {
      if (serverValidationCaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServerValidationCaIsMutable();
        serverValidationCa_.add(index, value);
        onChanged();
      } else {
        serverValidationCaBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServerValidationCa(
        com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder builderForValue) {
      if (serverValidationCaBuilder_ == null) {
        ensureServerValidationCaIsMutable();
        serverValidationCa_.add(builderForValue.build());
        onChanged();
      } else {
        serverValidationCaBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServerValidationCa(
        int index, com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder builderForValue) {
      if (serverValidationCaBuilder_ == null) {
        ensureServerValidationCaIsMutable();
        serverValidationCa_.add(index, builderForValue.build());
        onChanged();
      } else {
        serverValidationCaBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllServerValidationCa(
        java.lang.Iterable<? extends com.google.cloud.networksecurity.v1beta1.ValidationCA>
            values) {
      if (serverValidationCaBuilder_ == null) {
        ensureServerValidationCaIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serverValidationCa_);
        onChanged();
      } else {
        serverValidationCaBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearServerValidationCa() {
      if (serverValidationCaBuilder_ == null) {
        serverValidationCa_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        serverValidationCaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeServerValidationCa(int index) {
      if (serverValidationCaBuilder_ == null) {
        ensureServerValidationCaIsMutable();
        serverValidationCa_.remove(index);
        onChanged();
      } else {
        serverValidationCaBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder
        getServerValidationCaBuilder(int index) {
      return getServerValidationCaFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder
        getServerValidationCaOrBuilder(int index) {
      if (serverValidationCaBuilder_ == null) {
        return serverValidationCa_.get(index);
      } else {
        return serverValidationCaBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
        getServerValidationCaOrBuilderList() {
      if (serverValidationCaBuilder_ != null) {
        return serverValidationCaBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serverValidationCa_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder
        addServerValidationCaBuilder() {
      return getServerValidationCaFieldBuilder()
          .addBuilder(com.google.cloud.networksecurity.v1beta1.ValidationCA.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder
        addServerValidationCaBuilder(int index) {
      return getServerValidationCaFieldBuilder()
          .addBuilder(
              index, com.google.cloud.networksecurity.v1beta1.ValidationCA.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the mechanism to obtain the Certificate Authority
     * certificate to validate the server certificate. If empty, client does not
     * validate the server certificate.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networksecurity.v1beta1.ValidationCA server_validation_ca = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder>
        getServerValidationCaBuilderList() {
      return getServerValidationCaFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networksecurity.v1beta1.ValidationCA,
            com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder,
            com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>
        getServerValidationCaFieldBuilder() {
      if (serverValidationCaBuilder_ == null) {
        serverValidationCaBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networksecurity.v1beta1.ValidationCA,
                com.google.cloud.networksecurity.v1beta1.ValidationCA.Builder,
                com.google.cloud.networksecurity.v1beta1.ValidationCAOrBuilder>(
                serverValidationCa_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        serverValidationCa_ = null;
      }
      return serverValidationCaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networksecurity.v1beta1.ClientTlsPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networksecurity.v1beta1.ClientTlsPolicy)
  private static final com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy();
  }

  public static com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClientTlsPolicy> PARSER =
      new com.google.protobuf.AbstractParser<ClientTlsPolicy>() {
        @java.lang.Override
        public ClientTlsPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClientTlsPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClientTlsPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networksecurity.v1beta1.ClientTlsPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
