/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceConnectionMapName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_CONNECTION_MAP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceConnectionMaps/{service_connection_map}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceConnectionMap;

    @Deprecated
    protected ServiceConnectionMapName() {
        this.project = null;
        this.location = null;
        this.serviceConnectionMap = null;
    }

    private ServiceConnectionMapName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceConnectionMap = (String)Preconditions.checkNotNull((Object)builder.getServiceConnectionMap());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceConnectionMap() {
        return this.serviceConnectionMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceConnectionMapName of(String project, String location, String serviceConnectionMap) {
        return ServiceConnectionMapName.newBuilder().setProject(project).setLocation(location).setServiceConnectionMap(serviceConnectionMap).build();
    }

    public static String format(String project, String location, String serviceConnectionMap) {
        return ServiceConnectionMapName.newBuilder().setProject(project).setLocation(location).setServiceConnectionMap(serviceConnectionMap).build().toString();
    }

    public static ServiceConnectionMapName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_CONNECTION_MAP.validatedMatch(formattedString, "ServiceConnectionMapName.parse: formattedString not in valid format");
        return ServiceConnectionMapName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_connection_map"));
    }

    public static List<ServiceConnectionMapName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceConnectionMapName> list = new ArrayList<ServiceConnectionMapName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceConnectionMapName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceConnectionMapName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceConnectionMapName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_CONNECTION_MAP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceConnectionMapName serviceConnectionMapName = this;
            synchronized (serviceConnectionMapName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceConnectionMap != null) {
                        fieldMapBuilder.put((Object)"service_connection_map", (Object)this.serviceConnectionMap);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_CONNECTION_MAP.instantiate(new String[]{"project", this.project, "location", this.location, "service_connection_map", this.serviceConnectionMap});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceConnectionMapName that = (ServiceConnectionMapName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceConnectionMap, that.serviceConnectionMap);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceConnectionMap);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceConnectionMap;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceConnectionMap() {
            return this.serviceConnectionMap;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceConnectionMap(String serviceConnectionMap) {
            this.serviceConnectionMap = serviceConnectionMap;
            return this;
        }

        private Builder(ServiceConnectionMapName serviceConnectionMapName) {
            this.project = serviceConnectionMapName.project;
            this.location = serviceConnectionMapName.location;
            this.serviceConnectionMap = serviceConnectionMapName.serviceConnectionMap;
        }

        public ServiceConnectionMapName build() {
            return new ServiceConnectionMapName(this);
        }
    }
}

