/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceConnectionTokenName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_CONNECTION_TOKEN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceConnectionTokens/{service_connection_token}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceConnectionToken;

    @Deprecated
    protected ServiceConnectionTokenName() {
        this.project = null;
        this.location = null;
        this.serviceConnectionToken = null;
    }

    private ServiceConnectionTokenName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceConnectionToken = (String)Preconditions.checkNotNull((Object)builder.getServiceConnectionToken());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceConnectionToken() {
        return this.serviceConnectionToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceConnectionTokenName of(String project, String location, String serviceConnectionToken) {
        return ServiceConnectionTokenName.newBuilder().setProject(project).setLocation(location).setServiceConnectionToken(serviceConnectionToken).build();
    }

    public static String format(String project, String location, String serviceConnectionToken) {
        return ServiceConnectionTokenName.newBuilder().setProject(project).setLocation(location).setServiceConnectionToken(serviceConnectionToken).build().toString();
    }

    public static ServiceConnectionTokenName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_CONNECTION_TOKEN.validatedMatch(formattedString, "ServiceConnectionTokenName.parse: formattedString not in valid format");
        return ServiceConnectionTokenName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_connection_token"));
    }

    public static List<ServiceConnectionTokenName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceConnectionTokenName> list = new ArrayList<ServiceConnectionTokenName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceConnectionTokenName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceConnectionTokenName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceConnectionTokenName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_CONNECTION_TOKEN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceConnectionTokenName serviceConnectionTokenName = this;
            synchronized (serviceConnectionTokenName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceConnectionToken != null) {
                        fieldMapBuilder.put((Object)"service_connection_token", (Object)this.serviceConnectionToken);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_CONNECTION_TOKEN.instantiate(new String[]{"project", this.project, "location", this.location, "service_connection_token", this.serviceConnectionToken});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceConnectionTokenName that = (ServiceConnectionTokenName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceConnectionToken, that.serviceConnectionToken);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceConnectionToken);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceConnectionToken;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceConnectionToken() {
            return this.serviceConnectionToken;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceConnectionToken(String serviceConnectionToken) {
            this.serviceConnectionToken = serviceConnectionToken;
            return this;
        }

        private Builder(ServiceConnectionTokenName serviceConnectionTokenName) {
            this.project = serviceConnectionTokenName.project;
            this.location = serviceConnectionTokenName.location;
            this.serviceConnectionToken = serviceConnectionTokenName.serviceConnectionToken;
        }

        public ServiceConnectionTokenName build() {
            return new ServiceConnectionTokenName(this);
        }
    }
}

