/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.cloud.networkconnectivity.v1.ConnectionErrorType;
import com.google.cloud.networkconnectivity.v1.CrossNetworkAutomationProto;
import com.google.cloud.networkconnectivity.v1.IPVersion;
import com.google.cloud.networkconnectivity.v1.Infrastructure;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionMapOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import com.google.rpc.ErrorInfo;
import com.google.rpc.ErrorInfoOrBuilder;
import com.google.rpc.Status;
import com.google.rpc.StatusOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ServiceConnectionMap
extends GeneratedMessageV3
implements ServiceConnectionMapOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int CREATE_TIME_FIELD_NUMBER = 2;
    private Timestamp createTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 3;
    private Timestamp updateTime_;
    public static final int LABELS_FIELD_NUMBER = 4;
    private MapField<String, String> labels_;
    public static final int DESCRIPTION_FIELD_NUMBER = 5;
    private volatile Object description_ = "";
    public static final int SERVICE_CLASS_FIELD_NUMBER = 7;
    private volatile Object serviceClass_ = "";
    public static final int SERVICE_CLASS_URI_FIELD_NUMBER = 12;
    private volatile Object serviceClassUri_ = "";
    public static final int INFRASTRUCTURE_FIELD_NUMBER = 8;
    private int infrastructure_ = 0;
    public static final int PRODUCER_PSC_CONFIGS_FIELD_NUMBER = 9;
    private List<ProducerPscConfig> producerPscConfigs_;
    public static final int CONSUMER_PSC_CONFIGS_FIELD_NUMBER = 10;
    private List<ConsumerPscConfig> consumerPscConfigs_;
    public static final int CONSUMER_PSC_CONNECTIONS_FIELD_NUMBER = 11;
    private List<ConsumerPscConnection> consumerPscConnections_;
    public static final int TOKEN_FIELD_NUMBER = 13;
    private volatile Object token_ = "";
    public static final int ETAG_FIELD_NUMBER = 14;
    private volatile Object etag_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final ServiceConnectionMap DEFAULT_INSTANCE = new ServiceConnectionMap();
    private static final Parser<ServiceConnectionMap> PARSER = new AbstractParser<ServiceConnectionMap>(){

        public ServiceConnectionMap parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ServiceConnectionMap.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ServiceConnectionMap(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ServiceConnectionMap() {
        this.name_ = "";
        this.description_ = "";
        this.serviceClass_ = "";
        this.serviceClassUri_ = "";
        this.infrastructure_ = 0;
        this.producerPscConfigs_ = Collections.emptyList();
        this.consumerPscConfigs_ = Collections.emptyList();
        this.consumerPscConnections_ = Collections.emptyList();
        this.token_ = "";
        this.etag_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ServiceConnectionMap();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 4: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_fieldAccessorTable.ensureFieldAccessorsInitialized(ServiceConnectionMap.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getServiceClass() {
        Object ref = this.serviceClass_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceClass_ = s;
        return s;
    }

    @Override
    public ByteString getServiceClassBytes() {
        Object ref = this.serviceClass_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceClass_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getServiceClassUri() {
        Object ref = this.serviceClassUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceClassUri_ = s;
        return s;
    }

    @Override
    public ByteString getServiceClassUriBytes() {
        Object ref = this.serviceClassUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceClassUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getInfrastructureValue() {
        return this.infrastructure_;
    }

    @Override
    public Infrastructure getInfrastructure() {
        Infrastructure result = Infrastructure.forNumber(this.infrastructure_);
        return result == null ? Infrastructure.UNRECOGNIZED : result;
    }

    @Override
    public List<ProducerPscConfig> getProducerPscConfigsList() {
        return this.producerPscConfigs_;
    }

    @Override
    public List<? extends ProducerPscConfigOrBuilder> getProducerPscConfigsOrBuilderList() {
        return this.producerPscConfigs_;
    }

    @Override
    public int getProducerPscConfigsCount() {
        return this.producerPscConfigs_.size();
    }

    @Override
    public ProducerPscConfig getProducerPscConfigs(int index) {
        return this.producerPscConfigs_.get(index);
    }

    @Override
    public ProducerPscConfigOrBuilder getProducerPscConfigsOrBuilder(int index) {
        return this.producerPscConfigs_.get(index);
    }

    @Override
    public List<ConsumerPscConfig> getConsumerPscConfigsList() {
        return this.consumerPscConfigs_;
    }

    @Override
    public List<? extends ConsumerPscConfigOrBuilder> getConsumerPscConfigsOrBuilderList() {
        return this.consumerPscConfigs_;
    }

    @Override
    public int getConsumerPscConfigsCount() {
        return this.consumerPscConfigs_.size();
    }

    @Override
    public ConsumerPscConfig getConsumerPscConfigs(int index) {
        return this.consumerPscConfigs_.get(index);
    }

    @Override
    public ConsumerPscConfigOrBuilder getConsumerPscConfigsOrBuilder(int index) {
        return this.consumerPscConfigs_.get(index);
    }

    @Override
    public List<ConsumerPscConnection> getConsumerPscConnectionsList() {
        return this.consumerPscConnections_;
    }

    @Override
    public List<? extends ConsumerPscConnectionOrBuilder> getConsumerPscConnectionsOrBuilderList() {
        return this.consumerPscConnections_;
    }

    @Override
    public int getConsumerPscConnectionsCount() {
        return this.consumerPscConnections_.size();
    }

    @Override
    public ConsumerPscConnection getConsumerPscConnections(int index) {
        return this.consumerPscConnections_.get(index);
    }

    @Override
    public ConsumerPscConnectionOrBuilder getConsumerPscConnectionsOrBuilder(int index) {
        return this.consumerPscConnections_.get(index);
    }

    @Override
    public String getToken() {
        Object ref = this.token_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.token_ = s;
        return s;
    }

    @Override
    public ByteString getTokenBytes() {
        Object ref = this.token_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.token_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasEtag() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getEtag() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.etag_ = s;
        return s;
    }

    @Override
    public ByteString getEtagBytes() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.etag_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(2, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(3, (MessageLite)this.getUpdateTime());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)4);
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.description_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceClass_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.serviceClass_);
        }
        if (this.infrastructure_ != Infrastructure.INFRASTRUCTURE_UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.infrastructure_);
        }
        for (i = 0; i < this.producerPscConfigs_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.producerPscConfigs_.get(i));
        }
        for (i = 0; i < this.consumerPscConfigs_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.consumerPscConfigs_.get(i));
        }
        for (i = 0; i < this.consumerPscConnections_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.consumerPscConnections_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceClassUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.serviceClassUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.token_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.token_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.etag_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getUpdateTime());
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)labels__);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.description_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceClass_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.serviceClass_);
        }
        if (this.infrastructure_ != Infrastructure.INFRASTRUCTURE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.infrastructure_);
        }
        for (i = 0; i < this.producerPscConfigs_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.producerPscConfigs_.get(i)));
        }
        for (i = 0; i < this.consumerPscConfigs_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.consumerPscConfigs_.get(i)));
        }
        for (i = 0; i < this.consumerPscConnections_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.consumerPscConnections_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceClassUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.serviceClassUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.token_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.token_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.etag_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceConnectionMap)) {
            return super.equals(obj);
        }
        ServiceConnectionMap other = (ServiceConnectionMap)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getServiceClass().equals(other.getServiceClass())) {
            return false;
        }
        if (!this.getServiceClassUri().equals(other.getServiceClassUri())) {
            return false;
        }
        if (this.infrastructure_ != other.infrastructure_) {
            return false;
        }
        if (!this.getProducerPscConfigsList().equals(other.getProducerPscConfigsList())) {
            return false;
        }
        if (!this.getConsumerPscConfigsList().equals(other.getConsumerPscConfigsList())) {
            return false;
        }
        if (!this.getConsumerPscConnectionsList().equals(other.getConsumerPscConnectionsList())) {
            return false;
        }
        if (!this.getToken().equals(other.getToken())) {
            return false;
        }
        if (this.hasEtag() != other.hasEtag()) {
            return false;
        }
        if (this.hasEtag() && !this.getEtag().equals(other.getEtag())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ServiceConnectionMap.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.hasCreateTime()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getServiceClass().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getServiceClassUri().hashCode();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.infrastructure_;
        if (this.getProducerPscConfigsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getProducerPscConfigsList().hashCode();
        }
        if (this.getConsumerPscConfigsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getConsumerPscConfigsList().hashCode();
        }
        if (this.getConsumerPscConnectionsCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getConsumerPscConnectionsList().hashCode();
        }
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getToken().hashCode();
        if (this.hasEtag()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getEtag().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ServiceConnectionMap parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ServiceConnectionMap)PARSER.parseFrom(data);
    }

    public static ServiceConnectionMap parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ServiceConnectionMap)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ServiceConnectionMap parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ServiceConnectionMap)PARSER.parseFrom(data);
    }

    public static ServiceConnectionMap parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ServiceConnectionMap)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ServiceConnectionMap parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ServiceConnectionMap)PARSER.parseFrom(data);
    }

    public static ServiceConnectionMap parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ServiceConnectionMap)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ServiceConnectionMap parseFrom(InputStream input) throws IOException {
        return (ServiceConnectionMap)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ServiceConnectionMap parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ServiceConnectionMap)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ServiceConnectionMap parseDelimitedFrom(InputStream input) throws IOException {
        return (ServiceConnectionMap)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ServiceConnectionMap parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ServiceConnectionMap)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ServiceConnectionMap parseFrom(CodedInputStream input) throws IOException {
        return (ServiceConnectionMap)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ServiceConnectionMap parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ServiceConnectionMap)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ServiceConnectionMap.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ServiceConnectionMap prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ServiceConnectionMap getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ServiceConnectionMap> parser() {
        return PARSER;
    }

    public Parser<ServiceConnectionMap> getParserForType() {
        return PARSER;
    }

    public ServiceConnectionMap getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ServiceConnectionMapOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private MapField<String, String> labels_;
        private Object description_ = "";
        private Object serviceClass_ = "";
        private Object serviceClassUri_ = "";
        private int infrastructure_ = 0;
        private List<ProducerPscConfig> producerPscConfigs_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ProducerPscConfig, ProducerPscConfig.Builder, ProducerPscConfigOrBuilder> producerPscConfigsBuilder_;
        private List<ConsumerPscConfig> consumerPscConfigs_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ConsumerPscConfig, ConsumerPscConfig.Builder, ConsumerPscConfigOrBuilder> consumerPscConfigsBuilder_;
        private List<ConsumerPscConnection> consumerPscConnections_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ConsumerPscConnection, ConsumerPscConnection.Builder, ConsumerPscConnectionOrBuilder> consumerPscConnectionsBuilder_;
        private Object token_ = "";
        private Object etag_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_fieldAccessorTable.ensureFieldAccessorsInitialized(ServiceConnectionMap.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCreateTimeFieldBuilder();
                this.getUpdateTimeFieldBuilder();
                this.getProducerPscConfigsFieldBuilder();
                this.getConsumerPscConfigsFieldBuilder();
                this.getConsumerPscConnectionsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.internalGetMutableLabels().clear();
            this.description_ = "";
            this.serviceClass_ = "";
            this.serviceClassUri_ = "";
            this.infrastructure_ = 0;
            if (this.producerPscConfigsBuilder_ == null) {
                this.producerPscConfigs_ = Collections.emptyList();
            } else {
                this.producerPscConfigs_ = null;
                this.producerPscConfigsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            if (this.consumerPscConfigsBuilder_ == null) {
                this.consumerPscConfigs_ = Collections.emptyList();
            } else {
                this.consumerPscConfigs_ = null;
                this.consumerPscConfigsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.consumerPscConnections_ = Collections.emptyList();
            } else {
                this.consumerPscConnections_ = null;
                this.consumerPscConnectionsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            this.token_ = "";
            this.etag_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_descriptor;
        }

        public ServiceConnectionMap getDefaultInstanceForType() {
            return ServiceConnectionMap.getDefaultInstance();
        }

        public ServiceConnectionMap build() {
            ServiceConnectionMap result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ServiceConnectionMap buildPartial() {
            ServiceConnectionMap result = new ServiceConnectionMap(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ServiceConnectionMap result) {
            if (this.producerPscConfigsBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.producerPscConfigs_ = Collections.unmodifiableList(this.producerPscConfigs_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.producerPscConfigs_ = this.producerPscConfigs_;
            } else {
                result.producerPscConfigs_ = this.producerPscConfigsBuilder_.build();
            }
            if (this.consumerPscConfigsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.consumerPscConfigs_ = Collections.unmodifiableList(this.consumerPscConfigs_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.consumerPscConfigs_ = this.consumerPscConfigs_;
            } else {
                result.consumerPscConfigs_ = this.consumerPscConfigsBuilder_.build();
            }
            if (this.consumerPscConnectionsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.consumerPscConnections_ = Collections.unmodifiableList(this.consumerPscConnections_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.consumerPscConnections_ = this.consumerPscConnections_;
            } else {
                result.consumerPscConnections_ = this.consumerPscConnectionsBuilder_.build();
            }
        }

        private void buildPartial0(ServiceConnectionMap result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.serviceClass_ = this.serviceClass_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.serviceClassUri_ = this.serviceClassUri_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.infrastructure_ = this.infrastructure_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.token_ = this.token_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.etag_ = this.etag_;
                to_bitField0_ |= 4;
            }
            ServiceConnectionMap serviceConnectionMap = result;
            serviceConnectionMap.bitField0_ = serviceConnectionMap.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ServiceConnectionMap) {
                return this.mergeFrom((ServiceConnectionMap)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ServiceConnectionMap other) {
            if (other == ServiceConnectionMap.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 8;
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (!other.getServiceClass().isEmpty()) {
                this.serviceClass_ = other.serviceClass_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (!other.getServiceClassUri().isEmpty()) {
                this.serviceClassUri_ = other.serviceClassUri_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.infrastructure_ != 0) {
                this.setInfrastructureValue(other.getInfrastructureValue());
            }
            if (this.producerPscConfigsBuilder_ == null) {
                if (!other.producerPscConfigs_.isEmpty()) {
                    if (this.producerPscConfigs_.isEmpty()) {
                        this.producerPscConfigs_ = other.producerPscConfigs_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureProducerPscConfigsIsMutable();
                        this.producerPscConfigs_.addAll(other.producerPscConfigs_);
                    }
                    this.onChanged();
                }
            } else if (!other.producerPscConfigs_.isEmpty()) {
                if (this.producerPscConfigsBuilder_.isEmpty()) {
                    this.producerPscConfigsBuilder_.dispose();
                    this.producerPscConfigsBuilder_ = null;
                    this.producerPscConfigs_ = other.producerPscConfigs_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.producerPscConfigsBuilder_ = alwaysUseFieldBuilders ? this.getProducerPscConfigsFieldBuilder() : null;
                } else {
                    this.producerPscConfigsBuilder_.addAllMessages((Iterable)other.producerPscConfigs_);
                }
            }
            if (this.consumerPscConfigsBuilder_ == null) {
                if (!other.consumerPscConfigs_.isEmpty()) {
                    if (this.consumerPscConfigs_.isEmpty()) {
                        this.consumerPscConfigs_ = other.consumerPscConfigs_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureConsumerPscConfigsIsMutable();
                        this.consumerPscConfigs_.addAll(other.consumerPscConfigs_);
                    }
                    this.onChanged();
                }
            } else if (!other.consumerPscConfigs_.isEmpty()) {
                if (this.consumerPscConfigsBuilder_.isEmpty()) {
                    this.consumerPscConfigsBuilder_.dispose();
                    this.consumerPscConfigsBuilder_ = null;
                    this.consumerPscConfigs_ = other.consumerPscConfigs_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.consumerPscConfigsBuilder_ = alwaysUseFieldBuilders ? this.getConsumerPscConfigsFieldBuilder() : null;
                } else {
                    this.consumerPscConfigsBuilder_.addAllMessages((Iterable)other.consumerPscConfigs_);
                }
            }
            if (this.consumerPscConnectionsBuilder_ == null) {
                if (!other.consumerPscConnections_.isEmpty()) {
                    if (this.consumerPscConnections_.isEmpty()) {
                        this.consumerPscConnections_ = other.consumerPscConnections_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureConsumerPscConnectionsIsMutable();
                        this.consumerPscConnections_.addAll(other.consumerPscConnections_);
                    }
                    this.onChanged();
                }
            } else if (!other.consumerPscConnections_.isEmpty()) {
                if (this.consumerPscConnectionsBuilder_.isEmpty()) {
                    this.consumerPscConnectionsBuilder_.dispose();
                    this.consumerPscConnectionsBuilder_ = null;
                    this.consumerPscConnections_ = other.consumerPscConnections_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.consumerPscConnectionsBuilder_ = alwaysUseFieldBuilders ? this.getConsumerPscConnectionsFieldBuilder() : null;
                } else {
                    this.consumerPscConnectionsBuilder_.addAllMessages((Iterable)other.consumerPscConnections_);
                }
            }
            if (!other.getToken().isEmpty()) {
                this.token_ = other.token_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (other.hasEtag()) {
                this.etag_ = other.etag_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 34: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 8;
                            continue block21;
                        }
                        case 42: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block21;
                        }
                        case 58: {
                            this.serviceClass_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 64: {
                            this.infrastructure_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block21;
                        }
                        case 74: {
                            GeneratedMessageV3 m = (ProducerPscConfig)input.readMessage(ProducerPscConfig.parser(), extensionRegistry);
                            if (this.producerPscConfigsBuilder_ == null) {
                                this.ensureProducerPscConfigsIsMutable();
                                this.producerPscConfigs_.add((ProducerPscConfig)m);
                                continue block21;
                            }
                            this.producerPscConfigsBuilder_.addMessage((AbstractMessage)m);
                            continue block21;
                        }
                        case 82: {
                            GeneratedMessageV3 m = (ConsumerPscConfig)input.readMessage(ConsumerPscConfig.parser(), extensionRegistry);
                            if (this.consumerPscConfigsBuilder_ == null) {
                                this.ensureConsumerPscConfigsIsMutable();
                                this.consumerPscConfigs_.add((ConsumerPscConfig)m);
                                continue block21;
                            }
                            this.consumerPscConfigsBuilder_.addMessage((AbstractMessage)m);
                            continue block21;
                        }
                        case 90: {
                            GeneratedMessageV3 m = (ConsumerPscConnection)input.readMessage(ConsumerPscConnection.parser(), extensionRegistry);
                            if (this.consumerPscConnectionsBuilder_ == null) {
                                this.ensureConsumerPscConnectionsIsMutable();
                                this.consumerPscConnections_.add((ConsumerPscConnection)m);
                                continue block21;
                            }
                            this.consumerPscConnectionsBuilder_.addMessage((AbstractMessage)m);
                            continue block21;
                        }
                        case 98: {
                            this.serviceClassUri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 106: {
                            this.token_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block21;
                        }
                        case 114: {
                            this.etag_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = ServiceConnectionMap.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConnectionMap.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.updateTime_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 8;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 8;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 8;
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = ServiceConnectionMap.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConnectionMap.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceClass() {
            Object ref = this.serviceClass_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceClass_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceClassBytes() {
            Object ref = this.serviceClass_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceClass_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceClass(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceClass_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearServiceClass() {
            this.serviceClass_ = ServiceConnectionMap.getDefaultInstance().getServiceClass();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setServiceClassBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConnectionMap.checkByteStringIsUtf8((ByteString)value);
            this.serviceClass_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceClassUri() {
            Object ref = this.serviceClassUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceClassUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceClassUriBytes() {
            Object ref = this.serviceClassUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceClassUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceClassUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceClassUri_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearServiceClassUri() {
            this.serviceClassUri_ = ServiceConnectionMap.getDefaultInstance().getServiceClassUri();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setServiceClassUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConnectionMap.checkByteStringIsUtf8((ByteString)value);
            this.serviceClassUri_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public int getInfrastructureValue() {
            return this.infrastructure_;
        }

        public Builder setInfrastructureValue(int value) {
            this.infrastructure_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public Infrastructure getInfrastructure() {
            Infrastructure result = Infrastructure.forNumber(this.infrastructure_);
            return result == null ? Infrastructure.UNRECOGNIZED : result;
        }

        public Builder setInfrastructure(Infrastructure value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.infrastructure_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearInfrastructure() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.infrastructure_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureProducerPscConfigsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.producerPscConfigs_ = new ArrayList<ProducerPscConfig>(this.producerPscConfigs_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<ProducerPscConfig> getProducerPscConfigsList() {
            if (this.producerPscConfigsBuilder_ == null) {
                return Collections.unmodifiableList(this.producerPscConfigs_);
            }
            return this.producerPscConfigsBuilder_.getMessageList();
        }

        @Override
        public int getProducerPscConfigsCount() {
            if (this.producerPscConfigsBuilder_ == null) {
                return this.producerPscConfigs_.size();
            }
            return this.producerPscConfigsBuilder_.getCount();
        }

        @Override
        public ProducerPscConfig getProducerPscConfigs(int index) {
            if (this.producerPscConfigsBuilder_ == null) {
                return this.producerPscConfigs_.get(index);
            }
            return (ProducerPscConfig)this.producerPscConfigsBuilder_.getMessage(index);
        }

        public Builder setProducerPscConfigs(int index, ProducerPscConfig value) {
            if (this.producerPscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.set(index, value);
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setProducerPscConfigs(int index, ProducerPscConfig.Builder builderForValue) {
            if (this.producerPscConfigsBuilder_ == null) {
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProducerPscConfigs(ProducerPscConfig value) {
            if (this.producerPscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.add(value);
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addProducerPscConfigs(int index, ProducerPscConfig value) {
            if (this.producerPscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.add(index, value);
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addProducerPscConfigs(ProducerPscConfig.Builder builderForValue) {
            if (this.producerPscConfigsBuilder_ == null) {
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProducerPscConfigs(int index, ProducerPscConfig.Builder builderForValue) {
            if (this.producerPscConfigsBuilder_ == null) {
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllProducerPscConfigs(Iterable<? extends ProducerPscConfig> values) {
            if (this.producerPscConfigsBuilder_ == null) {
                this.ensureProducerPscConfigsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.producerPscConfigs_);
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearProducerPscConfigs() {
            if (this.producerPscConfigsBuilder_ == null) {
                this.producerPscConfigs_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.clear();
            }
            return this;
        }

        public Builder removeProducerPscConfigs(int index) {
            if (this.producerPscConfigsBuilder_ == null) {
                this.ensureProducerPscConfigsIsMutable();
                this.producerPscConfigs_.remove(index);
                this.onChanged();
            } else {
                this.producerPscConfigsBuilder_.remove(index);
            }
            return this;
        }

        public ProducerPscConfig.Builder getProducerPscConfigsBuilder(int index) {
            return (ProducerPscConfig.Builder)this.getProducerPscConfigsFieldBuilder().getBuilder(index);
        }

        @Override
        public ProducerPscConfigOrBuilder getProducerPscConfigsOrBuilder(int index) {
            if (this.producerPscConfigsBuilder_ == null) {
                return this.producerPscConfigs_.get(index);
            }
            return (ProducerPscConfigOrBuilder)this.producerPscConfigsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ProducerPscConfigOrBuilder> getProducerPscConfigsOrBuilderList() {
            if (this.producerPscConfigsBuilder_ != null) {
                return this.producerPscConfigsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.producerPscConfigs_);
        }

        public ProducerPscConfig.Builder addProducerPscConfigsBuilder() {
            return (ProducerPscConfig.Builder)this.getProducerPscConfigsFieldBuilder().addBuilder((AbstractMessage)ProducerPscConfig.getDefaultInstance());
        }

        public ProducerPscConfig.Builder addProducerPscConfigsBuilder(int index) {
            return (ProducerPscConfig.Builder)this.getProducerPscConfigsFieldBuilder().addBuilder(index, (AbstractMessage)ProducerPscConfig.getDefaultInstance());
        }

        public List<ProducerPscConfig.Builder> getProducerPscConfigsBuilderList() {
            return this.getProducerPscConfigsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ProducerPscConfig, ProducerPscConfig.Builder, ProducerPscConfigOrBuilder> getProducerPscConfigsFieldBuilder() {
            if (this.producerPscConfigsBuilder_ == null) {
                this.producerPscConfigsBuilder_ = new RepeatedFieldBuilderV3(this.producerPscConfigs_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.producerPscConfigs_ = null;
            }
            return this.producerPscConfigsBuilder_;
        }

        private void ensureConsumerPscConfigsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.consumerPscConfigs_ = new ArrayList<ConsumerPscConfig>(this.consumerPscConfigs_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<ConsumerPscConfig> getConsumerPscConfigsList() {
            if (this.consumerPscConfigsBuilder_ == null) {
                return Collections.unmodifiableList(this.consumerPscConfigs_);
            }
            return this.consumerPscConfigsBuilder_.getMessageList();
        }

        @Override
        public int getConsumerPscConfigsCount() {
            if (this.consumerPscConfigsBuilder_ == null) {
                return this.consumerPscConfigs_.size();
            }
            return this.consumerPscConfigsBuilder_.getCount();
        }

        @Override
        public ConsumerPscConfig getConsumerPscConfigs(int index) {
            if (this.consumerPscConfigsBuilder_ == null) {
                return this.consumerPscConfigs_.get(index);
            }
            return (ConsumerPscConfig)this.consumerPscConfigsBuilder_.getMessage(index);
        }

        public Builder setConsumerPscConfigs(int index, ConsumerPscConfig value) {
            if (this.consumerPscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.set(index, value);
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setConsumerPscConfigs(int index, ConsumerPscConfig.Builder builderForValue) {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addConsumerPscConfigs(ConsumerPscConfig value) {
            if (this.consumerPscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.add(value);
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addConsumerPscConfigs(int index, ConsumerPscConfig value) {
            if (this.consumerPscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.add(index, value);
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addConsumerPscConfigs(ConsumerPscConfig.Builder builderForValue) {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addConsumerPscConfigs(int index, ConsumerPscConfig.Builder builderForValue) {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllConsumerPscConfigs(Iterable<? extends ConsumerPscConfig> values) {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.ensureConsumerPscConfigsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.consumerPscConfigs_);
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearConsumerPscConfigs() {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.consumerPscConfigs_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.clear();
            }
            return this;
        }

        public Builder removeConsumerPscConfigs(int index) {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.ensureConsumerPscConfigsIsMutable();
                this.consumerPscConfigs_.remove(index);
                this.onChanged();
            } else {
                this.consumerPscConfigsBuilder_.remove(index);
            }
            return this;
        }

        public ConsumerPscConfig.Builder getConsumerPscConfigsBuilder(int index) {
            return (ConsumerPscConfig.Builder)this.getConsumerPscConfigsFieldBuilder().getBuilder(index);
        }

        @Override
        public ConsumerPscConfigOrBuilder getConsumerPscConfigsOrBuilder(int index) {
            if (this.consumerPscConfigsBuilder_ == null) {
                return this.consumerPscConfigs_.get(index);
            }
            return (ConsumerPscConfigOrBuilder)this.consumerPscConfigsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ConsumerPscConfigOrBuilder> getConsumerPscConfigsOrBuilderList() {
            if (this.consumerPscConfigsBuilder_ != null) {
                return this.consumerPscConfigsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.consumerPscConfigs_);
        }

        public ConsumerPscConfig.Builder addConsumerPscConfigsBuilder() {
            return (ConsumerPscConfig.Builder)this.getConsumerPscConfigsFieldBuilder().addBuilder((AbstractMessage)ConsumerPscConfig.getDefaultInstance());
        }

        public ConsumerPscConfig.Builder addConsumerPscConfigsBuilder(int index) {
            return (ConsumerPscConfig.Builder)this.getConsumerPscConfigsFieldBuilder().addBuilder(index, (AbstractMessage)ConsumerPscConfig.getDefaultInstance());
        }

        public List<ConsumerPscConfig.Builder> getConsumerPscConfigsBuilderList() {
            return this.getConsumerPscConfigsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ConsumerPscConfig, ConsumerPscConfig.Builder, ConsumerPscConfigOrBuilder> getConsumerPscConfigsFieldBuilder() {
            if (this.consumerPscConfigsBuilder_ == null) {
                this.consumerPscConfigsBuilder_ = new RepeatedFieldBuilderV3(this.consumerPscConfigs_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.consumerPscConfigs_ = null;
            }
            return this.consumerPscConfigsBuilder_;
        }

        private void ensureConsumerPscConnectionsIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.consumerPscConnections_ = new ArrayList<ConsumerPscConnection>(this.consumerPscConnections_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<ConsumerPscConnection> getConsumerPscConnectionsList() {
            if (this.consumerPscConnectionsBuilder_ == null) {
                return Collections.unmodifiableList(this.consumerPscConnections_);
            }
            return this.consumerPscConnectionsBuilder_.getMessageList();
        }

        @Override
        public int getConsumerPscConnectionsCount() {
            if (this.consumerPscConnectionsBuilder_ == null) {
                return this.consumerPscConnections_.size();
            }
            return this.consumerPscConnectionsBuilder_.getCount();
        }

        @Override
        public ConsumerPscConnection getConsumerPscConnections(int index) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                return this.consumerPscConnections_.get(index);
            }
            return (ConsumerPscConnection)this.consumerPscConnectionsBuilder_.getMessage(index);
        }

        public Builder setConsumerPscConnections(int index, ConsumerPscConnection value) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.set(index, value);
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setConsumerPscConnections(int index, ConsumerPscConnection.Builder builderForValue) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addConsumerPscConnections(ConsumerPscConnection value) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.add(value);
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addConsumerPscConnections(int index, ConsumerPscConnection value) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.add(index, value);
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addConsumerPscConnections(ConsumerPscConnection.Builder builderForValue) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addConsumerPscConnections(int index, ConsumerPscConnection.Builder builderForValue) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllConsumerPscConnections(Iterable<? extends ConsumerPscConnection> values) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.ensureConsumerPscConnectionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.consumerPscConnections_);
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearConsumerPscConnections() {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.consumerPscConnections_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.clear();
            }
            return this;
        }

        public Builder removeConsumerPscConnections(int index) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.ensureConsumerPscConnectionsIsMutable();
                this.consumerPscConnections_.remove(index);
                this.onChanged();
            } else {
                this.consumerPscConnectionsBuilder_.remove(index);
            }
            return this;
        }

        public ConsumerPscConnection.Builder getConsumerPscConnectionsBuilder(int index) {
            return (ConsumerPscConnection.Builder)this.getConsumerPscConnectionsFieldBuilder().getBuilder(index);
        }

        @Override
        public ConsumerPscConnectionOrBuilder getConsumerPscConnectionsOrBuilder(int index) {
            if (this.consumerPscConnectionsBuilder_ == null) {
                return this.consumerPscConnections_.get(index);
            }
            return (ConsumerPscConnectionOrBuilder)this.consumerPscConnectionsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ConsumerPscConnectionOrBuilder> getConsumerPscConnectionsOrBuilderList() {
            if (this.consumerPscConnectionsBuilder_ != null) {
                return this.consumerPscConnectionsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.consumerPscConnections_);
        }

        public ConsumerPscConnection.Builder addConsumerPscConnectionsBuilder() {
            return (ConsumerPscConnection.Builder)this.getConsumerPscConnectionsFieldBuilder().addBuilder((AbstractMessage)ConsumerPscConnection.getDefaultInstance());
        }

        public ConsumerPscConnection.Builder addConsumerPscConnectionsBuilder(int index) {
            return (ConsumerPscConnection.Builder)this.getConsumerPscConnectionsFieldBuilder().addBuilder(index, (AbstractMessage)ConsumerPscConnection.getDefaultInstance());
        }

        public List<ConsumerPscConnection.Builder> getConsumerPscConnectionsBuilderList() {
            return this.getConsumerPscConnectionsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ConsumerPscConnection, ConsumerPscConnection.Builder, ConsumerPscConnectionOrBuilder> getConsumerPscConnectionsFieldBuilder() {
            if (this.consumerPscConnectionsBuilder_ == null) {
                this.consumerPscConnectionsBuilder_ = new RepeatedFieldBuilderV3(this.consumerPscConnections_, (this.bitField0_ & 0x400) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.consumerPscConnections_ = null;
            }
            return this.consumerPscConnectionsBuilder_;
        }

        @Override
        public String getToken() {
            Object ref = this.token_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.token_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTokenBytes() {
            Object ref = this.token_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.token_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.token_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearToken() {
            this.token_ = ServiceConnectionMap.getDefaultInstance().getToken();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConnectionMap.checkByteStringIsUtf8((ByteString)value);
            this.token_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEtag() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public String getEtag() {
            Object ref = this.etag_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.etag_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEtagBytes() {
            Object ref = this.etag_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.etag_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEtag(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.etag_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearEtag() {
            this.etag_ = ServiceConnectionMap.getDefaultInstance().getEtag();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setEtagBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ServiceConnectionMap.checkByteStringIsUtf8((ByteString)value);
            this.etag_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static final class ConsumerPscConnection
    extends GeneratedMessageV3
    implements ConsumerPscConnectionOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int SERVICE_ATTACHMENT_URI_FIELD_NUMBER = 1;
        private volatile Object serviceAttachmentUri_ = "";
        public static final int STATE_FIELD_NUMBER = 2;
        private int state_ = 0;
        public static final int PROJECT_FIELD_NUMBER = 3;
        private volatile Object project_ = "";
        public static final int NETWORK_FIELD_NUMBER = 4;
        private volatile Object network_ = "";
        public static final int PSC_CONNECTION_ID_FIELD_NUMBER = 5;
        private volatile Object pscConnectionId_ = "";
        public static final int IP_FIELD_NUMBER = 6;
        private volatile Object ip_ = "";
        public static final int ERROR_TYPE_FIELD_NUMBER = 7;
        private int errorType_ = 0;
        public static final int ERROR_FIELD_NUMBER = 8;
        private Status error_;
        public static final int GCE_OPERATION_FIELD_NUMBER = 9;
        private volatile Object gceOperation_ = "";
        public static final int FORWARDING_RULE_FIELD_NUMBER = 10;
        private volatile Object forwardingRule_ = "";
        public static final int ERROR_INFO_FIELD_NUMBER = 11;
        private ErrorInfo errorInfo_;
        public static final int SELECTED_SUBNETWORK_FIELD_NUMBER = 12;
        private volatile Object selectedSubnetwork_ = "";
        public static final int PRODUCER_INSTANCE_ID_FIELD_NUMBER = 13;
        private volatile Object producerInstanceId_ = "";
        public static final int PRODUCER_INSTANCE_METADATA_FIELD_NUMBER = 14;
        private MapField<String, String> producerInstanceMetadata_;
        public static final int IP_VERSION_FIELD_NUMBER = 15;
        private int ipVersion_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ConsumerPscConnection DEFAULT_INSTANCE = new ConsumerPscConnection();
        private static final Parser<ConsumerPscConnection> PARSER = new AbstractParser<ConsumerPscConnection>(){

            public ConsumerPscConnection parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ConsumerPscConnection.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ConsumerPscConnection(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ConsumerPscConnection() {
            this.serviceAttachmentUri_ = "";
            this.state_ = 0;
            this.project_ = "";
            this.network_ = "";
            this.pscConnectionId_ = "";
            this.ip_ = "";
            this.errorType_ = 0;
            this.gceOperation_ = "";
            this.forwardingRule_ = "";
            this.selectedSubnetwork_ = "";
            this.producerInstanceId_ = "";
            this.ipVersion_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ConsumerPscConnection();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConnection_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 14: {
                    return this.internalGetProducerInstanceMetadata();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConnection_fieldAccessorTable.ensureFieldAccessorsInitialized(ConsumerPscConnection.class, Builder.class);
        }

        @Override
        public String getServiceAttachmentUri() {
            Object ref = this.serviceAttachmentUri_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.serviceAttachmentUri_ = s;
            return s;
        }

        @Override
        public ByteString getServiceAttachmentUriBytes() {
            Object ref = this.serviceAttachmentUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAttachmentUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        @Override
        public String getProject() {
            Object ref = this.project_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.project_ = s;
            return s;
        }

        @Override
        public ByteString getProjectBytes() {
            Object ref = this.project_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.project_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getNetwork() {
            Object ref = this.network_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.network_ = s;
            return s;
        }

        @Override
        public ByteString getNetworkBytes() {
            Object ref = this.network_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.network_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getPscConnectionId() {
            Object ref = this.pscConnectionId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.pscConnectionId_ = s;
            return s;
        }

        @Override
        public ByteString getPscConnectionIdBytes() {
            Object ref = this.pscConnectionId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.pscConnectionId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getIp() {
            Object ref = this.ip_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.ip_ = s;
            return s;
        }

        @Override
        public ByteString getIpBytes() {
            Object ref = this.ip_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.ip_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        @Deprecated
        public int getErrorTypeValue() {
            return this.errorType_;
        }

        @Override
        @Deprecated
        public ConnectionErrorType getErrorType() {
            ConnectionErrorType result = ConnectionErrorType.forNumber(this.errorType_);
            return result == null ? ConnectionErrorType.UNRECOGNIZED : result;
        }

        @Override
        @Deprecated
        public boolean hasError() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        @Deprecated
        public Status getError() {
            return this.error_ == null ? Status.getDefaultInstance() : this.error_;
        }

        @Override
        @Deprecated
        public StatusOrBuilder getErrorOrBuilder() {
            return this.error_ == null ? Status.getDefaultInstance() : this.error_;
        }

        @Override
        public String getGceOperation() {
            Object ref = this.gceOperation_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.gceOperation_ = s;
            return s;
        }

        @Override
        public ByteString getGceOperationBytes() {
            Object ref = this.gceOperation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.gceOperation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getForwardingRule() {
            Object ref = this.forwardingRule_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.forwardingRule_ = s;
            return s;
        }

        @Override
        public ByteString getForwardingRuleBytes() {
            Object ref = this.forwardingRule_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.forwardingRule_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasErrorInfo() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public ErrorInfo getErrorInfo() {
            return this.errorInfo_ == null ? ErrorInfo.getDefaultInstance() : this.errorInfo_;
        }

        @Override
        public ErrorInfoOrBuilder getErrorInfoOrBuilder() {
            return this.errorInfo_ == null ? ErrorInfo.getDefaultInstance() : this.errorInfo_;
        }

        @Override
        public String getSelectedSubnetwork() {
            Object ref = this.selectedSubnetwork_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.selectedSubnetwork_ = s;
            return s;
        }

        @Override
        public ByteString getSelectedSubnetworkBytes() {
            Object ref = this.selectedSubnetwork_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.selectedSubnetwork_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        @Deprecated
        public String getProducerInstanceId() {
            Object ref = this.producerInstanceId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.producerInstanceId_ = s;
            return s;
        }

        @Override
        @Deprecated
        public ByteString getProducerInstanceIdBytes() {
            Object ref = this.producerInstanceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.producerInstanceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        private MapField<String, String> internalGetProducerInstanceMetadata() {
            if (this.producerInstanceMetadata_ == null) {
                return MapField.emptyMapField(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry);
            }
            return this.producerInstanceMetadata_;
        }

        @Override
        public int getProducerInstanceMetadataCount() {
            return this.internalGetProducerInstanceMetadata().getMap().size();
        }

        @Override
        public boolean containsProducerInstanceMetadata(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetProducerInstanceMetadata().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getProducerInstanceMetadata() {
            return this.getProducerInstanceMetadataMap();
        }

        @Override
        public Map<String, String> getProducerInstanceMetadataMap() {
            return this.internalGetProducerInstanceMetadata().getMap();
        }

        @Override
        public String getProducerInstanceMetadataOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetProducerInstanceMetadata().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getProducerInstanceMetadataOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetProducerInstanceMetadata().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        @Override
        public boolean hasIpVersion() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public int getIpVersionValue() {
            return this.ipVersion_;
        }

        @Override
        public IPVersion getIpVersion() {
            IPVersion result = IPVersion.forNumber(this.ipVersion_);
            return result == null ? IPVersion.UNRECOGNIZED : result;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAttachmentUri_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.serviceAttachmentUri_);
            }
            if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
                output.writeEnum(2, this.state_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.project_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.project_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.network_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.network_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.pscConnectionId_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.pscConnectionId_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.ip_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.ip_);
            }
            if (this.errorType_ != ConnectionErrorType.CONNECTION_ERROR_TYPE_UNSPECIFIED.getNumber()) {
                output.writeEnum(7, this.errorType_);
            }
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(8, (MessageLite)this.getError());
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.gceOperation_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.gceOperation_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.forwardingRule_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.forwardingRule_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeMessage(11, (MessageLite)this.getErrorInfo());
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.selectedSubnetwork_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.selectedSubnetwork_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.producerInstanceId_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.producerInstanceId_);
            }
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetProducerInstanceMetadata(), ProducerInstanceMetadataDefaultEntryHolder.defaultEntry, (int)14);
            if ((this.bitField0_ & 4) != 0) {
                output.writeEnum(15, this.ipVersion_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAttachmentUri_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.serviceAttachmentUri_);
            }
            if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)2, (int)this.state_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.project_)) {
                size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.project_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.network_)) {
                size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.network_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.pscConnectionId_)) {
                size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.pscConnectionId_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.ip_)) {
                size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.ip_);
            }
            if (this.errorType_ != ConnectionErrorType.CONNECTION_ERROR_TYPE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)7, (int)this.errorType_);
            }
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getError());
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.gceOperation_)) {
                size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.gceOperation_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.forwardingRule_)) {
                size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.forwardingRule_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getErrorInfo());
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.selectedSubnetwork_)) {
                size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.selectedSubnetwork_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.producerInstanceId_)) {
                size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.producerInstanceId_);
            }
            for (Map.Entry entry : this.internalGetProducerInstanceMetadata().getMap().entrySet()) {
                MapEntry producerInstanceMetadata__ = ProducerInstanceMetadataDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)producerInstanceMetadata__);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeEnumSize((int)15, (int)this.ipVersion_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConsumerPscConnection)) {
                return super.equals(obj);
            }
            ConsumerPscConnection other = (ConsumerPscConnection)obj;
            if (!this.getServiceAttachmentUri().equals(other.getServiceAttachmentUri())) {
                return false;
            }
            if (this.state_ != other.state_) {
                return false;
            }
            if (!this.getProject().equals(other.getProject())) {
                return false;
            }
            if (!this.getNetwork().equals(other.getNetwork())) {
                return false;
            }
            if (!this.getPscConnectionId().equals(other.getPscConnectionId())) {
                return false;
            }
            if (!this.getIp().equals(other.getIp())) {
                return false;
            }
            if (this.errorType_ != other.errorType_) {
                return false;
            }
            if (this.hasError() != other.hasError()) {
                return false;
            }
            if (this.hasError() && !this.getError().equals((Object)other.getError())) {
                return false;
            }
            if (!this.getGceOperation().equals(other.getGceOperation())) {
                return false;
            }
            if (!this.getForwardingRule().equals(other.getForwardingRule())) {
                return false;
            }
            if (this.hasErrorInfo() != other.hasErrorInfo()) {
                return false;
            }
            if (this.hasErrorInfo() && !this.getErrorInfo().equals((Object)other.getErrorInfo())) {
                return false;
            }
            if (!this.getSelectedSubnetwork().equals(other.getSelectedSubnetwork())) {
                return false;
            }
            if (!this.getProducerInstanceId().equals(other.getProducerInstanceId())) {
                return false;
            }
            if (!this.internalGetProducerInstanceMetadata().equals(other.internalGetProducerInstanceMetadata())) {
                return false;
            }
            if (this.hasIpVersion() != other.hasIpVersion()) {
                return false;
            }
            if (this.hasIpVersion() && this.ipVersion_ != other.ipVersion_) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ConsumerPscConnection.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getServiceAttachmentUri().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.state_;
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getProject().hashCode();
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getNetwork().hashCode();
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPscConnectionId().hashCode();
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getIp().hashCode();
            hash = 37 * hash + 7;
            hash = 53 * hash + this.errorType_;
            if (this.hasError()) {
                hash = 37 * hash + 8;
                hash = 53 * hash + this.getError().hashCode();
            }
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getGceOperation().hashCode();
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getForwardingRule().hashCode();
            if (this.hasErrorInfo()) {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getErrorInfo().hashCode();
            }
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getSelectedSubnetwork().hashCode();
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getProducerInstanceId().hashCode();
            if (!this.internalGetProducerInstanceMetadata().getMap().isEmpty()) {
                hash = 37 * hash + 14;
                hash = 53 * hash + this.internalGetProducerInstanceMetadata().hashCode();
            }
            if (this.hasIpVersion()) {
                hash = 37 * hash + 15;
                hash = 53 * hash + this.ipVersion_;
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ConsumerPscConnection parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (ConsumerPscConnection)PARSER.parseFrom(data);
        }

        public static ConsumerPscConnection parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ConsumerPscConnection)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ConsumerPscConnection parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (ConsumerPscConnection)PARSER.parseFrom(data);
        }

        public static ConsumerPscConnection parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ConsumerPscConnection)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ConsumerPscConnection parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (ConsumerPscConnection)PARSER.parseFrom(data);
        }

        public static ConsumerPscConnection parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ConsumerPscConnection)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ConsumerPscConnection parseFrom(InputStream input) throws IOException {
            return (ConsumerPscConnection)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static ConsumerPscConnection parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ConsumerPscConnection)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ConsumerPscConnection parseDelimitedFrom(InputStream input) throws IOException {
            return (ConsumerPscConnection)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static ConsumerPscConnection parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ConsumerPscConnection)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ConsumerPscConnection parseFrom(CodedInputStream input) throws IOException {
            return (ConsumerPscConnection)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static ConsumerPscConnection parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ConsumerPscConnection)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return ConsumerPscConnection.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ConsumerPscConnection prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ConsumerPscConnection getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ConsumerPscConnection> parser() {
            return PARSER;
        }

        public Parser<ConsumerPscConnection> getParserForType() {
            return PARSER;
        }

        public ConsumerPscConnection getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ConsumerPscConnectionOrBuilder {
            private int bitField0_;
            private Object serviceAttachmentUri_ = "";
            private int state_ = 0;
            private Object project_ = "";
            private Object network_ = "";
            private Object pscConnectionId_ = "";
            private Object ip_ = "";
            private int errorType_ = 0;
            private Status error_;
            private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> errorBuilder_;
            private Object gceOperation_ = "";
            private Object forwardingRule_ = "";
            private ErrorInfo errorInfo_;
            private SingleFieldBuilderV3<ErrorInfo, ErrorInfo.Builder, ErrorInfoOrBuilder> errorInfoBuilder_;
            private Object selectedSubnetwork_ = "";
            private Object producerInstanceId_ = "";
            private MapField<String, String> producerInstanceMetadata_;
            private int ipVersion_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConnection_descriptor;
            }

            protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
                switch (number) {
                    case 14: {
                        return this.internalGetProducerInstanceMetadata();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
                switch (number) {
                    case 14: {
                        return this.internalGetMutableProducerInstanceMetadata();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConnection_fieldAccessorTable.ensureFieldAccessorsInitialized(ConsumerPscConnection.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getErrorFieldBuilder();
                    this.getErrorInfoFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.serviceAttachmentUri_ = "";
                this.state_ = 0;
                this.project_ = "";
                this.network_ = "";
                this.pscConnectionId_ = "";
                this.ip_ = "";
                this.errorType_ = 0;
                this.error_ = null;
                if (this.errorBuilder_ != null) {
                    this.errorBuilder_.dispose();
                    this.errorBuilder_ = null;
                }
                this.gceOperation_ = "";
                this.forwardingRule_ = "";
                this.errorInfo_ = null;
                if (this.errorInfoBuilder_ != null) {
                    this.errorInfoBuilder_.dispose();
                    this.errorInfoBuilder_ = null;
                }
                this.selectedSubnetwork_ = "";
                this.producerInstanceId_ = "";
                this.internalGetMutableProducerInstanceMetadata().clear();
                this.ipVersion_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConnection_descriptor;
            }

            public ConsumerPscConnection getDefaultInstanceForType() {
                return ConsumerPscConnection.getDefaultInstance();
            }

            public ConsumerPscConnection build() {
                ConsumerPscConnection result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public ConsumerPscConnection buildPartial() {
                ConsumerPscConnection result = new ConsumerPscConnection(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ConsumerPscConnection result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.serviceAttachmentUri_ = this.serviceAttachmentUri_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.state_ = this.state_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.project_ = this.project_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.network_ = this.network_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.pscConnectionId_ = this.pscConnectionId_;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.ip_ = this.ip_;
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    result.errorType_ = this.errorType_;
                }
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 0x80) != 0) {
                    result.error_ = this.errorBuilder_ == null ? this.error_ : (Status)this.errorBuilder_.build();
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 0x100) != 0) {
                    result.gceOperation_ = this.gceOperation_;
                }
                if ((from_bitField0_ & 0x200) != 0) {
                    result.forwardingRule_ = this.forwardingRule_;
                }
                if ((from_bitField0_ & 0x400) != 0) {
                    result.errorInfo_ = this.errorInfoBuilder_ == null ? this.errorInfo_ : (ErrorInfo)this.errorInfoBuilder_.build();
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 0x800) != 0) {
                    result.selectedSubnetwork_ = this.selectedSubnetwork_;
                }
                if ((from_bitField0_ & 0x1000) != 0) {
                    result.producerInstanceId_ = this.producerInstanceId_;
                }
                if ((from_bitField0_ & 0x2000) != 0) {
                    result.producerInstanceMetadata_ = this.internalGetProducerInstanceMetadata();
                    result.producerInstanceMetadata_.makeImmutable();
                }
                if ((from_bitField0_ & 0x4000) != 0) {
                    result.ipVersion_ = this.ipVersion_;
                    to_bitField0_ |= 4;
                }
                ConsumerPscConnection consumerPscConnection = result;
                consumerPscConnection.bitField0_ = consumerPscConnection.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof ConsumerPscConnection) {
                    return this.mergeFrom((ConsumerPscConnection)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ConsumerPscConnection other) {
                if (other == ConsumerPscConnection.getDefaultInstance()) {
                    return this;
                }
                if (!other.getServiceAttachmentUri().isEmpty()) {
                    this.serviceAttachmentUri_ = other.serviceAttachmentUri_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.state_ != 0) {
                    this.setStateValue(other.getStateValue());
                }
                if (!other.getProject().isEmpty()) {
                    this.project_ = other.project_;
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                if (!other.getNetwork().isEmpty()) {
                    this.network_ = other.network_;
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                if (!other.getPscConnectionId().isEmpty()) {
                    this.pscConnectionId_ = other.pscConnectionId_;
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                }
                if (!other.getIp().isEmpty()) {
                    this.ip_ = other.ip_;
                    this.bitField0_ |= 0x20;
                    this.onChanged();
                }
                if (other.errorType_ != 0) {
                    this.setErrorTypeValue(other.getErrorTypeValue());
                }
                if (other.hasError()) {
                    this.mergeError(other.getError());
                }
                if (!other.getGceOperation().isEmpty()) {
                    this.gceOperation_ = other.gceOperation_;
                    this.bitField0_ |= 0x100;
                    this.onChanged();
                }
                if (!other.getForwardingRule().isEmpty()) {
                    this.forwardingRule_ = other.forwardingRule_;
                    this.bitField0_ |= 0x200;
                    this.onChanged();
                }
                if (other.hasErrorInfo()) {
                    this.mergeErrorInfo(other.getErrorInfo());
                }
                if (!other.getSelectedSubnetwork().isEmpty()) {
                    this.selectedSubnetwork_ = other.selectedSubnetwork_;
                    this.bitField0_ |= 0x800;
                    this.onChanged();
                }
                if (!other.getProducerInstanceId().isEmpty()) {
                    this.producerInstanceId_ = other.producerInstanceId_;
                    this.bitField0_ |= 0x1000;
                    this.onChanged();
                }
                this.internalGetMutableProducerInstanceMetadata().mergeFrom(other.internalGetProducerInstanceMetadata());
                this.bitField0_ |= 0x2000;
                if (other.hasIpVersion()) {
                    this.setIpVersion(other.getIpVersion());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block23: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block23;
                            }
                            case 10: {
                                this.serviceAttachmentUri_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block23;
                            }
                            case 16: {
                                this.state_ = input.readEnum();
                                this.bitField0_ |= 2;
                                continue block23;
                            }
                            case 26: {
                                this.project_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 4;
                                continue block23;
                            }
                            case 34: {
                                this.network_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 8;
                                continue block23;
                            }
                            case 42: {
                                this.pscConnectionId_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x10;
                                continue block23;
                            }
                            case 50: {
                                this.ip_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x20;
                                continue block23;
                            }
                            case 56: {
                                this.errorType_ = input.readEnum();
                                this.bitField0_ |= 0x40;
                                continue block23;
                            }
                            case 66: {
                                input.readMessage((MessageLite.Builder)this.getErrorFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x80;
                                continue block23;
                            }
                            case 74: {
                                this.gceOperation_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x100;
                                continue block23;
                            }
                            case 82: {
                                this.forwardingRule_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x200;
                                continue block23;
                            }
                            case 90: {
                                input.readMessage((MessageLite.Builder)this.getErrorInfoFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x400;
                                continue block23;
                            }
                            case 98: {
                                this.selectedSubnetwork_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x800;
                                continue block23;
                            }
                            case 106: {
                                this.producerInstanceId_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x1000;
                                continue block23;
                            }
                            case 114: {
                                MapEntry producerInstanceMetadata__ = (MapEntry)input.readMessage(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableProducerInstanceMetadata().getMutableMap().put(producerInstanceMetadata__.getKey(), producerInstanceMetadata__.getValue());
                                this.bitField0_ |= 0x2000;
                                continue block23;
                            }
                            case 120: {
                                this.ipVersion_ = input.readEnum();
                                this.bitField0_ |= 0x4000;
                                continue block23;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getServiceAttachmentUri() {
                Object ref = this.serviceAttachmentUri_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.serviceAttachmentUri_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getServiceAttachmentUriBytes() {
                Object ref = this.serviceAttachmentUri_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.serviceAttachmentUri_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setServiceAttachmentUri(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.serviceAttachmentUri_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearServiceAttachmentUri() {
                this.serviceAttachmentUri_ = ConsumerPscConnection.getDefaultInstance().getServiceAttachmentUri();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setServiceAttachmentUriBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.serviceAttachmentUri_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public int getStateValue() {
                return this.state_;
            }

            public Builder setStateValue(int value) {
                this.state_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public State getState() {
                State result = State.forNumber(this.state_);
                return result == null ? State.UNRECOGNIZED : result;
            }

            public Builder setState(State value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 2;
                this.state_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearState() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.state_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public String getProject() {
                Object ref = this.project_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.project_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getProjectBytes() {
                Object ref = this.project_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.project_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setProject(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.project_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearProject() {
                this.project_ = ConsumerPscConnection.getDefaultInstance().getProject();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder setProjectBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.project_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            @Override
            public String getNetwork() {
                Object ref = this.network_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.network_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNetworkBytes() {
                Object ref = this.network_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.network_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setNetwork(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.network_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearNetwork() {
                this.network_ = ConsumerPscConnection.getDefaultInstance().getNetwork();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder setNetworkBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.network_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            @Override
            public String getPscConnectionId() {
                Object ref = this.pscConnectionId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.pscConnectionId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getPscConnectionIdBytes() {
                Object ref = this.pscConnectionId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.pscConnectionId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setPscConnectionId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.pscConnectionId_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearPscConnectionId() {
                this.pscConnectionId_ = ConsumerPscConnection.getDefaultInstance().getPscConnectionId();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
                return this;
            }

            public Builder setPscConnectionIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.pscConnectionId_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            @Override
            public String getIp() {
                Object ref = this.ip_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.ip_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getIpBytes() {
                Object ref = this.ip_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.ip_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setIp(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ip_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearIp() {
                this.ip_ = ConsumerPscConnection.getDefaultInstance().getIp();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
                return this;
            }

            public Builder setIpBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.ip_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            @Override
            @Deprecated
            public int getErrorTypeValue() {
                return this.errorType_;
            }

            @Deprecated
            public Builder setErrorTypeValue(int value) {
                this.errorType_ = value;
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            @Override
            @Deprecated
            public ConnectionErrorType getErrorType() {
                ConnectionErrorType result = ConnectionErrorType.forNumber(this.errorType_);
                return result == null ? ConnectionErrorType.UNRECOGNIZED : result;
            }

            @Deprecated
            public Builder setErrorType(ConnectionErrorType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 0x40;
                this.errorType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder clearErrorType() {
                this.bitField0_ &= 0xFFFFFFBF;
                this.errorType_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            @Deprecated
            public boolean hasError() {
                return (this.bitField0_ & 0x80) != 0;
            }

            @Override
            @Deprecated
            public Status getError() {
                if (this.errorBuilder_ == null) {
                    return this.error_ == null ? Status.getDefaultInstance() : this.error_;
                }
                return (Status)this.errorBuilder_.getMessage();
            }

            @Deprecated
            public Builder setError(Status value) {
                if (this.errorBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.error_ = value;
                } else {
                    this.errorBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder setError(Status.Builder builderForValue) {
                if (this.errorBuilder_ == null) {
                    this.error_ = builderForValue.build();
                } else {
                    this.errorBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder mergeError(Status value) {
                if (this.errorBuilder_ == null) {
                    if ((this.bitField0_ & 0x80) != 0 && this.error_ != null && this.error_ != Status.getDefaultInstance()) {
                        this.getErrorBuilder().mergeFrom(value);
                    } else {
                        this.error_ = value;
                    }
                } else {
                    this.errorBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.error_ != null) {
                    this.bitField0_ |= 0x80;
                    this.onChanged();
                }
                return this;
            }

            @Deprecated
            public Builder clearError() {
                this.bitField0_ &= 0xFFFFFF7F;
                this.error_ = null;
                if (this.errorBuilder_ != null) {
                    this.errorBuilder_.dispose();
                    this.errorBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            @Deprecated
            public Status.Builder getErrorBuilder() {
                this.bitField0_ |= 0x80;
                this.onChanged();
                return (Status.Builder)this.getErrorFieldBuilder().getBuilder();
            }

            @Override
            @Deprecated
            public StatusOrBuilder getErrorOrBuilder() {
                if (this.errorBuilder_ != null) {
                    return (StatusOrBuilder)this.errorBuilder_.getMessageOrBuilder();
                }
                return this.error_ == null ? Status.getDefaultInstance() : this.error_;
            }

            private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> getErrorFieldBuilder() {
                if (this.errorBuilder_ == null) {
                    this.errorBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getError(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.error_ = null;
                }
                return this.errorBuilder_;
            }

            @Override
            public String getGceOperation() {
                Object ref = this.gceOperation_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.gceOperation_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getGceOperationBytes() {
                Object ref = this.gceOperation_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.gceOperation_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setGceOperation(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.gceOperation_ = value;
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder clearGceOperation() {
                this.gceOperation_ = ConsumerPscConnection.getDefaultInstance().getGceOperation();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
                return this;
            }

            public Builder setGceOperationBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.gceOperation_ = value;
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            @Override
            public String getForwardingRule() {
                Object ref = this.forwardingRule_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.forwardingRule_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getForwardingRuleBytes() {
                Object ref = this.forwardingRule_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.forwardingRule_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setForwardingRule(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.forwardingRule_ = value;
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder clearForwardingRule() {
                this.forwardingRule_ = ConsumerPscConnection.getDefaultInstance().getForwardingRule();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
                return this;
            }

            public Builder setForwardingRuleBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.forwardingRule_ = value;
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasErrorInfo() {
                return (this.bitField0_ & 0x400) != 0;
            }

            @Override
            public ErrorInfo getErrorInfo() {
                if (this.errorInfoBuilder_ == null) {
                    return this.errorInfo_ == null ? ErrorInfo.getDefaultInstance() : this.errorInfo_;
                }
                return (ErrorInfo)this.errorInfoBuilder_.getMessage();
            }

            public Builder setErrorInfo(ErrorInfo value) {
                if (this.errorInfoBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.errorInfo_ = value;
                } else {
                    this.errorInfoBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            public Builder setErrorInfo(ErrorInfo.Builder builderForValue) {
                if (this.errorInfoBuilder_ == null) {
                    this.errorInfo_ = builderForValue.build();
                } else {
                    this.errorInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            public Builder mergeErrorInfo(ErrorInfo value) {
                if (this.errorInfoBuilder_ == null) {
                    if ((this.bitField0_ & 0x400) != 0 && this.errorInfo_ != null && this.errorInfo_ != ErrorInfo.getDefaultInstance()) {
                        this.getErrorInfoBuilder().mergeFrom(value);
                    } else {
                        this.errorInfo_ = value;
                    }
                } else {
                    this.errorInfoBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.errorInfo_ != null) {
                    this.bitField0_ |= 0x400;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearErrorInfo() {
                this.bitField0_ &= 0xFFFFFBFF;
                this.errorInfo_ = null;
                if (this.errorInfoBuilder_ != null) {
                    this.errorInfoBuilder_.dispose();
                    this.errorInfoBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public ErrorInfo.Builder getErrorInfoBuilder() {
                this.bitField0_ |= 0x400;
                this.onChanged();
                return (ErrorInfo.Builder)this.getErrorInfoFieldBuilder().getBuilder();
            }

            @Override
            public ErrorInfoOrBuilder getErrorInfoOrBuilder() {
                if (this.errorInfoBuilder_ != null) {
                    return (ErrorInfoOrBuilder)this.errorInfoBuilder_.getMessageOrBuilder();
                }
                return this.errorInfo_ == null ? ErrorInfo.getDefaultInstance() : this.errorInfo_;
            }

            private SingleFieldBuilderV3<ErrorInfo, ErrorInfo.Builder, ErrorInfoOrBuilder> getErrorInfoFieldBuilder() {
                if (this.errorInfoBuilder_ == null) {
                    this.errorInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getErrorInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.errorInfo_ = null;
                }
                return this.errorInfoBuilder_;
            }

            @Override
            public String getSelectedSubnetwork() {
                Object ref = this.selectedSubnetwork_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.selectedSubnetwork_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getSelectedSubnetworkBytes() {
                Object ref = this.selectedSubnetwork_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.selectedSubnetwork_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setSelectedSubnetwork(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.selectedSubnetwork_ = value;
                this.bitField0_ |= 0x800;
                this.onChanged();
                return this;
            }

            public Builder clearSelectedSubnetwork() {
                this.selectedSubnetwork_ = ConsumerPscConnection.getDefaultInstance().getSelectedSubnetwork();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
                return this;
            }

            public Builder setSelectedSubnetworkBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.selectedSubnetwork_ = value;
                this.bitField0_ |= 0x800;
                this.onChanged();
                return this;
            }

            @Override
            @Deprecated
            public String getProducerInstanceId() {
                Object ref = this.producerInstanceId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.producerInstanceId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            @Deprecated
            public ByteString getProducerInstanceIdBytes() {
                Object ref = this.producerInstanceId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.producerInstanceId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Deprecated
            public Builder setProducerInstanceId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.producerInstanceId_ = value;
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder clearProducerInstanceId() {
                this.producerInstanceId_ = ConsumerPscConnection.getDefaultInstance().getProducerInstanceId();
                this.bitField0_ &= 0xFFFFEFFF;
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder setProducerInstanceIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConnection.checkByteStringIsUtf8((ByteString)value);
                this.producerInstanceId_ = value;
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            private MapField<String, String> internalGetProducerInstanceMetadata() {
                if (this.producerInstanceMetadata_ == null) {
                    return MapField.emptyMapField(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry);
                }
                return this.producerInstanceMetadata_;
            }

            private MapField<String, String> internalGetMutableProducerInstanceMetadata() {
                if (this.producerInstanceMetadata_ == null) {
                    this.producerInstanceMetadata_ = MapField.newMapField(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry);
                }
                if (!this.producerInstanceMetadata_.isMutable()) {
                    this.producerInstanceMetadata_ = this.producerInstanceMetadata_.copy();
                }
                this.bitField0_ |= 0x2000;
                this.onChanged();
                return this.producerInstanceMetadata_;
            }

            @Override
            public int getProducerInstanceMetadataCount() {
                return this.internalGetProducerInstanceMetadata().getMap().size();
            }

            @Override
            public boolean containsProducerInstanceMetadata(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetProducerInstanceMetadata().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, String> getProducerInstanceMetadata() {
                return this.getProducerInstanceMetadataMap();
            }

            @Override
            public Map<String, String> getProducerInstanceMetadataMap() {
                return this.internalGetProducerInstanceMetadata().getMap();
            }

            @Override
            public String getProducerInstanceMetadataOrDefault(String key, String defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetProducerInstanceMetadata().getMap();
                return map.containsKey(key) ? (String)map.get(key) : defaultValue;
            }

            @Override
            public String getProducerInstanceMetadataOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetProducerInstanceMetadata().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return (String)map.get(key);
            }

            public Builder clearProducerInstanceMetadata() {
                this.bitField0_ &= 0xFFFFDFFF;
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().clear();
                return this;
            }

            public Builder removeProducerInstanceMetadata(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, String> getMutableProducerInstanceMetadata() {
                this.bitField0_ |= 0x2000;
                return this.internalGetMutableProducerInstanceMetadata().getMutableMap();
            }

            public Builder putProducerInstanceMetadata(String key, String value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().put(key, value);
                this.bitField0_ |= 0x2000;
                return this;
            }

            public Builder putAllProducerInstanceMetadata(Map<String, String> values) {
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().putAll(values);
                this.bitField0_ |= 0x2000;
                return this;
            }

            @Override
            public boolean hasIpVersion() {
                return (this.bitField0_ & 0x4000) != 0;
            }

            @Override
            public int getIpVersionValue() {
                return this.ipVersion_;
            }

            public Builder setIpVersionValue(int value) {
                this.ipVersion_ = value;
                this.bitField0_ |= 0x4000;
                this.onChanged();
                return this;
            }

            @Override
            public IPVersion getIpVersion() {
                IPVersion result = IPVersion.forNumber(this.ipVersion_);
                return result == null ? IPVersion.UNRECOGNIZED : result;
            }

            public Builder setIpVersion(IPVersion value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 0x4000;
                this.ipVersion_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearIpVersion() {
                this.bitField0_ &= 0xFFFFBFFF;
                this.ipVersion_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        private static final class ProducerInstanceMetadataDefaultEntryHolder {
            static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConnection_ProducerInstanceMetadataEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

            private ProducerInstanceMetadataDefaultEntryHolder() {
            }
        }

        public static enum State implements ProtocolMessageEnum
        {
            STATE_UNSPECIFIED(0),
            ACTIVE(1),
            FAILED(2),
            CREATING(3),
            DELETING(4),
            CREATE_REPAIRING(5),
            DELETE_REPAIRING(6),
            UNRECOGNIZED(-1);

            public static final int STATE_UNSPECIFIED_VALUE = 0;
            public static final int ACTIVE_VALUE = 1;
            public static final int FAILED_VALUE = 2;
            public static final int CREATING_VALUE = 3;
            public static final int DELETING_VALUE = 4;
            public static final int CREATE_REPAIRING_VALUE = 5;
            public static final int DELETE_REPAIRING_VALUE = 6;
            private static final Internal.EnumLiteMap<State> internalValueMap;
            private static final State[] VALUES;
            private final int value;

            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static State valueOf(int value) {
                return State.forNumber(value);
            }

            public static State forNumber(int value) {
                switch (value) {
                    case 0: {
                        return STATE_UNSPECIFIED;
                    }
                    case 1: {
                        return ACTIVE;
                    }
                    case 2: {
                        return FAILED;
                    }
                    case 3: {
                        return CREATING;
                    }
                    case 4: {
                        return DELETING;
                    }
                    case 5: {
                        return CREATE_REPAIRING;
                    }
                    case 6: {
                        return DELETE_REPAIRING;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<State> internalGetValueMap() {
                return internalValueMap;
            }

            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
            }

            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return State.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return (Descriptors.EnumDescriptor)ConsumerPscConnection.getDescriptor().getEnumTypes().get(0);
            }

            public static State valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != State.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private State(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<State>(){

                    public State findValueByNumber(int number) {
                        return State.forNumber(number);
                    }
                };
                VALUES = State.values();
            }
        }
    }

    public static interface ConsumerPscConnectionOrBuilder
    extends MessageOrBuilder {
        public String getServiceAttachmentUri();

        public ByteString getServiceAttachmentUriBytes();

        public int getStateValue();

        public ConsumerPscConnection.State getState();

        public String getProject();

        public ByteString getProjectBytes();

        public String getNetwork();

        public ByteString getNetworkBytes();

        public String getPscConnectionId();

        public ByteString getPscConnectionIdBytes();

        public String getIp();

        public ByteString getIpBytes();

        @Deprecated
        public int getErrorTypeValue();

        @Deprecated
        public ConnectionErrorType getErrorType();

        @Deprecated
        public boolean hasError();

        @Deprecated
        public Status getError();

        @Deprecated
        public StatusOrBuilder getErrorOrBuilder();

        public String getGceOperation();

        public ByteString getGceOperationBytes();

        public String getForwardingRule();

        public ByteString getForwardingRuleBytes();

        public boolean hasErrorInfo();

        public ErrorInfo getErrorInfo();

        public ErrorInfoOrBuilder getErrorInfoOrBuilder();

        public String getSelectedSubnetwork();

        public ByteString getSelectedSubnetworkBytes();

        @Deprecated
        public String getProducerInstanceId();

        @Deprecated
        public ByteString getProducerInstanceIdBytes();

        public int getProducerInstanceMetadataCount();

        public boolean containsProducerInstanceMetadata(String var1);

        @Deprecated
        public Map<String, String> getProducerInstanceMetadata();

        public Map<String, String> getProducerInstanceMetadataMap();

        public String getProducerInstanceMetadataOrDefault(String var1, String var2);

        public String getProducerInstanceMetadataOrThrow(String var1);

        public boolean hasIpVersion();

        public int getIpVersionValue();

        public IPVersion getIpVersion();
    }

    public static final class ConsumerPscConfig
    extends GeneratedMessageV3
    implements ConsumerPscConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int PROJECT_FIELD_NUMBER = 1;
        private volatile Object project_ = "";
        public static final int NETWORK_FIELD_NUMBER = 2;
        private volatile Object network_ = "";
        public static final int DISABLE_GLOBAL_ACCESS_FIELD_NUMBER = 3;
        private boolean disableGlobalAccess_ = false;
        public static final int STATE_FIELD_NUMBER = 4;
        private int state_ = 0;
        public static final int PRODUCER_INSTANCE_ID_FIELD_NUMBER = 5;
        private volatile Object producerInstanceId_ = "";
        public static final int SERVICE_ATTACHMENT_IP_ADDRESS_MAP_FIELD_NUMBER = 6;
        private MapField<String, String> serviceAttachmentIpAddressMap_;
        public static final int CONSUMER_INSTANCE_PROJECT_FIELD_NUMBER = 7;
        private volatile Object consumerInstanceProject_ = "";
        public static final int PRODUCER_INSTANCE_METADATA_FIELD_NUMBER = 8;
        private MapField<String, String> producerInstanceMetadata_;
        public static final int IP_VERSION_FIELD_NUMBER = 9;
        private int ipVersion_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ConsumerPscConfig DEFAULT_INSTANCE = new ConsumerPscConfig();
        private static final Parser<ConsumerPscConfig> PARSER = new AbstractParser<ConsumerPscConfig>(){

            public ConsumerPscConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ConsumerPscConfig.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ConsumerPscConfig(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ConsumerPscConfig() {
            this.project_ = "";
            this.network_ = "";
            this.state_ = 0;
            this.producerInstanceId_ = "";
            this.consumerInstanceProject_ = "";
            this.ipVersion_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ConsumerPscConfig();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 6: {
                    return this.internalGetServiceAttachmentIpAddressMap();
                }
                case 8: {
                    return this.internalGetProducerInstanceMetadata();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(ConsumerPscConfig.class, Builder.class);
        }

        @Override
        public String getProject() {
            Object ref = this.project_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.project_ = s;
            return s;
        }

        @Override
        public ByteString getProjectBytes() {
            Object ref = this.project_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.project_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getNetwork() {
            Object ref = this.network_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.network_ = s;
            return s;
        }

        @Override
        public ByteString getNetworkBytes() {
            Object ref = this.network_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.network_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean getDisableGlobalAccess() {
            return this.disableGlobalAccess_;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        @Override
        @Deprecated
        public String getProducerInstanceId() {
            Object ref = this.producerInstanceId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.producerInstanceId_ = s;
            return s;
        }

        @Override
        @Deprecated
        public ByteString getProducerInstanceIdBytes() {
            Object ref = this.producerInstanceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.producerInstanceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        private MapField<String, String> internalGetServiceAttachmentIpAddressMap() {
            if (this.serviceAttachmentIpAddressMap_ == null) {
                return MapField.emptyMapField(ServiceAttachmentIpAddressMapDefaultEntryHolder.defaultEntry);
            }
            return this.serviceAttachmentIpAddressMap_;
        }

        @Override
        public int getServiceAttachmentIpAddressMapCount() {
            return this.internalGetServiceAttachmentIpAddressMap().getMap().size();
        }

        @Override
        public boolean containsServiceAttachmentIpAddressMap(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetServiceAttachmentIpAddressMap().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getServiceAttachmentIpAddressMap() {
            return this.getServiceAttachmentIpAddressMapMap();
        }

        @Override
        public Map<String, String> getServiceAttachmentIpAddressMapMap() {
            return this.internalGetServiceAttachmentIpAddressMap().getMap();
        }

        @Override
        public String getServiceAttachmentIpAddressMapOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetServiceAttachmentIpAddressMap().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getServiceAttachmentIpAddressMapOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetServiceAttachmentIpAddressMap().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        @Override
        public String getConsumerInstanceProject() {
            Object ref = this.consumerInstanceProject_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.consumerInstanceProject_ = s;
            return s;
        }

        @Override
        public ByteString getConsumerInstanceProjectBytes() {
            Object ref = this.consumerInstanceProject_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.consumerInstanceProject_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        private MapField<String, String> internalGetProducerInstanceMetadata() {
            if (this.producerInstanceMetadata_ == null) {
                return MapField.emptyMapField(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry);
            }
            return this.producerInstanceMetadata_;
        }

        @Override
        public int getProducerInstanceMetadataCount() {
            return this.internalGetProducerInstanceMetadata().getMap().size();
        }

        @Override
        public boolean containsProducerInstanceMetadata(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetProducerInstanceMetadata().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getProducerInstanceMetadata() {
            return this.getProducerInstanceMetadataMap();
        }

        @Override
        public Map<String, String> getProducerInstanceMetadataMap() {
            return this.internalGetProducerInstanceMetadata().getMap();
        }

        @Override
        public String getProducerInstanceMetadataOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetProducerInstanceMetadata().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getProducerInstanceMetadataOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetProducerInstanceMetadata().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        @Override
        public boolean hasIpVersion() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getIpVersionValue() {
            return this.ipVersion_;
        }

        @Override
        public IPVersion getIpVersion() {
            IPVersion result = IPVersion.forNumber(this.ipVersion_);
            return result == null ? IPVersion.UNRECOGNIZED : result;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.project_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.project_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.network_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.network_);
            }
            if (this.disableGlobalAccess_) {
                output.writeBool(3, this.disableGlobalAccess_);
            }
            if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
                output.writeEnum(4, this.state_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.producerInstanceId_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.producerInstanceId_);
            }
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetServiceAttachmentIpAddressMap(), ServiceAttachmentIpAddressMapDefaultEntryHolder.defaultEntry, (int)6);
            if (!GeneratedMessageV3.isStringEmpty((Object)this.consumerInstanceProject_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.consumerInstanceProject_);
            }
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetProducerInstanceMetadata(), ProducerInstanceMetadataDefaultEntryHolder.defaultEntry, (int)8);
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(9, this.ipVersion_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.project_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.project_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.network_)) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.network_);
            }
            if (this.disableGlobalAccess_) {
                size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.disableGlobalAccess_);
            }
            if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)4, (int)this.state_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.producerInstanceId_)) {
                size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.producerInstanceId_);
            }
            for (Map.Entry entry : this.internalGetServiceAttachmentIpAddressMap().getMap().entrySet()) {
                MapEntry serviceAttachmentIpAddressMap__ = ServiceAttachmentIpAddressMapDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)serviceAttachmentIpAddressMap__);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.consumerInstanceProject_)) {
                size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.consumerInstanceProject_);
            }
            for (Map.Entry entry : this.internalGetProducerInstanceMetadata().getMap().entrySet()) {
                MapEntry producerInstanceMetadata__ = ProducerInstanceMetadataDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)producerInstanceMetadata__);
            }
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)9, (int)this.ipVersion_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConsumerPscConfig)) {
                return super.equals(obj);
            }
            ConsumerPscConfig other = (ConsumerPscConfig)obj;
            if (!this.getProject().equals(other.getProject())) {
                return false;
            }
            if (!this.getNetwork().equals(other.getNetwork())) {
                return false;
            }
            if (this.getDisableGlobalAccess() != other.getDisableGlobalAccess()) {
                return false;
            }
            if (this.state_ != other.state_) {
                return false;
            }
            if (!this.getProducerInstanceId().equals(other.getProducerInstanceId())) {
                return false;
            }
            if (!this.internalGetServiceAttachmentIpAddressMap().equals(other.internalGetServiceAttachmentIpAddressMap())) {
                return false;
            }
            if (!this.getConsumerInstanceProject().equals(other.getConsumerInstanceProject())) {
                return false;
            }
            if (!this.internalGetProducerInstanceMetadata().equals(other.internalGetProducerInstanceMetadata())) {
                return false;
            }
            if (this.hasIpVersion() != other.hasIpVersion()) {
                return false;
            }
            if (this.hasIpVersion() && this.ipVersion_ != other.ipVersion_) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ConsumerPscConfig.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getProject().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getNetwork().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getDisableGlobalAccess());
            hash = 37 * hash + 4;
            hash = 53 * hash + this.state_;
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getProducerInstanceId().hashCode();
            if (!this.internalGetServiceAttachmentIpAddressMap().getMap().isEmpty()) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.internalGetServiceAttachmentIpAddressMap().hashCode();
            }
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getConsumerInstanceProject().hashCode();
            if (!this.internalGetProducerInstanceMetadata().getMap().isEmpty()) {
                hash = 37 * hash + 8;
                hash = 53 * hash + this.internalGetProducerInstanceMetadata().hashCode();
            }
            if (this.hasIpVersion()) {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.ipVersion_;
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ConsumerPscConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (ConsumerPscConfig)PARSER.parseFrom(data);
        }

        public static ConsumerPscConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ConsumerPscConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ConsumerPscConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (ConsumerPscConfig)PARSER.parseFrom(data);
        }

        public static ConsumerPscConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ConsumerPscConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ConsumerPscConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (ConsumerPscConfig)PARSER.parseFrom(data);
        }

        public static ConsumerPscConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ConsumerPscConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ConsumerPscConfig parseFrom(InputStream input) throws IOException {
            return (ConsumerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static ConsumerPscConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ConsumerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ConsumerPscConfig parseDelimitedFrom(InputStream input) throws IOException {
            return (ConsumerPscConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static ConsumerPscConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ConsumerPscConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ConsumerPscConfig parseFrom(CodedInputStream input) throws IOException {
            return (ConsumerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static ConsumerPscConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ConsumerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return ConsumerPscConfig.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ConsumerPscConfig prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ConsumerPscConfig getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ConsumerPscConfig> parser() {
            return PARSER;
        }

        public Parser<ConsumerPscConfig> getParserForType() {
            return PARSER;
        }

        public ConsumerPscConfig getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ConsumerPscConfigOrBuilder {
            private int bitField0_;
            private Object project_ = "";
            private Object network_ = "";
            private boolean disableGlobalAccess_;
            private int state_ = 0;
            private Object producerInstanceId_ = "";
            private MapField<String, String> serviceAttachmentIpAddressMap_;
            private Object consumerInstanceProject_ = "";
            private MapField<String, String> producerInstanceMetadata_;
            private int ipVersion_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_descriptor;
            }

            protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
                switch (number) {
                    case 6: {
                        return this.internalGetServiceAttachmentIpAddressMap();
                    }
                    case 8: {
                        return this.internalGetProducerInstanceMetadata();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
                switch (number) {
                    case 6: {
                        return this.internalGetMutableServiceAttachmentIpAddressMap();
                    }
                    case 8: {
                        return this.internalGetMutableProducerInstanceMetadata();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(ConsumerPscConfig.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.project_ = "";
                this.network_ = "";
                this.disableGlobalAccess_ = false;
                this.state_ = 0;
                this.producerInstanceId_ = "";
                this.internalGetMutableServiceAttachmentIpAddressMap().clear();
                this.consumerInstanceProject_ = "";
                this.internalGetMutableProducerInstanceMetadata().clear();
                this.ipVersion_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_descriptor;
            }

            public ConsumerPscConfig getDefaultInstanceForType() {
                return ConsumerPscConfig.getDefaultInstance();
            }

            public ConsumerPscConfig build() {
                ConsumerPscConfig result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public ConsumerPscConfig buildPartial() {
                ConsumerPscConfig result = new ConsumerPscConfig(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ConsumerPscConfig result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.project_ = this.project_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.network_ = this.network_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.disableGlobalAccess_ = this.disableGlobalAccess_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.state_ = this.state_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.producerInstanceId_ = this.producerInstanceId_;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.serviceAttachmentIpAddressMap_ = this.internalGetServiceAttachmentIpAddressMap();
                    result.serviceAttachmentIpAddressMap_.makeImmutable();
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    result.consumerInstanceProject_ = this.consumerInstanceProject_;
                }
                if ((from_bitField0_ & 0x80) != 0) {
                    result.producerInstanceMetadata_ = this.internalGetProducerInstanceMetadata();
                    result.producerInstanceMetadata_.makeImmutable();
                }
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 0x100) != 0) {
                    result.ipVersion_ = this.ipVersion_;
                    to_bitField0_ |= 1;
                }
                ConsumerPscConfig consumerPscConfig = result;
                consumerPscConfig.bitField0_ = consumerPscConfig.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof ConsumerPscConfig) {
                    return this.mergeFrom((ConsumerPscConfig)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ConsumerPscConfig other) {
                if (other == ConsumerPscConfig.getDefaultInstance()) {
                    return this;
                }
                if (!other.getProject().isEmpty()) {
                    this.project_ = other.project_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (!other.getNetwork().isEmpty()) {
                    this.network_ = other.network_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                if (other.getDisableGlobalAccess()) {
                    this.setDisableGlobalAccess(other.getDisableGlobalAccess());
                }
                if (other.state_ != 0) {
                    this.setStateValue(other.getStateValue());
                }
                if (!other.getProducerInstanceId().isEmpty()) {
                    this.producerInstanceId_ = other.producerInstanceId_;
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                }
                this.internalGetMutableServiceAttachmentIpAddressMap().mergeFrom(other.internalGetServiceAttachmentIpAddressMap());
                this.bitField0_ |= 0x20;
                if (!other.getConsumerInstanceProject().isEmpty()) {
                    this.consumerInstanceProject_ = other.consumerInstanceProject_;
                    this.bitField0_ |= 0x40;
                    this.onChanged();
                }
                this.internalGetMutableProducerInstanceMetadata().mergeFrom(other.internalGetProducerInstanceMetadata());
                this.bitField0_ |= 0x80;
                if (other.hasIpVersion()) {
                    this.setIpVersion(other.getIpVersion());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block17: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block17;
                            }
                            case 10: {
                                this.project_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block17;
                            }
                            case 18: {
                                this.network_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block17;
                            }
                            case 24: {
                                this.disableGlobalAccess_ = input.readBool();
                                this.bitField0_ |= 4;
                                continue block17;
                            }
                            case 32: {
                                this.state_ = input.readEnum();
                                this.bitField0_ |= 8;
                                continue block17;
                            }
                            case 42: {
                                this.producerInstanceId_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x10;
                                continue block17;
                            }
                            case 50: {
                                MapEntry serviceAttachmentIpAddressMap__ = (MapEntry)input.readMessage(ServiceAttachmentIpAddressMapDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableServiceAttachmentIpAddressMap().getMutableMap().put(serviceAttachmentIpAddressMap__.getKey(), serviceAttachmentIpAddressMap__.getValue());
                                this.bitField0_ |= 0x20;
                                continue block17;
                            }
                            case 58: {
                                this.consumerInstanceProject_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x40;
                                continue block17;
                            }
                            case 66: {
                                MapEntry producerInstanceMetadata__ = (MapEntry)input.readMessage(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableProducerInstanceMetadata().getMutableMap().put(producerInstanceMetadata__.getKey(), producerInstanceMetadata__.getValue());
                                this.bitField0_ |= 0x80;
                                continue block17;
                            }
                            case 72: {
                                this.ipVersion_ = input.readEnum();
                                this.bitField0_ |= 0x100;
                                continue block17;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getProject() {
                Object ref = this.project_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.project_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getProjectBytes() {
                Object ref = this.project_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.project_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setProject(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.project_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearProject() {
                this.project_ = ConsumerPscConfig.getDefaultInstance().getProject();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setProjectBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConfig.checkByteStringIsUtf8((ByteString)value);
                this.project_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public String getNetwork() {
                Object ref = this.network_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.network_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNetworkBytes() {
                Object ref = this.network_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.network_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setNetwork(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.network_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearNetwork() {
                this.network_ = ConsumerPscConfig.getDefaultInstance().getNetwork();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setNetworkBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConfig.checkByteStringIsUtf8((ByteString)value);
                this.network_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getDisableGlobalAccess() {
                return this.disableGlobalAccess_;
            }

            public Builder setDisableGlobalAccess(boolean value) {
                this.disableGlobalAccess_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearDisableGlobalAccess() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.disableGlobalAccess_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public int getStateValue() {
                return this.state_;
            }

            public Builder setStateValue(int value) {
                this.state_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            @Override
            public State getState() {
                State result = State.forNumber(this.state_);
                return result == null ? State.UNRECOGNIZED : result;
            }

            public Builder setState(State value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 8;
                this.state_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearState() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.state_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            @Deprecated
            public String getProducerInstanceId() {
                Object ref = this.producerInstanceId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.producerInstanceId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            @Deprecated
            public ByteString getProducerInstanceIdBytes() {
                Object ref = this.producerInstanceId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.producerInstanceId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Deprecated
            public Builder setProducerInstanceId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.producerInstanceId_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder clearProducerInstanceId() {
                this.producerInstanceId_ = ConsumerPscConfig.getDefaultInstance().getProducerInstanceId();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
                return this;
            }

            @Deprecated
            public Builder setProducerInstanceIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConfig.checkByteStringIsUtf8((ByteString)value);
                this.producerInstanceId_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            private MapField<String, String> internalGetServiceAttachmentIpAddressMap() {
                if (this.serviceAttachmentIpAddressMap_ == null) {
                    return MapField.emptyMapField(ServiceAttachmentIpAddressMapDefaultEntryHolder.defaultEntry);
                }
                return this.serviceAttachmentIpAddressMap_;
            }

            private MapField<String, String> internalGetMutableServiceAttachmentIpAddressMap() {
                if (this.serviceAttachmentIpAddressMap_ == null) {
                    this.serviceAttachmentIpAddressMap_ = MapField.newMapField(ServiceAttachmentIpAddressMapDefaultEntryHolder.defaultEntry);
                }
                if (!this.serviceAttachmentIpAddressMap_.isMutable()) {
                    this.serviceAttachmentIpAddressMap_ = this.serviceAttachmentIpAddressMap_.copy();
                }
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this.serviceAttachmentIpAddressMap_;
            }

            @Override
            public int getServiceAttachmentIpAddressMapCount() {
                return this.internalGetServiceAttachmentIpAddressMap().getMap().size();
            }

            @Override
            public boolean containsServiceAttachmentIpAddressMap(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetServiceAttachmentIpAddressMap().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, String> getServiceAttachmentIpAddressMap() {
                return this.getServiceAttachmentIpAddressMapMap();
            }

            @Override
            public Map<String, String> getServiceAttachmentIpAddressMapMap() {
                return this.internalGetServiceAttachmentIpAddressMap().getMap();
            }

            @Override
            public String getServiceAttachmentIpAddressMapOrDefault(String key, String defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetServiceAttachmentIpAddressMap().getMap();
                return map.containsKey(key) ? (String)map.get(key) : defaultValue;
            }

            @Override
            public String getServiceAttachmentIpAddressMapOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetServiceAttachmentIpAddressMap().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return (String)map.get(key);
            }

            public Builder clearServiceAttachmentIpAddressMap() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.internalGetMutableServiceAttachmentIpAddressMap().getMutableMap().clear();
                return this;
            }

            public Builder removeServiceAttachmentIpAddressMap(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableServiceAttachmentIpAddressMap().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, String> getMutableServiceAttachmentIpAddressMap() {
                this.bitField0_ |= 0x20;
                return this.internalGetMutableServiceAttachmentIpAddressMap().getMutableMap();
            }

            public Builder putServiceAttachmentIpAddressMap(String key, String value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableServiceAttachmentIpAddressMap().getMutableMap().put(key, value);
                this.bitField0_ |= 0x20;
                return this;
            }

            public Builder putAllServiceAttachmentIpAddressMap(Map<String, String> values) {
                this.internalGetMutableServiceAttachmentIpAddressMap().getMutableMap().putAll(values);
                this.bitField0_ |= 0x20;
                return this;
            }

            @Override
            public String getConsumerInstanceProject() {
                Object ref = this.consumerInstanceProject_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.consumerInstanceProject_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getConsumerInstanceProjectBytes() {
                Object ref = this.consumerInstanceProject_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.consumerInstanceProject_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setConsumerInstanceProject(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.consumerInstanceProject_ = value;
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder clearConsumerInstanceProject() {
                this.consumerInstanceProject_ = ConsumerPscConfig.getDefaultInstance().getConsumerInstanceProject();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
                return this;
            }

            public Builder setConsumerInstanceProjectBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ConsumerPscConfig.checkByteStringIsUtf8((ByteString)value);
                this.consumerInstanceProject_ = value;
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            private MapField<String, String> internalGetProducerInstanceMetadata() {
                if (this.producerInstanceMetadata_ == null) {
                    return MapField.emptyMapField(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry);
                }
                return this.producerInstanceMetadata_;
            }

            private MapField<String, String> internalGetMutableProducerInstanceMetadata() {
                if (this.producerInstanceMetadata_ == null) {
                    this.producerInstanceMetadata_ = MapField.newMapField(ProducerInstanceMetadataDefaultEntryHolder.defaultEntry);
                }
                if (!this.producerInstanceMetadata_.isMutable()) {
                    this.producerInstanceMetadata_ = this.producerInstanceMetadata_.copy();
                }
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this.producerInstanceMetadata_;
            }

            @Override
            public int getProducerInstanceMetadataCount() {
                return this.internalGetProducerInstanceMetadata().getMap().size();
            }

            @Override
            public boolean containsProducerInstanceMetadata(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetProducerInstanceMetadata().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, String> getProducerInstanceMetadata() {
                return this.getProducerInstanceMetadataMap();
            }

            @Override
            public Map<String, String> getProducerInstanceMetadataMap() {
                return this.internalGetProducerInstanceMetadata().getMap();
            }

            @Override
            public String getProducerInstanceMetadataOrDefault(String key, String defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetProducerInstanceMetadata().getMap();
                return map.containsKey(key) ? (String)map.get(key) : defaultValue;
            }

            @Override
            public String getProducerInstanceMetadataOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetProducerInstanceMetadata().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return (String)map.get(key);
            }

            public Builder clearProducerInstanceMetadata() {
                this.bitField0_ &= 0xFFFFFF7F;
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().clear();
                return this;
            }

            public Builder removeProducerInstanceMetadata(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, String> getMutableProducerInstanceMetadata() {
                this.bitField0_ |= 0x80;
                return this.internalGetMutableProducerInstanceMetadata().getMutableMap();
            }

            public Builder putProducerInstanceMetadata(String key, String value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().put(key, value);
                this.bitField0_ |= 0x80;
                return this;
            }

            public Builder putAllProducerInstanceMetadata(Map<String, String> values) {
                this.internalGetMutableProducerInstanceMetadata().getMutableMap().putAll(values);
                this.bitField0_ |= 0x80;
                return this;
            }

            @Override
            public boolean hasIpVersion() {
                return (this.bitField0_ & 0x100) != 0;
            }

            @Override
            public int getIpVersionValue() {
                return this.ipVersion_;
            }

            public Builder setIpVersionValue(int value) {
                this.ipVersion_ = value;
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            @Override
            public IPVersion getIpVersion() {
                IPVersion result = IPVersion.forNumber(this.ipVersion_);
                return result == null ? IPVersion.UNRECOGNIZED : result;
            }

            public Builder setIpVersion(IPVersion value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 0x100;
                this.ipVersion_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearIpVersion() {
                this.bitField0_ &= 0xFFFFFEFF;
                this.ipVersion_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        private static final class ProducerInstanceMetadataDefaultEntryHolder {
            static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_ProducerInstanceMetadataEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

            private ProducerInstanceMetadataDefaultEntryHolder() {
            }
        }

        private static final class ServiceAttachmentIpAddressMapDefaultEntryHolder {
            static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ConsumerPscConfig_ServiceAttachmentIpAddressMapEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

            private ServiceAttachmentIpAddressMapDefaultEntryHolder() {
            }
        }

        public static enum State implements ProtocolMessageEnum
        {
            STATE_UNSPECIFIED(0),
            VALID(1),
            CONNECTION_POLICY_MISSING(2),
            POLICY_LIMIT_REACHED(3),
            CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED(4),
            UNRECOGNIZED(-1);

            public static final int STATE_UNSPECIFIED_VALUE = 0;
            public static final int VALID_VALUE = 1;
            public static final int CONNECTION_POLICY_MISSING_VALUE = 2;
            public static final int POLICY_LIMIT_REACHED_VALUE = 3;
            public static final int CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED_VALUE = 4;
            private static final Internal.EnumLiteMap<State> internalValueMap;
            private static final State[] VALUES;
            private final int value;

            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static State valueOf(int value) {
                return State.forNumber(value);
            }

            public static State forNumber(int value) {
                switch (value) {
                    case 0: {
                        return STATE_UNSPECIFIED;
                    }
                    case 1: {
                        return VALID;
                    }
                    case 2: {
                        return CONNECTION_POLICY_MISSING;
                    }
                    case 3: {
                        return POLICY_LIMIT_REACHED;
                    }
                    case 4: {
                        return CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<State> internalGetValueMap() {
                return internalValueMap;
            }

            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
            }

            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return State.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return (Descriptors.EnumDescriptor)ConsumerPscConfig.getDescriptor().getEnumTypes().get(0);
            }

            public static State valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != State.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private State(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<State>(){

                    public State findValueByNumber(int number) {
                        return State.forNumber(number);
                    }
                };
                VALUES = State.values();
            }
        }
    }

    public static interface ConsumerPscConfigOrBuilder
    extends MessageOrBuilder {
        public String getProject();

        public ByteString getProjectBytes();

        public String getNetwork();

        public ByteString getNetworkBytes();

        public boolean getDisableGlobalAccess();

        public int getStateValue();

        public ConsumerPscConfig.State getState();

        @Deprecated
        public String getProducerInstanceId();

        @Deprecated
        public ByteString getProducerInstanceIdBytes();

        public int getServiceAttachmentIpAddressMapCount();

        public boolean containsServiceAttachmentIpAddressMap(String var1);

        @Deprecated
        public Map<String, String> getServiceAttachmentIpAddressMap();

        public Map<String, String> getServiceAttachmentIpAddressMapMap();

        public String getServiceAttachmentIpAddressMapOrDefault(String var1, String var2);

        public String getServiceAttachmentIpAddressMapOrThrow(String var1);

        public String getConsumerInstanceProject();

        public ByteString getConsumerInstanceProjectBytes();

        public int getProducerInstanceMetadataCount();

        public boolean containsProducerInstanceMetadata(String var1);

        @Deprecated
        public Map<String, String> getProducerInstanceMetadata();

        public Map<String, String> getProducerInstanceMetadataMap();

        public String getProducerInstanceMetadataOrDefault(String var1, String var2);

        public String getProducerInstanceMetadataOrThrow(String var1);

        public boolean hasIpVersion();

        public int getIpVersionValue();

        public IPVersion getIpVersion();
    }

    public static final class ProducerPscConfig
    extends GeneratedMessageV3
    implements ProducerPscConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int SERVICE_ATTACHMENT_URI_FIELD_NUMBER = 1;
        private volatile Object serviceAttachmentUri_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final ProducerPscConfig DEFAULT_INSTANCE = new ProducerPscConfig();
        private static final Parser<ProducerPscConfig> PARSER = new AbstractParser<ProducerPscConfig>(){

            public ProducerPscConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ProducerPscConfig.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ProducerPscConfig(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ProducerPscConfig() {
            this.serviceAttachmentUri_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ProducerPscConfig();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ProducerPscConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ProducerPscConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(ProducerPscConfig.class, Builder.class);
        }

        @Override
        public String getServiceAttachmentUri() {
            Object ref = this.serviceAttachmentUri_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.serviceAttachmentUri_ = s;
            return s;
        }

        @Override
        public ByteString getServiceAttachmentUriBytes() {
            Object ref = this.serviceAttachmentUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAttachmentUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAttachmentUri_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.serviceAttachmentUri_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAttachmentUri_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.serviceAttachmentUri_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProducerPscConfig)) {
                return super.equals(obj);
            }
            ProducerPscConfig other = (ProducerPscConfig)obj;
            if (!this.getServiceAttachmentUri().equals(other.getServiceAttachmentUri())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ProducerPscConfig.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getServiceAttachmentUri().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ProducerPscConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (ProducerPscConfig)PARSER.parseFrom(data);
        }

        public static ProducerPscConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ProducerPscConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProducerPscConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (ProducerPscConfig)PARSER.parseFrom(data);
        }

        public static ProducerPscConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ProducerPscConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProducerPscConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (ProducerPscConfig)PARSER.parseFrom(data);
        }

        public static ProducerPscConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ProducerPscConfig)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProducerPscConfig parseFrom(InputStream input) throws IOException {
            return (ProducerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static ProducerPscConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ProducerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ProducerPscConfig parseDelimitedFrom(InputStream input) throws IOException {
            return (ProducerPscConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static ProducerPscConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ProducerPscConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ProducerPscConfig parseFrom(CodedInputStream input) throws IOException {
            return (ProducerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static ProducerPscConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ProducerPscConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return ProducerPscConfig.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ProducerPscConfig prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ProducerPscConfig getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ProducerPscConfig> parser() {
            return PARSER;
        }

        public Parser<ProducerPscConfig> getParserForType() {
            return PARSER;
        }

        public ProducerPscConfig getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ProducerPscConfigOrBuilder {
            private int bitField0_;
            private Object serviceAttachmentUri_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ProducerPscConfig_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ProducerPscConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(ProducerPscConfig.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.serviceAttachmentUri_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CrossNetworkAutomationProto.internal_static_google_cloud_networkconnectivity_v1_ServiceConnectionMap_ProducerPscConfig_descriptor;
            }

            public ProducerPscConfig getDefaultInstanceForType() {
                return ProducerPscConfig.getDefaultInstance();
            }

            public ProducerPscConfig build() {
                ProducerPscConfig result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public ProducerPscConfig buildPartial() {
                ProducerPscConfig result = new ProducerPscConfig(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ProducerPscConfig result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.serviceAttachmentUri_ = this.serviceAttachmentUri_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof ProducerPscConfig) {
                    return this.mergeFrom((ProducerPscConfig)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ProducerPscConfig other) {
                if (other == ProducerPscConfig.getDefaultInstance()) {
                    return this;
                }
                if (!other.getServiceAttachmentUri().isEmpty()) {
                    this.serviceAttachmentUri_ = other.serviceAttachmentUri_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                this.serviceAttachmentUri_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getServiceAttachmentUri() {
                Object ref = this.serviceAttachmentUri_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.serviceAttachmentUri_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getServiceAttachmentUriBytes() {
                Object ref = this.serviceAttachmentUri_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.serviceAttachmentUri_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setServiceAttachmentUri(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.serviceAttachmentUri_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearServiceAttachmentUri() {
                this.serviceAttachmentUri_ = ProducerPscConfig.getDefaultInstance().getServiceAttachmentUri();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setServiceAttachmentUriBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ProducerPscConfig.checkByteStringIsUtf8((ByteString)value);
                this.serviceAttachmentUri_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface ProducerPscConfigOrBuilder
    extends MessageOrBuilder {
        public String getServiceAttachmentUri();

        public ByteString getServiceAttachmentUriBytes();
    }
}

