/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v1beta1/environment.proto

package com.google.cloud.notebooks.v1beta1;

/**
 *
 *
 * <pre>
 * Definition of a software environment that is used to start a notebook
 * instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v1beta1.Environment}
 */
public final class Environment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v1beta1.Environment)
    EnvironmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Environment.newBuilder() to construct.
  private Environment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Environment() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    postStartupScript_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Environment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v1beta1.EnvironmentProto
        .internal_static_google_cloud_notebooks_v1beta1_Environment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v1beta1.EnvironmentProto
        .internal_static_google_cloud_notebooks_v1beta1_Environment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v1beta1.Environment.class,
            com.google.cloud.notebooks.v1beta1.Environment.Builder.class);
  }

  private int imageTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object imageType_;

  public enum ImageTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VM_IMAGE(6),
    CONTAINER_IMAGE(7),
    IMAGETYPE_NOT_SET(0);
    private final int value;

    private ImageTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImageTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ImageTypeCase forNumber(int value) {
      switch (value) {
        case 6:
          return VM_IMAGE;
        case 7:
          return CONTAINER_IMAGE;
        case 0:
          return IMAGETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ImageTypeCase getImageTypeCase() {
    return ImageTypeCase.forNumber(imageTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of this environment.
   * Format:
   * `projects/{project_id}/locations/{location}/environments/{environment_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of this environment.
   * Format:
   * `projects/{project_id}/locations/{location}/environments/{environment_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name of this environment for the UI.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name of this environment for the UI.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A brief description of this environment.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A brief description of this environment.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_IMAGE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
   *
   * @return Whether the vmImage field is set.
   */
  @java.lang.Override
  public boolean hasVmImage() {
    return imageTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
   *
   * @return The vmImage.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.VmImage getVmImage() {
    if (imageTypeCase_ == 6) {
      return (com.google.cloud.notebooks.v1beta1.VmImage) imageType_;
    }
    return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.VmImageOrBuilder getVmImageOrBuilder() {
    if (imageTypeCase_ == 6) {
      return (com.google.cloud.notebooks.v1beta1.VmImage) imageType_;
    }
    return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
  }

  public static final int CONTAINER_IMAGE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
   *
   * @return Whether the containerImage field is set.
   */
  @java.lang.Override
  public boolean hasContainerImage() {
    return imageTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
   *
   * @return The containerImage.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.ContainerImage getContainerImage() {
    if (imageTypeCase_ == 7) {
      return (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_;
    }
    return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder getContainerImageOrBuilder() {
    if (imageTypeCase_ == 7) {
      return (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_;
    }
    return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
  }

  public static final int POST_STARTUP_SCRIPT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postStartupScript_ = "";
  /**
   *
   *
   * <pre>
   * Path to a Bash script that automatically runs after a notebook instance
   * fully boots up. The path must be a URL or
   * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
   * </pre>
   *
   * <code>string post_startup_script = 8;</code>
   *
   * @return The postStartupScript.
   */
  @java.lang.Override
  public java.lang.String getPostStartupScript() {
    java.lang.Object ref = postStartupScript_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postStartupScript_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path to a Bash script that automatically runs after a notebook instance
   * fully boots up. The path must be a URL or
   * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
   * </pre>
   *
   * <code>string post_startup_script = 8;</code>
   *
   * @return The bytes for postStartupScript.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPostStartupScriptBytes() {
    java.lang.Object ref = postStartupScript_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postStartupScript_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this environment was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this environment was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this environment was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (imageTypeCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.notebooks.v1beta1.VmImage) imageType_);
    }
    if (imageTypeCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postStartupScript_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, postStartupScript_);
    }
    if (createTime_ != null) {
      output.writeMessage(9, getCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (imageTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.notebooks.v1beta1.VmImage) imageType_);
    }
    if (imageTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postStartupScript_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, postStartupScript_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v1beta1.Environment)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v1beta1.Environment other =
        (com.google.cloud.notebooks.v1beta1.Environment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getPostStartupScript().equals(other.getPostStartupScript())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getImageTypeCase().equals(other.getImageTypeCase())) return false;
    switch (imageTypeCase_) {
      case 6:
        if (!getVmImage().equals(other.getVmImage())) return false;
        break;
      case 7:
        if (!getContainerImage().equals(other.getContainerImage())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + POST_STARTUP_SCRIPT_FIELD_NUMBER;
    hash = (53 * hash) + getPostStartupScript().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    switch (imageTypeCase_) {
      case 6:
        hash = (37 * hash) + VM_IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getVmImage().hashCode();
        break;
      case 7:
        hash = (37 * hash) + CONTAINER_IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getContainerImage().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v1beta1.Environment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Definition of a software environment that is used to start a notebook
   * instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v1beta1.Environment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v1beta1.Environment)
      com.google.cloud.notebooks.v1beta1.EnvironmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.EnvironmentProto
          .internal_static_google_cloud_notebooks_v1beta1_Environment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v1beta1.EnvironmentProto
          .internal_static_google_cloud_notebooks_v1beta1_Environment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v1beta1.Environment.class,
              com.google.cloud.notebooks.v1beta1.Environment.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v1beta1.Environment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (vmImageBuilder_ != null) {
        vmImageBuilder_.clear();
      }
      if (containerImageBuilder_ != null) {
        containerImageBuilder_.clear();
      }
      postStartupScript_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      imageTypeCase_ = 0;
      imageType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v1beta1.EnvironmentProto
          .internal_static_google_cloud_notebooks_v1beta1_Environment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Environment getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v1beta1.Environment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Environment build() {
      com.google.cloud.notebooks.v1beta1.Environment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Environment buildPartial() {
      com.google.cloud.notebooks.v1beta1.Environment result =
          new com.google.cloud.notebooks.v1beta1.Environment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.notebooks.v1beta1.Environment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.postStartupScript_ = postStartupScript_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.notebooks.v1beta1.Environment result) {
      result.imageTypeCase_ = imageTypeCase_;
      result.imageType_ = this.imageType_;
      if (imageTypeCase_ == 6 && vmImageBuilder_ != null) {
        result.imageType_ = vmImageBuilder_.build();
      }
      if (imageTypeCase_ == 7 && containerImageBuilder_ != null) {
        result.imageType_ = containerImageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v1beta1.Environment) {
        return mergeFrom((com.google.cloud.notebooks.v1beta1.Environment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v1beta1.Environment other) {
      if (other == com.google.cloud.notebooks.v1beta1.Environment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPostStartupScript().isEmpty()) {
        postStartupScript_ = other.postStartupScript_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      switch (other.getImageTypeCase()) {
        case VM_IMAGE:
          {
            mergeVmImage(other.getVmImage());
            break;
          }
        case CONTAINER_IMAGE:
          {
            mergeContainerImage(other.getContainerImage());
            break;
          }
        case IMAGETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getVmImageFieldBuilder().getBuilder(), extensionRegistry);
                imageTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getContainerImageFieldBuilder().getBuilder(), extensionRegistry);
                imageTypeCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                postStartupScript_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int imageTypeCase_ = 0;
    private java.lang.Object imageType_;

    public ImageTypeCase getImageTypeCase() {
      return ImageTypeCase.forNumber(imageTypeCase_);
    }

    public Builder clearImageType() {
      imageTypeCase_ = 0;
      imageType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of this environment.
     * Format:
     * `projects/{project_id}/locations/{location}/environments/{environment_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of this environment.
     * Format:
     * `projects/{project_id}/locations/{location}/environments/{environment_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of this environment.
     * Format:
     * `projects/{project_id}/locations/{location}/environments/{environment_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of this environment.
     * Format:
     * `projects/{project_id}/locations/{location}/environments/{environment_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of this environment.
     * Format:
     * `projects/{project_id}/locations/{location}/environments/{environment_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name of this environment for the UI.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of this environment for the UI.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of this environment for the UI.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of this environment for the UI.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of this environment for the UI.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A brief description of this environment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A brief description of this environment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A brief description of this environment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A brief description of this environment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A brief description of this environment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.VmImage,
            com.google.cloud.notebooks.v1beta1.VmImage.Builder,
            com.google.cloud.notebooks.v1beta1.VmImageOrBuilder>
        vmImageBuilder_;
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     *
     * @return Whether the vmImage field is set.
     */
    @java.lang.Override
    public boolean hasVmImage() {
      return imageTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     *
     * @return The vmImage.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.VmImage getVmImage() {
      if (vmImageBuilder_ == null) {
        if (imageTypeCase_ == 6) {
          return (com.google.cloud.notebooks.v1beta1.VmImage) imageType_;
        }
        return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
      } else {
        if (imageTypeCase_ == 6) {
          return vmImageBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    public Builder setVmImage(com.google.cloud.notebooks.v1beta1.VmImage value) {
      if (vmImageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageType_ = value;
        onChanged();
      } else {
        vmImageBuilder_.setMessage(value);
      }
      imageTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    public Builder setVmImage(com.google.cloud.notebooks.v1beta1.VmImage.Builder builderForValue) {
      if (vmImageBuilder_ == null) {
        imageType_ = builderForValue.build();
        onChanged();
      } else {
        vmImageBuilder_.setMessage(builderForValue.build());
      }
      imageTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    public Builder mergeVmImage(com.google.cloud.notebooks.v1beta1.VmImage value) {
      if (vmImageBuilder_ == null) {
        if (imageTypeCase_ == 6
            && imageType_ != com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance()) {
          imageType_ =
              com.google.cloud.notebooks.v1beta1.VmImage.newBuilder(
                      (com.google.cloud.notebooks.v1beta1.VmImage) imageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          imageType_ = value;
        }
        onChanged();
      } else {
        if (imageTypeCase_ == 6) {
          vmImageBuilder_.mergeFrom(value);
        } else {
          vmImageBuilder_.setMessage(value);
        }
      }
      imageTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    public Builder clearVmImage() {
      if (vmImageBuilder_ == null) {
        if (imageTypeCase_ == 6) {
          imageTypeCase_ = 0;
          imageType_ = null;
          onChanged();
        }
      } else {
        if (imageTypeCase_ == 6) {
          imageTypeCase_ = 0;
          imageType_ = null;
        }
        vmImageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    public com.google.cloud.notebooks.v1beta1.VmImage.Builder getVmImageBuilder() {
      return getVmImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.VmImageOrBuilder getVmImageOrBuilder() {
      if ((imageTypeCase_ == 6) && (vmImageBuilder_ != null)) {
        return vmImageBuilder_.getMessageOrBuilder();
      } else {
        if (imageTypeCase_ == 6) {
          return (com.google.cloud.notebooks.v1beta1.VmImage) imageType_;
        }
        return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.VmImage,
            com.google.cloud.notebooks.v1beta1.VmImage.Builder,
            com.google.cloud.notebooks.v1beta1.VmImageOrBuilder>
        getVmImageFieldBuilder() {
      if (vmImageBuilder_ == null) {
        if (!(imageTypeCase_ == 6)) {
          imageType_ = com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
        }
        vmImageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v1beta1.VmImage,
                com.google.cloud.notebooks.v1beta1.VmImage.Builder,
                com.google.cloud.notebooks.v1beta1.VmImageOrBuilder>(
                (com.google.cloud.notebooks.v1beta1.VmImage) imageType_,
                getParentForChildren(),
                isClean());
        imageType_ = null;
      }
      imageTypeCase_ = 6;
      onChanged();
      return vmImageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.ContainerImage,
            com.google.cloud.notebooks.v1beta1.ContainerImage.Builder,
            com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder>
        containerImageBuilder_;
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     *
     * @return Whether the containerImage field is set.
     */
    @java.lang.Override
    public boolean hasContainerImage() {
      return imageTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     *
     * @return The containerImage.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.ContainerImage getContainerImage() {
      if (containerImageBuilder_ == null) {
        if (imageTypeCase_ == 7) {
          return (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_;
        }
        return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
      } else {
        if (imageTypeCase_ == 7) {
          return containerImageBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    public Builder setContainerImage(com.google.cloud.notebooks.v1beta1.ContainerImage value) {
      if (containerImageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageType_ = value;
        onChanged();
      } else {
        containerImageBuilder_.setMessage(value);
      }
      imageTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    public Builder setContainerImage(
        com.google.cloud.notebooks.v1beta1.ContainerImage.Builder builderForValue) {
      if (containerImageBuilder_ == null) {
        imageType_ = builderForValue.build();
        onChanged();
      } else {
        containerImageBuilder_.setMessage(builderForValue.build());
      }
      imageTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    public Builder mergeContainerImage(com.google.cloud.notebooks.v1beta1.ContainerImage value) {
      if (containerImageBuilder_ == null) {
        if (imageTypeCase_ == 7
            && imageType_
                != com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance()) {
          imageType_ =
              com.google.cloud.notebooks.v1beta1.ContainerImage.newBuilder(
                      (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          imageType_ = value;
        }
        onChanged();
      } else {
        if (imageTypeCase_ == 7) {
          containerImageBuilder_.mergeFrom(value);
        } else {
          containerImageBuilder_.setMessage(value);
        }
      }
      imageTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    public Builder clearContainerImage() {
      if (containerImageBuilder_ == null) {
        if (imageTypeCase_ == 7) {
          imageTypeCase_ = 0;
          imageType_ = null;
          onChanged();
        }
      } else {
        if (imageTypeCase_ == 7) {
          imageTypeCase_ = 0;
          imageType_ = null;
        }
        containerImageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    public com.google.cloud.notebooks.v1beta1.ContainerImage.Builder getContainerImageBuilder() {
      return getContainerImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder getContainerImageOrBuilder() {
      if ((imageTypeCase_ == 7) && (containerImageBuilder_ != null)) {
        return containerImageBuilder_.getMessageOrBuilder();
      } else {
        if (imageTypeCase_ == 7) {
          return (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_;
        }
        return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.ContainerImage,
            com.google.cloud.notebooks.v1beta1.ContainerImage.Builder,
            com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder>
        getContainerImageFieldBuilder() {
      if (containerImageBuilder_ == null) {
        if (!(imageTypeCase_ == 7)) {
          imageType_ = com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
        }
        containerImageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v1beta1.ContainerImage,
                com.google.cloud.notebooks.v1beta1.ContainerImage.Builder,
                com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder>(
                (com.google.cloud.notebooks.v1beta1.ContainerImage) imageType_,
                getParentForChildren(),
                isClean());
        imageType_ = null;
      }
      imageTypeCase_ = 7;
      onChanged();
      return containerImageBuilder_;
    }

    private java.lang.Object postStartupScript_ = "";
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
     * </pre>
     *
     * <code>string post_startup_script = 8;</code>
     *
     * @return The postStartupScript.
     */
    public java.lang.String getPostStartupScript() {
      java.lang.Object ref = postStartupScript_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postStartupScript_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
     * </pre>
     *
     * <code>string post_startup_script = 8;</code>
     *
     * @return The bytes for postStartupScript.
     */
    public com.google.protobuf.ByteString getPostStartupScriptBytes() {
      java.lang.Object ref = postStartupScript_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postStartupScript_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
     * </pre>
     *
     * <code>string post_startup_script = 8;</code>
     *
     * @param value The postStartupScript to set.
     * @return This builder for chaining.
     */
    public Builder setPostStartupScript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postStartupScript_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
     * </pre>
     *
     * <code>string post_startup_script = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostStartupScript() {
      postStartupScript_ = getDefaultInstance().getPostStartupScript();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path. Example: `"gs://path-to-file/file-name"`
     * </pre>
     *
     * <code>string post_startup_script = 8;</code>
     *
     * @param value The bytes for postStartupScript to set.
     * @return This builder for chaining.
     */
    public Builder setPostStartupScriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postStartupScript_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this environment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v1beta1.Environment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v1beta1.Environment)
  private static final com.google.cloud.notebooks.v1beta1.Environment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v1beta1.Environment();
  }

  public static com.google.cloud.notebooks.v1beta1.Environment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Environment> PARSER =
      new com.google.protobuf.AbstractParser<Environment>() {
        @java.lang.Override
        public Environment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Environment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Environment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Environment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
