/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v1beta1/instance.proto

package com.google.cloud.notebooks.v1beta1;

/**
 *
 *
 * <pre>
 * The definition of a notebook instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v1beta1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v1beta1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    postStartupScript_ = "";
    proxyUri_ = "";
    instanceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccount_ = "";
    machineType_ = "";
    state_ = 0;
    customGpuDriverPath_ = "";
    bootDiskType_ = 0;
    dataDiskType_ = 0;
    diskEncryption_ = 0;
    kmsKey_ = "";
    network_ = "";
    subnet_ = "";
    nicType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v1beta1.InstanceProto
        .internal_static_google_cloud_notebooks_v1beta1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 21:
        return internalGetLabels();
      case 22:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v1beta1.InstanceProto
        .internal_static_google_cloud_notebooks_v1beta1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v1beta1.Instance.class,
            com.google.cloud.notebooks.v1beta1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Definition of the types of hardware accelerators that can be used on this
   * instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v1beta1.Instance.AcceleratorType}
   */
  public enum AcceleratorType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Accelerator type is not specified.
     * </pre>
     *
     * <code>ACCELERATOR_TYPE_UNSPECIFIED = 0;</code>
     */
    ACCELERATOR_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla K80.
     * </pre>
     *
     * <code>NVIDIA_TESLA_K80 = 1;</code>
     */
    NVIDIA_TESLA_K80(1),
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla P100.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P100 = 2;</code>
     */
    NVIDIA_TESLA_P100(2),
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla V100.
     * </pre>
     *
     * <code>NVIDIA_TESLA_V100 = 3;</code>
     */
    NVIDIA_TESLA_V100(3),
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla P4.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P4 = 4;</code>
     */
    NVIDIA_TESLA_P4(4),
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla T4.
     * </pre>
     *
     * <code>NVIDIA_TESLA_T4 = 5;</code>
     */
    NVIDIA_TESLA_T4(5),
    /**
     *
     *
     * <pre>
     * Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
     * </pre>
     *
     * <code>NVIDIA_TESLA_T4_VWS = 8;</code>
     */
    NVIDIA_TESLA_T4_VWS(8),
    /**
     *
     *
     * <pre>
     * Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P100_VWS = 9;</code>
     */
    NVIDIA_TESLA_P100_VWS(9),
    /**
     *
     *
     * <pre>
     * Accelerator type is NVIDIA Tesla P4 Virtual Workstations.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P4_VWS = 10;</code>
     */
    NVIDIA_TESLA_P4_VWS(10),
    /**
     *
     *
     * <pre>
     * (Coming soon) Accelerator type is TPU V2.
     * </pre>
     *
     * <code>TPU_V2 = 6;</code>
     */
    TPU_V2(6),
    /**
     *
     *
     * <pre>
     * (Coming soon) Accelerator type is TPU V3.
     * </pre>
     *
     * <code>TPU_V3 = 7;</code>
     */
    TPU_V3(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Accelerator type is not specified.
     * </pre>
     *
     * <code>ACCELERATOR_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ACCELERATOR_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla K80.
     * </pre>
     *
     * <code>NVIDIA_TESLA_K80 = 1;</code>
     */
    public static final int NVIDIA_TESLA_K80_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla P100.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P100 = 2;</code>
     */
    public static final int NVIDIA_TESLA_P100_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla V100.
     * </pre>
     *
     * <code>NVIDIA_TESLA_V100 = 3;</code>
     */
    public static final int NVIDIA_TESLA_V100_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla P4.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P4 = 4;</code>
     */
    public static final int NVIDIA_TESLA_P4_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Accelerator type is Nvidia Tesla T4.
     * </pre>
     *
     * <code>NVIDIA_TESLA_T4 = 5;</code>
     */
    public static final int NVIDIA_TESLA_T4_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
     * </pre>
     *
     * <code>NVIDIA_TESLA_T4_VWS = 8;</code>
     */
    public static final int NVIDIA_TESLA_T4_VWS_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P100_VWS = 9;</code>
     */
    public static final int NVIDIA_TESLA_P100_VWS_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Accelerator type is NVIDIA Tesla P4 Virtual Workstations.
     * </pre>
     *
     * <code>NVIDIA_TESLA_P4_VWS = 10;</code>
     */
    public static final int NVIDIA_TESLA_P4_VWS_VALUE = 10;
    /**
     *
     *
     * <pre>
     * (Coming soon) Accelerator type is TPU V2.
     * </pre>
     *
     * <code>TPU_V2 = 6;</code>
     */
    public static final int TPU_V2_VALUE = 6;
    /**
     *
     *
     * <pre>
     * (Coming soon) Accelerator type is TPU V3.
     * </pre>
     *
     * <code>TPU_V3 = 7;</code>
     */
    public static final int TPU_V3_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AcceleratorType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AcceleratorType forNumber(int value) {
      switch (value) {
        case 0:
          return ACCELERATOR_TYPE_UNSPECIFIED;
        case 1:
          return NVIDIA_TESLA_K80;
        case 2:
          return NVIDIA_TESLA_P100;
        case 3:
          return NVIDIA_TESLA_V100;
        case 4:
          return NVIDIA_TESLA_P4;
        case 5:
          return NVIDIA_TESLA_T4;
        case 8:
          return NVIDIA_TESLA_T4_VWS;
        case 9:
          return NVIDIA_TESLA_P100_VWS;
        case 10:
          return NVIDIA_TESLA_P4_VWS;
        case 6:
          return TPU_V2;
        case 7:
          return TPU_V3;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AcceleratorType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AcceleratorType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AcceleratorType>() {
              public AcceleratorType findValueByNumber(int number) {
                return AcceleratorType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final AcceleratorType[] VALUES = values();

    public static AcceleratorType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AcceleratorType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v1beta1.Instance.AcceleratorType)
  }

  /**
   *
   *
   * <pre>
   * The definition of the states of this instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v1beta1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State is not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The control logic is starting the instance.
     * </pre>
     *
     * <code>STARTING = 1;</code>
     */
    STARTING(1),
    /**
     *
     *
     * <pre>
     * The control logic is installing required frameworks and registering the
     * instance with notebook proxy
     * </pre>
     *
     * <code>PROVISIONING = 2;</code>
     */
    PROVISIONING(2),
    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>ACTIVE = 3;</code>
     */
    ACTIVE(3),
    /**
     *
     *
     * <pre>
     * The control logic is stopping the instance.
     * </pre>
     *
     * <code>STOPPING = 4;</code>
     */
    STOPPING(4),
    /**
     *
     *
     * <pre>
     * The instance is stopped.
     * </pre>
     *
     * <code>STOPPED = 5;</code>
     */
    STOPPED(5),
    /**
     *
     *
     * <pre>
     * The instance is deleted.
     * </pre>
     *
     * <code>DELETED = 6;</code>
     */
    DELETED(6),
    /**
     *
     *
     * <pre>
     * The instance is upgrading.
     * </pre>
     *
     * <code>UPGRADING = 7;</code>
     */
    UPGRADING(7),
    /**
     *
     *
     * <pre>
     * The instance is being created.
     * </pre>
     *
     * <code>INITIALIZING = 8;</code>
     */
    INITIALIZING(8),
    /**
     *
     *
     * <pre>
     * The instance is getting registered.
     * </pre>
     *
     * <code>REGISTERING = 9;</code>
     */
    REGISTERING(9),
    /**
     *
     *
     * <pre>
     * The instance is suspending.
     * </pre>
     *
     * <code>SUSPENDING = 10;</code>
     */
    SUSPENDING(10),
    /**
     *
     *
     * <pre>
     * The instance is suspended.
     * </pre>
     *
     * <code>SUSPENDED = 11;</code>
     */
    SUSPENDED(11),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State is not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The control logic is starting the instance.
     * </pre>
     *
     * <code>STARTING = 1;</code>
     */
    public static final int STARTING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The control logic is installing required frameworks and registering the
     * instance with notebook proxy
     * </pre>
     *
     * <code>PROVISIONING = 2;</code>
     */
    public static final int PROVISIONING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>ACTIVE = 3;</code>
     */
    public static final int ACTIVE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The control logic is stopping the instance.
     * </pre>
     *
     * <code>STOPPING = 4;</code>
     */
    public static final int STOPPING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The instance is stopped.
     * </pre>
     *
     * <code>STOPPED = 5;</code>
     */
    public static final int STOPPED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The instance is deleted.
     * </pre>
     *
     * <code>DELETED = 6;</code>
     */
    public static final int DELETED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The instance is upgrading.
     * </pre>
     *
     * <code>UPGRADING = 7;</code>
     */
    public static final int UPGRADING_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The instance is being created.
     * </pre>
     *
     * <code>INITIALIZING = 8;</code>
     */
    public static final int INITIALIZING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The instance is getting registered.
     * </pre>
     *
     * <code>REGISTERING = 9;</code>
     */
    public static final int REGISTERING_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The instance is suspending.
     * </pre>
     *
     * <code>SUSPENDING = 10;</code>
     */
    public static final int SUSPENDING_VALUE = 10;
    /**
     *
     *
     * <pre>
     * The instance is suspended.
     * </pre>
     *
     * <code>SUSPENDED = 11;</code>
     */
    public static final int SUSPENDED_VALUE = 11;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STARTING;
        case 2:
          return PROVISIONING;
        case 3:
          return ACTIVE;
        case 4:
          return STOPPING;
        case 5:
          return STOPPED;
        case 6:
          return DELETED;
        case 7:
          return UPGRADING;
        case 8:
          return INITIALIZING;
        case 9:
          return REGISTERING;
        case 10:
          return SUSPENDING;
        case 11:
          return SUSPENDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v1beta1.Instance.State)
  }

  /**
   *
   *
   * <pre>
   * Possible disk types for notebook instances.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v1beta1.Instance.DiskType}
   */
  public enum DiskType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Disk type not set.
     * </pre>
     *
     * <code>DISK_TYPE_UNSPECIFIED = 0;</code>
     */
    DISK_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Standard persistent disk type.
     * </pre>
     *
     * <code>PD_STANDARD = 1;</code>
     */
    PD_STANDARD(1),
    /**
     *
     *
     * <pre>
     * SSD persistent disk type.
     * </pre>
     *
     * <code>PD_SSD = 2;</code>
     */
    PD_SSD(2),
    /**
     *
     *
     * <pre>
     * Balanced persistent disk type.
     * </pre>
     *
     * <code>PD_BALANCED = 3;</code>
     */
    PD_BALANCED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Disk type not set.
     * </pre>
     *
     * <code>DISK_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DISK_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Standard persistent disk type.
     * </pre>
     *
     * <code>PD_STANDARD = 1;</code>
     */
    public static final int PD_STANDARD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * SSD persistent disk type.
     * </pre>
     *
     * <code>PD_SSD = 2;</code>
     */
    public static final int PD_SSD_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Balanced persistent disk type.
     * </pre>
     *
     * <code>PD_BALANCED = 3;</code>
     */
    public static final int PD_BALANCED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DiskType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DiskType forNumber(int value) {
      switch (value) {
        case 0:
          return DISK_TYPE_UNSPECIFIED;
        case 1:
          return PD_STANDARD;
        case 2:
          return PD_SSD;
        case 3:
          return PD_BALANCED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DiskType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DiskType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DiskType>() {
          public DiskType findValueByNumber(int number) {
            return DiskType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.Instance.getDescriptor().getEnumTypes().get(2);
    }

    private static final DiskType[] VALUES = values();

    public static DiskType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DiskType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v1beta1.Instance.DiskType)
  }

  /**
   *
   *
   * <pre>
   * Definition of the disk encryption options.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v1beta1.Instance.DiskEncryption}
   */
  public enum DiskEncryption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Disk encryption is not specified.
     * </pre>
     *
     * <code>DISK_ENCRYPTION_UNSPECIFIED = 0;</code>
     */
    DISK_ENCRYPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use Google managed encryption keys to encrypt the boot disk.
     * </pre>
     *
     * <code>GMEK = 1;</code>
     */
    GMEK(1),
    /**
     *
     *
     * <pre>
     * Use customer managed encryption keys to encrypt the boot disk.
     * </pre>
     *
     * <code>CMEK = 2;</code>
     */
    CMEK(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Disk encryption is not specified.
     * </pre>
     *
     * <code>DISK_ENCRYPTION_UNSPECIFIED = 0;</code>
     */
    public static final int DISK_ENCRYPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use Google managed encryption keys to encrypt the boot disk.
     * </pre>
     *
     * <code>GMEK = 1;</code>
     */
    public static final int GMEK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use customer managed encryption keys to encrypt the boot disk.
     * </pre>
     *
     * <code>CMEK = 2;</code>
     */
    public static final int CMEK_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DiskEncryption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DiskEncryption forNumber(int value) {
      switch (value) {
        case 0:
          return DISK_ENCRYPTION_UNSPECIFIED;
        case 1:
          return GMEK;
        case 2:
          return CMEK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DiskEncryption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DiskEncryption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DiskEncryption>() {
          public DiskEncryption findValueByNumber(int number) {
            return DiskEncryption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.Instance.getDescriptor().getEnumTypes().get(3);
    }

    private static final DiskEncryption[] VALUES = values();

    public static DiskEncryption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DiskEncryption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v1beta1.Instance.DiskEncryption)
  }

  /**
   *
   *
   * <pre>
   * The type of vNIC driver.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v1beta1.Instance.NicType}
   */
  public enum NicType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No type specified. Default should be UNSPECIFIED_NIC_TYPE.
     * </pre>
     *
     * <code>UNSPECIFIED_NIC_TYPE = 0;</code>
     */
    UNSPECIFIED_NIC_TYPE(0),
    /**
     *
     *
     * <pre>
     * VIRTIO. Default in Notebooks DLVM.
     * </pre>
     *
     * <code>VIRTIO_NET = 1;</code>
     */
    VIRTIO_NET(1),
    /**
     *
     *
     * <pre>
     * GVNIC. Alternative to VIRTIO.
     * https://github.com/GoogleCloudPlatform/compute-virtual-ethernet-linux
     * </pre>
     *
     * <code>GVNIC = 2;</code>
     */
    GVNIC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No type specified. Default should be UNSPECIFIED_NIC_TYPE.
     * </pre>
     *
     * <code>UNSPECIFIED_NIC_TYPE = 0;</code>
     */
    public static final int UNSPECIFIED_NIC_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * VIRTIO. Default in Notebooks DLVM.
     * </pre>
     *
     * <code>VIRTIO_NET = 1;</code>
     */
    public static final int VIRTIO_NET_VALUE = 1;
    /**
     *
     *
     * <pre>
     * GVNIC. Alternative to VIRTIO.
     * https://github.com/GoogleCloudPlatform/compute-virtual-ethernet-linux
     * </pre>
     *
     * <code>GVNIC = 2;</code>
     */
    public static final int GVNIC_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NicType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NicType forNumber(int value) {
      switch (value) {
        case 0:
          return UNSPECIFIED_NIC_TYPE;
        case 1:
          return VIRTIO_NET;
        case 2:
          return GVNIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NicType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NicType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NicType>() {
          public NicType findValueByNumber(int number) {
            return NicType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.Instance.getDescriptor().getEnumTypes().get(4);
    }

    private static final NicType[] VALUES = values();

    public static NicType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NicType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v1beta1.Instance.NicType)
  }

  public interface AcceleratorConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of this accelerator.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Type of this accelerator.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
     *
     * @return The type.
     */
    com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType getType();

    /**
     *
     *
     * <pre>
     * Count of cores of this accelerator.
     * </pre>
     *
     * <code>int64 core_count = 2;</code>
     *
     * @return The coreCount.
     */
    long getCoreCount();
  }
  /**
   *
   *
   * <pre>
   * Definition of a hardware accelerator. Note that not all combinations
   * of `type` and `core_count` are valid. Check [GPUs on Compute
   * Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a
   * valid combination. TPUs are not supported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig}
   */
  public static final class AcceleratorConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig)
      AcceleratorConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AcceleratorConfig.newBuilder() to construct.
    private AcceleratorConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AcceleratorConfig() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AcceleratorConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.InstanceProto
          .internal_static_google_cloud_notebooks_v1beta1_Instance_AcceleratorConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v1beta1.InstanceProto
          .internal_static_google_cloud_notebooks_v1beta1_Instance_AcceleratorConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.class,
              com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Type of this accelerator.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Type of this accelerator.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType getType() {
      com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType result =
          com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType.forNumber(type_);
      return result == null
          ? com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType.UNRECOGNIZED
          : result;
    }

    public static final int CORE_COUNT_FIELD_NUMBER = 2;
    private long coreCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Count of cores of this accelerator.
     * </pre>
     *
     * <code>int64 core_count = 2;</code>
     *
     * @return The coreCount.
     */
    @java.lang.Override
    public long getCoreCount() {
      return coreCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType
              .ACCELERATOR_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      if (coreCount_ != 0L) {
        output.writeInt64(2, coreCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType
              .ACCELERATOR_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (coreCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, coreCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig other =
          (com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig) obj;

      if (type_ != other.type_) return false;
      if (getCoreCount() != other.getCoreCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + CORE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCoreCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Definition of a hardware accelerator. Note that not all combinations
     * of `type` and `core_count` are valid. Check [GPUs on Compute
     * Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a
     * valid combination. TPUs are not supported.
     * </pre>
     *
     * Protobuf type {@code google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig)
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.notebooks.v1beta1.InstanceProto
            .internal_static_google_cloud_notebooks_v1beta1_Instance_AcceleratorConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.notebooks.v1beta1.InstanceProto
            .internal_static_google_cloud_notebooks_v1beta1_Instance_AcceleratorConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.class,
                com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder.class);
      }

      // Construct using com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        coreCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.notebooks.v1beta1.InstanceProto
            .internal_static_google_cloud_notebooks_v1beta1_Instance_AcceleratorConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
          getDefaultInstanceForType() {
        return com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig build() {
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig buildPartial() {
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig result =
            new com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.coreCount_ = coreCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig) {
          return mergeFrom((com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig other) {
        if (other
            == com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getCoreCount() != 0L) {
          setCoreCount(other.getCoreCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  coreCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Type of this accelerator.
       * </pre>
       *
       * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Type of this accelerator.
       * </pre>
       *
       * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of this accelerator.
       * </pre>
       *
       * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType getType() {
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType result =
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType.forNumber(type_);
        return result == null
            ? com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Type of this accelerator.
       * </pre>
       *
       * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.notebooks.v1beta1.Instance.AcceleratorType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of this accelerator.
       * </pre>
       *
       * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorType type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private long coreCount_;
      /**
       *
       *
       * <pre>
       * Count of cores of this accelerator.
       * </pre>
       *
       * <code>int64 core_count = 2;</code>
       *
       * @return The coreCount.
       */
      @java.lang.Override
      public long getCoreCount() {
        return coreCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of cores of this accelerator.
       * </pre>
       *
       * <code>int64 core_count = 2;</code>
       *
       * @param value The coreCount to set.
       * @return This builder for chaining.
       */
      public Builder setCoreCount(long value) {

        coreCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of cores of this accelerator.
       * </pre>
       *
       * <code>int64 core_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCoreCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        coreCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig)
    private static final com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig();
    }

    public static com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AcceleratorConfig> PARSER =
        new com.google.protobuf.AbstractParser<AcceleratorConfig>() {
          @java.lang.Override
          public AcceleratorConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AcceleratorConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AcceleratorConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int environmentCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object environment_;

  public enum EnvironmentCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VM_IMAGE(2),
    CONTAINER_IMAGE(3),
    ENVIRONMENT_NOT_SET(0);
    private final int value;

    private EnvironmentCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnvironmentCase valueOf(int value) {
      return forNumber(value);
    }

    public static EnvironmentCase forNumber(int value) {
      switch (value) {
        case 2:
          return VM_IMAGE;
        case 3:
          return CONTAINER_IMAGE;
        case 0:
          return ENVIRONMENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EnvironmentCase getEnvironmentCase() {
    return EnvironmentCase.forNumber(environmentCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of this notebook instance. Format:
   * `projects/{project_id}/locations/{location}/instances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of this notebook instance. Format:
   * `projects/{project_id}/locations/{location}/instances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_IMAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
   *
   * @return Whether the vmImage field is set.
   */
  @java.lang.Override
  public boolean hasVmImage() {
    return environmentCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
   *
   * @return The vmImage.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.VmImage getVmImage() {
    if (environmentCase_ == 2) {
      return (com.google.cloud.notebooks.v1beta1.VmImage) environment_;
    }
    return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.VmImageOrBuilder getVmImageOrBuilder() {
    if (environmentCase_ == 2) {
      return (com.google.cloud.notebooks.v1beta1.VmImage) environment_;
    }
    return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
  }

  public static final int CONTAINER_IMAGE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
   *
   * @return Whether the containerImage field is set.
   */
  @java.lang.Override
  public boolean hasContainerImage() {
    return environmentCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
   *
   * @return The containerImage.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.ContainerImage getContainerImage() {
    if (environmentCase_ == 3) {
      return (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_;
    }
    return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder getContainerImageOrBuilder() {
    if (environmentCase_ == 3) {
      return (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_;
    }
    return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
  }

  public static final int POST_STARTUP_SCRIPT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postStartupScript_ = "";
  /**
   *
   *
   * <pre>
   * Path to a Bash script that automatically runs after a notebook instance
   * fully boots up. The path must be a URL or
   * Cloud Storage path (`gs://path-to-file/file-name`).
   * </pre>
   *
   * <code>string post_startup_script = 4;</code>
   *
   * @return The postStartupScript.
   */
  @java.lang.Override
  public java.lang.String getPostStartupScript() {
    java.lang.Object ref = postStartupScript_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postStartupScript_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path to a Bash script that automatically runs after a notebook instance
   * fully boots up. The path must be a URL or
   * Cloud Storage path (`gs://path-to-file/file-name`).
   * </pre>
   *
   * <code>string post_startup_script = 4;</code>
   *
   * @return The bytes for postStartupScript.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPostStartupScriptBytes() {
    java.lang.Object ref = postStartupScript_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postStartupScript_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROXY_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object proxyUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The proxy endpoint that is used to access the Jupyter notebook.
   * </pre>
   *
   * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The proxyUri.
   */
  @java.lang.Override
  public java.lang.String getProxyUri() {
    java.lang.Object ref = proxyUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      proxyUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The proxy endpoint that is used to access the Jupyter notebook.
   * </pre>
   *
   * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for proxyUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProxyUriBytes() {
    java.lang.Object ref = proxyUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      proxyUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_OWNERS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instanceOwners_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return A list containing the instanceOwners.
   */
  public com.google.protobuf.ProtocolStringList getInstanceOwnersList() {
    return instanceOwners_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The count of instanceOwners.
   */
  public int getInstanceOwnersCount() {
    return instanceOwners_.size();
  }
  /**
   *
   *
   * <pre>
   * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The instanceOwners at the given index.
   */
  public java.lang.String getInstanceOwners(int index) {
    return instanceOwners_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instanceOwners at the given index.
   */
  public com.google.protobuf.ByteString getInstanceOwnersBytes(int index) {
    return instanceOwners_.getByteString(index);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The service account on this instance, giving access to other Google
   * Cloud services.
   * You can use any service account within the same project, but you
   * must have the service account user permission to use the instance.
   *
   * If not specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used.
   * </pre>
   *
   * <code>string service_account = 7;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account on this instance, giving access to other Google
   * Cloud services.
   * You can use any service account within the same project, but you
   * must have the service account user permission to use the instance.
   *
   * If not specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used.
   * </pre>
   *
   * <code>string service_account = 7;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * Required. The [Compute Engine machine
   * type](https://cloud.google.com/compute/docs/machine-types) of this
   * instance.
   * </pre>
   *
   * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The [Compute Engine machine
   * type](https://cloud.google.com/compute/docs/machine-types) of this
   * instance.
   * </pre>
   *
   * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCELERATOR_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig acceleratorConfig_;
  /**
   *
   *
   * <pre>
   * The hardware accelerator used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;</code>
   *
   * @return Whether the acceleratorConfig field is set.
   */
  @java.lang.Override
  public boolean hasAcceleratorConfig() {
    return acceleratorConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The hardware accelerator used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;</code>
   *
   * @return The acceleratorConfig.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig getAcceleratorConfig() {
    return acceleratorConfig_ == null
        ? com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.getDefaultInstance()
        : acceleratorConfig_;
  }
  /**
   *
   *
   * <pre>
   * The hardware accelerator used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * </pre>
   *
   * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfigOrBuilder
      getAcceleratorConfigOrBuilder() {
    return acceleratorConfig_ == null
        ? com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.getDefaultInstance()
        : acceleratorConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.State getState() {
    com.google.cloud.notebooks.v1beta1.Instance.State result =
        com.google.cloud.notebooks.v1beta1.Instance.State.forNumber(state_);
    return result == null ? com.google.cloud.notebooks.v1beta1.Instance.State.UNRECOGNIZED : result;
  }

  public static final int INSTALL_GPU_DRIVER_FIELD_NUMBER = 11;
  private boolean installGpuDriver_ = false;
  /**
   *
   *
   * <pre>
   * Whether the end user authorizes Google Cloud to install GPU driver
   * on this instance.
   * If this field is empty or set to false, the GPU driver won't be installed.
   * Only applicable to instances with GPUs.
   * </pre>
   *
   * <code>bool install_gpu_driver = 11;</code>
   *
   * @return The installGpuDriver.
   */
  @java.lang.Override
  public boolean getInstallGpuDriver() {
    return installGpuDriver_;
  }

  public static final int CUSTOM_GPU_DRIVER_PATH_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customGpuDriverPath_ = "";
  /**
   *
   *
   * <pre>
   * Specify a custom Cloud Storage path where the GPU driver is stored.
   * If not specified, we'll automatically choose from official GPU drivers.
   * </pre>
   *
   * <code>string custom_gpu_driver_path = 12;</code>
   *
   * @return The customGpuDriverPath.
   */
  @java.lang.Override
  public java.lang.String getCustomGpuDriverPath() {
    java.lang.Object ref = customGpuDriverPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customGpuDriverPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specify a custom Cloud Storage path where the GPU driver is stored.
   * If not specified, we'll automatically choose from official GPU drivers.
   * </pre>
   *
   * <code>string custom_gpu_driver_path = 12;</code>
   *
   * @return The bytes for customGpuDriverPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomGpuDriverPathBytes() {
    java.lang.Object ref = customGpuDriverPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customGpuDriverPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOOT_DISK_TYPE_FIELD_NUMBER = 13;
  private int bootDiskType_ = 0;
  /**
   *
   *
   * <pre>
   * Input only. The type of the boot disk attached to this instance, defaults to
   * standard persistent disk (`PD_STANDARD`).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for bootDiskType.
   */
  @java.lang.Override
  public int getBootDiskTypeValue() {
    return bootDiskType_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The type of the boot disk attached to this instance, defaults to
   * standard persistent disk (`PD_STANDARD`).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The bootDiskType.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.DiskType getBootDiskType() {
    com.google.cloud.notebooks.v1beta1.Instance.DiskType result =
        com.google.cloud.notebooks.v1beta1.Instance.DiskType.forNumber(bootDiskType_);
    return result == null
        ? com.google.cloud.notebooks.v1beta1.Instance.DiskType.UNRECOGNIZED
        : result;
  }

  public static final int BOOT_DISK_SIZE_GB_FIELD_NUMBER = 14;
  private long bootDiskSizeGb_ = 0L;
  /**
   *
   *
   * <pre>
   * Input only. The size of the boot disk in GB attached to this instance, up to a maximum
   * of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not
   * specified, this defaults to 100.
   * </pre>
   *
   * <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bootDiskSizeGb.
   */
  @java.lang.Override
  public long getBootDiskSizeGb() {
    return bootDiskSizeGb_;
  }

  public static final int DATA_DISK_TYPE_FIELD_NUMBER = 25;
  private int dataDiskType_ = 0;
  /**
   *
   *
   * <pre>
   * Input only. The type of the data disk attached to this instance, defaults to
   * standard persistent disk (`PD_STANDARD`).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for dataDiskType.
   */
  @java.lang.Override
  public int getDataDiskTypeValue() {
    return dataDiskType_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The type of the data disk attached to this instance, defaults to
   * standard persistent disk (`PD_STANDARD`).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The dataDiskType.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.DiskType getDataDiskType() {
    com.google.cloud.notebooks.v1beta1.Instance.DiskType result =
        com.google.cloud.notebooks.v1beta1.Instance.DiskType.forNumber(dataDiskType_);
    return result == null
        ? com.google.cloud.notebooks.v1beta1.Instance.DiskType.UNRECOGNIZED
        : result;
  }

  public static final int DATA_DISK_SIZE_GB_FIELD_NUMBER = 26;
  private long dataDiskSizeGb_ = 0L;
  /**
   *
   *
   * <pre>
   * Input only. The size of the data disk in GB attached to this instance, up to a maximum
   * of 64000 GB (64 TB). You can choose the size of the data disk based on how
   * big your notebooks and data are. If not specified, this defaults to 100.
   * </pre>
   *
   * <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The dataDiskSizeGb.
   */
  @java.lang.Override
  public long getDataDiskSizeGb() {
    return dataDiskSizeGb_;
  }

  public static final int NO_REMOVE_DATA_DISK_FIELD_NUMBER = 27;
  private boolean noRemoveDataDisk_ = false;
  /**
   *
   *
   * <pre>
   * Input only. If true, the data disk will not be auto deleted when deleting the instance.
   * </pre>
   *
   * <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The noRemoveDataDisk.
   */
  @java.lang.Override
  public boolean getNoRemoveDataDisk() {
    return noRemoveDataDisk_;
  }

  public static final int DISK_ENCRYPTION_FIELD_NUMBER = 15;
  private int diskEncryption_ = 0;
  /**
   *
   *
   * <pre>
   * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for diskEncryption.
   */
  @java.lang.Override
  public int getDiskEncryptionValue() {
    return diskEncryption_;
  }
  /**
   *
   *
   * <pre>
   * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The diskEncryption.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption getDiskEncryption() {
    com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption result =
        com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption.forNumber(diskEncryption_);
    return result == null
        ? com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption.UNRECOGNIZED
        : result;
  }

  public static final int KMS_KEY_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
   * is CMEK.
   * Format:
   * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
   *
   * Learn more about [using your own encryption
   * keys](https://cloud.google.com/kms/docs/quickstart).
   * </pre>
   *
   * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
   * is CMEK.
   * Format:
   * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
   *
   * Learn more about [using your own encryption
   * keys](https://cloud.google.com/kms/docs/quickstart).
   * </pre>
   *
   * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NO_PUBLIC_IP_FIELD_NUMBER = 17;
  private boolean noPublicIp_ = false;
  /**
   *
   *
   * <pre>
   * If true, no public IP will be assigned to this instance.
   * </pre>
   *
   * <code>bool no_public_ip = 17;</code>
   *
   * @return The noPublicIp.
   */
  @java.lang.Override
  public boolean getNoPublicIp() {
    return noPublicIp_;
  }

  public static final int NO_PROXY_ACCESS_FIELD_NUMBER = 18;
  private boolean noProxyAccess_ = false;
  /**
   *
   *
   * <pre>
   * If true, the notebook instance will not register with the proxy.
   * </pre>
   *
   * <code>bool no_proxy_access = 18;</code>
   *
   * @return The noProxyAccess.
   */
  @java.lang.Override
  public boolean getNoProxyAccess() {
    return noProxyAccess_;
  }

  public static final int NETWORK_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * The name of the VPC that this instance is in.
   * Format:
   * `projects/{project_id}/global/networks/{network_id}`
   * </pre>
   *
   * <code>string network = 19;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the VPC that this instance is in.
   * Format:
   * `projects/{project_id}/global/networks/{network_id}`
   * </pre>
   *
   * <code>string network = 19;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNET_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnet_ = "";
  /**
   *
   *
   * <pre>
   * The name of the subnet that this instance is in.
   * Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * </pre>
   *
   * <code>string subnet = 20;</code>
   *
   * @return The subnet.
   */
  @java.lang.Override
  public java.lang.String getSubnet() {
    java.lang.Object ref = subnet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the subnet that this instance is in.
   * Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * </pre>
   *
   * <code>string subnet = 20;</code>
   *
   * @return The bytes for subnet.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetBytes() {
    java.lang.Object ref = subnet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 21;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.notebooks.v1beta1.InstanceProto
                .internal_static_google_cloud_notebooks_v1beta1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance.
   * These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 21;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance.
   * These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 21;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance.
   * These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 21;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this instance.
   * These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 21;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int METADATA_FIELD_NUMBER = 22;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.notebooks.v1beta1.InstanceProto
                .internal_static_google_cloud_notebooks_v1beta1_Instance_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22;</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NIC_TYPE_FIELD_NUMBER = 28;
  private int nicType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
   * VirtioNet.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for nicType.
   */
  @java.lang.Override
  public int getNicTypeValue() {
    return nicType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
   * VirtioNet.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nicType.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance.NicType getNicType() {
    com.google.cloud.notebooks.v1beta1.Instance.NicType result =
        com.google.cloud.notebooks.v1beta1.Instance.NicType.forNumber(nicType_);
    return result == null
        ? com.google.cloud.notebooks.v1beta1.Instance.NicType.UNRECOGNIZED
        : result;
  }

  public static final int RESERVATION_AFFINITY_FIELD_NUMBER = 29;
  private com.google.cloud.notebooks.v1beta1.ReservationAffinity reservationAffinity_;
  /**
   *
   *
   * <pre>
   * Optional. The optional reservation affinity. Setting this field will apply
   * the specified [Zonal Compute
   * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
   * to this notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the reservationAffinity field is set.
   */
  @java.lang.Override
  public boolean hasReservationAffinity() {
    return reservationAffinity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The optional reservation affinity. Setting this field will apply
   * the specified [Zonal Compute
   * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
   * to this notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The reservationAffinity.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.ReservationAffinity getReservationAffinity() {
    return reservationAffinity_ == null
        ? com.google.cloud.notebooks.v1beta1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The optional reservation affinity. Setting this field will apply
   * the specified [Zonal Compute
   * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
   * to this notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.ReservationAffinityOrBuilder
      getReservationAffinityOrBuilder() {
    return reservationAffinity_ == null
        ? com.google.cloud.notebooks.v1beta1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }

  public static final int CAN_IP_FORWARD_FIELD_NUMBER = 31;
  private boolean canIpForward_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Flag to enable ip forwarding or not, default false/off.
   * https://cloud.google.com/vpc/docs/using-routes#canipforward
   * </pre>
   *
   * <code>bool can_ip_forward = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The canIpForward.
   */
  @java.lang.Override
  public boolean getCanIpForward() {
    return canIpForward_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 23;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Instance creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 24;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Instance update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (environmentCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.notebooks.v1beta1.VmImage) environment_);
    }
    if (environmentCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postStartupScript_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, postStartupScript_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(proxyUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, proxyUri_);
    }
    for (int i = 0; i < instanceOwners_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, instanceOwners_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, machineType_);
    }
    if (acceleratorConfig_ != null) {
      output.writeMessage(9, getAcceleratorConfig());
    }
    if (state_ != com.google.cloud.notebooks.v1beta1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (installGpuDriver_ != false) {
      output.writeBool(11, installGpuDriver_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customGpuDriverPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, customGpuDriverPath_);
    }
    if (bootDiskType_
        != com.google.cloud.notebooks.v1beta1.Instance.DiskType.DISK_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, bootDiskType_);
    }
    if (bootDiskSizeGb_ != 0L) {
      output.writeInt64(14, bootDiskSizeGb_);
    }
    if (diskEncryption_
        != com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption.DISK_ENCRYPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, diskEncryption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, kmsKey_);
    }
    if (noPublicIp_ != false) {
      output.writeBool(17, noPublicIp_);
    }
    if (noProxyAccess_ != false) {
      output.writeBool(18, noProxyAccess_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnet_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, subnet_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 21);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 22);
    if (createTime_ != null) {
      output.writeMessage(23, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(24, getUpdateTime());
    }
    if (dataDiskType_
        != com.google.cloud.notebooks.v1beta1.Instance.DiskType.DISK_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(25, dataDiskType_);
    }
    if (dataDiskSizeGb_ != 0L) {
      output.writeInt64(26, dataDiskSizeGb_);
    }
    if (noRemoveDataDisk_ != false) {
      output.writeBool(27, noRemoveDataDisk_);
    }
    if (nicType_
        != com.google.cloud.notebooks.v1beta1.Instance.NicType.UNSPECIFIED_NIC_TYPE.getNumber()) {
      output.writeEnum(28, nicType_);
    }
    if (reservationAffinity_ != null) {
      output.writeMessage(29, getReservationAffinity());
    }
    if (canIpForward_ != false) {
      output.writeBool(31, canIpForward_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (environmentCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.notebooks.v1beta1.VmImage) environment_);
    }
    if (environmentCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postStartupScript_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, postStartupScript_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(proxyUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, proxyUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceOwners_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceOwners_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInstanceOwnersList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, machineType_);
    }
    if (acceleratorConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getAcceleratorConfig());
    }
    if (state_ != com.google.cloud.notebooks.v1beta1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (installGpuDriver_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, installGpuDriver_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customGpuDriverPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, customGpuDriverPath_);
    }
    if (bootDiskType_
        != com.google.cloud.notebooks.v1beta1.Instance.DiskType.DISK_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, bootDiskType_);
    }
    if (bootDiskSizeGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(14, bootDiskSizeGb_);
    }
    if (diskEncryption_
        != com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption.DISK_ENCRYPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, diskEncryption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, kmsKey_);
    }
    if (noPublicIp_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(17, noPublicIp_);
    }
    if (noProxyAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, noProxyAccess_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnet_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, subnet_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, metadata__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getUpdateTime());
    }
    if (dataDiskType_
        != com.google.cloud.notebooks.v1beta1.Instance.DiskType.DISK_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(25, dataDiskType_);
    }
    if (dataDiskSizeGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(26, dataDiskSizeGb_);
    }
    if (noRemoveDataDisk_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(27, noRemoveDataDisk_);
    }
    if (nicType_
        != com.google.cloud.notebooks.v1beta1.Instance.NicType.UNSPECIFIED_NIC_TYPE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(28, nicType_);
    }
    if (reservationAffinity_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(29, getReservationAffinity());
    }
    if (canIpForward_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(31, canIpForward_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v1beta1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v1beta1.Instance other =
        (com.google.cloud.notebooks.v1beta1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getPostStartupScript().equals(other.getPostStartupScript())) return false;
    if (!getProxyUri().equals(other.getProxyUri())) return false;
    if (!getInstanceOwnersList().equals(other.getInstanceOwnersList())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getMachineType().equals(other.getMachineType())) return false;
    if (hasAcceleratorConfig() != other.hasAcceleratorConfig()) return false;
    if (hasAcceleratorConfig()) {
      if (!getAcceleratorConfig().equals(other.getAcceleratorConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (getInstallGpuDriver() != other.getInstallGpuDriver()) return false;
    if (!getCustomGpuDriverPath().equals(other.getCustomGpuDriverPath())) return false;
    if (bootDiskType_ != other.bootDiskType_) return false;
    if (getBootDiskSizeGb() != other.getBootDiskSizeGb()) return false;
    if (dataDiskType_ != other.dataDiskType_) return false;
    if (getDataDiskSizeGb() != other.getDataDiskSizeGb()) return false;
    if (getNoRemoveDataDisk() != other.getNoRemoveDataDisk()) return false;
    if (diskEncryption_ != other.diskEncryption_) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (getNoPublicIp() != other.getNoPublicIp()) return false;
    if (getNoProxyAccess() != other.getNoProxyAccess()) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getSubnet().equals(other.getSubnet())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (nicType_ != other.nicType_) return false;
    if (hasReservationAffinity() != other.hasReservationAffinity()) return false;
    if (hasReservationAffinity()) {
      if (!getReservationAffinity().equals(other.getReservationAffinity())) return false;
    }
    if (getCanIpForward() != other.getCanIpForward()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEnvironmentCase().equals(other.getEnvironmentCase())) return false;
    switch (environmentCase_) {
      case 2:
        if (!getVmImage().equals(other.getVmImage())) return false;
        break;
      case 3:
        if (!getContainerImage().equals(other.getContainerImage())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + POST_STARTUP_SCRIPT_FIELD_NUMBER;
    hash = (53 * hash) + getPostStartupScript().hashCode();
    hash = (37 * hash) + PROXY_URI_FIELD_NUMBER;
    hash = (53 * hash) + getProxyUri().hashCode();
    if (getInstanceOwnersCount() > 0) {
      hash = (37 * hash) + INSTANCE_OWNERS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceOwnersList().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    if (hasAcceleratorConfig()) {
      hash = (37 * hash) + ACCELERATOR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + INSTALL_GPU_DRIVER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInstallGpuDriver());
    hash = (37 * hash) + CUSTOM_GPU_DRIVER_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getCustomGpuDriverPath().hashCode();
    hash = (37 * hash) + BOOT_DISK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + bootDiskType_;
    hash = (37 * hash) + BOOT_DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getBootDiskSizeGb());
    hash = (37 * hash) + DATA_DISK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataDiskType_;
    hash = (37 * hash) + DATA_DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDataDiskSizeGb());
    hash = (37 * hash) + NO_REMOVE_DATA_DISK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoRemoveDataDisk());
    hash = (37 * hash) + DISK_ENCRYPTION_FIELD_NUMBER;
    hash = (53 * hash) + diskEncryption_;
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    hash = (37 * hash) + NO_PUBLIC_IP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoPublicIp());
    hash = (37 * hash) + NO_PROXY_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoProxyAccess());
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + SUBNET_FIELD_NUMBER;
    hash = (53 * hash) + getSubnet().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    hash = (37 * hash) + NIC_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + nicType_;
    if (hasReservationAffinity()) {
      hash = (37 * hash) + RESERVATION_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getReservationAffinity().hashCode();
    }
    hash = (37 * hash) + CAN_IP_FORWARD_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCanIpForward());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (environmentCase_) {
      case 2:
        hash = (37 * hash) + VM_IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getVmImage().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CONTAINER_IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getContainerImage().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v1beta1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of a notebook instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v1beta1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v1beta1.Instance)
      com.google.cloud.notebooks.v1beta1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.InstanceProto
          .internal_static_google_cloud_notebooks_v1beta1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 21:
          return internalGetLabels();
        case 22:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 21:
          return internalGetMutableLabels();
        case 22:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v1beta1.InstanceProto
          .internal_static_google_cloud_notebooks_v1beta1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v1beta1.Instance.class,
              com.google.cloud.notebooks.v1beta1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v1beta1.Instance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (vmImageBuilder_ != null) {
        vmImageBuilder_.clear();
      }
      if (containerImageBuilder_ != null) {
        containerImageBuilder_.clear();
      }
      postStartupScript_ = "";
      proxyUri_ = "";
      instanceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceAccount_ = "";
      machineType_ = "";
      acceleratorConfig_ = null;
      if (acceleratorConfigBuilder_ != null) {
        acceleratorConfigBuilder_.dispose();
        acceleratorConfigBuilder_ = null;
      }
      state_ = 0;
      installGpuDriver_ = false;
      customGpuDriverPath_ = "";
      bootDiskType_ = 0;
      bootDiskSizeGb_ = 0L;
      dataDiskType_ = 0;
      dataDiskSizeGb_ = 0L;
      noRemoveDataDisk_ = false;
      diskEncryption_ = 0;
      kmsKey_ = "";
      noPublicIp_ = false;
      noProxyAccess_ = false;
      network_ = "";
      subnet_ = "";
      internalGetMutableLabels().clear();
      internalGetMutableMetadata().clear();
      nicType_ = 0;
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      canIpForward_ = false;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      environmentCase_ = 0;
      environment_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v1beta1.InstanceProto
          .internal_static_google_cloud_notebooks_v1beta1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v1beta1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance build() {
      com.google.cloud.notebooks.v1beta1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance buildPartial() {
      com.google.cloud.notebooks.v1beta1.Instance result =
          new com.google.cloud.notebooks.v1beta1.Instance(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.notebooks.v1beta1.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.postStartupScript_ = postStartupScript_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.proxyUri_ = proxyUri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        instanceOwners_.makeImmutable();
        result.instanceOwners_ = instanceOwners_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.machineType_ = machineType_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.acceleratorConfig_ =
            acceleratorConfigBuilder_ == null
                ? acceleratorConfig_
                : acceleratorConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.installGpuDriver_ = installGpuDriver_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.customGpuDriverPath_ = customGpuDriverPath_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.bootDiskType_ = bootDiskType_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.bootDiskSizeGb_ = bootDiskSizeGb_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.dataDiskType_ = dataDiskType_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.dataDiskSizeGb_ = dataDiskSizeGb_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.noRemoveDataDisk_ = noRemoveDataDisk_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.diskEncryption_ = diskEncryption_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.noPublicIp_ = noPublicIp_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.noProxyAccess_ = noProxyAccess_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.subnet_ = subnet_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.nicType_ = nicType_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.reservationAffinity_ =
            reservationAffinityBuilder_ == null
                ? reservationAffinity_
                : reservationAffinityBuilder_.build();
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.canIpForward_ = canIpForward_;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.notebooks.v1beta1.Instance result) {
      result.environmentCase_ = environmentCase_;
      result.environment_ = this.environment_;
      if (environmentCase_ == 2 && vmImageBuilder_ != null) {
        result.environment_ = vmImageBuilder_.build();
      }
      if (environmentCase_ == 3 && containerImageBuilder_ != null) {
        result.environment_ = containerImageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v1beta1.Instance) {
        return mergeFrom((com.google.cloud.notebooks.v1beta1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v1beta1.Instance other) {
      if (other == com.google.cloud.notebooks.v1beta1.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPostStartupScript().isEmpty()) {
        postStartupScript_ = other.postStartupScript_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getProxyUri().isEmpty()) {
        proxyUri_ = other.proxyUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.instanceOwners_.isEmpty()) {
        if (instanceOwners_.isEmpty()) {
          instanceOwners_ = other.instanceOwners_;
          bitField0_ |= 0x00000020;
        } else {
          ensureInstanceOwnersIsMutable();
          instanceOwners_.addAll(other.instanceOwners_);
        }
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasAcceleratorConfig()) {
        mergeAcceleratorConfig(other.getAcceleratorConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getInstallGpuDriver() != false) {
        setInstallGpuDriver(other.getInstallGpuDriver());
      }
      if (!other.getCustomGpuDriverPath().isEmpty()) {
        customGpuDriverPath_ = other.customGpuDriverPath_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.bootDiskType_ != 0) {
        setBootDiskTypeValue(other.getBootDiskTypeValue());
      }
      if (other.getBootDiskSizeGb() != 0L) {
        setBootDiskSizeGb(other.getBootDiskSizeGb());
      }
      if (other.dataDiskType_ != 0) {
        setDataDiskTypeValue(other.getDataDiskTypeValue());
      }
      if (other.getDataDiskSizeGb() != 0L) {
        setDataDiskSizeGb(other.getDataDiskSizeGb());
      }
      if (other.getNoRemoveDataDisk() != false) {
        setNoRemoveDataDisk(other.getNoRemoveDataDisk());
      }
      if (other.diskEncryption_ != 0) {
        setDiskEncryptionValue(other.getDiskEncryptionValue());
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.getNoPublicIp() != false) {
        setNoPublicIp(other.getNoPublicIp());
      }
      if (other.getNoProxyAccess() != false) {
        setNoProxyAccess(other.getNoProxyAccess());
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (!other.getSubnet().isEmpty()) {
        subnet_ = other.subnet_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00800000;
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x01000000;
      if (other.nicType_ != 0) {
        setNicTypeValue(other.getNicTypeValue());
      }
      if (other.hasReservationAffinity()) {
        mergeReservationAffinity(other.getReservationAffinity());
      }
      if (other.getCanIpForward() != false) {
        setCanIpForward(other.getCanIpForward());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getEnvironmentCase()) {
        case VM_IMAGE:
          {
            mergeVmImage(other.getVmImage());
            break;
          }
        case CONTAINER_IMAGE:
          {
            mergeContainerImage(other.getContainerImage());
            break;
          }
        case ENVIRONMENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getVmImageFieldBuilder().getBuilder(), extensionRegistry);
                environmentCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getContainerImageFieldBuilder().getBuilder(), extensionRegistry);
                environmentCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                postStartupScript_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                proxyUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceOwnersIsMutable();
                instanceOwners_.add(s);
                break;
              } // case 50
            case 58:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getAcceleratorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                installGpuDriver_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                customGpuDriverPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                bootDiskType_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 112:
              {
                bootDiskSizeGb_ = input.readInt64();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 120:
              {
                diskEncryption_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 120
            case 130:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 130
            case 136:
              {
                noPublicIp_ = input.readBool();
                bitField0_ |= 0x00080000;
                break;
              } // case 136
            case 144:
              {
                noProxyAccess_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 144
            case 154:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 154
            case 162:
              {
                subnet_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 162
            case 170:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00800000;
                break;
              } // case 170
            case 178:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x01000000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 194
            case 200:
              {
                dataDiskType_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 200
            case 208:
              {
                dataDiskSizeGb_ = input.readInt64();
                bitField0_ |= 0x00008000;
                break;
              } // case 208
            case 216:
              {
                noRemoveDataDisk_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 216
            case 224:
              {
                nicType_ = input.readEnum();
                bitField0_ |= 0x02000000;
                break;
              } // case 224
            case 234:
              {
                input.readMessage(
                    getReservationAffinityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 234
            case 248:
              {
                canIpForward_ = input.readBool();
                bitField0_ |= 0x08000000;
                break;
              } // case 248
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int environmentCase_ = 0;
    private java.lang.Object environment_;

    public EnvironmentCase getEnvironmentCase() {
      return EnvironmentCase.forNumber(environmentCase_);
    }

    public Builder clearEnvironment() {
      environmentCase_ = 0;
      environment_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.VmImage,
            com.google.cloud.notebooks.v1beta1.VmImage.Builder,
            com.google.cloud.notebooks.v1beta1.VmImageOrBuilder>
        vmImageBuilder_;
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     *
     * @return Whether the vmImage field is set.
     */
    @java.lang.Override
    public boolean hasVmImage() {
      return environmentCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     *
     * @return The vmImage.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.VmImage getVmImage() {
      if (vmImageBuilder_ == null) {
        if (environmentCase_ == 2) {
          return (com.google.cloud.notebooks.v1beta1.VmImage) environment_;
        }
        return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
      } else {
        if (environmentCase_ == 2) {
          return vmImageBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    public Builder setVmImage(com.google.cloud.notebooks.v1beta1.VmImage value) {
      if (vmImageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environment_ = value;
        onChanged();
      } else {
        vmImageBuilder_.setMessage(value);
      }
      environmentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    public Builder setVmImage(com.google.cloud.notebooks.v1beta1.VmImage.Builder builderForValue) {
      if (vmImageBuilder_ == null) {
        environment_ = builderForValue.build();
        onChanged();
      } else {
        vmImageBuilder_.setMessage(builderForValue.build());
      }
      environmentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    public Builder mergeVmImage(com.google.cloud.notebooks.v1beta1.VmImage value) {
      if (vmImageBuilder_ == null) {
        if (environmentCase_ == 2
            && environment_ != com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance()) {
          environment_ =
              com.google.cloud.notebooks.v1beta1.VmImage.newBuilder(
                      (com.google.cloud.notebooks.v1beta1.VmImage) environment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          environment_ = value;
        }
        onChanged();
      } else {
        if (environmentCase_ == 2) {
          vmImageBuilder_.mergeFrom(value);
        } else {
          vmImageBuilder_.setMessage(value);
        }
      }
      environmentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    public Builder clearVmImage() {
      if (vmImageBuilder_ == null) {
        if (environmentCase_ == 2) {
          environmentCase_ = 0;
          environment_ = null;
          onChanged();
        }
      } else {
        if (environmentCase_ == 2) {
          environmentCase_ = 0;
          environment_ = null;
        }
        vmImageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    public com.google.cloud.notebooks.v1beta1.VmImage.Builder getVmImageBuilder() {
      return getVmImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.VmImageOrBuilder getVmImageOrBuilder() {
      if ((environmentCase_ == 2) && (vmImageBuilder_ != null)) {
        return vmImageBuilder_.getMessageOrBuilder();
      } else {
        if (environmentCase_ == 2) {
          return (com.google.cloud.notebooks.v1beta1.VmImage) environment_;
        }
        return com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.VmImage,
            com.google.cloud.notebooks.v1beta1.VmImage.Builder,
            com.google.cloud.notebooks.v1beta1.VmImageOrBuilder>
        getVmImageFieldBuilder() {
      if (vmImageBuilder_ == null) {
        if (!(environmentCase_ == 2)) {
          environment_ = com.google.cloud.notebooks.v1beta1.VmImage.getDefaultInstance();
        }
        vmImageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v1beta1.VmImage,
                com.google.cloud.notebooks.v1beta1.VmImage.Builder,
                com.google.cloud.notebooks.v1beta1.VmImageOrBuilder>(
                (com.google.cloud.notebooks.v1beta1.VmImage) environment_,
                getParentForChildren(),
                isClean());
        environment_ = null;
      }
      environmentCase_ = 2;
      onChanged();
      return vmImageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.ContainerImage,
            com.google.cloud.notebooks.v1beta1.ContainerImage.Builder,
            com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder>
        containerImageBuilder_;
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     *
     * @return Whether the containerImage field is set.
     */
    @java.lang.Override
    public boolean hasContainerImage() {
      return environmentCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     *
     * @return The containerImage.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.ContainerImage getContainerImage() {
      if (containerImageBuilder_ == null) {
        if (environmentCase_ == 3) {
          return (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_;
        }
        return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
      } else {
        if (environmentCase_ == 3) {
          return containerImageBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    public Builder setContainerImage(com.google.cloud.notebooks.v1beta1.ContainerImage value) {
      if (containerImageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environment_ = value;
        onChanged();
      } else {
        containerImageBuilder_.setMessage(value);
      }
      environmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    public Builder setContainerImage(
        com.google.cloud.notebooks.v1beta1.ContainerImage.Builder builderForValue) {
      if (containerImageBuilder_ == null) {
        environment_ = builderForValue.build();
        onChanged();
      } else {
        containerImageBuilder_.setMessage(builderForValue.build());
      }
      environmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    public Builder mergeContainerImage(com.google.cloud.notebooks.v1beta1.ContainerImage value) {
      if (containerImageBuilder_ == null) {
        if (environmentCase_ == 3
            && environment_
                != com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance()) {
          environment_ =
              com.google.cloud.notebooks.v1beta1.ContainerImage.newBuilder(
                      (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          environment_ = value;
        }
        onChanged();
      } else {
        if (environmentCase_ == 3) {
          containerImageBuilder_.mergeFrom(value);
        } else {
          containerImageBuilder_.setMessage(value);
        }
      }
      environmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    public Builder clearContainerImage() {
      if (containerImageBuilder_ == null) {
        if (environmentCase_ == 3) {
          environmentCase_ = 0;
          environment_ = null;
          onChanged();
        }
      } else {
        if (environmentCase_ == 3) {
          environmentCase_ = 0;
          environment_ = null;
        }
        containerImageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    public com.google.cloud.notebooks.v1beta1.ContainerImage.Builder getContainerImageBuilder() {
      return getContainerImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder getContainerImageOrBuilder() {
      if ((environmentCase_ == 3) && (containerImageBuilder_ != null)) {
        return containerImageBuilder_.getMessageOrBuilder();
      } else {
        if (environmentCase_ == 3) {
          return (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_;
        }
        return com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.ContainerImage,
            com.google.cloud.notebooks.v1beta1.ContainerImage.Builder,
            com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder>
        getContainerImageFieldBuilder() {
      if (containerImageBuilder_ == null) {
        if (!(environmentCase_ == 3)) {
          environment_ = com.google.cloud.notebooks.v1beta1.ContainerImage.getDefaultInstance();
        }
        containerImageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v1beta1.ContainerImage,
                com.google.cloud.notebooks.v1beta1.ContainerImage.Builder,
                com.google.cloud.notebooks.v1beta1.ContainerImageOrBuilder>(
                (com.google.cloud.notebooks.v1beta1.ContainerImage) environment_,
                getParentForChildren(),
                isClean());
        environment_ = null;
      }
      environmentCase_ = 3;
      onChanged();
      return containerImageBuilder_;
    }

    private java.lang.Object postStartupScript_ = "";
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     * </pre>
     *
     * <code>string post_startup_script = 4;</code>
     *
     * @return The postStartupScript.
     */
    public java.lang.String getPostStartupScript() {
      java.lang.Object ref = postStartupScript_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postStartupScript_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     * </pre>
     *
     * <code>string post_startup_script = 4;</code>
     *
     * @return The bytes for postStartupScript.
     */
    public com.google.protobuf.ByteString getPostStartupScriptBytes() {
      java.lang.Object ref = postStartupScript_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postStartupScript_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     * </pre>
     *
     * <code>string post_startup_script = 4;</code>
     *
     * @param value The postStartupScript to set.
     * @return This builder for chaining.
     */
    public Builder setPostStartupScript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postStartupScript_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     * </pre>
     *
     * <code>string post_startup_script = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostStartupScript() {
      postStartupScript_ = getDefaultInstance().getPostStartupScript();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     * </pre>
     *
     * <code>string post_startup_script = 4;</code>
     *
     * @param value The bytes for postStartupScript to set.
     * @return This builder for chaining.
     */
    public Builder setPostStartupScriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postStartupScript_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object proxyUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter notebook.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The proxyUri.
     */
    public java.lang.String getProxyUri() {
      java.lang.Object ref = proxyUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        proxyUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter notebook.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for proxyUri.
     */
    public com.google.protobuf.ByteString getProxyUriBytes() {
      java.lang.Object ref = proxyUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        proxyUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter notebook.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The proxyUri to set.
     * @return This builder for chaining.
     */
    public Builder setProxyUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      proxyUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter notebook.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProxyUri() {
      proxyUri_ = getDefaultInstance().getProxyUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter notebook.
     * </pre>
     *
     * <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for proxyUri to set.
     * @return This builder for chaining.
     */
    public Builder setProxyUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      proxyUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList instanceOwners_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstanceOwnersIsMutable() {
      if (!instanceOwners_.isModifiable()) {
        instanceOwners_ = new com.google.protobuf.LazyStringArrayList(instanceOwners_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return A list containing the instanceOwners.
     */
    public com.google.protobuf.ProtocolStringList getInstanceOwnersList() {
      instanceOwners_.makeImmutable();
      return instanceOwners_;
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The count of instanceOwners.
     */
    public int getInstanceOwnersCount() {
      return instanceOwners_.size();
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The instanceOwners at the given index.
     */
    public java.lang.String getInstanceOwners(int index) {
      return instanceOwners_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instanceOwners at the given index.
     */
    public com.google.protobuf.ByteString getInstanceOwnersBytes(int index) {
      return instanceOwners_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The instanceOwners to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceOwners(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceOwnersIsMutable();
      instanceOwners_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The instanceOwners to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceOwners(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceOwnersIsMutable();
      instanceOwners_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param values The instanceOwners to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstanceOwners(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceOwnersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceOwners_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceOwners() {
      instanceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The owner of this instance after creation. Format: `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes of the instanceOwners to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceOwnersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceOwnersIsMutable();
      instanceOwners_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     * </pre>
     *
     * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     * </pre>
     *
     * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     * </pre>
     *
     * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     * </pre>
     *
     * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     * </pre>
     *
     * <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig acceleratorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig,
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder,
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfigOrBuilder>
        acceleratorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     *
     * @return Whether the acceleratorConfig field is set.
     */
    public boolean hasAcceleratorConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     *
     * @return The acceleratorConfig.
     */
    public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig getAcceleratorConfig() {
      if (acceleratorConfigBuilder_ == null) {
        return acceleratorConfig_ == null
            ? com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.getDefaultInstance()
            : acceleratorConfig_;
      } else {
        return acceleratorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    public Builder setAcceleratorConfig(
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig value) {
      if (acceleratorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        acceleratorConfig_ = value;
      } else {
        acceleratorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    public Builder setAcceleratorConfig(
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorConfigBuilder_ == null) {
        acceleratorConfig_ = builderForValue.build();
      } else {
        acceleratorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    public Builder mergeAcceleratorConfig(
        com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig value) {
      if (acceleratorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && acceleratorConfig_ != null
            && acceleratorConfig_
                != com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
                    .getDefaultInstance()) {
          getAcceleratorConfigBuilder().mergeFrom(value);
        } else {
          acceleratorConfig_ = value;
        }
      } else {
        acceleratorConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    public Builder clearAcceleratorConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      acceleratorConfig_ = null;
      if (acceleratorConfigBuilder_ != null) {
        acceleratorConfigBuilder_.dispose();
        acceleratorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder
        getAcceleratorConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getAcceleratorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    public com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfigOrBuilder
        getAcceleratorConfigOrBuilder() {
      if (acceleratorConfigBuilder_ != null) {
        return acceleratorConfigBuilder_.getMessageOrBuilder();
      } else {
        return acceleratorConfig_ == null
            ? com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.getDefaultInstance()
            : acceleratorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * </pre>
     *
     * <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig,
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder,
            com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfigOrBuilder>
        getAcceleratorConfigFieldBuilder() {
      if (acceleratorConfigBuilder_ == null) {
        acceleratorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig,
                com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.Builder,
                com.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfigOrBuilder>(
                getAcceleratorConfig(), getParentForChildren(), isClean());
        acceleratorConfig_ = null;
      }
      return acceleratorConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.State getState() {
      com.google.cloud.notebooks.v1beta1.Instance.State result =
          com.google.cloud.notebooks.v1beta1.Instance.State.forNumber(state_);
      return result == null
          ? com.google.cloud.notebooks.v1beta1.Instance.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.notebooks.v1beta1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      state_ = 0;
      onChanged();
      return this;
    }

    private boolean installGpuDriver_;
    /**
     *
     *
     * <pre>
     * Whether the end user authorizes Google Cloud to install GPU driver
     * on this instance.
     * If this field is empty or set to false, the GPU driver won't be installed.
     * Only applicable to instances with GPUs.
     * </pre>
     *
     * <code>bool install_gpu_driver = 11;</code>
     *
     * @return The installGpuDriver.
     */
    @java.lang.Override
    public boolean getInstallGpuDriver() {
      return installGpuDriver_;
    }
    /**
     *
     *
     * <pre>
     * Whether the end user authorizes Google Cloud to install GPU driver
     * on this instance.
     * If this field is empty or set to false, the GPU driver won't be installed.
     * Only applicable to instances with GPUs.
     * </pre>
     *
     * <code>bool install_gpu_driver = 11;</code>
     *
     * @param value The installGpuDriver to set.
     * @return This builder for chaining.
     */
    public Builder setInstallGpuDriver(boolean value) {

      installGpuDriver_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the end user authorizes Google Cloud to install GPU driver
     * on this instance.
     * If this field is empty or set to false, the GPU driver won't be installed.
     * Only applicable to instances with GPUs.
     * </pre>
     *
     * <code>bool install_gpu_driver = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstallGpuDriver() {
      bitField0_ = (bitField0_ & ~0x00000400);
      installGpuDriver_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object customGpuDriverPath_ = "";
    /**
     *
     *
     * <pre>
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     * </pre>
     *
     * <code>string custom_gpu_driver_path = 12;</code>
     *
     * @return The customGpuDriverPath.
     */
    public java.lang.String getCustomGpuDriverPath() {
      java.lang.Object ref = customGpuDriverPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customGpuDriverPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     * </pre>
     *
     * <code>string custom_gpu_driver_path = 12;</code>
     *
     * @return The bytes for customGpuDriverPath.
     */
    public com.google.protobuf.ByteString getCustomGpuDriverPathBytes() {
      java.lang.Object ref = customGpuDriverPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customGpuDriverPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     * </pre>
     *
     * <code>string custom_gpu_driver_path = 12;</code>
     *
     * @param value The customGpuDriverPath to set.
     * @return This builder for chaining.
     */
    public Builder setCustomGpuDriverPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customGpuDriverPath_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     * </pre>
     *
     * <code>string custom_gpu_driver_path = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomGpuDriverPath() {
      customGpuDriverPath_ = getDefaultInstance().getCustomGpuDriverPath();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     * </pre>
     *
     * <code>string custom_gpu_driver_path = 12;</code>
     *
     * @param value The bytes for customGpuDriverPath to set.
     * @return This builder for chaining.
     */
    public Builder setCustomGpuDriverPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customGpuDriverPath_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int bootDiskType_ = 0;
    /**
     *
     *
     * <pre>
     * Input only. The type of the boot disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for bootDiskType.
     */
    @java.lang.Override
    public int getBootDiskTypeValue() {
      return bootDiskType_;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the boot disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for bootDiskType to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskTypeValue(int value) {
      bootDiskType_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the boot disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The bootDiskType.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.DiskType getBootDiskType() {
      com.google.cloud.notebooks.v1beta1.Instance.DiskType result =
          com.google.cloud.notebooks.v1beta1.Instance.DiskType.forNumber(bootDiskType_);
      return result == null
          ? com.google.cloud.notebooks.v1beta1.Instance.DiskType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the boot disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The bootDiskType to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskType(com.google.cloud.notebooks.v1beta1.Instance.DiskType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      bootDiskType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the boot disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBootDiskType() {
      bitField0_ = (bitField0_ & ~0x00001000);
      bootDiskType_ = 0;
      onChanged();
      return this;
    }

    private long bootDiskSizeGb_;
    /**
     *
     *
     * <pre>
     * Input only. The size of the boot disk in GB attached to this instance, up to a maximum
     * of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not
     * specified, this defaults to 100.
     * </pre>
     *
     * <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bootDiskSizeGb.
     */
    @java.lang.Override
    public long getBootDiskSizeGb() {
      return bootDiskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Input only. The size of the boot disk in GB attached to this instance, up to a maximum
     * of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not
     * specified, this defaults to 100.
     * </pre>
     *
     * <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bootDiskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskSizeGb(long value) {

      bootDiskSizeGb_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The size of the boot disk in GB attached to this instance, up to a maximum
     * of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not
     * specified, this defaults to 100.
     * </pre>
     *
     * <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBootDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00002000);
      bootDiskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private int dataDiskType_ = 0;
    /**
     *
     *
     * <pre>
     * Input only. The type of the data disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for dataDiskType.
     */
    @java.lang.Override
    public int getDataDiskTypeValue() {
      return dataDiskType_;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the data disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataDiskType to set.
     * @return This builder for chaining.
     */
    public Builder setDataDiskTypeValue(int value) {
      dataDiskType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the data disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The dataDiskType.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.DiskType getDataDiskType() {
      com.google.cloud.notebooks.v1beta1.Instance.DiskType result =
          com.google.cloud.notebooks.v1beta1.Instance.DiskType.forNumber(dataDiskType_);
      return result == null
          ? com.google.cloud.notebooks.v1beta1.Instance.DiskType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the data disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The dataDiskType to set.
     * @return This builder for chaining.
     */
    public Builder setDataDiskType(com.google.cloud.notebooks.v1beta1.Instance.DiskType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      dataDiskType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of the data disk attached to this instance, defaults to
     * standard persistent disk (`PD_STANDARD`).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataDiskType() {
      bitField0_ = (bitField0_ & ~0x00004000);
      dataDiskType_ = 0;
      onChanged();
      return this;
    }

    private long dataDiskSizeGb_;
    /**
     *
     *
     * <pre>
     * Input only. The size of the data disk in GB attached to this instance, up to a maximum
     * of 64000 GB (64 TB). You can choose the size of the data disk based on how
     * big your notebooks and data are. If not specified, this defaults to 100.
     * </pre>
     *
     * <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The dataDiskSizeGb.
     */
    @java.lang.Override
    public long getDataDiskSizeGb() {
      return dataDiskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Input only. The size of the data disk in GB attached to this instance, up to a maximum
     * of 64000 GB (64 TB). You can choose the size of the data disk based on how
     * big your notebooks and data are. If not specified, this defaults to 100.
     * </pre>
     *
     * <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The dataDiskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDataDiskSizeGb(long value) {

      dataDiskSizeGb_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The size of the data disk in GB attached to this instance, up to a maximum
     * of 64000 GB (64 TB). You can choose the size of the data disk based on how
     * big your notebooks and data are. If not specified, this defaults to 100.
     * </pre>
     *
     * <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00008000);
      dataDiskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private boolean noRemoveDataDisk_;
    /**
     *
     *
     * <pre>
     * Input only. If true, the data disk will not be auto deleted when deleting the instance.
     * </pre>
     *
     * <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The noRemoveDataDisk.
     */
    @java.lang.Override
    public boolean getNoRemoveDataDisk() {
      return noRemoveDataDisk_;
    }
    /**
     *
     *
     * <pre>
     * Input only. If true, the data disk will not be auto deleted when deleting the instance.
     * </pre>
     *
     * <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The noRemoveDataDisk to set.
     * @return This builder for chaining.
     */
    public Builder setNoRemoveDataDisk(boolean value) {

      noRemoveDataDisk_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. If true, the data disk will not be auto deleted when deleting the instance.
     * </pre>
     *
     * <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoRemoveDataDisk() {
      bitField0_ = (bitField0_ & ~0x00010000);
      noRemoveDataDisk_ = false;
      onChanged();
      return this;
    }

    private int diskEncryption_ = 0;
    /**
     *
     *
     * <pre>
     * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for diskEncryption.
     */
    @java.lang.Override
    public int getDiskEncryptionValue() {
      return diskEncryption_;
    }
    /**
     *
     *
     * <pre>
     * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for diskEncryption to set.
     * @return This builder for chaining.
     */
    public Builder setDiskEncryptionValue(int value) {
      diskEncryption_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The diskEncryption.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption getDiskEncryption() {
      com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption result =
          com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption.forNumber(diskEncryption_);
      return result == null
          ? com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The diskEncryption to set.
     * @return This builder for chaining.
     */
    public Builder setDiskEncryption(
        com.google.cloud.notebooks.v1beta1.Instance.DiskEncryption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      diskEncryption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskEncryption() {
      bitField0_ = (bitField0_ & ~0x00020000);
      diskEncryption_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
     * is CMEK.
     * Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     *
     * Learn more about [using your own encryption
     * keys](https://cloud.google.com/kms/docs/quickstart).
     * </pre>
     *
     * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
     * is CMEK.
     * Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     *
     * Learn more about [using your own encryption
     * keys](https://cloud.google.com/kms/docs/quickstart).
     * </pre>
     *
     * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
     * is CMEK.
     * Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     *
     * Learn more about [using your own encryption
     * keys](https://cloud.google.com/kms/docs/quickstart).
     * </pre>
     *
     * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
     * is CMEK.
     * Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     *
     * Learn more about [using your own encryption
     * keys](https://cloud.google.com/kms/docs/quickstart).
     * </pre>
     *
     * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
     * is CMEK.
     * Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     *
     * Learn more about [using your own encryption
     * keys](https://cloud.google.com/kms/docs/quickstart).
     * </pre>
     *
     * <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private boolean noPublicIp_;
    /**
     *
     *
     * <pre>
     * If true, no public IP will be assigned to this instance.
     * </pre>
     *
     * <code>bool no_public_ip = 17;</code>
     *
     * @return The noPublicIp.
     */
    @java.lang.Override
    public boolean getNoPublicIp() {
      return noPublicIp_;
    }
    /**
     *
     *
     * <pre>
     * If true, no public IP will be assigned to this instance.
     * </pre>
     *
     * <code>bool no_public_ip = 17;</code>
     *
     * @param value The noPublicIp to set.
     * @return This builder for chaining.
     */
    public Builder setNoPublicIp(boolean value) {

      noPublicIp_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, no public IP will be assigned to this instance.
     * </pre>
     *
     * <code>bool no_public_ip = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoPublicIp() {
      bitField0_ = (bitField0_ & ~0x00080000);
      noPublicIp_ = false;
      onChanged();
      return this;
    }

    private boolean noProxyAccess_;
    /**
     *
     *
     * <pre>
     * If true, the notebook instance will not register with the proxy.
     * </pre>
     *
     * <code>bool no_proxy_access = 18;</code>
     *
     * @return The noProxyAccess.
     */
    @java.lang.Override
    public boolean getNoProxyAccess() {
      return noProxyAccess_;
    }
    /**
     *
     *
     * <pre>
     * If true, the notebook instance will not register with the proxy.
     * </pre>
     *
     * <code>bool no_proxy_access = 18;</code>
     *
     * @param value The noProxyAccess to set.
     * @return This builder for chaining.
     */
    public Builder setNoProxyAccess(boolean value) {

      noProxyAccess_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the notebook instance will not register with the proxy.
     * </pre>
     *
     * <code>bool no_proxy_access = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoProxyAccess() {
      bitField0_ = (bitField0_ & ~0x00100000);
      noProxyAccess_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 19;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 19;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 19;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 19;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object subnet_ = "";
    /**
     *
     *
     * <pre>
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 20;</code>
     *
     * @return The subnet.
     */
    public java.lang.String getSubnet() {
      java.lang.Object ref = subnet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 20;</code>
     *
     * @return The bytes for subnet.
     */
    public com.google.protobuf.ByteString getSubnetBytes() {
      java.lang.Object ref = subnet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 20;</code>
     *
     * @param value The subnet to set.
     * @return This builder for chaining.
     */
    public Builder setSubnet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnet_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnet() {
      subnet_ = getDefaultInstance().getSubnet();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 20;</code>
     *
     * @param value The bytes for subnet to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnet_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00800000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00800000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00800000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 21;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00800000;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x01000000);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x01000000;
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x01000000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22;</code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x01000000;
      return this;
    }

    private int nicType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for nicType.
     */
    @java.lang.Override
    public int getNicTypeValue() {
      return nicType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for nicType to set.
     * @return This builder for chaining.
     */
    public Builder setNicTypeValue(int value) {
      nicType_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nicType.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.Instance.NicType getNicType() {
      com.google.cloud.notebooks.v1beta1.Instance.NicType result =
          com.google.cloud.notebooks.v1beta1.Instance.NicType.forNumber(nicType_);
      return result == null
          ? com.google.cloud.notebooks.v1beta1.Instance.NicType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The nicType to set.
     * @return This builder for chaining.
     */
    public Builder setNicType(com.google.cloud.notebooks.v1beta1.Instance.NicType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x02000000;
      nicType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.Instance.NicType nic_type = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNicType() {
      bitField0_ = (bitField0_ & ~0x02000000);
      nicType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.notebooks.v1beta1.ReservationAffinity reservationAffinity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.ReservationAffinity,
            com.google.cloud.notebooks.v1beta1.ReservationAffinity.Builder,
            com.google.cloud.notebooks.v1beta1.ReservationAffinityOrBuilder>
        reservationAffinityBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reservationAffinity field is set.
     */
    public boolean hasReservationAffinity() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reservationAffinity.
     */
    public com.google.cloud.notebooks.v1beta1.ReservationAffinity getReservationAffinity() {
      if (reservationAffinityBuilder_ == null) {
        return reservationAffinity_ == null
            ? com.google.cloud.notebooks.v1beta1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      } else {
        return reservationAffinityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReservationAffinity(
        com.google.cloud.notebooks.v1beta1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationAffinity_ = value;
      } else {
        reservationAffinityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReservationAffinity(
        com.google.cloud.notebooks.v1beta1.ReservationAffinity.Builder builderForValue) {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinity_ = builderForValue.build();
      } else {
        reservationAffinityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReservationAffinity(
        com.google.cloud.notebooks.v1beta1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && reservationAffinity_ != null
            && reservationAffinity_
                != com.google.cloud.notebooks.v1beta1.ReservationAffinity.getDefaultInstance()) {
          getReservationAffinityBuilder().mergeFrom(value);
        } else {
          reservationAffinity_ = value;
        }
      } else {
        reservationAffinityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReservationAffinity() {
      bitField0_ = (bitField0_ & ~0x04000000);
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v1beta1.ReservationAffinity.Builder
        getReservationAffinityBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getReservationAffinityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v1beta1.ReservationAffinityOrBuilder
        getReservationAffinityOrBuilder() {
      if (reservationAffinityBuilder_ != null) {
        return reservationAffinityBuilder_.getMessageOrBuilder();
      } else {
        return reservationAffinity_ == null
            ? com.google.cloud.notebooks.v1beta1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v1beta1.ReservationAffinity reservation_affinity = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v1beta1.ReservationAffinity,
            com.google.cloud.notebooks.v1beta1.ReservationAffinity.Builder,
            com.google.cloud.notebooks.v1beta1.ReservationAffinityOrBuilder>
        getReservationAffinityFieldBuilder() {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v1beta1.ReservationAffinity,
                com.google.cloud.notebooks.v1beta1.ReservationAffinity.Builder,
                com.google.cloud.notebooks.v1beta1.ReservationAffinityOrBuilder>(
                getReservationAffinity(), getParentForChildren(), isClean());
        reservationAffinity_ = null;
      }
      return reservationAffinityBuilder_;
    }

    private boolean canIpForward_;
    /**
     *
     *
     * <pre>
     * Optional. Flag to enable ip forwarding or not, default false/off.
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * </pre>
     *
     * <code>bool can_ip_forward = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The canIpForward.
     */
    @java.lang.Override
    public boolean getCanIpForward() {
      return canIpForward_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag to enable ip forwarding or not, default false/off.
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * </pre>
     *
     * <code>bool can_ip_forward = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The canIpForward to set.
     * @return This builder for chaining.
     */
    public Builder setCanIpForward(boolean value) {

      canIpForward_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag to enable ip forwarding or not, default false/off.
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * </pre>
     *
     * <code>bool can_ip_forward = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanIpForward() {
      bitField0_ = (bitField0_ & ~0x08000000);
      canIpForward_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x10000000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x20000000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v1beta1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v1beta1.Instance)
  private static final com.google.cloud.notebooks.v1beta1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v1beta1.Instance();
  }

  public static com.google.cloud.notebooks.v1beta1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
