/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v1beta1/service.proto

package com.google.cloud.notebooks.v1beta1;

/**
 *
 *
 * <pre>
 * Response for checking if a notebook instance is upgradeable.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse}
 */
public final class IsInstanceUpgradeableResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse)
    IsInstanceUpgradeableResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IsInstanceUpgradeableResponse.newBuilder() to construct.
  private IsInstanceUpgradeableResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IsInstanceUpgradeableResponse() {
    upgradeVersion_ = "";
    upgradeInfo_ = "";
    upgradeImage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IsInstanceUpgradeableResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v1beta1.NotebooksProto
        .internal_static_google_cloud_notebooks_v1beta1_IsInstanceUpgradeableResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v1beta1.NotebooksProto
        .internal_static_google_cloud_notebooks_v1beta1_IsInstanceUpgradeableResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.class,
            com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.Builder.class);
  }

  public static final int UPGRADEABLE_FIELD_NUMBER = 1;
  private boolean upgradeable_ = false;
  /**
   *
   *
   * <pre>
   * If an instance is upgradeable.
   * </pre>
   *
   * <code>bool upgradeable = 1;</code>
   *
   * @return The upgradeable.
   */
  @java.lang.Override
  public boolean getUpgradeable() {
    return upgradeable_;
  }

  public static final int UPGRADE_VERSION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object upgradeVersion_ = "";
  /**
   *
   *
   * <pre>
   * The version this instance will be upgraded to if calling the upgrade
   * endpoint. This field will only be populated if field upgradeable is true.
   * </pre>
   *
   * <code>string upgrade_version = 2;</code>
   *
   * @return The upgradeVersion.
   */
  @java.lang.Override
  public java.lang.String getUpgradeVersion() {
    java.lang.Object ref = upgradeVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      upgradeVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The version this instance will be upgraded to if calling the upgrade
   * endpoint. This field will only be populated if field upgradeable is true.
   * </pre>
   *
   * <code>string upgrade_version = 2;</code>
   *
   * @return The bytes for upgradeVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUpgradeVersionBytes() {
    java.lang.Object ref = upgradeVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      upgradeVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPGRADE_INFO_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object upgradeInfo_ = "";
  /**
   *
   *
   * <pre>
   * Additional information about upgrade.
   * </pre>
   *
   * <code>string upgrade_info = 3;</code>
   *
   * @return The upgradeInfo.
   */
  @java.lang.Override
  public java.lang.String getUpgradeInfo() {
    java.lang.Object ref = upgradeInfo_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      upgradeInfo_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Additional information about upgrade.
   * </pre>
   *
   * <code>string upgrade_info = 3;</code>
   *
   * @return The bytes for upgradeInfo.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUpgradeInfoBytes() {
    java.lang.Object ref = upgradeInfo_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      upgradeInfo_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPGRADE_IMAGE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object upgradeImage_ = "";
  /**
   *
   *
   * <pre>
   * The new image self link this instance will be upgraded to if calling the
   * upgrade endpoint. This field will only be populated if field upgradeable
   * is true.
   * </pre>
   *
   * <code>string upgrade_image = 4;</code>
   *
   * @return The upgradeImage.
   */
  @java.lang.Override
  public java.lang.String getUpgradeImage() {
    java.lang.Object ref = upgradeImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      upgradeImage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The new image self link this instance will be upgraded to if calling the
   * upgrade endpoint. This field will only be populated if field upgradeable
   * is true.
   * </pre>
   *
   * <code>string upgrade_image = 4;</code>
   *
   * @return The bytes for upgradeImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUpgradeImageBytes() {
    java.lang.Object ref = upgradeImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      upgradeImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (upgradeable_ != false) {
      output.writeBool(1, upgradeable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upgradeVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, upgradeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upgradeInfo_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, upgradeInfo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upgradeImage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, upgradeImage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (upgradeable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, upgradeable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upgradeVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, upgradeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upgradeInfo_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, upgradeInfo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upgradeImage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, upgradeImage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse other =
        (com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse) obj;

    if (getUpgradeable() != other.getUpgradeable()) return false;
    if (!getUpgradeVersion().equals(other.getUpgradeVersion())) return false;
    if (!getUpgradeInfo().equals(other.getUpgradeInfo())) return false;
    if (!getUpgradeImage().equals(other.getUpgradeImage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + UPGRADEABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUpgradeable());
    hash = (37 * hash) + UPGRADE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getUpgradeVersion().hashCode();
    hash = (37 * hash) + UPGRADE_INFO_FIELD_NUMBER;
    hash = (53 * hash) + getUpgradeInfo().hashCode();
    hash = (37 * hash) + UPGRADE_IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getUpgradeImage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for checking if a notebook instance is upgradeable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse)
      com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v1beta1.NotebooksProto
          .internal_static_google_cloud_notebooks_v1beta1_IsInstanceUpgradeableResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v1beta1.NotebooksProto
          .internal_static_google_cloud_notebooks_v1beta1_IsInstanceUpgradeableResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.class,
              com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      upgradeable_ = false;
      upgradeVersion_ = "";
      upgradeInfo_ = "";
      upgradeImage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v1beta1.NotebooksProto
          .internal_static_google_cloud_notebooks_v1beta1_IsInstanceUpgradeableResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse
        getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse build() {
      com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse buildPartial() {
      com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse result =
          new com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.upgradeable_ = upgradeable_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.upgradeVersion_ = upgradeVersion_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.upgradeInfo_ = upgradeInfo_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.upgradeImage_ = upgradeImage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse) {
        return mergeFrom((com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse other) {
      if (other
          == com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse.getDefaultInstance())
        return this;
      if (other.getUpgradeable() != false) {
        setUpgradeable(other.getUpgradeable());
      }
      if (!other.getUpgradeVersion().isEmpty()) {
        upgradeVersion_ = other.upgradeVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUpgradeInfo().isEmpty()) {
        upgradeInfo_ = other.upgradeInfo_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getUpgradeImage().isEmpty()) {
        upgradeImage_ = other.upgradeImage_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                upgradeable_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                upgradeVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                upgradeInfo_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                upgradeImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean upgradeable_;
    /**
     *
     *
     * <pre>
     * If an instance is upgradeable.
     * </pre>
     *
     * <code>bool upgradeable = 1;</code>
     *
     * @return The upgradeable.
     */
    @java.lang.Override
    public boolean getUpgradeable() {
      return upgradeable_;
    }
    /**
     *
     *
     * <pre>
     * If an instance is upgradeable.
     * </pre>
     *
     * <code>bool upgradeable = 1;</code>
     *
     * @param value The upgradeable to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeable(boolean value) {

      upgradeable_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an instance is upgradeable.
     * </pre>
     *
     * <code>bool upgradeable = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpgradeable() {
      bitField0_ = (bitField0_ & ~0x00000001);
      upgradeable_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object upgradeVersion_ = "";
    /**
     *
     *
     * <pre>
     * The version this instance will be upgraded to if calling the upgrade
     * endpoint. This field will only be populated if field upgradeable is true.
     * </pre>
     *
     * <code>string upgrade_version = 2;</code>
     *
     * @return The upgradeVersion.
     */
    public java.lang.String getUpgradeVersion() {
      java.lang.Object ref = upgradeVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        upgradeVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version this instance will be upgraded to if calling the upgrade
     * endpoint. This field will only be populated if field upgradeable is true.
     * </pre>
     *
     * <code>string upgrade_version = 2;</code>
     *
     * @return The bytes for upgradeVersion.
     */
    public com.google.protobuf.ByteString getUpgradeVersionBytes() {
      java.lang.Object ref = upgradeVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        upgradeVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version this instance will be upgraded to if calling the upgrade
     * endpoint. This field will only be populated if field upgradeable is true.
     * </pre>
     *
     * <code>string upgrade_version = 2;</code>
     *
     * @param value The upgradeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      upgradeVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version this instance will be upgraded to if calling the upgrade
     * endpoint. This field will only be populated if field upgradeable is true.
     * </pre>
     *
     * <code>string upgrade_version = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpgradeVersion() {
      upgradeVersion_ = getDefaultInstance().getUpgradeVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version this instance will be upgraded to if calling the upgrade
     * endpoint. This field will only be populated if field upgradeable is true.
     * </pre>
     *
     * <code>string upgrade_version = 2;</code>
     *
     * @param value The bytes for upgradeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      upgradeVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object upgradeInfo_ = "";
    /**
     *
     *
     * <pre>
     * Additional information about upgrade.
     * </pre>
     *
     * <code>string upgrade_info = 3;</code>
     *
     * @return The upgradeInfo.
     */
    public java.lang.String getUpgradeInfo() {
      java.lang.Object ref = upgradeInfo_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        upgradeInfo_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about upgrade.
     * </pre>
     *
     * <code>string upgrade_info = 3;</code>
     *
     * @return The bytes for upgradeInfo.
     */
    public com.google.protobuf.ByteString getUpgradeInfoBytes() {
      java.lang.Object ref = upgradeInfo_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        upgradeInfo_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about upgrade.
     * </pre>
     *
     * <code>string upgrade_info = 3;</code>
     *
     * @param value The upgradeInfo to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeInfo(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      upgradeInfo_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about upgrade.
     * </pre>
     *
     * <code>string upgrade_info = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpgradeInfo() {
      upgradeInfo_ = getDefaultInstance().getUpgradeInfo();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about upgrade.
     * </pre>
     *
     * <code>string upgrade_info = 3;</code>
     *
     * @param value The bytes for upgradeInfo to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeInfoBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      upgradeInfo_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object upgradeImage_ = "";
    /**
     *
     *
     * <pre>
     * The new image self link this instance will be upgraded to if calling the
     * upgrade endpoint. This field will only be populated if field upgradeable
     * is true.
     * </pre>
     *
     * <code>string upgrade_image = 4;</code>
     *
     * @return The upgradeImage.
     */
    public java.lang.String getUpgradeImage() {
      java.lang.Object ref = upgradeImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        upgradeImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The new image self link this instance will be upgraded to if calling the
     * upgrade endpoint. This field will only be populated if field upgradeable
     * is true.
     * </pre>
     *
     * <code>string upgrade_image = 4;</code>
     *
     * @return The bytes for upgradeImage.
     */
    public com.google.protobuf.ByteString getUpgradeImageBytes() {
      java.lang.Object ref = upgradeImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        upgradeImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The new image self link this instance will be upgraded to if calling the
     * upgrade endpoint. This field will only be populated if field upgradeable
     * is true.
     * </pre>
     *
     * <code>string upgrade_image = 4;</code>
     *
     * @param value The upgradeImage to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      upgradeImage_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The new image self link this instance will be upgraded to if calling the
     * upgrade endpoint. This field will only be populated if field upgradeable
     * is true.
     * </pre>
     *
     * <code>string upgrade_image = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpgradeImage() {
      upgradeImage_ = getDefaultInstance().getUpgradeImage();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The new image self link this instance will be upgraded to if calling the
     * upgrade endpoint. This field will only be populated if field upgradeable
     * is true.
     * </pre>
     *
     * <code>string upgrade_image = 4;</code>
     *
     * @param value The bytes for upgradeImage to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      upgradeImage_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse)
  private static final com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse();
  }

  public static com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IsInstanceUpgradeableResponse> PARSER =
      new com.google.protobuf.AbstractParser<IsInstanceUpgradeableResponse>() {
        @java.lang.Override
        public IsInstanceUpgradeableResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IsInstanceUpgradeableResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IsInstanceUpgradeableResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
