/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/gce_setup.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

public interface BootDiskOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.notebooks.v2.BootDisk)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The size of the boot disk in GB attached to this instance, up to
   * a maximum of 64000 GB (64 TB). If not specified, this defaults to the
   * recommended value of 150GB.
   * </pre>
   *
   * <code>int64 disk_size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The diskSizeGb.
   */
  long getDiskSizeGb();

  /**
   *
   *
   * <pre>
   * Optional. Indicates the type of the disk.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.DiskType disk_type = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for diskType.
   */
  int getDiskTypeValue();
  /**
   *
   *
   * <pre>
   * Optional. Indicates the type of the disk.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.DiskType disk_type = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The diskType.
   */
  com.google.cloud.notebooks.v2.DiskType getDiskType();

  /**
   *
   *
   * <pre>
   * Optional. Input only. Disk encryption method used on the boot and data
   * disks, defaults to GMEK.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.DiskEncryption disk_encryption = 3 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for diskEncryption.
   */
  int getDiskEncryptionValue();
  /**
   *
   *
   * <pre>
   * Optional. Input only. Disk encryption method used on the boot and data
   * disks, defaults to GMEK.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.DiskEncryption disk_encryption = 3 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The diskEncryption.
   */
  com.google.cloud.notebooks.v2.DiskEncryption getDiskEncryption();

  /**
   *
   *
   * <pre>
   * Optional. Input only. The KMS key used to encrypt the disks, only
   * applicable if disk_encryption is CMEK. Format:
   * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
   *
   * Learn more about using your own encryption keys.
   * </pre>
   *
   * <code>
   * string kms_key = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The kmsKey.
   */
  java.lang.String getKmsKey();
  /**
   *
   *
   * <pre>
   * Optional. Input only. The KMS key used to encrypt the disks, only
   * applicable if disk_encryption is CMEK. Format:
   * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
   *
   * Learn more about using your own encryption keys.
   * </pre>
   *
   * <code>
   * string kms_key = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  com.google.protobuf.ByteString getKmsKeyBytes();
}
