/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/diagnostic_config.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

/**
 *
 *
 * <pre>
 * Defines flags that are used to run the diagnostic tool
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v2.DiagnosticConfig}
 */
public final class DiagnosticConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v2.DiagnosticConfig)
    DiagnosticConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiagnosticConfig.newBuilder() to construct.
  private DiagnosticConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiagnosticConfig() {
    gcsBucket_ = "";
    relativePath_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiagnosticConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v2.DiagnosticConfigProto
        .internal_static_google_cloud_notebooks_v2_DiagnosticConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v2.DiagnosticConfigProto
        .internal_static_google_cloud_notebooks_v2_DiagnosticConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v2.DiagnosticConfig.class,
            com.google.cloud.notebooks.v2.DiagnosticConfig.Builder.class);
  }

  public static final int GCS_BUCKET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gcsBucket_ = "";
  /**
   *
   *
   * <pre>
   * Required. User Cloud Storage bucket location (REQUIRED).
   * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
   *
   * Permissions:
   * User Managed Notebooks:
   * - storage.buckets.writer: Must be given to the project's service account
   *   attached to VM.
   * Google Managed Notebooks:
   * - storage.buckets.writer: Must be given to the project's service account or
   *   user credentials attached to VM depending on authentication mode.
   *
   * Cloud Storage bucket Log file will be written to
   * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
   * </pre>
   *
   * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The gcsBucket.
   */
  @java.lang.Override
  public java.lang.String getGcsBucket() {
    java.lang.Object ref = gcsBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gcsBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User Cloud Storage bucket location (REQUIRED).
   * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
   *
   * Permissions:
   * User Managed Notebooks:
   * - storage.buckets.writer: Must be given to the project's service account
   *   attached to VM.
   * Google Managed Notebooks:
   * - storage.buckets.writer: Must be given to the project's service account or
   *   user credentials attached to VM depending on authentication mode.
   *
   * Cloud Storage bucket Log file will be written to
   * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
   * </pre>
   *
   * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for gcsBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGcsBucketBytes() {
    java.lang.Object ref = gcsBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gcsBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELATIVE_PATH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object relativePath_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Defines the relative storage path in the Cloud Storage bucket
   * where the diagnostic logs will be written: Default path will be the root
   * directory of the Cloud Storage bucket
   * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
   * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
   * </pre>
   *
   * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The relativePath.
   */
  @java.lang.Override
  public java.lang.String getRelativePath() {
    java.lang.Object ref = relativePath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relativePath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines the relative storage path in the Cloud Storage bucket
   * where the diagnostic logs will be written: Default path will be the root
   * directory of the Cloud Storage bucket
   * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
   * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
   * </pre>
   *
   * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for relativePath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelativePathBytes() {
    java.lang.Object ref = relativePath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relativePath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_REPAIR_FLAG_FIELD_NUMBER = 3;
  private boolean enableRepairFlag_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Enables flag to repair service for instance
   * </pre>
   *
   * <code>bool enable_repair_flag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableRepairFlag.
   */
  @java.lang.Override
  public boolean getEnableRepairFlag() {
    return enableRepairFlag_;
  }

  public static final int ENABLE_PACKET_CAPTURE_FLAG_FIELD_NUMBER = 4;
  private boolean enablePacketCaptureFlag_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Enables flag to capture packets from the instance for 30 seconds
   * </pre>
   *
   * <code>bool enable_packet_capture_flag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enablePacketCaptureFlag.
   */
  @java.lang.Override
  public boolean getEnablePacketCaptureFlag() {
    return enablePacketCaptureFlag_;
  }

  public static final int ENABLE_COPY_HOME_FILES_FLAG_FIELD_NUMBER = 5;
  private boolean enableCopyHomeFilesFlag_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Enables flag to copy all `/home/jupyter` folder contents
   * </pre>
   *
   * <code>bool enable_copy_home_files_flag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableCopyHomeFilesFlag.
   */
  @java.lang.Override
  public boolean getEnableCopyHomeFilesFlag() {
    return enableCopyHomeFilesFlag_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsBucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativePath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, relativePath_);
    }
    if (enableRepairFlag_ != false) {
      output.writeBool(3, enableRepairFlag_);
    }
    if (enablePacketCaptureFlag_ != false) {
      output.writeBool(4, enablePacketCaptureFlag_);
    }
    if (enableCopyHomeFilesFlag_ != false) {
      output.writeBool(5, enableCopyHomeFilesFlag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsBucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativePath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, relativePath_);
    }
    if (enableRepairFlag_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableRepairFlag_);
    }
    if (enablePacketCaptureFlag_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enablePacketCaptureFlag_);
    }
    if (enableCopyHomeFilesFlag_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableCopyHomeFilesFlag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v2.DiagnosticConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v2.DiagnosticConfig other =
        (com.google.cloud.notebooks.v2.DiagnosticConfig) obj;

    if (!getGcsBucket().equals(other.getGcsBucket())) return false;
    if (!getRelativePath().equals(other.getRelativePath())) return false;
    if (getEnableRepairFlag() != other.getEnableRepairFlag()) return false;
    if (getEnablePacketCaptureFlag() != other.getEnablePacketCaptureFlag()) return false;
    if (getEnableCopyHomeFilesFlag() != other.getEnableCopyHomeFilesFlag()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GCS_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getGcsBucket().hashCode();
    hash = (37 * hash) + RELATIVE_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getRelativePath().hashCode();
    hash = (37 * hash) + ENABLE_REPAIR_FLAG_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableRepairFlag());
    hash = (37 * hash) + ENABLE_PACKET_CAPTURE_FLAG_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePacketCaptureFlag());
    hash = (37 * hash) + ENABLE_COPY_HOME_FILES_FLAG_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableCopyHomeFilesFlag());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v2.DiagnosticConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines flags that are used to run the diagnostic tool
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v2.DiagnosticConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v2.DiagnosticConfig)
      com.google.cloud.notebooks.v2.DiagnosticConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.DiagnosticConfigProto
          .internal_static_google_cloud_notebooks_v2_DiagnosticConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v2.DiagnosticConfigProto
          .internal_static_google_cloud_notebooks_v2_DiagnosticConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v2.DiagnosticConfig.class,
              com.google.cloud.notebooks.v2.DiagnosticConfig.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v2.DiagnosticConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      gcsBucket_ = "";
      relativePath_ = "";
      enableRepairFlag_ = false;
      enablePacketCaptureFlag_ = false;
      enableCopyHomeFilesFlag_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v2.DiagnosticConfigProto
          .internal_static_google_cloud_notebooks_v2_DiagnosticConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.DiagnosticConfig getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v2.DiagnosticConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.DiagnosticConfig build() {
      com.google.cloud.notebooks.v2.DiagnosticConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.DiagnosticConfig buildPartial() {
      com.google.cloud.notebooks.v2.DiagnosticConfig result =
          new com.google.cloud.notebooks.v2.DiagnosticConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.notebooks.v2.DiagnosticConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.gcsBucket_ = gcsBucket_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.relativePath_ = relativePath_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableRepairFlag_ = enableRepairFlag_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enablePacketCaptureFlag_ = enablePacketCaptureFlag_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableCopyHomeFilesFlag_ = enableCopyHomeFilesFlag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v2.DiagnosticConfig) {
        return mergeFrom((com.google.cloud.notebooks.v2.DiagnosticConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v2.DiagnosticConfig other) {
      if (other == com.google.cloud.notebooks.v2.DiagnosticConfig.getDefaultInstance()) return this;
      if (!other.getGcsBucket().isEmpty()) {
        gcsBucket_ = other.gcsBucket_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRelativePath().isEmpty()) {
        relativePath_ = other.relativePath_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getEnableRepairFlag() != false) {
        setEnableRepairFlag(other.getEnableRepairFlag());
      }
      if (other.getEnablePacketCaptureFlag() != false) {
        setEnablePacketCaptureFlag(other.getEnablePacketCaptureFlag());
      }
      if (other.getEnableCopyHomeFilesFlag() != false) {
        setEnableCopyHomeFilesFlag(other.getEnableCopyHomeFilesFlag());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                gcsBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                relativePath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                enableRepairFlag_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                enablePacketCaptureFlag_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                enableCopyHomeFilesFlag_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object gcsBucket_ = "";
    /**
     *
     *
     * <pre>
     * Required. User Cloud Storage bucket location (REQUIRED).
     * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
     *
     * Permissions:
     * User Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account
     *   attached to VM.
     * Google Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account or
     *   user credentials attached to VM depending on authentication mode.
     *
     * Cloud Storage bucket Log file will be written to
     * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
     * </pre>
     *
     * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsBucket.
     */
    public java.lang.String getGcsBucket() {
      java.lang.Object ref = gcsBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User Cloud Storage bucket location (REQUIRED).
     * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
     *
     * Permissions:
     * User Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account
     *   attached to VM.
     * Google Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account or
     *   user credentials attached to VM depending on authentication mode.
     *
     * Cloud Storage bucket Log file will be written to
     * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
     * </pre>
     *
     * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsBucket.
     */
    public com.google.protobuf.ByteString getGcsBucketBytes() {
      java.lang.Object ref = gcsBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User Cloud Storage bucket location (REQUIRED).
     * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
     *
     * Permissions:
     * User Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account
     *   attached to VM.
     * Google Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account or
     *   user credentials attached to VM depending on authentication mode.
     *
     * Cloud Storage bucket Log file will be written to
     * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
     * </pre>
     *
     * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The gcsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setGcsBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gcsBucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User Cloud Storage bucket location (REQUIRED).
     * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
     *
     * Permissions:
     * User Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account
     *   attached to VM.
     * Google Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account or
     *   user credentials attached to VM depending on authentication mode.
     *
     * Cloud Storage bucket Log file will be written to
     * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
     * </pre>
     *
     * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsBucket() {
      gcsBucket_ = getDefaultInstance().getGcsBucket();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User Cloud Storage bucket location (REQUIRED).
     * Must be formatted with path prefix (`gs://$GCS_BUCKET`).
     *
     * Permissions:
     * User Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account
     *   attached to VM.
     * Google Managed Notebooks:
     * - storage.buckets.writer: Must be given to the project's service account or
     *   user credentials attached to VM depending on authentication mode.
     *
     * Cloud Storage bucket Log file will be written to
     * `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
     * </pre>
     *
     * <code>string gcs_bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for gcsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setGcsBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gcsBucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object relativePath_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Defines the relative storage path in the Cloud Storage bucket
     * where the diagnostic logs will be written: Default path will be the root
     * directory of the Cloud Storage bucket
     * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
     * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
     * </pre>
     *
     * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The relativePath.
     */
    public java.lang.String getRelativePath() {
      java.lang.Object ref = relativePath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relativePath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the relative storage path in the Cloud Storage bucket
     * where the diagnostic logs will be written: Default path will be the root
     * directory of the Cloud Storage bucket
     * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
     * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
     * </pre>
     *
     * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for relativePath.
     */
    public com.google.protobuf.ByteString getRelativePathBytes() {
      java.lang.Object ref = relativePath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relativePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the relative storage path in the Cloud Storage bucket
     * where the diagnostic logs will be written: Default path will be the root
     * directory of the Cloud Storage bucket
     * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
     * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
     * </pre>
     *
     * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The relativePath to set.
     * @return This builder for chaining.
     */
    public Builder setRelativePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      relativePath_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the relative storage path in the Cloud Storage bucket
     * where the diagnostic logs will be written: Default path will be the root
     * directory of the Cloud Storage bucket
     * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
     * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
     * </pre>
     *
     * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelativePath() {
      relativePath_ = getDefaultInstance().getRelativePath();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines the relative storage path in the Cloud Storage bucket
     * where the diagnostic logs will be written: Default path will be the root
     * directory of the Cloud Storage bucket
     * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file
     * will be written: `gs://$GCS_BUCKET/$RELATIVE_PATH/`
     * </pre>
     *
     * <code>string relative_path = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for relativePath to set.
     * @return This builder for chaining.
     */
    public Builder setRelativePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      relativePath_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean enableRepairFlag_;
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to repair service for instance
     * </pre>
     *
     * <code>bool enable_repair_flag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableRepairFlag.
     */
    @java.lang.Override
    public boolean getEnableRepairFlag() {
      return enableRepairFlag_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to repair service for instance
     * </pre>
     *
     * <code>bool enable_repair_flag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableRepairFlag to set.
     * @return This builder for chaining.
     */
    public Builder setEnableRepairFlag(boolean value) {

      enableRepairFlag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to repair service for instance
     * </pre>
     *
     * <code>bool enable_repair_flag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableRepairFlag() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableRepairFlag_ = false;
      onChanged();
      return this;
    }

    private boolean enablePacketCaptureFlag_;
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to capture packets from the instance for 30 seconds
     * </pre>
     *
     * <code>bool enable_packet_capture_flag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enablePacketCaptureFlag.
     */
    @java.lang.Override
    public boolean getEnablePacketCaptureFlag() {
      return enablePacketCaptureFlag_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to capture packets from the instance for 30 seconds
     * </pre>
     *
     * <code>bool enable_packet_capture_flag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enablePacketCaptureFlag to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePacketCaptureFlag(boolean value) {

      enablePacketCaptureFlag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to capture packets from the instance for 30 seconds
     * </pre>
     *
     * <code>bool enable_packet_capture_flag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePacketCaptureFlag() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enablePacketCaptureFlag_ = false;
      onChanged();
      return this;
    }

    private boolean enableCopyHomeFilesFlag_;
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to copy all `/home/jupyter` folder contents
     * </pre>
     *
     * <code>bool enable_copy_home_files_flag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableCopyHomeFilesFlag.
     */
    @java.lang.Override
    public boolean getEnableCopyHomeFilesFlag() {
      return enableCopyHomeFilesFlag_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to copy all `/home/jupyter` folder contents
     * </pre>
     *
     * <code>bool enable_copy_home_files_flag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableCopyHomeFilesFlag to set.
     * @return This builder for chaining.
     */
    public Builder setEnableCopyHomeFilesFlag(boolean value) {

      enableCopyHomeFilesFlag_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables flag to copy all `/home/jupyter` folder contents
     * </pre>
     *
     * <code>bool enable_copy_home_files_flag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableCopyHomeFilesFlag() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableCopyHomeFilesFlag_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v2.DiagnosticConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v2.DiagnosticConfig)
  private static final com.google.cloud.notebooks.v2.DiagnosticConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v2.DiagnosticConfig();
  }

  public static com.google.cloud.notebooks.v2.DiagnosticConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiagnosticConfig> PARSER =
      new com.google.protobuf.AbstractParser<DiagnosticConfig>() {
        @java.lang.Override
        public DiagnosticConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiagnosticConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiagnosticConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v2.DiagnosticConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
