/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/event.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

/**
 *
 *
 * <pre>
 * The definition of an Event for a managed / semi-managed notebook instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v2.Event}
 */
public final class Event extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v2.Event)
    EventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Event.newBuilder() to construct.
  private Event(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Event() {
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Event();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v2.EventProto
        .internal_static_google_cloud_notebooks_v2_Event_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetDetails();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v2.EventProto
        .internal_static_google_cloud_notebooks_v2_Event_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v2.Event.class,
            com.google.cloud.notebooks.v2.Event.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The definition of the event types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v2.Event.EventType}
   */
  public enum EventType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Event is not specified.
     * </pre>
     *
     * <code>EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    EVENT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance / runtime is idle
     * </pre>
     *
     * <code>IDLE = 1;</code>
     */
    IDLE(1),
    /**
     *
     *
     * <pre>
     * The instance / runtime is available.
     * This event indicates that instance / runtime underlying compute is
     * operational.
     * </pre>
     *
     * <code>HEARTBEAT = 2;</code>
     */
    HEARTBEAT(2),
    /**
     *
     *
     * <pre>
     * The instance / runtime health is available.
     * This event indicates that instance / runtime health information.
     * </pre>
     *
     * <code>HEALTH = 3;</code>
     */
    HEALTH(3),
    /**
     *
     *
     * <pre>
     * The instance / runtime is available.
     * This event allows instance / runtime to send Host maintenance
     * information to Control Plane.
     * https://cloud.google.com/compute/docs/gpus/gpu-host-maintenance
     * </pre>
     *
     * <code>MAINTENANCE = 4;</code>
     */
    MAINTENANCE(4),
    /**
     *
     *
     * <pre>
     * The instance / runtime is available.
     * This event indicates that the instance had metadata that needs to be
     * modified.
     * </pre>
     *
     * <code>METADATA_CHANGE = 5;</code>
     */
    METADATA_CHANGE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Event is not specified.
     * </pre>
     *
     * <code>EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int EVENT_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance / runtime is idle
     * </pre>
     *
     * <code>IDLE = 1;</code>
     */
    public static final int IDLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The instance / runtime is available.
     * This event indicates that instance / runtime underlying compute is
     * operational.
     * </pre>
     *
     * <code>HEARTBEAT = 2;</code>
     */
    public static final int HEARTBEAT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The instance / runtime health is available.
     * This event indicates that instance / runtime health information.
     * </pre>
     *
     * <code>HEALTH = 3;</code>
     */
    public static final int HEALTH_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The instance / runtime is available.
     * This event allows instance / runtime to send Host maintenance
     * information to Control Plane.
     * https://cloud.google.com/compute/docs/gpus/gpu-host-maintenance
     * </pre>
     *
     * <code>MAINTENANCE = 4;</code>
     */
    public static final int MAINTENANCE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The instance / runtime is available.
     * This event indicates that the instance had metadata that needs to be
     * modified.
     * </pre>
     *
     * <code>METADATA_CHANGE = 5;</code>
     */
    public static final int METADATA_CHANGE_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EventType forNumber(int value) {
      switch (value) {
        case 0:
          return EVENT_TYPE_UNSPECIFIED;
        case 1:
          return IDLE;
        case 2:
          return HEARTBEAT;
        case 3:
          return HEALTH;
        case 4:
          return MAINTENANCE;
        case 5:
          return METADATA_CHANGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EventType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EventType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EventType>() {
          public EventType findValueByNumber(int number) {
            return EventType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.Event.getDescriptor().getEnumTypes().get(0);
    }

    private static final EventType[] VALUES = values();

    public static EventType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v2.Event.EventType)
  }

  private int bitField0_;
  public static final int REPORT_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp reportTime_;
  /**
   *
   *
   * <pre>
   * Optional. Event report time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the reportTime field is set.
   */
  @java.lang.Override
  public boolean hasReportTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Event report time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The reportTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReportTime() {
    return reportTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : reportTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Event report time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReportTimeOrBuilder() {
    return reportTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : reportTime_;
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Event type.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Event type.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.Event.EventType getType() {
    com.google.cloud.notebooks.v2.Event.EventType result =
        com.google.cloud.notebooks.v2.Event.EventType.forNumber(type_);
    return result == null ? com.google.cloud.notebooks.v2.Event.EventType.UNRECOGNIZED : result;
  }

  public static final int DETAILS_FIELD_NUMBER = 3;

  private static final class DetailsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.notebooks.v2.EventProto
                .internal_static_google_cloud_notebooks_v2_Event_DetailsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> details_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDetails() {
    if (details_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DetailsDefaultEntryHolder.defaultEntry);
    }
    return details_;
  }

  public int getDetailsCount() {
    return internalGetDetails().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Event details. This field is used to pass event information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsDetails(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDetails().getMap().containsKey(key);
  }
  /** Use {@link #getDetailsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDetails() {
    return getDetailsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Event details. This field is used to pass event information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDetailsMap() {
    return internalGetDetails().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Event details. This field is used to pass event information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDetailsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Event details. This field is used to pass event information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getDetailsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getReportTime());
    }
    if (type_ != com.google.cloud.notebooks.v2.Event.EventType.EVENT_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDetails(), DetailsDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReportTime());
    }
    if (type_ != com.google.cloud.notebooks.v2.Event.EventType.EVENT_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDetails().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> details__ =
          DetailsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, details__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v2.Event)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v2.Event other = (com.google.cloud.notebooks.v2.Event) obj;

    if (hasReportTime() != other.hasReportTime()) return false;
    if (hasReportTime()) {
      if (!getReportTime().equals(other.getReportTime())) return false;
    }
    if (type_ != other.type_) return false;
    if (!internalGetDetails().equals(other.internalGetDetails())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasReportTime()) {
      hash = (37 * hash) + REPORT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReportTime().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (!internalGetDetails().getMap().isEmpty()) {
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Event parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.Event parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.Event parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v2.Event prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of an Event for a managed / semi-managed notebook instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v2.Event}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v2.Event)
      com.google.cloud.notebooks.v2.EventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.EventProto
          .internal_static_google_cloud_notebooks_v2_Event_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetDetails();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableDetails();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v2.EventProto
          .internal_static_google_cloud_notebooks_v2_Event_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v2.Event.class,
              com.google.cloud.notebooks.v2.Event.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v2.Event.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReportTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      reportTime_ = null;
      if (reportTimeBuilder_ != null) {
        reportTimeBuilder_.dispose();
        reportTimeBuilder_ = null;
      }
      type_ = 0;
      internalGetMutableDetails().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v2.EventProto
          .internal_static_google_cloud_notebooks_v2_Event_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.Event getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v2.Event.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.Event build() {
      com.google.cloud.notebooks.v2.Event result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.Event buildPartial() {
      com.google.cloud.notebooks.v2.Event result = new com.google.cloud.notebooks.v2.Event(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.notebooks.v2.Event result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.reportTime_ = reportTimeBuilder_ == null ? reportTime_ : reportTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.details_ = internalGetDetails();
        result.details_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v2.Event) {
        return mergeFrom((com.google.cloud.notebooks.v2.Event) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v2.Event other) {
      if (other == com.google.cloud.notebooks.v2.Event.getDefaultInstance()) return this;
      if (other.hasReportTime()) {
        mergeReportTime(other.getReportTime());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      internalGetMutableDetails().mergeFrom(other.internalGetDetails());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReportTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> details__ =
                    input.readMessage(
                        DetailsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDetails()
                    .getMutableMap()
                    .put(details__.getKey(), details__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp reportTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        reportTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reportTime field is set.
     */
    public boolean hasReportTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reportTime.
     */
    public com.google.protobuf.Timestamp getReportTime() {
      if (reportTimeBuilder_ == null) {
        return reportTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : reportTime_;
      } else {
        return reportTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReportTime(com.google.protobuf.Timestamp value) {
      if (reportTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportTime_ = value;
      } else {
        reportTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReportTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (reportTimeBuilder_ == null) {
        reportTime_ = builderForValue.build();
      } else {
        reportTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReportTime(com.google.protobuf.Timestamp value) {
      if (reportTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && reportTime_ != null
            && reportTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReportTimeBuilder().mergeFrom(value);
        } else {
          reportTime_ = value;
        }
      } else {
        reportTimeBuilder_.mergeFrom(value);
      }
      if (reportTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReportTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      reportTime_ = null;
      if (reportTimeBuilder_ != null) {
        reportTimeBuilder_.dispose();
        reportTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getReportTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getReportTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getReportTimeOrBuilder() {
      if (reportTimeBuilder_ != null) {
        return reportTimeBuilder_.getMessageOrBuilder();
      } else {
        return reportTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : reportTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Event report time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReportTimeFieldBuilder() {
      if (reportTimeBuilder_ == null) {
        reportTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReportTime(), getParentForChildren(), isClean());
        reportTime_ = null;
      }
      return reportTimeBuilder_;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Event type.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event type.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event type.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.Event.EventType getType() {
      com.google.cloud.notebooks.v2.Event.EventType result =
          com.google.cloud.notebooks.v2.Event.EventType.forNumber(type_);
      return result == null ? com.google.cloud.notebooks.v2.Event.EventType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event type.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.notebooks.v2.Event.EventType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event type.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.Event.EventType type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> details_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDetails() {
      if (details_ == null) {
        return com.google.protobuf.MapField.emptyMapField(DetailsDefaultEntryHolder.defaultEntry);
      }
      return details_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDetails() {
      if (details_ == null) {
        details_ = com.google.protobuf.MapField.newMapField(DetailsDefaultEntryHolder.defaultEntry);
      }
      if (!details_.isMutable()) {
        details_ = details_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return details_;
    }

    public int getDetailsCount() {
      return internalGetDetails().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsDetails(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDetails().getMap().containsKey(key);
    }
    /** Use {@link #getDetailsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDetails() {
      return getDetailsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDetailsMap() {
      return internalGetDetails().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDetailsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getDetailsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDetails() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableDetails().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeDetails(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDetails().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDetails() {
      bitField0_ |= 0x00000004;
      return internalGetMutableDetails().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putDetails(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDetails().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Event details. This field is used to pass event information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllDetails(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDetails().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v2.Event)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v2.Event)
  private static final com.google.cloud.notebooks.v2.Event DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v2.Event();
  }

  public static com.google.cloud.notebooks.v2.Event getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Event> PARSER =
      new com.google.protobuf.AbstractParser<Event>() {
        @java.lang.Override
        public Event parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Event> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Event> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v2.Event getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
