/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/gce_setup.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

/**
 *
 *
 * <pre>
 * The definition of how to configure a VM instance outside of Resources and
 * Identity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v2.GceSetup}
 */
public final class GceSetup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v2.GceSetup)
    GceSetupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GceSetup.newBuilder() to construct.
  private GceSetup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GceSetup() {
    machineType_ = "";
    acceleratorConfigs_ = java.util.Collections.emptyList();
    serviceAccounts_ = java.util.Collections.emptyList();
    dataDisks_ = java.util.Collections.emptyList();
    networkInterfaces_ = java.util.Collections.emptyList();
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GceSetup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v2.GceSetupProto
        .internal_static_google_cloud_notebooks_v2_GceSetup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v2.GceSetupProto
        .internal_static_google_cloud_notebooks_v2_GceSetup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v2.GceSetup.class,
            com.google.cloud.notebooks.v2.GceSetup.Builder.class);
  }

  private int bitField0_;
  private int imageCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object image_;

  public enum ImageCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VM_IMAGE(4),
    CONTAINER_IMAGE(5),
    IMAGE_NOT_SET(0);
    private final int value;

    private ImageCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImageCase valueOf(int value) {
      return forNumber(value);
    }

    public static ImageCase forNumber(int value) {
      switch (value) {
        case 4:
          return VM_IMAGE;
        case 5:
          return CONTAINER_IMAGE;
        case 0:
          return IMAGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ImageCase getImageCase() {
    return ImageCase.forNumber(imageCase_);
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The machine type of the VM instance.
   * https://cloud.google.com/compute/docs/machine-resource
   * </pre>
   *
   * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The machine type of the VM instance.
   * https://cloud.google.com/compute/docs/machine-resource
   * </pre>
   *
   * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCELERATOR_CONFIGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.notebooks.v2.AcceleratorConfig> acceleratorConfigs_;
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.notebooks.v2.AcceleratorConfig>
      getAcceleratorConfigsList() {
    return acceleratorConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder>
      getAcceleratorConfigsOrBuilderList() {
    return acceleratorConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAcceleratorConfigsCount() {
    return acceleratorConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.AcceleratorConfig getAcceleratorConfigs(int index) {
    return acceleratorConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder getAcceleratorConfigsOrBuilder(
      int index) {
    return acceleratorConfigs_.get(index);
  }

  public static final int SERVICE_ACCOUNTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.notebooks.v2.ServiceAccount> serviceAccounts_;
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.notebooks.v2.ServiceAccount> getServiceAccountsList() {
    return serviceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.notebooks.v2.ServiceAccountOrBuilder>
      getServiceAccountsOrBuilderList() {
    return serviceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getServiceAccountsCount() {
    return serviceAccounts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.ServiceAccount getServiceAccounts(int index) {
    return serviceAccounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
      int index) {
    return serviceAccounts_.get(index);
  }

  public static final int VM_IMAGE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the vmImage field is set.
   */
  @java.lang.Override
  public boolean hasVmImage() {
    return imageCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The vmImage.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.VmImage getVmImage() {
    if (imageCase_ == 4) {
      return (com.google.cloud.notebooks.v2.VmImage) image_;
    }
    return com.google.cloud.notebooks.v2.VmImage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.VmImageOrBuilder getVmImageOrBuilder() {
    if (imageCase_ == 4) {
      return (com.google.cloud.notebooks.v2.VmImage) image_;
    }
    return com.google.cloud.notebooks.v2.VmImage.getDefaultInstance();
  }

  public static final int CONTAINER_IMAGE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the containerImage field is set.
   */
  @java.lang.Override
  public boolean hasContainerImage() {
    return imageCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The containerImage.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.ContainerImage getContainerImage() {
    if (imageCase_ == 5) {
      return (com.google.cloud.notebooks.v2.ContainerImage) image_;
    }
    return com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.ContainerImageOrBuilder getContainerImageOrBuilder() {
    if (imageCase_ == 5) {
      return (com.google.cloud.notebooks.v2.ContainerImage) image_;
    }
    return com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance();
  }

  public static final int BOOT_DISK_FIELD_NUMBER = 6;
  private com.google.cloud.notebooks.v2.BootDisk bootDisk_;
  /**
   *
   *
   * <pre>
   * Optional. The boot disk for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bootDisk field is set.
   */
  @java.lang.Override
  public boolean hasBootDisk() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The boot disk for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bootDisk.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.BootDisk getBootDisk() {
    return bootDisk_ == null
        ? com.google.cloud.notebooks.v2.BootDisk.getDefaultInstance()
        : bootDisk_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The boot disk for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.BootDiskOrBuilder getBootDiskOrBuilder() {
    return bootDisk_ == null
        ? com.google.cloud.notebooks.v2.BootDisk.getDefaultInstance()
        : bootDisk_;
  }

  public static final int DATA_DISKS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.notebooks.v2.DataDisk> dataDisks_;
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.notebooks.v2.DataDisk> getDataDisksList() {
    return dataDisks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.notebooks.v2.DataDiskOrBuilder>
      getDataDisksOrBuilderList() {
    return dataDisks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getDataDisksCount() {
    return dataDisks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.DataDisk getDataDisks(int index) {
    return dataDisks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.DataDiskOrBuilder getDataDisksOrBuilder(int index) {
    return dataDisks_.get(index);
  }

  public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.notebooks.v2.ShieldedInstanceConfig shieldedInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Shielded VM configuration.
   * [Images using supported Shielded VM
   * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Shielded VM configuration.
   * [Images using supported Shielded VM
   * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The shieldedInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.notebooks.v2.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Shielded VM configuration.
   * [Images using supported Shielded VM
   * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.notebooks.v2.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  public static final int NETWORK_INTERFACES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.notebooks.v2.NetworkInterface> networkInterfaces_;
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.notebooks.v2.NetworkInterface> getNetworkInterfacesList() {
    return networkInterfaces_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder>
      getNetworkInterfacesOrBuilderList() {
    return networkInterfaces_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getNetworkInterfacesCount() {
    return networkInterfaces_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.NetworkInterface getNetworkInterfaces(int index) {
    return networkInterfaces_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
      int index) {
    return networkInterfaces_.get(index);
  }

  public static final int DISABLE_PUBLIC_IP_FIELD_NUMBER = 10;
  private boolean disablePublicIp_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If true, no external IP will be assigned to this VM instance.
   * </pre>
   *
   * <code>bool disable_public_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disablePublicIp.
   */
  @java.lang.Override
  public boolean getDisablePublicIp() {
    return disablePublicIp_;
  }

  public static final int TAGS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int METADATA_FIELD_NUMBER = 12;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.notebooks.v2.GceSetupProto
                .internal_static_google_cloud_notebooks_v2_GceSetup_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENABLE_IP_FORWARDING_FIELD_NUMBER = 13;
  private boolean enableIpForwarding_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Flag to enable ip forwarding or not, default false/off.
   * https://cloud.google.com/vpc/docs/using-routes#canipforward
   * </pre>
   *
   * <code>bool enable_ip_forwarding = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableIpForwarding.
   */
  @java.lang.Override
  public boolean getEnableIpForwarding() {
    return enableIpForwarding_;
  }

  public static final int GPU_DRIVER_CONFIG_FIELD_NUMBER = 14;
  private com.google.cloud.notebooks.v2.GPUDriverConfig gpuDriverConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for GPU drivers.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gpuDriverConfig field is set.
   */
  @java.lang.Override
  public boolean hasGpuDriverConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for GPU drivers.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gpuDriverConfig.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.GPUDriverConfig getGpuDriverConfig() {
    return gpuDriverConfig_ == null
        ? com.google.cloud.notebooks.v2.GPUDriverConfig.getDefaultInstance()
        : gpuDriverConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for GPU drivers.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.GPUDriverConfigOrBuilder getGpuDriverConfigOrBuilder() {
    return gpuDriverConfig_ == null
        ? com.google.cloud.notebooks.v2.GPUDriverConfig.getDefaultInstance()
        : gpuDriverConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
    }
    for (int i = 0; i < acceleratorConfigs_.size(); i++) {
      output.writeMessage(2, acceleratorConfigs_.get(i));
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      output.writeMessage(3, serviceAccounts_.get(i));
    }
    if (imageCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.notebooks.v2.VmImage) image_);
    }
    if (imageCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.notebooks.v2.ContainerImage) image_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getBootDisk());
    }
    for (int i = 0; i < dataDisks_.size(); i++) {
      output.writeMessage(7, dataDisks_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getShieldedInstanceConfig());
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      output.writeMessage(9, networkInterfaces_.get(i));
    }
    if (disablePublicIp_ != false) {
      output.writeBool(10, disablePublicIp_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, tags_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 12);
    if (enableIpForwarding_ != false) {
      output.writeBool(13, enableIpForwarding_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(14, getGpuDriverConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
    }
    for (int i = 0; i < acceleratorConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, acceleratorConfigs_.get(i));
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, serviceAccounts_.get(i));
    }
    if (imageCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.notebooks.v2.VmImage) image_);
    }
    if (imageCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.notebooks.v2.ContainerImage) image_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBootDisk());
    }
    for (int i = 0; i < dataDisks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, dataDisks_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getShieldedInstanceConfig());
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, networkInterfaces_.get(i));
    }
    if (disablePublicIp_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, disablePublicIp_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, metadata__);
    }
    if (enableIpForwarding_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, enableIpForwarding_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getGpuDriverConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v2.GceSetup)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v2.GceSetup other = (com.google.cloud.notebooks.v2.GceSetup) obj;

    if (!getMachineType().equals(other.getMachineType())) return false;
    if (!getAcceleratorConfigsList().equals(other.getAcceleratorConfigsList())) return false;
    if (!getServiceAccountsList().equals(other.getServiceAccountsList())) return false;
    if (hasBootDisk() != other.hasBootDisk()) return false;
    if (hasBootDisk()) {
      if (!getBootDisk().equals(other.getBootDisk())) return false;
    }
    if (!getDataDisksList().equals(other.getDataDisksList())) return false;
    if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
    if (hasShieldedInstanceConfig()) {
      if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
    }
    if (!getNetworkInterfacesList().equals(other.getNetworkInterfacesList())) return false;
    if (getDisablePublicIp() != other.getDisablePublicIp()) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (getEnableIpForwarding() != other.getEnableIpForwarding()) return false;
    if (hasGpuDriverConfig() != other.hasGpuDriverConfig()) return false;
    if (hasGpuDriverConfig()) {
      if (!getGpuDriverConfig().equals(other.getGpuDriverConfig())) return false;
    }
    if (!getImageCase().equals(other.getImageCase())) return false;
    switch (imageCase_) {
      case 4:
        if (!getVmImage().equals(other.getVmImage())) return false;
        break;
      case 5:
        if (!getContainerImage().equals(other.getContainerImage())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    if (getAcceleratorConfigsCount() > 0) {
      hash = (37 * hash) + ACCELERATOR_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorConfigsList().hashCode();
    }
    if (getServiceAccountsCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountsList().hashCode();
    }
    if (hasBootDisk()) {
      hash = (37 * hash) + BOOT_DISK_FIELD_NUMBER;
      hash = (53 * hash) + getBootDisk().hashCode();
    }
    if (getDataDisksCount() > 0) {
      hash = (37 * hash) + DATA_DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDataDisksList().hashCode();
    }
    if (hasShieldedInstanceConfig()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
    }
    if (getNetworkInterfacesCount() > 0) {
      hash = (37 * hash) + NETWORK_INTERFACES_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkInterfacesList().hashCode();
    }
    hash = (37 * hash) + DISABLE_PUBLIC_IP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisablePublicIp());
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    hash = (37 * hash) + ENABLE_IP_FORWARDING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIpForwarding());
    if (hasGpuDriverConfig()) {
      hash = (37 * hash) + GPU_DRIVER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGpuDriverConfig().hashCode();
    }
    switch (imageCase_) {
      case 4:
        hash = (37 * hash) + VM_IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getVmImage().hashCode();
        break;
      case 5:
        hash = (37 * hash) + CONTAINER_IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getContainerImage().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.GceSetup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v2.GceSetup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of how to configure a VM instance outside of Resources and
   * Identity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v2.GceSetup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v2.GceSetup)
      com.google.cloud.notebooks.v2.GceSetupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.GceSetupProto
          .internal_static_google_cloud_notebooks_v2_GceSetup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v2.GceSetupProto
          .internal_static_google_cloud_notebooks_v2_GceSetup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v2.GceSetup.class,
              com.google.cloud.notebooks.v2.GceSetup.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v2.GceSetup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAcceleratorConfigsFieldBuilder();
        getServiceAccountsFieldBuilder();
        getBootDiskFieldBuilder();
        getDataDisksFieldBuilder();
        getShieldedInstanceConfigFieldBuilder();
        getNetworkInterfacesFieldBuilder();
        getGpuDriverConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      machineType_ = "";
      if (acceleratorConfigsBuilder_ == null) {
        acceleratorConfigs_ = java.util.Collections.emptyList();
      } else {
        acceleratorConfigs_ = null;
        acceleratorConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
      } else {
        serviceAccounts_ = null;
        serviceAccountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (vmImageBuilder_ != null) {
        vmImageBuilder_.clear();
      }
      if (containerImageBuilder_ != null) {
        containerImageBuilder_.clear();
      }
      bootDisk_ = null;
      if (bootDiskBuilder_ != null) {
        bootDiskBuilder_.dispose();
        bootDiskBuilder_ = null;
      }
      if (dataDisksBuilder_ == null) {
        dataDisks_ = java.util.Collections.emptyList();
      } else {
        dataDisks_ = null;
        dataDisksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
      } else {
        networkInterfaces_ = null;
        networkInterfacesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      disablePublicIp_ = false;
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableMetadata().clear();
      enableIpForwarding_ = false;
      gpuDriverConfig_ = null;
      if (gpuDriverConfigBuilder_ != null) {
        gpuDriverConfigBuilder_.dispose();
        gpuDriverConfigBuilder_ = null;
      }
      imageCase_ = 0;
      image_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v2.GceSetupProto
          .internal_static_google_cloud_notebooks_v2_GceSetup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.GceSetup getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.GceSetup build() {
      com.google.cloud.notebooks.v2.GceSetup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.GceSetup buildPartial() {
      com.google.cloud.notebooks.v2.GceSetup result =
          new com.google.cloud.notebooks.v2.GceSetup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.notebooks.v2.GceSetup result) {
      if (acceleratorConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          acceleratorConfigs_ = java.util.Collections.unmodifiableList(acceleratorConfigs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.acceleratorConfigs_ = acceleratorConfigs_;
      } else {
        result.acceleratorConfigs_ = acceleratorConfigsBuilder_.build();
      }
      if (serviceAccountsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          serviceAccounts_ = java.util.Collections.unmodifiableList(serviceAccounts_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.serviceAccounts_ = serviceAccounts_;
      } else {
        result.serviceAccounts_ = serviceAccountsBuilder_.build();
      }
      if (dataDisksBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          dataDisks_ = java.util.Collections.unmodifiableList(dataDisks_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.dataDisks_ = dataDisks_;
      } else {
        result.dataDisks_ = dataDisksBuilder_.build();
      }
      if (networkInterfacesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          networkInterfaces_ = java.util.Collections.unmodifiableList(networkInterfaces_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.networkInterfaces_ = networkInterfaces_;
      } else {
        result.networkInterfaces_ = networkInterfacesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.notebooks.v2.GceSetup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.machineType_ = machineType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.bootDisk_ = bootDiskBuilder_ == null ? bootDisk_ : bootDiskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.shieldedInstanceConfig_ =
            shieldedInstanceConfigBuilder_ == null
                ? shieldedInstanceConfig_
                : shieldedInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.disablePublicIp_ = disablePublicIp_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.enableIpForwarding_ = enableIpForwarding_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.gpuDriverConfig_ =
            gpuDriverConfigBuilder_ == null ? gpuDriverConfig_ : gpuDriverConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.notebooks.v2.GceSetup result) {
      result.imageCase_ = imageCase_;
      result.image_ = this.image_;
      if (imageCase_ == 4 && vmImageBuilder_ != null) {
        result.image_ = vmImageBuilder_.build();
      }
      if (imageCase_ == 5 && containerImageBuilder_ != null) {
        result.image_ = containerImageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v2.GceSetup) {
        return mergeFrom((com.google.cloud.notebooks.v2.GceSetup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v2.GceSetup other) {
      if (other == com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance()) return this;
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (acceleratorConfigsBuilder_ == null) {
        if (!other.acceleratorConfigs_.isEmpty()) {
          if (acceleratorConfigs_.isEmpty()) {
            acceleratorConfigs_ = other.acceleratorConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAcceleratorConfigsIsMutable();
            acceleratorConfigs_.addAll(other.acceleratorConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.acceleratorConfigs_.isEmpty()) {
          if (acceleratorConfigsBuilder_.isEmpty()) {
            acceleratorConfigsBuilder_.dispose();
            acceleratorConfigsBuilder_ = null;
            acceleratorConfigs_ = other.acceleratorConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            acceleratorConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorConfigsFieldBuilder()
                    : null;
          } else {
            acceleratorConfigsBuilder_.addAllMessages(other.acceleratorConfigs_);
          }
        }
      }
      if (serviceAccountsBuilder_ == null) {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccounts_.isEmpty()) {
            serviceAccounts_ = other.serviceAccounts_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureServiceAccountsIsMutable();
            serviceAccounts_.addAll(other.serviceAccounts_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccountsBuilder_.isEmpty()) {
            serviceAccountsBuilder_.dispose();
            serviceAccountsBuilder_ = null;
            serviceAccounts_ = other.serviceAccounts_;
            bitField0_ = (bitField0_ & ~0x00000004);
            serviceAccountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceAccountsFieldBuilder()
                    : null;
          } else {
            serviceAccountsBuilder_.addAllMessages(other.serviceAccounts_);
          }
        }
      }
      if (other.hasBootDisk()) {
        mergeBootDisk(other.getBootDisk());
      }
      if (dataDisksBuilder_ == null) {
        if (!other.dataDisks_.isEmpty()) {
          if (dataDisks_.isEmpty()) {
            dataDisks_ = other.dataDisks_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureDataDisksIsMutable();
            dataDisks_.addAll(other.dataDisks_);
          }
          onChanged();
        }
      } else {
        if (!other.dataDisks_.isEmpty()) {
          if (dataDisksBuilder_.isEmpty()) {
            dataDisksBuilder_.dispose();
            dataDisksBuilder_ = null;
            dataDisks_ = other.dataDisks_;
            bitField0_ = (bitField0_ & ~0x00000040);
            dataDisksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataDisksFieldBuilder()
                    : null;
          } else {
            dataDisksBuilder_.addAllMessages(other.dataDisks_);
          }
        }
      }
      if (other.hasShieldedInstanceConfig()) {
        mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
      }
      if (networkInterfacesBuilder_ == null) {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfaces_.isEmpty()) {
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureNetworkInterfacesIsMutable();
            networkInterfaces_.addAll(other.networkInterfaces_);
          }
          onChanged();
        }
      } else {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfacesBuilder_.isEmpty()) {
            networkInterfacesBuilder_.dispose();
            networkInterfacesBuilder_ = null;
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x00000100);
            networkInterfacesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNetworkInterfacesFieldBuilder()
                    : null;
          } else {
            networkInterfacesBuilder_.addAllMessages(other.networkInterfaces_);
          }
        }
      }
      if (other.getDisablePublicIp() != false) {
        setDisablePublicIp(other.getDisablePublicIp());
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000400;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x00000800;
      if (other.getEnableIpForwarding() != false) {
        setEnableIpForwarding(other.getEnableIpForwarding());
      }
      if (other.hasGpuDriverConfig()) {
        mergeGpuDriverConfig(other.getGpuDriverConfig());
      }
      switch (other.getImageCase()) {
        case VM_IMAGE:
          {
            mergeVmImage(other.getVmImage());
            break;
          }
        case CONTAINER_IMAGE:
          {
            mergeContainerImage(other.getContainerImage());
            break;
          }
        case IMAGE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.notebooks.v2.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.notebooks.v2.AcceleratorConfig.parser(),
                        extensionRegistry);
                if (acceleratorConfigsBuilder_ == null) {
                  ensureAcceleratorConfigsIsMutable();
                  acceleratorConfigs_.add(m);
                } else {
                  acceleratorConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.notebooks.v2.ServiceAccount m =
                    input.readMessage(
                        com.google.cloud.notebooks.v2.ServiceAccount.parser(), extensionRegistry);
                if (serviceAccountsBuilder_ == null) {
                  ensureServiceAccountsIsMutable();
                  serviceAccounts_.add(m);
                } else {
                  serviceAccountsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getVmImageFieldBuilder().getBuilder(), extensionRegistry);
                imageCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getContainerImageFieldBuilder().getBuilder(), extensionRegistry);
                imageCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBootDiskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.notebooks.v2.DataDisk m =
                    input.readMessage(
                        com.google.cloud.notebooks.v2.DataDisk.parser(), extensionRegistry);
                if (dataDisksBuilder_ == null) {
                  ensureDataDisksIsMutable();
                  dataDisks_.add(m);
                } else {
                  dataDisksBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.notebooks.v2.NetworkInterface m =
                    input.readMessage(
                        com.google.cloud.notebooks.v2.NetworkInterface.parser(), extensionRegistry);
                if (networkInterfacesBuilder_ == null) {
                  ensureNetworkInterfacesIsMutable();
                  networkInterfaces_.add(m);
                } else {
                  networkInterfacesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                disablePublicIp_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                enableIpForwarding_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(getGpuDriverConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int imageCase_ = 0;
    private java.lang.Object image_;

    public ImageCase getImageCase() {
      return ImageCase.forNumber(imageCase_);
    }

    public Builder clearImage() {
      imageCase_ = 0;
      image_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The machine type of the VM instance.
     * https://cloud.google.com/compute/docs/machine-resource
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The machine type of the VM instance.
     * https://cloud.google.com/compute/docs/machine-resource
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The machine type of the VM instance.
     * https://cloud.google.com/compute/docs/machine-resource
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The machine type of the VM instance.
     * https://cloud.google.com/compute/docs/machine-resource
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The machine type of the VM instance.
     * https://cloud.google.com/compute/docs/machine-resource
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.notebooks.v2.AcceleratorConfig> acceleratorConfigs_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorConfigsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        acceleratorConfigs_ =
            new java.util.ArrayList<com.google.cloud.notebooks.v2.AcceleratorConfig>(
                acceleratorConfigs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.AcceleratorConfig,
            com.google.cloud.notebooks.v2.AcceleratorConfig.Builder,
            com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder>
        acceleratorConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.AcceleratorConfig>
        getAcceleratorConfigsList() {
      if (acceleratorConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(acceleratorConfigs_);
      } else {
        return acceleratorConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAcceleratorConfigsCount() {
      if (acceleratorConfigsBuilder_ == null) {
        return acceleratorConfigs_.size();
      } else {
        return acceleratorConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.AcceleratorConfig getAcceleratorConfigs(int index) {
      if (acceleratorConfigsBuilder_ == null) {
        return acceleratorConfigs_.get(index);
      } else {
        return acceleratorConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAcceleratorConfigs(
        int index, com.google.cloud.notebooks.v2.AcceleratorConfig value) {
      if (acceleratorConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.set(index, value);
        onChanged();
      } else {
        acceleratorConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAcceleratorConfigs(
        int index, com.google.cloud.notebooks.v2.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorConfigsBuilder_ == null) {
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcceleratorConfigs(com.google.cloud.notebooks.v2.AcceleratorConfig value) {
      if (acceleratorConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.add(value);
        onChanged();
      } else {
        acceleratorConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcceleratorConfigs(
        int index, com.google.cloud.notebooks.v2.AcceleratorConfig value) {
      if (acceleratorConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.add(index, value);
        onChanged();
      } else {
        acceleratorConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcceleratorConfigs(
        com.google.cloud.notebooks.v2.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorConfigsBuilder_ == null) {
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcceleratorConfigs(
        int index, com.google.cloud.notebooks.v2.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorConfigsBuilder_ == null) {
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAcceleratorConfigs(
        java.lang.Iterable<? extends com.google.cloud.notebooks.v2.AcceleratorConfig> values) {
      if (acceleratorConfigsBuilder_ == null) {
        ensureAcceleratorConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, acceleratorConfigs_);
        onChanged();
      } else {
        acceleratorConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAcceleratorConfigs() {
      if (acceleratorConfigsBuilder_ == null) {
        acceleratorConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        acceleratorConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAcceleratorConfigs(int index) {
      if (acceleratorConfigsBuilder_ == null) {
        ensureAcceleratorConfigsIsMutable();
        acceleratorConfigs_.remove(index);
        onChanged();
      } else {
        acceleratorConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.AcceleratorConfig.Builder getAcceleratorConfigsBuilder(
        int index) {
      return getAcceleratorConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder getAcceleratorConfigsOrBuilder(
        int index) {
      if (acceleratorConfigsBuilder_ == null) {
        return acceleratorConfigs_.get(index);
      } else {
        return acceleratorConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder>
        getAcceleratorConfigsOrBuilderList() {
      if (acceleratorConfigsBuilder_ != null) {
        return acceleratorConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(acceleratorConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.AcceleratorConfig.Builder addAcceleratorConfigsBuilder() {
      return getAcceleratorConfigsFieldBuilder()
          .addBuilder(com.google.cloud.notebooks.v2.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.AcceleratorConfig.Builder addAcceleratorConfigsBuilder(
        int index) {
      return getAcceleratorConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.notebooks.v2.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The hardware accelerators used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you have
     * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     * Currently supports only one accelerator configuration.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.AcceleratorConfig.Builder>
        getAcceleratorConfigsBuilderList() {
      return getAcceleratorConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.AcceleratorConfig,
            com.google.cloud.notebooks.v2.AcceleratorConfig.Builder,
            com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder>
        getAcceleratorConfigsFieldBuilder() {
      if (acceleratorConfigsBuilder_ == null) {
        acceleratorConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.notebooks.v2.AcceleratorConfig,
                com.google.cloud.notebooks.v2.AcceleratorConfig.Builder,
                com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder>(
                acceleratorConfigs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        acceleratorConfigs_ = null;
      }
      return acceleratorConfigsBuilder_;
    }

    private java.util.List<com.google.cloud.notebooks.v2.ServiceAccount> serviceAccounts_ =
        java.util.Collections.emptyList();

    private void ensureServiceAccountsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        serviceAccounts_ =
            new java.util.ArrayList<com.google.cloud.notebooks.v2.ServiceAccount>(serviceAccounts_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.ServiceAccount,
            com.google.cloud.notebooks.v2.ServiceAccount.Builder,
            com.google.cloud.notebooks.v2.ServiceAccountOrBuilder>
        serviceAccountsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.ServiceAccount> getServiceAccountsList() {
      if (serviceAccountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      } else {
        return serviceAccountsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getServiceAccountsCount() {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.size();
      } else {
        return serviceAccountsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ServiceAccount getServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setServiceAccounts(
        int index, com.google.cloud.notebooks.v2.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setServiceAccounts(
        int index, com.google.cloud.notebooks.v2.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServiceAccounts(com.google.cloud.notebooks.v2.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServiceAccounts(
        int index, com.google.cloud.notebooks.v2.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServiceAccounts(
        com.google.cloud.notebooks.v2.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addServiceAccounts(
        int index, com.google.cloud.notebooks.v2.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllServiceAccounts(
        java.lang.Iterable<? extends com.google.cloud.notebooks.v2.ServiceAccount> values) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccounts_);
        onChanged();
      } else {
        serviceAccountsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearServiceAccounts() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        serviceAccountsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.remove(index);
        onChanged();
      } else {
        serviceAccountsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ServiceAccount.Builder getServiceAccountsBuilder(
        int index) {
      return getServiceAccountsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
        int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.notebooks.v2.ServiceAccountOrBuilder>
        getServiceAccountsOrBuilderList() {
      if (serviceAccountsBuilder_ != null) {
        return serviceAccountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ServiceAccount.Builder addServiceAccountsBuilder() {
      return getServiceAccountsFieldBuilder()
          .addBuilder(com.google.cloud.notebooks.v2.ServiceAccount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ServiceAccount.Builder addServiceAccountsBuilder(
        int index) {
      return getServiceAccountsFieldBuilder()
          .addBuilder(index, com.google.cloud.notebooks.v2.ServiceAccount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that serves as an identity for the VM
     * instance. Currently supports only one service account.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.ServiceAccount.Builder>
        getServiceAccountsBuilderList() {
      return getServiceAccountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.ServiceAccount,
            com.google.cloud.notebooks.v2.ServiceAccount.Builder,
            com.google.cloud.notebooks.v2.ServiceAccountOrBuilder>
        getServiceAccountsFieldBuilder() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.notebooks.v2.ServiceAccount,
                com.google.cloud.notebooks.v2.ServiceAccount.Builder,
                com.google.cloud.notebooks.v2.ServiceAccountOrBuilder>(
                serviceAccounts_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        serviceAccounts_ = null;
      }
      return serviceAccountsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.VmImage,
            com.google.cloud.notebooks.v2.VmImage.Builder,
            com.google.cloud.notebooks.v2.VmImageOrBuilder>
        vmImageBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vmImage field is set.
     */
    @java.lang.Override
    public boolean hasVmImage() {
      return imageCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vmImage.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.VmImage getVmImage() {
      if (vmImageBuilder_ == null) {
        if (imageCase_ == 4) {
          return (com.google.cloud.notebooks.v2.VmImage) image_;
        }
        return com.google.cloud.notebooks.v2.VmImage.getDefaultInstance();
      } else {
        if (imageCase_ == 4) {
          return vmImageBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v2.VmImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVmImage(com.google.cloud.notebooks.v2.VmImage value) {
      if (vmImageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        image_ = value;
        onChanged();
      } else {
        vmImageBuilder_.setMessage(value);
      }
      imageCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVmImage(com.google.cloud.notebooks.v2.VmImage.Builder builderForValue) {
      if (vmImageBuilder_ == null) {
        image_ = builderForValue.build();
        onChanged();
      } else {
        vmImageBuilder_.setMessage(builderForValue.build());
      }
      imageCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVmImage(com.google.cloud.notebooks.v2.VmImage value) {
      if (vmImageBuilder_ == null) {
        if (imageCase_ == 4
            && image_ != com.google.cloud.notebooks.v2.VmImage.getDefaultInstance()) {
          image_ =
              com.google.cloud.notebooks.v2.VmImage.newBuilder(
                      (com.google.cloud.notebooks.v2.VmImage) image_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          image_ = value;
        }
        onChanged();
      } else {
        if (imageCase_ == 4) {
          vmImageBuilder_.mergeFrom(value);
        } else {
          vmImageBuilder_.setMessage(value);
        }
      }
      imageCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVmImage() {
      if (vmImageBuilder_ == null) {
        if (imageCase_ == 4) {
          imageCase_ = 0;
          image_ = null;
          onChanged();
        }
      } else {
        if (imageCase_ == 4) {
          imageCase_ = 0;
          image_ = null;
        }
        vmImageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.VmImage.Builder getVmImageBuilder() {
      return getVmImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.VmImageOrBuilder getVmImageOrBuilder() {
      if ((imageCase_ == 4) && (vmImageBuilder_ != null)) {
        return vmImageBuilder_.getMessageOrBuilder();
      } else {
        if (imageCase_ == 4) {
          return (com.google.cloud.notebooks.v2.VmImage) image_;
        }
        return com.google.cloud.notebooks.v2.VmImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a Compute Engine VM image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.VmImage,
            com.google.cloud.notebooks.v2.VmImage.Builder,
            com.google.cloud.notebooks.v2.VmImageOrBuilder>
        getVmImageFieldBuilder() {
      if (vmImageBuilder_ == null) {
        if (!(imageCase_ == 4)) {
          image_ = com.google.cloud.notebooks.v2.VmImage.getDefaultInstance();
        }
        vmImageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v2.VmImage,
                com.google.cloud.notebooks.v2.VmImage.Builder,
                com.google.cloud.notebooks.v2.VmImageOrBuilder>(
                (com.google.cloud.notebooks.v2.VmImage) image_, getParentForChildren(), isClean());
        image_ = null;
      }
      imageCase_ = 4;
      onChanged();
      return vmImageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.ContainerImage,
            com.google.cloud.notebooks.v2.ContainerImage.Builder,
            com.google.cloud.notebooks.v2.ContainerImageOrBuilder>
        containerImageBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the containerImage field is set.
     */
    @java.lang.Override
    public boolean hasContainerImage() {
      return imageCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The containerImage.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.ContainerImage getContainerImage() {
      if (containerImageBuilder_ == null) {
        if (imageCase_ == 5) {
          return (com.google.cloud.notebooks.v2.ContainerImage) image_;
        }
        return com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance();
      } else {
        if (imageCase_ == 5) {
          return containerImageBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContainerImage(com.google.cloud.notebooks.v2.ContainerImage value) {
      if (containerImageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        image_ = value;
        onChanged();
      } else {
        containerImageBuilder_.setMessage(value);
      }
      imageCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContainerImage(
        com.google.cloud.notebooks.v2.ContainerImage.Builder builderForValue) {
      if (containerImageBuilder_ == null) {
        image_ = builderForValue.build();
        onChanged();
      } else {
        containerImageBuilder_.setMessage(builderForValue.build());
      }
      imageCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeContainerImage(com.google.cloud.notebooks.v2.ContainerImage value) {
      if (containerImageBuilder_ == null) {
        if (imageCase_ == 5
            && image_ != com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance()) {
          image_ =
              com.google.cloud.notebooks.v2.ContainerImage.newBuilder(
                      (com.google.cloud.notebooks.v2.ContainerImage) image_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          image_ = value;
        }
        onChanged();
      } else {
        if (imageCase_ == 5) {
          containerImageBuilder_.mergeFrom(value);
        } else {
          containerImageBuilder_.setMessage(value);
        }
      }
      imageCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContainerImage() {
      if (containerImageBuilder_ == null) {
        if (imageCase_ == 5) {
          imageCase_ = 0;
          image_ = null;
          onChanged();
        }
      } else {
        if (imageCase_ == 5) {
          imageCase_ = 0;
          image_ = null;
        }
        containerImageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ContainerImage.Builder getContainerImageBuilder() {
      return getContainerImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.ContainerImageOrBuilder getContainerImageOrBuilder() {
      if ((imageCase_ == 5) && (containerImageBuilder_ != null)) {
        return containerImageBuilder_.getMessageOrBuilder();
      } else {
        if (imageCase_ == 5) {
          return (com.google.cloud.notebooks.v2.ContainerImage) image_;
        }
        return com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Use a container image to start the notebook instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.ContainerImage,
            com.google.cloud.notebooks.v2.ContainerImage.Builder,
            com.google.cloud.notebooks.v2.ContainerImageOrBuilder>
        getContainerImageFieldBuilder() {
      if (containerImageBuilder_ == null) {
        if (!(imageCase_ == 5)) {
          image_ = com.google.cloud.notebooks.v2.ContainerImage.getDefaultInstance();
        }
        containerImageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v2.ContainerImage,
                com.google.cloud.notebooks.v2.ContainerImage.Builder,
                com.google.cloud.notebooks.v2.ContainerImageOrBuilder>(
                (com.google.cloud.notebooks.v2.ContainerImage) image_,
                getParentForChildren(),
                isClean());
        image_ = null;
      }
      imageCase_ = 5;
      onChanged();
      return containerImageBuilder_;
    }

    private com.google.cloud.notebooks.v2.BootDisk bootDisk_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.BootDisk,
            com.google.cloud.notebooks.v2.BootDisk.Builder,
            com.google.cloud.notebooks.v2.BootDiskOrBuilder>
        bootDiskBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bootDisk field is set.
     */
    public boolean hasBootDisk() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bootDisk.
     */
    public com.google.cloud.notebooks.v2.BootDisk getBootDisk() {
      if (bootDiskBuilder_ == null) {
        return bootDisk_ == null
            ? com.google.cloud.notebooks.v2.BootDisk.getDefaultInstance()
            : bootDisk_;
      } else {
        return bootDiskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBootDisk(com.google.cloud.notebooks.v2.BootDisk value) {
      if (bootDiskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bootDisk_ = value;
      } else {
        bootDiskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBootDisk(com.google.cloud.notebooks.v2.BootDisk.Builder builderForValue) {
      if (bootDiskBuilder_ == null) {
        bootDisk_ = builderForValue.build();
      } else {
        bootDiskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBootDisk(com.google.cloud.notebooks.v2.BootDisk value) {
      if (bootDiskBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && bootDisk_ != null
            && bootDisk_ != com.google.cloud.notebooks.v2.BootDisk.getDefaultInstance()) {
          getBootDiskBuilder().mergeFrom(value);
        } else {
          bootDisk_ = value;
        }
      } else {
        bootDiskBuilder_.mergeFrom(value);
      }
      if (bootDisk_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBootDisk() {
      bitField0_ = (bitField0_ & ~0x00000020);
      bootDisk_ = null;
      if (bootDiskBuilder_ != null) {
        bootDiskBuilder_.dispose();
        bootDiskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.BootDisk.Builder getBootDiskBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getBootDiskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.BootDiskOrBuilder getBootDiskOrBuilder() {
      if (bootDiskBuilder_ != null) {
        return bootDiskBuilder_.getMessageOrBuilder();
      } else {
        return bootDisk_ == null
            ? com.google.cloud.notebooks.v2.BootDisk.getDefaultInstance()
            : bootDisk_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The boot disk for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.BootDisk,
            com.google.cloud.notebooks.v2.BootDisk.Builder,
            com.google.cloud.notebooks.v2.BootDiskOrBuilder>
        getBootDiskFieldBuilder() {
      if (bootDiskBuilder_ == null) {
        bootDiskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v2.BootDisk,
                com.google.cloud.notebooks.v2.BootDisk.Builder,
                com.google.cloud.notebooks.v2.BootDiskOrBuilder>(
                getBootDisk(), getParentForChildren(), isClean());
        bootDisk_ = null;
      }
      return bootDiskBuilder_;
    }

    private java.util.List<com.google.cloud.notebooks.v2.DataDisk> dataDisks_ =
        java.util.Collections.emptyList();

    private void ensureDataDisksIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        dataDisks_ = new java.util.ArrayList<com.google.cloud.notebooks.v2.DataDisk>(dataDisks_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.DataDisk,
            com.google.cloud.notebooks.v2.DataDisk.Builder,
            com.google.cloud.notebooks.v2.DataDiskOrBuilder>
        dataDisksBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.DataDisk> getDataDisksList() {
      if (dataDisksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataDisks_);
      } else {
        return dataDisksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getDataDisksCount() {
      if (dataDisksBuilder_ == null) {
        return dataDisks_.size();
      } else {
        return dataDisksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.DataDisk getDataDisks(int index) {
      if (dataDisksBuilder_ == null) {
        return dataDisks_.get(index);
      } else {
        return dataDisksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataDisks(int index, com.google.cloud.notebooks.v2.DataDisk value) {
      if (dataDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataDisksIsMutable();
        dataDisks_.set(index, value);
        onChanged();
      } else {
        dataDisksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataDisks(
        int index, com.google.cloud.notebooks.v2.DataDisk.Builder builderForValue) {
      if (dataDisksBuilder_ == null) {
        ensureDataDisksIsMutable();
        dataDisks_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataDisksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataDisks(com.google.cloud.notebooks.v2.DataDisk value) {
      if (dataDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataDisksIsMutable();
        dataDisks_.add(value);
        onChanged();
      } else {
        dataDisksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataDisks(int index, com.google.cloud.notebooks.v2.DataDisk value) {
      if (dataDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataDisksIsMutable();
        dataDisks_.add(index, value);
        onChanged();
      } else {
        dataDisksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataDisks(com.google.cloud.notebooks.v2.DataDisk.Builder builderForValue) {
      if (dataDisksBuilder_ == null) {
        ensureDataDisksIsMutable();
        dataDisks_.add(builderForValue.build());
        onChanged();
      } else {
        dataDisksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addDataDisks(
        int index, com.google.cloud.notebooks.v2.DataDisk.Builder builderForValue) {
      if (dataDisksBuilder_ == null) {
        ensureDataDisksIsMutable();
        dataDisks_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataDisksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllDataDisks(
        java.lang.Iterable<? extends com.google.cloud.notebooks.v2.DataDisk> values) {
      if (dataDisksBuilder_ == null) {
        ensureDataDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataDisks_);
        onChanged();
      } else {
        dataDisksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDataDisks() {
      if (dataDisksBuilder_ == null) {
        dataDisks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        dataDisksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeDataDisks(int index) {
      if (dataDisksBuilder_ == null) {
        ensureDataDisksIsMutable();
        dataDisks_.remove(index);
        onChanged();
      } else {
        dataDisksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.DataDisk.Builder getDataDisksBuilder(int index) {
      return getDataDisksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.DataDiskOrBuilder getDataDisksOrBuilder(int index) {
      if (dataDisksBuilder_ == null) {
        return dataDisks_.get(index);
      } else {
        return dataDisksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.notebooks.v2.DataDiskOrBuilder>
        getDataDisksOrBuilderList() {
      if (dataDisksBuilder_ != null) {
        return dataDisksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataDisks_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.DataDisk.Builder addDataDisksBuilder() {
      return getDataDisksFieldBuilder()
          .addBuilder(com.google.cloud.notebooks.v2.DataDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.DataDisk.Builder addDataDisksBuilder(int index) {
      return getDataDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.notebooks.v2.DataDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Data disks attached to the VM instance.
     * Currently supports only one data disk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.DataDisk.Builder>
        getDataDisksBuilderList() {
      return getDataDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.DataDisk,
            com.google.cloud.notebooks.v2.DataDisk.Builder,
            com.google.cloud.notebooks.v2.DataDiskOrBuilder>
        getDataDisksFieldBuilder() {
      if (dataDisksBuilder_ == null) {
        dataDisksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.notebooks.v2.DataDisk,
                com.google.cloud.notebooks.v2.DataDisk.Builder,
                com.google.cloud.notebooks.v2.DataDiskOrBuilder>(
                dataDisks_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        dataDisks_ = null;
      }
      return dataDisksBuilder_;
    }

    private com.google.cloud.notebooks.v2.ShieldedInstanceConfig shieldedInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.ShieldedInstanceConfig,
            com.google.cloud.notebooks.v2.ShieldedInstanceConfig.Builder,
            com.google.cloud.notebooks.v2.ShieldedInstanceConfigOrBuilder>
        shieldedInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the shieldedInstanceConfig field is set.
     */
    public boolean hasShieldedInstanceConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The shieldedInstanceConfig.
     */
    public com.google.cloud.notebooks.v2.ShieldedInstanceConfig getShieldedInstanceConfig() {
      if (shieldedInstanceConfigBuilder_ == null) {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.notebooks.v2.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      } else {
        return shieldedInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.notebooks.v2.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceConfig_ = value;
      } else {
        shieldedInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.notebooks.v2.ShieldedInstanceConfig.Builder builderForValue) {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfig_ = builderForValue.build();
      } else {
        shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeShieldedInstanceConfig(
        com.google.cloud.notebooks.v2.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && shieldedInstanceConfig_ != null
            && shieldedInstanceConfig_
                != com.google.cloud.notebooks.v2.ShieldedInstanceConfig.getDefaultInstance()) {
          getShieldedInstanceConfigBuilder().mergeFrom(value);
        } else {
          shieldedInstanceConfig_ = value;
        }
      } else {
        shieldedInstanceConfigBuilder_.mergeFrom(value);
      }
      if (shieldedInstanceConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearShieldedInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ShieldedInstanceConfig.Builder
        getShieldedInstanceConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getShieldedInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.ShieldedInstanceConfigOrBuilder
        getShieldedInstanceConfigOrBuilder() {
      if (shieldedInstanceConfigBuilder_ != null) {
        return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.notebooks.v2.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded VM configuration.
     * [Images using supported Shielded VM
     * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.ShieldedInstanceConfig,
            com.google.cloud.notebooks.v2.ShieldedInstanceConfig.Builder,
            com.google.cloud.notebooks.v2.ShieldedInstanceConfigOrBuilder>
        getShieldedInstanceConfigFieldBuilder() {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v2.ShieldedInstanceConfig,
                com.google.cloud.notebooks.v2.ShieldedInstanceConfig.Builder,
                com.google.cloud.notebooks.v2.ShieldedInstanceConfigOrBuilder>(
                getShieldedInstanceConfig(), getParentForChildren(), isClean());
        shieldedInstanceConfig_ = null;
      }
      return shieldedInstanceConfigBuilder_;
    }

    private java.util.List<com.google.cloud.notebooks.v2.NetworkInterface> networkInterfaces_ =
        java.util.Collections.emptyList();

    private void ensureNetworkInterfacesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        networkInterfaces_ =
            new java.util.ArrayList<com.google.cloud.notebooks.v2.NetworkInterface>(
                networkInterfaces_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.NetworkInterface,
            com.google.cloud.notebooks.v2.NetworkInterface.Builder,
            com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder>
        networkInterfacesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.NetworkInterface>
        getNetworkInterfacesList() {
      if (networkInterfacesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      } else {
        return networkInterfacesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getNetworkInterfacesCount() {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.size();
      } else {
        return networkInterfacesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.NetworkInterface getNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.notebooks.v2.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.notebooks.v2.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNetworkInterfaces(com.google.cloud.notebooks.v2.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.notebooks.v2.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNetworkInterfaces(
        com.google.cloud.notebooks.v2.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.notebooks.v2.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllNetworkInterfaces(
        java.lang.Iterable<? extends com.google.cloud.notebooks.v2.NetworkInterface> values) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkInterfaces_);
        onChanged();
      } else {
        networkInterfacesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNetworkInterfaces() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        networkInterfacesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.remove(index);
        onChanged();
      } else {
        networkInterfacesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.NetworkInterface.Builder getNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
        int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder>
        getNetworkInterfacesOrBuilderList() {
      if (networkInterfacesBuilder_ != null) {
        return networkInterfacesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.NetworkInterface.Builder addNetworkInterfacesBuilder() {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(com.google.cloud.notebooks.v2.NetworkInterface.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.NetworkInterface.Builder addNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(index, com.google.cloud.notebooks.v2.NetworkInterface.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The network interfaces for the VM.
     * Supports only one interface.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.NetworkInterface.Builder>
        getNetworkInterfacesBuilderList() {
      return getNetworkInterfacesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.NetworkInterface,
            com.google.cloud.notebooks.v2.NetworkInterface.Builder,
            com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder>
        getNetworkInterfacesFieldBuilder() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfacesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.notebooks.v2.NetworkInterface,
                com.google.cloud.notebooks.v2.NetworkInterface.Builder,
                com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder>(
                networkInterfaces_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        networkInterfaces_ = null;
      }
      return networkInterfacesBuilder_;
    }

    private boolean disablePublicIp_;
    /**
     *
     *
     * <pre>
     * Optional. If true, no external IP will be assigned to this VM instance.
     * </pre>
     *
     * <code>bool disable_public_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disablePublicIp.
     */
    @java.lang.Override
    public boolean getDisablePublicIp() {
      return disablePublicIp_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, no external IP will be assigned to this VM instance.
     * </pre>
     *
     * <code>bool disable_public_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disablePublicIp to set.
     * @return This builder for chaining.
     */
    public Builder setDisablePublicIp(boolean value) {

      disablePublicIp_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, no external IP will be assigned to this VM instance.
     * </pre>
     *
     * <code>bool disable_public_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisablePublicIp() {
      bitField0_ = (bitField0_ & ~0x00000200);
      disablePublicIp_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000800);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x00000800;
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x00000800;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata to apply to this instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x00000800;
      return this;
    }

    private boolean enableIpForwarding_;
    /**
     *
     *
     * <pre>
     * Optional. Flag to enable ip forwarding or not, default false/off.
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * </pre>
     *
     * <code>bool enable_ip_forwarding = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableIpForwarding.
     */
    @java.lang.Override
    public boolean getEnableIpForwarding() {
      return enableIpForwarding_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag to enable ip forwarding or not, default false/off.
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * </pre>
     *
     * <code>bool enable_ip_forwarding = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableIpForwarding to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIpForwarding(boolean value) {

      enableIpForwarding_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag to enable ip forwarding or not, default false/off.
     * https://cloud.google.com/vpc/docs/using-routes#canipforward
     * </pre>
     *
     * <code>bool enable_ip_forwarding = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIpForwarding() {
      bitField0_ = (bitField0_ & ~0x00001000);
      enableIpForwarding_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.notebooks.v2.GPUDriverConfig gpuDriverConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.GPUDriverConfig,
            com.google.cloud.notebooks.v2.GPUDriverConfig.Builder,
            com.google.cloud.notebooks.v2.GPUDriverConfigOrBuilder>
        gpuDriverConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gpuDriverConfig field is set.
     */
    public boolean hasGpuDriverConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gpuDriverConfig.
     */
    public com.google.cloud.notebooks.v2.GPUDriverConfig getGpuDriverConfig() {
      if (gpuDriverConfigBuilder_ == null) {
        return gpuDriverConfig_ == null
            ? com.google.cloud.notebooks.v2.GPUDriverConfig.getDefaultInstance()
            : gpuDriverConfig_;
      } else {
        return gpuDriverConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGpuDriverConfig(com.google.cloud.notebooks.v2.GPUDriverConfig value) {
      if (gpuDriverConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gpuDriverConfig_ = value;
      } else {
        gpuDriverConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGpuDriverConfig(
        com.google.cloud.notebooks.v2.GPUDriverConfig.Builder builderForValue) {
      if (gpuDriverConfigBuilder_ == null) {
        gpuDriverConfig_ = builderForValue.build();
      } else {
        gpuDriverConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGpuDriverConfig(com.google.cloud.notebooks.v2.GPUDriverConfig value) {
      if (gpuDriverConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && gpuDriverConfig_ != null
            && gpuDriverConfig_
                != com.google.cloud.notebooks.v2.GPUDriverConfig.getDefaultInstance()) {
          getGpuDriverConfigBuilder().mergeFrom(value);
        } else {
          gpuDriverConfig_ = value;
        }
      } else {
        gpuDriverConfigBuilder_.mergeFrom(value);
      }
      if (gpuDriverConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGpuDriverConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      gpuDriverConfig_ = null;
      if (gpuDriverConfigBuilder_ != null) {
        gpuDriverConfigBuilder_.dispose();
        gpuDriverConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.GPUDriverConfig.Builder getGpuDriverConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getGpuDriverConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.GPUDriverConfigOrBuilder getGpuDriverConfigOrBuilder() {
      if (gpuDriverConfigBuilder_ != null) {
        return gpuDriverConfigBuilder_.getMessageOrBuilder();
      } else {
        return gpuDriverConfig_ == null
            ? com.google.cloud.notebooks.v2.GPUDriverConfig.getDefaultInstance()
            : gpuDriverConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for GPU drivers.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.GPUDriverConfig,
            com.google.cloud.notebooks.v2.GPUDriverConfig.Builder,
            com.google.cloud.notebooks.v2.GPUDriverConfigOrBuilder>
        getGpuDriverConfigFieldBuilder() {
      if (gpuDriverConfigBuilder_ == null) {
        gpuDriverConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v2.GPUDriverConfig,
                com.google.cloud.notebooks.v2.GPUDriverConfig.Builder,
                com.google.cloud.notebooks.v2.GPUDriverConfigOrBuilder>(
                getGpuDriverConfig(), getParentForChildren(), isClean());
        gpuDriverConfig_ = null;
      }
      return gpuDriverConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v2.GceSetup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v2.GceSetup)
  private static final com.google.cloud.notebooks.v2.GceSetup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v2.GceSetup();
  }

  public static com.google.cloud.notebooks.v2.GceSetup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GceSetup> PARSER =
      new com.google.protobuf.AbstractParser<GceSetup>() {
        @java.lang.Override
        public GceSetup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GceSetup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GceSetup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v2.GceSetup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
