/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/gce_setup.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

public interface GceSetupOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.notebooks.v2.GceSetup)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The machine type of the VM instance.
   * https://cloud.google.com/compute/docs/machine-resource
   * </pre>
   *
   * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The machineType.
   */
  java.lang.String getMachineType();
  /**
   *
   *
   * <pre>
   * Optional. The machine type of the VM instance.
   * https://cloud.google.com/compute/docs/machine-resource
   * </pre>
   *
   * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for machineType.
   */
  com.google.protobuf.ByteString getMachineTypeBytes();

  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.notebooks.v2.AcceleratorConfig> getAcceleratorConfigsList();
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.AcceleratorConfig getAcceleratorConfigs(int index);
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAcceleratorConfigsCount();
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder>
      getAcceleratorConfigsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. The hardware accelerators used on this instance. If you use
   * accelerators, make sure that your configuration has
   * [enough vCPUs and memory to support the `machine_type` you have
   * selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
   * Currently supports only one accelerator configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.AcceleratorConfig accelerator_configs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.AcceleratorConfigOrBuilder getAcceleratorConfigsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.notebooks.v2.ServiceAccount> getServiceAccountsList();
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.ServiceAccount getServiceAccounts(int index);
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getServiceAccountsCount();
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.notebooks.v2.ServiceAccountOrBuilder>
      getServiceAccountsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. The service account that serves as an identity for the VM
   * instance. Currently supports only one service account.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.ServiceAccount service_accounts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.ServiceAccountOrBuilder getServiceAccountsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the vmImage field is set.
   */
  boolean hasVmImage();
  /**
   *
   *
   * <pre>
   * Optional. Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The vmImage.
   */
  com.google.cloud.notebooks.v2.VmImage getVmImage();
  /**
   *
   *
   * <pre>
   * Optional. Use a Compute Engine VM image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.VmImage vm_image = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.VmImageOrBuilder getVmImageOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the containerImage field is set.
   */
  boolean hasContainerImage();
  /**
   *
   *
   * <pre>
   * Optional. Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The containerImage.
   */
  com.google.cloud.notebooks.v2.ContainerImage getContainerImage();
  /**
   *
   *
   * <pre>
   * Optional. Use a container image to start the notebook instance.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ContainerImage container_image = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.ContainerImageOrBuilder getContainerImageOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The boot disk for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bootDisk field is set.
   */
  boolean hasBootDisk();
  /**
   *
   *
   * <pre>
   * Optional. The boot disk for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bootDisk.
   */
  com.google.cloud.notebooks.v2.BootDisk getBootDisk();
  /**
   *
   *
   * <pre>
   * Optional. The boot disk for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.BootDisk boot_disk = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.BootDiskOrBuilder getBootDiskOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.notebooks.v2.DataDisk> getDataDisksList();
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.DataDisk getDataDisks(int index);
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getDataDisksCount();
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.notebooks.v2.DataDiskOrBuilder>
      getDataDisksOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Data disks attached to the VM instance.
   * Currently supports only one data disk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.DataDisk data_disks = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.DataDiskOrBuilder getDataDisksOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Shielded VM configuration.
   * [Images using supported Shielded VM
   * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  boolean hasShieldedInstanceConfig();
  /**
   *
   *
   * <pre>
   * Optional. Shielded VM configuration.
   * [Images using supported Shielded VM
   * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The shieldedInstanceConfig.
   */
  com.google.cloud.notebooks.v2.ShieldedInstanceConfig getShieldedInstanceConfig();
  /**
   *
   *
   * <pre>
   * Optional. Shielded VM configuration.
   * [Images using supported Shielded VM
   * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.ShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.notebooks.v2.NetworkInterface> getNetworkInterfacesList();
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.NetworkInterface getNetworkInterfaces(int index);
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getNetworkInterfacesCount();
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder>
      getNetworkInterfacesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. The network interfaces for the VM.
   * Supports only one interface.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.NetworkInterface network_interfaces = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. If true, no external IP will be assigned to this VM instance.
   * </pre>
   *
   * <code>bool disable_public_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disablePublicIp.
   */
  boolean getDisablePublicIp();

  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the tags.
   */
  java.util.List<java.lang.String> getTagsList();
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of tags.
   */
  int getTagsCount();
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  java.lang.String getTags(int index);
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  com.google.protobuf.ByteString getTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getMetadataCount();
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsMetadata(java.lang.String key);
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getMetadata();
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getMetadataMap();
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata to apply to this instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getMetadataOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Flag to enable ip forwarding or not, default false/off.
   * https://cloud.google.com/vpc/docs/using-routes#canipforward
   * </pre>
   *
   * <code>bool enable_ip_forwarding = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableIpForwarding.
   */
  boolean getEnableIpForwarding();

  /**
   *
   *
   * <pre>
   * Optional. Configuration for GPU drivers.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gpuDriverConfig field is set.
   */
  boolean hasGpuDriverConfig();
  /**
   *
   *
   * <pre>
   * Optional. Configuration for GPU drivers.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gpuDriverConfig.
   */
  com.google.cloud.notebooks.v2.GPUDriverConfig getGpuDriverConfig();
  /**
   *
   *
   * <pre>
   * Optional. Configuration for GPU drivers.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GPUDriverConfig gpu_driver_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.notebooks.v2.GPUDriverConfigOrBuilder getGpuDriverConfigOrBuilder();

  com.google.cloud.notebooks.v2.GceSetup.ImageCase getImageCase();
}
