/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/instance.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

/**
 *
 *
 * <pre>
 * The definition of a notebook instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v2.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v2.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    proxyUri_ = "";
    instanceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
    creator_ = "";
    state_ = 0;
    upgradeHistory_ = java.util.Collections.emptyList();
    id_ = "";
    healthState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v2.InstanceProto
        .internal_static_google_cloud_notebooks_v2_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 10:
        return internalGetHealthInfo();
      case 14:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v2.InstanceProto
        .internal_static_google_cloud_notebooks_v2_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v2.Instance.class,
            com.google.cloud.notebooks.v2.Instance.Builder.class);
  }

  private int bitField0_;
  private int infrastructureCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object infrastructure_;

  public enum InfrastructureCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCE_SETUP(2),
    INFRASTRUCTURE_NOT_SET(0);
    private final int value;

    private InfrastructureCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InfrastructureCase valueOf(int value) {
      return forNumber(value);
    }

    public static InfrastructureCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCE_SETUP;
        case 0:
          return INFRASTRUCTURE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InfrastructureCase getInfrastructureCase() {
    return InfrastructureCase.forNumber(infrastructureCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of this notebook instance. Format:
   * `projects/{project_id}/locations/{location}/instances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of this notebook instance. Format:
   * `projects/{project_id}/locations/{location}/instances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCE_SETUP_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. Compute Engine setup for the notebook. Uses notebook-defined
   * fields.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gceSetup field is set.
   */
  @java.lang.Override
  public boolean hasGceSetup() {
    return infrastructureCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. Compute Engine setup for the notebook. Uses notebook-defined
   * fields.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gceSetup.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.GceSetup getGceSetup() {
    if (infrastructureCase_ == 2) {
      return (com.google.cloud.notebooks.v2.GceSetup) infrastructure_;
    }
    return com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Compute Engine setup for the notebook. Uses notebook-defined
   * fields.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.GceSetupOrBuilder getGceSetupOrBuilder() {
    if (infrastructureCase_ == 2) {
      return (com.google.cloud.notebooks.v2.GceSetup) infrastructure_;
    }
    return com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
  }

  public static final int PROXY_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object proxyUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The proxy endpoint that is used to access the Jupyter
   * notebook.
   * </pre>
   *
   * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The proxyUri.
   */
  @java.lang.Override
  public java.lang.String getProxyUri() {
    java.lang.Object ref = proxyUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      proxyUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The proxy endpoint that is used to access the Jupyter
   * notebook.
   * </pre>
   *
   * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for proxyUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProxyUriBytes() {
    java.lang.Object ref = proxyUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      proxyUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_OWNERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instanceOwners_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Input only. The owner of this instance after creation. Format:
   * `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>
   * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the instanceOwners.
   */
  public com.google.protobuf.ProtocolStringList getInstanceOwnersList() {
    return instanceOwners_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. The owner of this instance after creation. Format:
   * `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>
   * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of instanceOwners.
   */
  public int getInstanceOwnersCount() {
    return instanceOwners_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. The owner of this instance after creation. Format:
   * `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>
   * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The instanceOwners at the given index.
   */
  public java.lang.String getInstanceOwners(int index) {
    return instanceOwners_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Input only. The owner of this instance after creation. Format:
   * `alias&#64;example.com`
   *
   * Currently supports one owner only. If not specified, all of the service
   * account users of your VM instance's service account can use
   * the instance.
   * </pre>
   *
   * <code>
   * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instanceOwners at the given index.
   */
  public com.google.protobuf.ByteString getInstanceOwnersBytes(int index) {
    return instanceOwners_.getByteString(index);
  }

  public static final int CREATOR_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creator_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Email address of entity that sent original CreateInstance
   * request.
   * </pre>
   *
   * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  @java.lang.Override
  public java.lang.String getCreator() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Email address of entity that sent original CreateInstance
   * request.
   * </pre>
   *
   * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatorBytes() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of this instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of this instance.
   * </pre>
   *
   * <code>.google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.State getState() {
    com.google.cloud.notebooks.v2.State result =
        com.google.cloud.notebooks.v2.State.forNumber(state_);
    return result == null ? com.google.cloud.notebooks.v2.State.UNRECOGNIZED : result;
  }

  public static final int UPGRADE_HISTORY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.notebooks.v2.UpgradeHistoryEntry> upgradeHistory_;
  /**
   *
   *
   * <pre>
   * Output only. The upgrade history of this instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.notebooks.v2.UpgradeHistoryEntry> getUpgradeHistoryList() {
    return upgradeHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The upgrade history of this instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder>
      getUpgradeHistoryOrBuilderList() {
    return upgradeHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The upgrade history of this instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getUpgradeHistoryCount() {
    return upgradeHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The upgrade history of this instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.UpgradeHistoryEntry getUpgradeHistory(int index) {
    return upgradeHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The upgrade history of this instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder getUpgradeHistoryOrBuilder(
      int index) {
    return upgradeHistory_.get(index);
  }

  public static final int ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique ID of the resource.
   * </pre>
   *
   * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique ID of the resource.
   * </pre>
   *
   * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_STATE_FIELD_NUMBER = 9;
  private int healthState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Instance health_state.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for healthState.
   */
  @java.lang.Override
  public int getHealthStateValue() {
    return healthState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance health_state.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The healthState.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.HealthState getHealthState() {
    com.google.cloud.notebooks.v2.HealthState result =
        com.google.cloud.notebooks.v2.HealthState.forNumber(healthState_);
    return result == null ? com.google.cloud.notebooks.v2.HealthState.UNRECOGNIZED : result;
  }

  public static final int HEALTH_INFO_FIELD_NUMBER = 10;

  private static final class HealthInfoDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.notebooks.v2.InstanceProto
                .internal_static_google_cloud_notebooks_v2_Instance_HealthInfoEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> healthInfo_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHealthInfo() {
    if (healthInfo_ == null) {
      return com.google.protobuf.MapField.emptyMapField(HealthInfoDefaultEntryHolder.defaultEntry);
    }
    return healthInfo_;
  }

  public int getHealthInfoCount() {
    return internalGetHealthInfo().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about instance health.
   * Example:
   *
   *     healthInfo": {
   *       "docker_proxy_agent_status": "1",
   *       "docker_status": "1",
   *       "jupyterlab_api_status": "-1",
   *       "jupyterlab_status": "-1",
   *       "updated": "2020-10-18 09:40:03.573409"
   *     }
   * </pre>
   *
   * <code>map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsHealthInfo(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetHealthInfo().getMap().containsKey(key);
  }
  /** Use {@link #getHealthInfoMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getHealthInfo() {
    return getHealthInfoMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about instance health.
   * Example:
   *
   *     healthInfo": {
   *       "docker_proxy_agent_status": "1",
   *       "docker_status": "1",
   *       "jupyterlab_api_status": "-1",
   *       "jupyterlab_status": "-1",
   *       "updated": "2020-10-18 09:40:03.573409"
   *     }
   * </pre>
   *
   * <code>map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getHealthInfoMap() {
    return internalGetHealthInfo().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about instance health.
   * Example:
   *
   *     healthInfo": {
   *       "docker_proxy_agent_status": "1",
   *       "docker_status": "1",
   *       "jupyterlab_api_status": "-1",
   *       "jupyterlab_status": "-1",
   *       "updated": "2020-10-18 09:40:03.573409"
   *     }
   * </pre>
   *
   * <code>map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getHealthInfoOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHealthInfo().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about instance health.
   * Example:
   *
   *     healthInfo": {
   *       "docker_proxy_agent_status": "1",
   *       "docker_status": "1",
   *       "jupyterlab_api_status": "-1",
   *       "jupyterlab_status": "-1",
   *       "updated": "2020-10-18 09:40:03.573409"
   *     }
   * </pre>
   *
   * <code>map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getHealthInfoOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHealthInfo().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Instance creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Instance update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Instance update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DISABLE_PROXY_ACCESS_FIELD_NUMBER = 13;
  private boolean disableProxyAccess_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If true, the notebook instance will not register with the proxy.
   * </pre>
   *
   * <code>bool disable_proxy_access = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableProxyAccess.
   */
  @java.lang.Override
  public boolean getDisableProxyAccess() {
    return disableProxyAccess_;
  }

  public static final int LABELS_FIELD_NUMBER = 14;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.notebooks.v2.InstanceProto
                .internal_static_google_cloud_notebooks_v2_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to apply to this instance.
   * These can be later modified by the UpdateInstance method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to apply to this instance.
   * These can be later modified by the UpdateInstance method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to apply to this instance.
   * These can be later modified by the UpdateInstance method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to apply to this instance.
   * These can be later modified by the UpdateInstance method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (infrastructureCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.notebooks.v2.GceSetup) infrastructure_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(proxyUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, proxyUri_);
    }
    for (int i = 0; i < instanceOwners_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, instanceOwners_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, creator_);
    }
    if (state_ != com.google.cloud.notebooks.v2.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    for (int i = 0; i < upgradeHistory_.size(); i++) {
      output.writeMessage(7, upgradeHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, id_);
    }
    if (healthState_
        != com.google.cloud.notebooks.v2.HealthState.HEALTH_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, healthState_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHealthInfo(), HealthInfoDefaultEntryHolder.defaultEntry, 10);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getUpdateTime());
    }
    if (disableProxyAccess_ != false) {
      output.writeBool(13, disableProxyAccess_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 14);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (infrastructureCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.notebooks.v2.GceSetup) infrastructure_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(proxyUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, proxyUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceOwners_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceOwners_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInstanceOwnersList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, creator_);
    }
    if (state_ != com.google.cloud.notebooks.v2.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    for (int i = 0; i < upgradeHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, upgradeHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, id_);
    }
    if (healthState_
        != com.google.cloud.notebooks.v2.HealthState.HEALTH_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, healthState_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetHealthInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> healthInfo__ =
          HealthInfoDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, healthInfo__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    if (disableProxyAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, disableProxyAccess_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v2.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v2.Instance other = (com.google.cloud.notebooks.v2.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getProxyUri().equals(other.getProxyUri())) return false;
    if (!getInstanceOwnersList().equals(other.getInstanceOwnersList())) return false;
    if (!getCreator().equals(other.getCreator())) return false;
    if (state_ != other.state_) return false;
    if (!getUpgradeHistoryList().equals(other.getUpgradeHistoryList())) return false;
    if (!getId().equals(other.getId())) return false;
    if (healthState_ != other.healthState_) return false;
    if (!internalGetHealthInfo().equals(other.internalGetHealthInfo())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getDisableProxyAccess() != other.getDisableProxyAccess()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getInfrastructureCase().equals(other.getInfrastructureCase())) return false;
    switch (infrastructureCase_) {
      case 2:
        if (!getGceSetup().equals(other.getGceSetup())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROXY_URI_FIELD_NUMBER;
    hash = (53 * hash) + getProxyUri().hashCode();
    if (getInstanceOwnersCount() > 0) {
      hash = (37 * hash) + INSTANCE_OWNERS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceOwnersList().hashCode();
    }
    hash = (37 * hash) + CREATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCreator().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getUpgradeHistoryCount() > 0) {
      hash = (37 * hash) + UPGRADE_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getUpgradeHistoryList().hashCode();
    }
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + HEALTH_STATE_FIELD_NUMBER;
    hash = (53 * hash) + healthState_;
    if (!internalGetHealthInfo().getMap().isEmpty()) {
      hash = (37 * hash) + HEALTH_INFO_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHealthInfo().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DISABLE_PROXY_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableProxyAccess());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    switch (infrastructureCase_) {
      case 2:
        hash = (37 * hash) + GCE_SETUP_FIELD_NUMBER;
        hash = (53 * hash) + getGceSetup().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Instance parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v2.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of a notebook instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v2.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v2.Instance)
      com.google.cloud.notebooks.v2.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.InstanceProto
          .internal_static_google_cloud_notebooks_v2_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetHealthInfo();
        case 14:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableHealthInfo();
        case 14:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v2.InstanceProto
          .internal_static_google_cloud_notebooks_v2_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v2.Instance.class,
              com.google.cloud.notebooks.v2.Instance.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v2.Instance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpgradeHistoryFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (gceSetupBuilder_ != null) {
        gceSetupBuilder_.clear();
      }
      proxyUri_ = "";
      instanceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
      creator_ = "";
      state_ = 0;
      if (upgradeHistoryBuilder_ == null) {
        upgradeHistory_ = java.util.Collections.emptyList();
      } else {
        upgradeHistory_ = null;
        upgradeHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      id_ = "";
      healthState_ = 0;
      internalGetMutableHealthInfo().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      disableProxyAccess_ = false;
      internalGetMutableLabels().clear();
      infrastructureCase_ = 0;
      infrastructure_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v2.InstanceProto
          .internal_static_google_cloud_notebooks_v2_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.Instance getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v2.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.Instance build() {
      com.google.cloud.notebooks.v2.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.Instance buildPartial() {
      com.google.cloud.notebooks.v2.Instance result =
          new com.google.cloud.notebooks.v2.Instance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.notebooks.v2.Instance result) {
      if (upgradeHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          upgradeHistory_ = java.util.Collections.unmodifiableList(upgradeHistory_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.upgradeHistory_ = upgradeHistory_;
      } else {
        result.upgradeHistory_ = upgradeHistoryBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.notebooks.v2.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.proxyUri_ = proxyUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        instanceOwners_.makeImmutable();
        result.instanceOwners_ = instanceOwners_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.creator_ = creator_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.healthState_ = healthState_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.healthInfo_ = internalGetHealthInfo();
        result.healthInfo_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.disableProxyAccess_ = disableProxyAccess_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.notebooks.v2.Instance result) {
      result.infrastructureCase_ = infrastructureCase_;
      result.infrastructure_ = this.infrastructure_;
      if (infrastructureCase_ == 2 && gceSetupBuilder_ != null) {
        result.infrastructure_ = gceSetupBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v2.Instance) {
        return mergeFrom((com.google.cloud.notebooks.v2.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v2.Instance other) {
      if (other == com.google.cloud.notebooks.v2.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProxyUri().isEmpty()) {
        proxyUri_ = other.proxyUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.instanceOwners_.isEmpty()) {
        if (instanceOwners_.isEmpty()) {
          instanceOwners_ = other.instanceOwners_;
          bitField0_ |= 0x00000008;
        } else {
          ensureInstanceOwnersIsMutable();
          instanceOwners_.addAll(other.instanceOwners_);
        }
        onChanged();
      }
      if (!other.getCreator().isEmpty()) {
        creator_ = other.creator_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (upgradeHistoryBuilder_ == null) {
        if (!other.upgradeHistory_.isEmpty()) {
          if (upgradeHistory_.isEmpty()) {
            upgradeHistory_ = other.upgradeHistory_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureUpgradeHistoryIsMutable();
            upgradeHistory_.addAll(other.upgradeHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.upgradeHistory_.isEmpty()) {
          if (upgradeHistoryBuilder_.isEmpty()) {
            upgradeHistoryBuilder_.dispose();
            upgradeHistoryBuilder_ = null;
            upgradeHistory_ = other.upgradeHistory_;
            bitField0_ = (bitField0_ & ~0x00000040);
            upgradeHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUpgradeHistoryFieldBuilder()
                    : null;
          } else {
            upgradeHistoryBuilder_.addAllMessages(other.upgradeHistory_);
          }
        }
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.healthState_ != 0) {
        setHealthStateValue(other.getHealthStateValue());
      }
      internalGetMutableHealthInfo().mergeFrom(other.internalGetHealthInfo());
      bitField0_ |= 0x00000200;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getDisableProxyAccess() != false) {
        setDisableProxyAccess(other.getDisableProxyAccess());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00002000;
      switch (other.getInfrastructureCase()) {
        case GCE_SETUP:
          {
            mergeGceSetup(other.getGceSetup());
            break;
          }
        case INFRASTRUCTURE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGceSetupFieldBuilder().getBuilder(), extensionRegistry);
                infrastructureCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                proxyUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceOwnersIsMutable();
                instanceOwners_.add(s);
                break;
              } // case 34
            case 42:
              {
                creator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.cloud.notebooks.v2.UpgradeHistoryEntry m =
                    input.readMessage(
                        com.google.cloud.notebooks.v2.UpgradeHistoryEntry.parser(),
                        extensionRegistry);
                if (upgradeHistoryBuilder_ == null) {
                  ensureUpgradeHistoryIsMutable();
                  upgradeHistory_.add(m);
                } else {
                  upgradeHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                healthState_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> healthInfo__ =
                    input.readMessage(
                        HealthInfoDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableHealthInfo()
                    .getMutableMap()
                    .put(healthInfo__.getKey(), healthInfo__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                disableProxyAccess_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int infrastructureCase_ = 0;
    private java.lang.Object infrastructure_;

    public InfrastructureCase getInfrastructureCase() {
      return InfrastructureCase.forNumber(infrastructureCase_);
    }

    public Builder clearInfrastructure() {
      infrastructureCase_ = 0;
      infrastructure_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.GceSetup,
            com.google.cloud.notebooks.v2.GceSetup.Builder,
            com.google.cloud.notebooks.v2.GceSetupOrBuilder>
        gceSetupBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gceSetup field is set.
     */
    @java.lang.Override
    public boolean hasGceSetup() {
      return infrastructureCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gceSetup.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.GceSetup getGceSetup() {
      if (gceSetupBuilder_ == null) {
        if (infrastructureCase_ == 2) {
          return (com.google.cloud.notebooks.v2.GceSetup) infrastructure_;
        }
        return com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
      } else {
        if (infrastructureCase_ == 2) {
          return gceSetupBuilder_.getMessage();
        }
        return com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGceSetup(com.google.cloud.notebooks.v2.GceSetup value) {
      if (gceSetupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        infrastructure_ = value;
        onChanged();
      } else {
        gceSetupBuilder_.setMessage(value);
      }
      infrastructureCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGceSetup(com.google.cloud.notebooks.v2.GceSetup.Builder builderForValue) {
      if (gceSetupBuilder_ == null) {
        infrastructure_ = builderForValue.build();
        onChanged();
      } else {
        gceSetupBuilder_.setMessage(builderForValue.build());
      }
      infrastructureCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGceSetup(com.google.cloud.notebooks.v2.GceSetup value) {
      if (gceSetupBuilder_ == null) {
        if (infrastructureCase_ == 2
            && infrastructure_ != com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance()) {
          infrastructure_ =
              com.google.cloud.notebooks.v2.GceSetup.newBuilder(
                      (com.google.cloud.notebooks.v2.GceSetup) infrastructure_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          infrastructure_ = value;
        }
        onChanged();
      } else {
        if (infrastructureCase_ == 2) {
          gceSetupBuilder_.mergeFrom(value);
        } else {
          gceSetupBuilder_.setMessage(value);
        }
      }
      infrastructureCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGceSetup() {
      if (gceSetupBuilder_ == null) {
        if (infrastructureCase_ == 2) {
          infrastructureCase_ = 0;
          infrastructure_ = null;
          onChanged();
        }
      } else {
        if (infrastructureCase_ == 2) {
          infrastructureCase_ = 0;
          infrastructure_ = null;
        }
        gceSetupBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.notebooks.v2.GceSetup.Builder getGceSetupBuilder() {
      return getGceSetupFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.GceSetupOrBuilder getGceSetupOrBuilder() {
      if ((infrastructureCase_ == 2) && (gceSetupBuilder_ != null)) {
        return gceSetupBuilder_.getMessageOrBuilder();
      } else {
        if (infrastructureCase_ == 2) {
          return (com.google.cloud.notebooks.v2.GceSetup) infrastructure_;
        }
        return com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Compute Engine setup for the notebook. Uses notebook-defined
     * fields.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.GceSetup gce_setup = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.notebooks.v2.GceSetup,
            com.google.cloud.notebooks.v2.GceSetup.Builder,
            com.google.cloud.notebooks.v2.GceSetupOrBuilder>
        getGceSetupFieldBuilder() {
      if (gceSetupBuilder_ == null) {
        if (!(infrastructureCase_ == 2)) {
          infrastructure_ = com.google.cloud.notebooks.v2.GceSetup.getDefaultInstance();
        }
        gceSetupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.notebooks.v2.GceSetup,
                com.google.cloud.notebooks.v2.GceSetup.Builder,
                com.google.cloud.notebooks.v2.GceSetupOrBuilder>(
                (com.google.cloud.notebooks.v2.GceSetup) infrastructure_,
                getParentForChildren(),
                isClean());
        infrastructure_ = null;
      }
      infrastructureCase_ = 2;
      onChanged();
      return gceSetupBuilder_;
    }

    private java.lang.Object proxyUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     * </pre>
     *
     * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The proxyUri.
     */
    public java.lang.String getProxyUri() {
      java.lang.Object ref = proxyUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        proxyUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     * </pre>
     *
     * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for proxyUri.
     */
    public com.google.protobuf.ByteString getProxyUriBytes() {
      java.lang.Object ref = proxyUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        proxyUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     * </pre>
     *
     * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The proxyUri to set.
     * @return This builder for chaining.
     */
    public Builder setProxyUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      proxyUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     * </pre>
     *
     * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProxyUri() {
      proxyUri_ = getDefaultInstance().getProxyUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     * </pre>
     *
     * <code>string proxy_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for proxyUri to set.
     * @return This builder for chaining.
     */
    public Builder setProxyUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      proxyUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList instanceOwners_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstanceOwnersIsMutable() {
      if (!instanceOwners_.isModifiable()) {
        instanceOwners_ = new com.google.protobuf.LazyStringArrayList(instanceOwners_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the instanceOwners.
     */
    public com.google.protobuf.ProtocolStringList getInstanceOwnersList() {
      instanceOwners_.makeImmutable();
      return instanceOwners_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of instanceOwners.
     */
    public int getInstanceOwnersCount() {
      return instanceOwners_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The instanceOwners at the given index.
     */
    public java.lang.String getInstanceOwners(int index) {
      return instanceOwners_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instanceOwners at the given index.
     */
    public com.google.protobuf.ByteString getInstanceOwnersBytes(int index) {
      return instanceOwners_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The instanceOwners to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceOwners(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceOwnersIsMutable();
      instanceOwners_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The instanceOwners to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceOwners(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceOwnersIsMutable();
      instanceOwners_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The instanceOwners to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstanceOwners(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceOwnersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceOwners_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceOwners() {
      instanceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     *
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     * </pre>
     *
     * <code>
     * repeated string instance_owners = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the instanceOwners to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceOwnersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceOwnersIsMutable();
      instanceOwners_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object creator_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Email address of entity that sent original CreateInstance
     * request.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creator.
     */
    public java.lang.String getCreator() {
      java.lang.Object ref = creator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of entity that sent original CreateInstance
     * request.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for creator.
     */
    public com.google.protobuf.ByteString getCreatorBytes() {
      java.lang.Object ref = creator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of entity that sent original CreateInstance
     * request.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creator_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of entity that sent original CreateInstance
     * request.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreator() {
      creator_ = getDefaultInstance().getCreator();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of entity that sent original CreateInstance
     * request.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creator_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.State getState() {
      com.google.cloud.notebooks.v2.State result =
          com.google.cloud.notebooks.v2.State.forNumber(state_);
      return result == null ? com.google.cloud.notebooks.v2.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.notebooks.v2.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.notebooks.v2.UpgradeHistoryEntry> upgradeHistory_ =
        java.util.Collections.emptyList();

    private void ensureUpgradeHistoryIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        upgradeHistory_ =
            new java.util.ArrayList<com.google.cloud.notebooks.v2.UpgradeHistoryEntry>(
                upgradeHistory_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.UpgradeHistoryEntry,
            com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder,
            com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder>
        upgradeHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.UpgradeHistoryEntry>
        getUpgradeHistoryList() {
      if (upgradeHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(upgradeHistory_);
      } else {
        return upgradeHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getUpgradeHistoryCount() {
      if (upgradeHistoryBuilder_ == null) {
        return upgradeHistory_.size();
      } else {
        return upgradeHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry getUpgradeHistory(int index) {
      if (upgradeHistoryBuilder_ == null) {
        return upgradeHistory_.get(index);
      } else {
        return upgradeHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpgradeHistory(
        int index, com.google.cloud.notebooks.v2.UpgradeHistoryEntry value) {
      if (upgradeHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.set(index, value);
        onChanged();
      } else {
        upgradeHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpgradeHistory(
        int index, com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder builderForValue) {
      if (upgradeHistoryBuilder_ == null) {
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        upgradeHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUpgradeHistory(com.google.cloud.notebooks.v2.UpgradeHistoryEntry value) {
      if (upgradeHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.add(value);
        onChanged();
      } else {
        upgradeHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUpgradeHistory(
        int index, com.google.cloud.notebooks.v2.UpgradeHistoryEntry value) {
      if (upgradeHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.add(index, value);
        onChanged();
      } else {
        upgradeHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUpgradeHistory(
        com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder builderForValue) {
      if (upgradeHistoryBuilder_ == null) {
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.add(builderForValue.build());
        onChanged();
      } else {
        upgradeHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addUpgradeHistory(
        int index, com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder builderForValue) {
      if (upgradeHistoryBuilder_ == null) {
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        upgradeHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllUpgradeHistory(
        java.lang.Iterable<? extends com.google.cloud.notebooks.v2.UpgradeHistoryEntry> values) {
      if (upgradeHistoryBuilder_ == null) {
        ensureUpgradeHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, upgradeHistory_);
        onChanged();
      } else {
        upgradeHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpgradeHistory() {
      if (upgradeHistoryBuilder_ == null) {
        upgradeHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        upgradeHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeUpgradeHistory(int index) {
      if (upgradeHistoryBuilder_ == null) {
        ensureUpgradeHistoryIsMutable();
        upgradeHistory_.remove(index);
        onChanged();
      } else {
        upgradeHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder getUpgradeHistoryBuilder(
        int index) {
      return getUpgradeHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder getUpgradeHistoryOrBuilder(
        int index) {
      if (upgradeHistoryBuilder_ == null) {
        return upgradeHistory_.get(index);
      } else {
        return upgradeHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder>
        getUpgradeHistoryOrBuilderList() {
      if (upgradeHistoryBuilder_ != null) {
        return upgradeHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(upgradeHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder addUpgradeHistoryBuilder() {
      return getUpgradeHistoryFieldBuilder()
          .addBuilder(com.google.cloud.notebooks.v2.UpgradeHistoryEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder addUpgradeHistoryBuilder(
        int index) {
      return getUpgradeHistoryFieldBuilder()
          .addBuilder(
              index, com.google.cloud.notebooks.v2.UpgradeHistoryEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The upgrade history of this instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.notebooks.v2.UpgradeHistoryEntry upgrade_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder>
        getUpgradeHistoryBuilderList() {
      return getUpgradeHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.notebooks.v2.UpgradeHistoryEntry,
            com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder,
            com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder>
        getUpgradeHistoryFieldBuilder() {
      if (upgradeHistoryBuilder_ == null) {
        upgradeHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.notebooks.v2.UpgradeHistoryEntry,
                com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder,
                com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder>(
                upgradeHistory_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        upgradeHistory_ = null;
      }
      return upgradeHistoryBuilder_;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique ID of the resource.
     * </pre>
     *
     * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique ID of the resource.
     * </pre>
     *
     * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique ID of the resource.
     * </pre>
     *
     * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique ID of the resource.
     * </pre>
     *
     * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique ID of the resource.
     * </pre>
     *
     * <code>string id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int healthState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Instance health_state.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for healthState.
     */
    @java.lang.Override
    public int getHealthStateValue() {
      return healthState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance health_state.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthStateValue(int value) {
      healthState_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance health_state.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The healthState.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.HealthState getHealthState() {
      com.google.cloud.notebooks.v2.HealthState result =
          com.google.cloud.notebooks.v2.HealthState.forNumber(healthState_);
      return result == null ? com.google.cloud.notebooks.v2.HealthState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance health_state.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The healthState to set.
     * @return This builder for chaining.
     */
    public Builder setHealthState(com.google.cloud.notebooks.v2.HealthState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      healthState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance health_state.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.HealthState health_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      healthState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> healthInfo_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetHealthInfo() {
      if (healthInfo_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            HealthInfoDefaultEntryHolder.defaultEntry);
      }
      return healthInfo_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableHealthInfo() {
      if (healthInfo_ == null) {
        healthInfo_ =
            com.google.protobuf.MapField.newMapField(HealthInfoDefaultEntryHolder.defaultEntry);
      }
      if (!healthInfo_.isMutable()) {
        healthInfo_ = healthInfo_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return healthInfo_;
    }

    public int getHealthInfoCount() {
      return internalGetHealthInfo().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsHealthInfo(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHealthInfo().getMap().containsKey(key);
    }
    /** Use {@link #getHealthInfoMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHealthInfo() {
      return getHealthInfoMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHealthInfoMap() {
      return internalGetHealthInfo().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getHealthInfoOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHealthInfo().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getHealthInfoOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHealthInfo().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearHealthInfo() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableHealthInfo().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeHealthInfo(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableHealthInfo().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableHealthInfo() {
      bitField0_ |= 0x00000200;
      return internalGetMutableHealthInfo().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putHealthInfo(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableHealthInfo().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about instance health.
     * Example:
     *
     *     healthInfo": {
     *       "docker_proxy_agent_status": "1",
     *       "docker_status": "1",
     *       "jupyterlab_api_status": "-1",
     *       "jupyterlab_status": "-1",
     *       "updated": "2020-10-18 09:40:03.573409"
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; health_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllHealthInfo(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableHealthInfo().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instance update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean disableProxyAccess_;
    /**
     *
     *
     * <pre>
     * Optional. If true, the notebook instance will not register with the proxy.
     * </pre>
     *
     * <code>bool disable_proxy_access = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableProxyAccess.
     */
    @java.lang.Override
    public boolean getDisableProxyAccess() {
      return disableProxyAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, the notebook instance will not register with the proxy.
     * </pre>
     *
     * <code>bool disable_proxy_access = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disableProxyAccess to set.
     * @return This builder for chaining.
     */
    public Builder setDisableProxyAccess(boolean value) {

      disableProxyAccess_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, the notebook instance will not register with the proxy.
     * </pre>
     *
     * <code>bool disable_proxy_access = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableProxyAccess() {
      bitField0_ = (bitField0_ & ~0x00001000);
      disableProxyAccess_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00002000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00002000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00002000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to apply to this instance.
     * These can be later modified by the UpdateInstance method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00002000;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v2.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v2.Instance)
  private static final com.google.cloud.notebooks.v2.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v2.Instance();
  }

  public static com.google.cloud.notebooks.v2.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v2.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
