/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/gce_setup.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

/**
 *
 *
 * <pre>
 * The definition of a network interface resource attached to a VM.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v2.NetworkInterface}
 */
public final class NetworkInterface extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v2.NetworkInterface)
    NetworkInterfaceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkInterface.newBuilder() to construct.
  private NetworkInterface(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkInterface() {
    network_ = "";
    subnet_ = "";
    nicType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkInterface();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v2.GceSetupProto
        .internal_static_google_cloud_notebooks_v2_NetworkInterface_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v2.GceSetupProto
        .internal_static_google_cloud_notebooks_v2_NetworkInterface_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v2.NetworkInterface.class,
            com.google.cloud.notebooks.v2.NetworkInterface.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of vNIC driver.
   * Default should be NIC_TYPE_UNSPECIFIED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v2.NetworkInterface.NicType}
   */
  public enum NicType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No type specified.
     * </pre>
     *
     * <code>NIC_TYPE_UNSPECIFIED = 0;</code>
     */
    NIC_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * VIRTIO
     * </pre>
     *
     * <code>VIRTIO_NET = 1;</code>
     */
    VIRTIO_NET(1),
    /**
     *
     *
     * <pre>
     * GVNIC
     * </pre>
     *
     * <code>GVNIC = 2;</code>
     */
    GVNIC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No type specified.
     * </pre>
     *
     * <code>NIC_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int NIC_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * VIRTIO
     * </pre>
     *
     * <code>VIRTIO_NET = 1;</code>
     */
    public static final int VIRTIO_NET_VALUE = 1;
    /**
     *
     *
     * <pre>
     * GVNIC
     * </pre>
     *
     * <code>GVNIC = 2;</code>
     */
    public static final int GVNIC_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NicType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NicType forNumber(int value) {
      switch (value) {
        case 0:
          return NIC_TYPE_UNSPECIFIED;
        case 1:
          return VIRTIO_NET;
        case 2:
          return GVNIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NicType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NicType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NicType>() {
          public NicType findValueByNumber(int number) {
            return NicType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.NetworkInterface.getDescriptor().getEnumTypes().get(0);
    }

    private static final NicType[] VALUES = values();

    public static NicType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NicType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v2.NetworkInterface.NicType)
  }

  public static final int NETWORK_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the VPC that this VM instance is in.
   * Format:
   * `projects/{project_id}/global/networks/{network_id}`
   * </pre>
   *
   * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the VPC that this VM instance is in.
   * Format:
   * `projects/{project_id}/global/networks/{network_id}`
   * </pre>
   *
   * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnet_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the subnet that this VM instance is in.
   * Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * </pre>
   *
   * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The subnet.
   */
  @java.lang.Override
  public java.lang.String getSubnet() {
    java.lang.Object ref = subnet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the subnet that this VM instance is in.
   * Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * </pre>
   *
   * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for subnet.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetBytes() {
    java.lang.Object ref = subnet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NIC_TYPE_FIELD_NUMBER = 3;
  private int nicType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of vNIC to be used on this interface. This may be gVNIC
   * or VirtioNet.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for nicType.
   */
  @java.lang.Override
  public int getNicTypeValue() {
    return nicType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of vNIC to be used on this interface. This may be gVNIC
   * or VirtioNet.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nicType.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.NetworkInterface.NicType getNicType() {
    com.google.cloud.notebooks.v2.NetworkInterface.NicType result =
        com.google.cloud.notebooks.v2.NetworkInterface.NicType.forNumber(nicType_);
    return result == null
        ? com.google.cloud.notebooks.v2.NetworkInterface.NicType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnet_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subnet_);
    }
    if (nicType_
        != com.google.cloud.notebooks.v2.NetworkInterface.NicType.NIC_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, nicType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnet_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subnet_);
    }
    if (nicType_
        != com.google.cloud.notebooks.v2.NetworkInterface.NicType.NIC_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, nicType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v2.NetworkInterface)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v2.NetworkInterface other =
        (com.google.cloud.notebooks.v2.NetworkInterface) obj;

    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getSubnet().equals(other.getSubnet())) return false;
    if (nicType_ != other.nicType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + SUBNET_FIELD_NUMBER;
    hash = (53 * hash) + getSubnet().hashCode();
    hash = (37 * hash) + NIC_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + nicType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v2.NetworkInterface prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of a network interface resource attached to a VM.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v2.NetworkInterface}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v2.NetworkInterface)
      com.google.cloud.notebooks.v2.NetworkInterfaceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.GceSetupProto
          .internal_static_google_cloud_notebooks_v2_NetworkInterface_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v2.GceSetupProto
          .internal_static_google_cloud_notebooks_v2_NetworkInterface_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v2.NetworkInterface.class,
              com.google.cloud.notebooks.v2.NetworkInterface.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v2.NetworkInterface.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      network_ = "";
      subnet_ = "";
      nicType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v2.GceSetupProto
          .internal_static_google_cloud_notebooks_v2_NetworkInterface_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.NetworkInterface getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v2.NetworkInterface.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.NetworkInterface build() {
      com.google.cloud.notebooks.v2.NetworkInterface result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.NetworkInterface buildPartial() {
      com.google.cloud.notebooks.v2.NetworkInterface result =
          new com.google.cloud.notebooks.v2.NetworkInterface(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.notebooks.v2.NetworkInterface result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.subnet_ = subnet_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nicType_ = nicType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v2.NetworkInterface) {
        return mergeFrom((com.google.cloud.notebooks.v2.NetworkInterface) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v2.NetworkInterface other) {
      if (other == com.google.cloud.notebooks.v2.NetworkInterface.getDefaultInstance()) return this;
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSubnet().isEmpty()) {
        subnet_ = other.subnet_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.nicType_ != 0) {
        setNicTypeValue(other.getNicTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                subnet_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                nicType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the VPC that this VM instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the VPC that this VM instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the VPC that this VM instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the VPC that this VM instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the VPC that this VM instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object subnet_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the subnet that this VM instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subnet.
     */
    public java.lang.String getSubnet() {
      java.lang.Object ref = subnet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the subnet that this VM instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subnet.
     */
    public com.google.protobuf.ByteString getSubnetBytes() {
      java.lang.Object ref = subnet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the subnet that this VM instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The subnet to set.
     * @return This builder for chaining.
     */
    public Builder setSubnet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnet_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the subnet that this VM instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnet() {
      subnet_ = getDefaultInstance().getSubnet();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the subnet that this VM instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>string subnet = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for subnet to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnet_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int nicType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC
     * or VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for nicType.
     */
    @java.lang.Override
    public int getNicTypeValue() {
      return nicType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC
     * or VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for nicType to set.
     * @return This builder for chaining.
     */
    public Builder setNicTypeValue(int value) {
      nicType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC
     * or VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nicType.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.NetworkInterface.NicType getNicType() {
      com.google.cloud.notebooks.v2.NetworkInterface.NicType result =
          com.google.cloud.notebooks.v2.NetworkInterface.NicType.forNumber(nicType_);
      return result == null
          ? com.google.cloud.notebooks.v2.NetworkInterface.NicType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC
     * or VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The nicType to set.
     * @return This builder for chaining.
     */
    public Builder setNicType(com.google.cloud.notebooks.v2.NetworkInterface.NicType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      nicType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC
     * or VirtioNet.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.NetworkInterface.NicType nic_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNicType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      nicType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v2.NetworkInterface)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v2.NetworkInterface)
  private static final com.google.cloud.notebooks.v2.NetworkInterface DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v2.NetworkInterface();
  }

  public static com.google.cloud.notebooks.v2.NetworkInterface getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkInterface> PARSER =
      new com.google.protobuf.AbstractParser<NetworkInterface>() {
        @java.lang.Override
        public NetworkInterface parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkInterface> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkInterface> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v2.NetworkInterface getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
