/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/notebooks/v2/instance.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.notebooks.v2;

/**
 *
 *
 * <pre>
 * The entry of VM image upgrade history.
 * </pre>
 *
 * Protobuf type {@code google.cloud.notebooks.v2.UpgradeHistoryEntry}
 */
public final class UpgradeHistoryEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.notebooks.v2.UpgradeHistoryEntry)
    UpgradeHistoryEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpgradeHistoryEntry.newBuilder() to construct.
  private UpgradeHistoryEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpgradeHistoryEntry() {
    snapshot_ = "";
    vmImage_ = "";
    containerImage_ = "";
    framework_ = "";
    version_ = "";
    state_ = 0;
    action_ = 0;
    targetVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpgradeHistoryEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.notebooks.v2.InstanceProto
        .internal_static_google_cloud_notebooks_v2_UpgradeHistoryEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.notebooks.v2.InstanceProto
        .internal_static_google_cloud_notebooks_v2_UpgradeHistoryEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.notebooks.v2.UpgradeHistoryEntry.class,
            com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The definition of the states of this upgrade history entry.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v2.UpgradeHistoryEntry.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State is not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance upgrade is started.
     * </pre>
     *
     * <code>STARTED = 1;</code>
     */
    STARTED(1),
    /**
     *
     *
     * <pre>
     * The instance upgrade is succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The instance upgrade is failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State is not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance upgrade is started.
     * </pre>
     *
     * <code>STARTED = 1;</code>
     */
    public static final int STARTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The instance upgrade is succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The instance upgrade is failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STARTED;
        case 2:
          return SUCCEEDED;
        case 3:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.UpgradeHistoryEntry.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v2.UpgradeHistoryEntry.State)
  }

  /**
   *
   *
   * <pre>
   * The definition of operations of this upgrade history entry.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.notebooks.v2.UpgradeHistoryEntry.Action}
   */
  public enum Action implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Operation is not specified.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    ACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Upgrade.
     * </pre>
     *
     * <code>UPGRADE = 1;</code>
     */
    UPGRADE(1),
    /**
     *
     *
     * <pre>
     * Rollback.
     * </pre>
     *
     * <code>ROLLBACK = 2;</code>
     */
    ROLLBACK(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Operation is not specified.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    public static final int ACTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Upgrade.
     * </pre>
     *
     * <code>UPGRADE = 1;</code>
     */
    public static final int UPGRADE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Rollback.
     * </pre>
     *
     * <code>ROLLBACK = 2;</code>
     */
    public static final int ROLLBACK_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0:
          return ACTION_UNSPECIFIED;
        case 1:
          return UPGRADE;
        case 2:
          return ROLLBACK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Action>() {
          public Action findValueByNumber(int number) {
            return Action.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.UpgradeHistoryEntry.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.notebooks.v2.UpgradeHistoryEntry.Action)
  }

  private int bitField0_;
  public static final int SNAPSHOT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object snapshot_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The snapshot of the boot disk of this notebook instance before
   * upgrade.
   * </pre>
   *
   * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The snapshot.
   */
  @java.lang.Override
  public java.lang.String getSnapshot() {
    java.lang.Object ref = snapshot_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      snapshot_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The snapshot of the boot disk of this notebook instance before
   * upgrade.
   * </pre>
   *
   * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for snapshot.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSnapshotBytes() {
    java.lang.Object ref = snapshot_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      snapshot_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_IMAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vmImage_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The VM image before this instance upgrade.
   * </pre>
   *
   * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The vmImage.
   */
  @java.lang.Override
  public java.lang.String getVmImage() {
    java.lang.Object ref = vmImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vmImage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The VM image before this instance upgrade.
   * </pre>
   *
   * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for vmImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVmImageBytes() {
    java.lang.Object ref = vmImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vmImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_IMAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object containerImage_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The container image before this instance upgrade.
   * </pre>
   *
   * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The containerImage.
   */
  @java.lang.Override
  public java.lang.String getContainerImage() {
    java.lang.Object ref = containerImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerImage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The container image before this instance upgrade.
   * </pre>
   *
   * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for containerImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerImageBytes() {
    java.lang.Object ref = containerImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FRAMEWORK_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object framework_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The framework of this notebook instance.
   * </pre>
   *
   * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The framework.
   */
  @java.lang.Override
  public java.lang.String getFramework() {
    java.lang.Object ref = framework_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      framework_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The framework of this notebook instance.
   * </pre>
   *
   * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for framework.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFrameworkBytes() {
    java.lang.Object ref = framework_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      framework_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The version of the notebook instance before this upgrade.
   * </pre>
   *
   * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The version of the notebook instance before this upgrade.
   * </pre>
   *
   * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of this instance upgrade history entry.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of this instance upgrade history entry.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State getState() {
    com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State result =
        com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State.forNumber(state_);
    return result == null
        ? com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Immutable. The time that this instance upgrade history entry is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Immutable. The time that this instance upgrade history entry is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The time that this instance upgrade history entry is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int ACTION_FIELD_NUMBER = 8;
  private int action_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Action. Rolloback or Upgrade.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for action.
   */
  @java.lang.Override
  public int getActionValue() {
    return action_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Action. Rolloback or Upgrade.
   * </pre>
   *
   * <code>
   * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action getAction() {
    com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action result =
        com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action.forNumber(action_);
    return result == null
        ? com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action.UNRECOGNIZED
        : result;
  }

  public static final int TARGET_VERSION_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetVersion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Target VM Version, like m63.
   * </pre>
   *
   * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The targetVersion.
   */
  @java.lang.Override
  public java.lang.String getTargetVersion() {
    java.lang.Object ref = targetVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Target VM Version, like m63.
   * </pre>
   *
   * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for targetVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetVersionBytes() {
    java.lang.Object ref = targetVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snapshot_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, snapshot_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vmImage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, vmImage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerImage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, containerImage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(framework_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, framework_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, version_);
    }
    if (state_
        != com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (action_
        != com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action.ACTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, targetVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snapshot_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, snapshot_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vmImage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, vmImage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerImage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, containerImage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(framework_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, framework_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, version_);
    }
    if (state_
        != com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (action_
        != com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action.ACTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, action_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, targetVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.notebooks.v2.UpgradeHistoryEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.notebooks.v2.UpgradeHistoryEntry other =
        (com.google.cloud.notebooks.v2.UpgradeHistoryEntry) obj;

    if (!getSnapshot().equals(other.getSnapshot())) return false;
    if (!getVmImage().equals(other.getVmImage())) return false;
    if (!getContainerImage().equals(other.getContainerImage())) return false;
    if (!getFramework().equals(other.getFramework())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (action_ != other.action_) return false;
    if (!getTargetVersion().equals(other.getTargetVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SNAPSHOT_FIELD_NUMBER;
    hash = (53 * hash) + getSnapshot().hashCode();
    hash = (37 * hash) + VM_IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getVmImage().hashCode();
    hash = (37 * hash) + CONTAINER_IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getContainerImage().hashCode();
    hash = (37 * hash) + FRAMEWORK_FIELD_NUMBER;
    hash = (53 * hash) + getFramework().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    hash = (37 * hash) + TARGET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getTargetVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.notebooks.v2.UpgradeHistoryEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The entry of VM image upgrade history.
   * </pre>
   *
   * Protobuf type {@code google.cloud.notebooks.v2.UpgradeHistoryEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.notebooks.v2.UpgradeHistoryEntry)
      com.google.cloud.notebooks.v2.UpgradeHistoryEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.notebooks.v2.InstanceProto
          .internal_static_google_cloud_notebooks_v2_UpgradeHistoryEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.notebooks.v2.InstanceProto
          .internal_static_google_cloud_notebooks_v2_UpgradeHistoryEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.notebooks.v2.UpgradeHistoryEntry.class,
              com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Builder.class);
    }

    // Construct using com.google.cloud.notebooks.v2.UpgradeHistoryEntry.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      snapshot_ = "";
      vmImage_ = "";
      containerImage_ = "";
      framework_ = "";
      version_ = "";
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      action_ = 0;
      targetVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.notebooks.v2.InstanceProto
          .internal_static_google_cloud_notebooks_v2_UpgradeHistoryEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry getDefaultInstanceForType() {
      return com.google.cloud.notebooks.v2.UpgradeHistoryEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry build() {
      com.google.cloud.notebooks.v2.UpgradeHistoryEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry buildPartial() {
      com.google.cloud.notebooks.v2.UpgradeHistoryEntry result =
          new com.google.cloud.notebooks.v2.UpgradeHistoryEntry(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.notebooks.v2.UpgradeHistoryEntry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.snapshot_ = snapshot_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.vmImage_ = vmImage_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.containerImage_ = containerImage_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.framework_ = framework_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.action_ = action_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.targetVersion_ = targetVersion_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.notebooks.v2.UpgradeHistoryEntry) {
        return mergeFrom((com.google.cloud.notebooks.v2.UpgradeHistoryEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.notebooks.v2.UpgradeHistoryEntry other) {
      if (other == com.google.cloud.notebooks.v2.UpgradeHistoryEntry.getDefaultInstance())
        return this;
      if (!other.getSnapshot().isEmpty()) {
        snapshot_ = other.snapshot_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getVmImage().isEmpty()) {
        vmImage_ = other.vmImage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getContainerImage().isEmpty()) {
        containerImage_ = other.containerImage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFramework().isEmpty()) {
        framework_ = other.framework_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      if (!other.getTargetVersion().isEmpty()) {
        targetVersion_ = other.targetVersion_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                snapshot_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                vmImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                containerImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                framework_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                action_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                targetVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object snapshot_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The snapshot of the boot disk of this notebook instance before
     * upgrade.
     * </pre>
     *
     * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The snapshot.
     */
    public java.lang.String getSnapshot() {
      java.lang.Object ref = snapshot_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        snapshot_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The snapshot of the boot disk of this notebook instance before
     * upgrade.
     * </pre>
     *
     * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for snapshot.
     */
    public com.google.protobuf.ByteString getSnapshotBytes() {
      java.lang.Object ref = snapshot_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        snapshot_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The snapshot of the boot disk of this notebook instance before
     * upgrade.
     * </pre>
     *
     * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The snapshot to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshot(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      snapshot_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The snapshot of the boot disk of this notebook instance before
     * upgrade.
     * </pre>
     *
     * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSnapshot() {
      snapshot_ = getDefaultInstance().getSnapshot();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The snapshot of the boot disk of this notebook instance before
     * upgrade.
     * </pre>
     *
     * <code>string snapshot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for snapshot to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      snapshot_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object vmImage_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The VM image before this instance upgrade.
     * </pre>
     *
     * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The vmImage.
     */
    public java.lang.String getVmImage() {
      java.lang.Object ref = vmImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vmImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The VM image before this instance upgrade.
     * </pre>
     *
     * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for vmImage.
     */
    public com.google.protobuf.ByteString getVmImageBytes() {
      java.lang.Object ref = vmImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vmImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The VM image before this instance upgrade.
     * </pre>
     *
     * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The vmImage to set.
     * @return This builder for chaining.
     */
    public Builder setVmImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vmImage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The VM image before this instance upgrade.
     * </pre>
     *
     * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmImage() {
      vmImage_ = getDefaultInstance().getVmImage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The VM image before this instance upgrade.
     * </pre>
     *
     * <code>string vm_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for vmImage to set.
     * @return This builder for chaining.
     */
    public Builder setVmImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vmImage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object containerImage_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The container image before this instance upgrade.
     * </pre>
     *
     * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The containerImage.
     */
    public java.lang.String getContainerImage() {
      java.lang.Object ref = containerImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The container image before this instance upgrade.
     * </pre>
     *
     * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for containerImage.
     */
    public com.google.protobuf.ByteString getContainerImageBytes() {
      java.lang.Object ref = containerImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The container image before this instance upgrade.
     * </pre>
     *
     * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The containerImage to set.
     * @return This builder for chaining.
     */
    public Builder setContainerImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      containerImage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The container image before this instance upgrade.
     * </pre>
     *
     * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerImage() {
      containerImage_ = getDefaultInstance().getContainerImage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The container image before this instance upgrade.
     * </pre>
     *
     * <code>string container_image = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for containerImage to set.
     * @return This builder for chaining.
     */
    public Builder setContainerImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      containerImage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object framework_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The framework of this notebook instance.
     * </pre>
     *
     * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The framework.
     */
    public java.lang.String getFramework() {
      java.lang.Object ref = framework_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        framework_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The framework of this notebook instance.
     * </pre>
     *
     * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for framework.
     */
    public com.google.protobuf.ByteString getFrameworkBytes() {
      java.lang.Object ref = framework_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        framework_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The framework of this notebook instance.
     * </pre>
     *
     * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The framework to set.
     * @return This builder for chaining.
     */
    public Builder setFramework(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      framework_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The framework of this notebook instance.
     * </pre>
     *
     * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFramework() {
      framework_ = getDefaultInstance().getFramework();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The framework of this notebook instance.
     * </pre>
     *
     * <code>string framework = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for framework to set.
     * @return This builder for chaining.
     */
    public Builder setFrameworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      framework_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The version of the notebook instance before this upgrade.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of the notebook instance before this upgrade.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of the notebook instance before this upgrade.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of the notebook instance before this upgrade.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The version of the notebook instance before this upgrade.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance upgrade history entry.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance upgrade history entry.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance upgrade history entry.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State getState() {
      com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State result =
          com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State.forNumber(state_);
      return result == null
          ? com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance upgrade history entry.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.notebooks.v2.UpgradeHistoryEntry.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this instance upgrade history entry.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The time that this instance upgrade history entry is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int action_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Action. Rolloback or Upgrade.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override
    public int getActionValue() {
      return action_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action. Rolloback or Upgrade.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionValue(int value) {
      action_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action. Rolloback or Upgrade.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action getAction() {
      com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action result =
          com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action.forNumber(action_);
      return result == null
          ? com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action. Rolloback or Upgrade.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(com.google.cloud.notebooks.v2.UpgradeHistoryEntry.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      action_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Action. Rolloback or Upgrade.
     * </pre>
     *
     * <code>
     * .google.cloud.notebooks.v2.UpgradeHistoryEntry.Action action = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      bitField0_ = (bitField0_ & ~0x00000080);
      action_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object targetVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Target VM Version, like m63.
     * </pre>
     *
     * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The targetVersion.
     */
    public java.lang.String getTargetVersion() {
      java.lang.Object ref = targetVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Target VM Version, like m63.
     * </pre>
     *
     * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for targetVersion.
     */
    public com.google.protobuf.ByteString getTargetVersionBytes() {
      java.lang.Object ref = targetVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Target VM Version, like m63.
     * </pre>
     *
     * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The targetVersion to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetVersion_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Target VM Version, like m63.
     * </pre>
     *
     * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetVersion() {
      targetVersion_ = getDefaultInstance().getTargetVersion();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Target VM Version, like m63.
     * </pre>
     *
     * <code>string target_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for targetVersion to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetVersion_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.notebooks.v2.UpgradeHistoryEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.notebooks.v2.UpgradeHistoryEntry)
  private static final com.google.cloud.notebooks.v2.UpgradeHistoryEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.notebooks.v2.UpgradeHistoryEntry();
  }

  public static com.google.cloud.notebooks.v2.UpgradeHistoryEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpgradeHistoryEntry> PARSER =
      new com.google.protobuf.AbstractParser<UpgradeHistoryEntry>() {
        @java.lang.Override
        public UpgradeHistoryEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpgradeHistoryEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpgradeHistoryEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.notebooks.v2.UpgradeHistoryEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
