/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1;

/**
 *
 *
 * <pre>
 * The configuration information for the Kubernetes Engine nodes running
 * the Apache Airflow software.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1.NodeConfig}
 */
public final class NodeConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1.NodeConfig)
    NodeConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeConfig.newBuilder() to construct.
  private NodeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeConfig() {
    location_ = "";
    machineType_ = "";
    network_ = "";
    subnetwork_ = "";
    oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccount_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1_NodeConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1_NodeConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1.NodeConfig.class,
            com.google.cloud.orchestration.airflow.service.v1.NodeConfig.Builder.class);
  }

  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
   * to deploy the VMs used to run the Apache Airflow software, specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/zones/{zoneId}".
   *
   * This `location` must belong to the enclosing environment's project and
   * location. If both this field and `nodeConfig.machineType` are specified,
   * `nodeConfig.machineType` must belong to this `location`; if both are
   * unspecified, the service will pick a zone in the Compute Engine region
   * corresponding to the Cloud Composer location, and propagate that choice to
   * both fields. If only one field (`location` or `nodeConfig.machineType`) is
   * specified, the location information from the specified field will be
   * propagated to the unspecified field.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string location = 1;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
   * to deploy the VMs used to run the Apache Airflow software, specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/zones/{zoneId}".
   *
   * This `location` must belong to the enclosing environment's project and
   * location. If both this field and `nodeConfig.machineType` are specified,
   * `nodeConfig.machineType` must belong to this `location`; if both are
   * unspecified, the service will pick a zone in the Compute Engine region
   * corresponding to the Cloud Composer location, and propagate that choice to
   * both fields. If only one field (`location` or `nodeConfig.machineType`) is
   * specified, the location information from the specified field will be
   * propagated to the unspecified field.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string location = 1;</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine
   * [machine type](/compute/docs/machine-types) used for cluster instances,
   * specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
   *
   * The `machineType` must belong to the enclosing environment's project and
   * location. If both this field and `nodeConfig.location` are specified,
   * this `machineType` must belong to the `nodeConfig.location`; if both are
   * unspecified, the service will pick a zone in the Compute Engine region
   * corresponding to the Cloud Composer location, and propagate that choice to
   * both fields. If exactly one of this field and `nodeConfig.location` is
   * specified, the location information from the specified field will be
   * propagated to the unspecified field.
   *
   * The `machineTypeId` must not be a [shared-core machine
   * type](/compute/docs/machine-types#sharedcore).
   *
   * If this field is unspecified, the `machineTypeId` defaults
   * to "n1-standard-1".
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string machine_type = 2;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine
   * [machine type](/compute/docs/machine-types) used for cluster instances,
   * specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
   *
   * The `machineType` must belong to the enclosing environment's project and
   * location. If both this field and `nodeConfig.location` are specified,
   * this `machineType` must belong to the `nodeConfig.location`; if both are
   * unspecified, the service will pick a zone in the Compute Engine region
   * corresponding to the Cloud Composer location, and propagate that choice to
   * both fields. If exactly one of this field and `nodeConfig.location` is
   * specified, the location information from the specified field will be
   * propagated to the unspecified field.
   *
   * The `machineTypeId` must not be a [shared-core machine
   * type](/compute/docs/machine-types#sharedcore).
   *
   * If this field is unspecified, the `machineTypeId` defaults
   * to "n1-standard-1".
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string machine_type = 2;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine network to be used for machine
   * communications, specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/global/networks/{networkId}".
   *
   * If unspecified, the "default" network ID in the environment's project is
   * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
   * is provided, `nodeConfig.subnetwork` must also be provided. For
   * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
   * `nodeConfig.subnetwork`.
   * </pre>
   *
   * <code>string network = 3;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine network to be used for machine
   * communications, specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/global/networks/{networkId}".
   *
   * If unspecified, the "default" network ID in the environment's project is
   * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
   * is provided, `nodeConfig.subnetwork` must also be provided. For
   * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
   * `nodeConfig.subnetwork`.
   * </pre>
   *
   * <code>string network = 3;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine subnetwork to be used for machine
   * communications, specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
   *
   * If a subnetwork is provided, `nodeConfig.network` must also be provided,
   * and the subnetwork must belong to the enclosing environment's project and
   * location.
   * </pre>
   *
   * <code>string subnetwork = 4;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine subnetwork to be used for machine
   * communications, specified as a
   * [relative resource
   * name](/apis/design/resource_names#relative_resource_name). For example:
   * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
   *
   * If a subnetwork is provided, `nodeConfig.network` must also be provided,
   * and the subnetwork must belong to the enclosing environment's project and
   * location.
   * </pre>
   *
   * <code>string subnetwork = 4;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 5;
  private int diskSizeGb_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The disk size in GB used for node VMs. Minimum size is 30GB.
   * If unspecified, defaults to 100GB. Cannot be updated.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>int32 disk_size_gb = 5;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public int getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int OAUTH_SCOPES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList oauthScopes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The set of Google API scopes to be made available on all
   * node VMs. If `oauth_scopes` is empty, defaults to
   * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 6;</code>
   *
   * @return A list containing the oauthScopes.
   */
  public com.google.protobuf.ProtocolStringList getOauthScopesList() {
    return oauthScopes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The set of Google API scopes to be made available on all
   * node VMs. If `oauth_scopes` is empty, defaults to
   * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 6;</code>
   *
   * @return The count of oauthScopes.
   */
  public int getOauthScopesCount() {
    return oauthScopes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The set of Google API scopes to be made available on all
   * node VMs. If `oauth_scopes` is empty, defaults to
   * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The oauthScopes at the given index.
   */
  public java.lang.String getOauthScopes(int index) {
    return oauthScopes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The set of Google API scopes to be made available on all
   * node VMs. If `oauth_scopes` is empty, defaults to
   * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the oauthScopes at the given index.
   */
  public com.google.protobuf.ByteString getOauthScopesBytes(int index) {
    return oauthScopes_.getByteString(index);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Google Cloud Platform Service Account to be used by the node
   * VMs. If a service account is not specified, the "default" Compute Engine
   * service account is used. Cannot be updated.
   * </pre>
   *
   * <code>string service_account = 7;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Google Cloud Platform Service Account to be used by the node
   * VMs. If a service account is not specified, the "default" Compute Engine
   * service account is used. Cannot be updated.
   * </pre>
   *
   * <code>string service_account = 7;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAGS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The list of instance tags applied to all node VMs. Tags are used
   * to identify valid sources or targets for network firewalls. Each tag within
   * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Cannot be updated.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of instance tags applied to all node VMs. Tags are used
   * to identify valid sources or targets for network firewalls. Each tag within
   * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Cannot be updated.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of instance tags applied to all node VMs. Tags are used
   * to identify valid sources or targets for network firewalls. Each tag within
   * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Cannot be updated.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of instance tags applied to all node VMs. Tags are used
   * to identify valid sources or targets for network firewalls. Each tag within
   * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Cannot be updated.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int IP_ALLOCATION_POLICY_FIELD_NUMBER = 9;
  private com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ipAllocationPolicy_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration for controlling how IPs are allocated in the
   * GKE cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ipAllocationPolicy field is set.
   */
  @java.lang.Override
  public boolean hasIpAllocationPolicy() {
    return ipAllocationPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration for controlling how IPs are allocated in the
   * GKE cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ipAllocationPolicy.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
      getIpAllocationPolicy() {
    return ipAllocationPolicy_ == null
        ? com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.getDefaultInstance()
        : ipAllocationPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration for controlling how IPs are allocated in the
   * GKE cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicyOrBuilder
      getIpAllocationPolicyOrBuilder() {
    return ipAllocationPolicy_ == null
        ? com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.getDefaultInstance()
        : ipAllocationPolicy_;
  }

  public static final int ENABLE_IP_MASQ_AGENT_FIELD_NUMBER = 11;
  private boolean enableIpMasqAgent_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines
   * nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for
   * all destination addresses, except between pods traffic.
   *
   * See:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
   * </pre>
   *
   * <code>bool enable_ip_masq_agent = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableIpMasqAgent.
   */
  @java.lang.Override
  public boolean getEnableIpMasqAgent() {
    return enableIpMasqAgent_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, machineType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, subnetwork_);
    }
    if (diskSizeGb_ != 0) {
      output.writeInt32(5, diskSizeGb_);
    }
    for (int i = 0; i < oauthScopes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, oauthScopes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serviceAccount_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, tags_.getRaw(i));
    }
    if (ipAllocationPolicy_ != null) {
      output.writeMessage(9, getIpAllocationPolicy());
    }
    if (enableIpMasqAgent_ != false) {
      output.writeBool(11, enableIpMasqAgent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, machineType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, subnetwork_);
    }
    if (diskSizeGb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, diskSizeGb_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < oauthScopes_.size(); i++) {
        dataSize += computeStringSizeNoTag(oauthScopes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOauthScopesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serviceAccount_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    if (ipAllocationPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getIpAllocationPolicy());
    }
    if (enableIpMasqAgent_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableIpMasqAgent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orchestration.airflow.service.v1.NodeConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1.NodeConfig other =
        (com.google.cloud.orchestration.airflow.service.v1.NodeConfig) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (!getMachineType().equals(other.getMachineType())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    if (!getOauthScopesList().equals(other.getOauthScopesList())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (hasIpAllocationPolicy() != other.hasIpAllocationPolicy()) return false;
    if (hasIpAllocationPolicy()) {
      if (!getIpAllocationPolicy().equals(other.getIpAllocationPolicy())) return false;
    }
    if (getEnableIpMasqAgent() != other.getEnableIpMasqAgent()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetwork().hashCode();
    hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + getDiskSizeGb();
    if (getOauthScopesCount() > 0) {
      hash = (37 * hash) + OAUTH_SCOPES_FIELD_NUMBER;
      hash = (53 * hash) + getOauthScopesList().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (hasIpAllocationPolicy()) {
      hash = (37 * hash) + IP_ALLOCATION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getIpAllocationPolicy().hashCode();
    }
    hash = (37 * hash) + ENABLE_IP_MASQ_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIpMasqAgent());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1.NodeConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration information for the Kubernetes Engine nodes running
   * the Apache Airflow software.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1.NodeConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1.NodeConfig)
      com.google.cloud.orchestration.airflow.service.v1.NodeConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_NodeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_NodeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1.NodeConfig.class,
              com.google.cloud.orchestration.airflow.service.v1.NodeConfig.Builder.class);
    }

    // Construct using com.google.cloud.orchestration.airflow.service.v1.NodeConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = "";
      machineType_ = "";
      network_ = "";
      subnetwork_ = "";
      diskSizeGb_ = 0;
      oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceAccount_ = "";
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      ipAllocationPolicy_ = null;
      if (ipAllocationPolicyBuilder_ != null) {
        ipAllocationPolicyBuilder_.dispose();
        ipAllocationPolicyBuilder_ = null;
      }
      enableIpMasqAgent_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_NodeConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.NodeConfig
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1.NodeConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.NodeConfig build() {
      com.google.cloud.orchestration.airflow.service.v1.NodeConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.NodeConfig buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1.NodeConfig result =
          new com.google.cloud.orchestration.airflow.service.v1.NodeConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1.NodeConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.machineType_ = machineType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.subnetwork_ = subnetwork_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        oauthScopes_.makeImmutable();
        result.oauthScopes_ = oauthScopes_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.ipAllocationPolicy_ =
            ipAllocationPolicyBuilder_ == null
                ? ipAllocationPolicy_
                : ipAllocationPolicyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.enableIpMasqAgent_ = enableIpMasqAgent_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orchestration.airflow.service.v1.NodeConfig) {
        return mergeFrom((com.google.cloud.orchestration.airflow.service.v1.NodeConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orchestration.airflow.service.v1.NodeConfig other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1.NodeConfig.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getSubnetwork().isEmpty()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getDiskSizeGb() != 0) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (!other.oauthScopes_.isEmpty()) {
        if (oauthScopes_.isEmpty()) {
          oauthScopes_ = other.oauthScopes_;
          bitField0_ |= 0x00000020;
        } else {
          ensureOauthScopesIsMutable();
          oauthScopes_.addAll(other.oauthScopes_);
        }
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000080;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (other.hasIpAllocationPolicy()) {
        mergeIpAllocationPolicy(other.getIpAllocationPolicy());
      }
      if (other.getEnableIpMasqAgent() != false) {
        setEnableIpMasqAgent(other.getEnableIpMasqAgent());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                diskSizeGb_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureOauthScopesIsMutable();
                oauthScopes_.add(s);
                break;
              } // case 50
            case 58:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getIpAllocationPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 88:
              {
                enableIpMasqAgent_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
     * to deploy the VMs used to run the Apache Airflow software, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}".
     *
     * This `location` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.machineType` are specified,
     * `nodeConfig.machineType` must belong to this `location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If only one field (`location` or `nodeConfig.machineType`) is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
     * to deploy the VMs used to run the Apache Airflow software, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}".
     *
     * This `location` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.machineType` are specified,
     * `nodeConfig.machineType` must belong to this `location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If only one field (`location` or `nodeConfig.machineType`) is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
     * to deploy the VMs used to run the Apache Airflow software, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}".
     *
     * This `location` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.machineType` are specified,
     * `nodeConfig.machineType` must belong to this `location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If only one field (`location` or `nodeConfig.machineType`) is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
     * to deploy the VMs used to run the Apache Airflow software, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}".
     *
     * This `location` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.machineType` are specified,
     * `nodeConfig.machineType` must belong to this `location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If only one field (`location` or `nodeConfig.machineType`) is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
     * to deploy the VMs used to run the Apache Airflow software, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}".
     *
     * This `location` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.machineType` are specified,
     * `nodeConfig.machineType` must belong to this `location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If only one field (`location` or `nodeConfig.machineType`) is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine
     * [machine type](/compute/docs/machine-types) used for cluster instances,
     * specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
     *
     * The `machineType` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.location` are specified,
     * this `machineType` must belong to the `nodeConfig.location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If exactly one of this field and `nodeConfig.location` is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * The `machineTypeId` must not be a [shared-core machine
     * type](/compute/docs/machine-types#sharedcore).
     *
     * If this field is unspecified, the `machineTypeId` defaults
     * to "n1-standard-1".
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine
     * [machine type](/compute/docs/machine-types) used for cluster instances,
     * specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
     *
     * The `machineType` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.location` are specified,
     * this `machineType` must belong to the `nodeConfig.location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If exactly one of this field and `nodeConfig.location` is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * The `machineTypeId` must not be a [shared-core machine
     * type](/compute/docs/machine-types#sharedcore).
     *
     * If this field is unspecified, the `machineTypeId` defaults
     * to "n1-standard-1".
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine
     * [machine type](/compute/docs/machine-types) used for cluster instances,
     * specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
     *
     * The `machineType` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.location` are specified,
     * this `machineType` must belong to the `nodeConfig.location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If exactly one of this field and `nodeConfig.location` is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * The `machineTypeId` must not be a [shared-core machine
     * type](/compute/docs/machine-types#sharedcore).
     *
     * If this field is unspecified, the `machineTypeId` defaults
     * to "n1-standard-1".
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine
     * [machine type](/compute/docs/machine-types) used for cluster instances,
     * specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
     *
     * The `machineType` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.location` are specified,
     * this `machineType` must belong to the `nodeConfig.location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If exactly one of this field and `nodeConfig.location` is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * The `machineTypeId` must not be a [shared-core machine
     * type](/compute/docs/machine-types#sharedcore).
     *
     * If this field is unspecified, the `machineTypeId` defaults
     * to "n1-standard-1".
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine
     * [machine type](/compute/docs/machine-types) used for cluster instances,
     * specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
     *
     * The `machineType` must belong to the enclosing environment's project and
     * location. If both this field and `nodeConfig.location` are specified,
     * this `machineType` must belong to the `nodeConfig.location`; if both are
     * unspecified, the service will pick a zone in the Compute Engine region
     * corresponding to the Cloud Composer location, and propagate that choice to
     * both fields. If exactly one of this field and `nodeConfig.location` is
     * specified, the location information from the specified field will be
     * propagated to the unspecified field.
     *
     * The `machineTypeId` must not be a [shared-core machine
     * type](/compute/docs/machine-types#sharedcore).
     *
     * If this field is unspecified, the `machineTypeId` defaults
     * to "n1-standard-1".
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/global/networks/{networkId}".
     *
     * If unspecified, the "default" network ID in the environment's project is
     * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
     * is provided, `nodeConfig.subnetwork` must also be provided. For
     * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
     * `nodeConfig.subnetwork`.
     * </pre>
     *
     * <code>string network = 3;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/global/networks/{networkId}".
     *
     * If unspecified, the "default" network ID in the environment's project is
     * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
     * is provided, `nodeConfig.subnetwork` must also be provided. For
     * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
     * `nodeConfig.subnetwork`.
     * </pre>
     *
     * <code>string network = 3;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/global/networks/{networkId}".
     *
     * If unspecified, the "default" network ID in the environment's project is
     * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
     * is provided, `nodeConfig.subnetwork` must also be provided. For
     * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
     * `nodeConfig.subnetwork`.
     * </pre>
     *
     * <code>string network = 3;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/global/networks/{networkId}".
     *
     * If unspecified, the "default" network ID in the environment's project is
     * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
     * is provided, `nodeConfig.subnetwork` must also be provided. For
     * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
     * `nodeConfig.subnetwork`.
     * </pre>
     *
     * <code>string network = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/global/networks/{networkId}".
     *
     * If unspecified, the "default" network ID in the environment's project is
     * used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
     * is provided, `nodeConfig.subnetwork` must also be provided. For
     * [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
     * `nodeConfig.subnetwork`.
     * </pre>
     *
     * <code>string network = 3;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
     *
     * If a subnetwork is provided, `nodeConfig.network` must also be provided,
     * and the subnetwork must belong to the enclosing environment's project and
     * location.
     * </pre>
     *
     * <code>string subnetwork = 4;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
     *
     * If a subnetwork is provided, `nodeConfig.network` must also be provided,
     * and the subnetwork must belong to the enclosing environment's project and
     * location.
     * </pre>
     *
     * <code>string subnetwork = 4;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
     *
     * If a subnetwork is provided, `nodeConfig.network` must also be provided,
     * and the subnetwork must belong to the enclosing environment's project and
     * location.
     * </pre>
     *
     * <code>string subnetwork = 4;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
     *
     * If a subnetwork is provided, `nodeConfig.network` must also be provided,
     * and the subnetwork must belong to the enclosing environment's project and
     * location.
     * </pre>
     *
     * <code>string subnetwork = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications, specified as a
     * [relative resource
     * name](/apis/design/resource_names#relative_resource_name). For example:
     * "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
     *
     * If a subnetwork is provided, `nodeConfig.network` must also be provided,
     * and the subnetwork must belong to the enclosing environment's project and
     * location.
     * </pre>
     *
     * <code>string subnetwork = 4;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Optional. The disk size in GB used for node VMs. Minimum size is 30GB.
     * If unspecified, defaults to 100GB. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>int32 disk_size_gb = 5;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public int getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The disk size in GB used for node VMs. Minimum size is 30GB.
     * If unspecified, defaults to 100GB. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>int32 disk_size_gb = 5;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(int value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The disk size in GB used for node VMs. Minimum size is 30GB.
     * If unspecified, defaults to 100GB. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>int32 disk_size_gb = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000010);
      diskSizeGb_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList oauthScopes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureOauthScopesIsMutable() {
      if (!oauthScopes_.isModifiable()) {
        oauthScopes_ = new com.google.protobuf.LazyStringArrayList(oauthScopes_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @return A list containing the oauthScopes.
     */
    public com.google.protobuf.ProtocolStringList getOauthScopesList() {
      oauthScopes_.makeImmutable();
      return oauthScopes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @return The count of oauthScopes.
     */
    public int getOauthScopesCount() {
      return oauthScopes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The oauthScopes at the given index.
     */
    public java.lang.String getOauthScopes(int index) {
      return oauthScopes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the oauthScopes at the given index.
     */
    public com.google.protobuf.ByteString getOauthScopesBytes(int index) {
      return oauthScopes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The oauthScopes to set.
     * @return This builder for chaining.
     */
    public Builder setOauthScopes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOauthScopesIsMutable();
      oauthScopes_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @param value The oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addOauthScopes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOauthScopesIsMutable();
      oauthScopes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @param values The oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addAllOauthScopes(java.lang.Iterable<java.lang.String> values) {
      ensureOauthScopesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, oauthScopes_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOauthScopes() {
      oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The set of Google API scopes to be made available on all
     * node VMs. If `oauth_scopes` is empty, defaults to
     * ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 6;</code>
     *
     * @param value The bytes of the oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addOauthScopesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureOauthScopesIsMutable();
      oauthScopes_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform Service Account to be used by the node
     * VMs. If a service account is not specified, the "default" Compute Engine
     * service account is used. Cannot be updated.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform Service Account to be used by the node
     * VMs. If a service account is not specified, the "default" Compute Engine
     * service account is used. Cannot be updated.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform Service Account to be used by the node
     * VMs. If a service account is not specified, the "default" Compute Engine
     * service account is used. Cannot be updated.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform Service Account to be used by the node
     * VMs. If a service account is not specified, the "default" Compute Engine
     * service account is used. Cannot be updated.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Platform Service Account to be used by the node
     * VMs. If a service account is not specified, the "default" Compute Engine
     * service account is used. Cannot be updated.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of instance tags applied to all node VMs. Tags are used
     * to identify valid sources or targets for network firewalls. Each tag within
     * the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Cannot be updated.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
        ipAllocationPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy,
            com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.Builder,
            com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicyOrBuilder>
        ipAllocationPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ipAllocationPolicy field is set.
     */
    public boolean hasIpAllocationPolicy() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ipAllocationPolicy.
     */
    public com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
        getIpAllocationPolicy() {
      if (ipAllocationPolicyBuilder_ == null) {
        return ipAllocationPolicy_ == null
            ? com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
                .getDefaultInstance()
            : ipAllocationPolicy_;
      } else {
        return ipAllocationPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIpAllocationPolicy(
        com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy value) {
      if (ipAllocationPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ipAllocationPolicy_ = value;
      } else {
        ipAllocationPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIpAllocationPolicy(
        com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.Builder
            builderForValue) {
      if (ipAllocationPolicyBuilder_ == null) {
        ipAllocationPolicy_ = builderForValue.build();
      } else {
        ipAllocationPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeIpAllocationPolicy(
        com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy value) {
      if (ipAllocationPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && ipAllocationPolicy_ != null
            && ipAllocationPolicy_
                != com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
                    .getDefaultInstance()) {
          getIpAllocationPolicyBuilder().mergeFrom(value);
        } else {
          ipAllocationPolicy_ = value;
        }
      } else {
        ipAllocationPolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIpAllocationPolicy() {
      bitField0_ = (bitField0_ & ~0x00000100);
      ipAllocationPolicy_ = null;
      if (ipAllocationPolicyBuilder_ != null) {
        ipAllocationPolicyBuilder_.dispose();
        ipAllocationPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.Builder
        getIpAllocationPolicyBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getIpAllocationPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicyOrBuilder
        getIpAllocationPolicyOrBuilder() {
      if (ipAllocationPolicyBuilder_ != null) {
        return ipAllocationPolicyBuilder_.getMessageOrBuilder();
      } else {
        return ipAllocationPolicy_ == null
            ? com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
                .getDefaultInstance()
            : ipAllocationPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for controlling how IPs are allocated in the
     * GKE cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy ip_allocation_policy = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy,
            com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.Builder,
            com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicyOrBuilder>
        getIpAllocationPolicyFieldBuilder() {
      if (ipAllocationPolicyBuilder_ == null) {
        ipAllocationPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy,
                com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy.Builder,
                com.google.cloud.orchestration.airflow.service.v1.IPAllocationPolicyOrBuilder>(
                getIpAllocationPolicy(), getParentForChildren(), isClean());
        ipAllocationPolicy_ = null;
      }
      return ipAllocationPolicyBuilder_;
    }

    private boolean enableIpMasqAgent_;
    /**
     *
     *
     * <pre>
     * Optional. Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines
     * nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for
     * all destination addresses, except between pods traffic.
     *
     * See:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
     * </pre>
     *
     * <code>bool enable_ip_masq_agent = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableIpMasqAgent.
     */
    @java.lang.Override
    public boolean getEnableIpMasqAgent() {
      return enableIpMasqAgent_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines
     * nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for
     * all destination addresses, except between pods traffic.
     *
     * See:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
     * </pre>
     *
     * <code>bool enable_ip_masq_agent = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableIpMasqAgent to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIpMasqAgent(boolean value) {

      enableIpMasqAgent_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines
     * nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for
     * all destination addresses, except between pods traffic.
     *
     * See:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
     * </pre>
     *
     * <code>bool enable_ip_masq_agent = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIpMasqAgent() {
      bitField0_ = (bitField0_ & ~0x00000200);
      enableIpMasqAgent_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1.NodeConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1.NodeConfig)
  private static final com.google.cloud.orchestration.airflow.service.v1.NodeConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orchestration.airflow.service.v1.NodeConfig();
  }

  public static com.google.cloud.orchestration.airflow.service.v1.NodeConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeConfig> PARSER =
      new com.google.protobuf.AbstractParser<NodeConfig>() {
        @java.lang.Override
        public NodeConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.NodeConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
