/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1/image_versions.proto

package com.google.cloud.orchestration.airflow.service.v1;

/**
 *
 *
 * <pre>
 * ImageVersion information
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1.ImageVersion}
 */
public final class ImageVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1.ImageVersion)
    ImageVersionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImageVersion.newBuilder() to construct.
  private ImageVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImageVersion() {
    imageVersionId_ = "";
    supportedPythonVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImageVersion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1.ImageVersionsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1_ImageVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1.ImageVersionsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1_ImageVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1.ImageVersion.class,
            com.google.cloud.orchestration.airflow.service.v1.ImageVersion.Builder.class);
  }

  public static final int IMAGE_VERSION_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageVersionId_ = "";
  /**
   *
   *
   * <pre>
   * The string identifier of the ImageVersion, in the form:
   * "composer-x.y.z-airflow-a.b.c"
   * </pre>
   *
   * <code>string image_version_id = 1;</code>
   *
   * @return The imageVersionId.
   */
  @java.lang.Override
  public java.lang.String getImageVersionId() {
    java.lang.Object ref = imageVersionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageVersionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The string identifier of the ImageVersion, in the form:
   * "composer-x.y.z-airflow-a.b.c"
   * </pre>
   *
   * <code>string image_version_id = 1;</code>
   *
   * @return The bytes for imageVersionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageVersionIdBytes() {
    java.lang.Object ref = imageVersionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageVersionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_DEFAULT_FIELD_NUMBER = 2;
  private boolean isDefault_ = false;
  /**
   *
   *
   * <pre>
   * Whether this is the default ImageVersion used by Composer during
   * environment creation if no input ImageVersion is specified.
   * </pre>
   *
   * <code>bool is_default = 2;</code>
   *
   * @return The isDefault.
   */
  @java.lang.Override
  public boolean getIsDefault() {
    return isDefault_;
  }

  public static final int SUPPORTED_PYTHON_VERSIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList supportedPythonVersions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * supported python versions
   * </pre>
   *
   * <code>repeated string supported_python_versions = 3;</code>
   *
   * @return A list containing the supportedPythonVersions.
   */
  public com.google.protobuf.ProtocolStringList getSupportedPythonVersionsList() {
    return supportedPythonVersions_;
  }
  /**
   *
   *
   * <pre>
   * supported python versions
   * </pre>
   *
   * <code>repeated string supported_python_versions = 3;</code>
   *
   * @return The count of supportedPythonVersions.
   */
  public int getSupportedPythonVersionsCount() {
    return supportedPythonVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * supported python versions
   * </pre>
   *
   * <code>repeated string supported_python_versions = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedPythonVersions at the given index.
   */
  public java.lang.String getSupportedPythonVersions(int index) {
    return supportedPythonVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * supported python versions
   * </pre>
   *
   * <code>repeated string supported_python_versions = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedPythonVersions at the given index.
   */
  public com.google.protobuf.ByteString getSupportedPythonVersionsBytes(int index) {
    return supportedPythonVersions_.getByteString(index);
  }

  public static final int RELEASE_DATE_FIELD_NUMBER = 4;
  private com.google.type.Date releaseDate_;
  /**
   *
   *
   * <pre>
   * The date of the version release.
   * </pre>
   *
   * <code>.google.type.Date release_date = 4;</code>
   *
   * @return Whether the releaseDate field is set.
   */
  @java.lang.Override
  public boolean hasReleaseDate() {
    return releaseDate_ != null;
  }
  /**
   *
   *
   * <pre>
   * The date of the version release.
   * </pre>
   *
   * <code>.google.type.Date release_date = 4;</code>
   *
   * @return The releaseDate.
   */
  @java.lang.Override
  public com.google.type.Date getReleaseDate() {
    return releaseDate_ == null ? com.google.type.Date.getDefaultInstance() : releaseDate_;
  }
  /**
   *
   *
   * <pre>
   * The date of the version release.
   * </pre>
   *
   * <code>.google.type.Date release_date = 4;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getReleaseDateOrBuilder() {
    return releaseDate_ == null ? com.google.type.Date.getDefaultInstance() : releaseDate_;
  }

  public static final int CREATION_DISABLED_FIELD_NUMBER = 5;
  private boolean creationDisabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether it is impossible to create an environment with the image version.
   * </pre>
   *
   * <code>bool creation_disabled = 5;</code>
   *
   * @return The creationDisabled.
   */
  @java.lang.Override
  public boolean getCreationDisabled() {
    return creationDisabled_;
  }

  public static final int UPGRADE_DISABLED_FIELD_NUMBER = 6;
  private boolean upgradeDisabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether it is impossible to upgrade an environment running with the image
   * version.
   * </pre>
   *
   * <code>bool upgrade_disabled = 6;</code>
   *
   * @return The upgradeDisabled.
   */
  @java.lang.Override
  public boolean getUpgradeDisabled() {
    return upgradeDisabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageVersionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageVersionId_);
    }
    if (isDefault_ != false) {
      output.writeBool(2, isDefault_);
    }
    for (int i = 0; i < supportedPythonVersions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, supportedPythonVersions_.getRaw(i));
    }
    if (releaseDate_ != null) {
      output.writeMessage(4, getReleaseDate());
    }
    if (creationDisabled_ != false) {
      output.writeBool(5, creationDisabled_);
    }
    if (upgradeDisabled_ != false) {
      output.writeBool(6, upgradeDisabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageVersionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageVersionId_);
    }
    if (isDefault_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isDefault_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedPythonVersions_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedPythonVersions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedPythonVersionsList().size();
    }
    if (releaseDate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getReleaseDate());
    }
    if (creationDisabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, creationDisabled_);
    }
    if (upgradeDisabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, upgradeDisabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orchestration.airflow.service.v1.ImageVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1.ImageVersion other =
        (com.google.cloud.orchestration.airflow.service.v1.ImageVersion) obj;

    if (!getImageVersionId().equals(other.getImageVersionId())) return false;
    if (getIsDefault() != other.getIsDefault()) return false;
    if (!getSupportedPythonVersionsList().equals(other.getSupportedPythonVersionsList()))
      return false;
    if (hasReleaseDate() != other.hasReleaseDate()) return false;
    if (hasReleaseDate()) {
      if (!getReleaseDate().equals(other.getReleaseDate())) return false;
    }
    if (getCreationDisabled() != other.getCreationDisabled()) return false;
    if (getUpgradeDisabled() != other.getUpgradeDisabled()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getImageVersionId().hashCode();
    hash = (37 * hash) + IS_DEFAULT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDefault());
    if (getSupportedPythonVersionsCount() > 0) {
      hash = (37 * hash) + SUPPORTED_PYTHON_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedPythonVersionsList().hashCode();
    }
    if (hasReleaseDate()) {
      hash = (37 * hash) + RELEASE_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getReleaseDate().hashCode();
    }
    hash = (37 * hash) + CREATION_DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCreationDisabled());
    hash = (37 * hash) + UPGRADE_DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUpgradeDisabled());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1.ImageVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ImageVersion information
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1.ImageVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1.ImageVersion)
      com.google.cloud.orchestration.airflow.service.v1.ImageVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1.ImageVersionsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_ImageVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1.ImageVersionsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_ImageVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1.ImageVersion.class,
              com.google.cloud.orchestration.airflow.service.v1.ImageVersion.Builder.class);
    }

    // Construct using com.google.cloud.orchestration.airflow.service.v1.ImageVersion.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      imageVersionId_ = "";
      isDefault_ = false;
      supportedPythonVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      releaseDate_ = null;
      if (releaseDateBuilder_ != null) {
        releaseDateBuilder_.dispose();
        releaseDateBuilder_ = null;
      }
      creationDisabled_ = false;
      upgradeDisabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1.ImageVersionsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_ImageVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.ImageVersion
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1.ImageVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.ImageVersion build() {
      com.google.cloud.orchestration.airflow.service.v1.ImageVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.ImageVersion buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1.ImageVersion result =
          new com.google.cloud.orchestration.airflow.service.v1.ImageVersion(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1.ImageVersion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.imageVersionId_ = imageVersionId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.isDefault_ = isDefault_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        supportedPythonVersions_.makeImmutable();
        result.supportedPythonVersions_ = supportedPythonVersions_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.releaseDate_ =
            releaseDateBuilder_ == null ? releaseDate_ : releaseDateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.creationDisabled_ = creationDisabled_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.upgradeDisabled_ = upgradeDisabled_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orchestration.airflow.service.v1.ImageVersion) {
        return mergeFrom((com.google.cloud.orchestration.airflow.service.v1.ImageVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orchestration.airflow.service.v1.ImageVersion other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1.ImageVersion.getDefaultInstance())
        return this;
      if (!other.getImageVersionId().isEmpty()) {
        imageVersionId_ = other.imageVersionId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getIsDefault() != false) {
        setIsDefault(other.getIsDefault());
      }
      if (!other.supportedPythonVersions_.isEmpty()) {
        if (supportedPythonVersions_.isEmpty()) {
          supportedPythonVersions_ = other.supportedPythonVersions_;
          bitField0_ |= 0x00000004;
        } else {
          ensureSupportedPythonVersionsIsMutable();
          supportedPythonVersions_.addAll(other.supportedPythonVersions_);
        }
        onChanged();
      }
      if (other.hasReleaseDate()) {
        mergeReleaseDate(other.getReleaseDate());
      }
      if (other.getCreationDisabled() != false) {
        setCreationDisabled(other.getCreationDisabled());
      }
      if (other.getUpgradeDisabled() != false) {
        setUpgradeDisabled(other.getUpgradeDisabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                imageVersionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                isDefault_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedPythonVersionsIsMutable();
                supportedPythonVersions_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getReleaseDateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                creationDisabled_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                upgradeDisabled_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageVersionId_ = "";
    /**
     *
     *
     * <pre>
     * The string identifier of the ImageVersion, in the form:
     * "composer-x.y.z-airflow-a.b.c"
     * </pre>
     *
     * <code>string image_version_id = 1;</code>
     *
     * @return The imageVersionId.
     */
    public java.lang.String getImageVersionId() {
      java.lang.Object ref = imageVersionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageVersionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The string identifier of the ImageVersion, in the form:
     * "composer-x.y.z-airflow-a.b.c"
     * </pre>
     *
     * <code>string image_version_id = 1;</code>
     *
     * @return The bytes for imageVersionId.
     */
    public com.google.protobuf.ByteString getImageVersionIdBytes() {
      java.lang.Object ref = imageVersionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageVersionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The string identifier of the ImageVersion, in the form:
     * "composer-x.y.z-airflow-a.b.c"
     * </pre>
     *
     * <code>string image_version_id = 1;</code>
     *
     * @param value The imageVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setImageVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageVersionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The string identifier of the ImageVersion, in the form:
     * "composer-x.y.z-airflow-a.b.c"
     * </pre>
     *
     * <code>string image_version_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageVersionId() {
      imageVersionId_ = getDefaultInstance().getImageVersionId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The string identifier of the ImageVersion, in the form:
     * "composer-x.y.z-airflow-a.b.c"
     * </pre>
     *
     * <code>string image_version_id = 1;</code>
     *
     * @param value The bytes for imageVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setImageVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageVersionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean isDefault_;
    /**
     *
     *
     * <pre>
     * Whether this is the default ImageVersion used by Composer during
     * environment creation if no input ImageVersion is specified.
     * </pre>
     *
     * <code>bool is_default = 2;</code>
     *
     * @return The isDefault.
     */
    @java.lang.Override
    public boolean getIsDefault() {
      return isDefault_;
    }
    /**
     *
     *
     * <pre>
     * Whether this is the default ImageVersion used by Composer during
     * environment creation if no input ImageVersion is specified.
     * </pre>
     *
     * <code>bool is_default = 2;</code>
     *
     * @param value The isDefault to set.
     * @return This builder for chaining.
     */
    public Builder setIsDefault(boolean value) {

      isDefault_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether this is the default ImageVersion used by Composer during
     * environment creation if no input ImageVersion is specified.
     * </pre>
     *
     * <code>bool is_default = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDefault() {
      bitField0_ = (bitField0_ & ~0x00000002);
      isDefault_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList supportedPythonVersions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSupportedPythonVersionsIsMutable() {
      if (!supportedPythonVersions_.isModifiable()) {
        supportedPythonVersions_ =
            new com.google.protobuf.LazyStringArrayList(supportedPythonVersions_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @return A list containing the supportedPythonVersions.
     */
    public com.google.protobuf.ProtocolStringList getSupportedPythonVersionsList() {
      supportedPythonVersions_.makeImmutable();
      return supportedPythonVersions_;
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @return The count of supportedPythonVersions.
     */
    public int getSupportedPythonVersionsCount() {
      return supportedPythonVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedPythonVersions at the given index.
     */
    public java.lang.String getSupportedPythonVersions(int index) {
      return supportedPythonVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedPythonVersions at the given index.
     */
    public com.google.protobuf.ByteString getSupportedPythonVersionsBytes(int index) {
      return supportedPythonVersions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedPythonVersions to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPythonVersions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPythonVersionsIsMutable();
      supportedPythonVersions_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @param value The supportedPythonVersions to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPythonVersions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPythonVersionsIsMutable();
      supportedPythonVersions_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @param values The supportedPythonVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPythonVersions(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedPythonVersionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedPythonVersions_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedPythonVersions() {
      supportedPythonVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported python versions
     * </pre>
     *
     * <code>repeated string supported_python_versions = 3;</code>
     *
     * @param value The bytes of the supportedPythonVersions to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPythonVersionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedPythonVersionsIsMutable();
      supportedPythonVersions_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.type.Date releaseDate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        releaseDateBuilder_;
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     *
     * @return Whether the releaseDate field is set.
     */
    public boolean hasReleaseDate() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     *
     * @return The releaseDate.
     */
    public com.google.type.Date getReleaseDate() {
      if (releaseDateBuilder_ == null) {
        return releaseDate_ == null ? com.google.type.Date.getDefaultInstance() : releaseDate_;
      } else {
        return releaseDateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    public Builder setReleaseDate(com.google.type.Date value) {
      if (releaseDateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        releaseDate_ = value;
      } else {
        releaseDateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    public Builder setReleaseDate(com.google.type.Date.Builder builderForValue) {
      if (releaseDateBuilder_ == null) {
        releaseDate_ = builderForValue.build();
      } else {
        releaseDateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    public Builder mergeReleaseDate(com.google.type.Date value) {
      if (releaseDateBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && releaseDate_ != null
            && releaseDate_ != com.google.type.Date.getDefaultInstance()) {
          getReleaseDateBuilder().mergeFrom(value);
        } else {
          releaseDate_ = value;
        }
      } else {
        releaseDateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    public Builder clearReleaseDate() {
      bitField0_ = (bitField0_ & ~0x00000008);
      releaseDate_ = null;
      if (releaseDateBuilder_ != null) {
        releaseDateBuilder_.dispose();
        releaseDateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    public com.google.type.Date.Builder getReleaseDateBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getReleaseDateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    public com.google.type.DateOrBuilder getReleaseDateOrBuilder() {
      if (releaseDateBuilder_ != null) {
        return releaseDateBuilder_.getMessageOrBuilder();
      } else {
        return releaseDate_ == null ? com.google.type.Date.getDefaultInstance() : releaseDate_;
      }
    }
    /**
     *
     *
     * <pre>
     * The date of the version release.
     * </pre>
     *
     * <code>.google.type.Date release_date = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getReleaseDateFieldBuilder() {
      if (releaseDateBuilder_ == null) {
        releaseDateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                getReleaseDate(), getParentForChildren(), isClean());
        releaseDate_ = null;
      }
      return releaseDateBuilder_;
    }

    private boolean creationDisabled_;
    /**
     *
     *
     * <pre>
     * Whether it is impossible to create an environment with the image version.
     * </pre>
     *
     * <code>bool creation_disabled = 5;</code>
     *
     * @return The creationDisabled.
     */
    @java.lang.Override
    public boolean getCreationDisabled() {
      return creationDisabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether it is impossible to create an environment with the image version.
     * </pre>
     *
     * <code>bool creation_disabled = 5;</code>
     *
     * @param value The creationDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setCreationDisabled(boolean value) {

      creationDisabled_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether it is impossible to create an environment with the image version.
     * </pre>
     *
     * <code>bool creation_disabled = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationDisabled() {
      bitField0_ = (bitField0_ & ~0x00000010);
      creationDisabled_ = false;
      onChanged();
      return this;
    }

    private boolean upgradeDisabled_;
    /**
     *
     *
     * <pre>
     * Whether it is impossible to upgrade an environment running with the image
     * version.
     * </pre>
     *
     * <code>bool upgrade_disabled = 6;</code>
     *
     * @return The upgradeDisabled.
     */
    @java.lang.Override
    public boolean getUpgradeDisabled() {
      return upgradeDisabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether it is impossible to upgrade an environment running with the image
     * version.
     * </pre>
     *
     * <code>bool upgrade_disabled = 6;</code>
     *
     * @param value The upgradeDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setUpgradeDisabled(boolean value) {

      upgradeDisabled_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether it is impossible to upgrade an environment running with the image
     * version.
     * </pre>
     *
     * <code>bool upgrade_disabled = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpgradeDisabled() {
      bitField0_ = (bitField0_ & ~0x00000020);
      upgradeDisabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1.ImageVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1.ImageVersion)
  private static final com.google.cloud.orchestration.airflow.service.v1.ImageVersion
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orchestration.airflow.service.v1.ImageVersion();
  }

  public static com.google.cloud.orchestration.airflow.service.v1.ImageVersion
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImageVersion> PARSER =
      new com.google.protobuf.AbstractParser<ImageVersion>() {
        @java.lang.Override
        public ImageVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImageVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImageVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.ImageVersion
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
