/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1;

/**
 *
 *
 * <pre>
 * Network-level access control policy for the Airflow web server.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl}
 */
public final class WebServerNetworkAccessControl extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl)
    WebServerNetworkAccessControlOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebServerNetworkAccessControl.newBuilder() to construct.
  private WebServerNetworkAccessControl(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebServerNetworkAccessControl() {
    allowedIpRanges_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebServerNetworkAccessControl();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.class,
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.Builder
                .class);
  }

  public interface AllowedIpRangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * IP address or range, defined using CIDR notation, of requests that this
     * rule applies to.
     * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
     *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
     *
     * IP range prefixes should be properly truncated. For example,
     * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
     * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * IP address or range, defined using CIDR notation, of requests that this
     * rule applies to.
     * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
     *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
     *
     * IP range prefixes should be properly truncated. For example,
     * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
     * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Optional. User-provided description. It must contain at most 300
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Optional. User-provided description. It must contain at most 300
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();
  }
  /**
   *
   *
   * <pre>
   * Allowed IP range with user-provided description.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange}
   */
  public static final class AllowedIpRange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange)
      AllowedIpRangeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AllowedIpRange.newBuilder() to construct.
    private AllowedIpRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AllowedIpRange() {
      value_ = "";
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AllowedIpRange();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_AllowedIpRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_AllowedIpRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRange.class,
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRange.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * IP address or range, defined using CIDR notation, of requests that this
     * rule applies to.
     * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
     *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
     *
     * IP range prefixes should be properly truncated. For example,
     * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
     * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address or range, defined using CIDR notation, of requests that this
     * rule applies to.
     * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
     *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
     *
     * IP range prefixes should be properly truncated. For example,
     * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
     * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided description. It must contain at most 300
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description. It must contain at most 300
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange)) {
        return super.equals(obj);
      }
      com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange
          other =
              (com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                      .AllowedIpRange)
                  obj;

      if (!getValue().equals(other.getValue())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Allowed IP range with user-provided description.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange)
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_AllowedIpRange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_AllowedIpRange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRange.class,
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRange.Builder.class);
      }

      // Construct using
      // com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = "";
        description_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_AllowedIpRange_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange
          getDefaultInstanceForType() {
        return com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange
          build() {
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange
          buildPartial() {
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange
            result =
                new com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRange(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRange
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange) {
          return mergeFrom(
              (com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                      .AllowedIpRange)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRange
              other) {
        if (other
            == com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.getDefaultInstance()) return this;
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * IP address or range, defined using CIDR notation, of requests that this
       * rule applies to.
       * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
       *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
       *
       * IP range prefixes should be properly truncated. For example,
       * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
       * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * IP address or range, defined using CIDR notation, of requests that this
       * rule applies to.
       * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
       *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
       *
       * IP range prefixes should be properly truncated. For example,
       * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
       * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * IP address or range, defined using CIDR notation, of requests that this
       * rule applies to.
       * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
       *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
       *
       * IP range prefixes should be properly truncated. For example,
       * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
       * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * IP address or range, defined using CIDR notation, of requests that this
       * rule applies to.
       * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
       *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
       *
       * IP range prefixes should be properly truncated. For example,
       * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
       * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * IP address or range, defined using CIDR notation, of requests that this
       * rule applies to.
       * Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
       *           or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
       *
       * IP range prefixes should be properly truncated. For example,
       * `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
       * `2001:db8::1/32` should be truncated to `2001:db8::/32`.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Optional. User-provided description. It must contain at most 300
       * characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. User-provided description. It must contain at most 300
       * characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. User-provided description. It must contain at most 300
       * characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. User-provided description. It must contain at most 300
       * characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. User-provided description. It must contain at most 300
       * characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange)
    private static final com.google.cloud.orchestration.airflow.service.v1
            .WebServerNetworkAccessControl.AllowedIpRange
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange();
    }

    public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AllowedIpRange> PARSER =
        new com.google.protobuf.AbstractParser<AllowedIpRange>() {
          @java.lang.Override
          public AllowedIpRange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AllowedIpRange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AllowedIpRange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ALLOWED_IP_RANGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange>
      allowedIpRanges_;
  /**
   *
   *
   * <pre>
   * A collection of allowed IP ranges with descriptions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .AllowedIpRange>
      getAllowedIpRangesList() {
    return allowedIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * A collection of allowed IP ranges with descriptions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRangeOrBuilder>
      getAllowedIpRangesOrBuilderList() {
    return allowedIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * A collection of allowed IP ranges with descriptions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
   * </code>
   */
  @java.lang.Override
  public int getAllowedIpRangesCount() {
    return allowedIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * A collection of allowed IP ranges with descriptions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
          .AllowedIpRange
      getAllowedIpRanges(int index) {
    return allowedIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A collection of allowed IP ranges with descriptions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
          .AllowedIpRangeOrBuilder
      getAllowedIpRangesOrBuilder(int index) {
    return allowedIpRanges_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < allowedIpRanges_.size(); i++) {
      output.writeMessage(1, allowedIpRanges_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < allowedIpRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, allowedIpRanges_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl other =
        (com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl) obj;

    if (!getAllowedIpRangesList().equals(other.getAllowedIpRangesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedIpRangesCount() > 0) {
      hash = (37 * hash) + ALLOWED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedIpRangesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Network-level access control policy for the Airflow web server.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl)
      com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControlOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.class,
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (allowedIpRangesBuilder_ == null) {
        allowedIpRanges_ = java.util.Collections.emptyList();
      } else {
        allowedIpRanges_ = null;
        allowedIpRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1_WebServerNetworkAccessControl_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl build() {
      com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
        buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl result =
          new com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl result) {
      if (allowedIpRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          allowedIpRanges_ = java.util.Collections.unmodifiableList(allowedIpRanges_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.allowedIpRanges_ = allowedIpRanges_;
      } else {
        result.allowedIpRanges_ = allowedIpRangesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
              .getDefaultInstance()) return this;
      if (allowedIpRangesBuilder_ == null) {
        if (!other.allowedIpRanges_.isEmpty()) {
          if (allowedIpRanges_.isEmpty()) {
            allowedIpRanges_ = other.allowedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAllowedIpRangesIsMutable();
            allowedIpRanges_.addAll(other.allowedIpRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.allowedIpRanges_.isEmpty()) {
          if (allowedIpRangesBuilder_.isEmpty()) {
            allowedIpRangesBuilder_.dispose();
            allowedIpRangesBuilder_ = null;
            allowedIpRanges_ = other.allowedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
            allowedIpRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAllowedIpRangesFieldBuilder()
                    : null;
          } else {
            allowedIpRangesBuilder_.addAllMessages(other.allowedIpRanges_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                        .AllowedIpRange
                    m =
                        input.readMessage(
                            com.google.cloud.orchestration.airflow.service.v1
                                .WebServerNetworkAccessControl.AllowedIpRange.parser(),
                            extensionRegistry);
                if (allowedIpRangesBuilder_ == null) {
                  ensureAllowedIpRangesIsMutable();
                  allowedIpRanges_.add(m);
                } else {
                  allowedIpRangesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange>
        allowedIpRanges_ = java.util.Collections.emptyList();

    private void ensureAllowedIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedIpRanges_ =
            new java.util.ArrayList<
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRange>(allowedIpRanges_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange,
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.Builder,
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRangeOrBuilder>
        allowedIpRangesBuilder_;

    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange>
        getAllowedIpRangesList() {
      if (allowedIpRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(allowedIpRanges_);
      } else {
        return allowedIpRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public int getAllowedIpRangesCount() {
      if (allowedIpRangesBuilder_ == null) {
        return allowedIpRanges_.size();
      } else {
        return allowedIpRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange
        getAllowedIpRanges(int index) {
      if (allowedIpRangesBuilder_ == null) {
        return allowedIpRanges_.get(index);
      } else {
        return allowedIpRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder setAllowedIpRanges(
        int index,
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange
            value) {
      if (allowedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.set(index, value);
        onChanged();
      } else {
        allowedIpRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder setAllowedIpRanges(
        int index,
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.Builder
            builderForValue) {
      if (allowedIpRangesBuilder_ == null) {
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        allowedIpRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder addAllowedIpRanges(
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange
            value) {
      if (allowedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.add(value);
        onChanged();
      } else {
        allowedIpRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder addAllowedIpRanges(
        int index,
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange
            value) {
      if (allowedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.add(index, value);
        onChanged();
      } else {
        allowedIpRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder addAllowedIpRanges(
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.Builder
            builderForValue) {
      if (allowedIpRangesBuilder_ == null) {
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.add(builderForValue.build());
        onChanged();
      } else {
        allowedIpRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder addAllowedIpRanges(
        int index,
        com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.Builder
            builderForValue) {
      if (allowedIpRangesBuilder_ == null) {
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        allowedIpRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder addAllAllowedIpRanges(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                        .AllowedIpRange>
            values) {
      if (allowedIpRangesBuilder_ == null) {
        ensureAllowedIpRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedIpRanges_);
        onChanged();
      } else {
        allowedIpRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder clearAllowedIpRanges() {
      if (allowedIpRangesBuilder_ == null) {
        allowedIpRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        allowedIpRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public Builder removeAllowedIpRanges(int index) {
      if (allowedIpRangesBuilder_ == null) {
        ensureAllowedIpRangesIsMutable();
        allowedIpRanges_.remove(index);
        onChanged();
      } else {
        allowedIpRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange.Builder
        getAllowedIpRangesBuilder(int index) {
      return getAllowedIpRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRangeOrBuilder
        getAllowedIpRangesOrBuilder(int index) {
      if (allowedIpRangesBuilder_ == null) {
        return allowedIpRanges_.get(index);
      } else {
        return allowedIpRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRangeOrBuilder>
        getAllowedIpRangesOrBuilderList() {
      if (allowedIpRangesBuilder_ != null) {
        return allowedIpRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(allowedIpRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange.Builder
        addAllowedIpRangesBuilder() {
      return getAllowedIpRangesFieldBuilder()
          .addBuilder(
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
            .AllowedIpRange.Builder
        addAllowedIpRangesBuilder(int index) {
      return getAllowedIpRangesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                  .AllowedIpRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of allowed IP ranges with descriptions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange allowed_ip_ranges = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.Builder>
        getAllowedIpRangesBuilderList() {
      return getAllowedIpRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange,
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRange.Builder,
            com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                .AllowedIpRangeOrBuilder>
        getAllowedIpRangesFieldBuilder() {
      if (allowedIpRangesBuilder_ == null) {
        allowedIpRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRange,
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRange.Builder,
                com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
                    .AllowedIpRangeOrBuilder>(
                allowedIpRanges_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        allowedIpRanges_ = null;
      }
      return allowedIpRangesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl)
  private static final com.google.cloud.orchestration.airflow.service.v1
          .WebServerNetworkAccessControl
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl();
  }

  public static com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebServerNetworkAccessControl> PARSER =
      new com.google.protobuf.AbstractParser<WebServerNetworkAccessControl>() {
        @java.lang.Override
        public WebServerNetworkAccessControl parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WebServerNetworkAccessControl> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebServerNetworkAccessControl> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
