/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnvironmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/environments/{environment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String environment;

    @Deprecated
    protected EnvironmentName() {
        this.project = null;
        this.location = null;
        this.environment = null;
    }

    private EnvironmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EnvironmentName of(String project, String location, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setLocation(location).setEnvironment(environment).build();
    }

    public static String format(String project, String location, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setLocation(location).setEnvironment(environment).build().toString();
    }

    public static EnvironmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENVIRONMENT.validatedMatch(formattedString, "EnvironmentName.parse: formattedString not in valid format");
        return EnvironmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"));
    }

    public static List<EnvironmentName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentName> list = new ArrayList<EnvironmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENVIRONMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentName environmentName = this;
            synchronized (environmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENVIRONMENT.instantiate(new String[]{"project", this.project, "location", this.location, "environment", this.environment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EnvironmentName that = (EnvironmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.environment, that.environment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.environment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String environment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        private Builder(EnvironmentName environmentName) {
            this.project = environmentName.project;
            this.location = environmentName.location;
            this.environment = environmentName.environment;
        }

        public EnvironmentName build() {
            return new EnvironmentName(this);
        }
    }
}

