/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Message containing information about the result of an upgrade check
 * operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse}
 */
public final class CheckUpgradeResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse)
    CheckUpgradeResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckUpgradeResponse.newBuilder() to construct.
  private CheckUpgradeResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckUpgradeResponse() {
    buildLogUri_ = "";
    containsPypiModulesConflict_ = 0;
    pypiConflictBuildLogExtract_ = "";
    imageVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckUpgradeResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_CheckUpgradeResponse_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetPypiDependencies();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_CheckUpgradeResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * Whether there were python modules conflict during image build.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult}
   */
  public enum ConflictResult implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * It is unknown whether build had conflicts or not.
     * </pre>
     *
     * <code>CONFLICT_RESULT_UNSPECIFIED = 0;</code>
     */
    CONFLICT_RESULT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * There were python packages conflicts.
     * </pre>
     *
     * <code>CONFLICT = 1;</code>
     */
    CONFLICT(1),
    /**
     *
     *
     * <pre>
     * There were no python packages conflicts.
     * </pre>
     *
     * <code>NO_CONFLICT = 2;</code>
     */
    NO_CONFLICT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * It is unknown whether build had conflicts or not.
     * </pre>
     *
     * <code>CONFLICT_RESULT_UNSPECIFIED = 0;</code>
     */
    public static final int CONFLICT_RESULT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * There were python packages conflicts.
     * </pre>
     *
     * <code>CONFLICT = 1;</code>
     */
    public static final int CONFLICT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * There were no python packages conflicts.
     * </pre>
     *
     * <code>NO_CONFLICT = 2;</code>
     */
    public static final int NO_CONFLICT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConflictResult valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConflictResult forNumber(int value) {
      switch (value) {
        case 0:
          return CONFLICT_RESULT_UNSPECIFIED;
        case 1:
          return CONFLICT;
        case 2:
          return NO_CONFLICT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConflictResult> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConflictResult> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ConflictResult>() {
          public ConflictResult findValueByNumber(int number) {
            return ConflictResult.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ConflictResult[] VALUES = values();

    public static ConflictResult valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConflictResult(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult)
  }

  public static final int BUILD_LOG_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildLogUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Url for a docker build log of an upgraded image.
   * </pre>
   *
   * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The buildLogUri.
   */
  @java.lang.Override
  public java.lang.String getBuildLogUri() {
    java.lang.Object ref = buildLogUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildLogUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Url for a docker build log of an upgraded image.
   * </pre>
   *
   * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for buildLogUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildLogUriBytes() {
    java.lang.Object ref = buildLogUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildLogUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINS_PYPI_MODULES_CONFLICT_FIELD_NUMBER = 4;
  private int containsPypiModulesConflict_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Whether build has succeeded or failed on modules conflicts.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for containsPypiModulesConflict.
   */
  @java.lang.Override
  public int getContainsPypiModulesConflictValue() {
    return containsPypiModulesConflict_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Whether build has succeeded or failed on modules conflicts.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The containsPypiModulesConflict.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult
      getContainsPypiModulesConflict() {
    com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult
        result =
            com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
                .ConflictResult.forNumber(containsPypiModulesConflict_);
    return result == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult
            .UNRECOGNIZED
        : result;
  }

  public static final int PYPI_CONFLICT_BUILD_LOG_EXTRACT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pypiConflictBuildLogExtract_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Extract from a docker image build log containing information
   * about pypi modules conflicts.
   * </pre>
   *
   * <code>string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The pypiConflictBuildLogExtract.
   */
  @java.lang.Override
  public java.lang.String getPypiConflictBuildLogExtract() {
    java.lang.Object ref = pypiConflictBuildLogExtract_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pypiConflictBuildLogExtract_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Extract from a docker image build log containing information
   * about pypi modules conflicts.
   * </pre>
   *
   * <code>string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for pypiConflictBuildLogExtract.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPypiConflictBuildLogExtractBytes() {
    java.lang.Object ref = pypiConflictBuildLogExtract_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pypiConflictBuildLogExtract_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageVersion_ = "";
  /**
   *
   *
   * <pre>
   * Composer image for which the build was happening.
   * </pre>
   *
   * <code>string image_version = 5;</code>
   *
   * @return The imageVersion.
   */
  @java.lang.Override
  public java.lang.String getImageVersion() {
    java.lang.Object ref = imageVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Composer image for which the build was happening.
   * </pre>
   *
   * <code>string image_version = 5;</code>
   *
   * @return The bytes for imageVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageVersionBytes() {
    java.lang.Object ref = imageVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PYPI_DEPENDENCIES_FIELD_NUMBER = 6;

  private static final class PypiDependenciesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
                .internal_static_google_cloud_orchestration_airflow_service_v1beta1_CheckUpgradeResponse_PypiDependenciesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> pypiDependencies_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetPypiDependencies() {
    if (pypiDependencies_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PypiDependenciesDefaultEntryHolder.defaultEntry);
    }
    return pypiDependencies_;
  }

  public int getPypiDependenciesCount() {
    return internalGetPypiDependencies().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Pypi dependencies specified in the environment configuration, at the time
   * when the build was triggered.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
   */
  @java.lang.Override
  public boolean containsPypiDependencies(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPypiDependencies().getMap().containsKey(key);
  }
  /** Use {@link #getPypiDependenciesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getPypiDependencies() {
    return getPypiDependenciesMap();
  }
  /**
   *
   *
   * <pre>
   * Pypi dependencies specified in the environment configuration, at the time
   * when the build was triggered.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPypiDependenciesMap() {
    return internalGetPypiDependencies().getMap();
  }
  /**
   *
   *
   * <pre>
   * Pypi dependencies specified in the environment configuration, at the time
   * when the build was triggered.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getPypiDependenciesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetPypiDependencies().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Pypi dependencies specified in the environment configuration, at the time
   * when the build was triggered.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getPypiDependenciesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetPypiDependencies().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildLogUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, buildLogUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pypiConflictBuildLogExtract_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pypiConflictBuildLogExtract_);
    }
    if (containsPypiModulesConflict_
        != com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
            .ConflictResult.CONFLICT_RESULT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, containsPypiModulesConflict_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, imageVersion_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetPypiDependencies(), PypiDependenciesDefaultEntryHolder.defaultEntry, 6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildLogUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, buildLogUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pypiConflictBuildLogExtract_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pypiConflictBuildLogExtract_);
    }
    if (containsPypiModulesConflict_
        != com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
            .ConflictResult.CONFLICT_RESULT_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(4, containsPypiModulesConflict_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, imageVersion_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetPypiDependencies().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> pypiDependencies__ =
          PypiDependenciesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, pypiDependencies__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse) obj;

    if (!getBuildLogUri().equals(other.getBuildLogUri())) return false;
    if (containsPypiModulesConflict_ != other.containsPypiModulesConflict_) return false;
    if (!getPypiConflictBuildLogExtract().equals(other.getPypiConflictBuildLogExtract()))
      return false;
    if (!getImageVersion().equals(other.getImageVersion())) return false;
    if (!internalGetPypiDependencies().equals(other.internalGetPypiDependencies())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUILD_LOG_URI_FIELD_NUMBER;
    hash = (53 * hash) + getBuildLogUri().hashCode();
    hash = (37 * hash) + CONTAINS_PYPI_MODULES_CONFLICT_FIELD_NUMBER;
    hash = (53 * hash) + containsPypiModulesConflict_;
    hash = (37 * hash) + PYPI_CONFLICT_BUILD_LOG_EXTRACT_FIELD_NUMBER;
    hash = (53 * hash) + getPypiConflictBuildLogExtract().hashCode();
    hash = (37 * hash) + IMAGE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getImageVersion().hashCode();
    if (!internalGetPypiDependencies().getMap().isEmpty()) {
      hash = (37 * hash) + PYPI_DEPENDENCIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPypiDependencies().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message containing information about the result of an upgrade check
   * operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse)
      com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_CheckUpgradeResponse_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetPypiDependencies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutablePypiDependencies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_CheckUpgradeResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      buildLogUri_ = "";
      containsPypiModulesConflict_ = 0;
      pypiConflictBuildLogExtract_ = "";
      imageVersion_ = "";
      internalGetMutablePypiDependencies().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_CheckUpgradeResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
        buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.buildLogUri_ = buildLogUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.containsPypiModulesConflict_ = containsPypiModulesConflict_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pypiConflictBuildLogExtract_ = pypiConflictBuildLogExtract_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.imageVersion_ = imageVersion_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pypiDependencies_ = internalGetPypiDependencies();
        result.pypiDependencies_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
              .getDefaultInstance()) return this;
      if (!other.getBuildLogUri().isEmpty()) {
        buildLogUri_ = other.buildLogUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.containsPypiModulesConflict_ != 0) {
        setContainsPypiModulesConflictValue(other.getContainsPypiModulesConflictValue());
      }
      if (!other.getPypiConflictBuildLogExtract().isEmpty()) {
        pypiConflictBuildLogExtract_ = other.pypiConflictBuildLogExtract_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getImageVersion().isEmpty()) {
        imageVersion_ = other.imageVersion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutablePypiDependencies().mergeFrom(other.internalGetPypiDependencies());
      bitField0_ |= 0x00000010;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                buildLogUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                pypiConflictBuildLogExtract_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                containsPypiModulesConflict_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 32
            case 42:
              {
                imageVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    pypiDependencies__ =
                        input.readMessage(
                            PypiDependenciesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutablePypiDependencies()
                    .getMutableMap()
                    .put(pypiDependencies__.getKey(), pypiDependencies__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object buildLogUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Url for a docker build log of an upgraded image.
     * </pre>
     *
     * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The buildLogUri.
     */
    public java.lang.String getBuildLogUri() {
      java.lang.Object ref = buildLogUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildLogUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Url for a docker build log of an upgraded image.
     * </pre>
     *
     * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for buildLogUri.
     */
    public com.google.protobuf.ByteString getBuildLogUriBytes() {
      java.lang.Object ref = buildLogUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildLogUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Url for a docker build log of an upgraded image.
     * </pre>
     *
     * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The buildLogUri to set.
     * @return This builder for chaining.
     */
    public Builder setBuildLogUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildLogUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Url for a docker build log of an upgraded image.
     * </pre>
     *
     * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildLogUri() {
      buildLogUri_ = getDefaultInstance().getBuildLogUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Url for a docker build log of an upgraded image.
     * </pre>
     *
     * <code>string build_log_uri = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for buildLogUri to set.
     * @return This builder for chaining.
     */
    public Builder setBuildLogUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildLogUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int containsPypiModulesConflict_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Whether build has succeeded or failed on modules conflicts.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for containsPypiModulesConflict.
     */
    @java.lang.Override
    public int getContainsPypiModulesConflictValue() {
      return containsPypiModulesConflict_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether build has succeeded or failed on modules conflicts.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for containsPypiModulesConflict to set.
     * @return This builder for chaining.
     */
    public Builder setContainsPypiModulesConflictValue(int value) {
      containsPypiModulesConflict_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether build has succeeded or failed on modules conflicts.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The containsPypiModulesConflict.
     */
    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
            .ConflictResult
        getContainsPypiModulesConflict() {
      com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult
          result =
              com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
                  .ConflictResult.forNumber(containsPypiModulesConflict_);
      return result == null
          ? com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
              .ConflictResult.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether build has succeeded or failed on modules conflicts.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The containsPypiModulesConflict to set.
     * @return This builder for chaining.
     */
    public Builder setContainsPypiModulesConflict(
        com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      containsPypiModulesConflict_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether build has succeeded or failed on modules conflicts.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse.ConflictResult contains_pypi_modules_conflict = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainsPypiModulesConflict() {
      bitField0_ = (bitField0_ & ~0x00000002);
      containsPypiModulesConflict_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pypiConflictBuildLogExtract_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Extract from a docker image build log containing information
     * about pypi modules conflicts.
     * </pre>
     *
     * <code>
     * string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The pypiConflictBuildLogExtract.
     */
    public java.lang.String getPypiConflictBuildLogExtract() {
      java.lang.Object ref = pypiConflictBuildLogExtract_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pypiConflictBuildLogExtract_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Extract from a docker image build log containing information
     * about pypi modules conflicts.
     * </pre>
     *
     * <code>
     * string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for pypiConflictBuildLogExtract.
     */
    public com.google.protobuf.ByteString getPypiConflictBuildLogExtractBytes() {
      java.lang.Object ref = pypiConflictBuildLogExtract_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pypiConflictBuildLogExtract_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Extract from a docker image build log containing information
     * about pypi modules conflicts.
     * </pre>
     *
     * <code>
     * string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The pypiConflictBuildLogExtract to set.
     * @return This builder for chaining.
     */
    public Builder setPypiConflictBuildLogExtract(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pypiConflictBuildLogExtract_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Extract from a docker image build log containing information
     * about pypi modules conflicts.
     * </pre>
     *
     * <code>
     * string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPypiConflictBuildLogExtract() {
      pypiConflictBuildLogExtract_ = getDefaultInstance().getPypiConflictBuildLogExtract();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Extract from a docker image build log containing information
     * about pypi modules conflicts.
     * </pre>
     *
     * <code>
     * string pypi_conflict_build_log_extract = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for pypiConflictBuildLogExtract to set.
     * @return This builder for chaining.
     */
    public Builder setPypiConflictBuildLogExtractBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pypiConflictBuildLogExtract_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object imageVersion_ = "";
    /**
     *
     *
     * <pre>
     * Composer image for which the build was happening.
     * </pre>
     *
     * <code>string image_version = 5;</code>
     *
     * @return The imageVersion.
     */
    public java.lang.String getImageVersion() {
      java.lang.Object ref = imageVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Composer image for which the build was happening.
     * </pre>
     *
     * <code>string image_version = 5;</code>
     *
     * @return The bytes for imageVersion.
     */
    public com.google.protobuf.ByteString getImageVersionBytes() {
      java.lang.Object ref = imageVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Composer image for which the build was happening.
     * </pre>
     *
     * <code>string image_version = 5;</code>
     *
     * @param value The imageVersion to set.
     * @return This builder for chaining.
     */
    public Builder setImageVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Composer image for which the build was happening.
     * </pre>
     *
     * <code>string image_version = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageVersion() {
      imageVersion_ = getDefaultInstance().getImageVersion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Composer image for which the build was happening.
     * </pre>
     *
     * <code>string image_version = 5;</code>
     *
     * @param value The bytes for imageVersion to set.
     * @return This builder for chaining.
     */
    public Builder setImageVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> pypiDependencies_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetPypiDependencies() {
      if (pypiDependencies_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PypiDependenciesDefaultEntryHolder.defaultEntry);
      }
      return pypiDependencies_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutablePypiDependencies() {
      if (pypiDependencies_ == null) {
        pypiDependencies_ =
            com.google.protobuf.MapField.newMapField(
                PypiDependenciesDefaultEntryHolder.defaultEntry);
      }
      if (!pypiDependencies_.isMutable()) {
        pypiDependencies_ = pypiDependencies_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return pypiDependencies_;
    }

    public int getPypiDependenciesCount() {
      return internalGetPypiDependencies().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    @java.lang.Override
    public boolean containsPypiDependencies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPypiDependencies().getMap().containsKey(key);
    }
    /** Use {@link #getPypiDependenciesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getPypiDependencies() {
      return getPypiDependenciesMap();
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPypiDependenciesMap() {
      return internalGetPypiDependencies().getMap();
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getPypiDependenciesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetPypiDependencies().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getPypiDependenciesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetPypiDependencies().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPypiDependencies() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutablePypiDependencies().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    public Builder removePypiDependencies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePypiDependencies().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutablePypiDependencies() {
      bitField0_ |= 0x00000010;
      return internalGetMutablePypiDependencies().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    public Builder putPypiDependencies(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePypiDependencies().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pypi dependencies specified in the environment configuration, at the time
     * when the build was triggered.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_dependencies = 6;</code>
     */
    public Builder putAllPypiDependencies(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutablePypiDependencies().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckUpgradeResponse> PARSER =
      new com.google.protobuf.AbstractParser<CheckUpgradeResponse>() {
        @java.lang.Override
        public CheckUpgradeResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CheckUpgradeResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckUpgradeResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
