/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration options for networking connections in the Composer 2
 * environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig}
 */
public final class NetworkingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig)
    NetworkingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkingConfig.newBuilder() to construct.
  private NetworkingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkingConfig() {
    connectionType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_NetworkingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_NetworkingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents connection type between Composer environment in Customer
   * Project and the corresponding Tenant project, from a predefined list
   * of available connection modes.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType}
   */
  public enum ConnectionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No specific connection type was requested, so the environment uses
     * the default value corresponding to the rest of its configuration.
     * </pre>
     *
     * <code>CONNECTION_TYPE_UNSPECIFIED = 0;</code>
     */
    CONNECTION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Requests the use of VPC peerings for connecting the Customer and Tenant
     * projects.
     * </pre>
     *
     * <code>VPC_PEERING = 1;</code>
     */
    VPC_PEERING(1),
    /**
     *
     *
     * <pre>
     * Requests the use of Private Service Connect for connecting the Customer
     * and Tenant projects.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 2;</code>
     */
    PRIVATE_SERVICE_CONNECT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No specific connection type was requested, so the environment uses
     * the default value corresponding to the rest of its configuration.
     * </pre>
     *
     * <code>CONNECTION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int CONNECTION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Requests the use of VPC peerings for connecting the Customer and Tenant
     * projects.
     * </pre>
     *
     * <code>VPC_PEERING = 1;</code>
     */
    public static final int VPC_PEERING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Requests the use of Private Service Connect for connecting the Customer
     * and Tenant projects.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 2;</code>
     */
    public static final int PRIVATE_SERVICE_CONNECT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectionType forNumber(int value) {
      switch (value) {
        case 0:
          return CONNECTION_TYPE_UNSPECIFIED;
        case 1:
          return VPC_PEERING;
        case 2:
          return PRIVATE_SERVICE_CONNECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectionType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConnectionType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ConnectionType>() {
          public ConnectionType findValueByNumber(int number) {
            return ConnectionType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ConnectionType[] VALUES = values();

    public static ConnectionType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType)
  }

  public static final int CONNECTION_TYPE_FIELD_NUMBER = 1;
  private int connectionType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Indicates the user requested specifc connection type between
   * Tenant and Customer projects. You cannot set networking connection type in
   * public IP environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for connectionType.
   */
  @java.lang.Override
  public int getConnectionTypeValue() {
    return connectionType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates the user requested specifc connection type between
   * Tenant and Customer projects. You cannot set networking connection type in
   * public IP environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The connectionType.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
      getConnectionType() {
    com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType result =
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
            .forNumber(connectionType_);
    return result == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (connectionType_
        != com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
            .CONNECTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, connectionType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (connectionType_
        != com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
            .CONNECTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, connectionType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig) obj;

    if (connectionType_ != other.connectionType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONNECTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + connectionType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for networking connections in the Composer 2
   * environment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig)
      com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_NetworkingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_NetworkingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      connectionType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_NetworkingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.connectionType_ = connectionType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
              .getDefaultInstance()) return this;
      if (other.connectionType_ != 0) {
        setConnectionTypeValue(other.getConnectionTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                connectionType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int connectionType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates the user requested specifc connection type between
     * Tenant and Customer projects. You cannot set networking connection type in
     * public IP environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for connectionType.
     */
    @java.lang.Override
    public int getConnectionTypeValue() {
      return connectionType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the user requested specifc connection type between
     * Tenant and Customer projects. You cannot set networking connection type in
     * public IP environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for connectionType to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionTypeValue(int value) {
      connectionType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the user requested specifc connection type between
     * Tenant and Customer projects. You cannot set networking connection type in
     * public IP environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The connectionType.
     */
    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
        getConnectionType() {
      com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
          result =
              com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
                  .forNumber(connectionType_);
      return result == null
          ? com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the user requested specifc connection type between
     * Tenant and Customer projects. You cannot set networking connection type in
     * public IP environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The connectionType to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionType(
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      connectionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the user requested specifc connection type between
     * Tenant and Customer projects. You cannot set networking connection type in
     * public IP environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.ConnectionType connection_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      connectionType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkingConfig> PARSER =
      new com.google.protobuf.AbstractParser<NetworkingConfig>() {
        @java.lang.Override
        public NetworkingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
