/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/operations.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata describing an operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata}
 */
public final class OperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata)
    OperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadata.newBuilder() to construct.
  private OperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadata() {
    state_ = 0;
    operationType_ = 0;
    resource_ = "";
    resourceUuid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.OperationsProto
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_OperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.OperationsProto
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_OperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum describing the overall state of an operation.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The operation has been created but is not yet started.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The operation is underway.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The operation completed successfully.
     * </pre>
     *
     * <code>SUCCESSFUL = 3;</code>
     */
    SUCCESSFUL(3),
    /**
     *
     *
     * <pre>
     * The operation is no longer running but did not succeed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The operation has been created but is not yet started.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The operation is underway.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The operation completed successfully.
     * </pre>
     *
     * <code>SUCCESSFUL = 3;</code>
     */
    public static final int SUCCESSFUL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The operation is no longer running but did not succeed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return SUCCESSFUL;
        case 4:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State)
  }

  /**
   *
   *
   * <pre>
   * Type of longrunning operation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A resource creation operation.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    CREATE(1),
    /**
     *
     *
     * <pre>
     * A resource deletion operation.
     * </pre>
     *
     * <code>DELETE = 2;</code>
     */
    DELETE(2),
    /**
     *
     *
     * <pre>
     * A resource update operation.
     * </pre>
     *
     * <code>UPDATE = 3;</code>
     */
    UPDATE(3),
    /**
     *
     *
     * <pre>
     * A resource check operation.
     * </pre>
     *
     * <code>CHECK = 4;</code>
     */
    CHECK(4),
    /**
     *
     *
     * <pre>
     * Saves snapshot of the resource operation.
     * </pre>
     *
     * <code>SAVE_SNAPSHOT = 5;</code>
     */
    SAVE_SNAPSHOT(5),
    /**
     *
     *
     * <pre>
     * Loads snapshot of the resource operation.
     * </pre>
     *
     * <code>LOAD_SNAPSHOT = 6;</code>
     */
    LOAD_SNAPSHOT(6),
    /**
     *
     *
     * <pre>
     * Triggers failover of environment's Cloud SQL instance (only for highly
     * resilient environments).
     * </pre>
     *
     * <code>DATABASE_FAILOVER = 7;</code>
     */
    DATABASE_FAILOVER(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A resource creation operation.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    public static final int CREATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A resource deletion operation.
     * </pre>
     *
     * <code>DELETE = 2;</code>
     */
    public static final int DELETE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * A resource update operation.
     * </pre>
     *
     * <code>UPDATE = 3;</code>
     */
    public static final int UPDATE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A resource check operation.
     * </pre>
     *
     * <code>CHECK = 4;</code>
     */
    public static final int CHECK_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Saves snapshot of the resource operation.
     * </pre>
     *
     * <code>SAVE_SNAPSHOT = 5;</code>
     */
    public static final int SAVE_SNAPSHOT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Loads snapshot of the resource operation.
     * </pre>
     *
     * <code>LOAD_SNAPSHOT = 6;</code>
     */
    public static final int LOAD_SNAPSHOT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Triggers failover of environment's Cloud SQL instance (only for highly
     * resilient environments).
     * </pre>
     *
     * <code>DATABASE_FAILOVER = 7;</code>
     */
    public static final int DATABASE_FAILOVER_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return CREATE;
        case 2:
          return DELETE;
        case 3:
          return UPDATE;
        case 4:
          return CHECK;
        case 5:
          return SAVE_SNAPSHOT;
        case 6:
          return LOAD_SNAPSHOT;
        case 7:
          return DATABASE_FAILOVER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
          .getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type)
  }

  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current operation state.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current operation state.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State getState() {
    com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State result =
        com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State.forNumber(
            state_);
    return result == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State
            .UNRECOGNIZED
        : result;
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 2;
  private int operationType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The type of operation being performed.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for operationType.
   */
  @java.lang.Override
  public int getOperationTypeValue() {
    return operationType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The type of operation being performed.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
   * </code>
   *
   * @return The operationType.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type
      getOperationType() {
    com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type result =
        com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type.forNumber(
            operationType_);
    return result == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type.UNRECOGNIZED
        : result;
  }

  public static final int RESOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource being operated on, as a [relative resource name](
   * /apis/design/resource_names#relative_resource_name).
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource being operated on, as a [relative resource name](
   * /apis/design/resource_names#relative_resource_name).
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_UUID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceUuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The UUID of the resource being operated on.
   * </pre>
   *
   * <code>string resource_uuid = 4;</code>
   *
   * @return The resourceUuid.
   */
  @java.lang.Override
  public java.lang.String getResourceUuid() {
    java.lang.Object ref = resourceUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The UUID of the resource being operated on.
   * </pre>
   *
   * <code>string resource_uuid = 4;</code>
   *
   * @return The bytes for resourceUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceUuidBytes() {
    java.lang.Object ref = resourceUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was submitted to the server.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was submitted to the server.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was submitted to the server.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the operation terminated, regardless of its
   * success. This field is unset if the operation is still ongoing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the operation terminated, regardless of its
   * success. This field is unset if the operation is still ongoing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the operation terminated, regardless of its
   * success. This field is unset if the operation is still ongoing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_
        != com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State
            .STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, state_);
    }
    if (operationType_
        != com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type
            .TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceUuid_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (endTime_ != null) {
      output.writeMessage(6, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_
        != com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State
            .STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (operationType_
        != com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type
            .TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceUuid_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata) obj;

    if (state_ != other.state_) return false;
    if (operationType_ != other.operationType_) return false;
    if (!getResource().equals(other.getResource())) return false;
    if (!getResourceUuid().equals(other.getResourceUuid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + operationType_;
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + RESOURCE_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getResourceUuid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing an operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata)
      com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.OperationsProto
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.OperationsProto
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_OperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      operationType_ = 0;
      resource_ = "";
      resourceUuid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.OperationsProto
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.operationType_ = operationType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resource_ = resource_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resourceUuid_ = resourceUuid_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
              .getDefaultInstance()) return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.operationType_ != 0) {
        setOperationTypeValue(other.getOperationTypeValue());
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getResourceUuid().isEmpty()) {
        resourceUuid_ = other.resourceUuid_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                operationType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                resourceUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current operation state.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current operation state.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current operation state.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State
        getState() {
      com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State result =
          com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State.forNumber(
              state_);
      return result == null
          ? com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current operation state.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current operation state.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.State state = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private int operationType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The type of operation being performed.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for operationType.
     */
    @java.lang.Override
    public int getOperationTypeValue() {
      return operationType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of operation being performed.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeValue(int value) {
      operationType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of operation being performed.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
     * </code>
     *
     * @return The operationType.
     */
    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type
        getOperationType() {
      com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type result =
          com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type.forNumber(
              operationType_);
      return result == null
          ? com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of operation being performed.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
     * </code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(
        com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      operationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of operation being performed.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata.Type operation_type = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      operationType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource being operated on, as a [relative resource name](
     * /apis/design/resource_names#relative_resource_name).
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource being operated on, as a [relative resource name](
     * /apis/design/resource_names#relative_resource_name).
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource being operated on, as a [relative resource name](
     * /apis/design/resource_names#relative_resource_name).
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource being operated on, as a [relative resource name](
     * /apis/design/resource_names#relative_resource_name).
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource being operated on, as a [relative resource name](
     * /apis/design/resource_names#relative_resource_name).
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object resourceUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The UUID of the resource being operated on.
     * </pre>
     *
     * <code>string resource_uuid = 4;</code>
     *
     * @return The resourceUuid.
     */
    public java.lang.String getResourceUuid() {
      java.lang.Object ref = resourceUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of the resource being operated on.
     * </pre>
     *
     * <code>string resource_uuid = 4;</code>
     *
     * @return The bytes for resourceUuid.
     */
    public com.google.protobuf.ByteString getResourceUuidBytes() {
      java.lang.Object ref = resourceUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of the resource being operated on.
     * </pre>
     *
     * <code>string resource_uuid = 4;</code>
     *
     * @param value The resourceUuid to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceUuid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of the resource being operated on.
     * </pre>
     *
     * <code>string resource_uuid = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceUuid() {
      resourceUuid_ = getDefaultInstance().getResourceUuid();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of the resource being operated on.
     * </pre>
     *
     * <code>string resource_uuid = 4;</code>
     *
     * @param value The bytes for resourceUuid to set.
     * @return This builder for chaining.
     */
    public Builder setResourceUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceUuid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was submitted to the server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the operation terminated, regardless of its
     * success. This field is unset if the operation is still ongoing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadata>() {
        @java.lang.Override
        public OperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
