/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Specifies the selection and configuration of software inside the environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig}
 */
public final class SoftwareConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig)
    SoftwareConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SoftwareConfig.newBuilder() to construct.
  private SoftwareConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SoftwareConfig() {
    imageVersion_ = "";
    pythonVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SoftwareConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetAirflowConfigOverrides();
      case 3:
        return internalGetPypiPackages();
      case 4:
        return internalGetEnvVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder.class);
  }

  public static final int IMAGE_VERSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageVersion_ = "";
  /**
   *
   *
   * <pre>
   * The version of the software running in the environment.
   * This encapsulates both the version of Cloud Composer functionality and the
   * version of Apache Airflow. It must match the regular expression
   * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
   * When used as input, the server also checks if the provided version is
   * supported and denies the request for an unsupported version.
   *
   * The Cloud Composer portion of the image version is a full
   * [semantic version](https://semver.org), or an alias in the form of major
   * version number or `latest`. When an alias is provided, the server replaces
   * it with the current Cloud Composer version that satisfies the alias.
   *
   * The Apache Airflow portion of the image version is a full semantic version
   * that points to one of the supported Apache Airflow versions, or an alias in
   * the form of only major or major.minor versions specified. When an alias is
   * provided, the server replaces it with the latest Apache Airflow version
   * that satisfies the alias and is supported in the given Cloud Composer
   * version.
   *
   * In all cases, the resolved image version is stored in the same field.
   *
   * See also [version
   * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
   * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
   * </pre>
   *
   * <code>string image_version = 1;</code>
   *
   * @return The imageVersion.
   */
  @java.lang.Override
  public java.lang.String getImageVersion() {
    java.lang.Object ref = imageVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The version of the software running in the environment.
   * This encapsulates both the version of Cloud Composer functionality and the
   * version of Apache Airflow. It must match the regular expression
   * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
   * When used as input, the server also checks if the provided version is
   * supported and denies the request for an unsupported version.
   *
   * The Cloud Composer portion of the image version is a full
   * [semantic version](https://semver.org), or an alias in the form of major
   * version number or `latest`. When an alias is provided, the server replaces
   * it with the current Cloud Composer version that satisfies the alias.
   *
   * The Apache Airflow portion of the image version is a full semantic version
   * that points to one of the supported Apache Airflow versions, or an alias in
   * the form of only major or major.minor versions specified. When an alias is
   * provided, the server replaces it with the latest Apache Airflow version
   * that satisfies the alias and is supported in the given Cloud Composer
   * version.
   *
   * In all cases, the resolved image version is stored in the same field.
   *
   * See also [version
   * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
   * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
   * </pre>
   *
   * <code>string image_version = 1;</code>
   *
   * @return The bytes for imageVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageVersionBytes() {
    java.lang.Object ref = imageVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AIRFLOW_CONFIG_OVERRIDES_FIELD_NUMBER = 2;

  private static final class AirflowConfigOverridesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
                .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_AirflowConfigOverridesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> airflowConfigOverrides_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAirflowConfigOverrides() {
    if (airflowConfigOverrides_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          AirflowConfigOverridesDefaultEntryHolder.defaultEntry);
    }
    return airflowConfigOverrides_;
  }

  public int getAirflowConfigOverridesCount() {
    return internalGetAirflowConfigOverrides().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Apache Airflow configuration properties to override.
   *
   * Property keys contain the section and property names, separated by a
   * hyphen, for example "core-dags_are_paused_at_creation". Section names must
   * not contain hyphens ("-"), opening square brackets ("["),  or closing
   * square brackets ("]"). The property name must not be empty and must not
   * contain an equals sign ("=") or semicolon (";"). Section and property names
   * must not contain a period ("."). Apache Airflow configuration property
   * names must be written in
   * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
   * contain any character, and can be written in any lower/upper case format.
   *
   * Certain Apache Airflow configuration property values are
   * [blocked](/composer/docs/concepts/airflow-configurations),
   * and cannot be overridden.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAirflowConfigOverrides(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAirflowConfigOverrides().getMap().containsKey(key);
  }
  /** Use {@link #getAirflowConfigOverridesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAirflowConfigOverrides() {
    return getAirflowConfigOverridesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Apache Airflow configuration properties to override.
   *
   * Property keys contain the section and property names, separated by a
   * hyphen, for example "core-dags_are_paused_at_creation". Section names must
   * not contain hyphens ("-"), opening square brackets ("["),  or closing
   * square brackets ("]"). The property name must not be empty and must not
   * contain an equals sign ("=") or semicolon (";"). Section and property names
   * must not contain a period ("."). Apache Airflow configuration property
   * names must be written in
   * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
   * contain any character, and can be written in any lower/upper case format.
   *
   * Certain Apache Airflow configuration property values are
   * [blocked](/composer/docs/concepts/airflow-configurations),
   * and cannot be overridden.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAirflowConfigOverridesMap() {
    return internalGetAirflowConfigOverrides().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Apache Airflow configuration properties to override.
   *
   * Property keys contain the section and property names, separated by a
   * hyphen, for example "core-dags_are_paused_at_creation". Section names must
   * not contain hyphens ("-"), opening square brackets ("["),  or closing
   * square brackets ("]"). The property name must not be empty and must not
   * contain an equals sign ("=") or semicolon (";"). Section and property names
   * must not contain a period ("."). Apache Airflow configuration property
   * names must be written in
   * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
   * contain any character, and can be written in any lower/upper case format.
   *
   * Certain Apache Airflow configuration property values are
   * [blocked](/composer/docs/concepts/airflow-configurations),
   * and cannot be overridden.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAirflowConfigOverridesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetAirflowConfigOverrides().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Apache Airflow configuration properties to override.
   *
   * Property keys contain the section and property names, separated by a
   * hyphen, for example "core-dags_are_paused_at_creation". Section names must
   * not contain hyphens ("-"), opening square brackets ("["),  or closing
   * square brackets ("]"). The property name must not be empty and must not
   * contain an equals sign ("=") or semicolon (";"). Section and property names
   * must not contain a period ("."). Apache Airflow configuration property
   * names must be written in
   * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
   * contain any character, and can be written in any lower/upper case format.
   *
   * Certain Apache Airflow configuration property values are
   * [blocked](/composer/docs/concepts/airflow-configurations),
   * and cannot be overridden.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAirflowConfigOverridesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetAirflowConfigOverrides().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PYPI_PACKAGES_FIELD_NUMBER = 3;

  private static final class PypiPackagesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
                .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_PypiPackagesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> pypiPackages_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetPypiPackages() {
    if (pypiPackages_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PypiPackagesDefaultEntryHolder.defaultEntry);
    }
    return pypiPackages_;
  }

  public int getPypiPackagesCount() {
    return internalGetPypiPackages().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom Python Package Index (PyPI) packages to be installed in
   * the environment.
   *
   * Keys refer to the lowercase package name such as "numpy"
   * and values are the lowercase extras and version specifier such as
   * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
   * package without pinning it to a version specifier, use the empty string as
   * the value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsPypiPackages(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPypiPackages().getMap().containsKey(key);
  }
  /** Use {@link #getPypiPackagesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getPypiPackages() {
    return getPypiPackagesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom Python Package Index (PyPI) packages to be installed in
   * the environment.
   *
   * Keys refer to the lowercase package name such as "numpy"
   * and values are the lowercase extras and version specifier such as
   * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
   * package without pinning it to a version specifier, use the empty string as
   * the value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPypiPackagesMap() {
    return internalGetPypiPackages().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom Python Package Index (PyPI) packages to be installed in
   * the environment.
   *
   * Keys refer to the lowercase package name such as "numpy"
   * and values are the lowercase extras and version specifier such as
   * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
   * package without pinning it to a version specifier, use the empty string as
   * the value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getPypiPackagesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetPypiPackages().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom Python Package Index (PyPI) packages to be installed in
   * the environment.
   *
   * Keys refer to the lowercase package name such as "numpy"
   * and values are the lowercase extras and version specifier such as
   * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
   * package without pinning it to a version specifier, use the empty string as
   * the value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getPypiPackagesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetPypiPackages().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENV_VARIABLES_FIELD_NUMBER = 4;

  private static final class EnvVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
                .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_EnvVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> envVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvVariables() {
    if (envVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvVariablesDefaultEntryHolder.defaultEntry);
    }
    return envVariables_;
  }

  public int getEnvVariablesCount() {
    return internalGetEnvVariables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional environment variables to provide to the Apache Airflow
   * scheduler, worker, and webserver processes.
   *
   * Environment variable names must match the regular expression
   * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
   * software configuration overrides (they cannot match the regular expression
   * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
   * following reserved names:
   *
   * * `AIRFLOW_HOME`
   * * `C_FORCE_ROOT`
   * * `CONTAINER_NAME`
   * * `DAGS_FOLDER`
   * * `GCP_PROJECT`
   * * `GCS_BUCKET`
   * * `GKE_CLUSTER_NAME`
   * * `SQL_DATABASE`
   * * `SQL_INSTANCE`
   * * `SQL_PASSWORD`
   * * `SQL_PROJECT`
   * * `SQL_REGION`
   * * `SQL_USER`
   * </pre>
   *
   * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsEnvVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvVariables().getMap().containsKey(key);
  }
  /** Use {@link #getEnvVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvVariables() {
    return getEnvVariablesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional environment variables to provide to the Apache Airflow
   * scheduler, worker, and webserver processes.
   *
   * Environment variable names must match the regular expression
   * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
   * software configuration overrides (they cannot match the regular expression
   * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
   * following reserved names:
   *
   * * `AIRFLOW_HOME`
   * * `C_FORCE_ROOT`
   * * `CONTAINER_NAME`
   * * `DAGS_FOLDER`
   * * `GCP_PROJECT`
   * * `GCS_BUCKET`
   * * `GKE_CLUSTER_NAME`
   * * `SQL_DATABASE`
   * * `SQL_INSTANCE`
   * * `SQL_PASSWORD`
   * * `SQL_PROJECT`
   * * `SQL_REGION`
   * * `SQL_USER`
   * </pre>
   *
   * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvVariablesMap() {
    return internalGetEnvVariables().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional environment variables to provide to the Apache Airflow
   * scheduler, worker, and webserver processes.
   *
   * Environment variable names must match the regular expression
   * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
   * software configuration overrides (they cannot match the regular expression
   * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
   * following reserved names:
   *
   * * `AIRFLOW_HOME`
   * * `C_FORCE_ROOT`
   * * `CONTAINER_NAME`
   * * `DAGS_FOLDER`
   * * `GCP_PROJECT`
   * * `GCS_BUCKET`
   * * `GKE_CLUSTER_NAME`
   * * `SQL_DATABASE`
   * * `SQL_INSTANCE`
   * * `SQL_PASSWORD`
   * * `SQL_PROJECT`
   * * `SQL_REGION`
   * * `SQL_USER`
   * </pre>
   *
   * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getEnvVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional environment variables to provide to the Apache Airflow
   * scheduler, worker, and webserver processes.
   *
   * Environment variable names must match the regular expression
   * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
   * software configuration overrides (they cannot match the regular expression
   * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
   * following reserved names:
   *
   * * `AIRFLOW_HOME`
   * * `C_FORCE_ROOT`
   * * `CONTAINER_NAME`
   * * `DAGS_FOLDER`
   * * `GCP_PROJECT`
   * * `GCS_BUCKET`
   * * `GKE_CLUSTER_NAME`
   * * `SQL_DATABASE`
   * * `SQL_INSTANCE`
   * * `SQL_PASSWORD`
   * * `SQL_PROJECT`
   * * `SQL_REGION`
   * * `SQL_USER`
   * </pre>
   *
   * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getEnvVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PYTHON_VERSION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pythonVersion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The major version of Python used to run the Apache Airflow
   * scheduler, worker, and webserver processes.
   *
   * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
   * updated.
   *
   * This field is only supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
   * Python major version 3.
   * </pre>
   *
   * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pythonVersion.
   */
  @java.lang.Override
  public java.lang.String getPythonVersion() {
    java.lang.Object ref = pythonVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pythonVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The major version of Python used to run the Apache Airflow
   * scheduler, worker, and webserver processes.
   *
   * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
   * updated.
   *
   * This field is only supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
   * Python major version 3.
   * </pre>
   *
   * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pythonVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPythonVersionBytes() {
    java.lang.Object ref = pythonVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pythonVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEDULER_COUNT_FIELD_NUMBER = 7;
  private int schedulerCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The number of schedulers for Airflow.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-2.*.*.
   * </pre>
   *
   * <code>int32 scheduler_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The schedulerCount.
   */
  @java.lang.Override
  public int getSchedulerCount() {
    return schedulerCount_;
  }

  public static final int CLOUD_DATA_LINEAGE_INTEGRATION_FIELD_NUMBER = 8;
  private com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
      cloudDataLineageIntegration_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration for Cloud Data Lineage integration.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cloudDataLineageIntegration field is set.
   */
  @java.lang.Override
  public boolean hasCloudDataLineageIntegration() {
    return cloudDataLineageIntegration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration for Cloud Data Lineage integration.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudDataLineageIntegration.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
      getCloudDataLineageIntegration() {
    return cloudDataLineageIntegration_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
            .getDefaultInstance()
        : cloudDataLineageIntegration_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration for Cloud Data Lineage integration.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegrationOrBuilder
      getCloudDataLineageIntegrationOrBuilder() {
    return cloudDataLineageIntegration_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
            .getDefaultInstance()
        : cloudDataLineageIntegration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageVersion_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetAirflowConfigOverrides(),
        AirflowConfigOverridesDefaultEntryHolder.defaultEntry,
        2);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetPypiPackages(), PypiPackagesDefaultEntryHolder.defaultEntry, 3);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetEnvVariables(), EnvVariablesDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pythonVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pythonVersion_);
    }
    if (schedulerCount_ != 0) {
      output.writeInt32(7, schedulerCount_);
    }
    if (cloudDataLineageIntegration_ != null) {
      output.writeMessage(8, getCloudDataLineageIntegration());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageVersion_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAirflowConfigOverrides().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> airflowConfigOverrides__ =
          AirflowConfigOverridesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, airflowConfigOverrides__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetPypiPackages().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> pypiPackages__ =
          PypiPackagesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, pypiPackages__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> envVariables__ =
          EnvVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, envVariables__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pythonVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pythonVersion_);
    }
    if (schedulerCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, schedulerCount_);
    }
    if (cloudDataLineageIntegration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getCloudDataLineageIntegration());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig) obj;

    if (!getImageVersion().equals(other.getImageVersion())) return false;
    if (!internalGetAirflowConfigOverrides().equals(other.internalGetAirflowConfigOverrides()))
      return false;
    if (!internalGetPypiPackages().equals(other.internalGetPypiPackages())) return false;
    if (!internalGetEnvVariables().equals(other.internalGetEnvVariables())) return false;
    if (!getPythonVersion().equals(other.getPythonVersion())) return false;
    if (getSchedulerCount() != other.getSchedulerCount()) return false;
    if (hasCloudDataLineageIntegration() != other.hasCloudDataLineageIntegration()) return false;
    if (hasCloudDataLineageIntegration()) {
      if (!getCloudDataLineageIntegration().equals(other.getCloudDataLineageIntegration()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getImageVersion().hashCode();
    if (!internalGetAirflowConfigOverrides().getMap().isEmpty()) {
      hash = (37 * hash) + AIRFLOW_CONFIG_OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAirflowConfigOverrides().hashCode();
    }
    if (!internalGetPypiPackages().getMap().isEmpty()) {
      hash = (37 * hash) + PYPI_PACKAGES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPypiPackages().hashCode();
    }
    if (!internalGetEnvVariables().getMap().isEmpty()) {
      hash = (37 * hash) + ENV_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvVariables().hashCode();
    }
    hash = (37 * hash) + PYTHON_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getPythonVersion().hashCode();
    hash = (37 * hash) + SCHEDULER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSchedulerCount();
    if (hasCloudDataLineageIntegration()) {
      hash = (37 * hash) + CLOUD_DATA_LINEAGE_INTEGRATION_FIELD_NUMBER;
      hash = (53 * hash) + getCloudDataLineageIntegration().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the selection and configuration of software inside the environment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig)
      com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetAirflowConfigOverrides();
        case 3:
          return internalGetPypiPackages();
        case 4:
          return internalGetEnvVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableAirflowConfigOverrides();
        case 3:
          return internalGetMutablePypiPackages();
        case 4:
          return internalGetMutableEnvVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder.class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      imageVersion_ = "";
      internalGetMutableAirflowConfigOverrides().clear();
      internalGetMutablePypiPackages().clear();
      internalGetMutableEnvVariables().clear();
      pythonVersion_ = "";
      schedulerCount_ = 0;
      cloudDataLineageIntegration_ = null;
      if (cloudDataLineageIntegrationBuilder_ != null) {
        cloudDataLineageIntegrationBuilder_.dispose();
        cloudDataLineageIntegrationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_SoftwareConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.imageVersion_ = imageVersion_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.airflowConfigOverrides_ = internalGetAirflowConfigOverrides();
        result.airflowConfigOverrides_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pypiPackages_ = internalGetPypiPackages();
        result.pypiPackages_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.envVariables_ = internalGetEnvVariables();
        result.envVariables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pythonVersion_ = pythonVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.schedulerCount_ = schedulerCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cloudDataLineageIntegration_ =
            cloudDataLineageIntegrationBuilder_ == null
                ? cloudDataLineageIntegration_
                : cloudDataLineageIntegrationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
              .getDefaultInstance()) return this;
      if (!other.getImageVersion().isEmpty()) {
        imageVersion_ = other.imageVersion_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableAirflowConfigOverrides()
          .mergeFrom(other.internalGetAirflowConfigOverrides());
      bitField0_ |= 0x00000002;
      internalGetMutablePypiPackages().mergeFrom(other.internalGetPypiPackages());
      bitField0_ |= 0x00000004;
      internalGetMutableEnvVariables().mergeFrom(other.internalGetEnvVariables());
      bitField0_ |= 0x00000008;
      if (!other.getPythonVersion().isEmpty()) {
        pythonVersion_ = other.pythonVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getSchedulerCount() != 0) {
        setSchedulerCount(other.getSchedulerCount());
      }
      if (other.hasCloudDataLineageIntegration()) {
        mergeCloudDataLineageIntegration(other.getCloudDataLineageIntegration());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                imageVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    airflowConfigOverrides__ =
                        input.readMessage(
                            AirflowConfigOverridesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableAirflowConfigOverrides()
                    .getMutableMap()
                    .put(airflowConfigOverrides__.getKey(), airflowConfigOverrides__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> pypiPackages__ =
                    input.readMessage(
                        PypiPackagesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutablePypiPackages()
                    .getMutableMap()
                    .put(pypiPackages__.getKey(), pypiPackages__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> envVariables__ =
                    input.readMessage(
                        EnvVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableEnvVariables()
                    .getMutableMap()
                    .put(envVariables__.getKey(), envVariables__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                pythonVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                schedulerCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(
                    getCloudDataLineageIntegrationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageVersion_ = "";
    /**
     *
     *
     * <pre>
     * The version of the software running in the environment.
     * This encapsulates both the version of Cloud Composer functionality and the
     * version of Apache Airflow. It must match the regular expression
     * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
     * When used as input, the server also checks if the provided version is
     * supported and denies the request for an unsupported version.
     *
     * The Cloud Composer portion of the image version is a full
     * [semantic version](https://semver.org), or an alias in the form of major
     * version number or `latest`. When an alias is provided, the server replaces
     * it with the current Cloud Composer version that satisfies the alias.
     *
     * The Apache Airflow portion of the image version is a full semantic version
     * that points to one of the supported Apache Airflow versions, or an alias in
     * the form of only major or major.minor versions specified. When an alias is
     * provided, the server replaces it with the latest Apache Airflow version
     * that satisfies the alias and is supported in the given Cloud Composer
     * version.
     *
     * In all cases, the resolved image version is stored in the same field.
     *
     * See also [version
     * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
     * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
     * </pre>
     *
     * <code>string image_version = 1;</code>
     *
     * @return The imageVersion.
     */
    public java.lang.String getImageVersion() {
      java.lang.Object ref = imageVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the software running in the environment.
     * This encapsulates both the version of Cloud Composer functionality and the
     * version of Apache Airflow. It must match the regular expression
     * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
     * When used as input, the server also checks if the provided version is
     * supported and denies the request for an unsupported version.
     *
     * The Cloud Composer portion of the image version is a full
     * [semantic version](https://semver.org), or an alias in the form of major
     * version number or `latest`. When an alias is provided, the server replaces
     * it with the current Cloud Composer version that satisfies the alias.
     *
     * The Apache Airflow portion of the image version is a full semantic version
     * that points to one of the supported Apache Airflow versions, or an alias in
     * the form of only major or major.minor versions specified. When an alias is
     * provided, the server replaces it with the latest Apache Airflow version
     * that satisfies the alias and is supported in the given Cloud Composer
     * version.
     *
     * In all cases, the resolved image version is stored in the same field.
     *
     * See also [version
     * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
     * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
     * </pre>
     *
     * <code>string image_version = 1;</code>
     *
     * @return The bytes for imageVersion.
     */
    public com.google.protobuf.ByteString getImageVersionBytes() {
      java.lang.Object ref = imageVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the software running in the environment.
     * This encapsulates both the version of Cloud Composer functionality and the
     * version of Apache Airflow. It must match the regular expression
     * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
     * When used as input, the server also checks if the provided version is
     * supported and denies the request for an unsupported version.
     *
     * The Cloud Composer portion of the image version is a full
     * [semantic version](https://semver.org), or an alias in the form of major
     * version number or `latest`. When an alias is provided, the server replaces
     * it with the current Cloud Composer version that satisfies the alias.
     *
     * The Apache Airflow portion of the image version is a full semantic version
     * that points to one of the supported Apache Airflow versions, or an alias in
     * the form of only major or major.minor versions specified. When an alias is
     * provided, the server replaces it with the latest Apache Airflow version
     * that satisfies the alias and is supported in the given Cloud Composer
     * version.
     *
     * In all cases, the resolved image version is stored in the same field.
     *
     * See also [version
     * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
     * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
     * </pre>
     *
     * <code>string image_version = 1;</code>
     *
     * @param value The imageVersion to set.
     * @return This builder for chaining.
     */
    public Builder setImageVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the software running in the environment.
     * This encapsulates both the version of Cloud Composer functionality and the
     * version of Apache Airflow. It must match the regular expression
     * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
     * When used as input, the server also checks if the provided version is
     * supported and denies the request for an unsupported version.
     *
     * The Cloud Composer portion of the image version is a full
     * [semantic version](https://semver.org), or an alias in the form of major
     * version number or `latest`. When an alias is provided, the server replaces
     * it with the current Cloud Composer version that satisfies the alias.
     *
     * The Apache Airflow portion of the image version is a full semantic version
     * that points to one of the supported Apache Airflow versions, or an alias in
     * the form of only major or major.minor versions specified. When an alias is
     * provided, the server replaces it with the latest Apache Airflow version
     * that satisfies the alias and is supported in the given Cloud Composer
     * version.
     *
     * In all cases, the resolved image version is stored in the same field.
     *
     * See also [version
     * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
     * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
     * </pre>
     *
     * <code>string image_version = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageVersion() {
      imageVersion_ = getDefaultInstance().getImageVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the software running in the environment.
     * This encapsulates both the version of Cloud Composer functionality and the
     * version of Apache Airflow. It must match the regular expression
     * `composer-([0-9]+(&#92;.[0-9]+&#92;.[0-9]+(-preview&#92;.[0-9]+)?)?|latest)-airflow-([0-9]+(&#92;.[0-9]+(&#92;.[0-9]+)?)?)`.
     * When used as input, the server also checks if the provided version is
     * supported and denies the request for an unsupported version.
     *
     * The Cloud Composer portion of the image version is a full
     * [semantic version](https://semver.org), or an alias in the form of major
     * version number or `latest`. When an alias is provided, the server replaces
     * it with the current Cloud Composer version that satisfies the alias.
     *
     * The Apache Airflow portion of the image version is a full semantic version
     * that points to one of the supported Apache Airflow versions, or an alias in
     * the form of only major or major.minor versions specified. When an alias is
     * provided, the server replaces it with the latest Apache Airflow version
     * that satisfies the alias and is supported in the given Cloud Composer
     * version.
     *
     * In all cases, the resolved image version is stored in the same field.
     *
     * See also [version
     * list](/composer/docs/concepts/versioning/composer-versions) and [versioning
     * overview](/composer/docs/concepts/versioning/composer-versioning-overview).
     * </pre>
     *
     * <code>string image_version = 1;</code>
     *
     * @param value The bytes for imageVersion to set.
     * @return This builder for chaining.
     */
    public Builder setImageVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        airflowConfigOverrides_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAirflowConfigOverrides() {
      if (airflowConfigOverrides_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AirflowConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      return airflowConfigOverrides_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAirflowConfigOverrides() {
      if (airflowConfigOverrides_ == null) {
        airflowConfigOverrides_ =
            com.google.protobuf.MapField.newMapField(
                AirflowConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      if (!airflowConfigOverrides_.isMutable()) {
        airflowConfigOverrides_ = airflowConfigOverrides_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return airflowConfigOverrides_;
    }

    public int getAirflowConfigOverridesCount() {
      return internalGetAirflowConfigOverrides().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAirflowConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAirflowConfigOverrides().getMap().containsKey(key);
    }
    /** Use {@link #getAirflowConfigOverridesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAirflowConfigOverrides() {
      return getAirflowConfigOverridesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAirflowConfigOverridesMap() {
      return internalGetAirflowConfigOverrides().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAirflowConfigOverridesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAirflowConfigOverrides().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAirflowConfigOverridesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAirflowConfigOverrides().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAirflowConfigOverrides() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableAirflowConfigOverrides().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAirflowConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAirflowConfigOverrides().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAirflowConfigOverrides() {
      bitField0_ |= 0x00000002;
      return internalGetMutableAirflowConfigOverrides().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAirflowConfigOverrides(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAirflowConfigOverrides().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a
     * hyphen, for example "core-dags_are_paused_at_creation". Section names must
     * not contain hyphens ("-"), opening square brackets ("["),  or closing
     * square brackets ("]"). The property name must not be empty and must not
     * contain an equals sign ("=") or semicolon (";"). Section and property names
     * must not contain a period ("."). Apache Airflow configuration property
     * names must be written in
     * [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
     * contain any character, and can be written in any lower/upper case format.
     *
     * Certain Apache Airflow configuration property values are
     * [blocked](/composer/docs/concepts/airflow-configurations),
     * and cannot be overridden.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; airflow_config_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAirflowConfigOverrides(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAirflowConfigOverrides().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> pypiPackages_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetPypiPackages() {
      if (pypiPackages_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PypiPackagesDefaultEntryHolder.defaultEntry);
      }
      return pypiPackages_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutablePypiPackages() {
      if (pypiPackages_ == null) {
        pypiPackages_ =
            com.google.protobuf.MapField.newMapField(PypiPackagesDefaultEntryHolder.defaultEntry);
      }
      if (!pypiPackages_.isMutable()) {
        pypiPackages_ = pypiPackages_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return pypiPackages_;
    }

    public int getPypiPackagesCount() {
      return internalGetPypiPackages().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsPypiPackages(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPypiPackages().getMap().containsKey(key);
    }
    /** Use {@link #getPypiPackagesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getPypiPackages() {
      return getPypiPackagesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPypiPackagesMap() {
      return internalGetPypiPackages().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getPypiPackagesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetPypiPackages().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getPypiPackagesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetPypiPackages().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPypiPackages() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutablePypiPackages().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePypiPackages(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePypiPackages().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutablePypiPackages() {
      bitField0_ |= 0x00000004;
      return internalGetMutablePypiPackages().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putPypiPackages(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePypiPackages().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom Python Package Index (PyPI) packages to be installed in
     * the environment.
     *
     * Keys refer to the lowercase package name such as "numpy"
     * and values are the lowercase extras and version specifier such as
     * "==1.12.0", "[devel,gcp_api]", or "[devel]&gt;=1.8.2, &lt;1.9.2". To specify a
     * package without pinning it to a version specifier, use the empty string as
     * the value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; pypi_packages = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllPypiPackages(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutablePypiPackages().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> envVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvVariables() {
      if (envVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvVariablesDefaultEntryHolder.defaultEntry);
      }
      return envVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvVariables() {
      if (envVariables_ == null) {
        envVariables_ =
            com.google.protobuf.MapField.newMapField(EnvVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!envVariables_.isMutable()) {
        envVariables_ = envVariables_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return envVariables_;
    }

    public int getEnvVariablesCount() {
      return internalGetEnvVariables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsEnvVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvVariables().getMap().containsKey(key);
    }
    /** Use {@link #getEnvVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvVariables() {
      return getEnvVariablesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvVariablesMap() {
      return internalGetEnvVariables().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEnvVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getEnvVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvVariables() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableEnvVariables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeEnvVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvVariables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvVariables() {
      bitField0_ |= 0x00000008;
      return internalGetMutableEnvVariables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putEnvVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEnvVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional environment variables to provide to the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression
     * `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
     * software configuration overrides (they cannot match the regular expression
     * `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
     * following reserved names:
     *
     * * `AIRFLOW_HOME`
     * * `C_FORCE_ROOT`
     * * `CONTAINER_NAME`
     * * `DAGS_FOLDER`
     * * `GCP_PROJECT`
     * * `GCS_BUCKET`
     * * `GKE_CLUSTER_NAME`
     * * `SQL_DATABASE`
     * * `SQL_INSTANCE`
     * * `SQL_PASSWORD`
     * * `SQL_PROJECT`
     * * `SQL_REGION`
     * * `SQL_USER`
     * </pre>
     *
     * <code>map&lt;string, string&gt; env_variables = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllEnvVariables(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object pythonVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The major version of Python used to run the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
     * updated.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * Python major version 3.
     * </pre>
     *
     * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pythonVersion.
     */
    public java.lang.String getPythonVersion() {
      java.lang.Object ref = pythonVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pythonVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The major version of Python used to run the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
     * updated.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * Python major version 3.
     * </pre>
     *
     * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pythonVersion.
     */
    public com.google.protobuf.ByteString getPythonVersionBytes() {
      java.lang.Object ref = pythonVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pythonVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The major version of Python used to run the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
     * updated.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * Python major version 3.
     * </pre>
     *
     * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pythonVersion to set.
     * @return This builder for chaining.
     */
    public Builder setPythonVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pythonVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The major version of Python used to run the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
     * updated.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * Python major version 3.
     * </pre>
     *
     * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPythonVersion() {
      pythonVersion_ = getDefaultInstance().getPythonVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The major version of Python used to run the Apache Airflow
     * scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
     * updated.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * Python major version 3.
     * </pre>
     *
     * <code>string python_version = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pythonVersion to set.
     * @return This builder for chaining.
     */
    public Builder setPythonVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pythonVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int schedulerCount_;
    /**
     *
     *
     * <pre>
     * Optional. The number of schedulers for Airflow.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-2.*.*.
     * </pre>
     *
     * <code>int32 scheduler_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The schedulerCount.
     */
    @java.lang.Override
    public int getSchedulerCount() {
      return schedulerCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of schedulers for Airflow.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-2.*.*.
     * </pre>
     *
     * <code>int32 scheduler_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The schedulerCount to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulerCount(int value) {

      schedulerCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of schedulers for Airflow.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-2.*.*.
     * </pre>
     *
     * <code>int32 scheduler_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedulerCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      schedulerCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
        cloudDataLineageIntegration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration,
            com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .CloudDataLineageIntegrationOrBuilder>
        cloudDataLineageIntegrationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cloudDataLineageIntegration field is set.
     */
    public boolean hasCloudDataLineageIntegration() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudDataLineageIntegration.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
        getCloudDataLineageIntegration() {
      if (cloudDataLineageIntegrationBuilder_ == null) {
        return cloudDataLineageIntegration_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
                .getDefaultInstance()
            : cloudDataLineageIntegration_;
      } else {
        return cloudDataLineageIntegrationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudDataLineageIntegration(
        com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration value) {
      if (cloudDataLineageIntegrationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudDataLineageIntegration_ = value;
      } else {
        cloudDataLineageIntegrationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudDataLineageIntegration(
        com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration.Builder
            builderForValue) {
      if (cloudDataLineageIntegrationBuilder_ == null) {
        cloudDataLineageIntegration_ = builderForValue.build();
      } else {
        cloudDataLineageIntegrationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCloudDataLineageIntegration(
        com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration value) {
      if (cloudDataLineageIntegrationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && cloudDataLineageIntegration_ != null
            && cloudDataLineageIntegration_
                != com.google.cloud.orchestration.airflow.service.v1beta1
                    .CloudDataLineageIntegration.getDefaultInstance()) {
          getCloudDataLineageIntegrationBuilder().mergeFrom(value);
        } else {
          cloudDataLineageIntegration_ = value;
        }
      } else {
        cloudDataLineageIntegrationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCloudDataLineageIntegration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      cloudDataLineageIntegration_ = null;
      if (cloudDataLineageIntegrationBuilder_ != null) {
        cloudDataLineageIntegrationBuilder_.dispose();
        cloudDataLineageIntegrationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
            .Builder
        getCloudDataLineageIntegrationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCloudDataLineageIntegrationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1
            .CloudDataLineageIntegrationOrBuilder
        getCloudDataLineageIntegrationOrBuilder() {
      if (cloudDataLineageIntegrationBuilder_ != null) {
        return cloudDataLineageIntegrationBuilder_.getMessageOrBuilder();
      } else {
        return cloudDataLineageIntegration_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
                .getDefaultInstance()
            : cloudDataLineageIntegration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for Cloud Data Lineage integration.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration cloud_data_lineage_integration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration,
            com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .CloudDataLineageIntegrationOrBuilder>
        getCloudDataLineageIntegrationFieldBuilder() {
      if (cloudDataLineageIntegrationBuilder_ == null) {
        cloudDataLineageIntegrationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration,
                com.google.cloud.orchestration.airflow.service.v1beta1.CloudDataLineageIntegration
                    .Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .CloudDataLineageIntegrationOrBuilder>(
                getCloudDataLineageIntegration(), getParentForChildren(), isClean());
        cloudDataLineageIntegration_ = null;
      }
      return cloudDataLineageIntegrationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SoftwareConfig> PARSER =
      new com.google.protobuf.AbstractParser<SoftwareConfig>() {
        @java.lang.Override
        public SoftwareConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SoftwareConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SoftwareConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
