/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Update an environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest}
 */
public final class UpdateEnvironmentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest)
    UpdateEnvironmentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateEnvironmentRequest.newBuilder() to construct.
  private UpdateEnvironmentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateEnvironmentRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateEnvironmentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_UpdateEnvironmentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_UpdateEnvironmentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest.Builder
                .class);
  }

  public static final int NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The relative resource name of the environment to update, in the form:
   * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of the environment to update, in the form:
   * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 1;
  private com.google.cloud.orchestration.airflow.service.v1beta1.Environment environment_;
  /**
   *
   *
   * <pre>
   * A patch environment. Fields specified by the `updateMask` will be copied
   * from the patch environment into the environment under update.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
   *
   * @return Whether the environment field is set.
   */
  @java.lang.Override
  public boolean hasEnvironment() {
    return environment_ != null;
  }
  /**
   *
   *
   * <pre>
   * A patch environment. Fields specified by the `updateMask` will be copied
   * from the patch environment into the environment under update.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.Environment getEnvironment() {
    return environment_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.Environment.getDefaultInstance()
        : environment_;
  }
  /**
   *
   *
   * <pre>
   * A patch environment. Fields specified by the `updateMask` will be copied
   * from the patch environment into the environment under update.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentOrBuilder
      getEnvironmentOrBuilder() {
    return environment_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.Environment.getDefaultInstance()
        : environment_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. A comma-separated list of paths, relative to `Environment`, of
   * fields to update.
   * For example, to set the version of scikit-learn to install in the
   * environment to 0.19.0 and to remove an existing installation of
   * argparse, the `updateMask` parameter would include the following two
   * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
   * "config.softwareConfig.pypiPackages.argparse". The included patch
   * environment would specify the scikit-learn version as follows:
   *
   *     {
   *       "config":{
   *         "softwareConfig":{
   *           "pypiPackages":{
   *             "scikit-learn":"==0.19.0"
   *           }
   *         }
   *       }
   *     }
   *
   * Note that in the above example, any existing PyPI packages
   * other than scikit-learn and argparse will be unaffected.
   *
   * Only one update type may be included in a single request's `updateMask`.
   * For example, one cannot update both the PyPI packages and
   * labels in the same request. However, it is possible to update multiple
   * members of a map field simultaneously in the same request. For example,
   * to set the labels "label1" and "label2" while clearing "label3" (assuming
   * it already exists), one can
   * provide the paths "labels.label1", "labels.label2", and "labels.label3"
   * and populate the patch environment as follows:
   *
   *     {
   *       "labels":{
   *         "label1":"new-label1-value"
   *         "label2":"new-label2-value"
   *       }
   *     }
   *
   * Note that in the above example, any existing labels that are not
   * included in the `updateMask` will be unaffected.
   *
   * It is also possible to replace an entire map field by providing the
   * map field's path in the `updateMask`. The new value of the field will
   * be that which is provided in the patch environment. For example, to
   * delete all pre-existing user-specified PyPI packages and
   * install botocore at version 1.7.14, the `updateMask` would contain
   * the path "config.softwareConfig.pypiPackages", and
   * the patch environment would be the following:
   *
   *     {
   *       "config":{
   *         "softwareConfig":{
   *           "pypiPackages":{
   *             "botocore":"==1.7.14"
   *           }
   *         }
   *       }
   *     }
   *
   * **Note:** Only the following fields can be updated:
   *
   * * `config.softwareConfig.pypiPackages`
   *     * Replace all custom custom PyPI packages. If a replacement
   *       package map is not included in `environment`, all custom
   *       PyPI packages are cleared. It is an error to provide both
   *       this mask and a mask specifying an individual package.
   * * `config.softwareConfig.pypiPackages.`packagename
   *     * Update the custom PyPI package *packagename*,
   *       preserving other packages. To delete the package, include it in
   *       `updateMask`, and omit the mapping for it in
   *       `environment.config.softwareConfig.pypiPackages`. It is an error
   *       to provide both a mask of this form and the
   *       `config.softwareConfig.pypiPackages` mask.
   * * `labels`
   *     * Replace all environment labels. If a replacement labels map is not
   *       included in `environment`, all labels are cleared. It is an error to
   *       provide both this mask and a mask specifying one or more individual
   *       labels.
   * * `labels.`labelName
   *     * Set the label named *labelName*, while preserving other
   *       labels. To delete the label, include it in `updateMask` and omit its
   *       mapping in `environment.labels`. It is an error to provide both a
   *       mask of this form and the `labels` mask.
   * * `config.nodeCount`
   *     * Horizontally scale the number of nodes in the environment. An integer
   *       greater than or equal to 3 must be provided in the `config.nodeCount`
   *       field. Supported for Cloud Composer environments in versions
   *       composer-1.*.*-airflow-*.*.*.
   * * `config.webServerNetworkAccessControl`
   *     * Replace the environment's current WebServerNetworkAccessControl.
   * * `config.softwareConfig.airflowConfigOverrides`
   *     * Replace all Apache Airflow config overrides. If a replacement config
   *       overrides map is not included in `environment`, all config overrides
   *       are cleared.
   *       It is an error to provide both this mask and a mask specifying one or
   *       more individual config overrides.
   * * `config.softwareConfig.airflowConfigOverrides.`section-name
   *     * Override the Apache Airflow config property *name* in the
   *       section named *section*, preserving other properties. To
   *       delete the property override, include it in `updateMask` and omit its
   *       mapping in
   *       `environment.config.softwareConfig.airflowConfigOverrides`.
   *       It is an error to provide both a mask of this form and the
   *       `config.softwareConfig.airflowConfigOverrides` mask.
   * * `config.softwareConfig.envVariables`
   *     * Replace all environment variables. If a replacement environment
   *       variable map is not included in `environment`, all custom environment
   *       variables are cleared.
   * * `config.softwareConfig.imageVersion`
   *     * Upgrade the version of the environment in-place. Refer to
   *       `SoftwareConfig.image_version` for information on how to format the
   *       new image version. Additionally, the new image version cannot effect
   *       a version downgrade, and must match the current image version's
   *       Composer and Airflow major versions. Consult the [Cloud Composer
   *       version list](/composer/docs/concepts/versioning/composer-versions)
   *       for valid values.
   * * `config.softwareConfig.schedulerCount`
   *     * Horizontally scale the number of schedulers in Airflow. A positive
   *       integer not greater than the number of nodes must be provided in the
   *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
   *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
   * * `config.softwareConfig.cloudDataLineageIntegration`
   *     * Configuration for Cloud Data Lineage integration.
   * * `config.databaseConfig.machineType`
   *     * Cloud SQL machine type used by Airflow database.
   *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
   *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
   *       environments in versions composer-1.*.*-airflow-*.*.*.
   * * `config.webServerConfig.machineType`
   *     * Machine type on which Airflow web server is running.
   *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
   *       or composer-n1-webserver-8. Supported for Cloud Composer environments
   *       in versions composer-1.*.*-airflow-*.*.*.
   * * `config.maintenanceWindow`
   *     * Maintenance window during which Cloud Composer components may be
   *       under maintenance.
   * * `config.workloadsConfig`
   *     * The workloads configuration settings for the GKE cluster associated
   *       with the Cloud Composer environment. Supported for Cloud Composer
   *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
   * * `config.environmentSize`
   *     * The size of the Cloud Composer environment. Supported for Cloud
   *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
   *       newer.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. A comma-separated list of paths, relative to `Environment`, of
   * fields to update.
   * For example, to set the version of scikit-learn to install in the
   * environment to 0.19.0 and to remove an existing installation of
   * argparse, the `updateMask` parameter would include the following two
   * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
   * "config.softwareConfig.pypiPackages.argparse". The included patch
   * environment would specify the scikit-learn version as follows:
   *
   *     {
   *       "config":{
   *         "softwareConfig":{
   *           "pypiPackages":{
   *             "scikit-learn":"==0.19.0"
   *           }
   *         }
   *       }
   *     }
   *
   * Note that in the above example, any existing PyPI packages
   * other than scikit-learn and argparse will be unaffected.
   *
   * Only one update type may be included in a single request's `updateMask`.
   * For example, one cannot update both the PyPI packages and
   * labels in the same request. However, it is possible to update multiple
   * members of a map field simultaneously in the same request. For example,
   * to set the labels "label1" and "label2" while clearing "label3" (assuming
   * it already exists), one can
   * provide the paths "labels.label1", "labels.label2", and "labels.label3"
   * and populate the patch environment as follows:
   *
   *     {
   *       "labels":{
   *         "label1":"new-label1-value"
   *         "label2":"new-label2-value"
   *       }
   *     }
   *
   * Note that in the above example, any existing labels that are not
   * included in the `updateMask` will be unaffected.
   *
   * It is also possible to replace an entire map field by providing the
   * map field's path in the `updateMask`. The new value of the field will
   * be that which is provided in the patch environment. For example, to
   * delete all pre-existing user-specified PyPI packages and
   * install botocore at version 1.7.14, the `updateMask` would contain
   * the path "config.softwareConfig.pypiPackages", and
   * the patch environment would be the following:
   *
   *     {
   *       "config":{
   *         "softwareConfig":{
   *           "pypiPackages":{
   *             "botocore":"==1.7.14"
   *           }
   *         }
   *       }
   *     }
   *
   * **Note:** Only the following fields can be updated:
   *
   * * `config.softwareConfig.pypiPackages`
   *     * Replace all custom custom PyPI packages. If a replacement
   *       package map is not included in `environment`, all custom
   *       PyPI packages are cleared. It is an error to provide both
   *       this mask and a mask specifying an individual package.
   * * `config.softwareConfig.pypiPackages.`packagename
   *     * Update the custom PyPI package *packagename*,
   *       preserving other packages. To delete the package, include it in
   *       `updateMask`, and omit the mapping for it in
   *       `environment.config.softwareConfig.pypiPackages`. It is an error
   *       to provide both a mask of this form and the
   *       `config.softwareConfig.pypiPackages` mask.
   * * `labels`
   *     * Replace all environment labels. If a replacement labels map is not
   *       included in `environment`, all labels are cleared. It is an error to
   *       provide both this mask and a mask specifying one or more individual
   *       labels.
   * * `labels.`labelName
   *     * Set the label named *labelName*, while preserving other
   *       labels. To delete the label, include it in `updateMask` and omit its
   *       mapping in `environment.labels`. It is an error to provide both a
   *       mask of this form and the `labels` mask.
   * * `config.nodeCount`
   *     * Horizontally scale the number of nodes in the environment. An integer
   *       greater than or equal to 3 must be provided in the `config.nodeCount`
   *       field. Supported for Cloud Composer environments in versions
   *       composer-1.*.*-airflow-*.*.*.
   * * `config.webServerNetworkAccessControl`
   *     * Replace the environment's current WebServerNetworkAccessControl.
   * * `config.softwareConfig.airflowConfigOverrides`
   *     * Replace all Apache Airflow config overrides. If a replacement config
   *       overrides map is not included in `environment`, all config overrides
   *       are cleared.
   *       It is an error to provide both this mask and a mask specifying one or
   *       more individual config overrides.
   * * `config.softwareConfig.airflowConfigOverrides.`section-name
   *     * Override the Apache Airflow config property *name* in the
   *       section named *section*, preserving other properties. To
   *       delete the property override, include it in `updateMask` and omit its
   *       mapping in
   *       `environment.config.softwareConfig.airflowConfigOverrides`.
   *       It is an error to provide both a mask of this form and the
   *       `config.softwareConfig.airflowConfigOverrides` mask.
   * * `config.softwareConfig.envVariables`
   *     * Replace all environment variables. If a replacement environment
   *       variable map is not included in `environment`, all custom environment
   *       variables are cleared.
   * * `config.softwareConfig.imageVersion`
   *     * Upgrade the version of the environment in-place. Refer to
   *       `SoftwareConfig.image_version` for information on how to format the
   *       new image version. Additionally, the new image version cannot effect
   *       a version downgrade, and must match the current image version's
   *       Composer and Airflow major versions. Consult the [Cloud Composer
   *       version list](/composer/docs/concepts/versioning/composer-versions)
   *       for valid values.
   * * `config.softwareConfig.schedulerCount`
   *     * Horizontally scale the number of schedulers in Airflow. A positive
   *       integer not greater than the number of nodes must be provided in the
   *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
   *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
   * * `config.softwareConfig.cloudDataLineageIntegration`
   *     * Configuration for Cloud Data Lineage integration.
   * * `config.databaseConfig.machineType`
   *     * Cloud SQL machine type used by Airflow database.
   *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
   *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
   *       environments in versions composer-1.*.*-airflow-*.*.*.
   * * `config.webServerConfig.machineType`
   *     * Machine type on which Airflow web server is running.
   *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
   *       or composer-n1-webserver-8. Supported for Cloud Composer environments
   *       in versions composer-1.*.*-airflow-*.*.*.
   * * `config.maintenanceWindow`
   *     * Maintenance window during which Cloud Composer components may be
   *       under maintenance.
   * * `config.workloadsConfig`
   *     * The workloads configuration settings for the GKE cluster associated
   *       with the Cloud Composer environment. Supported for Cloud Composer
   *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
   * * `config.environmentSize`
   *     * The size of the Cloud Composer environment. Supported for Cloud
   *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
   *       newer.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. A comma-separated list of paths, relative to `Environment`, of
   * fields to update.
   * For example, to set the version of scikit-learn to install in the
   * environment to 0.19.0 and to remove an existing installation of
   * argparse, the `updateMask` parameter would include the following two
   * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
   * "config.softwareConfig.pypiPackages.argparse". The included patch
   * environment would specify the scikit-learn version as follows:
   *
   *     {
   *       "config":{
   *         "softwareConfig":{
   *           "pypiPackages":{
   *             "scikit-learn":"==0.19.0"
   *           }
   *         }
   *       }
   *     }
   *
   * Note that in the above example, any existing PyPI packages
   * other than scikit-learn and argparse will be unaffected.
   *
   * Only one update type may be included in a single request's `updateMask`.
   * For example, one cannot update both the PyPI packages and
   * labels in the same request. However, it is possible to update multiple
   * members of a map field simultaneously in the same request. For example,
   * to set the labels "label1" and "label2" while clearing "label3" (assuming
   * it already exists), one can
   * provide the paths "labels.label1", "labels.label2", and "labels.label3"
   * and populate the patch environment as follows:
   *
   *     {
   *       "labels":{
   *         "label1":"new-label1-value"
   *         "label2":"new-label2-value"
   *       }
   *     }
   *
   * Note that in the above example, any existing labels that are not
   * included in the `updateMask` will be unaffected.
   *
   * It is also possible to replace an entire map field by providing the
   * map field's path in the `updateMask`. The new value of the field will
   * be that which is provided in the patch environment. For example, to
   * delete all pre-existing user-specified PyPI packages and
   * install botocore at version 1.7.14, the `updateMask` would contain
   * the path "config.softwareConfig.pypiPackages", and
   * the patch environment would be the following:
   *
   *     {
   *       "config":{
   *         "softwareConfig":{
   *           "pypiPackages":{
   *             "botocore":"==1.7.14"
   *           }
   *         }
   *       }
   *     }
   *
   * **Note:** Only the following fields can be updated:
   *
   * * `config.softwareConfig.pypiPackages`
   *     * Replace all custom custom PyPI packages. If a replacement
   *       package map is not included in `environment`, all custom
   *       PyPI packages are cleared. It is an error to provide both
   *       this mask and a mask specifying an individual package.
   * * `config.softwareConfig.pypiPackages.`packagename
   *     * Update the custom PyPI package *packagename*,
   *       preserving other packages. To delete the package, include it in
   *       `updateMask`, and omit the mapping for it in
   *       `environment.config.softwareConfig.pypiPackages`. It is an error
   *       to provide both a mask of this form and the
   *       `config.softwareConfig.pypiPackages` mask.
   * * `labels`
   *     * Replace all environment labels. If a replacement labels map is not
   *       included in `environment`, all labels are cleared. It is an error to
   *       provide both this mask and a mask specifying one or more individual
   *       labels.
   * * `labels.`labelName
   *     * Set the label named *labelName*, while preserving other
   *       labels. To delete the label, include it in `updateMask` and omit its
   *       mapping in `environment.labels`. It is an error to provide both a
   *       mask of this form and the `labels` mask.
   * * `config.nodeCount`
   *     * Horizontally scale the number of nodes in the environment. An integer
   *       greater than or equal to 3 must be provided in the `config.nodeCount`
   *       field. Supported for Cloud Composer environments in versions
   *       composer-1.*.*-airflow-*.*.*.
   * * `config.webServerNetworkAccessControl`
   *     * Replace the environment's current WebServerNetworkAccessControl.
   * * `config.softwareConfig.airflowConfigOverrides`
   *     * Replace all Apache Airflow config overrides. If a replacement config
   *       overrides map is not included in `environment`, all config overrides
   *       are cleared.
   *       It is an error to provide both this mask and a mask specifying one or
   *       more individual config overrides.
   * * `config.softwareConfig.airflowConfigOverrides.`section-name
   *     * Override the Apache Airflow config property *name* in the
   *       section named *section*, preserving other properties. To
   *       delete the property override, include it in `updateMask` and omit its
   *       mapping in
   *       `environment.config.softwareConfig.airflowConfigOverrides`.
   *       It is an error to provide both a mask of this form and the
   *       `config.softwareConfig.airflowConfigOverrides` mask.
   * * `config.softwareConfig.envVariables`
   *     * Replace all environment variables. If a replacement environment
   *       variable map is not included in `environment`, all custom environment
   *       variables are cleared.
   * * `config.softwareConfig.imageVersion`
   *     * Upgrade the version of the environment in-place. Refer to
   *       `SoftwareConfig.image_version` for information on how to format the
   *       new image version. Additionally, the new image version cannot effect
   *       a version downgrade, and must match the current image version's
   *       Composer and Airflow major versions. Consult the [Cloud Composer
   *       version list](/composer/docs/concepts/versioning/composer-versions)
   *       for valid values.
   * * `config.softwareConfig.schedulerCount`
   *     * Horizontally scale the number of schedulers in Airflow. A positive
   *       integer not greater than the number of nodes must be provided in the
   *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
   *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
   * * `config.softwareConfig.cloudDataLineageIntegration`
   *     * Configuration for Cloud Data Lineage integration.
   * * `config.databaseConfig.machineType`
   *     * Cloud SQL machine type used by Airflow database.
   *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
   *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
   *       environments in versions composer-1.*.*-airflow-*.*.*.
   * * `config.webServerConfig.machineType`
   *     * Machine type on which Airflow web server is running.
   *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
   *       or composer-n1-webserver-8. Supported for Cloud Composer environments
   *       in versions composer-1.*.*-airflow-*.*.*.
   * * `config.maintenanceWindow`
   *     * Maintenance window during which Cloud Composer components may be
   *       under maintenance.
   * * `config.workloadsConfig`
   *     * The workloads configuration settings for the GKE cluster associated
   *       with the Cloud Composer environment. Supported for Cloud Composer
   *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
   * * `config.environmentSize`
   *     * The size of the Cloud Composer environment. Supported for Cloud
   *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
   *       newer.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (environment_ != null) {
      output.writeMessage(1, getEnvironment());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (updateMask_ != null) {
      output.writeMessage(3, getUpdateMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (environment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEnvironment());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEnvironment() != other.hasEnvironment()) return false;
    if (hasEnvironment()) {
      if (!getEnvironment().equals(other.getEnvironment())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEnvironment()) {
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironment().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Update an environment.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest)
      com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_UpdateEnvironmentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_UpdateEnvironmentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_UpdateEnvironmentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
        buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.environment_ =
            environmentBuilder_ == null ? environment_ : environmentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
              .getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEnvironment()) {
        mergeEnvironment(other.getEnvironment());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEnvironmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of the environment to update, in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the environment to update, in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the environment to update, in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the environment to update, in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the environment to update, in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.Environment environment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.Environment,
            com.google.cloud.orchestration.airflow.service.v1beta1.Environment.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentOrBuilder>
        environmentBuilder_;
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     *
     * @return Whether the environment field is set.
     */
    public boolean hasEnvironment() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     *
     * @return The environment.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.Environment getEnvironment() {
      if (environmentBuilder_ == null) {
        return environment_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.Environment
                .getDefaultInstance()
            : environment_;
      } else {
        return environmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    public Builder setEnvironment(
        com.google.cloud.orchestration.airflow.service.v1beta1.Environment value) {
      if (environmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environment_ = value;
      } else {
        environmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    public Builder setEnvironment(
        com.google.cloud.orchestration.airflow.service.v1beta1.Environment.Builder
            builderForValue) {
      if (environmentBuilder_ == null) {
        environment_ = builderForValue.build();
      } else {
        environmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    public Builder mergeEnvironment(
        com.google.cloud.orchestration.airflow.service.v1beta1.Environment value) {
      if (environmentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && environment_ != null
            && environment_
                != com.google.cloud.orchestration.airflow.service.v1beta1.Environment
                    .getDefaultInstance()) {
          getEnvironmentBuilder().mergeFrom(value);
        } else {
          environment_ = value;
        }
      } else {
        environmentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    public Builder clearEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000002);
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.Environment.Builder
        getEnvironmentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEnvironmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentOrBuilder
        getEnvironmentOrBuilder() {
      if (environmentBuilder_ != null) {
        return environmentBuilder_.getMessageOrBuilder();
      } else {
        return environment_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.Environment
                .getDefaultInstance()
            : environment_;
      }
    }
    /**
     *
     *
     * <pre>
     * A patch environment. Fields specified by the `updateMask` will be copied
     * from the patch environment into the environment under update.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.Environment environment = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.Environment,
            com.google.cloud.orchestration.airflow.service.v1beta1.Environment.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentOrBuilder>
        getEnvironmentFieldBuilder() {
      if (environmentBuilder_ == null) {
        environmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.Environment,
                com.google.cloud.orchestration.airflow.service.v1beta1.Environment.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentOrBuilder>(
                getEnvironment(), getParentForChildren(), isClean());
        environment_ = null;
      }
      return environmentBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A comma-separated list of paths, relative to `Environment`, of
     * fields to update.
     * For example, to set the version of scikit-learn to install in the
     * environment to 0.19.0 and to remove an existing installation of
     * argparse, the `updateMask` parameter would include the following two
     * `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
     * "config.softwareConfig.pypiPackages.argparse". The included patch
     * environment would specify the scikit-learn version as follows:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "scikit-learn":"==0.19.0"
     *           }
     *         }
     *       }
     *     }
     *
     * Note that in the above example, any existing PyPI packages
     * other than scikit-learn and argparse will be unaffected.
     *
     * Only one update type may be included in a single request's `updateMask`.
     * For example, one cannot update both the PyPI packages and
     * labels in the same request. However, it is possible to update multiple
     * members of a map field simultaneously in the same request. For example,
     * to set the labels "label1" and "label2" while clearing "label3" (assuming
     * it already exists), one can
     * provide the paths "labels.label1", "labels.label2", and "labels.label3"
     * and populate the patch environment as follows:
     *
     *     {
     *       "labels":{
     *         "label1":"new-label1-value"
     *         "label2":"new-label2-value"
     *       }
     *     }
     *
     * Note that in the above example, any existing labels that are not
     * included in the `updateMask` will be unaffected.
     *
     * It is also possible to replace an entire map field by providing the
     * map field's path in the `updateMask`. The new value of the field will
     * be that which is provided in the patch environment. For example, to
     * delete all pre-existing user-specified PyPI packages and
     * install botocore at version 1.7.14, the `updateMask` would contain
     * the path "config.softwareConfig.pypiPackages", and
     * the patch environment would be the following:
     *
     *     {
     *       "config":{
     *         "softwareConfig":{
     *           "pypiPackages":{
     *             "botocore":"==1.7.14"
     *           }
     *         }
     *       }
     *     }
     *
     * **Note:** Only the following fields can be updated:
     *
     * * `config.softwareConfig.pypiPackages`
     *     * Replace all custom custom PyPI packages. If a replacement
     *       package map is not included in `environment`, all custom
     *       PyPI packages are cleared. It is an error to provide both
     *       this mask and a mask specifying an individual package.
     * * `config.softwareConfig.pypiPackages.`packagename
     *     * Update the custom PyPI package *packagename*,
     *       preserving other packages. To delete the package, include it in
     *       `updateMask`, and omit the mapping for it in
     *       `environment.config.softwareConfig.pypiPackages`. It is an error
     *       to provide both a mask of this form and the
     *       `config.softwareConfig.pypiPackages` mask.
     * * `labels`
     *     * Replace all environment labels. If a replacement labels map is not
     *       included in `environment`, all labels are cleared. It is an error to
     *       provide both this mask and a mask specifying one or more individual
     *       labels.
     * * `labels.`labelName
     *     * Set the label named *labelName*, while preserving other
     *       labels. To delete the label, include it in `updateMask` and omit its
     *       mapping in `environment.labels`. It is an error to provide both a
     *       mask of this form and the `labels` mask.
     * * `config.nodeCount`
     *     * Horizontally scale the number of nodes in the environment. An integer
     *       greater than or equal to 3 must be provided in the `config.nodeCount`
     *       field. Supported for Cloud Composer environments in versions
     *       composer-1.*.*-airflow-*.*.*.
     * * `config.webServerNetworkAccessControl`
     *     * Replace the environment's current WebServerNetworkAccessControl.
     * * `config.softwareConfig.airflowConfigOverrides`
     *     * Replace all Apache Airflow config overrides. If a replacement config
     *       overrides map is not included in `environment`, all config overrides
     *       are cleared.
     *       It is an error to provide both this mask and a mask specifying one or
     *       more individual config overrides.
     * * `config.softwareConfig.airflowConfigOverrides.`section-name
     *     * Override the Apache Airflow config property *name* in the
     *       section named *section*, preserving other properties. To
     *       delete the property override, include it in `updateMask` and omit its
     *       mapping in
     *       `environment.config.softwareConfig.airflowConfigOverrides`.
     *       It is an error to provide both a mask of this form and the
     *       `config.softwareConfig.airflowConfigOverrides` mask.
     * * `config.softwareConfig.envVariables`
     *     * Replace all environment variables. If a replacement environment
     *       variable map is not included in `environment`, all custom environment
     *       variables are cleared.
     * * `config.softwareConfig.imageVersion`
     *     * Upgrade the version of the environment in-place. Refer to
     *       `SoftwareConfig.image_version` for information on how to format the
     *       new image version. Additionally, the new image version cannot effect
     *       a version downgrade, and must match the current image version's
     *       Composer and Airflow major versions. Consult the [Cloud Composer
     *       version list](/composer/docs/concepts/versioning/composer-versions)
     *       for valid values.
     * * `config.softwareConfig.schedulerCount`
     *     * Horizontally scale the number of schedulers in Airflow. A positive
     *       integer not greater than the number of nodes must be provided in the
     *       `config.softwareConfig.schedulerCount` field. Supported for Cloud
     *       Composer environments in versions composer-1.*.*-airflow-2.*.*.
     * * `config.softwareConfig.cloudDataLineageIntegration`
     *     * Configuration for Cloud Data Lineage integration.
     * * `config.databaseConfig.machineType`
     *     * Cloud SQL machine type used by Airflow database.
     *       It has to be one of: db-n1-standard-2, db-n1-standard-4,
     *       db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
     *       environments in versions composer-1.*.*-airflow-*.*.*.
     * * `config.webServerConfig.machineType`
     *     * Machine type on which Airflow web server is running.
     *       It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
     *       or composer-n1-webserver-8. Supported for Cloud Composer environments
     *       in versions composer-1.*.*-airflow-*.*.*.
     * * `config.maintenanceWindow`
     *     * Maintenance window during which Cloud Composer components may be
     *       under maintenance.
     * * `config.workloadsConfig`
     *     * The workloads configuration settings for the GKE cluster associated
     *       with the Cloud Composer environment. Supported for Cloud Composer
     *       environments in versions composer-2.*.*-airflow-*.*.* and newer.
     * * `config.environmentSize`
     *     * The size of the Cloud Composer environment. Supported for Cloud
     *       Composer environments in versions composer-2.*.*-airflow-*.*.* and
     *       newer.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1
          .UpdateEnvironmentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateEnvironmentRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateEnvironmentRequest>() {
        @java.lang.Override
        public UpdateEnvironmentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateEnvironmentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateEnvironmentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
