/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration information for an environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig}
 */
public final class EnvironmentConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig)
    EnvironmentConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EnvironmentConfig.newBuilder() to construct.
  private EnvironmentConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EnvironmentConfig() {
    gkeCluster_ = "";
    dagGcsPrefix_ = "";
    airflowUri_ = "";
    airflowByoidUri_ = "";
    environmentSize_ = 0;
    resilienceMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EnvironmentConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_EnvironmentConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_EnvironmentConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The size of the Cloud Composer environment.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize}
   */
  public enum EnvironmentSize implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The size of the environment is unspecified.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_UNSPECIFIED = 0;</code>
     */
    ENVIRONMENT_SIZE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The environment size is small.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_SMALL = 1;</code>
     */
    ENVIRONMENT_SIZE_SMALL(1),
    /**
     *
     *
     * <pre>
     * The environment size is medium.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_MEDIUM = 2;</code>
     */
    ENVIRONMENT_SIZE_MEDIUM(2),
    /**
     *
     *
     * <pre>
     * The environment size is large.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_LARGE = 3;</code>
     */
    ENVIRONMENT_SIZE_LARGE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The size of the environment is unspecified.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_UNSPECIFIED = 0;</code>
     */
    public static final int ENVIRONMENT_SIZE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The environment size is small.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_SMALL = 1;</code>
     */
    public static final int ENVIRONMENT_SIZE_SMALL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The environment size is medium.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_MEDIUM = 2;</code>
     */
    public static final int ENVIRONMENT_SIZE_MEDIUM_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The environment size is large.
     * </pre>
     *
     * <code>ENVIRONMENT_SIZE_LARGE = 3;</code>
     */
    public static final int ENVIRONMENT_SIZE_LARGE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnvironmentSize valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EnvironmentSize forNumber(int value) {
      switch (value) {
        case 0:
          return ENVIRONMENT_SIZE_UNSPECIFIED;
        case 1:
          return ENVIRONMENT_SIZE_SMALL;
        case 2:
          return ENVIRONMENT_SIZE_MEDIUM;
        case 3:
          return ENVIRONMENT_SIZE_LARGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EnvironmentSize> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EnvironmentSize>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EnvironmentSize>() {
              public EnvironmentSize findValueByNumber(int number) {
                return EnvironmentSize.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EnvironmentSize[] VALUES = values();

    public static EnvironmentSize valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EnvironmentSize(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize)
  }

  /**
   *
   *
   * <pre>
   * Resilience mode of the Cloud Composer Environment.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode}
   */
  public enum ResilienceMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default mode doesn't change environment parameters.
     * </pre>
     *
     * <code>RESILIENCE_MODE_UNSPECIFIED = 0;</code>
     */
    RESILIENCE_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Enabled High Resilience mode, including Cloud SQL HA.
     * </pre>
     *
     * <code>HIGH_RESILIENCE = 1;</code>
     */
    HIGH_RESILIENCE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default mode doesn't change environment parameters.
     * </pre>
     *
     * <code>RESILIENCE_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int RESILIENCE_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Enabled High Resilience mode, including Cloud SQL HA.
     * </pre>
     *
     * <code>HIGH_RESILIENCE = 1;</code>
     */
    public static final int HIGH_RESILIENCE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResilienceMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResilienceMode forNumber(int value) {
      switch (value) {
        case 0:
          return RESILIENCE_MODE_UNSPECIFIED;
        case 1:
          return HIGH_RESILIENCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResilienceMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResilienceMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResilienceMode>() {
          public ResilienceMode findValueByNumber(int number) {
            return ResilienceMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
          .getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ResilienceMode[] VALUES = values();

    public static ResilienceMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResilienceMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode)
  }

  public static final int GKE_CLUSTER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gkeCluster_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes Engine cluster used to run this environment.
   * </pre>
   *
   * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The gkeCluster.
   */
  @java.lang.Override
  public java.lang.String getGkeCluster() {
    java.lang.Object ref = gkeCluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gkeCluster_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Kubernetes Engine cluster used to run this environment.
   * </pre>
   *
   * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for gkeCluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGkeClusterBytes() {
    java.lang.Object ref = gkeCluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gkeCluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DAG_GCS_PREFIX_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dagGcsPrefix_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Storage prefix of the DAGs for this environment.
   * Although Cloud Storage objects reside in a flat namespace, a hierarchical
   * file tree can be simulated using "/"-delimited object name prefixes. DAG
   * objects for this environment reside in a simulated directory with the given
   * prefix.
   * </pre>
   *
   * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The dagGcsPrefix.
   */
  @java.lang.Override
  public java.lang.String getDagGcsPrefix() {
    java.lang.Object ref = dagGcsPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dagGcsPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Cloud Storage prefix of the DAGs for this environment.
   * Although Cloud Storage objects reside in a flat namespace, a hierarchical
   * file tree can be simulated using "/"-delimited object name prefixes. DAG
   * objects for this environment reside in a simulated directory with the given
   * prefix.
   * </pre>
   *
   * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for dagGcsPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDagGcsPrefixBytes() {
    java.lang.Object ref = dagGcsPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dagGcsPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 3;
  private int nodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of nodes in the Kubernetes Engine cluster that will be
   * used to run this environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>int32 node_count = 3;</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    return nodeCount_;
  }

  public static final int SOFTWARE_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig softwareConfig_;
  /**
   *
   *
   * <pre>
   * The configuration settings for software inside the environment.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
   * </code>
   *
   * @return Whether the softwareConfig field is set.
   */
  @java.lang.Override
  public boolean hasSoftwareConfig() {
    return softwareConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The configuration settings for software inside the environment.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
   * </code>
   *
   * @return The softwareConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig getSoftwareConfig() {
    return softwareConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration settings for software inside the environment.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfigOrBuilder
      getSoftwareConfigOrBuilder() {
    return softwareConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }

  public static final int NODE_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig nodeConfig_;
  /**
   *
   *
   * <pre>
   * The configuration used for the Kubernetes Engine cluster.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
   *
   * @return Whether the nodeConfig field is set.
   */
  @java.lang.Override
  public boolean hasNodeConfig() {
    return nodeConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The configuration used for the Kubernetes Engine cluster.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
   *
   * @return The nodeConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig getNodeConfig() {
    return nodeConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.getDefaultInstance()
        : nodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration used for the Kubernetes Engine cluster.
   * </pre>
   *
   * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfigOrBuilder
      getNodeConfigOrBuilder() {
    return nodeConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.getDefaultInstance()
        : nodeConfig_;
  }

  public static final int PRIVATE_ENVIRONMENT_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      privateEnvironmentConfig_;
  /**
   *
   *
   * <pre>
   * The configuration used for the Private IP Cloud Composer environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
   * </code>
   *
   * @return Whether the privateEnvironmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateEnvironmentConfig() {
    return privateEnvironmentConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The configuration used for the Private IP Cloud Composer environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
   * </code>
   *
   * @return The privateEnvironmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      getPrivateEnvironmentConfig() {
    return privateEnvironmentConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
            .getDefaultInstance()
        : privateEnvironmentConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration used for the Private IP Cloud Composer environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfigOrBuilder
      getPrivateEnvironmentConfigOrBuilder() {
    return privateEnvironmentConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
            .getDefaultInstance()
        : privateEnvironmentConfig_;
  }

  public static final int WEB_SERVER_NETWORK_ACCESS_CONTROL_FIELD_NUMBER = 9;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
      webServerNetworkAccessControl_;
  /**
   *
   *
   * <pre>
   * Optional. The network-level access control policy for the Airflow web
   * server. If unspecified, no network-level access restrictions will be
   * applied.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webServerNetworkAccessControl field is set.
   */
  @java.lang.Override
  public boolean hasWebServerNetworkAccessControl() {
    return webServerNetworkAccessControl_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The network-level access control policy for the Airflow web
   * server. If unspecified, no network-level access restrictions will be
   * applied.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webServerNetworkAccessControl.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
      getWebServerNetworkAccessControl() {
    return webServerNetworkAccessControl_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
            .getDefaultInstance()
        : webServerNetworkAccessControl_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The network-level access control policy for the Airflow web
   * server. If unspecified, no network-level access restrictions will be
   * applied.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1
          .WebServerNetworkAccessControlOrBuilder
      getWebServerNetworkAccessControlOrBuilder() {
    return webServerNetworkAccessControl_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
            .getDefaultInstance()
        : webServerNetworkAccessControl_;
  }

  public static final int DATABASE_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig databaseConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration settings for Cloud SQL instance used internally
   * by Apache Airflow software.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the databaseConfig field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseConfig() {
    return databaseConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration settings for Cloud SQL instance used internally
   * by Apache Airflow software.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The databaseConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig getDatabaseConfig() {
    return databaseConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.getDefaultInstance()
        : databaseConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration settings for Cloud SQL instance used internally
   * by Apache Airflow software.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfigOrBuilder
      getDatabaseConfigOrBuilder() {
    return databaseConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.getDefaultInstance()
        : databaseConfig_;
  }

  public static final int WEB_SERVER_CONFIG_FIELD_NUMBER = 11;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig webServerConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration settings for the Airflow web server App Engine
   * instance.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webServerConfig field is set.
   */
  @java.lang.Override
  public boolean hasWebServerConfig() {
    return webServerConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration settings for the Airflow web server App Engine
   * instance.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webServerConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
      getWebServerConfig() {
    return webServerConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
            .getDefaultInstance()
        : webServerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration settings for the Airflow web server App Engine
   * instance.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfigOrBuilder
      getWebServerConfigOrBuilder() {
    return webServerConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
            .getDefaultInstance()
        : webServerConfig_;
  }

  public static final int AIRFLOW_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object airflowUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The URI of the Apache Airflow Web UI hosted within this
   * environment (see [Airflow web
   * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
   * </pre>
   *
   * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The airflowUri.
   */
  @java.lang.Override
  public java.lang.String getAirflowUri() {
    java.lang.Object ref = airflowUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      airflowUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The URI of the Apache Airflow Web UI hosted within this
   * environment (see [Airflow web
   * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
   * </pre>
   *
   * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for airflowUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAirflowUriBytes() {
    java.lang.Object ref = airflowUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      airflowUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AIRFLOW_BYOID_URI_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object airflowByoidUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The 'bring your own identity' variant of the URI of the Apache
   * Airflow Web UI hosted within this environment, to be accessed with external
   * identities using workforce identity federation (see [Access environments
   * with workforce identity
   * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
   * </pre>
   *
   * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The airflowByoidUri.
   */
  @java.lang.Override
  public java.lang.String getAirflowByoidUri() {
    java.lang.Object ref = airflowByoidUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      airflowByoidUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The 'bring your own identity' variant of the URI of the Apache
   * Airflow Web UI hosted within this environment, to be accessed with external
   * identities using workforce identity federation (see [Access environments
   * with workforce identity
   * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
   * </pre>
   *
   * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for airflowByoidUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAirflowByoidUriBytes() {
    java.lang.Object ref = airflowByoidUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      airflowByoidUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The encryption options for the Cloud Composer environment and its
   * dependencies. Cannot be updated.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return encryptionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption options for the Cloud Composer environment and its
   * dependencies. Cannot be updated.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
      getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
            .getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption options for the Cloud Composer environment and its
   * dependencies. Cannot be updated.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
            .getDefaultInstance()
        : encryptionConfig_;
  }

  public static final int MAINTENANCE_WINDOW_FIELD_NUMBER = 13;
  private com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
      maintenanceWindow_;
  /**
   *
   *
   * <pre>
   * Optional. The maintenance window is the period when Cloud Composer
   * components may undergo maintenance. It is defined so that maintenance is
   * not executed during peak hours or critical time periods.
   *
   * The system will not be under maintenance for every occurrence of this
   * window, but when maintenance is planned, it will be scheduled
   * during the window.
   *
   * The maintenance window period must encompass at least 12 hours per week.
   * This may be split into multiple chunks, each with a size of
   * at least 4 hours.
   *
   * If this value is omitted, Cloud Composer components may be subject to
   * maintenance at any time.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the maintenanceWindow field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceWindow() {
    return maintenanceWindow_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The maintenance window is the period when Cloud Composer
   * components may undergo maintenance. It is defined so that maintenance is
   * not executed during peak hours or critical time periods.
   *
   * The system will not be under maintenance for every occurrence of this
   * window, but when maintenance is planned, it will be scheduled
   * during the window.
   *
   * The maintenance window period must encompass at least 12 hours per week.
   * This may be split into multiple chunks, each with a size of
   * at least 4 hours.
   *
   * If this value is omitted, Cloud Composer components may be subject to
   * maintenance at any time.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maintenanceWindow.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
      getMaintenanceWindow() {
    return maintenanceWindow_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
            .getDefaultInstance()
        : maintenanceWindow_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The maintenance window is the period when Cloud Composer
   * components may undergo maintenance. It is defined so that maintenance is
   * not executed during peak hours or critical time periods.
   *
   * The system will not be under maintenance for every occurrence of this
   * window, but when maintenance is planned, it will be scheduled
   * during the window.
   *
   * The maintenance window period must encompass at least 12 hours per week.
   * This may be split into multiple chunks, each with a size of
   * at least 4 hours.
   *
   * If this value is omitted, Cloud Composer components may be subject to
   * maintenance at any time.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindowOrBuilder
      getMaintenanceWindowOrBuilder() {
    return maintenanceWindow_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
            .getDefaultInstance()
        : maintenanceWindow_;
  }

  public static final int WORKLOADS_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloadsConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The workloads configuration settings for the GKE cluster
   * associated with the Cloud Composer environment. The GKE cluster runs
   * Airflow scheduler, web server and workers workloads.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the workloadsConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkloadsConfig() {
    return workloadsConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The workloads configuration settings for the GKE cluster
   * associated with the Cloud Composer environment. The GKE cluster runs
   * Airflow scheduler, web server and workers workloads.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The workloadsConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
      getWorkloadsConfig() {
    return workloadsConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .getDefaultInstance()
        : workloadsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The workloads configuration settings for the GKE cluster
   * associated with the Cloud Composer environment. The GKE cluster runs
   * Airflow scheduler, web server and workers workloads.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfigOrBuilder
      getWorkloadsConfigOrBuilder() {
    return workloadsConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .getDefaultInstance()
        : workloadsConfig_;
  }

  public static final int ENVIRONMENT_SIZE_FIELD_NUMBER = 16;
  private int environmentSize_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The size of the Cloud Composer environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for environmentSize.
   */
  @java.lang.Override
  public int getEnvironmentSizeValue() {
    return environmentSize_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The size of the Cloud Composer environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The environmentSize.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
      getEnvironmentSize() {
    com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
        result =
            com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
                .forNumber(environmentSize_);
    return result == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
            .UNRECOGNIZED
        : result;
  }

  public static final int MASTER_AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER = 17;
  private com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
      masterAuthorizedNetworksConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration options for GKE cluster master authorized
   * networks. By default master authorized networks feature is:
   * - in case of private environment: enabled with no external networks
   * allowlisted.
   * - in case of public environment: disabled.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the masterAuthorizedNetworksConfig field is set.
   */
  @java.lang.Override
  public boolean hasMasterAuthorizedNetworksConfig() {
    return masterAuthorizedNetworksConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration options for GKE cluster master authorized
   * networks. By default master authorized networks feature is:
   * - in case of private environment: enabled with no external networks
   * allowlisted.
   * - in case of public environment: disabled.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The masterAuthorizedNetworksConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
      getMasterAuthorizedNetworksConfig() {
    return masterAuthorizedNetworksConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
            .getDefaultInstance()
        : masterAuthorizedNetworksConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration options for GKE cluster master authorized
   * networks. By default master authorized networks feature is:
   * - in case of private environment: enabled with no external networks
   * allowlisted.
   * - in case of public environment: disabled.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1
          .MasterAuthorizedNetworksConfigOrBuilder
      getMasterAuthorizedNetworksConfigOrBuilder() {
    return masterAuthorizedNetworksConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
            .getDefaultInstance()
        : masterAuthorizedNetworksConfig_;
  }

  public static final int RECOVERY_CONFIG_FIELD_NUMBER = 18;
  private com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recoveryConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The Recovery settings configuration of an environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the recoveryConfig field is set.
   */
  @java.lang.Override
  public boolean hasRecoveryConfig() {
    return recoveryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Recovery settings configuration of an environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The recoveryConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig getRecoveryConfig() {
    return recoveryConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.getDefaultInstance()
        : recoveryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Recovery settings configuration of an environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfigOrBuilder
      getRecoveryConfigOrBuilder() {
    return recoveryConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.getDefaultInstance()
        : recoveryConfig_;
  }

  public static final int RESILIENCE_MODE_FIELD_NUMBER = 20;
  private int resilienceMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Resilience mode of the Cloud Composer Environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.2.0-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for resilienceMode.
   */
  @java.lang.Override
  public int getResilienceModeValue() {
    return resilienceMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resilience mode of the Cloud Composer Environment.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.2.0-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The resilienceMode.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
      getResilienceMode() {
    com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode result =
        com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
            .forNumber(resilienceMode_);
    return result == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeCluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gkeCluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dagGcsPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dagGcsPrefix_);
    }
    if (nodeCount_ != 0) {
      output.writeInt32(3, nodeCount_);
    }
    if (softwareConfig_ != null) {
      output.writeMessage(4, getSoftwareConfig());
    }
    if (nodeConfig_ != null) {
      output.writeMessage(5, getNodeConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(airflowUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, airflowUri_);
    }
    if (privateEnvironmentConfig_ != null) {
      output.writeMessage(7, getPrivateEnvironmentConfig());
    }
    if (webServerNetworkAccessControl_ != null) {
      output.writeMessage(9, getWebServerNetworkAccessControl());
    }
    if (databaseConfig_ != null) {
      output.writeMessage(10, getDatabaseConfig());
    }
    if (webServerConfig_ != null) {
      output.writeMessage(11, getWebServerConfig());
    }
    if (encryptionConfig_ != null) {
      output.writeMessage(12, getEncryptionConfig());
    }
    if (maintenanceWindow_ != null) {
      output.writeMessage(13, getMaintenanceWindow());
    }
    if (workloadsConfig_ != null) {
      output.writeMessage(15, getWorkloadsConfig());
    }
    if (environmentSize_
        != com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
            .ENVIRONMENT_SIZE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(16, environmentSize_);
    }
    if (masterAuthorizedNetworksConfig_ != null) {
      output.writeMessage(17, getMasterAuthorizedNetworksConfig());
    }
    if (recoveryConfig_ != null) {
      output.writeMessage(18, getRecoveryConfig());
    }
    if (resilienceMode_
        != com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
            .RESILIENCE_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(20, resilienceMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(airflowByoidUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, airflowByoidUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeCluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gkeCluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dagGcsPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dagGcsPrefix_);
    }
    if (nodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, nodeCount_);
    }
    if (softwareConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSoftwareConfig());
    }
    if (nodeConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getNodeConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(airflowUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, airflowUri_);
    }
    if (privateEnvironmentConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getPrivateEnvironmentConfig());
    }
    if (webServerNetworkAccessControl_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getWebServerNetworkAccessControl());
    }
    if (databaseConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDatabaseConfig());
    }
    if (webServerConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getWebServerConfig());
    }
    if (encryptionConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getEncryptionConfig());
    }
    if (maintenanceWindow_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getMaintenanceWindow());
    }
    if (workloadsConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getWorkloadsConfig());
    }
    if (environmentSize_
        != com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
            .ENVIRONMENT_SIZE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, environmentSize_);
    }
    if (masterAuthorizedNetworksConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getMasterAuthorizedNetworksConfig());
    }
    if (recoveryConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getRecoveryConfig());
    }
    if (resilienceMode_
        != com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
            .RESILIENCE_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(20, resilienceMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(airflowByoidUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, airflowByoidUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig) obj;

    if (!getGkeCluster().equals(other.getGkeCluster())) return false;
    if (!getDagGcsPrefix().equals(other.getDagGcsPrefix())) return false;
    if (getNodeCount() != other.getNodeCount()) return false;
    if (hasSoftwareConfig() != other.hasSoftwareConfig()) return false;
    if (hasSoftwareConfig()) {
      if (!getSoftwareConfig().equals(other.getSoftwareConfig())) return false;
    }
    if (hasNodeConfig() != other.hasNodeConfig()) return false;
    if (hasNodeConfig()) {
      if (!getNodeConfig().equals(other.getNodeConfig())) return false;
    }
    if (hasPrivateEnvironmentConfig() != other.hasPrivateEnvironmentConfig()) return false;
    if (hasPrivateEnvironmentConfig()) {
      if (!getPrivateEnvironmentConfig().equals(other.getPrivateEnvironmentConfig())) return false;
    }
    if (hasWebServerNetworkAccessControl() != other.hasWebServerNetworkAccessControl())
      return false;
    if (hasWebServerNetworkAccessControl()) {
      if (!getWebServerNetworkAccessControl().equals(other.getWebServerNetworkAccessControl()))
        return false;
    }
    if (hasDatabaseConfig() != other.hasDatabaseConfig()) return false;
    if (hasDatabaseConfig()) {
      if (!getDatabaseConfig().equals(other.getDatabaseConfig())) return false;
    }
    if (hasWebServerConfig() != other.hasWebServerConfig()) return false;
    if (hasWebServerConfig()) {
      if (!getWebServerConfig().equals(other.getWebServerConfig())) return false;
    }
    if (!getAirflowUri().equals(other.getAirflowUri())) return false;
    if (!getAirflowByoidUri().equals(other.getAirflowByoidUri())) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (hasMaintenanceWindow() != other.hasMaintenanceWindow()) return false;
    if (hasMaintenanceWindow()) {
      if (!getMaintenanceWindow().equals(other.getMaintenanceWindow())) return false;
    }
    if (hasWorkloadsConfig() != other.hasWorkloadsConfig()) return false;
    if (hasWorkloadsConfig()) {
      if (!getWorkloadsConfig().equals(other.getWorkloadsConfig())) return false;
    }
    if (environmentSize_ != other.environmentSize_) return false;
    if (hasMasterAuthorizedNetworksConfig() != other.hasMasterAuthorizedNetworksConfig())
      return false;
    if (hasMasterAuthorizedNetworksConfig()) {
      if (!getMasterAuthorizedNetworksConfig().equals(other.getMasterAuthorizedNetworksConfig()))
        return false;
    }
    if (hasRecoveryConfig() != other.hasRecoveryConfig()) return false;
    if (hasRecoveryConfig()) {
      if (!getRecoveryConfig().equals(other.getRecoveryConfig())) return false;
    }
    if (resilienceMode_ != other.resilienceMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GKE_CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getGkeCluster().hashCode();
    hash = (37 * hash) + DAG_GCS_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getDagGcsPrefix().hashCode();
    hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNodeCount();
    if (hasSoftwareConfig()) {
      hash = (37 * hash) + SOFTWARE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSoftwareConfig().hashCode();
    }
    if (hasNodeConfig()) {
      hash = (37 * hash) + NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodeConfig().hashCode();
    }
    if (hasPrivateEnvironmentConfig()) {
      hash = (37 * hash) + PRIVATE_ENVIRONMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateEnvironmentConfig().hashCode();
    }
    if (hasWebServerNetworkAccessControl()) {
      hash = (37 * hash) + WEB_SERVER_NETWORK_ACCESS_CONTROL_FIELD_NUMBER;
      hash = (53 * hash) + getWebServerNetworkAccessControl().hashCode();
    }
    if (hasDatabaseConfig()) {
      hash = (37 * hash) + DATABASE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDatabaseConfig().hashCode();
    }
    if (hasWebServerConfig()) {
      hash = (37 * hash) + WEB_SERVER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWebServerConfig().hashCode();
    }
    hash = (37 * hash) + AIRFLOW_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAirflowUri().hashCode();
    hash = (37 * hash) + AIRFLOW_BYOID_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAirflowByoidUri().hashCode();
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    if (hasMaintenanceWindow()) {
      hash = (37 * hash) + MAINTENANCE_WINDOW_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceWindow().hashCode();
    }
    if (hasWorkloadsConfig()) {
      hash = (37 * hash) + WORKLOADS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkloadsConfig().hashCode();
    }
    hash = (37 * hash) + ENVIRONMENT_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + environmentSize_;
    if (hasMasterAuthorizedNetworksConfig()) {
      hash = (37 * hash) + MASTER_AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMasterAuthorizedNetworksConfig().hashCode();
    }
    if (hasRecoveryConfig()) {
      hash = (37 * hash) + RECOVERY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRecoveryConfig().hashCode();
    }
    hash = (37 * hash) + RESILIENCE_MODE_FIELD_NUMBER;
    hash = (53 * hash) + resilienceMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration information for an environment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig)
      com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_EnvironmentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_EnvironmentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      gkeCluster_ = "";
      dagGcsPrefix_ = "";
      nodeCount_ = 0;
      softwareConfig_ = null;
      if (softwareConfigBuilder_ != null) {
        softwareConfigBuilder_.dispose();
        softwareConfigBuilder_ = null;
      }
      nodeConfig_ = null;
      if (nodeConfigBuilder_ != null) {
        nodeConfigBuilder_.dispose();
        nodeConfigBuilder_ = null;
      }
      privateEnvironmentConfig_ = null;
      if (privateEnvironmentConfigBuilder_ != null) {
        privateEnvironmentConfigBuilder_.dispose();
        privateEnvironmentConfigBuilder_ = null;
      }
      webServerNetworkAccessControl_ = null;
      if (webServerNetworkAccessControlBuilder_ != null) {
        webServerNetworkAccessControlBuilder_.dispose();
        webServerNetworkAccessControlBuilder_ = null;
      }
      databaseConfig_ = null;
      if (databaseConfigBuilder_ != null) {
        databaseConfigBuilder_.dispose();
        databaseConfigBuilder_ = null;
      }
      webServerConfig_ = null;
      if (webServerConfigBuilder_ != null) {
        webServerConfigBuilder_.dispose();
        webServerConfigBuilder_ = null;
      }
      airflowUri_ = "";
      airflowByoidUri_ = "";
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      maintenanceWindow_ = null;
      if (maintenanceWindowBuilder_ != null) {
        maintenanceWindowBuilder_.dispose();
        maintenanceWindowBuilder_ = null;
      }
      workloadsConfig_ = null;
      if (workloadsConfigBuilder_ != null) {
        workloadsConfigBuilder_.dispose();
        workloadsConfigBuilder_ = null;
      }
      environmentSize_ = 0;
      masterAuthorizedNetworksConfig_ = null;
      if (masterAuthorizedNetworksConfigBuilder_ != null) {
        masterAuthorizedNetworksConfigBuilder_.dispose();
        masterAuthorizedNetworksConfigBuilder_ = null;
      }
      recoveryConfig_ = null;
      if (recoveryConfigBuilder_ != null) {
        recoveryConfigBuilder_.dispose();
        recoveryConfigBuilder_ = null;
      }
      resilienceMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_EnvironmentConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.gkeCluster_ = gkeCluster_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dagGcsPrefix_ = dagGcsPrefix_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nodeCount_ = nodeCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.softwareConfig_ =
            softwareConfigBuilder_ == null ? softwareConfig_ : softwareConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nodeConfig_ = nodeConfigBuilder_ == null ? nodeConfig_ : nodeConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.privateEnvironmentConfig_ =
            privateEnvironmentConfigBuilder_ == null
                ? privateEnvironmentConfig_
                : privateEnvironmentConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.webServerNetworkAccessControl_ =
            webServerNetworkAccessControlBuilder_ == null
                ? webServerNetworkAccessControl_
                : webServerNetworkAccessControlBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.databaseConfig_ =
            databaseConfigBuilder_ == null ? databaseConfig_ : databaseConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.webServerConfig_ =
            webServerConfigBuilder_ == null ? webServerConfig_ : webServerConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.airflowUri_ = airflowUri_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.airflowByoidUri_ = airflowByoidUri_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.maintenanceWindow_ =
            maintenanceWindowBuilder_ == null
                ? maintenanceWindow_
                : maintenanceWindowBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.workloadsConfig_ =
            workloadsConfigBuilder_ == null ? workloadsConfig_ : workloadsConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.environmentSize_ = environmentSize_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.masterAuthorizedNetworksConfig_ =
            masterAuthorizedNetworksConfigBuilder_ == null
                ? masterAuthorizedNetworksConfig_
                : masterAuthorizedNetworksConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.recoveryConfig_ =
            recoveryConfigBuilder_ == null ? recoveryConfig_ : recoveryConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.resilienceMode_ = resilienceMode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
              .getDefaultInstance()) return this;
      if (!other.getGkeCluster().isEmpty()) {
        gkeCluster_ = other.gkeCluster_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDagGcsPrefix().isEmpty()) {
        dagGcsPrefix_ = other.dagGcsPrefix_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getNodeCount() != 0) {
        setNodeCount(other.getNodeCount());
      }
      if (other.hasSoftwareConfig()) {
        mergeSoftwareConfig(other.getSoftwareConfig());
      }
      if (other.hasNodeConfig()) {
        mergeNodeConfig(other.getNodeConfig());
      }
      if (other.hasPrivateEnvironmentConfig()) {
        mergePrivateEnvironmentConfig(other.getPrivateEnvironmentConfig());
      }
      if (other.hasWebServerNetworkAccessControl()) {
        mergeWebServerNetworkAccessControl(other.getWebServerNetworkAccessControl());
      }
      if (other.hasDatabaseConfig()) {
        mergeDatabaseConfig(other.getDatabaseConfig());
      }
      if (other.hasWebServerConfig()) {
        mergeWebServerConfig(other.getWebServerConfig());
      }
      if (!other.getAirflowUri().isEmpty()) {
        airflowUri_ = other.airflowUri_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getAirflowByoidUri().isEmpty()) {
        airflowByoidUri_ = other.airflowByoidUri_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      if (other.hasMaintenanceWindow()) {
        mergeMaintenanceWindow(other.getMaintenanceWindow());
      }
      if (other.hasWorkloadsConfig()) {
        mergeWorkloadsConfig(other.getWorkloadsConfig());
      }
      if (other.environmentSize_ != 0) {
        setEnvironmentSizeValue(other.getEnvironmentSizeValue());
      }
      if (other.hasMasterAuthorizedNetworksConfig()) {
        mergeMasterAuthorizedNetworksConfig(other.getMasterAuthorizedNetworksConfig());
      }
      if (other.hasRecoveryConfig()) {
        mergeRecoveryConfig(other.getRecoveryConfig());
      }
      if (other.resilienceMode_ != 0) {
        setResilienceModeValue(other.getResilienceModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                gkeCluster_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dagGcsPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                nodeCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getSoftwareConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                airflowUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getPrivateEnvironmentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(
                    getWebServerNetworkAccessControlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getDatabaseConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getWebServerConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getMaintenanceWindowFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 122:
              {
                input.readMessage(getWorkloadsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 122
            case 128:
              {
                environmentSize_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(
                    getMasterAuthorizedNetworksConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getRecoveryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 146
            case 160:
              {
                resilienceMode_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 160
            case 170:
              {
                airflowByoidUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 170
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object gkeCluster_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes Engine cluster used to run this environment.
     * </pre>
     *
     * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gkeCluster.
     */
    public java.lang.String getGkeCluster() {
      java.lang.Object ref = gkeCluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gkeCluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes Engine cluster used to run this environment.
     * </pre>
     *
     * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gkeCluster.
     */
    public com.google.protobuf.ByteString getGkeClusterBytes() {
      java.lang.Object ref = gkeCluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gkeCluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes Engine cluster used to run this environment.
     * </pre>
     *
     * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The gkeCluster to set.
     * @return This builder for chaining.
     */
    public Builder setGkeCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gkeCluster_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes Engine cluster used to run this environment.
     * </pre>
     *
     * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGkeCluster() {
      gkeCluster_ = getDefaultInstance().getGkeCluster();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Kubernetes Engine cluster used to run this environment.
     * </pre>
     *
     * <code>string gke_cluster = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for gkeCluster to set.
     * @return This builder for chaining.
     */
    public Builder setGkeClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gkeCluster_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dagGcsPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Storage prefix of the DAGs for this environment.
     * Although Cloud Storage objects reside in a flat namespace, a hierarchical
     * file tree can be simulated using "/"-delimited object name prefixes. DAG
     * objects for this environment reside in a simulated directory with the given
     * prefix.
     * </pre>
     *
     * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dagGcsPrefix.
     */
    public java.lang.String getDagGcsPrefix() {
      java.lang.Object ref = dagGcsPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dagGcsPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Storage prefix of the DAGs for this environment.
     * Although Cloud Storage objects reside in a flat namespace, a hierarchical
     * file tree can be simulated using "/"-delimited object name prefixes. DAG
     * objects for this environment reside in a simulated directory with the given
     * prefix.
     * </pre>
     *
     * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dagGcsPrefix.
     */
    public com.google.protobuf.ByteString getDagGcsPrefixBytes() {
      java.lang.Object ref = dagGcsPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dagGcsPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Storage prefix of the DAGs for this environment.
     * Although Cloud Storage objects reside in a flat namespace, a hierarchical
     * file tree can be simulated using "/"-delimited object name prefixes. DAG
     * objects for this environment reside in a simulated directory with the given
     * prefix.
     * </pre>
     *
     * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The dagGcsPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setDagGcsPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dagGcsPrefix_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Storage prefix of the DAGs for this environment.
     * Although Cloud Storage objects reside in a flat namespace, a hierarchical
     * file tree can be simulated using "/"-delimited object name prefixes. DAG
     * objects for this environment reside in a simulated directory with the given
     * prefix.
     * </pre>
     *
     * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDagGcsPrefix() {
      dagGcsPrefix_ = getDefaultInstance().getDagGcsPrefix();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud Storage prefix of the DAGs for this environment.
     * Although Cloud Storage objects reside in a flat namespace, a hierarchical
     * file tree can be simulated using "/"-delimited object name prefixes. DAG
     * objects for this environment reside in a simulated directory with the given
     * prefix.
     * </pre>
     *
     * <code>string dag_gcs_prefix = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for dagGcsPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setDagGcsPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dagGcsPrefix_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int nodeCount_;
    /**
     *
     *
     * <pre>
     * The number of nodes in the Kubernetes Engine cluster that will be
     * used to run this environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>int32 node_count = 3;</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public int getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes in the Kubernetes Engine cluster that will be
     * used to run this environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>int32 node_count = 3;</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      nodeCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes in the Kubernetes Engine cluster that will be
     * used to run this environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>int32 node_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      nodeCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig softwareConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfigOrBuilder>
        softwareConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     *
     * @return Whether the softwareConfig field is set.
     */
    public boolean hasSoftwareConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     *
     * @return The softwareConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
        getSoftwareConfig() {
      if (softwareConfigBuilder_ == null) {
        return softwareConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
                .getDefaultInstance()
            : softwareConfig_;
      } else {
        return softwareConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    public Builder setSoftwareConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softwareConfig_ = value;
      } else {
        softwareConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    public Builder setSoftwareConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder
            builderForValue) {
      if (softwareConfigBuilder_ == null) {
        softwareConfig_ = builderForValue.build();
      } else {
        softwareConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    public Builder mergeSoftwareConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && softwareConfig_ != null
            && softwareConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
                    .getDefaultInstance()) {
          getSoftwareConfigBuilder().mergeFrom(value);
        } else {
          softwareConfig_ = value;
        }
      } else {
        softwareConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    public Builder clearSoftwareConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      softwareConfig_ = null;
      if (softwareConfigBuilder_ != null) {
        softwareConfigBuilder_.dispose();
        softwareConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder
        getSoftwareConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSoftwareConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfigOrBuilder
        getSoftwareConfigOrBuilder() {
      if (softwareConfigBuilder_ != null) {
        return softwareConfigBuilder_.getMessageOrBuilder();
      } else {
        return softwareConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig
                .getDefaultInstance()
            : softwareConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration settings for software inside the environment.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig software_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfigOrBuilder>
        getSoftwareConfigFieldBuilder() {
      if (softwareConfigBuilder_ == null) {
        softwareConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.SoftwareConfigOrBuilder>(
                getSoftwareConfig(), getParentForChildren(), isClean());
        softwareConfig_ = null;
      }
      return softwareConfigBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig nodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfigOrBuilder>
        nodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     *
     * @return Whether the nodeConfig field is set.
     */
    public boolean hasNodeConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     *
     * @return The nodeConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig getNodeConfig() {
      if (nodeConfigBuilder_ == null) {
        return nodeConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.getDefaultInstance()
            : nodeConfig_;
      } else {
        return nodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    public Builder setNodeConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig value) {
      if (nodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeConfig_ = value;
      } else {
        nodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    public Builder setNodeConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.Builder builderForValue) {
      if (nodeConfigBuilder_ == null) {
        nodeConfig_ = builderForValue.build();
      } else {
        nodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    public Builder mergeNodeConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig value) {
      if (nodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && nodeConfig_ != null
            && nodeConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig
                    .getDefaultInstance()) {
          getNodeConfigBuilder().mergeFrom(value);
        } else {
          nodeConfig_ = value;
        }
      } else {
        nodeConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    public Builder clearNodeConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      nodeConfig_ = null;
      if (nodeConfigBuilder_ != null) {
        nodeConfigBuilder_.dispose();
        nodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.Builder
        getNodeConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfigOrBuilder
        getNodeConfigOrBuilder() {
      if (nodeConfigBuilder_ != null) {
        return nodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodeConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.getDefaultInstance()
            : nodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Kubernetes Engine cluster.
     * </pre>
     *
     * <code>.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig node_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfigOrBuilder>
        getNodeConfigFieldBuilder() {
      if (nodeConfigBuilder_ == null) {
        nodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.NodeConfigOrBuilder>(
                getNodeConfig(), getParentForChildren(), isClean());
        nodeConfig_ = null;
      }
      return nodeConfigBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
        privateEnvironmentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .PrivateEnvironmentConfigOrBuilder>
        privateEnvironmentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     *
     * @return Whether the privateEnvironmentConfig field is set.
     */
    public boolean hasPrivateEnvironmentConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     *
     * @return The privateEnvironmentConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
        getPrivateEnvironmentConfig() {
      if (privateEnvironmentConfigBuilder_ == null) {
        return privateEnvironmentConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
                .getDefaultInstance()
            : privateEnvironmentConfig_;
      } else {
        return privateEnvironmentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    public Builder setPrivateEnvironmentConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig value) {
      if (privateEnvironmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateEnvironmentConfig_ = value;
      } else {
        privateEnvironmentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    public Builder setPrivateEnvironmentConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.Builder
            builderForValue) {
      if (privateEnvironmentConfigBuilder_ == null) {
        privateEnvironmentConfig_ = builderForValue.build();
      } else {
        privateEnvironmentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    public Builder mergePrivateEnvironmentConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig value) {
      if (privateEnvironmentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && privateEnvironmentConfig_ != null
            && privateEnvironmentConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
                    .getDefaultInstance()) {
          getPrivateEnvironmentConfigBuilder().mergeFrom(value);
        } else {
          privateEnvironmentConfig_ = value;
        }
      } else {
        privateEnvironmentConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    public Builder clearPrivateEnvironmentConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      privateEnvironmentConfig_ = null;
      if (privateEnvironmentConfigBuilder_ != null) {
        privateEnvironmentConfigBuilder_.dispose();
        privateEnvironmentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.Builder
        getPrivateEnvironmentConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPrivateEnvironmentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfigOrBuilder
        getPrivateEnvironmentConfigOrBuilder() {
      if (privateEnvironmentConfigBuilder_ != null) {
        return privateEnvironmentConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateEnvironmentConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
                .getDefaultInstance()
            : privateEnvironmentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration used for the Private IP Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig private_environment_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .PrivateEnvironmentConfigOrBuilder>
        getPrivateEnvironmentConfigFieldBuilder() {
      if (privateEnvironmentConfigBuilder_ == null) {
        privateEnvironmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
                    .Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .PrivateEnvironmentConfigOrBuilder>(
                getPrivateEnvironmentConfig(), getParentForChildren(), isClean());
        privateEnvironmentConfig_ = null;
      }
      return privateEnvironmentConfigBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
        webServerNetworkAccessControl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl,
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .WebServerNetworkAccessControlOrBuilder>
        webServerNetworkAccessControlBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the webServerNetworkAccessControl field is set.
     */
    public boolean hasWebServerNetworkAccessControl() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webServerNetworkAccessControl.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
        getWebServerNetworkAccessControl() {
      if (webServerNetworkAccessControlBuilder_ == null) {
        return webServerNetworkAccessControl_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
                .getDefaultInstance()
            : webServerNetworkAccessControl_;
      } else {
        return webServerNetworkAccessControlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebServerNetworkAccessControl(
        com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
            value) {
      if (webServerNetworkAccessControlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webServerNetworkAccessControl_ = value;
      } else {
        webServerNetworkAccessControlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebServerNetworkAccessControl(
        com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl.Builder
            builderForValue) {
      if (webServerNetworkAccessControlBuilder_ == null) {
        webServerNetworkAccessControl_ = builderForValue.build();
      } else {
        webServerNetworkAccessControlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWebServerNetworkAccessControl(
        com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
            value) {
      if (webServerNetworkAccessControlBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && webServerNetworkAccessControl_ != null
            && webServerNetworkAccessControl_
                != com.google.cloud.orchestration.airflow.service.v1beta1
                    .WebServerNetworkAccessControl.getDefaultInstance()) {
          getWebServerNetworkAccessControlBuilder().mergeFrom(value);
        } else {
          webServerNetworkAccessControl_ = value;
        }
      } else {
        webServerNetworkAccessControlBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWebServerNetworkAccessControl() {
      bitField0_ = (bitField0_ & ~0x00000040);
      webServerNetworkAccessControl_ = null;
      if (webServerNetworkAccessControlBuilder_ != null) {
        webServerNetworkAccessControlBuilder_.dispose();
        webServerNetworkAccessControlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
            .Builder
        getWebServerNetworkAccessControlBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getWebServerNetworkAccessControlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1
            .WebServerNetworkAccessControlOrBuilder
        getWebServerNetworkAccessControlOrBuilder() {
      if (webServerNetworkAccessControlBuilder_ != null) {
        return webServerNetworkAccessControlBuilder_.getMessageOrBuilder();
      } else {
        return webServerNetworkAccessControl_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
                .getDefaultInstance()
            : webServerNetworkAccessControl_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The network-level access control policy for the Airflow web
     * server. If unspecified, no network-level access restrictions will be
     * applied.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl web_server_network_access_control = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl,
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .WebServerNetworkAccessControlOrBuilder>
        getWebServerNetworkAccessControlFieldBuilder() {
      if (webServerNetworkAccessControlBuilder_ == null) {
        webServerNetworkAccessControlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .WebServerNetworkAccessControl,
                com.google.cloud.orchestration.airflow.service.v1beta1.WebServerNetworkAccessControl
                    .Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .WebServerNetworkAccessControlOrBuilder>(
                getWebServerNetworkAccessControl(), getParentForChildren(), isClean());
        webServerNetworkAccessControl_ = null;
      }
      return webServerNetworkAccessControlBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig databaseConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfigOrBuilder>
        databaseConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the databaseConfig field is set.
     */
    public boolean hasDatabaseConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The databaseConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig
        getDatabaseConfig() {
      if (databaseConfigBuilder_ == null) {
        return databaseConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig
                .getDefaultInstance()
            : databaseConfig_;
      } else {
        return databaseConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDatabaseConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig value) {
      if (databaseConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        databaseConfig_ = value;
      } else {
        databaseConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDatabaseConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.Builder
            builderForValue) {
      if (databaseConfigBuilder_ == null) {
        databaseConfig_ = builderForValue.build();
      } else {
        databaseConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDatabaseConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig value) {
      if (databaseConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && databaseConfig_ != null
            && databaseConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig
                    .getDefaultInstance()) {
          getDatabaseConfigBuilder().mergeFrom(value);
        } else {
          databaseConfig_ = value;
        }
      } else {
        databaseConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDatabaseConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      databaseConfig_ = null;
      if (databaseConfigBuilder_ != null) {
        databaseConfigBuilder_.dispose();
        databaseConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.Builder
        getDatabaseConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDatabaseConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfigOrBuilder
        getDatabaseConfigOrBuilder() {
      if (databaseConfigBuilder_ != null) {
        return databaseConfigBuilder_.getMessageOrBuilder();
      } else {
        return databaseConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig
                .getDefaultInstance()
            : databaseConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for Cloud SQL instance used internally
     * by Apache Airflow software.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig database_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfigOrBuilder>
        getDatabaseConfigFieldBuilder() {
      if (databaseConfigBuilder_ == null) {
        databaseConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.DatabaseConfigOrBuilder>(
                getDatabaseConfig(), getParentForChildren(), isClean());
        databaseConfig_ = null;
      }
      return databaseConfigBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig webServerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfigOrBuilder>
        webServerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the webServerConfig field is set.
     */
    public boolean hasWebServerConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webServerConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
        getWebServerConfig() {
      if (webServerConfigBuilder_ == null) {
        return webServerConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
                .getDefaultInstance()
            : webServerConfig_;
      } else {
        return webServerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebServerConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig value) {
      if (webServerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webServerConfig_ = value;
      } else {
        webServerConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebServerConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig.Builder
            builderForValue) {
      if (webServerConfigBuilder_ == null) {
        webServerConfig_ = builderForValue.build();
      } else {
        webServerConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWebServerConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig value) {
      if (webServerConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && webServerConfig_ != null
            && webServerConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
                    .getDefaultInstance()) {
          getWebServerConfigBuilder().mergeFrom(value);
        } else {
          webServerConfig_ = value;
        }
      } else {
        webServerConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWebServerConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      webServerConfig_ = null;
      if (webServerConfigBuilder_ != null) {
        webServerConfigBuilder_.dispose();
        webServerConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig.Builder
        getWebServerConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getWebServerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfigOrBuilder
        getWebServerConfigOrBuilder() {
      if (webServerConfigBuilder_ != null) {
        return webServerConfigBuilder_.getMessageOrBuilder();
      } else {
        return webServerConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig
                .getDefaultInstance()
            : webServerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration settings for the Airflow web server App Engine
     * instance.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig web_server_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfigOrBuilder>
        getWebServerConfigFieldBuilder() {
      if (webServerConfigBuilder_ == null) {
        webServerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.WebServerConfigOrBuilder>(
                getWebServerConfig(), getParentForChildren(), isClean());
        webServerConfig_ = null;
      }
      return webServerConfigBuilder_;
    }

    private java.lang.Object airflowUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The URI of the Apache Airflow Web UI hosted within this
     * environment (see [Airflow web
     * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
     * </pre>
     *
     * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The airflowUri.
     */
    public java.lang.String getAirflowUri() {
      java.lang.Object ref = airflowUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        airflowUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the Apache Airflow Web UI hosted within this
     * environment (see [Airflow web
     * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
     * </pre>
     *
     * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for airflowUri.
     */
    public com.google.protobuf.ByteString getAirflowUriBytes() {
      java.lang.Object ref = airflowUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        airflowUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the Apache Airflow Web UI hosted within this
     * environment (see [Airflow web
     * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
     * </pre>
     *
     * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The airflowUri to set.
     * @return This builder for chaining.
     */
    public Builder setAirflowUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      airflowUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the Apache Airflow Web UI hosted within this
     * environment (see [Airflow web
     * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
     * </pre>
     *
     * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAirflowUri() {
      airflowUri_ = getDefaultInstance().getAirflowUri();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the Apache Airflow Web UI hosted within this
     * environment (see [Airflow web
     * interface](/composer/docs/how-to/accessing/airflow-web-interface)).
     * </pre>
     *
     * <code>string airflow_uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for airflowUri to set.
     * @return This builder for chaining.
     */
    public Builder setAirflowUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      airflowUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object airflowByoidUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The 'bring your own identity' variant of the URI of the Apache
     * Airflow Web UI hosted within this environment, to be accessed with external
     * identities using workforce identity federation (see [Access environments
     * with workforce identity
     * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
     * </pre>
     *
     * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The airflowByoidUri.
     */
    public java.lang.String getAirflowByoidUri() {
      java.lang.Object ref = airflowByoidUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        airflowByoidUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'bring your own identity' variant of the URI of the Apache
     * Airflow Web UI hosted within this environment, to be accessed with external
     * identities using workforce identity federation (see [Access environments
     * with workforce identity
     * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
     * </pre>
     *
     * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for airflowByoidUri.
     */
    public com.google.protobuf.ByteString getAirflowByoidUriBytes() {
      java.lang.Object ref = airflowByoidUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        airflowByoidUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'bring your own identity' variant of the URI of the Apache
     * Airflow Web UI hosted within this environment, to be accessed with external
     * identities using workforce identity federation (see [Access environments
     * with workforce identity
     * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
     * </pre>
     *
     * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The airflowByoidUri to set.
     * @return This builder for chaining.
     */
    public Builder setAirflowByoidUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      airflowByoidUri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'bring your own identity' variant of the URI of the Apache
     * Airflow Web UI hosted within this environment, to be accessed with external
     * identities using workforce identity federation (see [Access environments
     * with workforce identity
     * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
     * </pre>
     *
     * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAirflowByoidUri() {
      airflowByoidUri_ = getDefaultInstance().getAirflowByoidUri();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'bring your own identity' variant of the URI of the Apache
     * Airflow Web UI hosted within this environment, to be accessed with external
     * identities using workforce identity federation (see [Access environments
     * with workforce identity
     * federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
     * </pre>
     *
     * <code>string airflow_byoid_uri = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for airflowByoidUri to set.
     * @return This builder for chaining.
     */
    public Builder setAirflowByoidUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      airflowByoidUri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
        encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
        getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
                .getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig.Builder
            builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
                    .getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig
                .getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption options for the Cloud Composer environment and its
     * dependencies. Cannot be updated.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig encryption_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
        maintenanceWindow_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow,
            com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindowOrBuilder>
        maintenanceWindowBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the maintenanceWindow field is set.
     */
    public boolean hasMaintenanceWindow() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maintenanceWindow.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
        getMaintenanceWindow() {
      if (maintenanceWindowBuilder_ == null) {
        return maintenanceWindow_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
                .getDefaultInstance()
            : maintenanceWindow_;
      } else {
        return maintenanceWindowBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaintenanceWindow(
        com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow value) {
      if (maintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenanceWindow_ = value;
      } else {
        maintenanceWindowBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaintenanceWindow(
        com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow.Builder
            builderForValue) {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindow_ = builderForValue.build();
      } else {
        maintenanceWindowBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMaintenanceWindow(
        com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow value) {
      if (maintenanceWindowBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && maintenanceWindow_ != null
            && maintenanceWindow_
                != com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
                    .getDefaultInstance()) {
          getMaintenanceWindowBuilder().mergeFrom(value);
        } else {
          maintenanceWindow_ = value;
        }
      } else {
        maintenanceWindowBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMaintenanceWindow() {
      bitField0_ = (bitField0_ & ~0x00001000);
      maintenanceWindow_ = null;
      if (maintenanceWindowBuilder_ != null) {
        maintenanceWindowBuilder_.dispose();
        maintenanceWindowBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow.Builder
        getMaintenanceWindowBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getMaintenanceWindowFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindowOrBuilder
        getMaintenanceWindowOrBuilder() {
      if (maintenanceWindowBuilder_ != null) {
        return maintenanceWindowBuilder_.getMessageOrBuilder();
      } else {
        return maintenanceWindow_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow
                .getDefaultInstance()
            : maintenanceWindow_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maintenance window is the period when Cloud Composer
     * components may undergo maintenance. It is defined so that maintenance is
     * not executed during peak hours or critical time periods.
     *
     * The system will not be under maintenance for every occurrence of this
     * window, but when maintenance is planned, it will be scheduled
     * during the window.
     *
     * The maintenance window period must encompass at least 12 hours per week.
     * This may be split into multiple chunks, each with a size of
     * at least 4 hours.
     *
     * If this value is omitted, Cloud Composer components may be subject to
     * maintenance at any time.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow maintenance_window = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow,
            com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindowOrBuilder>
        getMaintenanceWindowFieldBuilder() {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow,
                com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindow.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.MaintenanceWindowOrBuilder>(
                getMaintenanceWindow(), getParentForChildren(), isClean());
        maintenanceWindow_ = null;
      }
      return maintenanceWindowBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloadsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfigOrBuilder>
        workloadsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the workloadsConfig field is set.
     */
    public boolean hasWorkloadsConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The workloadsConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
        getWorkloadsConfig() {
      if (workloadsConfigBuilder_ == null) {
        return workloadsConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .getDefaultInstance()
            : workloadsConfig_;
      } else {
        return workloadsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorkloadsConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig value) {
      if (workloadsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workloadsConfig_ = value;
      } else {
        workloadsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorkloadsConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder
            builderForValue) {
      if (workloadsConfigBuilder_ == null) {
        workloadsConfig_ = builderForValue.build();
      } else {
        workloadsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWorkloadsConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig value) {
      if (workloadsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && workloadsConfig_ != null
            && workloadsConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .getDefaultInstance()) {
          getWorkloadsConfigBuilder().mergeFrom(value);
        } else {
          workloadsConfig_ = value;
        }
      } else {
        workloadsConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWorkloadsConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      workloadsConfig_ = null;
      if (workloadsConfigBuilder_ != null) {
        workloadsConfigBuilder_.dispose();
        workloadsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder
        getWorkloadsConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getWorkloadsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfigOrBuilder
        getWorkloadsConfigOrBuilder() {
      if (workloadsConfigBuilder_ != null) {
        return workloadsConfigBuilder_.getMessageOrBuilder();
      } else {
        return workloadsConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .getDefaultInstance()
            : workloadsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The workloads configuration settings for the GKE cluster
     * associated with the Cloud Composer environment. The GKE cluster runs
     * Airflow scheduler, web server and workers workloads.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig workloads_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfigOrBuilder>
        getWorkloadsConfigFieldBuilder() {
      if (workloadsConfigBuilder_ == null) {
        workloadsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfigOrBuilder>(
                getWorkloadsConfig(), getParentForChildren(), isClean());
        workloadsConfig_ = null;
      }
      return workloadsConfigBuilder_;
    }

    private int environmentSize_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The size of the Cloud Composer environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for environmentSize.
     */
    @java.lang.Override
    public int getEnvironmentSizeValue() {
      return environmentSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The size of the Cloud Composer environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for environmentSize to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironmentSizeValue(int value) {
      environmentSize_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The size of the Cloud Composer environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The environmentSize.
     */
    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
        getEnvironmentSize() {
      com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
          result =
              com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
                  .EnvironmentSize.forNumber(environmentSize_);
      return result == null
          ? com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The size of the Cloud Composer environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The environmentSize to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironmentSize(
        com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      environmentSize_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The size of the Cloud Composer environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.EnvironmentSize environment_size = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnvironmentSize() {
      bitField0_ = (bitField0_ & ~0x00004000);
      environmentSize_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
        masterAuthorizedNetworksConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .MasterAuthorizedNetworksConfigOrBuilder>
        masterAuthorizedNetworksConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the masterAuthorizedNetworksConfig field is set.
     */
    public boolean hasMasterAuthorizedNetworksConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The masterAuthorizedNetworksConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
        getMasterAuthorizedNetworksConfig() {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        return masterAuthorizedNetworksConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
                .getDefaultInstance()
            : masterAuthorizedNetworksConfig_;
      } else {
        return masterAuthorizedNetworksConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMasterAuthorizedNetworksConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
            value) {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        masterAuthorizedNetworksConfig_ = value;
      } else {
        masterAuthorizedNetworksConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMasterAuthorizedNetworksConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
                .Builder
            builderForValue) {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        masterAuthorizedNetworksConfig_ = builderForValue.build();
      } else {
        masterAuthorizedNetworksConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMasterAuthorizedNetworksConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
            value) {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && masterAuthorizedNetworksConfig_ != null
            && masterAuthorizedNetworksConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1
                    .MasterAuthorizedNetworksConfig.getDefaultInstance()) {
          getMasterAuthorizedNetworksConfigBuilder().mergeFrom(value);
        } else {
          masterAuthorizedNetworksConfig_ = value;
        }
      } else {
        masterAuthorizedNetworksConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMasterAuthorizedNetworksConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      masterAuthorizedNetworksConfig_ = null;
      if (masterAuthorizedNetworksConfigBuilder_ != null) {
        masterAuthorizedNetworksConfigBuilder_.dispose();
        masterAuthorizedNetworksConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
            .Builder
        getMasterAuthorizedNetworksConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getMasterAuthorizedNetworksConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1
            .MasterAuthorizedNetworksConfigOrBuilder
        getMasterAuthorizedNetworksConfigOrBuilder() {
      if (masterAuthorizedNetworksConfigBuilder_ != null) {
        return masterAuthorizedNetworksConfigBuilder_.getMessageOrBuilder();
      } else {
        return masterAuthorizedNetworksConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
                .getDefaultInstance()
            : masterAuthorizedNetworksConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration options for GKE cluster master authorized
     * networks. By default master authorized networks feature is:
     * - in case of private environment: enabled with no external networks
     * allowlisted.
     * - in case of public environment: disabled.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.MasterAuthorizedNetworksConfig
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1
                .MasterAuthorizedNetworksConfigOrBuilder>
        getMasterAuthorizedNetworksConfigFieldBuilder() {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        masterAuthorizedNetworksConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .MasterAuthorizedNetworksConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .MasterAuthorizedNetworksConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .MasterAuthorizedNetworksConfigOrBuilder>(
                getMasterAuthorizedNetworksConfig(), getParentForChildren(), isClean());
        masterAuthorizedNetworksConfig_ = null;
      }
      return masterAuthorizedNetworksConfigBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recoveryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfigOrBuilder>
        recoveryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the recoveryConfig field is set.
     */
    public boolean hasRecoveryConfig() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The recoveryConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig
        getRecoveryConfig() {
      if (recoveryConfigBuilder_ == null) {
        return recoveryConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig
                .getDefaultInstance()
            : recoveryConfig_;
      } else {
        return recoveryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRecoveryConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig value) {
      if (recoveryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recoveryConfig_ = value;
      } else {
        recoveryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRecoveryConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.Builder
            builderForValue) {
      if (recoveryConfigBuilder_ == null) {
        recoveryConfig_ = builderForValue.build();
      } else {
        recoveryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRecoveryConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig value) {
      if (recoveryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && recoveryConfig_ != null
            && recoveryConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig
                    .getDefaultInstance()) {
          getRecoveryConfigBuilder().mergeFrom(value);
        } else {
          recoveryConfig_ = value;
        }
      } else {
        recoveryConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRecoveryConfig() {
      bitField0_ = (bitField0_ & ~0x00010000);
      recoveryConfig_ = null;
      if (recoveryConfigBuilder_ != null) {
        recoveryConfigBuilder_.dispose();
        recoveryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.Builder
        getRecoveryConfigBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getRecoveryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfigOrBuilder
        getRecoveryConfigOrBuilder() {
      if (recoveryConfigBuilder_ != null) {
        return recoveryConfigBuilder_.getMessageOrBuilder();
      } else {
        return recoveryConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig
                .getDefaultInstance()
            : recoveryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Recovery settings configuration of an environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig recovery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfigOrBuilder>
        getRecoveryConfigFieldBuilder() {
      if (recoveryConfigBuilder_ == null) {
        recoveryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.RecoveryConfigOrBuilder>(
                getRecoveryConfig(), getParentForChildren(), isClean());
        recoveryConfig_ = null;
      }
      return recoveryConfigBuilder_;
    }

    private int resilienceMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Resilience mode of the Cloud Composer Environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.2.0-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for resilienceMode.
     */
    @java.lang.Override
    public int getResilienceModeValue() {
      return resilienceMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resilience mode of the Cloud Composer Environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.2.0-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for resilienceMode to set.
     * @return This builder for chaining.
     */
    public Builder setResilienceModeValue(int value) {
      resilienceMode_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resilience mode of the Cloud Composer Environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.2.0-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The resilienceMode.
     */
    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
        getResilienceMode() {
      com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
          result =
              com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
                  .ResilienceMode.forNumber(resilienceMode_);
      return result == null
          ? com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resilience mode of the Cloud Composer Environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.2.0-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The resilienceMode to set.
     * @return This builder for chaining.
     */
    public Builder setResilienceMode(
        com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      resilienceMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resilience mode of the Cloud Composer Environment.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.2.0-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig.ResilienceMode resilience_mode = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResilienceMode() {
      bitField0_ = (bitField0_ & ~0x00020000);
      resilienceMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EnvironmentConfig> PARSER =
      new com.google.protobuf.AbstractParser<EnvironmentConfig>() {
        @java.lang.Override
        public EnvironmentConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EnvironmentConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EnvironmentConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
