/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Execute Airflow Command request.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest}
 */
public final class ExecuteAirflowCommandRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest)
    ExecuteAirflowCommandRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecuteAirflowCommandRequest.newBuilder() to construct.
  private ExecuteAirflowCommandRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecuteAirflowCommandRequest() {
    environment_ = "";
    command_ = "";
    subcommand_ = "";
    parameters_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecuteAirflowCommandRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_ExecuteAirflowCommandRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_ExecuteAirflowCommandRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
                .class,
            com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
                .Builder.class);
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object environment_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the environment in the form:
   * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
   * </pre>
   *
   * <code>string environment = 1;</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public java.lang.String getEnvironment() {
    java.lang.Object ref = environment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      environment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the environment in the form:
   * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
   * </pre>
   *
   * <code>string environment = 1;</code>
   *
   * @return The bytes for environment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnvironmentBytes() {
    java.lang.Object ref = environment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      environment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMAND_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object command_ = "";
  /**
   *
   *
   * <pre>
   * Airflow command.
   * </pre>
   *
   * <code>string command = 2;</code>
   *
   * @return The command.
   */
  @java.lang.Override
  public java.lang.String getCommand() {
    java.lang.Object ref = command_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      command_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Airflow command.
   * </pre>
   *
   * <code>string command = 2;</code>
   *
   * @return The bytes for command.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommandBytes() {
    java.lang.Object ref = command_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      command_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBCOMMAND_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subcommand_ = "";
  /**
   *
   *
   * <pre>
   * Airflow subcommand.
   * </pre>
   *
   * <code>string subcommand = 3;</code>
   *
   * @return The subcommand.
   */
  @java.lang.Override
  public java.lang.String getSubcommand() {
    java.lang.Object ref = subcommand_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subcommand_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Airflow subcommand.
   * </pre>
   *
   * <code>string subcommand = 3;</code>
   *
   * @return The bytes for subcommand.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubcommandBytes() {
    java.lang.Object ref = subcommand_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subcommand_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList parameters_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Parameters for the Airflow command/subcommand as an array of arguments.
   * It may contain positional arguments like `["my-dag-id"]`, key-value
   * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
   * or other flags like `["-f"]`.
   * </pre>
   *
   * <code>repeated string parameters = 4;</code>
   *
   * @return A list containing the parameters.
   */
  public com.google.protobuf.ProtocolStringList getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for the Airflow command/subcommand as an array of arguments.
   * It may contain positional arguments like `["my-dag-id"]`, key-value
   * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
   * or other flags like `["-f"]`.
   * </pre>
   *
   * <code>repeated string parameters = 4;</code>
   *
   * @return The count of parameters.
   */
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Parameters for the Airflow command/subcommand as an array of arguments.
   * It may contain positional arguments like `["my-dag-id"]`, key-value
   * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
   * or other flags like `["-f"]`.
   * </pre>
   *
   * <code>repeated string parameters = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The parameters at the given index.
   */
  public java.lang.String getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Parameters for the Airflow command/subcommand as an array of arguments.
   * It may contain positional arguments like `["my-dag-id"]`, key-value
   * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
   * or other flags like `["-f"]`.
   * </pre>
   *
   * <code>repeated string parameters = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the parameters at the given index.
   */
  public com.google.protobuf.ByteString getParametersBytes(int index) {
    return parameters_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(environment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, environment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(command_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, command_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subcommand_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, subcommand_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parameters_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(environment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, environment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(command_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, command_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subcommand_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, subcommand_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < parameters_.size(); i++) {
        dataSize += computeStringSizeNoTag(parameters_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getParametersList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest) obj;

    if (!getEnvironment().equals(other.getEnvironment())) return false;
    if (!getCommand().equals(other.getCommand())) return false;
    if (!getSubcommand().equals(other.getSubcommand())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + getEnvironment().hashCode();
    hash = (37 * hash) + COMMAND_FIELD_NUMBER;
    hash = (53 * hash) + getCommand().hashCode();
    hash = (37 * hash) + SUBCOMMAND_FIELD_NUMBER;
    hash = (53 * hash) + getSubcommand().hashCode();
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Execute Airflow Command request.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest)
      com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_ExecuteAirflowCommandRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_ExecuteAirflowCommandRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
                  .class,
              com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      environment_ = "";
      command_ = "";
      subcommand_ = "";
      parameters_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_ExecuteAirflowCommandRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
        build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
        buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest(
              this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
            result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.environment_ = environment_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.command_ = command_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.subcommand_ = subcommand_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        parameters_.makeImmutable();
        result.parameters_ = parameters_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
              .getDefaultInstance()) return this;
      if (!other.getEnvironment().isEmpty()) {
        environment_ = other.environment_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCommand().isEmpty()) {
        command_ = other.command_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSubcommand().isEmpty()) {
        subcommand_ = other.subcommand_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.parameters_.isEmpty()) {
        if (parameters_.isEmpty()) {
          parameters_ = other.parameters_;
          bitField0_ |= 0x00000008;
        } else {
          ensureParametersIsMutable();
          parameters_.addAll(other.parameters_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                environment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                command_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                subcommand_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureParametersIsMutable();
                parameters_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object environment_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the environment in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
     * </pre>
     *
     * <code>string environment = 1;</code>
     *
     * @return The environment.
     */
    public java.lang.String getEnvironment() {
      java.lang.Object ref = environment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        environment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the environment in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
     * </pre>
     *
     * <code>string environment = 1;</code>
     *
     * @return The bytes for environment.
     */
    public com.google.protobuf.ByteString getEnvironmentBytes() {
      java.lang.Object ref = environment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        environment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the environment in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
     * </pre>
     *
     * <code>string environment = 1;</code>
     *
     * @param value The environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      environment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the environment in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
     * </pre>
     *
     * <code>string environment = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnvironment() {
      environment_ = getDefaultInstance().getEnvironment();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the environment in the form:
     * "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
     * </pre>
     *
     * <code>string environment = 1;</code>
     *
     * @param value The bytes for environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      environment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object command_ = "";
    /**
     *
     *
     * <pre>
     * Airflow command.
     * </pre>
     *
     * <code>string command = 2;</code>
     *
     * @return The command.
     */
    public java.lang.String getCommand() {
      java.lang.Object ref = command_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        command_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Airflow command.
     * </pre>
     *
     * <code>string command = 2;</code>
     *
     * @return The bytes for command.
     */
    public com.google.protobuf.ByteString getCommandBytes() {
      java.lang.Object ref = command_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        command_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Airflow command.
     * </pre>
     *
     * <code>string command = 2;</code>
     *
     * @param value The command to set.
     * @return This builder for chaining.
     */
    public Builder setCommand(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      command_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Airflow command.
     * </pre>
     *
     * <code>string command = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommand() {
      command_ = getDefaultInstance().getCommand();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Airflow command.
     * </pre>
     *
     * <code>string command = 2;</code>
     *
     * @param value The bytes for command to set.
     * @return This builder for chaining.
     */
    public Builder setCommandBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      command_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object subcommand_ = "";
    /**
     *
     *
     * <pre>
     * Airflow subcommand.
     * </pre>
     *
     * <code>string subcommand = 3;</code>
     *
     * @return The subcommand.
     */
    public java.lang.String getSubcommand() {
      java.lang.Object ref = subcommand_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subcommand_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Airflow subcommand.
     * </pre>
     *
     * <code>string subcommand = 3;</code>
     *
     * @return The bytes for subcommand.
     */
    public com.google.protobuf.ByteString getSubcommandBytes() {
      java.lang.Object ref = subcommand_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subcommand_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Airflow subcommand.
     * </pre>
     *
     * <code>string subcommand = 3;</code>
     *
     * @param value The subcommand to set.
     * @return This builder for chaining.
     */
    public Builder setSubcommand(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subcommand_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Airflow subcommand.
     * </pre>
     *
     * <code>string subcommand = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubcommand() {
      subcommand_ = getDefaultInstance().getSubcommand();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Airflow subcommand.
     * </pre>
     *
     * <code>string subcommand = 3;</code>
     *
     * @param value The bytes for subcommand to set.
     * @return This builder for chaining.
     */
    public Builder setSubcommandBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subcommand_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList parameters_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureParametersIsMutable() {
      if (!parameters_.isModifiable()) {
        parameters_ = new com.google.protobuf.LazyStringArrayList(parameters_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @return A list containing the parameters.
     */
    public com.google.protobuf.ProtocolStringList getParametersList() {
      parameters_.makeImmutable();
      return parameters_;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @return The count of parameters.
     */
    public int getParametersCount() {
      return parameters_.size();
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The parameters at the given index.
     */
    public java.lang.String getParameters(int index) {
      return parameters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the parameters at the given index.
     */
    public com.google.protobuf.ByteString getParametersBytes(int index) {
      return parameters_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The parameters to set.
     * @return This builder for chaining.
     */
    public Builder setParameters(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureParametersIsMutable();
      parameters_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @param value The parameters to add.
     * @return This builder for chaining.
     */
    public Builder addParameters(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureParametersIsMutable();
      parameters_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @param values The parameters to add.
     * @return This builder for chaining.
     */
    public Builder addAllParameters(java.lang.Iterable<java.lang.String> values) {
      ensureParametersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParameters() {
      parameters_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the Airflow command/subcommand as an array of arguments.
     * It may contain positional arguments like `["my-dag-id"]`, key-value
     * parameters like `["--foo=bar"]` or `["--foo","bar"]`,
     * or other flags like `["-f"]`.
     * </pre>
     *
     * <code>repeated string parameters = 4;</code>
     *
     * @param value The bytes of the parameters to add.
     * @return This builder for chaining.
     */
    public Builder addParametersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureParametersIsMutable();
      parameters_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1
          .ExecuteAirflowCommandRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecuteAirflowCommandRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExecuteAirflowCommandRequest>() {
        @java.lang.Override
        public ExecuteAirflowCommandRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecuteAirflowCommandRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecuteAirflowCommandRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.ExecuteAirflowCommandRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
