/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for controlling how IPs are allocated in the
 * GKE cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy}
 */
public final class IPAllocationPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy)
    IPAllocationPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IPAllocationPolicy.newBuilder() to construct.
  private IPAllocationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IPAllocationPolicy() {
    clusterSecondaryRangeName_ = "";
    servicesSecondaryRangeName_ = "";
    clusterIpv4CidrBlock_ = "";
    servicesIpv4CidrBlock_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IPAllocationPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_IPAllocationPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_IPAllocationPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy.Builder
                .class);
  }

  public static final int USE_IP_ALIASES_FIELD_NUMBER = 1;
  private boolean useIpAliases_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether or not to enable Alias IPs in the GKE cluster.
   * If `true`, a VPC-native cluster is created.
   *
   * This field is only supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
   * VPC-native GKE clusters.
   * </pre>
   *
   * <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The useIpAliases.
   */
  @java.lang.Override
  public boolean getUseIpAliases() {
    return useIpAliases_;
  }

  public static final int CLUSTER_SECONDARY_RANGE_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterSecondaryRangeName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the cluster's secondary range used to allocate
   * IP addresses to pods. Specify either `cluster_secondary_range_name`
   * or `cluster_ipv4_cidr_block` but not both.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   * </pre>
   *
   * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The clusterSecondaryRangeName.
   */
  @java.lang.Override
  public java.lang.String getClusterSecondaryRangeName() {
    java.lang.Object ref = clusterSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterSecondaryRangeName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the cluster's secondary range used to allocate
   * IP addresses to pods. Specify either `cluster_secondary_range_name`
   * or `cluster_ipv4_cidr_block` but not both.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   * </pre>
   *
   * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for clusterSecondaryRangeName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterSecondaryRangeNameBytes() {
    java.lang.Object ref = clusterSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterSecondaryRangeName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICES_SECONDARY_RANGE_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesSecondaryRangeName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the services' secondary range used to allocate
   * IP addresses to the cluster. Specify either `services_secondary_range_name`
   * or `services_ipv4_cidr_block` but not both.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   * </pre>
   *
   * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The servicesSecondaryRangeName.
   */
  @java.lang.Override
  public java.lang.String getServicesSecondaryRangeName() {
    java.lang.Object ref = servicesSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesSecondaryRangeName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the services' secondary range used to allocate
   * IP addresses to the cluster. Specify either `services_secondary_range_name`
   * or `services_ipv4_cidr_block` but not both.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   * </pre>
   *
   * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for servicesSecondaryRangeName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServicesSecondaryRangeNameBytes() {
    java.lang.Object ref = servicesSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesSecondaryRangeName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_IPV4_CIDR_BLOCK_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The IP address range used to allocate IP addresses to pods in
   * the cluster.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   *
   * Set to blank to have GKE choose a range with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
   * but not both.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The clusterIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getClusterIpv4CidrBlock() {
    java.lang.Object ref = clusterIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The IP address range used to allocate IP addresses to pods in
   * the cluster.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   *
   * Set to blank to have GKE choose a range with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
   * but not both.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for clusterIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterIpv4CidrBlockBytes() {
    java.lang.Object ref = clusterIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICES_IPV4_CIDR_BLOCK_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The IP address range of the services IP addresses in this
   * cluster.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   *
   * Set to blank to have GKE choose a range with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
   * but not both.
   * </pre>
   *
   * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The servicesIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getServicesIpv4CidrBlock() {
    java.lang.Object ref = servicesIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The IP address range of the services IP addresses in this
   * cluster.
   *
   * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
   * this field is applicable only when `use_ip_aliases` is true.
   *
   * Set to blank to have GKE choose a range with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
   * but not both.
   * </pre>
   *
   * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for servicesIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServicesIpv4CidrBlockBytes() {
    java.lang.Object ref = servicesIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (useIpAliases_ != false) {
      output.writeBool(1, useIpAliases_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterSecondaryRangeName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesSecondaryRangeName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, servicesSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, clusterIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, servicesIpv4CidrBlock_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (useIpAliases_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useIpAliases_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterSecondaryRangeName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesSecondaryRangeName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(3, servicesSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, clusterIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, servicesIpv4CidrBlock_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy) obj;

    if (getUseIpAliases() != other.getUseIpAliases()) return false;
    if (!getClusterSecondaryRangeName().equals(other.getClusterSecondaryRangeName())) return false;
    if (!getServicesSecondaryRangeName().equals(other.getServicesSecondaryRangeName()))
      return false;
    if (!getClusterIpv4CidrBlock().equals(other.getClusterIpv4CidrBlock())) return false;
    if (!getServicesIpv4CidrBlock().equals(other.getServicesIpv4CidrBlock())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USE_IP_ALIASES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseIpAliases());
    hash = (37 * hash) + CLUSTER_SECONDARY_RANGE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterSecondaryRangeName().hashCode();
    hash = (37 * hash) + SERVICES_SECONDARY_RANGE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServicesSecondaryRangeName().hashCode();
    hash = (37 * hash) + CLUSTER_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getClusterIpv4CidrBlock().hashCode();
    hash = (37 * hash) + SERVICES_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getServicesIpv4CidrBlock().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for controlling how IPs are allocated in the
   * GKE cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy)
      com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_IPAllocationPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_IPAllocationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      useIpAliases_ = false;
      clusterSecondaryRangeName_ = "";
      servicesSecondaryRangeName_ = "";
      clusterIpv4CidrBlock_ = "";
      servicesIpv4CidrBlock_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_IPAllocationPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
        buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.useIpAliases_ = useIpAliases_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.clusterSecondaryRangeName_ = clusterSecondaryRangeName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.servicesSecondaryRangeName_ = servicesSecondaryRangeName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.clusterIpv4CidrBlock_ = clusterIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.servicesIpv4CidrBlock_ = servicesIpv4CidrBlock_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
              .getDefaultInstance()) return this;
      if (other.getUseIpAliases() != false) {
        setUseIpAliases(other.getUseIpAliases());
      }
      if (!other.getClusterSecondaryRangeName().isEmpty()) {
        clusterSecondaryRangeName_ = other.clusterSecondaryRangeName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getServicesSecondaryRangeName().isEmpty()) {
        servicesSecondaryRangeName_ = other.servicesSecondaryRangeName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getClusterIpv4CidrBlock().isEmpty()) {
        clusterIpv4CidrBlock_ = other.clusterIpv4CidrBlock_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getServicesIpv4CidrBlock().isEmpty()) {
        servicesIpv4CidrBlock_ = other.servicesIpv4CidrBlock_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                useIpAliases_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                clusterSecondaryRangeName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                servicesSecondaryRangeName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                clusterIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                servicesIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean useIpAliases_;
    /**
     *
     *
     * <pre>
     * Optional. Whether or not to enable Alias IPs in the GKE cluster.
     * If `true`, a VPC-native cluster is created.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * VPC-native GKE clusters.
     * </pre>
     *
     * <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The useIpAliases.
     */
    @java.lang.Override
    public boolean getUseIpAliases() {
      return useIpAliases_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not to enable Alias IPs in the GKE cluster.
     * If `true`, a VPC-native cluster is created.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * VPC-native GKE clusters.
     * </pre>
     *
     * <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The useIpAliases to set.
     * @return This builder for chaining.
     */
    public Builder setUseIpAliases(boolean value) {

      useIpAliases_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether or not to enable Alias IPs in the GKE cluster.
     * If `true`, a VPC-native cluster is created.
     *
     * This field is only supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
     * VPC-native GKE clusters.
     * </pre>
     *
     * <code>bool use_ip_aliases = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseIpAliases() {
      bitField0_ = (bitField0_ & ~0x00000001);
      useIpAliases_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object clusterSecondaryRangeName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the cluster's secondary range used to allocate
     * IP addresses to pods. Specify either `cluster_secondary_range_name`
     * or `cluster_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The clusterSecondaryRangeName.
     */
    public java.lang.String getClusterSecondaryRangeName() {
      java.lang.Object ref = clusterSecondaryRangeName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterSecondaryRangeName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the cluster's secondary range used to allocate
     * IP addresses to pods. Specify either `cluster_secondary_range_name`
     * or `cluster_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for clusterSecondaryRangeName.
     */
    public com.google.protobuf.ByteString getClusterSecondaryRangeNameBytes() {
      java.lang.Object ref = clusterSecondaryRangeName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterSecondaryRangeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the cluster's secondary range used to allocate
     * IP addresses to pods. Specify either `cluster_secondary_range_name`
     * or `cluster_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The clusterSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterSecondaryRangeName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterSecondaryRangeName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the cluster's secondary range used to allocate
     * IP addresses to pods. Specify either `cluster_secondary_range_name`
     * or `cluster_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterSecondaryRangeName() {
      clusterSecondaryRangeName_ = getDefaultInstance().getClusterSecondaryRangeName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the cluster's secondary range used to allocate
     * IP addresses to pods. Specify either `cluster_secondary_range_name`
     * or `cluster_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for clusterSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterSecondaryRangeNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterSecondaryRangeName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object servicesSecondaryRangeName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the cluster. Specify either `services_secondary_range_name`
     * or `services_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The servicesSecondaryRangeName.
     */
    public java.lang.String getServicesSecondaryRangeName() {
      java.lang.Object ref = servicesSecondaryRangeName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesSecondaryRangeName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the cluster. Specify either `services_secondary_range_name`
     * or `services_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for servicesSecondaryRangeName.
     */
    public com.google.protobuf.ByteString getServicesSecondaryRangeNameBytes() {
      java.lang.Object ref = servicesSecondaryRangeName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesSecondaryRangeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the cluster. Specify either `services_secondary_range_name`
     * or `services_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The servicesSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setServicesSecondaryRangeName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesSecondaryRangeName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the cluster. Specify either `services_secondary_range_name`
     * or `services_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesSecondaryRangeName() {
      servicesSecondaryRangeName_ = getDefaultInstance().getServicesSecondaryRangeName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the services' secondary range used to allocate
     * IP addresses to the cluster. Specify either `services_secondary_range_name`
     * or `services_ipv4_cidr_block` but not both.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>string services_secondary_range_name = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for servicesSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setServicesSecondaryRangeNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesSecondaryRangeName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object clusterIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The clusterIpv4CidrBlock.
     */
    public java.lang.String getClusterIpv4CidrBlock() {
      java.lang.Object ref = clusterIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for clusterIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getClusterIpv4CidrBlockBytes() {
      java.lang.Object ref = clusterIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The clusterIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterIpv4CidrBlock() {
      clusterIpv4CidrBlock_ = getDefaultInstance().getClusterIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range used to allocate IP addresses to pods in
     * the cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for clusterIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object servicesIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The IP address range of the services IP addresses in this
     * cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The servicesIpv4CidrBlock.
     */
    public java.lang.String getServicesIpv4CidrBlock() {
      java.lang.Object ref = servicesIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range of the services IP addresses in this
     * cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for servicesIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getServicesIpv4CidrBlockBytes() {
      java.lang.Object ref = servicesIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range of the services IP addresses in this
     * cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The servicesIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range of the services IP addresses in this
     * cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesIpv4CidrBlock() {
      servicesIpv4CidrBlock_ = getDefaultInstance().getServicesIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address range of the services IP addresses in this
     * cluster.
     *
     * For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
     * this field is applicable only when `use_ip_aliases` is true.
     *
     * Set to blank to have GKE choose a range with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * Specify `services_secondary_range_name` or `services_ipv4_cidr_block`
     * but not both.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for servicesIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IPAllocationPolicy> PARSER =
      new com.google.protobuf.AbstractParser<IPAllocationPolicy>() {
        @java.lang.Override
        public IPAllocationPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IPAllocationPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IPAllocationPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.IPAllocationPolicy
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
