/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * The configuration information for configuring a Private IP Cloud Composer
 * environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig}
 */
public final class PrivateEnvironmentConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig)
    PrivateEnvironmentConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PrivateEnvironmentConfig.newBuilder() to construct.
  private PrivateEnvironmentConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrivateEnvironmentConfig() {
    webServerIpv4CidrBlock_ = "";
    cloudSqlIpv4CidrBlock_ = "";
    webServerIpv4ReservedRange_ = "";
    cloudComposerNetworkIpv4CidrBlock_ = "";
    cloudComposerNetworkIpv4ReservedRange_ = "";
    cloudComposerConnectionSubnetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrivateEnvironmentConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_PrivateEnvironmentConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_PrivateEnvironmentConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.Builder
                .class);
  }

  public static final int ENABLE_PRIVATE_ENVIRONMENT_FIELD_NUMBER = 1;
  private boolean enablePrivateEnvironment_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If `true`, a Private IP Cloud Composer environment is created.
   * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
   * set to true for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enablePrivateEnvironment.
   */
  @java.lang.Override
  public boolean getEnablePrivateEnvironment() {
    return enablePrivateEnvironment_;
  }

  public static final int PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
      privateClusterConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the private GKE cluster for a Private IP
   * Cloud Composer environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateClusterConfig() {
    return privateClusterConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the private GKE cluster for a Private IP
   * Cloud Composer environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateClusterConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
      getPrivateClusterConfig() {
    return privateClusterConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
            .getDefaultInstance()
        : privateClusterConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the private GKE cluster for a Private IP
   * Cloud Composer environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfigOrBuilder
      getPrivateClusterConfigOrBuilder() {
    return privateClusterConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
            .getDefaultInstance()
        : privateClusterConfig_;
  }

  public static final int WEB_SERVER_IPV4_CIDR_BLOCK_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object webServerIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The CIDR block from which IP range for web server will be
   * reserved. Needs to be disjoint from
   * private_cluster_config.master_ipv4_cidr_block and
   * cloud_sql_ipv4_cidr_block.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The webServerIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getWebServerIpv4CidrBlock() {
    java.lang.Object ref = webServerIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webServerIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The CIDR block from which IP range for web server will be
   * reserved. Needs to be disjoint from
   * private_cluster_config.master_ipv4_cidr_block and
   * cloud_sql_ipv4_cidr_block.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for webServerIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebServerIpv4CidrBlockBytes() {
    java.lang.Object ref = webServerIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webServerIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_SQL_IPV4_CIDR_BLOCK_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudSqlIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The CIDR block from which IP range in tenant project will be
   * reserved for Cloud SQL. Needs to be disjoint from
   * web_server_ipv4_cidr_block
   * </pre>
   *
   * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The cloudSqlIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getCloudSqlIpv4CidrBlock() {
    java.lang.Object ref = cloudSqlIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudSqlIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The CIDR block from which IP range in tenant project will be
   * reserved for Cloud SQL. Needs to be disjoint from
   * web_server_ipv4_cidr_block
   * </pre>
   *
   * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for cloudSqlIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudSqlIpv4CidrBlockBytes() {
    java.lang.Object ref = cloudSqlIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudSqlIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEB_SERVER_IPV4_RESERVED_RANGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object webServerIpv4ReservedRange_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The IP range reserved for the tenant project's App Engine VMs.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The webServerIpv4ReservedRange.
   */
  @java.lang.Override
  public java.lang.String getWebServerIpv4ReservedRange() {
    java.lang.Object ref = webServerIpv4ReservedRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webServerIpv4ReservedRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The IP range reserved for the tenant project's App Engine VMs.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-1.*.*-airflow-*.*.*.
   * </pre>
   *
   * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for webServerIpv4ReservedRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebServerIpv4ReservedRangeBytes() {
    java.lang.Object ref = webServerIpv4ReservedRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webServerIpv4ReservedRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_COMPOSER_NETWORK_IPV4_CIDR_BLOCK_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudComposerNetworkIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The CIDR block from which IP range for Cloud Composer Network in
   * tenant project will be reserved. Needs to be disjoint from
   * private_cluster_config.master_ipv4_cidr_block and
   * cloud_sql_ipv4_cidr_block.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudComposerNetworkIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getCloudComposerNetworkIpv4CidrBlock() {
    java.lang.Object ref = cloudComposerNetworkIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudComposerNetworkIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The CIDR block from which IP range for Cloud Composer Network in
   * tenant project will be reserved. Needs to be disjoint from
   * private_cluster_config.master_ipv4_cidr_block and
   * cloud_sql_ipv4_cidr_block.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for cloudComposerNetworkIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudComposerNetworkIpv4CidrBlockBytes() {
    java.lang.Object ref = cloudComposerNetworkIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudComposerNetworkIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_COMPOSER_NETWORK_IPV4_RESERVED_RANGE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudComposerNetworkIpv4ReservedRange_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The IP range reserved for the tenant project's Cloud Composer
   * network.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The cloudComposerNetworkIpv4ReservedRange.
   */
  @java.lang.Override
  public java.lang.String getCloudComposerNetworkIpv4ReservedRange() {
    java.lang.Object ref = cloudComposerNetworkIpv4ReservedRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudComposerNetworkIpv4ReservedRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The IP range reserved for the tenant project's Cloud Composer
   * network.
   *
   * This field is supported for Cloud Composer environments in versions
   * composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * <code>
   * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for cloudComposerNetworkIpv4ReservedRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudComposerNetworkIpv4ReservedRangeBytes() {
    java.lang.Object ref = cloudComposerNetworkIpv4ReservedRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudComposerNetworkIpv4ReservedRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_PRIVATELY_USED_PUBLIC_IPS_FIELD_NUMBER = 6;
  private boolean enablePrivatelyUsedPublicIps_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
   * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
   * `IPAllocationPolicy.service_ipv4_cidr_block`.
   * </pre>
   *
   * <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enablePrivatelyUsedPublicIps.
   */
  @java.lang.Override
  public boolean getEnablePrivatelyUsedPublicIps() {
    return enablePrivatelyUsedPublicIps_;
  }

  public static final int CLOUD_COMPOSER_CONNECTION_SUBNETWORK_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudComposerConnectionSubnetwork_ = "";
  /**
   *
   *
   * <pre>
   * Optional. When specified, the environment will use Private Service Connect
   * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
   * and the PSC endpoint in the Customer Project will use an IP address from
   * this subnetwork.
   * </pre>
   *
   * <code>
   * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudComposerConnectionSubnetwork.
   */
  @java.lang.Override
  public java.lang.String getCloudComposerConnectionSubnetwork() {
    java.lang.Object ref = cloudComposerConnectionSubnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudComposerConnectionSubnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. When specified, the environment will use Private Service Connect
   * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
   * and the PSC endpoint in the Customer Project will use an IP address from
   * this subnetwork.
   * </pre>
   *
   * <code>
   * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for cloudComposerConnectionSubnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudComposerConnectionSubnetworkBytes() {
    java.lang.Object ref = cloudComposerConnectionSubnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudComposerConnectionSubnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORKING_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networkingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the network connections configuration in the
   * environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the networkingConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkingConfig() {
    return networkingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the network connections configuration in the
   * environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The networkingConfig.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
      getNetworkingConfig() {
    return networkingConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
            .getDefaultInstance()
        : networkingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the network connections configuration in the
   * environment.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfigOrBuilder
      getNetworkingConfigOrBuilder() {
    return networkingConfig_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
            .getDefaultInstance()
        : networkingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enablePrivateEnvironment_ != false) {
      output.writeBool(1, enablePrivateEnvironment_);
    }
    if (privateClusterConfig_ != null) {
      output.writeMessage(2, getPrivateClusterConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webServerIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, webServerIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, cloudSqlIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webServerIpv4ReservedRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, webServerIpv4ReservedRange_);
    }
    if (enablePrivatelyUsedPublicIps_ != false) {
      output.writeBool(6, enablePrivatelyUsedPublicIps_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudComposerNetworkIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 7, cloudComposerNetworkIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(
        cloudComposerNetworkIpv4ReservedRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 8, cloudComposerNetworkIpv4ReservedRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudComposerConnectionSubnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 9, cloudComposerConnectionSubnetwork_);
    }
    if (networkingConfig_ != null) {
      output.writeMessage(10, getNetworkingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enablePrivateEnvironment_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enablePrivateEnvironment_);
    }
    if (privateClusterConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPrivateClusterConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webServerIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, webServerIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, cloudSqlIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webServerIpv4ReservedRange_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(5, webServerIpv4ReservedRange_);
    }
    if (enablePrivatelyUsedPublicIps_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(6, enablePrivatelyUsedPublicIps_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudComposerNetworkIpv4CidrBlock_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              7, cloudComposerNetworkIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(
        cloudComposerNetworkIpv4ReservedRange_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              8, cloudComposerNetworkIpv4ReservedRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudComposerConnectionSubnetwork_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              9, cloudComposerConnectionSubnetwork_);
    }
    if (networkingConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getNetworkingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig) obj;

    if (getEnablePrivateEnvironment() != other.getEnablePrivateEnvironment()) return false;
    if (hasPrivateClusterConfig() != other.hasPrivateClusterConfig()) return false;
    if (hasPrivateClusterConfig()) {
      if (!getPrivateClusterConfig().equals(other.getPrivateClusterConfig())) return false;
    }
    if (!getWebServerIpv4CidrBlock().equals(other.getWebServerIpv4CidrBlock())) return false;
    if (!getCloudSqlIpv4CidrBlock().equals(other.getCloudSqlIpv4CidrBlock())) return false;
    if (!getWebServerIpv4ReservedRange().equals(other.getWebServerIpv4ReservedRange()))
      return false;
    if (!getCloudComposerNetworkIpv4CidrBlock()
        .equals(other.getCloudComposerNetworkIpv4CidrBlock())) return false;
    if (!getCloudComposerNetworkIpv4ReservedRange()
        .equals(other.getCloudComposerNetworkIpv4ReservedRange())) return false;
    if (getEnablePrivatelyUsedPublicIps() != other.getEnablePrivatelyUsedPublicIps()) return false;
    if (!getCloudComposerConnectionSubnetwork()
        .equals(other.getCloudComposerConnectionSubnetwork())) return false;
    if (hasNetworkingConfig() != other.hasNetworkingConfig()) return false;
    if (hasNetworkingConfig()) {
      if (!getNetworkingConfig().equals(other.getNetworkingConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLE_PRIVATE_ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateEnvironment());
    if (hasPrivateClusterConfig()) {
      hash = (37 * hash) + PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateClusterConfig().hashCode();
    }
    hash = (37 * hash) + WEB_SERVER_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getWebServerIpv4CidrBlock().hashCode();
    hash = (37 * hash) + CLOUD_SQL_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getCloudSqlIpv4CidrBlock().hashCode();
    hash = (37 * hash) + WEB_SERVER_IPV4_RESERVED_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getWebServerIpv4ReservedRange().hashCode();
    hash = (37 * hash) + CLOUD_COMPOSER_NETWORK_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getCloudComposerNetworkIpv4CidrBlock().hashCode();
    hash = (37 * hash) + CLOUD_COMPOSER_NETWORK_IPV4_RESERVED_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getCloudComposerNetworkIpv4ReservedRange().hashCode();
    hash = (37 * hash) + ENABLE_PRIVATELY_USED_PUBLIC_IPS_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivatelyUsedPublicIps());
    hash = (37 * hash) + CLOUD_COMPOSER_CONNECTION_SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getCloudComposerConnectionSubnetwork().hashCode();
    if (hasNetworkingConfig()) {
      hash = (37 * hash) + NETWORKING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkingConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration information for configuring a Private IP Cloud Composer
   * environment.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig)
      com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_PrivateEnvironmentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_PrivateEnvironmentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enablePrivateEnvironment_ = false;
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      webServerIpv4CidrBlock_ = "";
      cloudSqlIpv4CidrBlock_ = "";
      webServerIpv4ReservedRange_ = "";
      cloudComposerNetworkIpv4CidrBlock_ = "";
      cloudComposerNetworkIpv4ReservedRange_ = "";
      enablePrivatelyUsedPublicIps_ = false;
      cloudComposerConnectionSubnetwork_ = "";
      networkingConfig_ = null;
      if (networkingConfigBuilder_ != null) {
        networkingConfigBuilder_.dispose();
        networkingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_PrivateEnvironmentConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
        buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enablePrivateEnvironment_ = enablePrivateEnvironment_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.privateClusterConfig_ =
            privateClusterConfigBuilder_ == null
                ? privateClusterConfig_
                : privateClusterConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.webServerIpv4CidrBlock_ = webServerIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cloudSqlIpv4CidrBlock_ = cloudSqlIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.webServerIpv4ReservedRange_ = webServerIpv4ReservedRange_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cloudComposerNetworkIpv4CidrBlock_ = cloudComposerNetworkIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cloudComposerNetworkIpv4ReservedRange_ = cloudComposerNetworkIpv4ReservedRange_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enablePrivatelyUsedPublicIps_ = enablePrivatelyUsedPublicIps_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.cloudComposerConnectionSubnetwork_ = cloudComposerConnectionSubnetwork_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.networkingConfig_ =
            networkingConfigBuilder_ == null ? networkingConfig_ : networkingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
              .getDefaultInstance()) return this;
      if (other.getEnablePrivateEnvironment() != false) {
        setEnablePrivateEnvironment(other.getEnablePrivateEnvironment());
      }
      if (other.hasPrivateClusterConfig()) {
        mergePrivateClusterConfig(other.getPrivateClusterConfig());
      }
      if (!other.getWebServerIpv4CidrBlock().isEmpty()) {
        webServerIpv4CidrBlock_ = other.webServerIpv4CidrBlock_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCloudSqlIpv4CidrBlock().isEmpty()) {
        cloudSqlIpv4CidrBlock_ = other.cloudSqlIpv4CidrBlock_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getWebServerIpv4ReservedRange().isEmpty()) {
        webServerIpv4ReservedRange_ = other.webServerIpv4ReservedRange_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getCloudComposerNetworkIpv4CidrBlock().isEmpty()) {
        cloudComposerNetworkIpv4CidrBlock_ = other.cloudComposerNetworkIpv4CidrBlock_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getCloudComposerNetworkIpv4ReservedRange().isEmpty()) {
        cloudComposerNetworkIpv4ReservedRange_ = other.cloudComposerNetworkIpv4ReservedRange_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getEnablePrivatelyUsedPublicIps() != false) {
        setEnablePrivatelyUsedPublicIps(other.getEnablePrivatelyUsedPublicIps());
      }
      if (!other.getCloudComposerConnectionSubnetwork().isEmpty()) {
        cloudComposerConnectionSubnetwork_ = other.cloudComposerConnectionSubnetwork_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasNetworkingConfig()) {
        mergeNetworkingConfig(other.getNetworkingConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enablePrivateEnvironment_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getPrivateClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                webServerIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                cloudSqlIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                webServerIpv4ReservedRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                enablePrivatelyUsedPublicIps_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 48
            case 58:
              {
                cloudComposerNetworkIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                cloudComposerNetworkIpv4ReservedRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                cloudComposerConnectionSubnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getNetworkingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enablePrivateEnvironment_;
    /**
     *
     *
     * <pre>
     * Optional. If `true`, a Private IP Cloud Composer environment is created.
     * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     * set to true for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enablePrivateEnvironment.
     */
    @java.lang.Override
    public boolean getEnablePrivateEnvironment() {
      return enablePrivateEnvironment_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `true`, a Private IP Cloud Composer environment is created.
     * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     * set to true for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enablePrivateEnvironment to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePrivateEnvironment(boolean value) {

      enablePrivateEnvironment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `true`, a Private IP Cloud Composer environment is created.
     * If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
     * set to true for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>bool enable_private_environment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePrivateEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enablePrivateEnvironment_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
        privateClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfigOrBuilder>
        privateClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateClusterConfig field is set.
     */
    public boolean hasPrivateClusterConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateClusterConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
        getPrivateClusterConfig() {
      if (privateClusterConfigBuilder_ == null) {
        return privateClusterConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
                .getDefaultInstance()
            : privateClusterConfig_;
      } else {
        return privateClusterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateClusterConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateClusterConfig_ = value;
      } else {
        privateClusterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateClusterConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig.Builder
            builderForValue) {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfig_ = builderForValue.build();
      } else {
        privateClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivateClusterConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && privateClusterConfig_ != null
            && privateClusterConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
                    .getDefaultInstance()) {
          getPrivateClusterConfigBuilder().mergeFrom(value);
        } else {
          privateClusterConfig_ = value;
        }
      } else {
        privateClusterConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivateClusterConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig.Builder
        getPrivateClusterConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPrivateClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfigOrBuilder
        getPrivateClusterConfigOrBuilder() {
      if (privateClusterConfigBuilder_ != null) {
        return privateClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateClusterConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig
                .getDefaultInstance()
            : privateClusterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the private GKE cluster for a Private IP
     * Cloud Composer environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig private_cluster_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfigOrBuilder>
        getPrivateClusterConfigFieldBuilder() {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.PrivateClusterConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1
                    .PrivateClusterConfigOrBuilder>(
                getPrivateClusterConfig(), getParentForChildren(), isClean());
        privateClusterConfig_ = null;
      }
      return privateClusterConfigBuilder_;
    }

    private java.lang.Object webServerIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The webServerIpv4CidrBlock.
     */
    public java.lang.String getWebServerIpv4CidrBlock() {
      java.lang.Object ref = webServerIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webServerIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for webServerIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getWebServerIpv4CidrBlockBytes() {
      java.lang.Object ref = webServerIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webServerIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The webServerIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setWebServerIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      webServerIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebServerIpv4CidrBlock() {
      webServerIpv4CidrBlock_ = getDefaultInstance().getWebServerIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for web server will be
     * reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_cidr_block = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for webServerIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setWebServerIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      webServerIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object cloudSqlIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * web_server_ipv4_cidr_block
     * </pre>
     *
     * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cloudSqlIpv4CidrBlock.
     */
    public java.lang.String getCloudSqlIpv4CidrBlock() {
      java.lang.Object ref = cloudSqlIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudSqlIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * web_server_ipv4_cidr_block
     * </pre>
     *
     * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for cloudSqlIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getCloudSqlIpv4CidrBlockBytes() {
      java.lang.Object ref = cloudSqlIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudSqlIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * web_server_ipv4_cidr_block
     * </pre>
     *
     * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The cloudSqlIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudSqlIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * web_server_ipv4_cidr_block
     * </pre>
     *
     * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudSqlIpv4CidrBlock() {
      cloudSqlIpv4CidrBlock_ = getDefaultInstance().getCloudSqlIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range in tenant project will be
     * reserved for Cloud SQL. Needs to be disjoint from
     * web_server_ipv4_cidr_block
     * </pre>
     *
     * <code>string cloud_sql_ipv4_cidr_block = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for cloudSqlIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudSqlIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object webServerIpv4ReservedRange_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The webServerIpv4ReservedRange.
     */
    public java.lang.String getWebServerIpv4ReservedRange() {
      java.lang.Object ref = webServerIpv4ReservedRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webServerIpv4ReservedRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for webServerIpv4ReservedRange.
     */
    public com.google.protobuf.ByteString getWebServerIpv4ReservedRangeBytes() {
      java.lang.Object ref = webServerIpv4ReservedRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webServerIpv4ReservedRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The webServerIpv4ReservedRange to set.
     * @return This builder for chaining.
     */
    public Builder setWebServerIpv4ReservedRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      webServerIpv4ReservedRange_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebServerIpv4ReservedRange() {
      webServerIpv4ReservedRange_ = getDefaultInstance().getWebServerIpv4ReservedRange();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's App Engine VMs.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-1.*.*-airflow-*.*.*.
     * </pre>
     *
     * <code>string web_server_ipv4_reserved_range = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for webServerIpv4ReservedRange to set.
     * @return This builder for chaining.
     */
    public Builder setWebServerIpv4ReservedRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      webServerIpv4ReservedRange_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object cloudComposerNetworkIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudComposerNetworkIpv4CidrBlock.
     */
    public java.lang.String getCloudComposerNetworkIpv4CidrBlock() {
      java.lang.Object ref = cloudComposerNetworkIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudComposerNetworkIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for cloudComposerNetworkIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getCloudComposerNetworkIpv4CidrBlockBytes() {
      java.lang.Object ref = cloudComposerNetworkIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudComposerNetworkIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The cloudComposerNetworkIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setCloudComposerNetworkIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudComposerNetworkIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudComposerNetworkIpv4CidrBlock() {
      cloudComposerNetworkIpv4CidrBlock_ =
          getDefaultInstance().getCloudComposerNetworkIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The CIDR block from which IP range for Cloud Composer Network in
     * tenant project will be reserved. Needs to be disjoint from
     * private_cluster_config.master_ipv4_cidr_block and
     * cloud_sql_ipv4_cidr_block.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_cidr_block = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for cloudComposerNetworkIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setCloudComposerNetworkIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudComposerNetworkIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object cloudComposerNetworkIpv4ReservedRange_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudComposerNetworkIpv4ReservedRange.
     */
    public java.lang.String getCloudComposerNetworkIpv4ReservedRange() {
      java.lang.Object ref = cloudComposerNetworkIpv4ReservedRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudComposerNetworkIpv4ReservedRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for cloudComposerNetworkIpv4ReservedRange.
     */
    public com.google.protobuf.ByteString getCloudComposerNetworkIpv4ReservedRangeBytes() {
      java.lang.Object ref = cloudComposerNetworkIpv4ReservedRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudComposerNetworkIpv4ReservedRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The cloudComposerNetworkIpv4ReservedRange to set.
     * @return This builder for chaining.
     */
    public Builder setCloudComposerNetworkIpv4ReservedRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudComposerNetworkIpv4ReservedRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudComposerNetworkIpv4ReservedRange() {
      cloudComposerNetworkIpv4ReservedRange_ =
          getDefaultInstance().getCloudComposerNetworkIpv4ReservedRange();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP range reserved for the tenant project's Cloud Composer
     * network.
     *
     * This field is supported for Cloud Composer environments in versions
     * composer-2.*.*-airflow-*.*.* and newer.
     * </pre>
     *
     * <code>
     * string cloud_composer_network_ipv4_reserved_range = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for cloudComposerNetworkIpv4ReservedRange to set.
     * @return This builder for chaining.
     */
    public Builder setCloudComposerNetworkIpv4ReservedRangeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudComposerNetworkIpv4ReservedRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean enablePrivatelyUsedPublicIps_;
    /**
     *
     *
     * <pre>
     * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     * `IPAllocationPolicy.service_ipv4_cidr_block`.
     * </pre>
     *
     * <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enablePrivatelyUsedPublicIps.
     */
    @java.lang.Override
    public boolean getEnablePrivatelyUsedPublicIps() {
      return enablePrivatelyUsedPublicIps_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     * `IPAllocationPolicy.service_ipv4_cidr_block`.
     * </pre>
     *
     * <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enablePrivatelyUsedPublicIps to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePrivatelyUsedPublicIps(boolean value) {

      enablePrivatelyUsedPublicIps_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
     * for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
     * `IPAllocationPolicy.service_ipv4_cidr_block`.
     * </pre>
     *
     * <code>bool enable_privately_used_public_ips = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePrivatelyUsedPublicIps() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enablePrivatelyUsedPublicIps_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object cloudComposerConnectionSubnetwork_ = "";
    /**
     *
     *
     * <pre>
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     * </pre>
     *
     * <code>
     * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudComposerConnectionSubnetwork.
     */
    public java.lang.String getCloudComposerConnectionSubnetwork() {
      java.lang.Object ref = cloudComposerConnectionSubnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudComposerConnectionSubnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     * </pre>
     *
     * <code>
     * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for cloudComposerConnectionSubnetwork.
     */
    public com.google.protobuf.ByteString getCloudComposerConnectionSubnetworkBytes() {
      java.lang.Object ref = cloudComposerConnectionSubnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudComposerConnectionSubnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     * </pre>
     *
     * <code>
     * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The cloudComposerConnectionSubnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setCloudComposerConnectionSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudComposerConnectionSubnetwork_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     * </pre>
     *
     * <code>
     * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudComposerConnectionSubnetwork() {
      cloudComposerConnectionSubnetwork_ =
          getDefaultInstance().getCloudComposerConnectionSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When specified, the environment will use Private Service Connect
     * instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
     * and the PSC endpoint in the Customer Project will use an IP address from
     * this subnetwork.
     * </pre>
     *
     * <code>
     * string cloud_composer_connection_subnetwork = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for cloudComposerConnectionSubnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setCloudComposerConnectionSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudComposerConnectionSubnetwork_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
        networkingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfigOrBuilder>
        networkingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the networkingConfig field is set.
     */
    public boolean hasNetworkingConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The networkingConfig.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
        getNetworkingConfig() {
      if (networkingConfigBuilder_ == null) {
        return networkingConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
                .getDefaultInstance()
            : networkingConfig_;
      } else {
        return networkingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNetworkingConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig value) {
      if (networkingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkingConfig_ = value;
      } else {
        networkingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNetworkingConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder
            builderForValue) {
      if (networkingConfigBuilder_ == null) {
        networkingConfig_ = builderForValue.build();
      } else {
        networkingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNetworkingConfig(
        com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig value) {
      if (networkingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && networkingConfig_ != null
            && networkingConfig_
                != com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
                    .getDefaultInstance()) {
          getNetworkingConfigBuilder().mergeFrom(value);
        } else {
          networkingConfig_ = value;
        }
      } else {
        networkingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNetworkingConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      networkingConfig_ = null;
      if (networkingConfigBuilder_ != null) {
        networkingConfigBuilder_.dispose();
        networkingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder
        getNetworkingConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getNetworkingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfigOrBuilder
        getNetworkingConfigOrBuilder() {
      if (networkingConfigBuilder_ != null) {
        return networkingConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkingConfig_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig
                .getDefaultInstance()
            : networkingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the network connections configuration in the
     * environment.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig networking_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig,
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfigOrBuilder>
        getNetworkingConfigFieldBuilder() {
      if (networkingConfigBuilder_ == null) {
        networkingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig,
                com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfig.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.NetworkingConfigOrBuilder>(
                getNetworkingConfig(), getParentForChildren(), isClean());
        networkingConfig_ = null;
      }
      return networkingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1
          .PrivateEnvironmentConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrivateEnvironmentConfig> PARSER =
      new com.google.protobuf.AbstractParser<PrivateEnvironmentConfig>() {
        @java.lang.Override
        public PrivateEnvironmentConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PrivateEnvironmentConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrivateEnvironmentConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.PrivateEnvironmentConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
