/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orchestration/airflow/service/v1beta1/environments.proto

package com.google.cloud.orchestration.airflow.service.v1beta1;

/**
 *
 *
 * <pre>
 * The Kubernetes workloads configuration for GKE cluster associated with the
 * Cloud Composer environment. Supported for Cloud Composer environments in
 * versions composer-2.*.*-airflow-*.*.* and newer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig}
 */
public final class WorkloadsConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig)
    WorkloadsConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkloadsConfig.newBuilder() to construct.
  private WorkloadsConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkloadsConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkloadsConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
        .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.class,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder.class);
  }

  public interface SchedulerResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for a single Airflow scheduler replica.
     * </pre>
     *
     * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    float getCpu();

    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for a single Airflow scheduler
     * replica.
     * </pre>
     *
     * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    float getMemoryGb();

    /**
     *
     *
     * <pre>
     * Optional. Storage (GB) request and limit for a single Airflow scheduler
     * replica.
     * </pre>
     *
     * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageGb.
     */
    float getStorageGb();

    /**
     *
     *
     * <pre>
     * Optional. The number of schedulers.
     * </pre>
     *
     * <code>int32 count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count.
     */
    int getCount();
  }
  /**
   *
   *
   * <pre>
   * Configuration for resources used by Airflow schedulers.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource}
   */
  public static final class SchedulerResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource)
      SchedulerResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SchedulerResource.newBuilder() to construct.
    private SchedulerResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SchedulerResource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SchedulerResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_SchedulerResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_SchedulerResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                  .SchedulerResource.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                  .SchedulerResource.Builder.class);
    }

    public static final int CPU_FIELD_NUMBER = 1;
    private float cpu_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for a single Airflow scheduler replica.
     * </pre>
     *
     * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    @java.lang.Override
    public float getCpu() {
      return cpu_;
    }

    public static final int MEMORY_GB_FIELD_NUMBER = 2;
    private float memoryGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for a single Airflow scheduler
     * replica.
     * </pre>
     *
     * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    @java.lang.Override
    public float getMemoryGb() {
      return memoryGb_;
    }

    public static final int STORAGE_GB_FIELD_NUMBER = 3;
    private float storageGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Storage (GB) request and limit for a single Airflow scheduler
     * replica.
     * </pre>
     *
     * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageGb.
     */
    @java.lang.Override
    public float getStorageGb() {
      return storageGb_;
    }

    public static final int COUNT_FIELD_NUMBER = 4;
    private int count_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The number of schedulers.
     * </pre>
     *
     * <code>int32 count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public int getCount() {
      return count_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        output.writeFloat(1, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        output.writeFloat(2, memoryGb_);
      }
      if (java.lang.Float.floatToRawIntBits(storageGb_) != 0) {
        output.writeFloat(3, storageGb_);
      }
      if (count_ != 0) {
        output.writeInt32(4, count_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, memoryGb_);
      }
      if (java.lang.Float.floatToRawIntBits(storageGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, storageGb_);
      }
      if (count_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, count_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .SchedulerResource)) {
        return super.equals(obj);
      }
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
          other =
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .SchedulerResource)
                  obj;

      if (java.lang.Float.floatToIntBits(getCpu())
          != java.lang.Float.floatToIntBits(other.getCpu())) return false;
      if (java.lang.Float.floatToIntBits(getMemoryGb())
          != java.lang.Float.floatToIntBits(other.getMemoryGb())) return false;
      if (java.lang.Float.floatToIntBits(getStorageGb())
          != java.lang.Float.floatToIntBits(other.getStorageGb())) return false;
      if (getCount() != other.getCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CPU_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCpu());
      hash = (37 * hash) + MEMORY_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMemoryGb());
      hash = (37 * hash) + STORAGE_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getStorageGb());
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for resources used by Airflow schedulers.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource)
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_SchedulerResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_SchedulerResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResource.class,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResource.Builder.class);
      }

      // Construct using
      // com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cpu_ = 0F;
        memoryGb_ = 0F;
        storageGb_ = 0F;
        count_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_SchedulerResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .SchedulerResource
          getDefaultInstanceForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .SchedulerResource
          build() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .SchedulerResource
          buildPartial() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            result =
                new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cpu_ = cpu_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.memoryGb_ = memoryGb_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.storageGb_ = storageGb_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.count_ = count_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResource) {
          return mergeFrom(
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .SchedulerResource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
              other) {
        if (other
            == com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResource.getDefaultInstance()) return this;
        if (other.getCpu() != 0F) {
          setCpu(other.getCpu());
        }
        if (other.getMemoryGb() != 0F) {
          setMemoryGb(other.getMemoryGb());
        }
        if (other.getStorageGb() != 0F) {
          setStorageGb(other.getStorageGb());
        }
        if (other.getCount() != 0) {
          setCount(other.getCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  cpu_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  memoryGb_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  storageGb_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 32:
                {
                  count_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float cpu_;
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow scheduler replica.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpu.
       */
      @java.lang.Override
      public float getCpu() {
        return cpu_;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow scheduler replica.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The cpu to set.
       * @return This builder for chaining.
       */
      public Builder setCpu(float value) {

        cpu_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow scheduler replica.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCpu() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cpu_ = 0F;
        onChanged();
        return this;
      }

      private float memoryGb_;
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow scheduler
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The memoryGb.
       */
      @java.lang.Override
      public float getMemoryGb() {
        return memoryGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow scheduler
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The memoryGb to set.
       * @return This builder for chaining.
       */
      public Builder setMemoryGb(float value) {

        memoryGb_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow scheduler
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMemoryGb() {
        bitField0_ = (bitField0_ & ~0x00000002);
        memoryGb_ = 0F;
        onChanged();
        return this;
      }

      private float storageGb_;
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for a single Airflow scheduler
       * replica.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The storageGb.
       */
      @java.lang.Override
      public float getStorageGb() {
        return storageGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for a single Airflow scheduler
       * replica.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The storageGb to set.
       * @return This builder for chaining.
       */
      public Builder setStorageGb(float value) {

        storageGb_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for a single Airflow scheduler
       * replica.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStorageGb() {
        bitField0_ = (bitField0_ & ~0x00000004);
        storageGb_ = 0F;
        onChanged();
        return this;
      }

      private int count_;
      /**
       *
       *
       * <pre>
       * Optional. The number of schedulers.
       * </pre>
       *
       * <code>int32 count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public int getCount() {
        return count_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of schedulers.
       * </pre>
       *
       * <code>int32 count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(int value) {

        count_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of schedulers.
       * </pre>
       *
       * <code>int32 count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        count_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource)
    private static final com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .SchedulerResource();
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SchedulerResource> PARSER =
        new com.google.protobuf.AbstractParser<SchedulerResource>() {
          @java.lang.Override
          public SchedulerResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SchedulerResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SchedulerResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebServerResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for Airflow web server.
     * </pre>
     *
     * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    float getCpu();

    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for Airflow web server.
     * </pre>
     *
     * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    float getMemoryGb();

    /**
     *
     *
     * <pre>
     * Optional. Storage (GB) request and limit for Airflow web server.
     * </pre>
     *
     * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageGb.
     */
    float getStorageGb();
  }
  /**
   *
   *
   * <pre>
   * Configuration for resources used by Airflow web server.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource}
   */
  public static final class WebServerResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource)
      WebServerResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebServerResource.newBuilder() to construct.
    private WebServerResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebServerResource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebServerResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WebServerResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WebServerResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                  .WebServerResource.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                  .WebServerResource.Builder.class);
    }

    public static final int CPU_FIELD_NUMBER = 1;
    private float cpu_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for Airflow web server.
     * </pre>
     *
     * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    @java.lang.Override
    public float getCpu() {
      return cpu_;
    }

    public static final int MEMORY_GB_FIELD_NUMBER = 2;
    private float memoryGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for Airflow web server.
     * </pre>
     *
     * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    @java.lang.Override
    public float getMemoryGb() {
      return memoryGb_;
    }

    public static final int STORAGE_GB_FIELD_NUMBER = 3;
    private float storageGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Storage (GB) request and limit for Airflow web server.
     * </pre>
     *
     * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageGb.
     */
    @java.lang.Override
    public float getStorageGb() {
      return storageGb_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        output.writeFloat(1, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        output.writeFloat(2, memoryGb_);
      }
      if (java.lang.Float.floatToRawIntBits(storageGb_) != 0) {
        output.writeFloat(3, storageGb_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, memoryGb_);
      }
      if (java.lang.Float.floatToRawIntBits(storageGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, storageGb_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .WebServerResource)) {
        return super.equals(obj);
      }
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
          other =
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .WebServerResource)
                  obj;

      if (java.lang.Float.floatToIntBits(getCpu())
          != java.lang.Float.floatToIntBits(other.getCpu())) return false;
      if (java.lang.Float.floatToIntBits(getMemoryGb())
          != java.lang.Float.floatToIntBits(other.getMemoryGb())) return false;
      if (java.lang.Float.floatToIntBits(getStorageGb())
          != java.lang.Float.floatToIntBits(other.getStorageGb())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CPU_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCpu());
      hash = (37 * hash) + MEMORY_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMemoryGb());
      hash = (37 * hash) + STORAGE_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getStorageGb());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for resources used by Airflow web server.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource)
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WebServerResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WebServerResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResource.class,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResource.Builder.class);
      }

      // Construct using
      // com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cpu_ = 0F;
        memoryGb_ = 0F;
        storageGb_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WebServerResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .WebServerResource
          getDefaultInstanceForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .WebServerResource
          build() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .WebServerResource
          buildPartial() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            result =
                new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cpu_ = cpu_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.memoryGb_ = memoryGb_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.storageGb_ = storageGb_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResource) {
          return mergeFrom(
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .WebServerResource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
              other) {
        if (other
            == com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResource.getDefaultInstance()) return this;
        if (other.getCpu() != 0F) {
          setCpu(other.getCpu());
        }
        if (other.getMemoryGb() != 0F) {
          setMemoryGb(other.getMemoryGb());
        }
        if (other.getStorageGb() != 0F) {
          setStorageGb(other.getStorageGb());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  cpu_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  memoryGb_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  storageGb_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float cpu_;
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for Airflow web server.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpu.
       */
      @java.lang.Override
      public float getCpu() {
        return cpu_;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for Airflow web server.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The cpu to set.
       * @return This builder for chaining.
       */
      public Builder setCpu(float value) {

        cpu_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for Airflow web server.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCpu() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cpu_ = 0F;
        onChanged();
        return this;
      }

      private float memoryGb_;
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for Airflow web server.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The memoryGb.
       */
      @java.lang.Override
      public float getMemoryGb() {
        return memoryGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for Airflow web server.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The memoryGb to set.
       * @return This builder for chaining.
       */
      public Builder setMemoryGb(float value) {

        memoryGb_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for Airflow web server.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMemoryGb() {
        bitField0_ = (bitField0_ & ~0x00000002);
        memoryGb_ = 0F;
        onChanged();
        return this;
      }

      private float storageGb_;
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for Airflow web server.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The storageGb.
       */
      @java.lang.Override
      public float getStorageGb() {
        return storageGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for Airflow web server.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The storageGb to set.
       * @return This builder for chaining.
       */
      public Builder setStorageGb(float value) {

        storageGb_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for Airflow web server.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStorageGb() {
        bitField0_ = (bitField0_ & ~0x00000004);
        storageGb_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource)
    private static final com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .WebServerResource();
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebServerResource> PARSER =
        new com.google.protobuf.AbstractParser<WebServerResource>() {
          @java.lang.Override
          public WebServerResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebServerResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebServerResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WorkerResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for a single Airflow worker replica.
     * </pre>
     *
     * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    float getCpu();

    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for a single Airflow worker
     * replica.
     * </pre>
     *
     * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    float getMemoryGb();

    /**
     *
     *
     * <pre>
     * Optional. Storage (GB) request and limit for a single Airflow worker
     * replica.
     * </pre>
     *
     * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageGb.
     */
    float getStorageGb();

    /**
     *
     *
     * <pre>
     * Optional. Minimum number of workers for autoscaling.
     * </pre>
     *
     * <code>int32 min_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCount.
     */
    int getMinCount();

    /**
     *
     *
     * <pre>
     * Optional. Maximum number of workers for autoscaling.
     * </pre>
     *
     * <code>int32 max_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxCount.
     */
    int getMaxCount();
  }
  /**
   *
   *
   * <pre>
   * Configuration for resources used by Airflow workers.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource}
   */
  public static final class WorkerResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)
      WorkerResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WorkerResource.newBuilder() to construct.
    private WorkerResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WorkerResource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WorkerResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WorkerResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WorkerResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                  .class,
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                  .Builder.class);
    }

    public static final int CPU_FIELD_NUMBER = 1;
    private float cpu_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for a single Airflow worker replica.
     * </pre>
     *
     * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    @java.lang.Override
    public float getCpu() {
      return cpu_;
    }

    public static final int MEMORY_GB_FIELD_NUMBER = 2;
    private float memoryGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for a single Airflow worker
     * replica.
     * </pre>
     *
     * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    @java.lang.Override
    public float getMemoryGb() {
      return memoryGb_;
    }

    public static final int STORAGE_GB_FIELD_NUMBER = 3;
    private float storageGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Storage (GB) request and limit for a single Airflow worker
     * replica.
     * </pre>
     *
     * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageGb.
     */
    @java.lang.Override
    public float getStorageGb() {
      return storageGb_;
    }

    public static final int MIN_COUNT_FIELD_NUMBER = 4;
    private int minCount_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of workers for autoscaling.
     * </pre>
     *
     * <code>int32 min_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCount.
     */
    @java.lang.Override
    public int getMinCount() {
      return minCount_;
    }

    public static final int MAX_COUNT_FIELD_NUMBER = 5;
    private int maxCount_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of workers for autoscaling.
     * </pre>
     *
     * <code>int32 max_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxCount.
     */
    @java.lang.Override
    public int getMaxCount() {
      return maxCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        output.writeFloat(1, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        output.writeFloat(2, memoryGb_);
      }
      if (java.lang.Float.floatToRawIntBits(storageGb_) != 0) {
        output.writeFloat(3, storageGb_);
      }
      if (minCount_ != 0) {
        output.writeInt32(4, minCount_);
      }
      if (maxCount_ != 0) {
        output.writeInt32(5, maxCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, memoryGb_);
      }
      if (java.lang.Float.floatToRawIntBits(storageGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, storageGb_);
      }
      if (minCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, minCount_);
      }
      if (maxCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)) {
        return super.equals(obj);
      }
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource other =
          (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)
              obj;

      if (java.lang.Float.floatToIntBits(getCpu())
          != java.lang.Float.floatToIntBits(other.getCpu())) return false;
      if (java.lang.Float.floatToIntBits(getMemoryGb())
          != java.lang.Float.floatToIntBits(other.getMemoryGb())) return false;
      if (java.lang.Float.floatToIntBits(getStorageGb())
          != java.lang.Float.floatToIntBits(other.getStorageGb())) return false;
      if (getMinCount() != other.getMinCount()) return false;
      if (getMaxCount() != other.getMaxCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CPU_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCpu());
      hash = (37 * hash) + MEMORY_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMemoryGb());
      hash = (37 * hash) + STORAGE_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getStorageGb());
      hash = (37 * hash) + MIN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMinCount();
      hash = (37 * hash) + MAX_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for resources used by Airflow workers.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WorkerResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WorkerResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResource.class,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResource.Builder.class);
      }

      // Construct using
      // com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cpu_ = 0F;
        memoryGb_ = 0F;
        storageGb_ = 0F;
        minCount_ = 0;
        maxCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_WorkerResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
          getDefaultInstanceForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
          build() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
          buildPartial() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            result =
                new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cpu_ = cpu_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.memoryGb_ = memoryGb_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.storageGb_ = storageGb_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.minCount_ = minCount_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.maxCount_ = maxCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource) {
          return mergeFrom(
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .WorkerResource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
              other) {
        if (other
            == com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                .getDefaultInstance()) return this;
        if (other.getCpu() != 0F) {
          setCpu(other.getCpu());
        }
        if (other.getMemoryGb() != 0F) {
          setMemoryGb(other.getMemoryGb());
        }
        if (other.getStorageGb() != 0F) {
          setStorageGb(other.getStorageGb());
        }
        if (other.getMinCount() != 0) {
          setMinCount(other.getMinCount());
        }
        if (other.getMaxCount() != 0) {
          setMaxCount(other.getMaxCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  cpu_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  memoryGb_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  storageGb_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 32:
                {
                  minCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  maxCount_ = input.readInt32();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float cpu_;
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow worker replica.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpu.
       */
      @java.lang.Override
      public float getCpu() {
        return cpu_;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow worker replica.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The cpu to set.
       * @return This builder for chaining.
       */
      public Builder setCpu(float value) {

        cpu_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow worker replica.
       * </pre>
       *
       * <code>float cpu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCpu() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cpu_ = 0F;
        onChanged();
        return this;
      }

      private float memoryGb_;
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow worker
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The memoryGb.
       */
      @java.lang.Override
      public float getMemoryGb() {
        return memoryGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow worker
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The memoryGb to set.
       * @return This builder for chaining.
       */
      public Builder setMemoryGb(float value) {

        memoryGb_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow worker
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMemoryGb() {
        bitField0_ = (bitField0_ & ~0x00000002);
        memoryGb_ = 0F;
        onChanged();
        return this;
      }

      private float storageGb_;
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for a single Airflow worker
       * replica.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The storageGb.
       */
      @java.lang.Override
      public float getStorageGb() {
        return storageGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for a single Airflow worker
       * replica.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The storageGb to set.
       * @return This builder for chaining.
       */
      public Builder setStorageGb(float value) {

        storageGb_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Storage (GB) request and limit for a single Airflow worker
       * replica.
       * </pre>
       *
       * <code>float storage_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStorageGb() {
        bitField0_ = (bitField0_ & ~0x00000004);
        storageGb_ = 0F;
        onChanged();
        return this;
      }

      private int minCount_;
      /**
       *
       *
       * <pre>
       * Optional. Minimum number of workers for autoscaling.
       * </pre>
       *
       * <code>int32 min_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The minCount.
       */
      @java.lang.Override
      public int getMinCount() {
        return minCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Minimum number of workers for autoscaling.
       * </pre>
       *
       * <code>int32 min_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The minCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinCount(int value) {

        minCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Minimum number of workers for autoscaling.
       * </pre>
       *
       * <code>int32 min_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        minCount_ = 0;
        onChanged();
        return this;
      }

      private int maxCount_;
      /**
       *
       *
       * <pre>
       * Optional. Maximum number of workers for autoscaling.
       * </pre>
       *
       * <code>int32 max_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The maxCount.
       */
      @java.lang.Override
      public int getMaxCount() {
        return maxCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Maximum number of workers for autoscaling.
       * </pre>
       *
       * <code>int32 max_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The maxCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxCount(int value) {

        maxCount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Maximum number of workers for autoscaling.
       * </pre>
       *
       * <code>int32 max_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxCount() {
        bitField0_ = (bitField0_ & ~0x00000010);
        maxCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource)
    private static final com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .WorkerResource();
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WorkerResource> PARSER =
        new com.google.protobuf.AbstractParser<WorkerResource>() {
          @java.lang.Override
          public WorkerResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WorkerResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WorkerResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TriggererResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The number of triggerers.
     * </pre>
     *
     * <code>int32 count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count.
     */
    int getCount();

    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for a single Airflow triggerer replica.
     * </pre>
     *
     * <code>float cpu = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    float getCpu();

    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for a single Airflow triggerer
     * replica.
     * </pre>
     *
     * <code>float memory_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    float getMemoryGb();
  }
  /**
   *
   *
   * <pre>
   * Configuration for resources used by Airflow triggerers.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource}
   */
  public static final class TriggererResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource)
      TriggererResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TriggererResource.newBuilder() to construct.
    private TriggererResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TriggererResource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TriggererResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_TriggererResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_TriggererResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                  .TriggererResource.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                  .TriggererResource.Builder.class);
    }

    public static final int COUNT_FIELD_NUMBER = 1;
    private int count_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The number of triggerers.
     * </pre>
     *
     * <code>int32 count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public int getCount() {
      return count_;
    }

    public static final int CPU_FIELD_NUMBER = 2;
    private float cpu_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. CPU request and limit for a single Airflow triggerer replica.
     * </pre>
     *
     * <code>float cpu = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cpu.
     */
    @java.lang.Override
    public float getCpu() {
      return cpu_;
    }

    public static final int MEMORY_GB_FIELD_NUMBER = 3;
    private float memoryGb_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Memory (GB) request and limit for a single Airflow triggerer
     * replica.
     * </pre>
     *
     * <code>float memory_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The memoryGb.
     */
    @java.lang.Override
    public float getMemoryGb() {
      return memoryGb_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (count_ != 0) {
        output.writeInt32(1, count_);
      }
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        output.writeFloat(2, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        output.writeFloat(3, memoryGb_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (count_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, count_);
      }
      if (java.lang.Float.floatToRawIntBits(cpu_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, cpu_);
      }
      if (java.lang.Float.floatToRawIntBits(memoryGb_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, memoryGb_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .TriggererResource)) {
        return super.equals(obj);
      }
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
          other =
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .TriggererResource)
                  obj;

      if (getCount() != other.getCount()) return false;
      if (java.lang.Float.floatToIntBits(getCpu())
          != java.lang.Float.floatToIntBits(other.getCpu())) return false;
      if (java.lang.Float.floatToIntBits(getMemoryGb())
          != java.lang.Float.floatToIntBits(other.getMemoryGb())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCount();
      hash = (37 * hash) + CPU_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCpu());
      hash = (37 * hash) + MEMORY_GB_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMemoryGb());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for resources used by Airflow triggerers.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource)
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_TriggererResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_TriggererResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResource.class,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResource.Builder.class);
      }

      // Construct using
      // com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        count_ = 0;
        cpu_ = 0F;
        memoryGb_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
            .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_TriggererResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .TriggererResource
          getDefaultInstanceForType() {
        return com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .TriggererResource
          build() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .TriggererResource
          buildPartial() {
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            result =
                new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.count_ = count_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.cpu_ = cpu_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.memoryGb_ = memoryGb_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResource) {
          return mergeFrom(
              (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                      .TriggererResource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
              other) {
        if (other
            == com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResource.getDefaultInstance()) return this;
        if (other.getCount() != 0) {
          setCount(other.getCount());
        }
        if (other.getCpu() != 0F) {
          setCpu(other.getCpu());
        }
        if (other.getMemoryGb() != 0F) {
          setMemoryGb(other.getMemoryGb());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  count_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 21:
                {
                  cpu_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  memoryGb_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int count_;
      /**
       *
       *
       * <pre>
       * Optional. The number of triggerers.
       * </pre>
       *
       * <code>int32 count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public int getCount() {
        return count_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of triggerers.
       * </pre>
       *
       * <code>int32 count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(int value) {

        count_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of triggerers.
       * </pre>
       *
       * <code>int32 count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        count_ = 0;
        onChanged();
        return this;
      }

      private float cpu_;
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow triggerer replica.
       * </pre>
       *
       * <code>float cpu = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpu.
       */
      @java.lang.Override
      public float getCpu() {
        return cpu_;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow triggerer replica.
       * </pre>
       *
       * <code>float cpu = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The cpu to set.
       * @return This builder for chaining.
       */
      public Builder setCpu(float value) {

        cpu_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. CPU request and limit for a single Airflow triggerer replica.
       * </pre>
       *
       * <code>float cpu = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCpu() {
        bitField0_ = (bitField0_ & ~0x00000002);
        cpu_ = 0F;
        onChanged();
        return this;
      }

      private float memoryGb_;
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow triggerer
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The memoryGb.
       */
      @java.lang.Override
      public float getMemoryGb() {
        return memoryGb_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow triggerer
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The memoryGb to set.
       * @return This builder for chaining.
       */
      public Builder setMemoryGb(float value) {

        memoryGb_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Memory (GB) request and limit for a single Airflow triggerer
       * replica.
       * </pre>
       *
       * <code>float memory_gb = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMemoryGb() {
        bitField0_ = (bitField0_ & ~0x00000004);
        memoryGb_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource)
    private static final com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .TriggererResource();
    }

    public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TriggererResource> PARSER =
        new com.google.protobuf.AbstractParser<TriggererResource>() {
          @java.lang.Override
          public TriggererResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TriggererResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TriggererResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SCHEDULER_FIELD_NUMBER = 1;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
      scheduler_;
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow schedulers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the scheduler field is set.
   */
  @java.lang.Override
  public boolean hasScheduler() {
    return scheduler_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow schedulers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The scheduler.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
      getScheduler() {
    return scheduler_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            .getDefaultInstance()
        : scheduler_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow schedulers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
          .SchedulerResourceOrBuilder
      getSchedulerOrBuilder() {
    return scheduler_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            .getDefaultInstance()
        : scheduler_;
  }

  public static final int WEB_SERVER_FIELD_NUMBER = 2;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
      webServer_;
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow web server.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webServer field is set.
   */
  @java.lang.Override
  public boolean hasWebServer() {
    return webServer_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow web server.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webServer.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
      getWebServer() {
    return webServer_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            .getDefaultInstance()
        : webServer_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow web server.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
          .WebServerResourceOrBuilder
      getWebServerOrBuilder() {
    return webServer_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            .getDefaultInstance()
        : webServer_;
  }

  public static final int WORKER_FIELD_NUMBER = 3;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
      worker_;
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow workers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the worker field is set.
   */
  @java.lang.Override
  public boolean hasWorker() {
    return worker_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow workers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The worker.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
      getWorker() {
    return worker_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            .getDefaultInstance()
        : worker_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow workers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
          .WorkerResourceOrBuilder
      getWorkerOrBuilder() {
    return worker_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            .getDefaultInstance()
        : worker_;
  }

  public static final int TRIGGERER_FIELD_NUMBER = 4;
  private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
      triggerer_;
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow triggerers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the triggerer field is set.
   */
  @java.lang.Override
  public boolean hasTriggerer() {
    return triggerer_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow triggerers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The triggerer.
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
      getTriggerer() {
    return triggerer_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            .getDefaultInstance()
        : triggerer_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resources used by Airflow triggerers.
   * </pre>
   *
   * <code>
   * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
          .TriggererResourceOrBuilder
      getTriggererOrBuilder() {
    return triggerer_ == null
        ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            .getDefaultInstance()
        : triggerer_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (scheduler_ != null) {
      output.writeMessage(1, getScheduler());
    }
    if (webServer_ != null) {
      output.writeMessage(2, getWebServer());
    }
    if (worker_ != null) {
      output.writeMessage(3, getWorker());
    }
    if (triggerer_ != null) {
      output.writeMessage(4, getTriggerer());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (scheduler_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getScheduler());
    }
    if (webServer_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getWebServer());
    }
    if (worker_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getWorker());
    }
    if (triggerer_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTriggerer());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig other =
        (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig) obj;

    if (hasScheduler() != other.hasScheduler()) return false;
    if (hasScheduler()) {
      if (!getScheduler().equals(other.getScheduler())) return false;
    }
    if (hasWebServer() != other.hasWebServer()) return false;
    if (hasWebServer()) {
      if (!getWebServer().equals(other.getWebServer())) return false;
    }
    if (hasWorker() != other.hasWorker()) return false;
    if (hasWorker()) {
      if (!getWorker().equals(other.getWorker())) return false;
    }
    if (hasTriggerer() != other.hasTriggerer()) return false;
    if (hasTriggerer()) {
      if (!getTriggerer().equals(other.getTriggerer())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasScheduler()) {
      hash = (37 * hash) + SCHEDULER_FIELD_NUMBER;
      hash = (53 * hash) + getScheduler().hashCode();
    }
    if (hasWebServer()) {
      hash = (37 * hash) + WEB_SERVER_FIELD_NUMBER;
      hash = (53 * hash) + getWebServer().hashCode();
    }
    if (hasWorker()) {
      hash = (37 * hash) + WORKER_FIELD_NUMBER;
      hash = (53 * hash) + getWorker().hashCode();
    }
    if (hasTriggerer()) {
      hash = (37 * hash) + TRIGGERER_FIELD_NUMBER;
      hash = (53 * hash) + getTriggerer().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Kubernetes workloads configuration for GKE cluster associated with the
   * Cloud Composer environment. Supported for Cloud Composer environments in
   * versions composer-2.*.*-airflow-*.*.* and newer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig)
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.class,
              com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.Builder.class);
    }

    // Construct using
    // com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      scheduler_ = null;
      if (schedulerBuilder_ != null) {
        schedulerBuilder_.dispose();
        schedulerBuilder_ = null;
      }
      webServer_ = null;
      if (webServerBuilder_ != null) {
        webServerBuilder_.dispose();
        webServerBuilder_ = null;
      }
      worker_ = null;
      if (workerBuilder_ != null) {
        workerBuilder_.dispose();
        workerBuilder_ = null;
      }
      triggerer_ = null;
      if (triggererBuilder_ != null) {
        triggererBuilder_.dispose();
        triggererBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsOuterClass
          .internal_static_google_cloud_orchestration_airflow_service_v1beta1_WorkloadsConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
        getDefaultInstanceForType() {
      return com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig build() {
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig buildPartial() {
      com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig result =
          new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.scheduler_ = schedulerBuilder_ == null ? scheduler_ : schedulerBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.webServer_ = webServerBuilder_ == null ? webServer_ : webServerBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.worker_ = workerBuilder_ == null ? worker_ : workerBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.triggerer_ = triggererBuilder_ == null ? triggerer_ : triggererBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig) {
        return mergeFrom(
            (com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig other) {
      if (other
          == com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
              .getDefaultInstance()) return this;
      if (other.hasScheduler()) {
        mergeScheduler(other.getScheduler());
      }
      if (other.hasWebServer()) {
        mergeWebServer(other.getWebServer());
      }
      if (other.hasWorker()) {
        mergeWorker(other.getWorker());
      }
      if (other.hasTriggerer()) {
        mergeTriggerer(other.getTriggerer());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSchedulerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getWebServerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getWorkerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTriggererFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
        scheduler_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResourceOrBuilder>
        schedulerBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the scheduler field is set.
     */
    public boolean hasScheduler() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The scheduler.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
        getScheduler() {
      if (schedulerBuilder_ == null) {
        return scheduler_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResource.getDefaultInstance()
            : scheduler_;
      } else {
        return schedulerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setScheduler(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            value) {
      if (schedulerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduler_ = value;
      } else {
        schedulerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setScheduler(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
                .Builder
            builderForValue) {
      if (schedulerBuilder_ == null) {
        scheduler_ = builderForValue.build();
      } else {
        schedulerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeScheduler(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            value) {
      if (schedulerBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && scheduler_ != null
            && scheduler_
                != com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResource.getDefaultInstance()) {
          getSchedulerBuilder().mergeFrom(value);
        } else {
          scheduler_ = value;
        }
      } else {
        schedulerBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearScheduler() {
      bitField0_ = (bitField0_ & ~0x00000001);
      scheduler_ = null;
      if (schedulerBuilder_ != null) {
        schedulerBuilder_.dispose();
        schedulerBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
            .Builder
        getSchedulerBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSchedulerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .SchedulerResourceOrBuilder
        getSchedulerOrBuilder() {
      if (schedulerBuilder_ != null) {
        return schedulerBuilder_.getMessageOrBuilder();
      } else {
        return scheduler_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResource.getDefaultInstance()
            : scheduler_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow schedulers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource scheduler = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.SchedulerResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .SchedulerResourceOrBuilder>
        getSchedulerFieldBuilder() {
      if (schedulerBuilder_ == null) {
        schedulerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResource,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResource.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .SchedulerResourceOrBuilder>(getScheduler(), getParentForChildren(), isClean());
        scheduler_ = null;
      }
      return schedulerBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
        webServer_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResourceOrBuilder>
        webServerBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the webServer field is set.
     */
    public boolean hasWebServer() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webServer.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
        getWebServer() {
      if (webServerBuilder_ == null) {
        return webServer_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResource.getDefaultInstance()
            : webServer_;
      } else {
        return webServerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebServer(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            value) {
      if (webServerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webServer_ = value;
      } else {
        webServerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebServer(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
                .Builder
            builderForValue) {
      if (webServerBuilder_ == null) {
        webServer_ = builderForValue.build();
      } else {
        webServerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWebServer(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            value) {
      if (webServerBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && webServer_ != null
            && webServer_
                != com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResource.getDefaultInstance()) {
          getWebServerBuilder().mergeFrom(value);
        } else {
          webServer_ = value;
        }
      } else {
        webServerBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWebServer() {
      bitField0_ = (bitField0_ & ~0x00000002);
      webServer_ = null;
      if (webServerBuilder_ != null) {
        webServerBuilder_.dispose();
        webServerBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
            .Builder
        getWebServerBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getWebServerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WebServerResourceOrBuilder
        getWebServerOrBuilder() {
      if (webServerBuilder_ != null) {
        return webServerBuilder_.getMessageOrBuilder();
      } else {
        return webServer_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResource.getDefaultInstance()
            : webServer_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow web server.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource web_server = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WebServerResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WebServerResourceOrBuilder>
        getWebServerFieldBuilder() {
      if (webServerBuilder_ == null) {
        webServerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResource,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResource.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WebServerResourceOrBuilder>(getWebServer(), getParentForChildren(), isClean());
        webServer_ = null;
      }
      return webServerBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
        worker_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WorkerResourceOrBuilder>
        workerBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the worker field is set.
     */
    public boolean hasWorker() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The worker.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
        getWorker() {
      if (workerBuilder_ == null) {
        return worker_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                .getDefaultInstance()
            : worker_;
      } else {
        return workerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorker(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            value) {
      if (workerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        worker_ = value;
      } else {
        workerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorker(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                .Builder
            builderForValue) {
      if (workerBuilder_ == null) {
        worker_ = builderForValue.build();
      } else {
        workerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWorker(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            value) {
      if (workerBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && worker_ != null
            && worker_
                != com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResource.getDefaultInstance()) {
          getWorkerBuilder().mergeFrom(value);
        } else {
          worker_ = value;
        }
      } else {
        workerBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWorker() {
      bitField0_ = (bitField0_ & ~0x00000004);
      worker_ = null;
      if (workerBuilder_ != null) {
        workerBuilder_.dispose();
        workerBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
            .Builder
        getWorkerBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getWorkerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .WorkerResourceOrBuilder
        getWorkerOrBuilder() {
      if (workerBuilder_ != null) {
        return workerBuilder_.getMessageOrBuilder();
      } else {
        return worker_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                .getDefaultInstance()
            : worker_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow workers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource worker = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.WorkerResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .WorkerResourceOrBuilder>
        getWorkerFieldBuilder() {
      if (workerBuilder_ == null) {
        workerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResource,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResource.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .WorkerResourceOrBuilder>(getWorker(), getParentForChildren(), isClean());
        worker_ = null;
      }
      return workerBuilder_;
    }

    private com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
        triggerer_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResourceOrBuilder>
        triggererBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the triggerer field is set.
     */
    public boolean hasTriggerer() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The triggerer.
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
        getTriggerer() {
      if (triggererBuilder_ == null) {
        return triggerer_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResource.getDefaultInstance()
            : triggerer_;
      } else {
        return triggererBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTriggerer(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            value) {
      if (triggererBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        triggerer_ = value;
      } else {
        triggererBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTriggerer(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
                .Builder
            builderForValue) {
      if (triggererBuilder_ == null) {
        triggerer_ = builderForValue.build();
      } else {
        triggererBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTriggerer(
        com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            value) {
      if (triggererBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && triggerer_ != null
            && triggerer_
                != com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResource.getDefaultInstance()) {
          getTriggererBuilder().mergeFrom(value);
        } else {
          triggerer_ = value;
        }
      } else {
        triggererBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTriggerer() {
      bitField0_ = (bitField0_ & ~0x00000008);
      triggerer_ = null;
      if (triggererBuilder_ != null) {
        triggererBuilder_.dispose();
        triggererBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
            .Builder
        getTriggererBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTriggererFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
            .TriggererResourceOrBuilder
        getTriggererOrBuilder() {
      if (triggererBuilder_ != null) {
        return triggererBuilder_.getMessageOrBuilder();
      } else {
        return triggerer_ == null
            ? com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResource.getDefaultInstance()
            : triggerer_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Resources used by Airflow triggerers.
     * </pre>
     *
     * <code>
     * .google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource triggerer = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResource,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig.TriggererResource
                .Builder,
            com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                .TriggererResourceOrBuilder>
        getTriggererFieldBuilder() {
      if (triggererBuilder_ == null) {
        triggererBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResource,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResource.Builder,
                com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
                    .TriggererResourceOrBuilder>(getTriggerer(), getParentForChildren(), isClean());
        triggerer_ = null;
      }
      return triggererBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig)
  private static final com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig();
  }

  public static com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkloadsConfig> PARSER =
      new com.google.protobuf.AbstractParser<WorkloadsConfig>() {
        @java.lang.Override
        public WorkloadsConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkloadsConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkloadsConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orchestration.airflow.service.v1beta1.WorkloadsConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
