/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserWorkloadsSecretName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_SECRET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/environments/{environment}/userWorkloadsSecrets/{user_workloads_secret}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String environment;
    private final String userWorkloadsSecret;

    @Deprecated
    protected UserWorkloadsSecretName() {
        this.project = null;
        this.location = null;
        this.environment = null;
        this.userWorkloadsSecret = null;
    }

    private UserWorkloadsSecretName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.userWorkloadsSecret = (String)Preconditions.checkNotNull((Object)builder.getUserWorkloadsSecret());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUserWorkloadsSecret() {
        return this.userWorkloadsSecret;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserWorkloadsSecretName of(String project, String location, String environment, String userWorkloadsSecret) {
        return UserWorkloadsSecretName.newBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUserWorkloadsSecret(userWorkloadsSecret).build();
    }

    public static String format(String project, String location, String environment, String userWorkloadsSecret) {
        return UserWorkloadsSecretName.newBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUserWorkloadsSecret(userWorkloadsSecret).build().toString();
    }

    public static UserWorkloadsSecretName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_SECRET.validatedMatch(formattedString, "UserWorkloadsSecretName.parse: formattedString not in valid format");
        return UserWorkloadsSecretName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"), (String)matchMap.get("user_workloads_secret"));
    }

    public static List<UserWorkloadsSecretName> parseList(List<String> formattedStrings) {
        ArrayList<UserWorkloadsSecretName> list = new ArrayList<UserWorkloadsSecretName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserWorkloadsSecretName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserWorkloadsSecretName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserWorkloadsSecretName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_SECRET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserWorkloadsSecretName userWorkloadsSecretName = this;
            synchronized (userWorkloadsSecretName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.userWorkloadsSecret != null) {
                        fieldMapBuilder.put((Object)"user_workloads_secret", (Object)this.userWorkloadsSecret);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_SECRET.instantiate(new String[]{"project", this.project, "location", this.location, "environment", this.environment, "user_workloads_secret", this.userWorkloadsSecret});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserWorkloadsSecretName that = (UserWorkloadsSecretName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.environment, that.environment) && Objects.equals(this.userWorkloadsSecret, that.userWorkloadsSecret);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userWorkloadsSecret);
    }

    public static class Builder {
        private String project;
        private String location;
        private String environment;
        private String userWorkloadsSecret;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUserWorkloadsSecret() {
            return this.userWorkloadsSecret;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setUserWorkloadsSecret(String userWorkloadsSecret) {
            this.userWorkloadsSecret = userWorkloadsSecret;
            return this;
        }

        private Builder(UserWorkloadsSecretName userWorkloadsSecretName) {
            this.project = userWorkloadsSecretName.project;
            this.location = userWorkloadsSecretName.location;
            this.environment = userWorkloadsSecretName.environment;
            this.userWorkloadsSecret = userWorkloadsSecretName.userWorkloadsSecret;
        }

        public UserWorkloadsSecretName build() {
            return new UserWorkloadsSecretName(this);
        }
    }
}

