/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v1/orgpolicy.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.orgpolicy.v1;

/**
 *
 *
 * <pre>
 * Defines a Cloud Organization `Policy` which is used to specify `Constraints`
 * for configurations of Cloud Platform resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orgpolicy.v1.Policy}
 */
public final class Policy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v1.Policy)
    PolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Policy.newBuilder() to construct.
  private Policy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Policy() {
    constraint_ = "";
    etag_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Policy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orgpolicy.v1.OrgPolicyProto
        .internal_static_google_cloud_orgpolicy_v1_Policy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orgpolicy.v1.OrgPolicyProto
        .internal_static_google_cloud_orgpolicy_v1_Policy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orgpolicy.v1.Policy.class,
            com.google.cloud.orgpolicy.v1.Policy.Builder.class);
  }

  public interface ListPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v1.Policy.ListPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @return A list containing the allowedValues.
     */
    java.util.List<java.lang.String> getAllowedValuesList();
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @return The count of allowedValues.
     */
    int getAllowedValuesCount();
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedValues at the given index.
     */
    java.lang.String getAllowedValues(int index);
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedValues at the given index.
     */
    com.google.protobuf.ByteString getAllowedValuesBytes(int index);

    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @return A list containing the deniedValues.
     */
    java.util.List<java.lang.String> getDeniedValuesList();
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @return The count of deniedValues.
     */
    int getDeniedValuesCount();
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The deniedValues at the given index.
     */
    java.lang.String getDeniedValues(int index);
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the deniedValues at the given index.
     */
    com.google.protobuf.ByteString getDeniedValuesBytes(int index);

    /**
     *
     *
     * <pre>
     * The policy all_values state.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
     *
     * @return The enum numeric value on the wire for allValues.
     */
    int getAllValuesValue();
    /**
     *
     *
     * <pre>
     * The policy all_values state.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
     *
     * @return The allValues.
     */
    com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues getAllValues();

    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Console will try to default to a configuration
     * that matches the value specified in this `Policy`. If `suggested_value`
     * is not set, it will inherit the value specified higher in the hierarchy,
     * unless `inherit_from_parent` is `false`.
     * </pre>
     *
     * <code>string suggested_value = 4;</code>
     *
     * @return The suggestedValue.
     */
    java.lang.String getSuggestedValue();
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Console will try to default to a configuration
     * that matches the value specified in this `Policy`. If `suggested_value`
     * is not set, it will inherit the value specified higher in the hierarchy,
     * unless `inherit_from_parent` is `false`.
     * </pre>
     *
     * <code>string suggested_value = 4;</code>
     *
     * @return The bytes for suggestedValue.
     */
    com.google.protobuf.ByteString getSuggestedValueBytes();

    /**
     *
     *
     * <pre>
     * Determines the inheritance behavior for this `Policy`.
     *
     * By default, a `ListPolicy` set at a resource supercedes any `Policy` set
     * anywhere up the resource hierarchy. However, if `inherit_from_parent` is
     * set to `true`, then the values from the effective `Policy` of the parent
     * resource are inherited, meaning the values set in this `Policy` are
     * added to the values inherited up the hierarchy.
     *
     * Setting `Policy` hierarchies that inherit both allowed values and denied
     * values isn't recommended in most circumstances to keep the configuration
     * simple and understandable. However, it is possible to set a `Policy` with
     * `allowed_values` set that inherits a `Policy` with `denied_values` set.
     * In this case, the values that are allowed must be in `allowed_values` and
     * not present in `denied_values`.
     *
     * For example, suppose you have a `Constraint`
     * `constraints/serviceuser.services`, which has a `constraint_type` of
     * `list_constraint`, and with `constraint_default` set to `ALLOW`.
     * Suppose that at the Organization level, a `Policy` is applied that
     * restricts the allowed API activations to {`E1`, `E2`}. Then, if a
     * `Policy` is applied to a project below the Organization that has
     * `inherit_from_parent` set to `false` and field all_values set to DENY,
     * then an attempt to activate any API will be denied.
     *
     * The following examples demonstrate different possible layerings for
     * `projects/bar` parented by `organizations/foo`:
     *
     * Example 1 (no inherited values):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values:"E2"}
     *   `projects/bar` has `inherit_from_parent` `false` and values:
     *     {allowed_values: "E3" allowed_values: "E4"}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The accepted values at `projects/bar` are `E3`, and `E4`.
     *
     * Example 2 (inherited values):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values:"E2"}
     *   `projects/bar` has a `Policy` with values:
     *     {value: "E3" value: "E4" inherit_from_parent: true}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
     *
     * Example 3 (inheriting both allowed and denied values):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values: "E2"}
     *   `projects/bar` has a `Policy` with:
     *     {denied_values: "E1"}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The value accepted at `projects/bar` is `E2`.
     *
     * Example 4 (RestoreDefault):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values:"E2"}
     *   `projects/bar` has a `Policy` with values:
     *     {RestoreDefault: {}}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The accepted values at `projects/bar` are either all or none depending on
     * the value of `constraint_default` (if `ALLOW`, all; if
     * `DENY`, none).
     *
     * Example 5 (no policy inherits parent policy):
     *   `organizations/foo` has no `Policy` set.
     *   `projects/bar` has no `Policy` set.
     * The accepted values at both levels are either all or none depending on
     * the value of `constraint_default` (if `ALLOW`, all; if
     * `DENY`, none).
     *
     * Example 6 (ListConstraint allowing all):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values: "E2"}
     *   `projects/bar` has a `Policy` with:
     *     {all: ALLOW}
     * The accepted values at `organizations/foo` are `E1`, E2`.
     * Any value is accepted at `projects/bar`.
     *
     * Example 7 (ListConstraint allowing none):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values: "E2"}
     *   `projects/bar` has a `Policy` with:
     *     {all: DENY}
     * The accepted values at `organizations/foo` are `E1`, E2`.
     * No value is accepted at `projects/bar`.
     *
     * Example 10 (allowed and denied subtrees of Resource Manager hierarchy):
     * Given the following resource hierarchy
     *   O1-&gt;{F1, F2}; F1-&gt;{P1}; F2-&gt;{P2, P3},
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "under:organizations/O1"}
     *   `projects/bar` has a `Policy` with:
     *     {allowed_values: "under:projects/P3"}
     *     {denied_values: "under:folders/F2"}
     * The accepted values at `organizations/foo` are `organizations/O1`,
     *   `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`,
     *   `projects/P3`.
     * The accepted values at `projects/bar` are `organizations/O1`,
     *   `folders/F1`, `projects/P1`.
     * </pre>
     *
     * <code>bool inherit_from_parent = 5;</code>
     *
     * @return The inheritFromParent.
     */
    boolean getInheritFromParent();
  }
  /**
   *
   *
   * <pre>
   * Used in `policy_type` to specify how `list_policy` behaves at this
   * resource.
   *
   * `ListPolicy` can define specific values and subtrees of Cloud Resource
   * Manager resource hierarchy (`Organizations`, `Folders`, `Projects`) that
   * are allowed or denied by setting the `allowed_values` and `denied_values`
   * fields. This is achieved by using the `under:` and optional `is:` prefixes.
   * The `under:` prefix is used to denote resource subtree values.
   * The `is:` prefix is used to denote specific values, and is required only
   * if the value contains a ":". Values prefixed with "is:" are treated the
   * same as values with no prefix.
   * Ancestry subtrees must be in one of the following formats:
   *     - "projects/&lt;project-id&gt;", e.g. "projects/tokyo-rain-123"
   *     - "folders/&lt;folder-id&gt;", e.g. "folders/1234"
   *     - "organizations/&lt;organization-id&gt;", e.g. "organizations/1234"
   * The `supports_under` field of the associated `Constraint`  defines whether
   * ancestry prefixes can be used. You can set `allowed_values` and
   * `denied_values` in the same `Policy` if `all_values` is
   * `ALL_VALUES_UNSPECIFIED`. `ALLOW` or `DENY` are used to allow or deny all
   * values. If `all_values` is set to either `ALLOW` or `DENY`,
   * `allowed_values` and `denied_values` must be unset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v1.Policy.ListPolicy}
   */
  public static final class ListPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v1.Policy.ListPolicy)
      ListPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPolicy.newBuilder() to construct.
    private ListPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPolicy() {
      allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      deniedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      allValues_ = 0;
      suggestedValue_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_ListPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_ListPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v1.Policy.ListPolicy.class,
              com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * This enum can be used to set `Policies` that apply to all possible
     * configuration values rather than specific values in `allowed_values` or
     * `denied_values`.
     *
     * Settting this to `ALLOW` will mean this `Policy` allows all values.
     * Similarly, setting it to `DENY` will mean no values are allowed. If
     * set to either `ALLOW` or `DENY,  `allowed_values` and `denied_values`
     * must be unset. Setting this to `ALL_VALUES_UNSPECIFIED` allows for
     * setting `allowed_values` and `denied_values`.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues}
     */
    public enum AllValues implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Indicates that allowed_values or denied_values must be set.
       * </pre>
       *
       * <code>ALL_VALUES_UNSPECIFIED = 0;</code>
       */
      ALL_VALUES_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * A policy with this set allows all values.
       * </pre>
       *
       * <code>ALLOW = 1;</code>
       */
      ALLOW(1),
      /**
       *
       *
       * <pre>
       * A policy with this set denies all values.
       * </pre>
       *
       * <code>DENY = 2;</code>
       */
      DENY(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Indicates that allowed_values or denied_values must be set.
       * </pre>
       *
       * <code>ALL_VALUES_UNSPECIFIED = 0;</code>
       */
      public static final int ALL_VALUES_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * A policy with this set allows all values.
       * </pre>
       *
       * <code>ALLOW = 1;</code>
       */
      public static final int ALLOW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * A policy with this set denies all values.
       * </pre>
       *
       * <code>DENY = 2;</code>
       */
      public static final int DENY_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AllValues valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AllValues forNumber(int value) {
        switch (value) {
          case 0:
            return ALL_VALUES_UNSPECIFIED;
          case 1:
            return ALLOW;
          case 2:
            return DENY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AllValues> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<AllValues> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<AllValues>() {
            public AllValues findValueByNumber(int number) {
              return AllValues.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final AllValues[] VALUES = values();

      public static AllValues valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AllValues(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues)
    }

    public static final int ALLOWED_VALUES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowedValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @return A list containing the allowedValues.
     */
    public com.google.protobuf.ProtocolStringList getAllowedValuesList() {
      return allowedValues_;
    }
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @return The count of allowedValues.
     */
    public int getAllowedValuesCount() {
      return allowedValues_.size();
    }
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedValues at the given index.
     */
    public java.lang.String getAllowedValues(int index) {
      return allowedValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of values allowed  at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string allowed_values = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedValues at the given index.
     */
    public com.google.protobuf.ByteString getAllowedValuesBytes(int index) {
      return allowedValues_.getByteString(index);
    }

    public static final int DENIED_VALUES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList deniedValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @return A list containing the deniedValues.
     */
    public com.google.protobuf.ProtocolStringList getDeniedValuesList() {
      return deniedValues_;
    }
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @return The count of deniedValues.
     */
    public int getDeniedValuesCount() {
      return deniedValues_.size();
    }
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The deniedValues at the given index.
     */
    public java.lang.String getDeniedValues(int index) {
      return deniedValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of values denied at this resource. Can only be set if `all_values`
     * is set to `ALL_VALUES_UNSPECIFIED`.
     * </pre>
     *
     * <code>repeated string denied_values = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the deniedValues at the given index.
     */
    public com.google.protobuf.ByteString getDeniedValuesBytes(int index) {
      return deniedValues_.getByteString(index);
    }

    public static final int ALL_VALUES_FIELD_NUMBER = 3;
    private int allValues_ = 0;
    /**
     *
     *
     * <pre>
     * The policy all_values state.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
     *
     * @return The enum numeric value on the wire for allValues.
     */
    @java.lang.Override
    public int getAllValuesValue() {
      return allValues_;
    }
    /**
     *
     *
     * <pre>
     * The policy all_values state.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
     *
     * @return The allValues.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues getAllValues() {
      com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues result =
          com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues.forNumber(allValues_);
      return result == null
          ? com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues.UNRECOGNIZED
          : result;
    }

    public static final int SUGGESTED_VALUE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestedValue_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Console will try to default to a configuration
     * that matches the value specified in this `Policy`. If `suggested_value`
     * is not set, it will inherit the value specified higher in the hierarchy,
     * unless `inherit_from_parent` is `false`.
     * </pre>
     *
     * <code>string suggested_value = 4;</code>
     *
     * @return The suggestedValue.
     */
    @java.lang.Override
    public java.lang.String getSuggestedValue() {
      java.lang.Object ref = suggestedValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestedValue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud Console will try to default to a configuration
     * that matches the value specified in this `Policy`. If `suggested_value`
     * is not set, it will inherit the value specified higher in the hierarchy,
     * unless `inherit_from_parent` is `false`.
     * </pre>
     *
     * <code>string suggested_value = 4;</code>
     *
     * @return The bytes for suggestedValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestedValueBytes() {
      java.lang.Object ref = suggestedValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestedValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INHERIT_FROM_PARENT_FIELD_NUMBER = 5;
    private boolean inheritFromParent_ = false;
    /**
     *
     *
     * <pre>
     * Determines the inheritance behavior for this `Policy`.
     *
     * By default, a `ListPolicy` set at a resource supercedes any `Policy` set
     * anywhere up the resource hierarchy. However, if `inherit_from_parent` is
     * set to `true`, then the values from the effective `Policy` of the parent
     * resource are inherited, meaning the values set in this `Policy` are
     * added to the values inherited up the hierarchy.
     *
     * Setting `Policy` hierarchies that inherit both allowed values and denied
     * values isn't recommended in most circumstances to keep the configuration
     * simple and understandable. However, it is possible to set a `Policy` with
     * `allowed_values` set that inherits a `Policy` with `denied_values` set.
     * In this case, the values that are allowed must be in `allowed_values` and
     * not present in `denied_values`.
     *
     * For example, suppose you have a `Constraint`
     * `constraints/serviceuser.services`, which has a `constraint_type` of
     * `list_constraint`, and with `constraint_default` set to `ALLOW`.
     * Suppose that at the Organization level, a `Policy` is applied that
     * restricts the allowed API activations to {`E1`, `E2`}. Then, if a
     * `Policy` is applied to a project below the Organization that has
     * `inherit_from_parent` set to `false` and field all_values set to DENY,
     * then an attempt to activate any API will be denied.
     *
     * The following examples demonstrate different possible layerings for
     * `projects/bar` parented by `organizations/foo`:
     *
     * Example 1 (no inherited values):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values:"E2"}
     *   `projects/bar` has `inherit_from_parent` `false` and values:
     *     {allowed_values: "E3" allowed_values: "E4"}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The accepted values at `projects/bar` are `E3`, and `E4`.
     *
     * Example 2 (inherited values):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values:"E2"}
     *   `projects/bar` has a `Policy` with values:
     *     {value: "E3" value: "E4" inherit_from_parent: true}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
     *
     * Example 3 (inheriting both allowed and denied values):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values: "E2"}
     *   `projects/bar` has a `Policy` with:
     *     {denied_values: "E1"}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The value accepted at `projects/bar` is `E2`.
     *
     * Example 4 (RestoreDefault):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values:"E2"}
     *   `projects/bar` has a `Policy` with values:
     *     {RestoreDefault: {}}
     * The accepted values at `organizations/foo` are `E1`, `E2`.
     * The accepted values at `projects/bar` are either all or none depending on
     * the value of `constraint_default` (if `ALLOW`, all; if
     * `DENY`, none).
     *
     * Example 5 (no policy inherits parent policy):
     *   `organizations/foo` has no `Policy` set.
     *   `projects/bar` has no `Policy` set.
     * The accepted values at both levels are either all or none depending on
     * the value of `constraint_default` (if `ALLOW`, all; if
     * `DENY`, none).
     *
     * Example 6 (ListConstraint allowing all):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values: "E2"}
     *   `projects/bar` has a `Policy` with:
     *     {all: ALLOW}
     * The accepted values at `organizations/foo` are `E1`, E2`.
     * Any value is accepted at `projects/bar`.
     *
     * Example 7 (ListConstraint allowing none):
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "E1" allowed_values: "E2"}
     *   `projects/bar` has a `Policy` with:
     *     {all: DENY}
     * The accepted values at `organizations/foo` are `E1`, E2`.
     * No value is accepted at `projects/bar`.
     *
     * Example 10 (allowed and denied subtrees of Resource Manager hierarchy):
     * Given the following resource hierarchy
     *   O1-&gt;{F1, F2}; F1-&gt;{P1}; F2-&gt;{P2, P3},
     *   `organizations/foo` has a `Policy` with values:
     *     {allowed_values: "under:organizations/O1"}
     *   `projects/bar` has a `Policy` with:
     *     {allowed_values: "under:projects/P3"}
     *     {denied_values: "under:folders/F2"}
     * The accepted values at `organizations/foo` are `organizations/O1`,
     *   `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`,
     *   `projects/P3`.
     * The accepted values at `projects/bar` are `organizations/O1`,
     *   `folders/F1`, `projects/P1`.
     * </pre>
     *
     * <code>bool inherit_from_parent = 5;</code>
     *
     * @return The inheritFromParent.
     */
    @java.lang.Override
    public boolean getInheritFromParent() {
      return inheritFromParent_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < allowedValues_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowedValues_.getRaw(i));
      }
      for (int i = 0; i < deniedValues_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deniedValues_.getRaw(i));
      }
      if (allValues_
          != com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues.ALL_VALUES_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, allValues_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestedValue_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, suggestedValue_);
      }
      if (inheritFromParent_ != false) {
        output.writeBool(5, inheritFromParent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < allowedValues_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedValues_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedValuesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < deniedValues_.size(); i++) {
          dataSize += computeStringSizeNoTag(deniedValues_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDeniedValuesList().size();
      }
      if (allValues_
          != com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues.ALL_VALUES_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, allValues_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestedValue_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, suggestedValue_);
      }
      if (inheritFromParent_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, inheritFromParent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.orgpolicy.v1.Policy.ListPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.orgpolicy.v1.Policy.ListPolicy other =
          (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) obj;

      if (!getAllowedValuesList().equals(other.getAllowedValuesList())) return false;
      if (!getDeniedValuesList().equals(other.getDeniedValuesList())) return false;
      if (allValues_ != other.allValues_) return false;
      if (!getSuggestedValue().equals(other.getSuggestedValue())) return false;
      if (getInheritFromParent() != other.getInheritFromParent()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllowedValuesCount() > 0) {
        hash = (37 * hash) + ALLOWED_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedValuesList().hashCode();
      }
      if (getDeniedValuesCount() > 0) {
        hash = (37 * hash) + DENIED_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getDeniedValuesList().hashCode();
      }
      hash = (37 * hash) + ALL_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + allValues_;
      hash = (37 * hash) + SUGGESTED_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestedValue().hashCode();
      hash = (37 * hash) + INHERIT_FROM_PARENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInheritFromParent());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.orgpolicy.v1.Policy.ListPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Used in `policy_type` to specify how `list_policy` behaves at this
     * resource.
     *
     * `ListPolicy` can define specific values and subtrees of Cloud Resource
     * Manager resource hierarchy (`Organizations`, `Folders`, `Projects`) that
     * are allowed or denied by setting the `allowed_values` and `denied_values`
     * fields. This is achieved by using the `under:` and optional `is:` prefixes.
     * The `under:` prefix is used to denote resource subtree values.
     * The `is:` prefix is used to denote specific values, and is required only
     * if the value contains a ":". Values prefixed with "is:" are treated the
     * same as values with no prefix.
     * Ancestry subtrees must be in one of the following formats:
     *     - "projects/&lt;project-id&gt;", e.g. "projects/tokyo-rain-123"
     *     - "folders/&lt;folder-id&gt;", e.g. "folders/1234"
     *     - "organizations/&lt;organization-id&gt;", e.g. "organizations/1234"
     * The `supports_under` field of the associated `Constraint`  defines whether
     * ancestry prefixes can be used. You can set `allowed_values` and
     * `denied_values` in the same `Policy` if `all_values` is
     * `ALL_VALUES_UNSPECIFIED`. `ALLOW` or `DENY` are used to allow or deny all
     * values. If `all_values` is set to either `ALLOW` or `DENY`,
     * `allowed_values` and `denied_values` must be unset.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v1.Policy.ListPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v1.Policy.ListPolicy)
        com.google.cloud.orgpolicy.v1.Policy.ListPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_ListPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_ListPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v1.Policy.ListPolicy.class,
                com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder.class);
      }

      // Construct using com.google.cloud.orgpolicy.v1.Policy.ListPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        deniedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        allValues_ = 0;
        suggestedValue_ = "";
        inheritFromParent_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_ListPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.ListPolicy getDefaultInstanceForType() {
        return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.ListPolicy build() {
        com.google.cloud.orgpolicy.v1.Policy.ListPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.ListPolicy buildPartial() {
        com.google.cloud.orgpolicy.v1.Policy.ListPolicy result =
            new com.google.cloud.orgpolicy.v1.Policy.ListPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.orgpolicy.v1.Policy.ListPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          allowedValues_.makeImmutable();
          result.allowedValues_ = allowedValues_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          deniedValues_.makeImmutable();
          result.deniedValues_ = deniedValues_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.allValues_ = allValues_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.suggestedValue_ = suggestedValue_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.inheritFromParent_ = inheritFromParent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.orgpolicy.v1.Policy.ListPolicy) {
          return mergeFrom((com.google.cloud.orgpolicy.v1.Policy.ListPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.orgpolicy.v1.Policy.ListPolicy other) {
        if (other == com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance())
          return this;
        if (!other.allowedValues_.isEmpty()) {
          if (allowedValues_.isEmpty()) {
            allowedValues_ = other.allowedValues_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAllowedValuesIsMutable();
            allowedValues_.addAll(other.allowedValues_);
          }
          onChanged();
        }
        if (!other.deniedValues_.isEmpty()) {
          if (deniedValues_.isEmpty()) {
            deniedValues_ = other.deniedValues_;
            bitField0_ |= 0x00000002;
          } else {
            ensureDeniedValuesIsMutable();
            deniedValues_.addAll(other.deniedValues_);
          }
          onChanged();
        }
        if (other.allValues_ != 0) {
          setAllValuesValue(other.getAllValuesValue());
        }
        if (!other.getSuggestedValue().isEmpty()) {
          suggestedValue_ = other.suggestedValue_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.getInheritFromParent() != false) {
          setInheritFromParent(other.getInheritFromParent());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowedValuesIsMutable();
                  allowedValues_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDeniedValuesIsMutable();
                  deniedValues_.add(s);
                  break;
                } // case 18
              case 24:
                {
                  allValues_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  suggestedValue_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  inheritFromParent_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList allowedValues_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowedValuesIsMutable() {
        if (!allowedValues_.isModifiable()) {
          allowedValues_ = new com.google.protobuf.LazyStringArrayList(allowedValues_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return A list containing the allowedValues.
       */
      public com.google.protobuf.ProtocolStringList getAllowedValuesList() {
        allowedValues_.makeImmutable();
        return allowedValues_;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return The count of allowedValues.
       */
      public int getAllowedValuesCount() {
        return allowedValues_.size();
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allowedValues at the given index.
       */
      public java.lang.String getAllowedValues(int index) {
        return allowedValues_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedValues at the given index.
       */
      public com.google.protobuf.ByteString getAllowedValuesBytes(int index) {
        return allowedValues_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The allowedValues to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedValues(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedValuesIsMutable();
        allowedValues_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param value The allowedValues to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedValues(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedValuesIsMutable();
        allowedValues_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param values The allowedValues to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedValues(java.lang.Iterable<java.lang.String> values) {
        ensureAllowedValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedValues_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedValues() {
        allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed  at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param value The bytes of the allowedValues to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedValuesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowedValuesIsMutable();
        allowedValues_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList deniedValues_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDeniedValuesIsMutable() {
        if (!deniedValues_.isModifiable()) {
          deniedValues_ = new com.google.protobuf.LazyStringArrayList(deniedValues_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return A list containing the deniedValues.
       */
      public com.google.protobuf.ProtocolStringList getDeniedValuesList() {
        deniedValues_.makeImmutable();
        return deniedValues_;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return The count of deniedValues.
       */
      public int getDeniedValuesCount() {
        return deniedValues_.size();
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The deniedValues at the given index.
       */
      public java.lang.String getDeniedValues(int index) {
        return deniedValues_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the deniedValues at the given index.
       */
      public com.google.protobuf.ByteString getDeniedValuesBytes(int index) {
        return deniedValues_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The deniedValues to set.
       * @return This builder for chaining.
       */
      public Builder setDeniedValues(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedValuesIsMutable();
        deniedValues_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param value The deniedValues to add.
       * @return This builder for chaining.
       */
      public Builder addDeniedValues(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedValuesIsMutable();
        deniedValues_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param values The deniedValues to add.
       * @return This builder for chaining.
       */
      public Builder addAllDeniedValues(java.lang.Iterable<java.lang.String> values) {
        ensureDeniedValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deniedValues_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeniedValues() {
        deniedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource. Can only be set if `all_values`
       * is set to `ALL_VALUES_UNSPECIFIED`.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param value The bytes of the deniedValues to add.
       * @return This builder for chaining.
       */
      public Builder addDeniedValuesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDeniedValuesIsMutable();
        deniedValues_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int allValues_ = 0;
      /**
       *
       *
       * <pre>
       * The policy all_values state.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
       *
       * @return The enum numeric value on the wire for allValues.
       */
      @java.lang.Override
      public int getAllValuesValue() {
        return allValues_;
      }
      /**
       *
       *
       * <pre>
       * The policy all_values state.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
       *
       * @param value The enum numeric value on the wire for allValues to set.
       * @return This builder for chaining.
       */
      public Builder setAllValuesValue(int value) {
        allValues_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The policy all_values state.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
       *
       * @return The allValues.
       */
      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues getAllValues() {
        com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues result =
            com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues.forNumber(allValues_);
        return result == null
            ? com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The policy all_values state.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
       *
       * @param value The allValues to set.
       * @return This builder for chaining.
       */
      public Builder setAllValues(com.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        allValues_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The policy all_values state.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy.AllValues all_values = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllValues() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allValues_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object suggestedValue_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud Console will try to default to a configuration
       * that matches the value specified in this `Policy`. If `suggested_value`
       * is not set, it will inherit the value specified higher in the hierarchy,
       * unless `inherit_from_parent` is `false`.
       * </pre>
       *
       * <code>string suggested_value = 4;</code>
       *
       * @return The suggestedValue.
       */
      public java.lang.String getSuggestedValue() {
        java.lang.Object ref = suggestedValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestedValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud Console will try to default to a configuration
       * that matches the value specified in this `Policy`. If `suggested_value`
       * is not set, it will inherit the value specified higher in the hierarchy,
       * unless `inherit_from_parent` is `false`.
       * </pre>
       *
       * <code>string suggested_value = 4;</code>
       *
       * @return The bytes for suggestedValue.
       */
      public com.google.protobuf.ByteString getSuggestedValueBytes() {
        java.lang.Object ref = suggestedValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestedValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud Console will try to default to a configuration
       * that matches the value specified in this `Policy`. If `suggested_value`
       * is not set, it will inherit the value specified higher in the hierarchy,
       * unless `inherit_from_parent` is `false`.
       * </pre>
       *
       * <code>string suggested_value = 4;</code>
       *
       * @param value The suggestedValue to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestedValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestedValue_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud Console will try to default to a configuration
       * that matches the value specified in this `Policy`. If `suggested_value`
       * is not set, it will inherit the value specified higher in the hierarchy,
       * unless `inherit_from_parent` is `false`.
       * </pre>
       *
       * <code>string suggested_value = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestedValue() {
        suggestedValue_ = getDefaultInstance().getSuggestedValue();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud Console will try to default to a configuration
       * that matches the value specified in this `Policy`. If `suggested_value`
       * is not set, it will inherit the value specified higher in the hierarchy,
       * unless `inherit_from_parent` is `false`.
       * </pre>
       *
       * <code>string suggested_value = 4;</code>
       *
       * @param value The bytes for suggestedValue to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestedValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestedValue_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private boolean inheritFromParent_;
      /**
       *
       *
       * <pre>
       * Determines the inheritance behavior for this `Policy`.
       *
       * By default, a `ListPolicy` set at a resource supercedes any `Policy` set
       * anywhere up the resource hierarchy. However, if `inherit_from_parent` is
       * set to `true`, then the values from the effective `Policy` of the parent
       * resource are inherited, meaning the values set in this `Policy` are
       * added to the values inherited up the hierarchy.
       *
       * Setting `Policy` hierarchies that inherit both allowed values and denied
       * values isn't recommended in most circumstances to keep the configuration
       * simple and understandable. However, it is possible to set a `Policy` with
       * `allowed_values` set that inherits a `Policy` with `denied_values` set.
       * In this case, the values that are allowed must be in `allowed_values` and
       * not present in `denied_values`.
       *
       * For example, suppose you have a `Constraint`
       * `constraints/serviceuser.services`, which has a `constraint_type` of
       * `list_constraint`, and with `constraint_default` set to `ALLOW`.
       * Suppose that at the Organization level, a `Policy` is applied that
       * restricts the allowed API activations to {`E1`, `E2`}. Then, if a
       * `Policy` is applied to a project below the Organization that has
       * `inherit_from_parent` set to `false` and field all_values set to DENY,
       * then an attempt to activate any API will be denied.
       *
       * The following examples demonstrate different possible layerings for
       * `projects/bar` parented by `organizations/foo`:
       *
       * Example 1 (no inherited values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has `inherit_from_parent` `false` and values:
       *     {allowed_values: "E3" allowed_values: "E4"}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are `E3`, and `E4`.
       *
       * Example 2 (inherited values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has a `Policy` with values:
       *     {value: "E3" value: "E4" inherit_from_parent: true}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
       *
       * Example 3 (inheriting both allowed and denied values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {denied_values: "E1"}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The value accepted at `projects/bar` is `E2`.
       *
       * Example 4 (RestoreDefault):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has a `Policy` with values:
       *     {RestoreDefault: {}}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are either all or none depending on
       * the value of `constraint_default` (if `ALLOW`, all; if
       * `DENY`, none).
       *
       * Example 5 (no policy inherits parent policy):
       *   `organizations/foo` has no `Policy` set.
       *   `projects/bar` has no `Policy` set.
       * The accepted values at both levels are either all or none depending on
       * the value of `constraint_default` (if `ALLOW`, all; if
       * `DENY`, none).
       *
       * Example 6 (ListConstraint allowing all):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {all: ALLOW}
       * The accepted values at `organizations/foo` are `E1`, E2`.
       * Any value is accepted at `projects/bar`.
       *
       * Example 7 (ListConstraint allowing none):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {all: DENY}
       * The accepted values at `organizations/foo` are `E1`, E2`.
       * No value is accepted at `projects/bar`.
       *
       * Example 10 (allowed and denied subtrees of Resource Manager hierarchy):
       * Given the following resource hierarchy
       *   O1-&gt;{F1, F2}; F1-&gt;{P1}; F2-&gt;{P2, P3},
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "under:organizations/O1"}
       *   `projects/bar` has a `Policy` with:
       *     {allowed_values: "under:projects/P3"}
       *     {denied_values: "under:folders/F2"}
       * The accepted values at `organizations/foo` are `organizations/O1`,
       *   `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`,
       *   `projects/P3`.
       * The accepted values at `projects/bar` are `organizations/O1`,
       *   `folders/F1`, `projects/P1`.
       * </pre>
       *
       * <code>bool inherit_from_parent = 5;</code>
       *
       * @return The inheritFromParent.
       */
      @java.lang.Override
      public boolean getInheritFromParent() {
        return inheritFromParent_;
      }
      /**
       *
       *
       * <pre>
       * Determines the inheritance behavior for this `Policy`.
       *
       * By default, a `ListPolicy` set at a resource supercedes any `Policy` set
       * anywhere up the resource hierarchy. However, if `inherit_from_parent` is
       * set to `true`, then the values from the effective `Policy` of the parent
       * resource are inherited, meaning the values set in this `Policy` are
       * added to the values inherited up the hierarchy.
       *
       * Setting `Policy` hierarchies that inherit both allowed values and denied
       * values isn't recommended in most circumstances to keep the configuration
       * simple and understandable. However, it is possible to set a `Policy` with
       * `allowed_values` set that inherits a `Policy` with `denied_values` set.
       * In this case, the values that are allowed must be in `allowed_values` and
       * not present in `denied_values`.
       *
       * For example, suppose you have a `Constraint`
       * `constraints/serviceuser.services`, which has a `constraint_type` of
       * `list_constraint`, and with `constraint_default` set to `ALLOW`.
       * Suppose that at the Organization level, a `Policy` is applied that
       * restricts the allowed API activations to {`E1`, `E2`}. Then, if a
       * `Policy` is applied to a project below the Organization that has
       * `inherit_from_parent` set to `false` and field all_values set to DENY,
       * then an attempt to activate any API will be denied.
       *
       * The following examples demonstrate different possible layerings for
       * `projects/bar` parented by `organizations/foo`:
       *
       * Example 1 (no inherited values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has `inherit_from_parent` `false` and values:
       *     {allowed_values: "E3" allowed_values: "E4"}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are `E3`, and `E4`.
       *
       * Example 2 (inherited values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has a `Policy` with values:
       *     {value: "E3" value: "E4" inherit_from_parent: true}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
       *
       * Example 3 (inheriting both allowed and denied values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {denied_values: "E1"}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The value accepted at `projects/bar` is `E2`.
       *
       * Example 4 (RestoreDefault):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has a `Policy` with values:
       *     {RestoreDefault: {}}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are either all or none depending on
       * the value of `constraint_default` (if `ALLOW`, all; if
       * `DENY`, none).
       *
       * Example 5 (no policy inherits parent policy):
       *   `organizations/foo` has no `Policy` set.
       *   `projects/bar` has no `Policy` set.
       * The accepted values at both levels are either all or none depending on
       * the value of `constraint_default` (if `ALLOW`, all; if
       * `DENY`, none).
       *
       * Example 6 (ListConstraint allowing all):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {all: ALLOW}
       * The accepted values at `organizations/foo` are `E1`, E2`.
       * Any value is accepted at `projects/bar`.
       *
       * Example 7 (ListConstraint allowing none):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {all: DENY}
       * The accepted values at `organizations/foo` are `E1`, E2`.
       * No value is accepted at `projects/bar`.
       *
       * Example 10 (allowed and denied subtrees of Resource Manager hierarchy):
       * Given the following resource hierarchy
       *   O1-&gt;{F1, F2}; F1-&gt;{P1}; F2-&gt;{P2, P3},
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "under:organizations/O1"}
       *   `projects/bar` has a `Policy` with:
       *     {allowed_values: "under:projects/P3"}
       *     {denied_values: "under:folders/F2"}
       * The accepted values at `organizations/foo` are `organizations/O1`,
       *   `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`,
       *   `projects/P3`.
       * The accepted values at `projects/bar` are `organizations/O1`,
       *   `folders/F1`, `projects/P1`.
       * </pre>
       *
       * <code>bool inherit_from_parent = 5;</code>
       *
       * @param value The inheritFromParent to set.
       * @return This builder for chaining.
       */
      public Builder setInheritFromParent(boolean value) {

        inheritFromParent_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Determines the inheritance behavior for this `Policy`.
       *
       * By default, a `ListPolicy` set at a resource supercedes any `Policy` set
       * anywhere up the resource hierarchy. However, if `inherit_from_parent` is
       * set to `true`, then the values from the effective `Policy` of the parent
       * resource are inherited, meaning the values set in this `Policy` are
       * added to the values inherited up the hierarchy.
       *
       * Setting `Policy` hierarchies that inherit both allowed values and denied
       * values isn't recommended in most circumstances to keep the configuration
       * simple and understandable. However, it is possible to set a `Policy` with
       * `allowed_values` set that inherits a `Policy` with `denied_values` set.
       * In this case, the values that are allowed must be in `allowed_values` and
       * not present in `denied_values`.
       *
       * For example, suppose you have a `Constraint`
       * `constraints/serviceuser.services`, which has a `constraint_type` of
       * `list_constraint`, and with `constraint_default` set to `ALLOW`.
       * Suppose that at the Organization level, a `Policy` is applied that
       * restricts the allowed API activations to {`E1`, `E2`}. Then, if a
       * `Policy` is applied to a project below the Organization that has
       * `inherit_from_parent` set to `false` and field all_values set to DENY,
       * then an attempt to activate any API will be denied.
       *
       * The following examples demonstrate different possible layerings for
       * `projects/bar` parented by `organizations/foo`:
       *
       * Example 1 (no inherited values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has `inherit_from_parent` `false` and values:
       *     {allowed_values: "E3" allowed_values: "E4"}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are `E3`, and `E4`.
       *
       * Example 2 (inherited values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has a `Policy` with values:
       *     {value: "E3" value: "E4" inherit_from_parent: true}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
       *
       * Example 3 (inheriting both allowed and denied values):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {denied_values: "E1"}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The value accepted at `projects/bar` is `E2`.
       *
       * Example 4 (RestoreDefault):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values:"E2"}
       *   `projects/bar` has a `Policy` with values:
       *     {RestoreDefault: {}}
       * The accepted values at `organizations/foo` are `E1`, `E2`.
       * The accepted values at `projects/bar` are either all or none depending on
       * the value of `constraint_default` (if `ALLOW`, all; if
       * `DENY`, none).
       *
       * Example 5 (no policy inherits parent policy):
       *   `organizations/foo` has no `Policy` set.
       *   `projects/bar` has no `Policy` set.
       * The accepted values at both levels are either all or none depending on
       * the value of `constraint_default` (if `ALLOW`, all; if
       * `DENY`, none).
       *
       * Example 6 (ListConstraint allowing all):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {all: ALLOW}
       * The accepted values at `organizations/foo` are `E1`, E2`.
       * Any value is accepted at `projects/bar`.
       *
       * Example 7 (ListConstraint allowing none):
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "E1" allowed_values: "E2"}
       *   `projects/bar` has a `Policy` with:
       *     {all: DENY}
       * The accepted values at `organizations/foo` are `E1`, E2`.
       * No value is accepted at `projects/bar`.
       *
       * Example 10 (allowed and denied subtrees of Resource Manager hierarchy):
       * Given the following resource hierarchy
       *   O1-&gt;{F1, F2}; F1-&gt;{P1}; F2-&gt;{P2, P3},
       *   `organizations/foo` has a `Policy` with values:
       *     {allowed_values: "under:organizations/O1"}
       *   `projects/bar` has a `Policy` with:
       *     {allowed_values: "under:projects/P3"}
       *     {denied_values: "under:folders/F2"}
       * The accepted values at `organizations/foo` are `organizations/O1`,
       *   `folders/F1`, `folders/F2`, `projects/P1`, `projects/P2`,
       *   `projects/P3`.
       * The accepted values at `projects/bar` are `organizations/O1`,
       *   `folders/F1`, `projects/P1`.
       * </pre>
       *
       * <code>bool inherit_from_parent = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInheritFromParent() {
        bitField0_ = (bitField0_ & ~0x00000010);
        inheritFromParent_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v1.Policy.ListPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v1.Policy.ListPolicy)
    private static final com.google.cloud.orgpolicy.v1.Policy.ListPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v1.Policy.ListPolicy();
    }

    public static com.google.cloud.orgpolicy.v1.Policy.ListPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPolicy> PARSER =
        new com.google.protobuf.AbstractParser<ListPolicy>() {
          @java.lang.Override
          public ListPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.ListPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BooleanPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v1.Policy.BooleanPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If `true`, then the `Policy` is enforced. If `false`, then any
     * configuration is acceptable.
     *
     * Suppose you have a `Constraint`
     * `constraints/compute.disableSerialPortAccess` with `constraint_default`
     * set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
     * behavior:
     *   - If the `Policy` at this resource has enforced set to `false`, serial
     *     port connection attempts will be allowed.
     *   - If the `Policy` at this resource has enforced set to `true`, serial
     *     port connection attempts will be refused.
     *   - If the `Policy` at this resource is `RestoreDefault`, serial port
     *     connection attempts will be allowed.
     *   - If no `Policy` is set at this resource or anywhere higher in the
     *     resource hierarchy, serial port connection attempts will be allowed.
     *   - If no `Policy` is set at this resource, but one exists higher in the
     *     resource hierarchy, the behavior is as if the`Policy` were set at
     *     this resource.
     *
     * The following examples demonstrate the different possible layerings:
     *
     * Example 1 (nearest `Constraint` wins):
     *   `organizations/foo` has a `Policy` with:
     *     {enforced: false}
     *   `projects/bar` has no `Policy` set.
     * The constraint at `projects/bar` and `organizations/foo` will not be
     * enforced.
     *
     * Example 2 (enforcement gets replaced):
     *   `organizations/foo` has a `Policy` with:
     *     {enforced: false}
     *   `projects/bar` has a `Policy` with:
     *     {enforced: true}
     * The constraint at `organizations/foo` is not enforced.
     * The constraint at `projects/bar` is enforced.
     *
     * Example 3 (RestoreDefault):
     *   `organizations/foo` has a `Policy` with:
     *     {enforced: true}
     *   `projects/bar` has a `Policy` with:
     *     {RestoreDefault: {}}
     * The constraint at `organizations/foo` is enforced.
     * The constraint at `projects/bar` is not enforced, because
     * `constraint_default` for the `Constraint` is `ALLOW`.
     * </pre>
     *
     * <code>bool enforced = 1;</code>
     *
     * @return The enforced.
     */
    boolean getEnforced();
  }
  /**
   *
   *
   * <pre>
   * Used in `policy_type` to specify how `boolean_policy` will behave at this
   * resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v1.Policy.BooleanPolicy}
   */
  public static final class BooleanPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v1.Policy.BooleanPolicy)
      BooleanPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BooleanPolicy.newBuilder() to construct.
    private BooleanPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BooleanPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BooleanPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_BooleanPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_BooleanPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.class,
              com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder.class);
    }

    public static final int ENFORCED_FIELD_NUMBER = 1;
    private boolean enforced_ = false;
    /**
     *
     *
     * <pre>
     * If `true`, then the `Policy` is enforced. If `false`, then any
     * configuration is acceptable.
     *
     * Suppose you have a `Constraint`
     * `constraints/compute.disableSerialPortAccess` with `constraint_default`
     * set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
     * behavior:
     *   - If the `Policy` at this resource has enforced set to `false`, serial
     *     port connection attempts will be allowed.
     *   - If the `Policy` at this resource has enforced set to `true`, serial
     *     port connection attempts will be refused.
     *   - If the `Policy` at this resource is `RestoreDefault`, serial port
     *     connection attempts will be allowed.
     *   - If no `Policy` is set at this resource or anywhere higher in the
     *     resource hierarchy, serial port connection attempts will be allowed.
     *   - If no `Policy` is set at this resource, but one exists higher in the
     *     resource hierarchy, the behavior is as if the`Policy` were set at
     *     this resource.
     *
     * The following examples demonstrate the different possible layerings:
     *
     * Example 1 (nearest `Constraint` wins):
     *   `organizations/foo` has a `Policy` with:
     *     {enforced: false}
     *   `projects/bar` has no `Policy` set.
     * The constraint at `projects/bar` and `organizations/foo` will not be
     * enforced.
     *
     * Example 2 (enforcement gets replaced):
     *   `organizations/foo` has a `Policy` with:
     *     {enforced: false}
     *   `projects/bar` has a `Policy` with:
     *     {enforced: true}
     * The constraint at `organizations/foo` is not enforced.
     * The constraint at `projects/bar` is enforced.
     *
     * Example 3 (RestoreDefault):
     *   `organizations/foo` has a `Policy` with:
     *     {enforced: true}
     *   `projects/bar` has a `Policy` with:
     *     {RestoreDefault: {}}
     * The constraint at `organizations/foo` is enforced.
     * The constraint at `projects/bar` is not enforced, because
     * `constraint_default` for the `Constraint` is `ALLOW`.
     * </pre>
     *
     * <code>bool enforced = 1;</code>
     *
     * @return The enforced.
     */
    @java.lang.Override
    public boolean getEnforced() {
      return enforced_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enforced_ != false) {
        output.writeBool(1, enforced_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enforced_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enforced_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy other =
          (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) obj;

      if (getEnforced() != other.getEnforced()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENFORCED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnforced());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Used in `policy_type` to specify how `boolean_policy` will behave at this
     * resource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v1.Policy.BooleanPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v1.Policy.BooleanPolicy)
        com.google.cloud.orgpolicy.v1.Policy.BooleanPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_BooleanPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_BooleanPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.class,
                com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder.class);
      }

      // Construct using com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enforced_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_BooleanPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy getDefaultInstanceForType() {
        return com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy build() {
        com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy buildPartial() {
        com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy result =
            new com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enforced_ = enforced_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) {
          return mergeFrom((com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy other) {
        if (other == com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance())
          return this;
        if (other.getEnforced() != false) {
          setEnforced(other.getEnforced());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enforced_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enforced_;
      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       *
       * Suppose you have a `Constraint`
       * `constraints/compute.disableSerialPortAccess` with `constraint_default`
       * set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
       * behavior:
       *   - If the `Policy` at this resource has enforced set to `false`, serial
       *     port connection attempts will be allowed.
       *   - If the `Policy` at this resource has enforced set to `true`, serial
       *     port connection attempts will be refused.
       *   - If the `Policy` at this resource is `RestoreDefault`, serial port
       *     connection attempts will be allowed.
       *   - If no `Policy` is set at this resource or anywhere higher in the
       *     resource hierarchy, serial port connection attempts will be allowed.
       *   - If no `Policy` is set at this resource, but one exists higher in the
       *     resource hierarchy, the behavior is as if the`Policy` were set at
       *     this resource.
       *
       * The following examples demonstrate the different possible layerings:
       *
       * Example 1 (nearest `Constraint` wins):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: false}
       *   `projects/bar` has no `Policy` set.
       * The constraint at `projects/bar` and `organizations/foo` will not be
       * enforced.
       *
       * Example 2 (enforcement gets replaced):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: false}
       *   `projects/bar` has a `Policy` with:
       *     {enforced: true}
       * The constraint at `organizations/foo` is not enforced.
       * The constraint at `projects/bar` is enforced.
       *
       * Example 3 (RestoreDefault):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: true}
       *   `projects/bar` has a `Policy` with:
       *     {RestoreDefault: {}}
       * The constraint at `organizations/foo` is enforced.
       * The constraint at `projects/bar` is not enforced, because
       * `constraint_default` for the `Constraint` is `ALLOW`.
       * </pre>
       *
       * <code>bool enforced = 1;</code>
       *
       * @return The enforced.
       */
      @java.lang.Override
      public boolean getEnforced() {
        return enforced_;
      }
      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       *
       * Suppose you have a `Constraint`
       * `constraints/compute.disableSerialPortAccess` with `constraint_default`
       * set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
       * behavior:
       *   - If the `Policy` at this resource has enforced set to `false`, serial
       *     port connection attempts will be allowed.
       *   - If the `Policy` at this resource has enforced set to `true`, serial
       *     port connection attempts will be refused.
       *   - If the `Policy` at this resource is `RestoreDefault`, serial port
       *     connection attempts will be allowed.
       *   - If no `Policy` is set at this resource or anywhere higher in the
       *     resource hierarchy, serial port connection attempts will be allowed.
       *   - If no `Policy` is set at this resource, but one exists higher in the
       *     resource hierarchy, the behavior is as if the`Policy` were set at
       *     this resource.
       *
       * The following examples demonstrate the different possible layerings:
       *
       * Example 1 (nearest `Constraint` wins):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: false}
       *   `projects/bar` has no `Policy` set.
       * The constraint at `projects/bar` and `organizations/foo` will not be
       * enforced.
       *
       * Example 2 (enforcement gets replaced):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: false}
       *   `projects/bar` has a `Policy` with:
       *     {enforced: true}
       * The constraint at `organizations/foo` is not enforced.
       * The constraint at `projects/bar` is enforced.
       *
       * Example 3 (RestoreDefault):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: true}
       *   `projects/bar` has a `Policy` with:
       *     {RestoreDefault: {}}
       * The constraint at `organizations/foo` is enforced.
       * The constraint at `projects/bar` is not enforced, because
       * `constraint_default` for the `Constraint` is `ALLOW`.
       * </pre>
       *
       * <code>bool enforced = 1;</code>
       *
       * @param value The enforced to set.
       * @return This builder for chaining.
       */
      public Builder setEnforced(boolean value) {

        enforced_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       *
       * Suppose you have a `Constraint`
       * `constraints/compute.disableSerialPortAccess` with `constraint_default`
       * set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
       * behavior:
       *   - If the `Policy` at this resource has enforced set to `false`, serial
       *     port connection attempts will be allowed.
       *   - If the `Policy` at this resource has enforced set to `true`, serial
       *     port connection attempts will be refused.
       *   - If the `Policy` at this resource is `RestoreDefault`, serial port
       *     connection attempts will be allowed.
       *   - If no `Policy` is set at this resource or anywhere higher in the
       *     resource hierarchy, serial port connection attempts will be allowed.
       *   - If no `Policy` is set at this resource, but one exists higher in the
       *     resource hierarchy, the behavior is as if the`Policy` were set at
       *     this resource.
       *
       * The following examples demonstrate the different possible layerings:
       *
       * Example 1 (nearest `Constraint` wins):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: false}
       *   `projects/bar` has no `Policy` set.
       * The constraint at `projects/bar` and `organizations/foo` will not be
       * enforced.
       *
       * Example 2 (enforcement gets replaced):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: false}
       *   `projects/bar` has a `Policy` with:
       *     {enforced: true}
       * The constraint at `organizations/foo` is not enforced.
       * The constraint at `projects/bar` is enforced.
       *
       * Example 3 (RestoreDefault):
       *   `organizations/foo` has a `Policy` with:
       *     {enforced: true}
       *   `projects/bar` has a `Policy` with:
       *     {RestoreDefault: {}}
       * The constraint at `organizations/foo` is enforced.
       * The constraint at `projects/bar` is not enforced, because
       * `constraint_default` for the `Constraint` is `ALLOW`.
       * </pre>
       *
       * <code>bool enforced = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnforced() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enforced_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v1.Policy.BooleanPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v1.Policy.BooleanPolicy)
    private static final com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy();
    }

    public static com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BooleanPolicy> PARSER =
        new com.google.protobuf.AbstractParser<BooleanPolicy>() {
          @java.lang.Override
          public BooleanPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BooleanPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BooleanPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RestoreDefaultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v1.Policy.RestoreDefault)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Ignores policies set above this resource and restores the
   * `constraint_default` enforcement behavior of the specific `Constraint` at
   * this resource.
   *
   * Suppose that `constraint_default` is set to `ALLOW` for the
   * `Constraint` `constraints/serviceuser.services`. Suppose that organization
   * foo.com sets a `Policy` at their Organization resource node that restricts
   * the allowed service activations to deny all service activations. They
   * could then set a `Policy` with the `policy_type` `restore_default` on
   * several experimental projects, restoring the `constraint_default`
   * enforcement of the `Constraint` for only those projects, allowing those
   * projects to have all services activated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v1.Policy.RestoreDefault}
   */
  public static final class RestoreDefault extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v1.Policy.RestoreDefault)
      RestoreDefaultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RestoreDefault.newBuilder() to construct.
    private RestoreDefault(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RestoreDefault() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RestoreDefault();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_RestoreDefault_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_RestoreDefault_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.class,
              com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.orgpolicy.v1.Policy.RestoreDefault)) {
        return super.equals(obj);
      }
      com.google.cloud.orgpolicy.v1.Policy.RestoreDefault other =
          (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orgpolicy.v1.Policy.RestoreDefault prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Ignores policies set above this resource and restores the
     * `constraint_default` enforcement behavior of the specific `Constraint` at
     * this resource.
     *
     * Suppose that `constraint_default` is set to `ALLOW` for the
     * `Constraint` `constraints/serviceuser.services`. Suppose that organization
     * foo.com sets a `Policy` at their Organization resource node that restricts
     * the allowed service activations to deny all service activations. They
     * could then set a `Policy` with the `policy_type` `restore_default` on
     * several experimental projects, restoring the `constraint_default`
     * enforcement of the `Constraint` for only those projects, allowing those
     * projects to have all services activated.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v1.Policy.RestoreDefault}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v1.Policy.RestoreDefault)
        com.google.cloud.orgpolicy.v1.Policy.RestoreDefaultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_RestoreDefault_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_RestoreDefault_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.class,
                com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder.class);
      }

      // Construct using com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orgpolicy.v1.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v1_Policy_RestoreDefault_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault getDefaultInstanceForType() {
        return com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault build() {
        com.google.cloud.orgpolicy.v1.Policy.RestoreDefault result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault buildPartial() {
        com.google.cloud.orgpolicy.v1.Policy.RestoreDefault result =
            new com.google.cloud.orgpolicy.v1.Policy.RestoreDefault(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) {
          return mergeFrom((com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.orgpolicy.v1.Policy.RestoreDefault other) {
        if (other == com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v1.Policy.RestoreDefault)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v1.Policy.RestoreDefault)
    private static final com.google.cloud.orgpolicy.v1.Policy.RestoreDefault DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v1.Policy.RestoreDefault();
    }

    public static com.google.cloud.orgpolicy.v1.Policy.RestoreDefault getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RestoreDefault> PARSER =
        new com.google.protobuf.AbstractParser<RestoreDefault>() {
          @java.lang.Override
          public RestoreDefault parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RestoreDefault> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RestoreDefault> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int policyTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object policyType_;

  public enum PolicyTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LIST_POLICY(5),
    BOOLEAN_POLICY(6),
    RESTORE_DEFAULT(7),
    POLICYTYPE_NOT_SET(0);
    private final int value;

    private PolicyTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PolicyTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static PolicyTypeCase forNumber(int value) {
      switch (value) {
        case 5:
          return LIST_POLICY;
        case 6:
          return BOOLEAN_POLICY;
        case 7:
          return RESTORE_DEFAULT;
        case 0:
          return POLICYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PolicyTypeCase getPolicyTypeCase() {
    return PolicyTypeCase.forNumber(policyTypeCase_);
  }

  public static final int VERSION_FIELD_NUMBER = 1;
  private int version_ = 0;
  /**
   *
   *
   * <pre>
   * Version of the `Policy`. Default version is 0;
   * </pre>
   *
   * <code>int32 version = 1;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public int getVersion() {
    return version_;
  }

  public static final int CONSTRAINT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object constraint_ = "";
  /**
   *
   *
   * <pre>
   * The name of the `Constraint` the `Policy` is configuring, for example,
   * `constraints/serviceuser.services`.
   *
   * Immutable after creation.
   * </pre>
   *
   * <code>string constraint = 2;</code>
   *
   * @return The constraint.
   */
  @java.lang.Override
  public java.lang.String getConstraint() {
    java.lang.Object ref = constraint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      constraint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the `Constraint` the `Policy` is configuring, for example,
   * `constraints/serviceuser.services`.
   *
   * Immutable after creation.
   * </pre>
   *
   * <code>string constraint = 2;</code>
   *
   * @return The bytes for constraint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConstraintBytes() {
    java.lang.Object ref = constraint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      constraint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString etag_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * An opaque tag indicating the current version of the `Policy`, used for
   * concurrency control.
   *
   * When the `Policy` is returned from either a `GetPolicy` or a
   * `ListOrgPolicy` request, this `etag` indicates the version of the current
   * `Policy` to use when executing a read-modify-write loop.
   *
   * When the `Policy` is returned from a `GetEffectivePolicy` request, the
   * `etag` will be unset.
   *
   * When the `Policy` is used in a `SetOrgPolicy` method, use the `etag` value
   * that was returned from a `GetOrgPolicy` request as part of a
   * read-modify-write loop for concurrency control. Not setting the `etag`in a
   * `SetOrgPolicy` request will result in an unconditional write of the
   * `Policy`.
   * </pre>
   *
   * <code>bytes etag = 3;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtag() {
    return etag_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The time stamp the `Policy` was previously updated. This is set by the
   * server, not specified by the caller, and represents the last time a call to
   * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
   * be ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time stamp the `Policy` was previously updated. This is set by the
   * server, not specified by the caller, and represents the last time a call to
   * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
   * be ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time stamp the `Policy` was previously updated. This is set by the
   * server, not specified by the caller, and represents the last time a call to
   * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
   * be ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LIST_POLICY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * List of values either allowed or disallowed.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
   *
   * @return Whether the listPolicy field is set.
   */
  @java.lang.Override
  public boolean hasListPolicy() {
    return policyTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * List of values either allowed or disallowed.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
   *
   * @return The listPolicy.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy.ListPolicy getListPolicy() {
    if (policyTypeCase_ == 5) {
      return (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_;
    }
    return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * List of values either allowed or disallowed.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy.ListPolicyOrBuilder getListPolicyOrBuilder() {
    if (policyTypeCase_ == 5) {
      return (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_;
    }
    return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
  }

  public static final int BOOLEAN_POLICY_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * For boolean `Constraints`, whether to enforce the `Constraint` or not.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
   *
   * @return Whether the booleanPolicy field is set.
   */
  @java.lang.Override
  public boolean hasBooleanPolicy() {
    return policyTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * For boolean `Constraints`, whether to enforce the `Constraint` or not.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
   *
   * @return The booleanPolicy.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy getBooleanPolicy() {
    if (policyTypeCase_ == 6) {
      return (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_;
    }
    return com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * For boolean `Constraints`, whether to enforce the `Constraint` or not.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicyOrBuilder getBooleanPolicyOrBuilder() {
    if (policyTypeCase_ == 6) {
      return (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_;
    }
    return com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
  }

  public static final int RESTORE_DEFAULT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Restores the default behavior of the constraint; independent of
   * `Constraint` type.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
   *
   * @return Whether the restoreDefault field is set.
   */
  @java.lang.Override
  public boolean hasRestoreDefault() {
    return policyTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Restores the default behavior of the constraint; independent of
   * `Constraint` type.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
   *
   * @return The restoreDefault.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault getRestoreDefault() {
    if (policyTypeCase_ == 7) {
      return (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_;
    }
    return com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Restores the default behavior of the constraint; independent of
   * `Constraint` type.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy.RestoreDefaultOrBuilder getRestoreDefaultOrBuilder() {
    if (policyTypeCase_ == 7) {
      return (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_;
    }
    return com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (version_ != 0) {
      output.writeInt32(1, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(constraint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, constraint_);
    }
    if (!etag_.isEmpty()) {
      output.writeBytes(3, etag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (policyTypeCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_);
    }
    if (policyTypeCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_);
    }
    if (policyTypeCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (version_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(constraint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, constraint_);
    }
    if (!etag_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, etag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (policyTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_);
    }
    if (policyTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_);
    }
    if (policyTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orgpolicy.v1.Policy)) {
      return super.equals(obj);
    }
    com.google.cloud.orgpolicy.v1.Policy other = (com.google.cloud.orgpolicy.v1.Policy) obj;

    if (getVersion() != other.getVersion()) return false;
    if (!getConstraint().equals(other.getConstraint())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getPolicyTypeCase().equals(other.getPolicyTypeCase())) return false;
    switch (policyTypeCase_) {
      case 5:
        if (!getListPolicy().equals(other.getListPolicy())) return false;
        break;
      case 6:
        if (!getBooleanPolicy().equals(other.getBooleanPolicy())) return false;
        break;
      case 7:
        if (!getRestoreDefault().equals(other.getRestoreDefault())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion();
    hash = (37 * hash) + CONSTRAINT_FIELD_NUMBER;
    hash = (53 * hash) + getConstraint().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (policyTypeCase_) {
      case 5:
        hash = (37 * hash) + LIST_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getListPolicy().hashCode();
        break;
      case 6:
        hash = (37 * hash) + BOOLEAN_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getBooleanPolicy().hashCode();
        break;
      case 7:
        hash = (37 * hash) + RESTORE_DEFAULT_FIELD_NUMBER;
        hash = (53 * hash) + getRestoreDefault().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v1.Policy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.orgpolicy.v1.Policy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a Cloud Organization `Policy` which is used to specify `Constraints`
   * for configurations of Cloud Platform resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v1.Policy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v1.Policy)
      com.google.cloud.orgpolicy.v1.PolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v1.Policy.class,
              com.google.cloud.orgpolicy.v1.Policy.Builder.class);
    }

    // Construct using com.google.cloud.orgpolicy.v1.Policy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      version_ = 0;
      constraint_ = "";
      etag_ = com.google.protobuf.ByteString.EMPTY;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (listPolicyBuilder_ != null) {
        listPolicyBuilder_.clear();
      }
      if (booleanPolicyBuilder_ != null) {
        booleanPolicyBuilder_.clear();
      }
      if (restoreDefaultBuilder_ != null) {
        restoreDefaultBuilder_.clear();
      }
      policyTypeCase_ = 0;
      policyType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orgpolicy.v1.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v1_Policy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy getDefaultInstanceForType() {
      return com.google.cloud.orgpolicy.v1.Policy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy build() {
      com.google.cloud.orgpolicy.v1.Policy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy buildPartial() {
      com.google.cloud.orgpolicy.v1.Policy result = new com.google.cloud.orgpolicy.v1.Policy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.orgpolicy.v1.Policy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.constraint_ = constraint_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.orgpolicy.v1.Policy result) {
      result.policyTypeCase_ = policyTypeCase_;
      result.policyType_ = this.policyType_;
      if (policyTypeCase_ == 5 && listPolicyBuilder_ != null) {
        result.policyType_ = listPolicyBuilder_.build();
      }
      if (policyTypeCase_ == 6 && booleanPolicyBuilder_ != null) {
        result.policyType_ = booleanPolicyBuilder_.build();
      }
      if (policyTypeCase_ == 7 && restoreDefaultBuilder_ != null) {
        result.policyType_ = restoreDefaultBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orgpolicy.v1.Policy) {
        return mergeFrom((com.google.cloud.orgpolicy.v1.Policy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orgpolicy.v1.Policy other) {
      if (other == com.google.cloud.orgpolicy.v1.Policy.getDefaultInstance()) return this;
      if (other.getVersion() != 0) {
        setVersion(other.getVersion());
      }
      if (!other.getConstraint().isEmpty()) {
        constraint_ = other.constraint_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getEtag() != com.google.protobuf.ByteString.EMPTY) {
        setEtag(other.getEtag());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getPolicyTypeCase()) {
        case LIST_POLICY:
          {
            mergeListPolicy(other.getListPolicy());
            break;
          }
        case BOOLEAN_POLICY:
          {
            mergeBooleanPolicy(other.getBooleanPolicy());
            break;
          }
        case RESTORE_DEFAULT:
          {
            mergeRestoreDefault(other.getRestoreDefault());
            break;
          }
        case POLICYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                version_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                constraint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                etag_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getListPolicyFieldBuilder().getBuilder(), extensionRegistry);
                policyTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBooleanPolicyFieldBuilder().getBuilder(), extensionRegistry);
                policyTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getRestoreDefaultFieldBuilder().getBuilder(), extensionRegistry);
                policyTypeCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int policyTypeCase_ = 0;
    private java.lang.Object policyType_;

    public PolicyTypeCase getPolicyTypeCase() {
      return PolicyTypeCase.forNumber(policyTypeCase_);
    }

    public Builder clearPolicyType() {
      policyTypeCase_ = 0;
      policyType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int version_;
    /**
     *
     *
     * <pre>
     * Version of the `Policy`. Default version is 0;
     * </pre>
     *
     * <code>int32 version = 1;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public int getVersion() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * Version of the `Policy`. Default version is 0;
     * </pre>
     *
     * <code>int32 version = 1;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(int value) {

      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version of the `Policy`. Default version is 0;
     * </pre>
     *
     * <code>int32 version = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000001);
      version_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object constraint_ = "";
    /**
     *
     *
     * <pre>
     * The name of the `Constraint` the `Policy` is configuring, for example,
     * `constraints/serviceuser.services`.
     *
     * Immutable after creation.
     * </pre>
     *
     * <code>string constraint = 2;</code>
     *
     * @return The constraint.
     */
    public java.lang.String getConstraint() {
      java.lang.Object ref = constraint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        constraint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Constraint` the `Policy` is configuring, for example,
     * `constraints/serviceuser.services`.
     *
     * Immutable after creation.
     * </pre>
     *
     * <code>string constraint = 2;</code>
     *
     * @return The bytes for constraint.
     */
    public com.google.protobuf.ByteString getConstraintBytes() {
      java.lang.Object ref = constraint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        constraint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the `Constraint` the `Policy` is configuring, for example,
     * `constraints/serviceuser.services`.
     *
     * Immutable after creation.
     * </pre>
     *
     * <code>string constraint = 2;</code>
     *
     * @param value The constraint to set.
     * @return This builder for chaining.
     */
    public Builder setConstraint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      constraint_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Constraint` the `Policy` is configuring, for example,
     * `constraints/serviceuser.services`.
     *
     * Immutable after creation.
     * </pre>
     *
     * <code>string constraint = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConstraint() {
      constraint_ = getDefaultInstance().getConstraint();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the `Constraint` the `Policy` is configuring, for example,
     * `constraints/serviceuser.services`.
     *
     * Immutable after creation.
     * </pre>
     *
     * <code>string constraint = 2;</code>
     *
     * @param value The bytes for constraint to set.
     * @return This builder for chaining.
     */
    public Builder setConstraintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      constraint_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString etag_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListOrgPolicy` request, this `etag` indicates the version of the current
     * `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     *
     * When the `Policy` is used in a `SetOrgPolicy` method, use the `etag` value
     * that was returned from a `GetOrgPolicy` request as part of a
     * read-modify-write loop for concurrency control. Not setting the `etag`in a
     * `SetOrgPolicy` request will result in an unconditional write of the
     * `Policy`.
     * </pre>
     *
     * <code>bytes etag = 3;</code>
     *
     * @return The etag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEtag() {
      return etag_;
    }
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListOrgPolicy` request, this `etag` indicates the version of the current
     * `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     *
     * When the `Policy` is used in a `SetOrgPolicy` method, use the `etag` value
     * that was returned from a `GetOrgPolicy` request as part of a
     * read-modify-write loop for concurrency control. Not setting the `etag`in a
     * `SetOrgPolicy` request will result in an unconditional write of the
     * `Policy`.
     * </pre>
     *
     * <code>bytes etag = 3;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListOrgPolicy` request, this `etag` indicates the version of the current
     * `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     *
     * When the `Policy` is used in a `SetOrgPolicy` method, use the `etag` value
     * that was returned from a `GetOrgPolicy` request as part of a
     * read-modify-write loop for concurrency control. Not setting the `etag`in a
     * `SetOrgPolicy` request will result in an unconditional write of the
     * `Policy`.
     * </pre>
     *
     * <code>bytes etag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      bitField0_ = (bitField0_ & ~0x00000004);
      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time stamp the `Policy` was previously updated. This is set by the
     * server, not specified by the caller, and represents the last time a call to
     * `SetOrgPolicy` was made for that `Policy`. Any value set by the client will
     * be ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy.ListPolicy,
            com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder,
            com.google.cloud.orgpolicy.v1.Policy.ListPolicyOrBuilder>
        listPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     *
     * @return Whether the listPolicy field is set.
     */
    @java.lang.Override
    public boolean hasListPolicy() {
      return policyTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     *
     * @return The listPolicy.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.ListPolicy getListPolicy() {
      if (listPolicyBuilder_ == null) {
        if (policyTypeCase_ == 5) {
          return (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_;
        }
        return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
      } else {
        if (policyTypeCase_ == 5) {
          return listPolicyBuilder_.getMessage();
        }
        return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    public Builder setListPolicy(com.google.cloud.orgpolicy.v1.Policy.ListPolicy value) {
      if (listPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyType_ = value;
        onChanged();
      } else {
        listPolicyBuilder_.setMessage(value);
      }
      policyTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    public Builder setListPolicy(
        com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder builderForValue) {
      if (listPolicyBuilder_ == null) {
        policyType_ = builderForValue.build();
        onChanged();
      } else {
        listPolicyBuilder_.setMessage(builderForValue.build());
      }
      policyTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    public Builder mergeListPolicy(com.google.cloud.orgpolicy.v1.Policy.ListPolicy value) {
      if (listPolicyBuilder_ == null) {
        if (policyTypeCase_ == 5
            && policyType_
                != com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance()) {
          policyType_ =
              com.google.cloud.orgpolicy.v1.Policy.ListPolicy.newBuilder(
                      (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          policyType_ = value;
        }
        onChanged();
      } else {
        if (policyTypeCase_ == 5) {
          listPolicyBuilder_.mergeFrom(value);
        } else {
          listPolicyBuilder_.setMessage(value);
        }
      }
      policyTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    public Builder clearListPolicy() {
      if (listPolicyBuilder_ == null) {
        if (policyTypeCase_ == 5) {
          policyTypeCase_ = 0;
          policyType_ = null;
          onChanged();
        }
      } else {
        if (policyTypeCase_ == 5) {
          policyTypeCase_ = 0;
          policyType_ = null;
        }
        listPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder getListPolicyBuilder() {
      return getListPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.ListPolicyOrBuilder getListPolicyOrBuilder() {
      if ((policyTypeCase_ == 5) && (listPolicyBuilder_ != null)) {
        return listPolicyBuilder_.getMessageOrBuilder();
      } else {
        if (policyTypeCase_ == 5) {
          return (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_;
        }
        return com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * List of values either allowed or disallowed.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.ListPolicy list_policy = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy.ListPolicy,
            com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder,
            com.google.cloud.orgpolicy.v1.Policy.ListPolicyOrBuilder>
        getListPolicyFieldBuilder() {
      if (listPolicyBuilder_ == null) {
        if (!(policyTypeCase_ == 5)) {
          policyType_ = com.google.cloud.orgpolicy.v1.Policy.ListPolicy.getDefaultInstance();
        }
        listPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v1.Policy.ListPolicy,
                com.google.cloud.orgpolicy.v1.Policy.ListPolicy.Builder,
                com.google.cloud.orgpolicy.v1.Policy.ListPolicyOrBuilder>(
                (com.google.cloud.orgpolicy.v1.Policy.ListPolicy) policyType_,
                getParentForChildren(),
                isClean());
        policyType_ = null;
      }
      policyTypeCase_ = 5;
      onChanged();
      return listPolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy,
            com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder,
            com.google.cloud.orgpolicy.v1.Policy.BooleanPolicyOrBuilder>
        booleanPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     *
     * @return Whether the booleanPolicy field is set.
     */
    @java.lang.Override
    public boolean hasBooleanPolicy() {
      return policyTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     *
     * @return The booleanPolicy.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy getBooleanPolicy() {
      if (booleanPolicyBuilder_ == null) {
        if (policyTypeCase_ == 6) {
          return (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_;
        }
        return com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
      } else {
        if (policyTypeCase_ == 6) {
          return booleanPolicyBuilder_.getMessage();
        }
        return com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    public Builder setBooleanPolicy(com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy value) {
      if (booleanPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyType_ = value;
        onChanged();
      } else {
        booleanPolicyBuilder_.setMessage(value);
      }
      policyTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    public Builder setBooleanPolicy(
        com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder builderForValue) {
      if (booleanPolicyBuilder_ == null) {
        policyType_ = builderForValue.build();
        onChanged();
      } else {
        booleanPolicyBuilder_.setMessage(builderForValue.build());
      }
      policyTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    public Builder mergeBooleanPolicy(com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy value) {
      if (booleanPolicyBuilder_ == null) {
        if (policyTypeCase_ == 6
            && policyType_
                != com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance()) {
          policyType_ =
              com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.newBuilder(
                      (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          policyType_ = value;
        }
        onChanged();
      } else {
        if (policyTypeCase_ == 6) {
          booleanPolicyBuilder_.mergeFrom(value);
        } else {
          booleanPolicyBuilder_.setMessage(value);
        }
      }
      policyTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    public Builder clearBooleanPolicy() {
      if (booleanPolicyBuilder_ == null) {
        if (policyTypeCase_ == 6) {
          policyTypeCase_ = 0;
          policyType_ = null;
          onChanged();
        }
      } else {
        if (policyTypeCase_ == 6) {
          policyTypeCase_ = 0;
          policyType_ = null;
        }
        booleanPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder getBooleanPolicyBuilder() {
      return getBooleanPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.BooleanPolicyOrBuilder getBooleanPolicyOrBuilder() {
      if ((policyTypeCase_ == 6) && (booleanPolicyBuilder_ != null)) {
        return booleanPolicyBuilder_.getMessageOrBuilder();
      } else {
        if (policyTypeCase_ == 6) {
          return (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_;
        }
        return com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For boolean `Constraints`, whether to enforce the `Constraint` or not.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.BooleanPolicy boolean_policy = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy,
            com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder,
            com.google.cloud.orgpolicy.v1.Policy.BooleanPolicyOrBuilder>
        getBooleanPolicyFieldBuilder() {
      if (booleanPolicyBuilder_ == null) {
        if (!(policyTypeCase_ == 6)) {
          policyType_ = com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.getDefaultInstance();
        }
        booleanPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy,
                com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy.Builder,
                com.google.cloud.orgpolicy.v1.Policy.BooleanPolicyOrBuilder>(
                (com.google.cloud.orgpolicy.v1.Policy.BooleanPolicy) policyType_,
                getParentForChildren(),
                isClean());
        policyType_ = null;
      }
      policyTypeCase_ = 6;
      onChanged();
      return booleanPolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy.RestoreDefault,
            com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder,
            com.google.cloud.orgpolicy.v1.Policy.RestoreDefaultOrBuilder>
        restoreDefaultBuilder_;
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     *
     * @return Whether the restoreDefault field is set.
     */
    @java.lang.Override
    public boolean hasRestoreDefault() {
      return policyTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     *
     * @return The restoreDefault.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault getRestoreDefault() {
      if (restoreDefaultBuilder_ == null) {
        if (policyTypeCase_ == 7) {
          return (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_;
        }
        return com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
      } else {
        if (policyTypeCase_ == 7) {
          return restoreDefaultBuilder_.getMessage();
        }
        return com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    public Builder setRestoreDefault(com.google.cloud.orgpolicy.v1.Policy.RestoreDefault value) {
      if (restoreDefaultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyType_ = value;
        onChanged();
      } else {
        restoreDefaultBuilder_.setMessage(value);
      }
      policyTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    public Builder setRestoreDefault(
        com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder builderForValue) {
      if (restoreDefaultBuilder_ == null) {
        policyType_ = builderForValue.build();
        onChanged();
      } else {
        restoreDefaultBuilder_.setMessage(builderForValue.build());
      }
      policyTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    public Builder mergeRestoreDefault(com.google.cloud.orgpolicy.v1.Policy.RestoreDefault value) {
      if (restoreDefaultBuilder_ == null) {
        if (policyTypeCase_ == 7
            && policyType_
                != com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance()) {
          policyType_ =
              com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.newBuilder(
                      (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          policyType_ = value;
        }
        onChanged();
      } else {
        if (policyTypeCase_ == 7) {
          restoreDefaultBuilder_.mergeFrom(value);
        } else {
          restoreDefaultBuilder_.setMessage(value);
        }
      }
      policyTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    public Builder clearRestoreDefault() {
      if (restoreDefaultBuilder_ == null) {
        if (policyTypeCase_ == 7) {
          policyTypeCase_ = 0;
          policyType_ = null;
          onChanged();
        }
      } else {
        if (policyTypeCase_ == 7) {
          policyTypeCase_ = 0;
          policyType_ = null;
        }
        restoreDefaultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    public com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder getRestoreDefaultBuilder() {
      return getRestoreDefaultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v1.Policy.RestoreDefaultOrBuilder
        getRestoreDefaultOrBuilder() {
      if ((policyTypeCase_ == 7) && (restoreDefaultBuilder_ != null)) {
        return restoreDefaultBuilder_.getMessageOrBuilder();
      } else {
        if (policyTypeCase_ == 7) {
          return (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_;
        }
        return com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Restores the default behavior of the constraint; independent of
     * `Constraint` type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v1.Policy.RestoreDefault restore_default = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v1.Policy.RestoreDefault,
            com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder,
            com.google.cloud.orgpolicy.v1.Policy.RestoreDefaultOrBuilder>
        getRestoreDefaultFieldBuilder() {
      if (restoreDefaultBuilder_ == null) {
        if (!(policyTypeCase_ == 7)) {
          policyType_ = com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.getDefaultInstance();
        }
        restoreDefaultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v1.Policy.RestoreDefault,
                com.google.cloud.orgpolicy.v1.Policy.RestoreDefault.Builder,
                com.google.cloud.orgpolicy.v1.Policy.RestoreDefaultOrBuilder>(
                (com.google.cloud.orgpolicy.v1.Policy.RestoreDefault) policyType_,
                getParentForChildren(),
                isClean());
        policyType_ = null;
      }
      policyTypeCase_ = 7;
      onChanged();
      return restoreDefaultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v1.Policy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v1.Policy)
  private static final com.google.cloud.orgpolicy.v1.Policy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v1.Policy();
  }

  public static com.google.cloud.orgpolicy.v1.Policy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Policy> PARSER =
      new com.google.protobuf.AbstractParser<Policy>() {
        @java.lang.Override
        public Policy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Policy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Policy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orgpolicy.v1.Policy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
