/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v2/constraint.proto

package com.google.cloud.orgpolicy.v2;

/**
 *
 *
 * <pre>
 * A `constraint` describes a way to restrict resource's configuration. For
 * example, you could enforce a constraint that controls which cloud services
 * can be activated across an organization, or whether a Compute Engine instance
 * can have serial port connections established. `Constraints` can be configured
 * by the organization's policy administrator to fit the needs of the
 * organization by setting a `policy` that includes `constraints` at different
 * locations in the organization's resource hierarchy. Policies are inherited
 * down the resource hierarchy from higher levels, but can also be overridden.
 * For details about the inheritance rules please read about
 * [`policies`][google.cloud.OrgPolicy.v2.Policy].
 *
 * `Constraints` have a default behavior determined by the `constraint_default`
 * field, which is the enforcement behavior that is used in the absence of a
 * `policy` being defined or inherited for the resource in question.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orgpolicy.v2.Constraint}
 */
public final class Constraint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.Constraint)
    ConstraintOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Constraint.newBuilder() to construct.
  private Constraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Constraint() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    constraintDefault_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Constraint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orgpolicy.v2.ConstraintProto
        .internal_static_google_cloud_orgpolicy_v2_Constraint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orgpolicy.v2.ConstraintProto
        .internal_static_google_cloud_orgpolicy_v2_Constraint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orgpolicy.v2.Constraint.class,
            com.google.cloud.orgpolicy.v2.Constraint.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the default behavior in the absence of any `Policy` for the
   * `Constraint`. This must not be `CONSTRAINT_DEFAULT_UNSPECIFIED`.
   *
   * Immutable after creation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.orgpolicy.v2.Constraint.ConstraintDefault}
   */
  public enum ConstraintDefault implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This is only used for distinguishing unset values and should never be
     * used.
     * </pre>
     *
     * <code>CONSTRAINT_DEFAULT_UNSPECIFIED = 0;</code>
     */
    CONSTRAINT_DEFAULT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicate that all values are allowed for list constraints.
     * Indicate that enforcement is off for boolean constraints.
     * </pre>
     *
     * <code>ALLOW = 1;</code>
     */
    ALLOW(1),
    /**
     *
     *
     * <pre>
     * Indicate that all values are denied for list constraints.
     * Indicate that enforcement is on for boolean constraints.
     * </pre>
     *
     * <code>DENY = 2;</code>
     */
    DENY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This is only used for distinguishing unset values and should never be
     * used.
     * </pre>
     *
     * <code>CONSTRAINT_DEFAULT_UNSPECIFIED = 0;</code>
     */
    public static final int CONSTRAINT_DEFAULT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicate that all values are allowed for list constraints.
     * Indicate that enforcement is off for boolean constraints.
     * </pre>
     *
     * <code>ALLOW = 1;</code>
     */
    public static final int ALLOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicate that all values are denied for list constraints.
     * Indicate that enforcement is on for boolean constraints.
     * </pre>
     *
     * <code>DENY = 2;</code>
     */
    public static final int DENY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConstraintDefault valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConstraintDefault forNumber(int value) {
      switch (value) {
        case 0:
          return CONSTRAINT_DEFAULT_UNSPECIFIED;
        case 1:
          return ALLOW;
        case 2:
          return DENY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConstraintDefault>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConstraintDefault>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConstraintDefault>() {
              public ConstraintDefault findValueByNumber(int number) {
                return ConstraintDefault.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.Constraint.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConstraintDefault[] VALUES = values();

    public static ConstraintDefault valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConstraintDefault(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orgpolicy.v2.Constraint.ConstraintDefault)
  }

  public interface ListConstraintOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v2.Constraint.ListConstraint)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates whether values grouped into categories can be used in
     * `Policy.allowed_values` and `Policy.denied_values`. For example,
     * `"in:Python"` would match any value in the 'Python' group.
     * </pre>
     *
     * <code>bool supports_in = 1;</code>
     *
     * @return The supportsIn.
     */
    boolean getSupportsIn();

    /**
     *
     *
     * <pre>
     * Indicates whether subtrees of Cloud Resource Manager resource hierarchy
     * can be used in `Policy.allowed_values` and `Policy.denied_values`. For
     * example, `"under:folders/123"` would match any resource under the
     * 'folders/123' folder.
     * </pre>
     *
     * <code>bool supports_under = 2;</code>
     *
     * @return The supportsUnder.
     */
    boolean getSupportsUnder();
  }
  /**
   *
   *
   * <pre>
   * A `Constraint` that allows or disallows a list of string values, which are
   * configured by an Organization's policy administrator with a `Policy`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.Constraint.ListConstraint}
   */
  public static final class ListConstraint extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.Constraint.ListConstraint)
      ListConstraintOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListConstraint.newBuilder() to construct.
    private ListConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListConstraint() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListConstraint();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_ListConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_ListConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.class,
              com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder.class);
    }

    public static final int SUPPORTS_IN_FIELD_NUMBER = 1;
    private boolean supportsIn_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether values grouped into categories can be used in
     * `Policy.allowed_values` and `Policy.denied_values`. For example,
     * `"in:Python"` would match any value in the 'Python' group.
     * </pre>
     *
     * <code>bool supports_in = 1;</code>
     *
     * @return The supportsIn.
     */
    @java.lang.Override
    public boolean getSupportsIn() {
      return supportsIn_;
    }

    public static final int SUPPORTS_UNDER_FIELD_NUMBER = 2;
    private boolean supportsUnder_ = false;
    /**
     *
     *
     * <pre>
     * Indicates whether subtrees of Cloud Resource Manager resource hierarchy
     * can be used in `Policy.allowed_values` and `Policy.denied_values`. For
     * example, `"under:folders/123"` would match any resource under the
     * 'folders/123' folder.
     * </pre>
     *
     * <code>bool supports_under = 2;</code>
     *
     * @return The supportsUnder.
     */
    @java.lang.Override
    public boolean getSupportsUnder() {
      return supportsUnder_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (supportsIn_ != false) {
        output.writeBool(1, supportsIn_);
      }
      if (supportsUnder_ != false) {
        output.writeBool(2, supportsUnder_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (supportsIn_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, supportsIn_);
      }
      if (supportsUnder_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, supportsUnder_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.orgpolicy.v2.Constraint.ListConstraint)) {
        return super.equals(obj);
      }
      com.google.cloud.orgpolicy.v2.Constraint.ListConstraint other =
          (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) obj;

      if (getSupportsIn() != other.getSupportsIn()) return false;
      if (getSupportsUnder() != other.getSupportsUnder()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUPPORTS_IN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSupportsIn());
      hash = (37 * hash) + SUPPORTS_UNDER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSupportsUnder());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraint prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A `Constraint` that allows or disallows a list of string values, which are
     * configured by an Organization's policy administrator with a `Policy`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v2.Constraint.ListConstraint}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.Constraint.ListConstraint)
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v2.ConstraintProto
            .internal_static_google_cloud_orgpolicy_v2_Constraint_ListConstraint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v2.ConstraintProto
            .internal_static_google_cloud_orgpolicy_v2_Constraint_ListConstraint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.class,
                com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder.class);
      }

      // Construct using com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        supportsIn_ = false;
        supportsUnder_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orgpolicy.v2.ConstraintProto
            .internal_static_google_cloud_orgpolicy_v2_Constraint_ListConstraint_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint getDefaultInstanceForType() {
        return com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint build() {
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraint result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint buildPartial() {
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraint result =
            new com.google.cloud.orgpolicy.v2.Constraint.ListConstraint(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.orgpolicy.v2.Constraint.ListConstraint result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.supportsIn_ = supportsIn_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.supportsUnder_ = supportsUnder_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) {
          return mergeFrom((com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.orgpolicy.v2.Constraint.ListConstraint other) {
        if (other == com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance())
          return this;
        if (other.getSupportsIn() != false) {
          setSupportsIn(other.getSupportsIn());
        }
        if (other.getSupportsUnder() != false) {
          setSupportsUnder(other.getSupportsUnder());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  supportsIn_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  supportsUnder_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean supportsIn_;
      /**
       *
       *
       * <pre>
       * Indicates whether values grouped into categories can be used in
       * `Policy.allowed_values` and `Policy.denied_values`. For example,
       * `"in:Python"` would match any value in the 'Python' group.
       * </pre>
       *
       * <code>bool supports_in = 1;</code>
       *
       * @return The supportsIn.
       */
      @java.lang.Override
      public boolean getSupportsIn() {
        return supportsIn_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether values grouped into categories can be used in
       * `Policy.allowed_values` and `Policy.denied_values`. For example,
       * `"in:Python"` would match any value in the 'Python' group.
       * </pre>
       *
       * <code>bool supports_in = 1;</code>
       *
       * @param value The supportsIn to set.
       * @return This builder for chaining.
       */
      public Builder setSupportsIn(boolean value) {

        supportsIn_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether values grouped into categories can be used in
       * `Policy.allowed_values` and `Policy.denied_values`. For example,
       * `"in:Python"` would match any value in the 'Python' group.
       * </pre>
       *
       * <code>bool supports_in = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSupportsIn() {
        bitField0_ = (bitField0_ & ~0x00000001);
        supportsIn_ = false;
        onChanged();
        return this;
      }

      private boolean supportsUnder_;
      /**
       *
       *
       * <pre>
       * Indicates whether subtrees of Cloud Resource Manager resource hierarchy
       * can be used in `Policy.allowed_values` and `Policy.denied_values`. For
       * example, `"under:folders/123"` would match any resource under the
       * 'folders/123' folder.
       * </pre>
       *
       * <code>bool supports_under = 2;</code>
       *
       * @return The supportsUnder.
       */
      @java.lang.Override
      public boolean getSupportsUnder() {
        return supportsUnder_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether subtrees of Cloud Resource Manager resource hierarchy
       * can be used in `Policy.allowed_values` and `Policy.denied_values`. For
       * example, `"under:folders/123"` would match any resource under the
       * 'folders/123' folder.
       * </pre>
       *
       * <code>bool supports_under = 2;</code>
       *
       * @param value The supportsUnder to set.
       * @return This builder for chaining.
       */
      public Builder setSupportsUnder(boolean value) {

        supportsUnder_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether subtrees of Cloud Resource Manager resource hierarchy
       * can be used in `Policy.allowed_values` and `Policy.denied_values`. For
       * example, `"under:folders/123"` would match any resource under the
       * 'folders/123' folder.
       * </pre>
       *
       * <code>bool supports_under = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSupportsUnder() {
        bitField0_ = (bitField0_ & ~0x00000002);
        supportsUnder_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.Constraint.ListConstraint)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.Constraint.ListConstraint)
    private static final com.google.cloud.orgpolicy.v2.Constraint.ListConstraint DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.Constraint.ListConstraint();
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.ListConstraint getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListConstraint> PARSER =
        new com.google.protobuf.AbstractParser<ListConstraint>() {
          @java.lang.Override
          public ListConstraint parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListConstraint> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListConstraint> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BooleanConstraintOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v2.Constraint.BooleanConstraint)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * A `Constraint` that is either enforced or not.
   *
   * For example a constraint `constraints/compute.disableSerialPortAccess`.
   * If it is enforced on a VM instance, serial port connections will not be
   * opened to that instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.Constraint.BooleanConstraint}
   */
  public static final class BooleanConstraint extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.Constraint.BooleanConstraint)
      BooleanConstraintOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BooleanConstraint.newBuilder() to construct.
    private BooleanConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BooleanConstraint() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BooleanConstraint();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_BooleanConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_BooleanConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.class,
              com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint)) {
        return super.equals(obj);
      }
      com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint other =
          (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A `Constraint` that is either enforced or not.
     *
     * For example a constraint `constraints/compute.disableSerialPortAccess`.
     * If it is enforced on a VM instance, serial port connections will not be
     * opened to that instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v2.Constraint.BooleanConstraint}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.Constraint.BooleanConstraint)
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v2.ConstraintProto
            .internal_static_google_cloud_orgpolicy_v2_Constraint_BooleanConstraint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v2.ConstraintProto
            .internal_static_google_cloud_orgpolicy_v2_Constraint_BooleanConstraint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.class,
                com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder.class);
      }

      // Construct using com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orgpolicy.v2.ConstraintProto
            .internal_static_google_cloud_orgpolicy_v2_Constraint_BooleanConstraint_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint
          getDefaultInstanceForType() {
        return com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint build() {
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint buildPartial() {
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint result =
            new com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) {
          return mergeFrom((com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint other) {
        if (other
            == com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.Constraint.BooleanConstraint)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.Constraint.BooleanConstraint)
    private static final com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint();
    }

    public static com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BooleanConstraint> PARSER =
        new com.google.protobuf.AbstractParser<BooleanConstraint>() {
          @java.lang.Override
          public BooleanConstraint parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BooleanConstraint> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BooleanConstraint> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int constraintTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object constraintType_;

  public enum ConstraintTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LIST_CONSTRAINT(5),
    BOOLEAN_CONSTRAINT(6),
    CONSTRAINTTYPE_NOT_SET(0);
    private final int value;

    private ConstraintTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConstraintTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConstraintTypeCase forNumber(int value) {
      switch (value) {
        case 5:
          return LIST_CONSTRAINT;
        case 6:
          return BOOLEAN_CONSTRAINT;
        case 0:
          return CONSTRAINTTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConstraintTypeCase getConstraintTypeCase() {
    return ConstraintTypeCase.forNumber(constraintTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Constraint. Must be in one of
   * the following forms:
   * * `projects/{project_number}/constraints/{constraint_name}`
   * * `folders/{folder_id}/constraints/{constraint_name}`
   * * `organizations/{organization_id}/constraints/{constraint_name}`
   *
   * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Constraint. Must be in one of
   * the following forms:
   * * `projects/{project_number}/constraints/{constraint_name}`
   * * `folders/{folder_id}/constraints/{constraint_name}`
   * * `organizations/{organization_id}/constraints/{constraint_name}`
   *
   * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The human readable name.
   *
   * Mutable.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human readable name.
   *
   * Mutable.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Detailed description of what this `Constraint` controls as well as how and
   * where it is enforced.
   *
   * Mutable.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Detailed description of what this `Constraint` controls as well as how and
   * where it is enforced.
   *
   * Mutable.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONSTRAINT_DEFAULT_FIELD_NUMBER = 4;
  private int constraintDefault_ = 0;
  /**
   *
   *
   * <pre>
   * The evaluation behavior of this constraint in the absence of 'Policy'.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
   *
   * @return The enum numeric value on the wire for constraintDefault.
   */
  @java.lang.Override
  public int getConstraintDefaultValue() {
    return constraintDefault_;
  }
  /**
   *
   *
   * <pre>
   * The evaluation behavior of this constraint in the absence of 'Policy'.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
   *
   * @return The constraintDefault.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault getConstraintDefault() {
    com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault result =
        com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault.forNumber(constraintDefault_);
    return result == null
        ? com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault.UNRECOGNIZED
        : result;
  }

  public static final int LIST_CONSTRAINT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a ListConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
   *
   * @return Whether the listConstraint field is set.
   */
  @java.lang.Override
  public boolean hasListConstraint() {
    return constraintTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a ListConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
   *
   * @return The listConstraint.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint getListConstraint() {
    if (constraintTypeCase_ == 5) {
      return (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_;
    }
    return com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a ListConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder
      getListConstraintOrBuilder() {
    if (constraintTypeCase_ == 5) {
      return (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_;
    }
    return com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
  }

  public static final int BOOLEAN_CONSTRAINT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a BooleanConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
   *
   * @return Whether the booleanConstraint field is set.
   */
  @java.lang.Override
  public boolean hasBooleanConstraint() {
    return constraintTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a BooleanConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
   *
   * @return The booleanConstraint.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint getBooleanConstraint() {
    if (constraintTypeCase_ == 6) {
      return (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_;
    }
    return com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a BooleanConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder
      getBooleanConstraintOrBuilder() {
    if (constraintTypeCase_ == 6) {
      return (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_;
    }
    return com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (constraintDefault_
        != com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault.CONSTRAINT_DEFAULT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, constraintDefault_);
    }
    if (constraintTypeCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_);
    }
    if (constraintTypeCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (constraintDefault_
        != com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault.CONSTRAINT_DEFAULT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, constraintDefault_);
    }
    if (constraintTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_);
    }
    if (constraintTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orgpolicy.v2.Constraint)) {
      return super.equals(obj);
    }
    com.google.cloud.orgpolicy.v2.Constraint other = (com.google.cloud.orgpolicy.v2.Constraint) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (constraintDefault_ != other.constraintDefault_) return false;
    if (!getConstraintTypeCase().equals(other.getConstraintTypeCase())) return false;
    switch (constraintTypeCase_) {
      case 5:
        if (!getListConstraint().equals(other.getListConstraint())) return false;
        break;
      case 6:
        if (!getBooleanConstraint().equals(other.getBooleanConstraint())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + CONSTRAINT_DEFAULT_FIELD_NUMBER;
    hash = (53 * hash) + constraintDefault_;
    switch (constraintTypeCase_) {
      case 5:
        hash = (37 * hash) + LIST_CONSTRAINT_FIELD_NUMBER;
        hash = (53 * hash) + getListConstraint().hashCode();
        break;
      case 6:
        hash = (37 * hash) + BOOLEAN_CONSTRAINT_FIELD_NUMBER;
        hash = (53 * hash) + getBooleanConstraint().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.Constraint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.orgpolicy.v2.Constraint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `constraint` describes a way to restrict resource's configuration. For
   * example, you could enforce a constraint that controls which cloud services
   * can be activated across an organization, or whether a Compute Engine instance
   * can have serial port connections established. `Constraints` can be configured
   * by the organization's policy administrator to fit the needs of the
   * organization by setting a `policy` that includes `constraints` at different
   * locations in the organization's resource hierarchy. Policies are inherited
   * down the resource hierarchy from higher levels, but can also be overridden.
   * For details about the inheritance rules please read about
   * [`policies`][google.cloud.OrgPolicy.v2.Policy].
   *
   * `Constraints` have a default behavior determined by the `constraint_default`
   * field, which is the enforcement behavior that is used in the absence of a
   * `policy` being defined or inherited for the resource in question.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.Constraint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.Constraint)
      com.google.cloud.orgpolicy.v2.ConstraintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.Constraint.class,
              com.google.cloud.orgpolicy.v2.Constraint.Builder.class);
    }

    // Construct using com.google.cloud.orgpolicy.v2.Constraint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      constraintDefault_ = 0;
      if (listConstraintBuilder_ != null) {
        listConstraintBuilder_.clear();
      }
      if (booleanConstraintBuilder_ != null) {
        booleanConstraintBuilder_.clear();
      }
      constraintTypeCase_ = 0;
      constraintType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_Constraint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint getDefaultInstanceForType() {
      return com.google.cloud.orgpolicy.v2.Constraint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint build() {
      com.google.cloud.orgpolicy.v2.Constraint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint buildPartial() {
      com.google.cloud.orgpolicy.v2.Constraint result =
          new com.google.cloud.orgpolicy.v2.Constraint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.orgpolicy.v2.Constraint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.constraintDefault_ = constraintDefault_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.orgpolicy.v2.Constraint result) {
      result.constraintTypeCase_ = constraintTypeCase_;
      result.constraintType_ = this.constraintType_;
      if (constraintTypeCase_ == 5 && listConstraintBuilder_ != null) {
        result.constraintType_ = listConstraintBuilder_.build();
      }
      if (constraintTypeCase_ == 6 && booleanConstraintBuilder_ != null) {
        result.constraintType_ = booleanConstraintBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orgpolicy.v2.Constraint) {
        return mergeFrom((com.google.cloud.orgpolicy.v2.Constraint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orgpolicy.v2.Constraint other) {
      if (other == com.google.cloud.orgpolicy.v2.Constraint.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.constraintDefault_ != 0) {
        setConstraintDefaultValue(other.getConstraintDefaultValue());
      }
      switch (other.getConstraintTypeCase()) {
        case LIST_CONSTRAINT:
          {
            mergeListConstraint(other.getListConstraint());
            break;
          }
        case BOOLEAN_CONSTRAINT:
          {
            mergeBooleanConstraint(other.getBooleanConstraint());
            break;
          }
        case CONSTRAINTTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                constraintDefault_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getListConstraintFieldBuilder().getBuilder(), extensionRegistry);
                constraintTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getBooleanConstraintFieldBuilder().getBuilder(), extensionRegistry);
                constraintTypeCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int constraintTypeCase_ = 0;
    private java.lang.Object constraintType_;

    public ConstraintTypeCase getConstraintTypeCase() {
      return ConstraintTypeCase.forNumber(constraintTypeCase_);
    }

    public Builder clearConstraintType() {
      constraintTypeCase_ = 0;
      constraintType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Constraint. Must be in one of
     * the following forms:
     * * `projects/{project_number}/constraints/{constraint_name}`
     * * `folders/{folder_id}/constraints/{constraint_name}`
     * * `organizations/{organization_id}/constraints/{constraint_name}`
     *
     * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Constraint. Must be in one of
     * the following forms:
     * * `projects/{project_number}/constraints/{constraint_name}`
     * * `folders/{folder_id}/constraints/{constraint_name}`
     * * `organizations/{organization_id}/constraints/{constraint_name}`
     *
     * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Constraint. Must be in one of
     * the following forms:
     * * `projects/{project_number}/constraints/{constraint_name}`
     * * `folders/{folder_id}/constraints/{constraint_name}`
     * * `organizations/{organization_id}/constraints/{constraint_name}`
     *
     * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Constraint. Must be in one of
     * the following forms:
     * * `projects/{project_number}/constraints/{constraint_name}`
     * * `folders/{folder_id}/constraints/{constraint_name}`
     * * `organizations/{organization_id}/constraints/{constraint_name}`
     *
     * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Constraint. Must be in one of
     * the following forms:
     * * `projects/{project_number}/constraints/{constraint_name}`
     * * `folders/{folder_id}/constraints/{constraint_name}`
     * * `organizations/{organization_id}/constraints/{constraint_name}`
     *
     * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The human readable name.
     *
     * Mutable.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human readable name.
     *
     * Mutable.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human readable name.
     *
     * Mutable.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human readable name.
     *
     * Mutable.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human readable name.
     *
     * Mutable.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Detailed description of what this `Constraint` controls as well as how and
     * where it is enforced.
     *
     * Mutable.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed description of what this `Constraint` controls as well as how and
     * where it is enforced.
     *
     * Mutable.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed description of what this `Constraint` controls as well as how and
     * where it is enforced.
     *
     * Mutable.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed description of what this `Constraint` controls as well as how and
     * where it is enforced.
     *
     * Mutable.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed description of what this `Constraint` controls as well as how and
     * where it is enforced.
     *
     * Mutable.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int constraintDefault_ = 0;
    /**
     *
     *
     * <pre>
     * The evaluation behavior of this constraint in the absence of 'Policy'.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
     *
     * @return The enum numeric value on the wire for constraintDefault.
     */
    @java.lang.Override
    public int getConstraintDefaultValue() {
      return constraintDefault_;
    }
    /**
     *
     *
     * <pre>
     * The evaluation behavior of this constraint in the absence of 'Policy'.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
     *
     * @param value The enum numeric value on the wire for constraintDefault to set.
     * @return This builder for chaining.
     */
    public Builder setConstraintDefaultValue(int value) {
      constraintDefault_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The evaluation behavior of this constraint in the absence of 'Policy'.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
     *
     * @return The constraintDefault.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault getConstraintDefault() {
      com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault result =
          com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault.forNumber(constraintDefault_);
      return result == null
          ? com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The evaluation behavior of this constraint in the absence of 'Policy'.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
     *
     * @param value The constraintDefault to set.
     * @return This builder for chaining.
     */
    public Builder setConstraintDefault(
        com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      constraintDefault_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The evaluation behavior of this constraint in the absence of 'Policy'.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConstraintDefault() {
      bitField0_ = (bitField0_ & ~0x00000008);
      constraintDefault_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.Constraint.ListConstraint,
            com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder,
            com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder>
        listConstraintBuilder_;
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     *
     * @return Whether the listConstraint field is set.
     */
    @java.lang.Override
    public boolean hasListConstraint() {
      return constraintTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     *
     * @return The listConstraint.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint getListConstraint() {
      if (listConstraintBuilder_ == null) {
        if (constraintTypeCase_ == 5) {
          return (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_;
        }
        return com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
      } else {
        if (constraintTypeCase_ == 5) {
          return listConstraintBuilder_.getMessage();
        }
        return com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    public Builder setListConstraint(
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraint value) {
      if (listConstraintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        constraintType_ = value;
        onChanged();
      } else {
        listConstraintBuilder_.setMessage(value);
      }
      constraintTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    public Builder setListConstraint(
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder builderForValue) {
      if (listConstraintBuilder_ == null) {
        constraintType_ = builderForValue.build();
        onChanged();
      } else {
        listConstraintBuilder_.setMessage(builderForValue.build());
      }
      constraintTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    public Builder mergeListConstraint(
        com.google.cloud.orgpolicy.v2.Constraint.ListConstraint value) {
      if (listConstraintBuilder_ == null) {
        if (constraintTypeCase_ == 5
            && constraintType_
                != com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance()) {
          constraintType_ =
              com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.newBuilder(
                      (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          constraintType_ = value;
        }
        onChanged();
      } else {
        if (constraintTypeCase_ == 5) {
          listConstraintBuilder_.mergeFrom(value);
        } else {
          listConstraintBuilder_.setMessage(value);
        }
      }
      constraintTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    public Builder clearListConstraint() {
      if (listConstraintBuilder_ == null) {
        if (constraintTypeCase_ == 5) {
          constraintTypeCase_ = 0;
          constraintType_ = null;
          onChanged();
        }
      } else {
        if (constraintTypeCase_ == 5) {
          constraintTypeCase_ = 0;
          constraintType_ = null;
        }
        listConstraintBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    public com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder
        getListConstraintBuilder() {
      return getListConstraintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder
        getListConstraintOrBuilder() {
      if ((constraintTypeCase_ == 5) && (listConstraintBuilder_ != null)) {
        return listConstraintBuilder_.getMessageOrBuilder();
      } else {
        if (constraintTypeCase_ == 5) {
          return (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_;
        }
        return com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a ListConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.Constraint.ListConstraint,
            com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder,
            com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder>
        getListConstraintFieldBuilder() {
      if (listConstraintBuilder_ == null) {
        if (!(constraintTypeCase_ == 5)) {
          constraintType_ =
              com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.getDefaultInstance();
        }
        listConstraintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v2.Constraint.ListConstraint,
                com.google.cloud.orgpolicy.v2.Constraint.ListConstraint.Builder,
                com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder>(
                (com.google.cloud.orgpolicy.v2.Constraint.ListConstraint) constraintType_,
                getParentForChildren(),
                isClean());
        constraintType_ = null;
      }
      constraintTypeCase_ = 5;
      onChanged();
      return listConstraintBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint,
            com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder,
            com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder>
        booleanConstraintBuilder_;
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     *
     * @return Whether the booleanConstraint field is set.
     */
    @java.lang.Override
    public boolean hasBooleanConstraint() {
      return constraintTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     *
     * @return The booleanConstraint.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint getBooleanConstraint() {
      if (booleanConstraintBuilder_ == null) {
        if (constraintTypeCase_ == 6) {
          return (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_;
        }
        return com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
      } else {
        if (constraintTypeCase_ == 6) {
          return booleanConstraintBuilder_.getMessage();
        }
        return com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    public Builder setBooleanConstraint(
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint value) {
      if (booleanConstraintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        constraintType_ = value;
        onChanged();
      } else {
        booleanConstraintBuilder_.setMessage(value);
      }
      constraintTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    public Builder setBooleanConstraint(
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder builderForValue) {
      if (booleanConstraintBuilder_ == null) {
        constraintType_ = builderForValue.build();
        onChanged();
      } else {
        booleanConstraintBuilder_.setMessage(builderForValue.build());
      }
      constraintTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    public Builder mergeBooleanConstraint(
        com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint value) {
      if (booleanConstraintBuilder_ == null) {
        if (constraintTypeCase_ == 6
            && constraintType_
                != com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint
                    .getDefaultInstance()) {
          constraintType_ =
              com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.newBuilder(
                      (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          constraintType_ = value;
        }
        onChanged();
      } else {
        if (constraintTypeCase_ == 6) {
          booleanConstraintBuilder_.mergeFrom(value);
        } else {
          booleanConstraintBuilder_.setMessage(value);
        }
      }
      constraintTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    public Builder clearBooleanConstraint() {
      if (booleanConstraintBuilder_ == null) {
        if (constraintTypeCase_ == 6) {
          constraintTypeCase_ = 0;
          constraintType_ = null;
          onChanged();
        }
      } else {
        if (constraintTypeCase_ == 6) {
          constraintTypeCase_ = 0;
          constraintType_ = null;
        }
        booleanConstraintBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder
        getBooleanConstraintBuilder() {
      return getBooleanConstraintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder
        getBooleanConstraintOrBuilder() {
      if ((constraintTypeCase_ == 6) && (booleanConstraintBuilder_ != null)) {
        return booleanConstraintBuilder_.getMessageOrBuilder();
      } else {
        if (constraintTypeCase_ == 6) {
          return (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_;
        }
        return com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines this constraint as being a BooleanConstraint.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint,
            com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder,
            com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder>
        getBooleanConstraintFieldBuilder() {
      if (booleanConstraintBuilder_ == null) {
        if (!(constraintTypeCase_ == 6)) {
          constraintType_ =
              com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.getDefaultInstance();
        }
        booleanConstraintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint,
                com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint.Builder,
                com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder>(
                (com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint) constraintType_,
                getParentForChildren(),
                isClean());
        constraintType_ = null;
      }
      constraintTypeCase_ = 6;
      onChanged();
      return booleanConstraintBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.Constraint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.Constraint)
  private static final com.google.cloud.orgpolicy.v2.Constraint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.Constraint();
  }

  public static com.google.cloud.orgpolicy.v2.Constraint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Constraint> PARSER =
      new com.google.protobuf.AbstractParser<Constraint>() {
        @java.lang.Override
        public Constraint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Constraint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Constraint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Constraint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
