/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v2/constraint.proto

package com.google.cloud.orgpolicy.v2;

public interface ConstraintOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v2.Constraint)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Constraint. Must be in one of
   * the following forms:
   * * `projects/{project_number}/constraints/{constraint_name}`
   * * `folders/{folder_id}/constraints/{constraint_name}`
   * * `organizations/{organization_id}/constraints/{constraint_name}`
   *
   * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Constraint. Must be in one of
   * the following forms:
   * * `projects/{project_number}/constraints/{constraint_name}`
   * * `folders/{folder_id}/constraints/{constraint_name}`
   * * `organizations/{organization_id}/constraints/{constraint_name}`
   *
   * For example, "/projects/123/constraints/compute.disableSerialPortAccess".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The human readable name.
   *
   * Mutable.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * The human readable name.
   *
   * Mutable.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Detailed description of what this `Constraint` controls as well as how and
   * where it is enforced.
   *
   * Mutable.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Detailed description of what this `Constraint` controls as well as how and
   * where it is enforced.
   *
   * Mutable.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * The evaluation behavior of this constraint in the absence of 'Policy'.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
   *
   * @return The enum numeric value on the wire for constraintDefault.
   */
  int getConstraintDefaultValue();
  /**
   *
   *
   * <pre>
   * The evaluation behavior of this constraint in the absence of 'Policy'.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault constraint_default = 4;</code>
   *
   * @return The constraintDefault.
   */
  com.google.cloud.orgpolicy.v2.Constraint.ConstraintDefault getConstraintDefault();

  /**
   *
   *
   * <pre>
   * Defines this constraint as being a ListConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
   *
   * @return Whether the listConstraint field is set.
   */
  boolean hasListConstraint();
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a ListConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
   *
   * @return The listConstraint.
   */
  com.google.cloud.orgpolicy.v2.Constraint.ListConstraint getListConstraint();
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a ListConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.ListConstraint list_constraint = 5;</code>
   */
  com.google.cloud.orgpolicy.v2.Constraint.ListConstraintOrBuilder getListConstraintOrBuilder();

  /**
   *
   *
   * <pre>
   * Defines this constraint as being a BooleanConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
   *
   * @return Whether the booleanConstraint field is set.
   */
  boolean hasBooleanConstraint();
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a BooleanConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
   *
   * @return The booleanConstraint.
   */
  com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint getBooleanConstraint();
  /**
   *
   *
   * <pre>
   * Defines this constraint as being a BooleanConstraint.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.Constraint.BooleanConstraint boolean_constraint = 6;</code>
   */
  com.google.cloud.orgpolicy.v2.Constraint.BooleanConstraintOrBuilder
      getBooleanConstraintOrBuilder();

  com.google.cloud.orgpolicy.v2.Constraint.ConstraintTypeCase getConstraintTypeCase();
}
