/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

package com.google.cloud.orgpolicy.v2;

/**
 *
 *
 * <pre>
 * Defines a Cloud Organization `Policy` which is used to specify `Constraints`
 * for configurations of Cloud Platform resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orgpolicy.v2.Policy}
 */
public final class Policy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.Policy)
    PolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Policy.newBuilder() to construct.
  private Policy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Policy() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Policy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orgpolicy.v2.OrgPolicyProto
        .internal_static_google_cloud_orgpolicy_v2_Policy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orgpolicy.v2.OrgPolicyProto
        .internal_static_google_cloud_orgpolicy_v2_Policy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orgpolicy.v2.Policy.class,
            com.google.cloud.orgpolicy.v2.Policy.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Policy. Must be one of the following
   * forms, where constraint_name is the name of the constraint which this
   * Policy configures:
   * * `projects/{project_number}/policies/{constraint_name}`
   * * `folders/{folder_id}/policies/{constraint_name}`
   * * `organizations/{organization_id}/policies/{constraint_name}`
   *
   * For example, "projects/123/policies/compute.disableSerialPortAccess".
   *
   * Note: `projects/{project_id}/policies/{constraint_name}` is also an
   * acceptable name for API requests, but responses will return the name using
   * the equivalent project number.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Policy. Must be one of the following
   * forms, where constraint_name is the name of the constraint which this
   * Policy configures:
   * * `projects/{project_number}/policies/{constraint_name}`
   * * `folders/{folder_id}/policies/{constraint_name}`
   * * `organizations/{organization_id}/policies/{constraint_name}`
   *
   * For example, "projects/123/policies/compute.disableSerialPortAccess".
   *
   * Note: `projects/{project_id}/policies/{constraint_name}` is also an
   * acceptable name for API requests, but responses will return the name using
   * the equivalent project number.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.orgpolicy.v2.PolicySpec spec_;
  /**
   *
   *
   * <pre>
   * Basic information about the Organization Policy.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
   *
   * @return Whether the spec field is set.
   */
  @java.lang.Override
  public boolean hasSpec() {
    return spec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Basic information about the Organization Policy.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
   *
   * @return The spec.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpec getSpec() {
    return spec_ == null ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance() : spec_;
  }
  /**
   *
   *
   * <pre>
   * Basic information about the Organization Policy.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder getSpecOrBuilder() {
    return spec_ == null ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance() : spec_;
  }

  public static final int ALTERNATE_FIELD_NUMBER = 3;
  private com.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate_;
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.orgpolicy.v2.Policy.alternate is deprecated. See
   *     google/cloud/orgpolicy/v2/orgpolicy.proto;l=204
   * @return Whether the alternate field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasAlternate() {
    return alternate_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.orgpolicy.v2.Policy.alternate is deprecated. See
   *     google/cloud/orgpolicy/v2/orgpolicy.proto;l=204
   * @return The alternate.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.orgpolicy.v2.AlternatePolicySpec getAlternate() {
    return alternate_ == null
        ? com.google.cloud.orgpolicy.v2.AlternatePolicySpec.getDefaultInstance()
        : alternate_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.orgpolicy.v2.AlternatePolicySpecOrBuilder getAlternateOrBuilder() {
    return alternate_ == null
        ? com.google.cloud.orgpolicy.v2.AlternatePolicySpec.getDefaultInstance()
        : alternate_;
  }

  public static final int DRY_RUN_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.orgpolicy.v2.PolicySpec dryRunSpec_;
  /**
   *
   *
   * <pre>
   * dry-run policy.
   * Audit-only policy, can be used to monitor how the policy would have
   * impacted the existing and future resources if it's enforced.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
   *
   * @return Whether the dryRunSpec field is set.
   */
  @java.lang.Override
  public boolean hasDryRunSpec() {
    return dryRunSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * dry-run policy.
   * Audit-only policy, can be used to monitor how the policy would have
   * impacted the existing and future resources if it's enforced.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
   *
   * @return The dryRunSpec.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpec getDryRunSpec() {
    return dryRunSpec_ == null
        ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()
        : dryRunSpec_;
  }
  /**
   *
   *
   * <pre>
   * dry-run policy.
   * Audit-only policy, can be used to monitor how the policy would have
   * impacted the existing and future resources if it's enforced.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder getDryRunSpecOrBuilder() {
    return dryRunSpec_ == null
        ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()
        : dryRunSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (spec_ != null) {
      output.writeMessage(2, getSpec());
    }
    if (alternate_ != null) {
      output.writeMessage(3, getAlternate());
    }
    if (dryRunSpec_ != null) {
      output.writeMessage(4, getDryRunSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (spec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
    }
    if (alternate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAlternate());
    }
    if (dryRunSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDryRunSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orgpolicy.v2.Policy)) {
      return super.equals(obj);
    }
    com.google.cloud.orgpolicy.v2.Policy other = (com.google.cloud.orgpolicy.v2.Policy) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSpec() != other.hasSpec()) return false;
    if (hasSpec()) {
      if (!getSpec().equals(other.getSpec())) return false;
    }
    if (hasAlternate() != other.hasAlternate()) return false;
    if (hasAlternate()) {
      if (!getAlternate().equals(other.getAlternate())) return false;
    }
    if (hasDryRunSpec() != other.hasDryRunSpec()) return false;
    if (hasDryRunSpec()) {
      if (!getDryRunSpec().equals(other.getDryRunSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSpec()) {
      hash = (37 * hash) + SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSpec().hashCode();
    }
    if (hasAlternate()) {
      hash = (37 * hash) + ALTERNATE_FIELD_NUMBER;
      hash = (53 * hash) + getAlternate().hashCode();
    }
    if (hasDryRunSpec()) {
      hash = (37 * hash) + DRY_RUN_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDryRunSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.Policy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.orgpolicy.v2.Policy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a Cloud Organization `Policy` which is used to specify `Constraints`
   * for configurations of Cloud Platform resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.Policy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.Policy)
      com.google.cloud.orgpolicy.v2.PolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_Policy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_Policy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.Policy.class,
              com.google.cloud.orgpolicy.v2.Policy.Builder.class);
    }

    // Construct using com.google.cloud.orgpolicy.v2.Policy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      spec_ = null;
      if (specBuilder_ != null) {
        specBuilder_.dispose();
        specBuilder_ = null;
      }
      alternate_ = null;
      if (alternateBuilder_ != null) {
        alternateBuilder_.dispose();
        alternateBuilder_ = null;
      }
      dryRunSpec_ = null;
      if (dryRunSpecBuilder_ != null) {
        dryRunSpecBuilder_.dispose();
        dryRunSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_Policy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Policy getDefaultInstanceForType() {
      return com.google.cloud.orgpolicy.v2.Policy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Policy build() {
      com.google.cloud.orgpolicy.v2.Policy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.Policy buildPartial() {
      com.google.cloud.orgpolicy.v2.Policy result = new com.google.cloud.orgpolicy.v2.Policy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.orgpolicy.v2.Policy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.spec_ = specBuilder_ == null ? spec_ : specBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.alternate_ = alternateBuilder_ == null ? alternate_ : alternateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dryRunSpec_ = dryRunSpecBuilder_ == null ? dryRunSpec_ : dryRunSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orgpolicy.v2.Policy) {
        return mergeFrom((com.google.cloud.orgpolicy.v2.Policy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orgpolicy.v2.Policy other) {
      if (other == com.google.cloud.orgpolicy.v2.Policy.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSpec()) {
        mergeSpec(other.getSpec());
      }
      if (other.hasAlternate()) {
        mergeAlternate(other.getAlternate());
      }
      if (other.hasDryRunSpec()) {
        mergeDryRunSpec(other.getDryRunSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAlternateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDryRunSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Policy. Must be one of the following
     * forms, where constraint_name is the name of the constraint which this
     * Policy configures:
     * * `projects/{project_number}/policies/{constraint_name}`
     * * `folders/{folder_id}/policies/{constraint_name}`
     * * `organizations/{organization_id}/policies/{constraint_name}`
     *
     * For example, "projects/123/policies/compute.disableSerialPortAccess".
     *
     * Note: `projects/{project_id}/policies/{constraint_name}` is also an
     * acceptable name for API requests, but responses will return the name using
     * the equivalent project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Policy. Must be one of the following
     * forms, where constraint_name is the name of the constraint which this
     * Policy configures:
     * * `projects/{project_number}/policies/{constraint_name}`
     * * `folders/{folder_id}/policies/{constraint_name}`
     * * `organizations/{organization_id}/policies/{constraint_name}`
     *
     * For example, "projects/123/policies/compute.disableSerialPortAccess".
     *
     * Note: `projects/{project_id}/policies/{constraint_name}` is also an
     * acceptable name for API requests, but responses will return the name using
     * the equivalent project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Policy. Must be one of the following
     * forms, where constraint_name is the name of the constraint which this
     * Policy configures:
     * * `projects/{project_number}/policies/{constraint_name}`
     * * `folders/{folder_id}/policies/{constraint_name}`
     * * `organizations/{organization_id}/policies/{constraint_name}`
     *
     * For example, "projects/123/policies/compute.disableSerialPortAccess".
     *
     * Note: `projects/{project_id}/policies/{constraint_name}` is also an
     * acceptable name for API requests, but responses will return the name using
     * the equivalent project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Policy. Must be one of the following
     * forms, where constraint_name is the name of the constraint which this
     * Policy configures:
     * * `projects/{project_number}/policies/{constraint_name}`
     * * `folders/{folder_id}/policies/{constraint_name}`
     * * `organizations/{organization_id}/policies/{constraint_name}`
     *
     * For example, "projects/123/policies/compute.disableSerialPortAccess".
     *
     * Note: `projects/{project_id}/policies/{constraint_name}` is also an
     * acceptable name for API requests, but responses will return the name using
     * the equivalent project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Policy. Must be one of the following
     * forms, where constraint_name is the name of the constraint which this
     * Policy configures:
     * * `projects/{project_number}/policies/{constraint_name}`
     * * `folders/{folder_id}/policies/{constraint_name}`
     * * `organizations/{organization_id}/policies/{constraint_name}`
     *
     * For example, "projects/123/policies/compute.disableSerialPortAccess".
     *
     * Note: `projects/{project_id}/policies/{constraint_name}` is also an
     * acceptable name for API requests, but responses will return the name using
     * the equivalent project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.orgpolicy.v2.PolicySpec spec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.PolicySpec,
            com.google.cloud.orgpolicy.v2.PolicySpec.Builder,
            com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder>
        specBuilder_;
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     *
     * @return Whether the spec field is set.
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     *
     * @return The spec.
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec getSpec() {
      if (specBuilder_ == null) {
        return spec_ == null
            ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()
            : spec_;
      } else {
        return specBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    public Builder setSpec(com.google.cloud.orgpolicy.v2.PolicySpec value) {
      if (specBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
      } else {
        specBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    public Builder setSpec(com.google.cloud.orgpolicy.v2.PolicySpec.Builder builderForValue) {
      if (specBuilder_ == null) {
        spec_ = builderForValue.build();
      } else {
        specBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    public Builder mergeSpec(com.google.cloud.orgpolicy.v2.PolicySpec value) {
      if (specBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && spec_ != null
            && spec_ != com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()) {
          getSpecBuilder().mergeFrom(value);
        } else {
          spec_ = value;
        }
      } else {
        specBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    public Builder clearSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      spec_ = null;
      if (specBuilder_ != null) {
        specBuilder_.dispose();
        specBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.Builder getSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder getSpecOrBuilder() {
      if (specBuilder_ != null) {
        return specBuilder_.getMessageOrBuilder();
      } else {
        return spec_ == null
            ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()
            : spec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Basic information about the Organization Policy.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec spec = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.PolicySpec,
            com.google.cloud.orgpolicy.v2.PolicySpec.Builder,
            com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder>
        getSpecFieldBuilder() {
      if (specBuilder_ == null) {
        specBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v2.PolicySpec,
                com.google.cloud.orgpolicy.v2.PolicySpec.Builder,
                com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder>(
                getSpec(), getParentForChildren(), isClean());
        spec_ = null;
      }
      return specBuilder_;
    }

    private com.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.AlternatePolicySpec,
            com.google.cloud.orgpolicy.v2.AlternatePolicySpec.Builder,
            com.google.cloud.orgpolicy.v2.AlternatePolicySpecOrBuilder>
        alternateBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.orgpolicy.v2.Policy.alternate is deprecated. See
     *     google/cloud/orgpolicy/v2/orgpolicy.proto;l=204
     * @return Whether the alternate field is set.
     */
    @java.lang.Deprecated
    public boolean hasAlternate() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.orgpolicy.v2.Policy.alternate is deprecated. See
     *     google/cloud/orgpolicy/v2/orgpolicy.proto;l=204
     * @return The alternate.
     */
    @java.lang.Deprecated
    public com.google.cloud.orgpolicy.v2.AlternatePolicySpec getAlternate() {
      if (alternateBuilder_ == null) {
        return alternate_ == null
            ? com.google.cloud.orgpolicy.v2.AlternatePolicySpec.getDefaultInstance()
            : alternate_;
      } else {
        return alternateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setAlternate(com.google.cloud.orgpolicy.v2.AlternatePolicySpec value) {
      if (alternateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alternate_ = value;
      } else {
        alternateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setAlternate(
        com.google.cloud.orgpolicy.v2.AlternatePolicySpec.Builder builderForValue) {
      if (alternateBuilder_ == null) {
        alternate_ = builderForValue.build();
      } else {
        alternateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeAlternate(com.google.cloud.orgpolicy.v2.AlternatePolicySpec value) {
      if (alternateBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && alternate_ != null
            && alternate_
                != com.google.cloud.orgpolicy.v2.AlternatePolicySpec.getDefaultInstance()) {
          getAlternateBuilder().mergeFrom(value);
        } else {
          alternate_ = value;
        }
      } else {
        alternateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearAlternate() {
      bitField0_ = (bitField0_ & ~0x00000004);
      alternate_ = null;
      if (alternateBuilder_ != null) {
        alternateBuilder_.dispose();
        alternateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.orgpolicy.v2.AlternatePolicySpec.Builder getAlternateBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAlternateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.orgpolicy.v2.AlternatePolicySpecOrBuilder getAlternateOrBuilder() {
      if (alternateBuilder_ != null) {
        return alternateBuilder_.getMessageOrBuilder();
      } else {
        return alternate_ == null
            ? com.google.cloud.orgpolicy.v2.AlternatePolicySpec.getDefaultInstance()
            : alternate_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.AlternatePolicySpec alternate = 3 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.AlternatePolicySpec,
            com.google.cloud.orgpolicy.v2.AlternatePolicySpec.Builder,
            com.google.cloud.orgpolicy.v2.AlternatePolicySpecOrBuilder>
        getAlternateFieldBuilder() {
      if (alternateBuilder_ == null) {
        alternateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v2.AlternatePolicySpec,
                com.google.cloud.orgpolicy.v2.AlternatePolicySpec.Builder,
                com.google.cloud.orgpolicy.v2.AlternatePolicySpecOrBuilder>(
                getAlternate(), getParentForChildren(), isClean());
        alternate_ = null;
      }
      return alternateBuilder_;
    }

    private com.google.cloud.orgpolicy.v2.PolicySpec dryRunSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.PolicySpec,
            com.google.cloud.orgpolicy.v2.PolicySpec.Builder,
            com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder>
        dryRunSpecBuilder_;
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     *
     * @return Whether the dryRunSpec field is set.
     */
    public boolean hasDryRunSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     *
     * @return The dryRunSpec.
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec getDryRunSpec() {
      if (dryRunSpecBuilder_ == null) {
        return dryRunSpec_ == null
            ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()
            : dryRunSpec_;
      } else {
        return dryRunSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    public Builder setDryRunSpec(com.google.cloud.orgpolicy.v2.PolicySpec value) {
      if (dryRunSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dryRunSpec_ = value;
      } else {
        dryRunSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    public Builder setDryRunSpec(com.google.cloud.orgpolicy.v2.PolicySpec.Builder builderForValue) {
      if (dryRunSpecBuilder_ == null) {
        dryRunSpec_ = builderForValue.build();
      } else {
        dryRunSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    public Builder mergeDryRunSpec(com.google.cloud.orgpolicy.v2.PolicySpec value) {
      if (dryRunSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && dryRunSpec_ != null
            && dryRunSpec_ != com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()) {
          getDryRunSpecBuilder().mergeFrom(value);
        } else {
          dryRunSpec_ = value;
        }
      } else {
        dryRunSpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    public Builder clearDryRunSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dryRunSpec_ = null;
      if (dryRunSpecBuilder_ != null) {
        dryRunSpecBuilder_.dispose();
        dryRunSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.Builder getDryRunSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDryRunSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder getDryRunSpecOrBuilder() {
      if (dryRunSpecBuilder_ != null) {
        return dryRunSpecBuilder_.getMessageOrBuilder();
      } else {
        return dryRunSpec_ == null
            ? com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()
            : dryRunSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * dry-run policy.
     * Audit-only policy, can be used to monitor how the policy would have
     * impacted the existing and future resources if it's enforced.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec dry_run_spec = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.PolicySpec,
            com.google.cloud.orgpolicy.v2.PolicySpec.Builder,
            com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder>
        getDryRunSpecFieldBuilder() {
      if (dryRunSpecBuilder_ == null) {
        dryRunSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.orgpolicy.v2.PolicySpec,
                com.google.cloud.orgpolicy.v2.PolicySpec.Builder,
                com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder>(
                getDryRunSpec(), getParentForChildren(), isClean());
        dryRunSpec_ = null;
      }
      return dryRunSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.Policy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.Policy)
  private static final com.google.cloud.orgpolicy.v2.Policy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.Policy();
  }

  public static com.google.cloud.orgpolicy.v2.Policy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Policy> PARSER =
      new com.google.protobuf.AbstractParser<Policy>() {
        @java.lang.Override
        public Policy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Policy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Policy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.Policy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
