/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

package com.google.cloud.orgpolicy.v2;

/**
 *
 *
 * <pre>
 * Defines a Cloud Organization `PolicySpec` which is used to specify
 * `Constraints` for configurations of Cloud Platform resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orgpolicy.v2.PolicySpec}
 */
public final class PolicySpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.PolicySpec)
    PolicySpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PolicySpec.newBuilder() to construct.
  private PolicySpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PolicySpec() {
    etag_ = "";
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PolicySpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orgpolicy.v2.OrgPolicyProto
        .internal_static_google_cloud_orgpolicy_v2_PolicySpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orgpolicy.v2.OrgPolicyProto
        .internal_static_google_cloud_orgpolicy_v2_PolicySpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orgpolicy.v2.PolicySpec.class,
            com.google.cloud.orgpolicy.v2.PolicySpec.Builder.class);
  }

  public interface PolicyRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of values to be used for this PolicyRule. This field can be set
     * only in Policies for list constraints.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
     *
     * @return Whether the values field is set.
     */
    boolean hasValues();
    /**
     *
     *
     * <pre>
     * List of values to be used for this PolicyRule. This field can be set
     * only in Policies for list constraints.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
     *
     * @return The values.
     */
    com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues getValues();
    /**
     *
     *
     * <pre>
     * List of values to be used for this PolicyRule. This field can be set
     * only in Policies for list constraints.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
     */
    com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder getValuesOrBuilder();

    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are allowed. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool allow_all = 2;</code>
     *
     * @return Whether the allowAll field is set.
     */
    boolean hasAllowAll();
    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are allowed. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool allow_all = 2;</code>
     *
     * @return The allowAll.
     */
    boolean getAllowAll();

    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are denied. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool deny_all = 3;</code>
     *
     * @return Whether the denyAll field is set.
     */
    boolean hasDenyAll();
    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are denied. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool deny_all = 3;</code>
     *
     * @return The denyAll.
     */
    boolean getDenyAll();

    /**
     *
     *
     * <pre>
     * If `true`, then the `Policy` is enforced. If `false`, then any
     * configuration is acceptable.
     * This field can be set only in Policies for boolean constraints.
     * </pre>
     *
     * <code>bool enforce = 4;</code>
     *
     * @return Whether the enforce field is set.
     */
    boolean hasEnforce();
    /**
     *
     *
     * <pre>
     * If `true`, then the `Policy` is enforced. If `false`, then any
     * configuration is acceptable.
     * This field can be set only in Policies for boolean constraints.
     * </pre>
     *
     * <code>bool enforce = 4;</code>
     *
     * @return The enforce.
     */
    boolean getEnforce();

    /**
     *
     *
     * <pre>
     * A condition which determines whether this rule is used
     * in the evaluation of the policy. When set, the `expression` field in
     * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
     * or "&amp;&amp;" operators. Each subexpression must be of the form
     * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
     * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
     * 'tagValues/value_id')". where key_name and value_name are the resource
     * names for Label Keys and Values. These names are available from the Tag
     * Manager Service. An example expression is:
     * "resource.matchTag('123456789/environment,
     * 'prod')". or "resource.matchTagId('tagKeys/123',
     * 'tagValues/456')".
     * </pre>
     *
     * <code>.google.type.Expr condition = 5;</code>
     *
     * @return Whether the condition field is set.
     */
    boolean hasCondition();
    /**
     *
     *
     * <pre>
     * A condition which determines whether this rule is used
     * in the evaluation of the policy. When set, the `expression` field in
     * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
     * or "&amp;&amp;" operators. Each subexpression must be of the form
     * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
     * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
     * 'tagValues/value_id')". where key_name and value_name are the resource
     * names for Label Keys and Values. These names are available from the Tag
     * Manager Service. An example expression is:
     * "resource.matchTag('123456789/environment,
     * 'prod')". or "resource.matchTagId('tagKeys/123',
     * 'tagValues/456')".
     * </pre>
     *
     * <code>.google.type.Expr condition = 5;</code>
     *
     * @return The condition.
     */
    com.google.type.Expr getCondition();
    /**
     *
     *
     * <pre>
     * A condition which determines whether this rule is used
     * in the evaluation of the policy. When set, the `expression` field in
     * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
     * or "&amp;&amp;" operators. Each subexpression must be of the form
     * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
     * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
     * 'tagValues/value_id')". where key_name and value_name are the resource
     * names for Label Keys and Values. These names are available from the Tag
     * Manager Service. An example expression is:
     * "resource.matchTag('123456789/environment,
     * 'prod')". or "resource.matchTagId('tagKeys/123',
     * 'tagValues/456')".
     * </pre>
     *
     * <code>.google.type.Expr condition = 5;</code>
     */
    com.google.type.ExprOrBuilder getConditionOrBuilder();

    com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.KindCase getKindCase();
  }
  /**
   *
   *
   * <pre>
   * A rule used to express this policy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.PolicySpec.PolicyRule}
   */
  public static final class PolicyRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule)
      PolicyRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PolicyRule.newBuilder() to construct.
    private PolicyRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PolicyRule() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PolicyRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.class,
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder.class);
    }

    public interface StringValuesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return A list containing the allowedValues.
       */
      java.util.List<java.lang.String> getAllowedValuesList();
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return The count of allowedValues.
       */
      int getAllowedValuesCount();
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allowedValues at the given index.
       */
      java.lang.String getAllowedValues(int index);
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedValues at the given index.
       */
      com.google.protobuf.ByteString getAllowedValuesBytes(int index);

      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return A list containing the deniedValues.
       */
      java.util.List<java.lang.String> getDeniedValuesList();
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return The count of deniedValues.
       */
      int getDeniedValuesCount();
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The deniedValues at the given index.
       */
      java.lang.String getDeniedValues(int index);
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the deniedValues at the given index.
       */
      com.google.protobuf.ByteString getDeniedValuesBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * A message that holds specific allowed and denied values.
     * This message can define specific values and subtrees of Cloud Resource
     * Manager resource hierarchy (`Organizations`, `Folders`, `Projects`) that
     * are allowed or denied. This is achieved by using the `under:` and
     * optional `is:` prefixes.
     * The `under:` prefix is used to denote resource subtree values.
     * The `is:` prefix is used to denote specific values, and is required only
     * if the value contains a ":". Values prefixed with "is:" are treated the
     * same as values with no prefix.
     * Ancestry subtrees must be in one of the following formats:
     *     - "projects/&lt;project-id&gt;", e.g. "projects/tokyo-rain-123"
     *     - "folders/&lt;folder-id&gt;", e.g. "folders/1234"
     *     - "organizations/&lt;organization-id&gt;", e.g. "organizations/1234"
     * The `supports_under` field of the associated `Constraint`  defines
     * whether ancestry prefixes can be used.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues}
     */
    public static final class StringValues extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues)
        StringValuesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use StringValues.newBuilder() to construct.
      private StringValues(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private StringValues() {
        allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        deniedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new StringValues();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v2.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_StringValues_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v2.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_StringValues_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.class,
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder.class);
      }

      public static final int ALLOWED_VALUES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList allowedValues_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return A list containing the allowedValues.
       */
      public com.google.protobuf.ProtocolStringList getAllowedValuesList() {
        return allowedValues_;
      }
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @return The count of allowedValues.
       */
      public int getAllowedValuesCount() {
        return allowedValues_.size();
      }
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allowedValues at the given index.
       */
      public java.lang.String getAllowedValues(int index) {
        return allowedValues_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of values allowed at this resource.
       * </pre>
       *
       * <code>repeated string allowed_values = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedValues at the given index.
       */
      public com.google.protobuf.ByteString getAllowedValuesBytes(int index) {
        return allowedValues_.getByteString(index);
      }

      public static final int DENIED_VALUES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList deniedValues_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return A list containing the deniedValues.
       */
      public com.google.protobuf.ProtocolStringList getDeniedValuesList() {
        return deniedValues_;
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @return The count of deniedValues.
       */
      public int getDeniedValuesCount() {
        return deniedValues_.size();
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The deniedValues at the given index.
       */
      public java.lang.String getDeniedValues(int index) {
        return deniedValues_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of values denied at this resource.
       * </pre>
       *
       * <code>repeated string denied_values = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the deniedValues at the given index.
       */
      public com.google.protobuf.ByteString getDeniedValuesBytes(int index) {
        return deniedValues_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < allowedValues_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowedValues_.getRaw(i));
        }
        for (int i = 0; i < deniedValues_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deniedValues_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < allowedValues_.size(); i++) {
            dataSize += computeStringSizeNoTag(allowedValues_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getAllowedValuesList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < deniedValues_.size(); i++) {
            dataSize += computeStringSizeNoTag(deniedValues_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getDeniedValuesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues)) {
          return super.equals(obj);
        }
        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues other =
            (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) obj;

        if (!getAllowedValuesList().equals(other.getAllowedValuesList())) return false;
        if (!getDeniedValuesList().equals(other.getDeniedValuesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getAllowedValuesCount() > 0) {
          hash = (37 * hash) + ALLOWED_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getAllowedValuesList().hashCode();
        }
        if (getDeniedValuesCount() > 0) {
          hash = (37 * hash) + DENIED_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getDeniedValuesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A message that holds specific allowed and denied values.
       * This message can define specific values and subtrees of Cloud Resource
       * Manager resource hierarchy (`Organizations`, `Folders`, `Projects`) that
       * are allowed or denied. This is achieved by using the `under:` and
       * optional `is:` prefixes.
       * The `under:` prefix is used to denote resource subtree values.
       * The `is:` prefix is used to denote specific values, and is required only
       * if the value contains a ":". Values prefixed with "is:" are treated the
       * same as values with no prefix.
       * Ancestry subtrees must be in one of the following formats:
       *     - "projects/&lt;project-id&gt;", e.g. "projects/tokyo-rain-123"
       *     - "folders/&lt;folder-id&gt;", e.g. "folders/1234"
       *     - "organizations/&lt;organization-id&gt;", e.g. "organizations/1234"
       * The `supports_under` field of the associated `Constraint`  defines
       * whether ancestry prefixes can be used.
       * </pre>
       *
       * Protobuf type {@code google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues)
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.orgpolicy.v2.OrgPolicyProto
              .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_StringValues_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.orgpolicy.v2.OrgPolicyProto
              .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_StringValues_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.class,
                  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder.class);
        }

        // Construct using
        // com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          deniedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.orgpolicy.v2.OrgPolicyProto
              .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_StringValues_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
            getDefaultInstanceForType() {
          return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues build() {
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues buildPartial() {
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues result =
              new com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            allowedValues_.makeImmutable();
            result.allowedValues_ = allowedValues_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            deniedValues_.makeImmutable();
            result.deniedValues_ = deniedValues_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) {
            return mergeFrom(
                (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues other) {
          if (other
              == com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
                  .getDefaultInstance()) return this;
          if (!other.allowedValues_.isEmpty()) {
            if (allowedValues_.isEmpty()) {
              allowedValues_ = other.allowedValues_;
              bitField0_ |= 0x00000001;
            } else {
              ensureAllowedValuesIsMutable();
              allowedValues_.addAll(other.allowedValues_);
            }
            onChanged();
          }
          if (!other.deniedValues_.isEmpty()) {
            if (deniedValues_.isEmpty()) {
              deniedValues_ = other.deniedValues_;
              bitField0_ |= 0x00000002;
            } else {
              ensureDeniedValuesIsMutable();
              deniedValues_.addAll(other.deniedValues_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureAllowedValuesIsMutable();
                    allowedValues_.add(s);
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureDeniedValuesIsMutable();
                    deniedValues_.add(s);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList allowedValues_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureAllowedValuesIsMutable() {
          if (!allowedValues_.isModifiable()) {
            allowedValues_ = new com.google.protobuf.LazyStringArrayList(allowedValues_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @return A list containing the allowedValues.
         */
        public com.google.protobuf.ProtocolStringList getAllowedValuesList() {
          allowedValues_.makeImmutable();
          return allowedValues_;
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @return The count of allowedValues.
         */
        public int getAllowedValuesCount() {
          return allowedValues_.size();
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The allowedValues at the given index.
         */
        public java.lang.String getAllowedValues(int index) {
          return allowedValues_.get(index);
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the allowedValues at the given index.
         */
        public com.google.protobuf.ByteString getAllowedValuesBytes(int index) {
          return allowedValues_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The allowedValues to set.
         * @return This builder for chaining.
         */
        public Builder setAllowedValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAllowedValuesIsMutable();
          allowedValues_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @param value The allowedValues to add.
         * @return This builder for chaining.
         */
        public Builder addAllowedValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAllowedValuesIsMutable();
          allowedValues_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @param values The allowedValues to add.
         * @return This builder for chaining.
         */
        public Builder addAllAllowedValues(java.lang.Iterable<java.lang.String> values) {
          ensureAllowedValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedValues_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAllowedValues() {
          allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values allowed at this resource.
         * </pre>
         *
         * <code>repeated string allowed_values = 1;</code>
         *
         * @param value The bytes of the allowedValues to add.
         * @return This builder for chaining.
         */
        public Builder addAllowedValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureAllowedValuesIsMutable();
          allowedValues_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList deniedValues_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureDeniedValuesIsMutable() {
          if (!deniedValues_.isModifiable()) {
            deniedValues_ = new com.google.protobuf.LazyStringArrayList(deniedValues_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @return A list containing the deniedValues.
         */
        public com.google.protobuf.ProtocolStringList getDeniedValuesList() {
          deniedValues_.makeImmutable();
          return deniedValues_;
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @return The count of deniedValues.
         */
        public int getDeniedValuesCount() {
          return deniedValues_.size();
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The deniedValues at the given index.
         */
        public java.lang.String getDeniedValues(int index) {
          return deniedValues_.get(index);
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the deniedValues at the given index.
         */
        public com.google.protobuf.ByteString getDeniedValuesBytes(int index) {
          return deniedValues_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The deniedValues to set.
         * @return This builder for chaining.
         */
        public Builder setDeniedValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeniedValuesIsMutable();
          deniedValues_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @param value The deniedValues to add.
         * @return This builder for chaining.
         */
        public Builder addDeniedValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeniedValuesIsMutable();
          deniedValues_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @param values The deniedValues to add.
         * @return This builder for chaining.
         */
        public Builder addAllDeniedValues(java.lang.Iterable<java.lang.String> values) {
          ensureDeniedValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deniedValues_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDeniedValues() {
          deniedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of values denied at this resource.
         * </pre>
         *
         * <code>repeated string denied_values = 2;</code>
         *
         * @param value The bytes of the deniedValues to add.
         * @return This builder for chaining.
         */
        public Builder addDeniedValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureDeniedValuesIsMutable();
          deniedValues_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues)
      private static final com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues();
      }

      public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<StringValues> PARSER =
          new com.google.protobuf.AbstractParser<StringValues>() {
            @java.lang.Override
            public StringValues parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<StringValues> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<StringValues> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int kindCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object kind_;

    public enum KindCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VALUES(1),
      ALLOW_ALL(2),
      DENY_ALL(3),
      ENFORCE(4),
      KIND_NOT_SET(0);
      private final int value;

      private KindCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static KindCase valueOf(int value) {
        return forNumber(value);
      }

      public static KindCase forNumber(int value) {
        switch (value) {
          case 1:
            return VALUES;
          case 2:
            return ALLOW_ALL;
          case 3:
            return DENY_ALL;
          case 4:
            return ENFORCE;
          case 0:
            return KIND_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public static final int VALUES_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * List of values to be used for this PolicyRule. This field can be set
     * only in Policies for list constraints.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
     *
     * @return Whether the values field is set.
     */
    @java.lang.Override
    public boolean hasValues() {
      return kindCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * List of values to be used for this PolicyRule. This field can be set
     * only in Policies for list constraints.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
     *
     * @return The values.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues getValues() {
      if (kindCase_ == 1) {
        return (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_;
      }
      return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * List of values to be used for this PolicyRule. This field can be set
     * only in Policies for list constraints.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder
        getValuesOrBuilder() {
      if (kindCase_ == 1) {
        return (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_;
      }
      return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.getDefaultInstance();
    }

    public static final int ALLOW_ALL_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are allowed. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool allow_all = 2;</code>
     *
     * @return Whether the allowAll field is set.
     */
    @java.lang.Override
    public boolean hasAllowAll() {
      return kindCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are allowed. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool allow_all = 2;</code>
     *
     * @return The allowAll.
     */
    @java.lang.Override
    public boolean getAllowAll() {
      if (kindCase_ == 2) {
        return (java.lang.Boolean) kind_;
      }
      return false;
    }

    public static final int DENY_ALL_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are denied. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool deny_all = 3;</code>
     *
     * @return Whether the denyAll field is set.
     */
    @java.lang.Override
    public boolean hasDenyAll() {
      return kindCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Setting this to true means that all values are denied. This field can
     * be set only in Policies for list constraints.
     * </pre>
     *
     * <code>bool deny_all = 3;</code>
     *
     * @return The denyAll.
     */
    @java.lang.Override
    public boolean getDenyAll() {
      if (kindCase_ == 3) {
        return (java.lang.Boolean) kind_;
      }
      return false;
    }

    public static final int ENFORCE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * If `true`, then the `Policy` is enforced. If `false`, then any
     * configuration is acceptable.
     * This field can be set only in Policies for boolean constraints.
     * </pre>
     *
     * <code>bool enforce = 4;</code>
     *
     * @return Whether the enforce field is set.
     */
    @java.lang.Override
    public boolean hasEnforce() {
      return kindCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * If `true`, then the `Policy` is enforced. If `false`, then any
     * configuration is acceptable.
     * This field can be set only in Policies for boolean constraints.
     * </pre>
     *
     * <code>bool enforce = 4;</code>
     *
     * @return The enforce.
     */
    @java.lang.Override
    public boolean getEnforce() {
      if (kindCase_ == 4) {
        return (java.lang.Boolean) kind_;
      }
      return false;
    }

    public static final int CONDITION_FIELD_NUMBER = 5;
    private com.google.type.Expr condition_;
    /**
     *
     *
     * <pre>
     * A condition which determines whether this rule is used
     * in the evaluation of the policy. When set, the `expression` field in
     * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
     * or "&amp;&amp;" operators. Each subexpression must be of the form
     * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
     * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
     * 'tagValues/value_id')". where key_name and value_name are the resource
     * names for Label Keys and Values. These names are available from the Tag
     * Manager Service. An example expression is:
     * "resource.matchTag('123456789/environment,
     * 'prod')". or "resource.matchTagId('tagKeys/123',
     * 'tagValues/456')".
     * </pre>
     *
     * <code>.google.type.Expr condition = 5;</code>
     *
     * @return Whether the condition field is set.
     */
    @java.lang.Override
    public boolean hasCondition() {
      return condition_ != null;
    }
    /**
     *
     *
     * <pre>
     * A condition which determines whether this rule is used
     * in the evaluation of the policy. When set, the `expression` field in
     * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
     * or "&amp;&amp;" operators. Each subexpression must be of the form
     * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
     * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
     * 'tagValues/value_id')". where key_name and value_name are the resource
     * names for Label Keys and Values. These names are available from the Tag
     * Manager Service. An example expression is:
     * "resource.matchTag('123456789/environment,
     * 'prod')". or "resource.matchTagId('tagKeys/123',
     * 'tagValues/456')".
     * </pre>
     *
     * <code>.google.type.Expr condition = 5;</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public com.google.type.Expr getCondition() {
      return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
    }
    /**
     *
     *
     * <pre>
     * A condition which determines whether this rule is used
     * in the evaluation of the policy. When set, the `expression` field in
     * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
     * or "&amp;&amp;" operators. Each subexpression must be of the form
     * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
     * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
     * 'tagValues/value_id')". where key_name and value_name are the resource
     * names for Label Keys and Values. These names are available from the Tag
     * Manager Service. An example expression is:
     * "resource.matchTag('123456789/environment,
     * 'prod')". or "resource.matchTagId('tagKeys/123',
     * 'tagValues/456')".
     * </pre>
     *
     * <code>.google.type.Expr condition = 5;</code>
     */
    @java.lang.Override
    public com.google.type.ExprOrBuilder getConditionOrBuilder() {
      return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (kindCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_);
      }
      if (kindCase_ == 2) {
        output.writeBool(2, (boolean) ((java.lang.Boolean) kind_));
      }
      if (kindCase_ == 3) {
        output.writeBool(3, (boolean) ((java.lang.Boolean) kind_));
      }
      if (kindCase_ == 4) {
        output.writeBool(4, (boolean) ((java.lang.Boolean) kind_));
      }
      if (condition_ != null) {
        output.writeMessage(5, getCondition());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (kindCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_);
      }
      if (kindCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                2, (boolean) ((java.lang.Boolean) kind_));
      }
      if (kindCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                3, (boolean) ((java.lang.Boolean) kind_));
      }
      if (kindCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                4, (boolean) ((java.lang.Boolean) kind_));
      }
      if (condition_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCondition());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule)) {
        return super.equals(obj);
      }
      com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule other =
          (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule) obj;

      if (hasCondition() != other.hasCondition()) return false;
      if (hasCondition()) {
        if (!getCondition().equals(other.getCondition())) return false;
      }
      if (!getKindCase().equals(other.getKindCase())) return false;
      switch (kindCase_) {
        case 1:
          if (!getValues().equals(other.getValues())) return false;
          break;
        case 2:
          if (getAllowAll() != other.getAllowAll()) return false;
          break;
        case 3:
          if (getDenyAll() != other.getDenyAll()) return false;
          break;
        case 4:
          if (getEnforce() != other.getEnforce()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCondition()) {
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
      }
      switch (kindCase_) {
        case 1:
          hash = (37 * hash) + VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getValues().hashCode();
          break;
        case 2:
          hash = (37 * hash) + ALLOW_ALL_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowAll());
          break;
        case 3:
          hash = (37 * hash) + DENY_ALL_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDenyAll());
          break;
        case 4:
          hash = (37 * hash) + ENFORCE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnforce());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A rule used to express this policy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.orgpolicy.v2.PolicySpec.PolicyRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule)
        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.orgpolicy.v2.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.orgpolicy.v2.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.class,
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder.class);
      }

      // Construct using com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (valuesBuilder_ != null) {
          valuesBuilder_.clear();
        }
        condition_ = null;
        if (conditionBuilder_ != null) {
          conditionBuilder_.dispose();
          conditionBuilder_ = null;
        }
        kindCase_ = 0;
        kind_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.orgpolicy.v2.OrgPolicyProto
            .internal_static_google_cloud_orgpolicy_v2_PolicySpec_PolicyRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule getDefaultInstanceForType() {
        return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule build() {
        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule buildPartial() {
        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule result =
            new com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
        }
      }

      private void buildPartialOneofs(com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule result) {
        result.kindCase_ = kindCase_;
        result.kind_ = this.kind_;
        if (kindCase_ == 1 && valuesBuilder_ != null) {
          result.kind_ = valuesBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule) {
          return mergeFrom((com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule other) {
        if (other == com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.getDefaultInstance())
          return this;
        if (other.hasCondition()) {
          mergeCondition(other.getCondition());
        }
        switch (other.getKindCase()) {
          case VALUES:
            {
              mergeValues(other.getValues());
              break;
            }
          case ALLOW_ALL:
            {
              setAllowAll(other.getAllowAll());
              break;
            }
          case DENY_ALL:
            {
              setDenyAll(other.getDenyAll());
              break;
            }
          case ENFORCE:
            {
              setEnforce(other.getEnforce());
              break;
            }
          case KIND_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getValuesFieldBuilder().getBuilder(), extensionRegistry);
                  kindCase_ = 1;
                  break;
                } // case 10
              case 16:
                {
                  kind_ = input.readBool();
                  kindCase_ = 2;
                  break;
                } // case 16
              case 24:
                {
                  kind_ = input.readBool();
                  kindCase_ = 3;
                  break;
                } // case 24
              case 32:
                {
                  kind_ = input.readBool();
                  kindCase_ = 4;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int kindCase_ = 0;
      private java.lang.Object kind_;

      public KindCase getKindCase() {
        return KindCase.forNumber(kindCase_);
      }

      public Builder clearKind() {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues,
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder,
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder>
          valuesBuilder_;
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       *
       * @return Whether the values field is set.
       */
      @java.lang.Override
      public boolean hasValues() {
        return kindCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       *
       * @return The values.
       */
      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues getValues() {
        if (valuesBuilder_ == null) {
          if (kindCase_ == 1) {
            return (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_;
          }
          return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
              .getDefaultInstance();
        } else {
          if (kindCase_ == 1) {
            return valuesBuilder_.getMessage();
          }
          return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      public Builder setValues(
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          kind_ = value;
          onChanged();
        } else {
          valuesBuilder_.setMessage(value);
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      public Builder setValues(
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          kind_ = builderForValue.build();
          onChanged();
        } else {
          valuesBuilder_.setMessage(builderForValue.build());
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      public Builder mergeValues(
          com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues value) {
        if (valuesBuilder_ == null) {
          if (kindCase_ == 1
              && kind_
                  != com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
                      .getDefaultInstance()) {
            kind_ =
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.newBuilder(
                        (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            kind_ = value;
          }
          onChanged();
        } else {
          if (kindCase_ == 1) {
            valuesBuilder_.mergeFrom(value);
          } else {
            valuesBuilder_.setMessage(value);
          }
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
          }
        } else {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
          }
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder
          getValuesBuilder() {
        return getValuesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder
          getValuesOrBuilder() {
        if ((kindCase_ == 1) && (valuesBuilder_ != null)) {
          return valuesBuilder_.getMessageOrBuilder();
        } else {
          if (kindCase_ == 1) {
            return (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_;
          }
          return com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * List of values to be used for this PolicyRule. This field can be set
       * only in Policies for list constraints.
       * </pre>
       *
       * <code>.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues values = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues,
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder,
              com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          if (!(kindCase_ == 1)) {
            kind_ =
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues
                    .getDefaultInstance();
          }
          valuesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues,
                  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues.Builder,
                  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValuesOrBuilder>(
                  (com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.StringValues) kind_,
                  getParentForChildren(),
                  isClean());
          kind_ = null;
        }
        kindCase_ = 1;
        onChanged();
        return valuesBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are allowed. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool allow_all = 2;</code>
       *
       * @return Whether the allowAll field is set.
       */
      public boolean hasAllowAll() {
        return kindCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are allowed. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool allow_all = 2;</code>
       *
       * @return The allowAll.
       */
      public boolean getAllowAll() {
        if (kindCase_ == 2) {
          return (java.lang.Boolean) kind_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are allowed. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool allow_all = 2;</code>
       *
       * @param value The allowAll to set.
       * @return This builder for chaining.
       */
      public Builder setAllowAll(boolean value) {

        kindCase_ = 2;
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are allowed. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool allow_all = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowAll() {
        if (kindCase_ == 2) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are denied. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool deny_all = 3;</code>
       *
       * @return Whether the denyAll field is set.
       */
      public boolean hasDenyAll() {
        return kindCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are denied. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool deny_all = 3;</code>
       *
       * @return The denyAll.
       */
      public boolean getDenyAll() {
        if (kindCase_ == 3) {
          return (java.lang.Boolean) kind_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are denied. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool deny_all = 3;</code>
       *
       * @param value The denyAll to set.
       * @return This builder for chaining.
       */
      public Builder setDenyAll(boolean value) {

        kindCase_ = 3;
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Setting this to true means that all values are denied. This field can
       * be set only in Policies for list constraints.
       * </pre>
       *
       * <code>bool deny_all = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDenyAll() {
        if (kindCase_ == 3) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       * This field can be set only in Policies for boolean constraints.
       * </pre>
       *
       * <code>bool enforce = 4;</code>
       *
       * @return Whether the enforce field is set.
       */
      public boolean hasEnforce() {
        return kindCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       * This field can be set only in Policies for boolean constraints.
       * </pre>
       *
       * <code>bool enforce = 4;</code>
       *
       * @return The enforce.
       */
      public boolean getEnforce() {
        if (kindCase_ == 4) {
          return (java.lang.Boolean) kind_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       * This field can be set only in Policies for boolean constraints.
       * </pre>
       *
       * <code>bool enforce = 4;</code>
       *
       * @param value The enforce to set.
       * @return This builder for chaining.
       */
      public Builder setEnforce(boolean value) {

        kindCase_ = 4;
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `true`, then the `Policy` is enforced. If `false`, then any
       * configuration is acceptable.
       * This field can be set only in Policies for boolean constraints.
       * </pre>
       *
       * <code>bool enforce = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnforce() {
        if (kindCase_ == 4) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.type.Expr condition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
          conditionBuilder_;
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       *
       * @return Whether the condition field is set.
       */
      public boolean hasCondition() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       *
       * @return The condition.
       */
      public com.google.type.Expr getCondition() {
        if (conditionBuilder_ == null) {
          return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
        } else {
          return conditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      public Builder setCondition(com.google.type.Expr value) {
        if (conditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
        } else {
          conditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      public Builder setCondition(com.google.type.Expr.Builder builderForValue) {
        if (conditionBuilder_ == null) {
          condition_ = builderForValue.build();
        } else {
          conditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      public Builder mergeCondition(com.google.type.Expr value) {
        if (conditionBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && condition_ != null
              && condition_ != com.google.type.Expr.getDefaultInstance()) {
            getConditionBuilder().mergeFrom(value);
          } else {
            condition_ = value;
          }
        } else {
          conditionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      public Builder clearCondition() {
        bitField0_ = (bitField0_ & ~0x00000010);
        condition_ = null;
        if (conditionBuilder_ != null) {
          conditionBuilder_.dispose();
          conditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      public com.google.type.Expr.Builder getConditionBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      public com.google.type.ExprOrBuilder getConditionOrBuilder() {
        if (conditionBuilder_ != null) {
          return conditionBuilder_.getMessageOrBuilder();
        } else {
          return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
        }
      }
      /**
       *
       *
       * <pre>
       * A condition which determines whether this rule is used
       * in the evaluation of the policy. When set, the `expression` field in
       * the `Expr' must include from 1 to 10 subexpressions, joined by the "||"
       * or "&amp;&amp;" operators. Each subexpression must be of the form
       * "resource.matchTag('&lt;ORG_ID&gt;/tag_key_short_name,
       * 'tag_value_short_name')". or "resource.matchTagId('tagKeys/key_id',
       * 'tagValues/value_id')". where key_name and value_name are the resource
       * names for Label Keys and Values. These names are available from the Tag
       * Manager Service. An example expression is:
       * "resource.matchTag('123456789/environment,
       * 'prod')". or "resource.matchTagId('tagKeys/123',
       * 'tagValues/456')".
       * </pre>
       *
       * <code>.google.type.Expr condition = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
          getConditionFieldBuilder() {
        if (conditionBuilder_ == null) {
          conditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Expr,
                  com.google.type.Expr.Builder,
                  com.google.type.ExprOrBuilder>(getCondition(), getParentForChildren(), isClean());
          condition_ = null;
        }
        return conditionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.PolicySpec.PolicyRule)
    private static final com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule();
    }

    public static com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PolicyRule> PARSER =
        new com.google.protobuf.AbstractParser<PolicyRule>() {
          @java.lang.Override
          public PolicyRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PolicyRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PolicyRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * An opaque tag indicating the current version of the `Policy`, used for
   * concurrency control.
   *
   * This field is ignored if used in a `CreatePolicy` request.
   *
   * When the `Policy` is returned from either a `GetPolicy` or a
   * `ListPolicies` request, this `etag` indicates the version of the
   * current `Policy` to use when executing a read-modify-write loop.
   *
   * When the `Policy` is returned from a `GetEffectivePolicy` request, the
   * `etag` will be unset.
   * </pre>
   *
   * <code>string etag = 1;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An opaque tag indicating the current version of the `Policy`, used for
   * concurrency control.
   *
   * This field is ignored if used in a `CreatePolicy` request.
   *
   * When the `Policy` is returned from either a `GetPolicy` or a
   * `ListPolicies` request, this `etag` indicates the version of the
   * current `Policy` to use when executing a read-modify-write loop.
   *
   * When the `Policy` is returned from a `GetEffectivePolicy` request, the
   * `etag` will be unset.
   * </pre>
   *
   * <code>string etag = 1;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time stamp this was previously updated. This
   * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
   * made for that `Policy`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time stamp this was previously updated. This
   * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
   * made for that `Policy`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time stamp this was previously updated. This
   * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
   * made for that `Policy`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int RULES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule> rules_;
  /**
   *
   *
   * <pre>
   * Up to 10 PolicyRules are allowed.
   *
   * In Policies for boolean constraints, the following requirements apply:
   *   - There must be one and only one PolicyRule where condition is unset.
   *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
   *     of the PolicyRule without a condition.
   *   - During policy evaluation, PolicyRules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Up to 10 PolicyRules are allowed.
   *
   * In Policies for boolean constraints, the following requirements apply:
   *   - There must be one and only one PolicyRule where condition is unset.
   *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
   *     of the PolicyRule without a condition.
   *   - During policy evaluation, PolicyRules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Up to 10 PolicyRules are allowed.
   *
   * In Policies for boolean constraints, the following requirements apply:
   *   - There must be one and only one PolicyRule where condition is unset.
   *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
   *     of the PolicyRule without a condition.
   *   - During policy evaluation, PolicyRules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * Up to 10 PolicyRules are allowed.
   *
   * In Policies for boolean constraints, the following requirements apply:
   *   - There must be one and only one PolicyRule where condition is unset.
   *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
   *     of the PolicyRule without a condition.
   *   - During policy evaluation, PolicyRules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Up to 10 PolicyRules are allowed.
   *
   * In Policies for boolean constraints, the following requirements apply:
   *   - There must be one and only one PolicyRule where condition is unset.
   *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
   *     of the PolicyRule without a condition.
   *   - During policy evaluation, PolicyRules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  public static final int INHERIT_FROM_PARENT_FIELD_NUMBER = 4;
  private boolean inheritFromParent_ = false;
  /**
   *
   *
   * <pre>
   * Determines the inheritance behavior for this `Policy`.
   *
   * If `inherit_from_parent` is true, PolicyRules set higher up in the
   * hierarchy (up to the closest root) are inherited and present in the
   * effective policy. If it is false, then no rules are inherited, and this
   * Policy becomes the new root for evaluation.
   * This field can be set only for Policies which configure list constraints.
   * </pre>
   *
   * <code>bool inherit_from_parent = 4;</code>
   *
   * @return The inheritFromParent.
   */
  @java.lang.Override
  public boolean getInheritFromParent() {
    return inheritFromParent_;
  }

  public static final int RESET_FIELD_NUMBER = 5;
  private boolean reset_ = false;
  /**
   *
   *
   * <pre>
   * Ignores policies set above this resource and restores the
   * `constraint_default` enforcement behavior of the specific `Constraint` at
   * this resource.
   * This field can be set in policies for either list or boolean
   * constraints. If set, `rules` must be empty and `inherit_from_parent`
   * must be set to false.
   * </pre>
   *
   * <code>bool reset = 5;</code>
   *
   * @return The reset.
   */
  @java.lang.Override
  public boolean getReset() {
    return reset_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, etag_);
    }
    if (updateTime_ != null) {
      output.writeMessage(2, getUpdateTime());
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(3, rules_.get(i));
    }
    if (inheritFromParent_ != false) {
      output.writeBool(4, inheritFromParent_);
    }
    if (reset_ != false) {
      output.writeBool(5, reset_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, etag_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateTime());
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, rules_.get(i));
    }
    if (inheritFromParent_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, inheritFromParent_);
    }
    if (reset_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, reset_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orgpolicy.v2.PolicySpec)) {
      return super.equals(obj);
    }
    com.google.cloud.orgpolicy.v2.PolicySpec other = (com.google.cloud.orgpolicy.v2.PolicySpec) obj;

    if (!getEtag().equals(other.getEtag())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (getInheritFromParent() != other.getInheritFromParent()) return false;
    if (getReset() != other.getReset()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (37 * hash) + INHERIT_FROM_PARENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInheritFromParent());
    hash = (37 * hash) + RESET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReset());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.orgpolicy.v2.PolicySpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a Cloud Organization `PolicySpec` which is used to specify
   * `Constraints` for configurations of Cloud Platform resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.PolicySpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.PolicySpec)
      com.google.cloud.orgpolicy.v2.PolicySpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_PolicySpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_PolicySpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.PolicySpec.class,
              com.google.cloud.orgpolicy.v2.PolicySpec.Builder.class);
    }

    // Construct using com.google.cloud.orgpolicy.v2.PolicySpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      etag_ = "";
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      inheritFromParent_ = false;
      reset_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orgpolicy.v2.OrgPolicyProto
          .internal_static_google_cloud_orgpolicy_v2_PolicySpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.PolicySpec getDefaultInstanceForType() {
      return com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.PolicySpec build() {
      com.google.cloud.orgpolicy.v2.PolicySpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.PolicySpec buildPartial() {
      com.google.cloud.orgpolicy.v2.PolicySpec result =
          new com.google.cloud.orgpolicy.v2.PolicySpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.orgpolicy.v2.PolicySpec result) {
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.orgpolicy.v2.PolicySpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.inheritFromParent_ = inheritFromParent_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.reset_ = reset_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orgpolicy.v2.PolicySpec) {
        return mergeFrom((com.google.cloud.orgpolicy.v2.PolicySpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orgpolicy.v2.PolicySpec other) {
      if (other == com.google.cloud.orgpolicy.v2.PolicySpec.getDefaultInstance()) return this;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000004);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (other.getInheritFromParent() != false) {
        setInheritFromParent(other.getInheritFromParent());
      }
      if (other.getReset() != false) {
        setReset(other.getReset());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule m =
                    input.readMessage(
                        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.parser(),
                        extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                inheritFromParent_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                reset_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * This field is ignored if used in a `CreatePolicy` request.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListPolicies` request, this `etag` indicates the version of the
     * current `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     * </pre>
     *
     * <code>string etag = 1;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * This field is ignored if used in a `CreatePolicy` request.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListPolicies` request, this `etag` indicates the version of the
     * current `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     * </pre>
     *
     * <code>string etag = 1;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * This field is ignored if used in a `CreatePolicy` request.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListPolicies` request, this `etag` indicates the version of the
     * current `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     * </pre>
     *
     * <code>string etag = 1;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * This field is ignored if used in a `CreatePolicy` request.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListPolicies` request, this `etag` indicates the version of the
     * current `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     * </pre>
     *
     * <code>string etag = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque tag indicating the current version of the `Policy`, used for
     * concurrency control.
     *
     * This field is ignored if used in a `CreatePolicy` request.
     *
     * When the `Policy` is returned from either a `GetPolicy` or a
     * `ListPolicies` request, this `etag` indicates the version of the
     * current `Policy` to use when executing a read-modify-write loop.
     *
     * When the `Policy` is returned from a `GetEffectivePolicy` request, the
     * `etag` will be unset.
     * </pre>
     *
     * <code>string etag = 1;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time stamp this was previously updated. This
     * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
     * made for that `Policy`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.util.List<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        rules_ =
            new java.util.ArrayList<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule>(rules_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule,
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder,
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public java.util.List<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder setRules(int index, com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder setRules(
        int index, com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder addRules(com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder addRules(int index, com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder addRules(
        com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder addRules(
        int index, com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder getRulesOrBuilder(
        int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Up to 10 PolicyRules are allowed.
     *
     * In Policies for boolean constraints, the following requirements apply:
     *   - There must be one and only one PolicyRule where condition is unset.
     *   - BooleanPolicyRules with conditions must set `enforced` to the opposite
     *     of the PolicyRule without a condition.
     *   - During policy evaluation, PolicyRules with conditions that are
     *     true for a target resource take precedence.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
     */
    public java.util.List<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder>
        getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule,
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder,
            com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule,
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule.Builder,
                com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private boolean inheritFromParent_;
    /**
     *
     *
     * <pre>
     * Determines the inheritance behavior for this `Policy`.
     *
     * If `inherit_from_parent` is true, PolicyRules set higher up in the
     * hierarchy (up to the closest root) are inherited and present in the
     * effective policy. If it is false, then no rules are inherited, and this
     * Policy becomes the new root for evaluation.
     * This field can be set only for Policies which configure list constraints.
     * </pre>
     *
     * <code>bool inherit_from_parent = 4;</code>
     *
     * @return The inheritFromParent.
     */
    @java.lang.Override
    public boolean getInheritFromParent() {
      return inheritFromParent_;
    }
    /**
     *
     *
     * <pre>
     * Determines the inheritance behavior for this `Policy`.
     *
     * If `inherit_from_parent` is true, PolicyRules set higher up in the
     * hierarchy (up to the closest root) are inherited and present in the
     * effective policy. If it is false, then no rules are inherited, and this
     * Policy becomes the new root for evaluation.
     * This field can be set only for Policies which configure list constraints.
     * </pre>
     *
     * <code>bool inherit_from_parent = 4;</code>
     *
     * @param value The inheritFromParent to set.
     * @return This builder for chaining.
     */
    public Builder setInheritFromParent(boolean value) {

      inheritFromParent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines the inheritance behavior for this `Policy`.
     *
     * If `inherit_from_parent` is true, PolicyRules set higher up in the
     * hierarchy (up to the closest root) are inherited and present in the
     * effective policy. If it is false, then no rules are inherited, and this
     * Policy becomes the new root for evaluation.
     * This field can be set only for Policies which configure list constraints.
     * </pre>
     *
     * <code>bool inherit_from_parent = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInheritFromParent() {
      bitField0_ = (bitField0_ & ~0x00000008);
      inheritFromParent_ = false;
      onChanged();
      return this;
    }

    private boolean reset_;
    /**
     *
     *
     * <pre>
     * Ignores policies set above this resource and restores the
     * `constraint_default` enforcement behavior of the specific `Constraint` at
     * this resource.
     * This field can be set in policies for either list or boolean
     * constraints. If set, `rules` must be empty and `inherit_from_parent`
     * must be set to false.
     * </pre>
     *
     * <code>bool reset = 5;</code>
     *
     * @return The reset.
     */
    @java.lang.Override
    public boolean getReset() {
      return reset_;
    }
    /**
     *
     *
     * <pre>
     * Ignores policies set above this resource and restores the
     * `constraint_default` enforcement behavior of the specific `Constraint` at
     * this resource.
     * This field can be set in policies for either list or boolean
     * constraints. If set, `rules` must be empty and `inherit_from_parent`
     * must be set to false.
     * </pre>
     *
     * <code>bool reset = 5;</code>
     *
     * @param value The reset to set.
     * @return This builder for chaining.
     */
    public Builder setReset(boolean value) {

      reset_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ignores policies set above this resource and restores the
     * `constraint_default` enforcement behavior of the specific `Constraint` at
     * this resource.
     * This field can be set in policies for either list or boolean
     * constraints. If set, `rules` must be empty and `inherit_from_parent`
     * must be set to false.
     * </pre>
     *
     * <code>bool reset = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReset() {
      bitField0_ = (bitField0_ & ~0x00000010);
      reset_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.PolicySpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.PolicySpec)
  private static final com.google.cloud.orgpolicy.v2.PolicySpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.PolicySpec();
  }

  public static com.google.cloud.orgpolicy.v2.PolicySpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PolicySpec> PARSER =
      new com.google.protobuf.AbstractParser<PolicySpec>() {
        @java.lang.Override
        public PolicySpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PolicySpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PolicySpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.PolicySpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
