/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v2/constraint.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.orgpolicy.v2;

/**
 *
 *
 * <pre>
 * A custom constraint defined by customers which can *only* be applied to the
 * given resource types and organization.
 *
 * By creating a custom constraint, customers can apply policies of this
 * custom constraint. *Creating a custom constraint itself does NOT apply any
 * policy enforcement*.
 * </pre>
 *
 * Protobuf type {@code google.cloud.orgpolicy.v2.CustomConstraint}
 */
public final class CustomConstraint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.orgpolicy.v2.CustomConstraint)
    CustomConstraintOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomConstraint.newBuilder() to construct.
  private CustomConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomConstraint() {
    name_ = "";
    resourceTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    methodTypes_ = java.util.Collections.emptyList();
    condition_ = "";
    actionType_ = 0;
    displayName_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomConstraint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.orgpolicy.v2.ConstraintProto
        .internal_static_google_cloud_orgpolicy_v2_CustomConstraint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.orgpolicy.v2.ConstraintProto
        .internal_static_google_cloud_orgpolicy_v2_CustomConstraint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.orgpolicy.v2.CustomConstraint.class,
            com.google.cloud.orgpolicy.v2.CustomConstraint.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The operation for which this constraint will be applied. To apply this
   * constraint only when creating new VMs, the `method_types` should be
   * `CREATE` only. To apply this constraint when creating or deleting
   * VMs, the `method_types` should be `CREATE` and `DELETE`.
   *
   * `UPDATE` only custom constraints are not supported. Use `CREATE` or
   * `CREATE, UPDATE`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.orgpolicy.v2.CustomConstraint.MethodType}
   */
  public enum MethodType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Results in an error.
     * </pre>
     *
     * <code>METHOD_TYPE_UNSPECIFIED = 0;</code>
     */
    METHOD_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Constraint applied when creating the resource.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    CREATE(1),
    /**
     *
     *
     * <pre>
     * Constraint applied when updating the resource.
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    UPDATE(2),
    /**
     *
     *
     * <pre>
     * Constraint applied when deleting the resource.
     * Not supported yet.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    DELETE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Results in an error.
     * </pre>
     *
     * <code>METHOD_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int METHOD_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Constraint applied when creating the resource.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    public static final int CREATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Constraint applied when updating the resource.
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    public static final int UPDATE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Constraint applied when deleting the resource.
     * Not supported yet.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    public static final int DELETE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MethodType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MethodType forNumber(int value) {
      switch (value) {
        case 0:
          return METHOD_TYPE_UNSPECIFIED;
        case 1:
          return CREATE;
        case 2:
          return UPDATE;
        case 3:
          return DELETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MethodType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MethodType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MethodType>() {
          public MethodType findValueByNumber(int number) {
            return MethodType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.CustomConstraint.getDescriptor().getEnumTypes().get(0);
    }

    private static final MethodType[] VALUES = values();

    public static MethodType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MethodType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orgpolicy.v2.CustomConstraint.MethodType)
  }

  /**
   *
   *
   * <pre>
   * Allow or deny type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.orgpolicy.v2.CustomConstraint.ActionType}
   */
  public enum ActionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Results in an error.
     * </pre>
     *
     * <code>ACTION_TYPE_UNSPECIFIED = 0;</code>
     */
    ACTION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Allowed action type.
     * </pre>
     *
     * <code>ALLOW = 1;</code>
     */
    ALLOW(1),
    /**
     *
     *
     * <pre>
     * Deny action type.
     * </pre>
     *
     * <code>DENY = 2;</code>
     */
    DENY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Results in an error.
     * </pre>
     *
     * <code>ACTION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ACTION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allowed action type.
     * </pre>
     *
     * <code>ALLOW = 1;</code>
     */
    public static final int ALLOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Deny action type.
     * </pre>
     *
     * <code>DENY = 2;</code>
     */
    public static final int DENY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ActionType forNumber(int value) {
      switch (value) {
        case 0:
          return ACTION_TYPE_UNSPECIFIED;
        case 1:
          return ALLOW;
        case 2:
          return DENY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ActionType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ActionType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ActionType>() {
          public ActionType findValueByNumber(int number) {
            return ActionType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.CustomConstraint.getDescriptor().getEnumTypes().get(1);
    }

    private static final ActionType[] VALUES = values();

    public static ActionType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ActionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.orgpolicy.v2.CustomConstraint.ActionType)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Name of the constraint. This is unique within the organization.
   * Format of the name should be
   *
   * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
   *
   * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
   *
   * The max length is 70 characters and the minimum length is 1. Note that the
   * prefix `organizations/{organization_id}/customConstraints/` is not counted.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Name of the constraint. This is unique within the organization.
   * Format of the name should be
   *
   * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
   *
   * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
   *
   * The max length is 70 characters and the minimum length is 1. Note that the
   * prefix `organizations/{organization_id}/customConstraints/` is not counted.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_TYPES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList resourceTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Immutable. The resource instance type on which this policy applies. Format
   * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
   *
   *  * `compute.googleapis.com/Instance`.
   * </pre>
   *
   * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the resourceTypes.
   */
  public com.google.protobuf.ProtocolStringList getResourceTypesList() {
    return resourceTypes_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource instance type on which this policy applies. Format
   * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
   *
   *  * `compute.googleapis.com/Instance`.
   * </pre>
   *
   * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of resourceTypes.
   */
  public int getResourceTypesCount() {
    return resourceTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource instance type on which this policy applies. Format
   * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
   *
   *  * `compute.googleapis.com/Instance`.
   * </pre>
   *
   * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The resourceTypes at the given index.
   */
  public java.lang.String getResourceTypes(int index) {
    return resourceTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource instance type on which this policy applies. Format
   * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
   *
   *  * `compute.googleapis.com/Instance`.
   * </pre>
   *
   * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourceTypes at the given index.
   */
  public com.google.protobuf.ByteString getResourceTypesBytes(int index) {
    return resourceTypes_.getByteString(index);
  }

  public static final int METHOD_TYPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> methodTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>
      methodTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>() {
            public com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType convert(
                java.lang.Integer from) {
              com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType result =
                  com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType.forNumber(from);
              return result == null
                  ? com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * All the operations being applied for this constraint.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
   *
   * @return A list containing the methodTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>
      getMethodTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>(
        methodTypes_, methodTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * All the operations being applied for this constraint.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
   *
   * @return The count of methodTypes.
   */
  @java.lang.Override
  public int getMethodTypesCount() {
    return methodTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * All the operations being applied for this constraint.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The methodTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType getMethodTypes(int index) {
    return methodTypes_converter_.convert(methodTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * All the operations being applied for this constraint.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
   *
   * @return A list containing the enum numeric values on the wire for methodTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getMethodTypesValueList() {
    return methodTypes_;
  }
  /**
   *
   *
   * <pre>
   * All the operations being applied for this constraint.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of methodTypes at the given index.
   */
  @java.lang.Override
  public int getMethodTypesValue(int index) {
    return methodTypes_.get(index);
  }

  private int methodTypesMemoizedSerializedSize;

  public static final int CONDITION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object condition_ = "";
  /**
   *
   *
   * <pre>
   * Org policy condition/expression. For example:
   * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
   * `resource.management.auto_upgrade == true`
   *
   * The max length of the condition is 1000 characters.
   * </pre>
   *
   * <code>string condition = 4;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public java.lang.String getCondition() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      condition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Org policy condition/expression. For example:
   * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
   * `resource.management.auto_upgrade == true`
   *
   * The max length of the condition is 1000 characters.
   * </pre>
   *
   * <code>string condition = 4;</code>
   *
   * @return The bytes for condition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConditionBytes() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      condition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTION_TYPE_FIELD_NUMBER = 5;
  private int actionType_ = 0;
  /**
   *
   *
   * <pre>
   * Allow or deny type.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
   *
   * @return The enum numeric value on the wire for actionType.
   */
  @java.lang.Override
  public int getActionTypeValue() {
    return actionType_;
  }
  /**
   *
   *
   * <pre>
   * Allow or deny type.
   * </pre>
   *
   * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
   *
   * @return The actionType.
   */
  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType getActionType() {
    com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType result =
        com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType.forNumber(actionType_);
    return result == null
        ? com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * One line display name for the UI.
   * The max length of the display_name is 200 characters.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One line display name for the UI.
   * The max length of the display_name is 200 characters.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Detailed information about this custom policy constraint.
   * The max length of the description is 2000 characters.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Detailed information about this custom policy constraint.
   * The max length of the description is 2000 characters.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last time this custom constraint was updated. This
   * represents the last time that the `CreateCustomConstraint` or
   * `UpdateCustomConstraint` RPC was called
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this custom constraint was updated. This
   * represents the last time that the `CreateCustomConstraint` or
   * `UpdateCustomConstraint` RPC was called
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this custom constraint was updated. This
   * represents the last time that the `CreateCustomConstraint` or
   * `UpdateCustomConstraint` RPC was called
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < resourceTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceTypes_.getRaw(i));
    }
    if (getMethodTypesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(methodTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < methodTypes_.size(); i++) {
      output.writeEnumNoTag(methodTypes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, condition_);
    }
    if (actionType_
        != com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType.ACTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, actionType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourceTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourceTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourceTypesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < methodTypes_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(methodTypes_.get(i));
      }
      size += dataSize;
      if (!getMethodTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      methodTypesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, condition_);
    }
    if (actionType_
        != com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType.ACTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, actionType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.orgpolicy.v2.CustomConstraint)) {
      return super.equals(obj);
    }
    com.google.cloud.orgpolicy.v2.CustomConstraint other =
        (com.google.cloud.orgpolicy.v2.CustomConstraint) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getResourceTypesList().equals(other.getResourceTypesList())) return false;
    if (!methodTypes_.equals(other.methodTypes_)) return false;
    if (!getCondition().equals(other.getCondition())) return false;
    if (actionType_ != other.actionType_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getResourceTypesCount() > 0) {
      hash = (37 * hash) + RESOURCE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getResourceTypesList().hashCode();
    }
    if (getMethodTypesCount() > 0) {
      hash = (37 * hash) + METHOD_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + methodTypes_.hashCode();
    }
    hash = (37 * hash) + CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getCondition().hashCode();
    hash = (37 * hash) + ACTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + actionType_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.orgpolicy.v2.CustomConstraint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A custom constraint defined by customers which can *only* be applied to the
   * given resource types and organization.
   *
   * By creating a custom constraint, customers can apply policies of this
   * custom constraint. *Creating a custom constraint itself does NOT apply any
   * policy enforcement*.
   * </pre>
   *
   * Protobuf type {@code google.cloud.orgpolicy.v2.CustomConstraint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.orgpolicy.v2.CustomConstraint)
      com.google.cloud.orgpolicy.v2.CustomConstraintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_CustomConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_CustomConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.orgpolicy.v2.CustomConstraint.class,
              com.google.cloud.orgpolicy.v2.CustomConstraint.Builder.class);
    }

    // Construct using com.google.cloud.orgpolicy.v2.CustomConstraint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      resourceTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      methodTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      condition_ = "";
      actionType_ = 0;
      displayName_ = "";
      description_ = "";
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.orgpolicy.v2.ConstraintProto
          .internal_static_google_cloud_orgpolicy_v2_CustomConstraint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.CustomConstraint getDefaultInstanceForType() {
      return com.google.cloud.orgpolicy.v2.CustomConstraint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.CustomConstraint build() {
      com.google.cloud.orgpolicy.v2.CustomConstraint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.CustomConstraint buildPartial() {
      com.google.cloud.orgpolicy.v2.CustomConstraint result =
          new com.google.cloud.orgpolicy.v2.CustomConstraint(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.orgpolicy.v2.CustomConstraint result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        methodTypes_ = java.util.Collections.unmodifiableList(methodTypes_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.methodTypes_ = methodTypes_;
    }

    private void buildPartial0(com.google.cloud.orgpolicy.v2.CustomConstraint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        resourceTypes_.makeImmutable();
        result.resourceTypes_ = resourceTypes_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.condition_ = condition_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.actionType_ = actionType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.orgpolicy.v2.CustomConstraint) {
        return mergeFrom((com.google.cloud.orgpolicy.v2.CustomConstraint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.orgpolicy.v2.CustomConstraint other) {
      if (other == com.google.cloud.orgpolicy.v2.CustomConstraint.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.resourceTypes_.isEmpty()) {
        if (resourceTypes_.isEmpty()) {
          resourceTypes_ = other.resourceTypes_;
          bitField0_ |= 0x00000002;
        } else {
          ensureResourceTypesIsMutable();
          resourceTypes_.addAll(other.resourceTypes_);
        }
        onChanged();
      }
      if (!other.methodTypes_.isEmpty()) {
        if (methodTypes_.isEmpty()) {
          methodTypes_ = other.methodTypes_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureMethodTypesIsMutable();
          methodTypes_.addAll(other.methodTypes_);
        }
        onChanged();
      }
      if (!other.getCondition().isEmpty()) {
        condition_ = other.condition_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.actionType_ != 0) {
        setActionTypeValue(other.getActionTypeValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourceTypesIsMutable();
                resourceTypes_.add(s);
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureMethodTypesIsMutable();
                methodTypes_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureMethodTypesIsMutable();
                  methodTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 34:
              {
                condition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                actionType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     *
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     *
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     *
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     *
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     *
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     *
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     *
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     *
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     *
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     *
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     *
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     *
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the constraint. This is unique within the organization.
     * Format of the name should be
     *
     * * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
     *
     * Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
     *
     * The max length is 70 characters and the minimum length is 1. Note that the
     * prefix `organizations/{organization_id}/customConstraints/` is not counted.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList resourceTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResourceTypesIsMutable() {
      if (!resourceTypes_.isModifiable()) {
        resourceTypes_ = new com.google.protobuf.LazyStringArrayList(resourceTypes_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the resourceTypes.
     */
    public com.google.protobuf.ProtocolStringList getResourceTypesList() {
      resourceTypes_.makeImmutable();
      return resourceTypes_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of resourceTypes.
     */
    public int getResourceTypesCount() {
      return resourceTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The resourceTypes at the given index.
     */
    public java.lang.String getResourceTypes(int index) {
      return resourceTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceTypes at the given index.
     */
    public com.google.protobuf.ByteString getResourceTypesBytes(int index) {
      return resourceTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index to set the value at.
     * @param value The resourceTypes to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourceTypesIsMutable();
      resourceTypes_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The resourceTypes to add.
     * @return This builder for chaining.
     */
    public Builder addResourceTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourceTypesIsMutable();
      resourceTypes_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param values The resourceTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourceTypes(java.lang.Iterable<java.lang.String> values) {
      ensureResourceTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceTypes_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceTypes() {
      resourceTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource instance type on which this policy applies. Format
     * will be of the form : `&lt;canonical service name&gt;/&lt;type&gt;` Example:
     *
     *  * `compute.googleapis.com/Instance`.
     * </pre>
     *
     * <code>repeated string resource_types = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes of the resourceTypes to add.
     * @return This builder for chaining.
     */
    public Builder addResourceTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourceTypesIsMutable();
      resourceTypes_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> methodTypes_ = java.util.Collections.emptyList();

    private void ensureMethodTypesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        methodTypes_ = new java.util.ArrayList<java.lang.Integer>(methodTypes_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @return A list containing the methodTypes.
     */
    public java.util.List<com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>
        getMethodTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>(
          methodTypes_, methodTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @return The count of methodTypes.
     */
    public int getMethodTypesCount() {
      return methodTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The methodTypes at the given index.
     */
    public com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType getMethodTypes(int index) {
      return methodTypes_converter_.convert(methodTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The methodTypes to set.
     * @return This builder for chaining.
     */
    public Builder setMethodTypes(
        int index, com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMethodTypesIsMutable();
      methodTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param value The methodTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMethodTypes(com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMethodTypesIsMutable();
      methodTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param values The methodTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllMethodTypes(
        java.lang.Iterable<? extends com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType>
            values) {
      ensureMethodTypesIsMutable();
      for (com.google.cloud.orgpolicy.v2.CustomConstraint.MethodType value : values) {
        methodTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMethodTypes() {
      methodTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for methodTypes.
     */
    public java.util.List<java.lang.Integer> getMethodTypesValueList() {
      return java.util.Collections.unmodifiableList(methodTypes_);
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of methodTypes at the given index.
     */
    public int getMethodTypesValue(int index) {
      return methodTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for methodTypes to set.
     * @return This builder for chaining.
     */
    public Builder setMethodTypesValue(int index, int value) {
      ensureMethodTypesIsMutable();
      methodTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for methodTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMethodTypesValue(int value) {
      ensureMethodTypesIsMutable();
      methodTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the operations being applied for this constraint.
     * </pre>
     *
     * <code>repeated .google.cloud.orgpolicy.v2.CustomConstraint.MethodType method_types = 3;
     * </code>
     *
     * @param values The enum numeric values on the wire for methodTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllMethodTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureMethodTypesIsMutable();
      for (int value : values) {
        methodTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * Org policy condition/expression. For example:
     * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
     * `resource.management.auto_upgrade == true`
     *
     * The max length of the condition is 1000 characters.
     * </pre>
     *
     * <code>string condition = 4;</code>
     *
     * @return The condition.
     */
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Org policy condition/expression. For example:
     * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
     * `resource.management.auto_upgrade == true`
     *
     * The max length of the condition is 1000 characters.
     * </pre>
     *
     * <code>string condition = 4;</code>
     *
     * @return The bytes for condition.
     */
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Org policy condition/expression. For example:
     * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
     * `resource.management.auto_upgrade == true`
     *
     * The max length of the condition is 1000 characters.
     * </pre>
     *
     * <code>string condition = 4;</code>
     *
     * @param value The condition to set.
     * @return This builder for chaining.
     */
    public Builder setCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      condition_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Org policy condition/expression. For example:
     * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
     * `resource.management.auto_upgrade == true`
     *
     * The max length of the condition is 1000 characters.
     * </pre>
     *
     * <code>string condition = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCondition() {
      condition_ = getDefaultInstance().getCondition();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Org policy condition/expression. For example:
     * `resource.instanceName.matches("[production|test]_.*_(&#92;d)+")` or,
     * `resource.management.auto_upgrade == true`
     *
     * The max length of the condition is 1000 characters.
     * </pre>
     *
     * <code>string condition = 4;</code>
     *
     * @param value The bytes for condition to set.
     * @return This builder for chaining.
     */
    public Builder setConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      condition_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int actionType_ = 0;
    /**
     *
     *
     * <pre>
     * Allow or deny type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     *
     * @return The enum numeric value on the wire for actionType.
     */
    @java.lang.Override
    public int getActionTypeValue() {
      return actionType_;
    }
    /**
     *
     *
     * <pre>
     * Allow or deny type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     *
     * @param value The enum numeric value on the wire for actionType to set.
     * @return This builder for chaining.
     */
    public Builder setActionTypeValue(int value) {
      actionType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allow or deny type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     *
     * @return The actionType.
     */
    @java.lang.Override
    public com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType getActionType() {
      com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType result =
          com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType.forNumber(actionType_);
      return result == null
          ? com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Allow or deny type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     *
     * @param value The actionType to set.
     * @return This builder for chaining.
     */
    public Builder setActionType(com.google.cloud.orgpolicy.v2.CustomConstraint.ActionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      actionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allow or deny type.
     * </pre>
     *
     * <code>.google.cloud.orgpolicy.v2.CustomConstraint.ActionType action_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActionType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      actionType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One line display name for the UI.
     * The max length of the display_name is 200 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed information about this custom policy constraint.
     * The max length of the description is 2000 characters.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this custom constraint was updated. This
     * represents the last time that the `CreateCustomConstraint` or
     * `UpdateCustomConstraint` RPC was called
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.orgpolicy.v2.CustomConstraint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.orgpolicy.v2.CustomConstraint)
  private static final com.google.cloud.orgpolicy.v2.CustomConstraint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.orgpolicy.v2.CustomConstraint();
  }

  public static com.google.cloud.orgpolicy.v2.CustomConstraint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomConstraint> PARSER =
      new com.google.protobuf.AbstractParser<CustomConstraint>() {
        @java.lang.Override
        public CustomConstraint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomConstraint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomConstraint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.orgpolicy.v2.CustomConstraint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
