/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.orgpolicy.v2;

public interface PolicySpecOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.orgpolicy.v2.PolicySpec)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * An opaque tag indicating the current version of the policySpec, used for
   * concurrency control.
   *
   * This field is ignored if used in a `CreatePolicy` request.
   *
   * When the policy is returned from either a `GetPolicy` or a
   * `ListPolicies` request, this `etag` indicates the version of the
   * current policySpec to use when executing a read-modify-write loop.
   *
   * When the policy is returned from a `GetEffectivePolicy` request, the
   * `etag` will be unset.
   * </pre>
   *
   * <code>string etag = 1;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * An opaque tag indicating the current version of the policySpec, used for
   * concurrency control.
   *
   * This field is ignored if used in a `CreatePolicy` request.
   *
   * When the policy is returned from either a `GetPolicy` or a
   * `ListPolicies` request, this `etag` indicates the version of the
   * current policySpec to use when executing a read-modify-write loop.
   *
   * When the policy is returned from a `GetEffectivePolicy` request, the
   * `etag` will be unset.
   * </pre>
   *
   * <code>string etag = 1;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time stamp this was previously updated. This
   * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
   * made for that policy.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time stamp this was previously updated. This
   * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
   * made for that policy.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time stamp this was previously updated. This
   * represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
   * made for that policy.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * In policies for boolean constraints, the following requirements apply:
   *
   *   - There must be one and only one policy rule where condition is unset.
   *   - Boolean policy rules with conditions must set `enforced` to the
   *     opposite of the policy rule without a condition.
   *   - During policy evaluation, policy rules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  java.util.List<com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule> getRulesList();
  /**
   *
   *
   * <pre>
   * In policies for boolean constraints, the following requirements apply:
   *
   *   - There must be one and only one policy rule where condition is unset.
   *   - Boolean policy rules with conditions must set `enforced` to the
   *     opposite of the policy rule without a condition.
   *   - During policy evaluation, policy rules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRule getRules(int index);
  /**
   *
   *
   * <pre>
   * In policies for boolean constraints, the following requirements apply:
   *
   *   - There must be one and only one policy rule where condition is unset.
   *   - Boolean policy rules with conditions must set `enforced` to the
   *     opposite of the policy rule without a condition.
   *   - During policy evaluation, policy rules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  int getRulesCount();
  /**
   *
   *
   * <pre>
   * In policies for boolean constraints, the following requirements apply:
   *
   *   - There must be one and only one policy rule where condition is unset.
   *   - Boolean policy rules with conditions must set `enforced` to the
   *     opposite of the policy rule without a condition.
   *   - During policy evaluation, policy rules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  java.util.List<? extends com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder>
      getRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * In policies for boolean constraints, the following requirements apply:
   *
   *   - There must be one and only one policy rule where condition is unset.
   *   - Boolean policy rules with conditions must set `enforced` to the
   *     opposite of the policy rule without a condition.
   *   - During policy evaluation, policy rules with conditions that are
   *     true for a target resource take precedence.
   * </pre>
   *
   * <code>repeated .google.cloud.orgpolicy.v2.PolicySpec.PolicyRule rules = 3;</code>
   */
  com.google.cloud.orgpolicy.v2.PolicySpec.PolicyRuleOrBuilder getRulesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Determines the inheritance behavior for this policy.
   *
   * If `inherit_from_parent` is true, policy rules set higher up in the
   * hierarchy (up to the closest root) are inherited and present in the
   * effective policy. If it is false, then no rules are inherited, and this
   * policy becomes the new root for evaluation.
   * This field can be set only for policies which configure list constraints.
   * </pre>
   *
   * <code>bool inherit_from_parent = 4;</code>
   *
   * @return The inheritFromParent.
   */
  boolean getInheritFromParent();

  /**
   *
   *
   * <pre>
   * Ignores policies set above this resource and restores the
   * `constraint_default` enforcement behavior of the specific constraint at
   * this resource.
   * This field can be set in policies for either list or boolean
   * constraints. If set, `rules` must be empty and `inherit_from_parent`
   * must be set to false.
   * </pre>
   *
   * <code>bool reset = 5;</code>
   *
   * @return The reset.
   */
  boolean getReset();
}
