/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1/os_policy_assignment_reports.proto

package com.google.cloud.osconfig.v1;

/**
 *
 *
 * <pre>
 * List the OS policy assignment reports for VM instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest}
 */
public final class ListOSPolicyAssignmentReportsRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest)
    ListOSPolicyAssignmentReportsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListOSPolicyAssignmentReportsRequest.newBuilder() to construct.
  private ListOSPolicyAssignmentReportsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListOSPolicyAssignmentReportsRequest() {
    parent_ = "";
    filter_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListOSPolicyAssignmentReportsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
        .internal_static_google_cloud_osconfig_v1_ListOSPolicyAssignmentReportsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
        .internal_static_google_cloud_osconfig_v1_ListOSPolicyAssignmentReportsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.class,
            com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource name.
   *
   * Format:
   * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
   *
   * For `{project}`, either `project-number` or `project-id` can be provided.
   * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
   * provided. If '-' is provided, the response will include
   * OSPolicyAssignmentReports for all instances in the project/location.
   * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
   * is provided, the response will include OSPolicyAssignmentReports for all
   * OSPolicyAssignments in the project/location.
   * Either {instance} or {assignment} must be `-`.
   *
   * For example:
   * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
   *  returns all reports for the instance
   * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
   *  returns all the reports for the given assignment across all instances.
   * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
   *  returns all the reports for all assignments across all instances.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource name.
   *
   * Format:
   * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
   *
   * For `{project}`, either `project-number` or `project-id` can be provided.
   * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
   * provided. If '-' is provided, the response will include
   * OSPolicyAssignmentReports for all instances in the project/location.
   * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
   * is provided, the response will include OSPolicyAssignmentReports for all
   * OSPolicyAssignments in the project/location.
   * Either {instance} or {assignment} must be `-`.
   *
   * For example:
   * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
   *  returns all reports for the instance
   * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
   *  returns all the reports for the given assignment across all instances.
   * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
   *  returns all the reports for all assignments across all instances.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * The maximum number of results to return.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int FILTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * If provided, this field specifies the criteria that must be met by the
   * `OSPolicyAssignmentReport` API resource that is included in the response.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If provided, this field specifies the criteria that must be met by the
   * `OSPolicyAssignmentReport` API resource that is included in the response.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * A pagination token returned from a previous call to the
   * `ListOSPolicyAssignmentReports` method that indicates where this listing
   * should continue from.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A pagination token returned from a previous call to the
   * `ListOSPolicyAssignmentReports` method that indicates where this listing
   * should continue from.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest other =
        (com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * List the OS policy assignment reports for VM instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest)
      com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_ListOSPolicyAssignmentReportsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_ListOSPolicyAssignmentReportsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.class,
              com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      pageSize_ = 0;
      filter_ = "";
      pageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_ListOSPolicyAssignmentReportsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest build() {
      com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest buildPartial() {
      com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest result =
          new com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageToken_ = pageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest) {
        return mergeFrom((com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest other) {
      if (other
          == com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource name.
     *
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     *
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name.
     *
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     *
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name.
     *
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     *
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name.
     *
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     *
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name.
     *
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
     *
     * For `{project}`, either `project-number` or `project-id` can be provided.
     * For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
     * provided. If '-' is provided, the response will include
     * OSPolicyAssignmentReports for all instances in the project/location.
     * For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
     * is provided, the response will include OSPolicyAssignmentReports for all
     * OSPolicyAssignments in the project/location.
     * Either {instance} or {assignment} must be `-`.
     *
     * For example:
     * `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
     *  returns all reports for the instance
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
     *  returns all the reports for the given assignment across all instances.
     * `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
     *  returns all the reports for all assignments across all instances.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by the
     * `OSPolicyAssignmentReport` API resource that is included in the response.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call to the
     * `ListOSPolicyAssignmentReports` method that indicates where this listing
     * should continue from.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest)
  private static final com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest();
  }

  public static com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListOSPolicyAssignmentReportsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListOSPolicyAssignmentReportsRequest>() {
        @java.lang.Override
        public ListOSPolicyAssignmentReportsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListOSPolicyAssignmentReportsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListOSPolicyAssignmentReportsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1.ListOSPolicyAssignmentReportsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
